/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

static data_1_1_t<float, float> g_atanhf_intel_data[] = {
  { // Entry 0
    -0x1.1ffc000000797af0120046e7dc31d3f5p-20,
    -0x1.1ffcp-20
  },
  { // Entry 1
    0x1.1ffc000000797af0120046e7dc31d3f5p-20,
    0x1.1ffcp-20
  },
  { // Entry 2
    -0x1.5f3287f902075197c786c1cf696101b4p-1,
    -0x1.30d35cp-1
  },
  { // Entry 3
    0x1.5f3287f902075197c786c1cf696101b4p-1,
    0x1.30d35cp-1
  },
  { // Entry 4
    -0x1.8a0ca6ffdb34c70bb4a5b23fb6e19d01p-1,
    -0x1.4b1df6p-1
  },
  { // Entry 5
    0x1.8a0ca6ffdb34c70bb4a5b23fb6e19d01p-1,
    0x1.4b1df6p-1
  },
  { // Entry 6
    -0x1.6d46ff0031931d74cbb9c2cfd9429d8cp-3,
    -0x1.6973e0p-3
  },
  { // Entry 7
    0x1.6d46ff0031931d74cbb9c2cfd9429d8cp-3,
    0x1.6973e0p-3
  },
  { // Entry 8
    -0x1.713f610010deb18ee2e239f1963a1405p-12,
    -0x1.713f60p-12
  },
  { // Entry 9
    0x1.713f610010deb18ee2e239f1963a1405p-12,
    0x1.713f60p-12
  },
  { // Entry 10
    -0x1.7141490014d5f81f903df4950464cda8p-12,
    -0x1.714148p-12
  },
  { // Entry 11
    0x1.7141490014d5f81f903df4950464cda8p-12,
    0x1.714148p-12
  },
  { // Entry 12
    -0x1.714177001535ac6e291f246ad5579b0ep-12,
    -0x1.714176p-12
  },
  { // Entry 13
    0x1.714177001535ac6e291f246ad5579b0ep-12,
    0x1.714176p-12
  },
  { // Entry 14
    -0x1.15963da938a6c10a74aafac840a012a1p0,
    -0x1.96efa2p-1
  },
  { // Entry 15
    0x1.15963da938a6c10a74aafac840a012a1p0,
    0x1.96efa2p-1
  },
  { // Entry 16
    -0x1.17f6e9a62565d644cd0022d91487ef7bp0,
    -0x1.98acaep-1
  },
  { // Entry 17
    0x1.17f6e9a62565d644cd0022d91487ef7bp0,
    0x1.98acaep-1
  },
  { // Entry 18
    -0x1.1ba0f2fffc8e369353caacfa549acbf2p0,
    -0x1.9b4dc0p-1
  },
  { // Entry 19
    0x1.1ba0f2fffc8e369353caacfa549acbf2p0,
    0x1.9b4dc0p-1
  },
  { // Entry 20
    -0x1.2dd9b663e5ae06cd47d4cca1f6139598p0,
    -0x1.a782a6p-1
  },
  { // Entry 21
    0x1.2dd9b663e5ae06cd47d4cca1f6139598p0,
    0x1.a782a6p-1
  },
  { // Entry 22
    -0x1.cd2af1003fb97ed31a696564871fd18ap-4,
    -0x1.cb3a9ap-4
  },
  { // Entry 23
    0x1.cd2af1003fb97ed31a696564871fd18ap-4,
    0x1.cb3a9ap-4
  },
  { // Entry 24
    -0x1.d077fc01fda53b80967d942b1ffe2193p-16,
    -0x1.d077fcp-16
  },
  { // Entry 25
    0x1.d077fc01fda53b80967d942b1ffe2193p-16,
    0x1.d077fcp-16
  },
  { // Entry 26
    -0x1.fb0335b41665a445bad16a5da2454d1ap-3,
    -0x1.f0e7p-3
  },
  { // Entry 27
    0x1.fb0335b41665a445bad16a5da2454d1ap-3,
    0x1.f0e7p-3
  },
  { // Entry 28
    -0x1.fbbbe9001627e7188cb48f38c4820e35p-3,
    -0x1.f194d0p-3
  },
  { // Entry 29
    0x1.fbbbe9001627e7188cb48f38c4820e35p-3,
    0x1.f194d0p-3
  },
  { // Entry 30
    -0x1.193d550095876f79105e76c75ca58b2fp-1,
    -0x1.fffe04p-2
  },
  { // Entry 31
    0x1.193d550095876f79105e76c75ca58b2fp-1,
    0x1.fffe04p-2
  },
  { // Entry 32
    -0x1.193ea5002587c5e868720bc46d87505bp-1,
    -0x1.fffffcp-2
  },
  { // Entry 33
    0x1.193ea5002587c5e868720bc46d87505bp-1,
    0x1.fffffcp-2
  },
  { // Entry 34
    0x1.193ea7aad030a976a4198d55053b7cb5p-1,
    0x1.p-1
  },
  { // Entry 35
    -0x1.193ea7aad030a976a4198d55053b7cb5p-1,
    -0x1.p-1
  },
  { // Entry 36
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 37
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 38
    0x1.00000200000000000000155555d55556p-41,
    0x1.000002p-41
  },
  { // Entry 39
    -0x1.00000200000000000000155555d55556p-41,
    -0x1.000002p-41
  },
  { // Entry 40
    0x1.193ebd0025f7c5edf31cf5a0e285059ep-1,
    0x1.000010p-1
  },
  { // Entry 41
    -0x1.193ebd0025f7c5edf31cf5a0e285059ep-1,
    -0x1.000010p-1
  },
  { // Entry 42
    0x1.05901c768a92c5a23c8e8531ffe01945p-2,
    0x1.0004dap-2
  },
  { // Entry 43
    -0x1.05901c768a92c5a23c8e8531ffe01945p-2,
    -0x1.0004dap-2
  },
  { // Entry 44
    0x1.01d972ffff40cd1cf377322d5faca975p-6,
    0x1.01d4p-6
  },
  { // Entry 45
    -0x1.01d972ffff40cd1cf377322d5faca975p-6,
    -0x1.01d4p-6
  },
  { // Entry 46
    0x1.0b4d0560a980ef9bc645b2c29563e89fp-2,
    0x1.0564p-2
  },
  { // Entry 47
    -0x1.0b4d0560a980ef9bc645b2c29563e89fp-2,
    -0x1.0564p-2
  },
  { // Entry 48
    0x1.0616e1ffd00766707c845454688ac285p-5,
    0x1.06p-5
  },
  { // Entry 49
    -0x1.0616e1ffd00766707c845454688ac285p-5,
    -0x1.06p-5
  },
  { // Entry 50
    0x1.0c1a71e0f243aaabf988a086b92d8098p-2,
    0x1.0624p-2
  },
  { // Entry 51
    -0x1.0c1a71e0f243aaabf988a086b92d8098p-2,
    -0x1.0624p-2
  },
  { // Entry 52
    0x1.068016ffffd89ea5af86d140cc4499acp-9,
    0x1.0680p-9
  },
  { // Entry 53
    -0x1.068016ffffd89ea5af86d140cc4499acp-9,
    -0x1.0680p-9
  },
  { // Entry 54
    0x1.10f99a58d073173f64d078d1921d0abdp-2,
    0x1.0ab0p-2
  },
  { // Entry 55
    -0x1.10f99a58d073173f64d078d1921d0abdp-2,
    -0x1.0ab0p-2
  },
  { // Entry 56
    0x1.10022efcd204975cd5de2eb798c5a366p-4,
    0x1.0f9cp-4
  },
  { // Entry 57
    -0x1.10022efcd204975cd5de2eb798c5a366p-4,
    -0x1.0f9cp-4
  },
  { // Entry 58
    0x1.384c7bbb40817a713670eda9b1b1aacdp-1,
    0x1.1694p-1
  },
  { // Entry 59
    -0x1.384c7bbb40817a713670eda9b1b1aacdp-1,
    -0x1.1694p-1
  },
  { // Entry 60
    0x1.189a2700033273251e12d5eba90e4465p-3,
    0x1.16dcp-3
  },
  { // Entry 61
    -0x1.189a2700033273251e12d5eba90e4465p-3,
    -0x1.16dcp-3
  },
  { // Entry 62
    0x1.3a52accbc786f237ffb73633c18324fbp-1,
    0x1.18p-1
  },
  { // Entry 63
    -0x1.3a52accbc786f237ffb73633c18324fbp-1,
    -0x1.18p-1
  },
  { // Entry 64
    0x1.19c3b0fa86d540072c08c5d6b394b165p-3,
    0x1.18p-3
  },
  { // Entry 65
    -0x1.19c3b0fa86d540072c08c5d6b394b165p-3,
    -0x1.18p-3
  },
  { // Entry 66
    0x1.1c8f7300000b7dc0ff5b03e64623dec6p-4,
    0x1.1c1a7ap-4
  },
  { // Entry 67
    -0x1.1c8f7300000b7dc0ff5b03e64623dec6p-4,
    -0x1.1c1a7ap-4
  },
  { // Entry 68
    0x1.44f16a9bea7f03af529b037b235f31b5p-1,
    0x1.1f5cp-1
  },
  { // Entry 69
    -0x1.44f16a9bea7f03af529b037b235f31b5p-1,
    -0x1.1f5cp-1
  },
  { // Entry 70
    0x1.1ffc000000797af0120046e7dc31d3f5p-20,
    0x1.1ffcp-20
  },
  { // Entry 71
    -0x1.1ffc000000797af0120046e7dc31d3f5p-20,
    -0x1.1ffcp-20
  },
  { // Entry 72
    0x1.27f9cfc34385aff96fa7a25c9010711bp-2,
    0x1.1ffffep-2
  },
  { // Entry 73
    -0x1.27f9cfc34385aff96fa7a25c9010711bp-2,
    -0x1.1ffffep-2
  },
  { // Entry 74
    0x1.5deb9a83ee95c385ba5335580af08f08p-1,
    0x1.30p-1
  },
  { // Entry 75
    -0x1.5deb9a83ee95c385ba5335580af08f08p-1,
    -0x1.30p-1
  },
  { // Entry 76
    0x1.5e0e0298d9eec3ab8b4f4e1b8d295ac3p-1,
    0x1.301646p-1
  },
  { // Entry 77
    -0x1.5e0e0298d9eec3ab8b4f4e1b8d295ac3p-1,
    -0x1.301646p-1
  },
  { // Entry 78
    0x1.5e60e400006f52cb7692b6e8a51da384p-1,
    0x1.304be6p-1
  },
  { // Entry 79
    -0x1.5e60e400006f52cb7692b6e8a51da384p-1,
    -0x1.304be6p-1
  },
  { // Entry 80
    0x1.47f5170000024233854b6203d98d324fp-5,
    0x1.47c844p-5
  },
  { // Entry 81
    -0x1.47f5170000024233854b6203d98d324fp-5,
    -0x1.47c844p-5
  },
  { // Entry 82
    0x1.48ae1cfffeff307b13c17eb56fdcf7c2p-5,
    0x1.4880fep-5
  },
  { // Entry 83
    -0x1.48ae1cfffeff307b13c17eb56fdcf7c2p-5,
    -0x1.4880fep-5
  },
  { // Entry 84
    0x1.79d4c40000354d83f4c26c097b0e75fdp-2,
    0x1.6991dap-2
  },
  { // Entry 85
    -0x1.79d4c40000354d83f4c26c097b0e75fdp-2,
    -0x1.6991dap-2
  },
  { // Entry 86
    0x1.c7139f215feb3a72cf1b5e192f938ea4p-1,
    0x1.6bef72p-1
  },
  { // Entry 87
    -0x1.c7139f215feb3a72cf1b5e192f938ea4p-1,
    -0x1.6bef72p-1
  },
  { // Entry 88
    0x1.7140e3001401c1b014172d6fd91711aep-12,
    0x1.7140e2p-12
  },
  { // Entry 89
    -0x1.7140e3001401c1b014172d6fd91711aep-12,
    -0x1.7140e2p-12
  },
  { // Entry 90
    0x1.e05648db7af67a5476dcef31c7834740p-1,
    0x1.77fffep-1
  },
  { // Entry 91
    -0x1.e05648db7af67a5476dcef31c7834740p-1,
    -0x1.77fffep-1
  },
  { // Entry 92
    0x1.77fffe0000000010e5f5104d55b356b3p-30,
    0x1.77fffep-30
  },
  { // Entry 93
    -0x1.77fffe0000000010e5f5104d55b356b3p-30,
    -0x1.77fffep-30
  },
  { // Entry 94
    0x1.93b0aee21c2c808f5840a8fdec9984e1p-2,
    0x1.80p-2
  },
  { // Entry 95
    -0x1.93b0aee21c2c808f5840a8fdec9984e1p-2,
    -0x1.80p-2
  },
  { // Entry 96
    0x1.f22781be9e69629e565cb27d7e8be241p-1,
    0x1.800026p-1
  },
  { // Entry 97
    -0x1.f22781be9e69629e565cb27d7e8be241p-1,
    -0x1.800026p-1
  },
  { // Entry 98
    0x1.f22a81c2c1df6e290a34d78c0e42165fp-1,
    0x1.800176p-1
  },
  { // Entry 99
    -0x1.f22a81c2c1df6e290a34d78c0e42165fp-1,
    -0x1.800176p-1
  },
  { // Entry 100
    0x1.f4d9b1f449f9637049f465ad813677cdp-1,
    0x1.812ceap-1
  },
  { // Entry 101
    -0x1.f4d9b1f449f9637049f465ad813677cdp-1,
    -0x1.812ceap-1
  },
  { // Entry 102
    0x1.f6a98a347aefdfbfdfc26e6c5fd39d63p-1,
    0x1.81f5b6p-1
  },
  { // Entry 103
    -0x1.f6a98a347aefdfbfdfc26e6c5fd39d63p-1,
    -0x1.81f5b6p-1
  },
  { // Entry 104
    0x1.f6b16e036a1228e2d7592b99921a73fdp-1,
    0x1.81f91ep-1
  },
  { // Entry 105
    -0x1.f6b16e036a1228e2d7592b99921a73fdp-1,
    -0x1.81f91ep-1
  },
  { // Entry 106
    0x1.879115ffff8980f9da1405781afd63e0p-3,
    0x1.82dd3cp-3
  },
  { // Entry 107
    -0x1.879115ffff8980f9da1405781afd63e0p-3,
    -0x1.82dd3cp-3
  },
  { // Entry 108
    0x1.87f3fb0000ab210be606ca39761681bdp-7,
    0x1.87ef32p-7
  },
  { // Entry 109
    -0x1.87f3fb0000ab210be606ca39761681bdp-7,
    -0x1.87ef32p-7
  },
  { // Entry 110
    0x1.8c680b3adda5a66ad6d8da856236ff97p-7,
    0x1.8c6318p-7
  },
  { // Entry 111
    -0x1.8c680b3adda5a66ad6d8da856236ff97p-7,
    -0x1.8c6318p-7
  },
  { // Entry 112
    0x1.9aa64d00181abc40f45d08711a8a0e2dp-3,
    0x1.953bb8p-3
  },
  { // Entry 113
    -0x1.9aa64d00181abc40f45d08711a8a0e2dp-3,
    -0x1.953bb8p-3
  },
  { // Entry 114
    0x1.99ba390011821eb8ba2f398e3ec3cbd2p-4,
    0x1.985dc4p-4
  },
  { // Entry 115
    -0x1.99ba390011821eb8ba2f398e3ec3cbd2p-4,
    -0x1.985dc4p-4
  },
  { // Entry 116
    0x1.a05bacfcccc788b02291ff2a73385befp-5,
    0x1.9ffffep-5
  },
  { // Entry 117
    -0x1.a05bacfcccc788b02291ff2a73385befp-5,
    -0x1.9ffffep-5
  },
  { // Entry 118
    0x1.a64fb7002d9b9b7248958431d95f77ebp-4,
    0x1.a4d240p-4
  },
  { // Entry 119
    -0x1.a64fb7002d9b9b7248958431d95f77ebp-4,
    -0x1.a4d240p-4
  },
  { // Entry 120
    0x1.a64908fbec59b6b02d326674ded2f9f2p-5,
    0x1.a5e962p-5
  },
  { // Entry 121
    -0x1.a64908fbec59b6b02d326674ded2f9f2p-5,
    -0x1.a5e962p-5
  },
  { // Entry 122
    0x1.b192470000fb2118da687cc4160f98c6p-6,
    0x1.b17860p-6
  },
  { // Entry 123
    -0x1.b192470000fb2118da687cc4160f98c6p-6,
    -0x1.b17860p-6
  },
  { // Entry 124
    0x1.d6f45cc922663f64dfff1989368eafd0p-2,
    0x1.b8562ap-2
  },
  { // Entry 125
    -0x1.d6f45cc922663f64dfff1989368eafd0p-2,
    -0x1.b8562ap-2
  },
  { // Entry 126
    0x1.dad882760031b0b207eec53f2bad3a56p-2,
    0x1.bb80c8p-2
  },
  { // Entry 127
    -0x1.dad882760031b0b207eec53f2bad3a56p-2,
    -0x1.bb80c8p-2
  },
  { // Entry 128
    0x1.bcef0900070bb4d60dba7d7916e44f1cp-11,
    0x1.bcef02p-11
  },
  { // Entry 129
    -0x1.bcef0900070bb4d60dba7d7916e44f1cp-11,
    -0x1.bcef02p-11
  },
  { // Entry 130
    0x1.e0648f29a5cb8fa830357eb28463b371p-2,
    0x1.bfffbep-2
  },
  { // Entry 131
    -0x1.e0648f29a5cb8fa830357eb28463b371p-2,
    -0x1.bfffbep-2
  },
  { // Entry 132
    0x1.c2e5e80000474fca411deeabc2d871b2p-6,
    0x1.c2c8c6p-6
  },
  { // Entry 133
    -0x1.c2e5e80000474fca411deeabc2d871b2p-6,
    -0x1.c2c8c6p-6
  },
  { // Entry 134
    0x1.c997430019b045d79984044543bd4322p-4,
    0x1.c7b258p-4
  },
  { // Entry 135
    -0x1.c997430019b045d79984044543bd4322p-4,
    -0x1.c7b258p-4
  },
  { // Entry 136
    0x1.6cc8dca857314e6901156d00f8a3b682p0,
    0x1.c7fffep-1
  },
  { // Entry 137
    -0x1.6cc8dca857314e6901156d00f8a3b682p0,
    -0x1.c7fffep-1
  },
  { // Entry 138
    0x1.c7fffe01e245f9ab162301990550caa9p-16,
    0x1.c7fffep-16
  },
  { // Entry 139
    -0x1.c7fffe01e245f9ab162301990550caa9p-16,
    -0x1.c7fffep-16
  },
  { // Entry 140
    0x1.ed65267d01a1db540b37753c51d66426p-2,
    0x1.ca7436p-2
  },
  { // Entry 141
    -0x1.ed65267d01a1db540b37753c51d66426p-2,
    -0x1.ca7436p-2
  },
  { // Entry 142
    0x1.d48af32968fa3b34457bcff03db0622dp-3,
    0x1.cc8928p-3
  },
  { // Entry 143
    -0x1.d48af32968fa3b34457bcff03db0622dp-3,
    -0x1.cc8928p-3
  },
  { // Entry 144
    0x1.f0c2d8fffefca01290c2ef36330c9115p-2,
    0x1.cd242cp-2
  },
  { // Entry 145
    -0x1.f0c2d8fffefca01290c2ef36330c9115p-2,
    -0x1.cd242cp-2
  },
  { // Entry 146
    0x1.ce535efa32f0cec15b3bccf05c079f19p-5,
    0x1.cdd5e0p-5
  },
  { // Entry 147
    -0x1.ce535efa32f0cec15b3bccf05c079f19p-5,
    -0x1.cdd5e0p-5
  },
  { // Entry 148
    0x1.d0703e01fd8bbf96395ed2f62f54fdcap-16,
    0x1.d0703ep-16
  },
  { // Entry 149
    -0x1.d0703e01fd8bbf96395ed2f62f54fdcap-16,
    -0x1.d0703ep-16
  },
  { // Entry 150
    0x1.f84fd66cf58e3da9e2d75ce683cca2d0p-2,
    0x1.d32406p-2
  },
  { // Entry 151
    -0x1.f84fd66cf58e3da9e2d75ce683cca2d0p-2,
    -0x1.d32406p-2
  },
  { // Entry 152
    0x1.dca60100427d4d26515dcb19009e0fe7p-4,
    0x1.da822cp-4
  },
  { // Entry 153
    -0x1.dca60100427d4d26515dcb19009e0fe7p-4,
    -0x1.da822cp-4
  },
  { // Entry 154
    0x1.f19057907b6a6fe84ba8e4830b7a0799p-3,
    0x1.e7fffep-3
  },
  { // Entry 155
    -0x1.f19057907b6a6fe84ba8e4830b7a0799p-3,
    -0x1.e7fffep-3
  },
  { // Entry 156
    0x1.ef311b0049dc13b5b0e01b868b4cfc92p-4,
    0x1.eccb14p-4
  },
  { // Entry 157
    -0x1.ef311b0049dc13b5b0e01b868b4cfc92p-4,
    -0x1.eccb14p-4
  },
  { // Entry 158
    0x1.ee703b40bad448188d321c9cf1c77c2fp-6,
    0x1.ee49d2p-6
  },
  { // Entry 159
    -0x1.ee703b40bad448188d321c9cf1c77c2fp-6,
    -0x1.ee49d2p-6
  },
  { // Entry 160
    0x1.efa28ecceba94af00baf6a70399b27c5p-6,
    0x1.ef7bdep-6
  },
  { // Entry 161
    -0x1.efa28ecceba94af00baf6a70399b27c5p-6,
    -0x1.ef7bdep-6
  },
  { // Entry 162
    0x1.fa0dc7b72c16fcd1b16623d79ed72b48p-3,
    0x1.effffep-3
  },
  { // Entry 163
    -0x1.fa0dc7b72c16fcd1b16623d79ed72b48p-3,
    -0x1.effffep-3
  },
  { // Entry 164
    0x1.f479ce9e62f1de793e626c5e4cd483bfp-4,
    0x1.f1fffep-4
  },
  { // Entry 165
    -0x1.f479ce9e62f1de793e626c5e4cd483bfp-4,
    -0x1.f1fffep-4
  },
  { // Entry 166
    0x1.f48dfd004492424a2242a7f1b84fde43p-4,
    0x1.f213e0p-4
  },
  { // Entry 167
    -0x1.f48dfd004492424a2242a7f1b84fde43p-4,
    -0x1.f213e0p-4
  },
  { // Entry 168
    0x1.f55565004e1ba77f8c68954d58ad9522p-4,
    0x1.f2d854p-4
  },
  { // Entry 169
    -0x1.f55565004e1ba77f8c68954d58ad9522p-4,
    -0x1.f2d854p-4
  },
  { // Entry 170
    0x1.fec794ffff80de6f133ff791c5439d8ep-3,
    0x1.f47232p-3
  },
  { // Entry 171
    -0x1.fec794ffff80de6f133ff791c5439d8ep-3,
    -0x1.f47232p-3
  },
  { // Entry 172
    0x1.f813e9004d5cdfb063728666fb66e97fp-4,
    0x1.f58c5ep-4
  },
  { // Entry 173
    -0x1.f813e9004d5cdfb063728666fb66e97fp-4,
    -0x1.f58c5ep-4
  },
  { // Entry 174
    0x1.f7b721ffff991c706d90945105ec030fp-7,
    0x1.f7acfap-7
  },
  { // Entry 175
    -0x1.f7b721ffff991c706d90945105ec030fp-7,
    -0x1.f7acfap-7
  },
  { // Entry 176
    0x1.fbd5f50051fbc9e55c8b2be9e9e21851p-4,
    0x1.f93fe2p-4
  },
  { // Entry 177
    -0x1.fbd5f50051fbc9e55c8b2be9e9e21851p-4,
    -0x1.f93fe2p-4
  },
  { // Entry 178
    0x1.fcfaff0050f8ca3009ab7b1e46b4ec9dp-4,
    0x1.fa6074p-4
  },
  { // Entry 179
    -0x1.fcfaff0050f8ca3009ab7b1e46b4ec9dp-4,
    -0x1.fa6074p-4
  },
  { // Entry 180
    0x1.03a8a30006385ed65d745b5dec7c194ep-2,
    0x1.fc7746p-3
  },
  { // Entry 181
    -0x1.03a8a30006385ed65d745b5dec7c194ep-2,
    -0x1.fc7746p-3
  },
  { // Entry 182
    0x1.fe2a317243079e4fdd1cb855c975cdf1p-6,
    0x1.fep-6
  },
  { // Entry 183
    -0x1.fe2a317243079e4fdd1cb855c975cdf1p-6,
    -0x1.fep-6
  },
  { // Entry 184
    0x1.fe82db7456cf5b9b9edf1b4b77c994bdp-6,
    0x1.fe5894p-6
  },
  { // Entry 185
    -0x1.fe82db7456cf5b9b9edf1b4b77c994bdp-6,
    -0x1.fe5894p-6
  },
  { // Entry 186
    0x1.ffeaa710f5a6e8d16dc905e338c0200fp-7,
    0x1.ffdffep-7
  },
  { // Entry 187
    -0x1.ffeaa710f5a6e8d16dc905e338c0200fp-7,
    -0x1.ffdffep-7
  },
  { // Entry 188
    0x1.7d33cb0c02505f47778ae337ae72ec1fp2,
    0x1.fffe3ep-1
  },
  { // Entry 189
    -0x1.7d33cb0c02505f47778ae337ae72ec1fp2,
    -0x1.fffe3ep-1
  },
  { // Entry 190
    0x1.193e51002cdbc475975ff766fbd1f6b5p-1,
    0x1.ffff7ep-2
  },
  { // Entry 191
    -0x1.193e51002cdbc475975ff766fbd1f6b5p-1,
    -0x1.ffff7ep-2
  },
  { // Entry 192
    0x1.000514847a91cdaebaecfa77f6111dd9p-6,
    0x1.ffff7ep-7
  },
  { // Entry 193
    -0x1.000514847a91cdaebaecfa77f6111dd9p-6,
    -0x1.ffff7ep-7
  },
  { // Entry 194
    0x1.193ea5002587c5e868720bc46d87505bp-1,
    0x1.fffffcp-2
  },
  { // Entry 195
    -0x1.193ea5002587c5e868720bc46d87505bp-1,
    -0x1.fffffcp-2
  },
  { // Entry 196
    0x1.fffffcaaaaa71111155a35aa3dc3d06cp-13,
    0x1.fffffcp-13
  },
  { // Entry 197
    -0x1.fffffcaaaaa71111155a35aa3dc3d06cp-13,
    -0x1.fffffcp-13
  },
  { // Entry 198
    -0x1.31dd2cd1386933d1d890b6a9703c16adp1,
    -0x1.f77778p-1
  },
  { // Entry 199
    0x1.31dd2cd1386933d1d890b6a9703c16adp1,
    0x1.f77778p-1
  },
  { // Entry 200
    -0x1.04f663adcdd5e8864c55a5751a0b17b7p1,
    -0x1.eeeef0p-1
  },
  { // Entry 201
    0x1.04f663adcdd5e8864c55a5751a0b17b7p1,
    0x1.eeeef0p-1
  },
  { // Entry 202
    -0x1.d4ef9ebd04658e641423a6ed3defe0dap0,
    -0x1.e66668p-1
  },
  { // Entry 203
    0x1.d4ef9ebd04658e641423a6ed3defe0dap0,
    0x1.e66668p-1
  },
  { // Entry 204
    -0x1.af0395037f075cc7baefa38ef81f508fp0,
    -0x1.dddde0p-1
  },
  { // Entry 205
    0x1.af0395037f075cc7baefa38ef81f508fp0,
    0x1.dddde0p-1
  },
  { // Entry 206
    -0x1.9157e83626a045c7caf65f13d23b0dd3p0,
    -0x1.d55558p-1
  },
  { // Entry 207
    0x1.9157e83626a045c7caf65f13d23b0dd3p0,
    0x1.d55558p-1
  },
  { // Entry 208
    -0x1.78e368cc158d8c46dcfa1f8a88963aa4p0,
    -0x1.ccccd0p-1
  },
  { // Entry 209
    0x1.78e368cc158d8c46dcfa1f8a88963aa4p0,
    0x1.ccccd0p-1
  },
  { // Entry 210
    -0x1.64077e53bbdd057c995616b489d53cf4p0,
    -0x1.c44448p-1
  },
  { // Entry 211
    0x1.64077e53bbdd057c995616b489d53cf4p0,
    0x1.c44448p-1
  },
  { // Entry 212
    -0x1.51cca9ffc51eb62dad1c2d513ab87a52p0,
    -0x1.bbbbc0p-1
  },
  { // Entry 213
    0x1.51cca9ffc51eb62dad1c2d513ab87a52p0,
    0x1.bbbbc0p-1
  },
  { // Entry 214
    -0x1.419343b452798f95458545b3a8e5c365p0,
    -0x1.b33338p-1
  },
  { // Entry 215
    0x1.419343b452798f95458545b3a8e5c365p0,
    0x1.b33338p-1
  },
  { // Entry 216
    -0x1.32ee4432223fd6ff7fc96b745a339d15p0,
    -0x1.aaaab0p-1
  },
  { // Entry 217
    0x1.32ee4432223fd6ff7fc96b745a339d15p0,
    0x1.aaaab0p-1
  },
  { // Entry 218
    -0x1.258fe3b6e537bb3292f6d7e4afbb9d07p0,
    -0x1.a22228p-1
  },
  { // Entry 219
    0x1.258fe3b6e537bb3292f6d7e4afbb9d07p0,
    0x1.a22228p-1
  },
  { // Entry 220
    -0x1.193eb08e5ea8c2c200b0e99c5a36fddep0,
    -0x1.9999a0p-1
  },
  { // Entry 221
    0x1.193eb08e5ea8c2c200b0e99c5a36fddep0,
    0x1.9999a0p-1
  },
  { // Entry 222
    -0x1.0dcf079da2f030ae3fbf6b6f92a2a743p0,
    -0x1.911118p-1
  },
  { // Entry 223
    0x1.0dcf079da2f030ae3fbf6b6f92a2a743p0,
    0x1.911118p-1
  },
  { // Entry 224
    -0x1.031efa1f0ecc8f3a906dd42d8c2123cbp0,
    -0x1.888890p-1
  },
  { // Entry 225
    0x1.031efa1f0ecc8f3a906dd42d8c2123cbp0,
    0x1.888890p-1
  },
  { // Entry 226
    -0x1.f2273d2c4ab521b4cd487640ff959135p-1,
    -0x1.800008p-1
  },
  { // Entry 227
    0x1.f2273d2c4ab521b4cd487640ff959135p-1,
    0x1.800008p-1
  },
  { // Entry 228
    -0x1.df2e7fe4879a14bed3444cebeb14e17ap-1,
    -0x1.777780p-1
  },
  { // Entry 229
    0x1.df2e7fe4879a14bed3444cebeb14e17ap-1,
    0x1.777780p-1
  },
  { // Entry 230
    -0x1.cd3033baff79597658ed84a70792b418p-1,
    -0x1.6eeef8p-1
  },
  { // Entry 231
    0x1.cd3033baff79597658ed84a70792b418p-1,
    0x1.6eeef8p-1
  },
  { // Entry 232
    -0x1.bc0ee367530d66cc841d5f9d30c2b886p-1,
    -0x1.666670p-1
  },
  { // Entry 233
    0x1.bc0ee367530d66cc841d5f9d30c2b886p-1,
    0x1.666670p-1
  },
  { // Entry 234
    -0x1.abb1dc08e18126620d575aabc793b2a9p-1,
    -0x1.5ddde8p-1
  },
  { // Entry 235
    0x1.abb1dc08e18126620d575aabc793b2a9p-1,
    0x1.5ddde8p-1
  },
  { // Entry 236
    -0x1.9c0432b20c814b3021011c479a51acefp-1,
    -0x1.555560p-1
  },
  { // Entry 237
    0x1.9c0432b20c814b3021011c479a51acefp-1,
    0x1.555560p-1
  },
  { // Entry 238
    -0x1.8cf4071c6b253657280e30019b42b6cbp-1,
    -0x1.4cccd8p-1
  },
  { // Entry 239
    0x1.8cf4071c6b253657280e30019b42b6cbp-1,
    0x1.4cccd8p-1
  },
  { // Entry 240
    -0x1.7e71f26de777bc532a40c40569e80be7p-1,
    -0x1.444450p-1
  },
  { // Entry 241
    0x1.7e71f26de777bc532a40c40569e80be7p-1,
    0x1.444450p-1
  },
  { // Entry 242
    -0x1.7070964a5465019869be4292807243adp-1,
    -0x1.3bbbc8p-1
  },
  { // Entry 243
    0x1.7070964a5465019869be4292807243adp-1,
    0x1.3bbbc8p-1
  },
  { // Entry 244
    -0x1.62e443efa416f35cfe72519ab5c49833p-1,
    -0x1.333340p-1
  },
  { // Entry 245
    0x1.62e443efa416f35cfe72519ab5c49833p-1,
    0x1.333340p-1
  },
  { // Entry 246
    -0x1.55c2b577a316f398743bc84818a8366dp-1,
    -0x1.2aaab8p-1
  },
  { // Entry 247
    0x1.55c2b577a316f398743bc84818a8366dp-1,
    0x1.2aaab8p-1
  },
  { // Entry 248
    -0x1.4902d4f8dcabba59533687adf378fc3bp-1,
    -0x1.222230p-1
  },
  { // Entry 249
    0x1.4902d4f8dcabba59533687adf378fc3bp-1,
    0x1.222230p-1
  },
  { // Entry 250
    -0x1.3c9c8e61aec973e370031a7719321089p-1,
    -0x1.1999a8p-1
  },
  { // Entry 251
    0x1.3c9c8e61aec973e370031a7719321089p-1,
    0x1.1999a8p-1
  },
  { // Entry 252
    -0x1.3088a9b5ad202b17e52d8601513662b0p-1,
    -0x1.111120p-1
  },
  { // Entry 253
    0x1.3088a9b5ad202b17e52d8601513662b0p-1,
    0x1.111120p-1
  },
  { // Entry 254
    -0x1.24c0abe8e973d6e99acbd15484fd64f1p-1,
    -0x1.088898p-1
  },
  { // Entry 255
    0x1.24c0abe8e973d6e99acbd15484fd64f1p-1,
    0x1.088898p-1
  },
  { // Entry 256
    -0x1.193ebd0025f7c5edf31cf5a0e285059ep-1,
    -0x1.000010p-1
  },
  { // Entry 257
    0x1.193ebd0025f7c5edf31cf5a0e285059ep-1,
    0x1.000010p-1
  },
  { // Entry 258
    0x1.193ea7aad030a976a4198d55053b7cb5p-1,
    0x1.p-1
  },
  { // Entry 259
    -0x1.193ea7aad030a976a4198d55053b7cb5p-1,
    -0x1.p-1
  },
  { // Entry 260
    0x1.24c0961556d0aa95d6fb6c106b236048p-1,
    0x1.088888p-1
  },
  { // Entry 261
    -0x1.24c0961556d0aa95d6fb6c106b236048p-1,
    -0x1.088888p-1
  },
  { // Entry 262
    0x1.30889359736e9acf9152fe43f28f7dcdp-1,
    0x1.111110p-1
  },
  { // Entry 263
    -0x1.30889359736e9acf9152fe43f28f7dcdp-1,
    -0x1.111110p-1
  },
  { // Entry 264
    0x1.3c9c77714791547aab37a433668ebfb8p-1,
    0x1.199998p-1
  },
  { // Entry 265
    -0x1.3c9c77714791547aab37a433668ebfb8p-1,
    -0x1.199998p-1
  },
  { // Entry 266
    0x1.4902bd6778eba4dde3659bd4e4b3b796p-1,
    0x1.222220p-1
  },
  { // Entry 267
    -0x1.4902bd6778eba4dde3659bd4e4b3b796p-1,
    -0x1.222220p-1
  },
  { // Entry 268
    0x1.55c29d36f62e0342a6067b58817783bep-1,
    0x1.2aaaa8p-1
  },
  { // Entry 269
    -0x1.55c29d36f62e0342a6067b58817783bep-1,
    -0x1.2aaaa8p-1
  },
  { // Entry 270
    0x1.62e42aefa3a673577e1cbcc51d3a75b3p-1,
    0x1.333330p-1
  },
  { // Entry 271
    -0x1.62e42aefa3a673577e1cbcc51d3a75b3p-1,
    -0x1.333330p-1
  },
  { // Entry 272
    0x1.70707c78ea48dcd2be90243420138634p-1,
    0x1.3bbbb8p-1
  },
  { // Entry 273
    -0x1.70707c78ea48dcd2be90243420138634p-1,
    -0x1.3bbbb8p-1
  },
  { // Entry 274
    0x1.7e71d7b69209fbf8a31f61e28fb38405p-1,
    0x1.444440p-1
  },
  { // Entry 275
    -0x1.7e71d7b69209fbf8a31f61e28fb38405p-1,
    -0x1.444440p-1
  },
  { // Entry 276
    0x1.8cf3eb67c6bcfdb506baa6ecb5f2d950p-1,
    0x1.4cccc8p-1
  },
  { // Entry 277
    -0x1.8cf3eb67c6bcfdb506baa6ecb5f2d950p-1,
    -0x1.4cccc8p-1
  },
  { // Entry 278
    0x1.9c0415e53f585567855afd0c32aa7e17p-1,
    0x1.555550p-1
  },
  { // Entry 279
    -0x1.9c0415e53f585567855afd0c32aa7e17p-1,
    -0x1.555550p-1
  },
  { // Entry 280
    0x1.abb1be04e0a675ba1948b8fb1841584cp-1,
    0x1.5dddd8p-1
  },
  { // Entry 281
    -0x1.abb1be04e0a675ba1948b8fb1841584cp-1,
    -0x1.5dddd8p-1
  },
  { // Entry 282
    0x1.bc0ec407f36921e00a5bfee526dd0834p-1,
    0x1.666660p-1
  },
  { // Entry 283
    -0x1.bc0ec407f36921e00a5bfee526dd0834p-1,
    -0x1.666660p-1
  },
  { // Entry 284
    0x1.cd3012d5c08d242886fcc0f61668a3d5p-1,
    0x1.6eeee8p-1
  },
  { // Entry 285
    -0x1.cd3012d5c08d242886fcc0f61668a3d5p-1,
    -0x1.6eeee8p-1
  },
  { // Entry 286
    0x1.df2e5d46fda42cf27a71863b4cf7c7e6p-1,
    0x1.777770p-1
  },
  { // Entry 287
    -0x1.df2e5d46fda42cf27a71863b4cf7c7e6p-1,
    -0x1.777770p-1
  },
  { // Entry 288
    0x1.f227189a01908f60f615760148cb8e3fp-1,
    0x1.7ffff8p-1
  },
  { // Entry 289
    -0x1.f227189a01908f60f615760148cb8e3fp-1,
    -0x1.7ffff8p-1
  },
  { // Entry 290
    0x1.031ee6b6dd313b8e955cf0deb74b13d5p0,
    0x1.888880p-1
  },
  { // Entry 291
    -0x1.031ee6b6dd313b8e955cf0deb74b13d5p0,
    -0x1.888880p-1
  },
  { // Entry 292
    0x1.0dcef2e94717cf54ab5e3d4ae7c6ab03p0,
    0x1.911108p-1
  },
  { // Entry 293
    -0x1.0dcef2e94717cf54ab5e3d4ae7c6ab03p0,
    -0x1.911108p-1
  },
  { // Entry 294
    0x1.193e9a557b698cfbd9d4a767ef99c767p0,
    0x1.999990p-1
  },
  { // Entry 295
    -0x1.193e9a557b698cfbd9d4a767ef99c767p0,
    -0x1.999990p-1
  },
  { // Entry 296
    0x1.258fcbb1c5e534f37ad64a1e99a869e8p0,
    0x1.a22218p-1
  },
  { // Entry 297
    -0x1.258fcbb1c5e534f37ad64a1e99a869e8p0,
    -0x1.a22218p-1
  },
  { // Entry 298
    0x1.32ee2a03975b57f64a84528990be1f9ap0,
    0x1.aaaaa0p-1
  },
  { // Entry 299
    -0x1.32ee2a03975b57f64a84528990be1f9ap0,
    -0x1.aaaaa0p-1
  },
  { // Entry 300
    0x1.419326e02573d8b3acc7cbf76968fe33p0,
    0x1.b33328p-1
  },
  { // Entry 301
    -0x1.419326e02573d8b3acc7cbf76968fe33p0,
    -0x1.b33328p-1
  },
  { // Entry 302
    0x1.51cc89db34776ccef56dd618e02f1da6p0,
    0x1.bbbbb0p-1
  },
  { // Entry 303
    -0x1.51cc89db34776ccef56dd618e02f1da6p0,
    -0x1.bbbbb0p-1
  },
  { // Entry 304
    0x1.640759eae23a226a9d7c3926242da006p0,
    0x1.c44438p-1
  },
  { // Entry 305
    -0x1.640759eae23a226a9d7c3926242da006p0,
    -0x1.c44438p-1
  },
  { // Entry 306
    0x1.78e33eb126c4263142e4f9584dfaa238p0,
    0x1.ccccc0p-1
  },
  { // Entry 307
    -0x1.78e33eb126c4263142e4f9584dfaa238p0,
    -0x1.ccccc0p-1
  },
  { // Entry 308
    0x1.9157b61fe9d5041ad9f9720e3ae0d7c0p0,
    0x1.d55548p-1
  },
  { // Entry 309
    -0x1.9157b61fe9d5041ad9f9720e3ae0d7c0p0,
    -0x1.d55548p-1
  },
  { // Entry 310
    0x1.af0356f1e19ad530d89ec545995495b6p0,
    0x1.ddddd0p-1
  },
  { // Entry 311
    -0x1.af0356f1e19ad530d89ec545995495b6p0,
    -0x1.ddddd0p-1
  },
  { // Entry 312
    0x1.d4ef4caff7901be8dda0560383f995f5p0,
    0x1.e66658p-1
  },
  { // Entry 313
    -0x1.d4ef4caff7901be8dda0560383f995f5p0,
    -0x1.e66658p-1
  },
  { // Entry 314
    0x1.04f626a98f6c7775f5aa272dfa30aa0cp1,
    0x1.eeeee0p-1
  },
  { // Entry 315
    -0x1.04f626a98f6c7775f5aa272dfa30aa0cp1,
    -0x1.eeeee0p-1
  },
  { // Entry 316
    0x1.31dcb3cf7aadccb53ddc6ab3e5f44cf1p1,
    0x1.f77768p-1
  },
  { // Entry 317
    -0x1.31dcb3cf7aadccb53ddc6ab3e5f44cf1p1,
    -0x1.f77768p-1
  },
  { // Entry 318
    -0x1.1542456b37d42c1c6b731df2db40f6c7p3,
    -0x1.fffffep-1
  },
  { // Entry 319
    0x1.1542456b37d42c1c6b731df2db40f6c7p3,
    0x1.fffffep-1
  },
  { // Entry 320
    -0x1.0a2b23e3bab72e81aed0380eac971caep3,
    -0x1.fffffcp-1
  },
  { // Entry 321
    0x1.0a2b23e3bab72e81aed0380eac971caep3,
    0x1.fffffcp-1
  },
  { // Entry 322
    -0x1.03ae5ae08ad1118501202fc82197e98ep3,
    -0x1.fffffap-1
  },
  { // Entry 323
    0x1.03ae5ae08ad1118501202fc82197e98ep3,
    0x1.fffffap-1
  },
  { // Entry 324
    0x1.1542456b37d42c1c6b731df2db40f6c7p3,
    0x1.fffffep-1
  },
  { // Entry 325
    -0x1.1542456b37d42c1c6b731df2db40f6c7p3,
    -0x1.fffffep-1
  },
  { // Entry 326
    0x1.0a2b23e3bab72e81aed0380eac971caep3,
    0x1.fffffcp-1
  },
  { // Entry 327
    -0x1.0a2b23e3bab72e81aed0380eac971caep3,
    -0x1.fffffcp-1
  },
  { // Entry 328
    0x1.03ae5ae08ad1118501202fc82197e98ep3,
    0x1.fffffap-1
  },
  { // Entry 329
    -0x1.03ae5ae08ad1118501202fc82197e98ep3,
    -0x1.fffffap-1
  },
  { // Entry 330
    0x1.4a851923985f29e566d100aa672e9ae3p-3,
    0x1.47ae12p-3
  },
  { // Entry 331
    -0x1.4a851923985f29e566d100aa672e9ae3p-3,
    -0x1.47ae12p-3
  },
  { // Entry 332
    0x1.4a851b310bf87886f18db6831c7dbb5bp-3,
    0x1.47ae14p-3
  },
  { // Entry 333
    -0x1.4a851b310bf87886f18db6831c7dbb5bp-3,
    -0x1.47ae14p-3
  },
  { // Entry 334
    0x1.4a851d3e7f91f24c757b36332a215cb4p-3,
    0x1.47ae16p-3
  },
  { // Entry 335
    -0x1.4a851d3e7f91f24c757b36332a215cb4p-3,
    -0x1.47ae16p-3
  },
  { // Entry 336
    -0x1.4a851d3e7f91f24c757b36332a215cb4p-3,
    -0x1.47ae16p-3
  },
  { // Entry 337
    0x1.4a851d3e7f91f24c757b36332a215cb4p-3,
    0x1.47ae16p-3
  },
  { // Entry 338
    -0x1.4a851b310bf87886f18db6831c7dbb5bp-3,
    -0x1.47ae14p-3
  },
  { // Entry 339
    0x1.4a851b310bf87886f18db6831c7dbb5bp-3,
    0x1.47ae14p-3
  },
  { // Entry 340
    -0x1.4a851923985f29e566d100aa672e9ae3p-3,
    -0x1.47ae12p-3
  },
  { // Entry 341
    0x1.4a851923985f29e566d100aa672e9ae3p-3,
    0x1.47ae12p-3
  },
  { // Entry 342
    0x1.193ea6557adbc5e86add80b0ebf2cb85p-1,
    0x1.fffffep-2
  },
  { // Entry 343
    -0x1.193ea6557adbc5e86add80b0ebf2cb85p-1,
    -0x1.fffffep-2
  },
  { // Entry 344
    0x1.193ea7aad030a976a4198d55053b7cb5p-1,
    0x1.p-1
  },
  { // Entry 345
    -0x1.193ea7aad030a976a4198d55053b7cb5p-1,
    -0x1.p-1
  },
  { // Entry 346
    0x1.193eaa557add1b3dc34f47d111dfdba1p-1,
    0x1.000002p-1
  },
  { // Entry 347
    -0x1.193eaa557add1b3dc34f47d111dfdba1p-1,
    -0x1.000002p-1
  },
  { // Entry 348
    0x1.058aee9700341b95bc1c097b18171158p-2,
    0x1.fffffep-3
  },
  { // Entry 349
    -0x1.058aee9700341b95bc1c097b18171158p-2,
    -0x1.fffffep-3
  },
  { // Entry 350
    0x1.058aefa811451a7276bc2f82043b6a7dp-2,
    0x1.p-2
  },
  { // Entry 351
    -0x1.058aefa811451a7276bc2f82043b6a7dp-2,
    -0x1.p-2
  },
  { // Entry 352
    0x1.058af1ca33678565f2fe3a2d94083376p-2,
    0x1.000002p-2
  },
  { // Entry 353
    -0x1.058af1ca33678565f2fe3a2d94083376p-2,
    -0x1.000002p-2
  },
  { // Entry 354
    0x1.015890c5daae76a9c988ea53c9fdd571p-3,
    0x1.fffffep-4
  },
  { // Entry 355
    -0x1.015890c5daae76a9c988ea53c9fdd571p-3,
    -0x1.fffffep-4
  },
  { // Entry 356
    0x1.015891c9eaef7699467a0f6b916c6494p-3,
    0x1.p-3
  },
  { // Entry 357
    -0x1.015891c9eaef7699467a0f6b916c6494p-3,
    -0x1.p-3
  },
  { // Entry 358
    0x1.015893d20b718f3cd8df6c056dc045a9p-3,
    0x1.000002p-3
  },
  { // Entry 359
    -0x1.015893d20b718f3cd8df6c056dc045a9p-3,
    -0x1.000002p-3
  },
  { // Entry 360
    0x1.005587ac3659cdcc1515520e6dd371acp-4,
    0x1.fffffep-5
  },
  { // Entry 361
    -0x1.005587ac3659cdcc1515520e6dd371acp-4,
    -0x1.fffffep-5
  },
  { // Entry 362
    0x1.005588ad375acdcb1312a563c685255ep-4,
    0x1.p-4
  },
  { // Entry 363
    -0x1.005588ad375acdcb1312a563c685255ep-4,
    -0x1.p-4
  },
  { // Entry 364
    0x1.00558aaf395cd3d521277650da85a2b3p-4,
    0x1.000002p-4
  },
  { // Entry 365
    -0x1.00558aaf395cd3d521277650da85a2b3p-4,
    -0x1.000002p-4
  },
  { // Entry 366
    0x1.00155788dade20f3bd9fdc4d8c702791p-5,
    0x1.fffffep-6
  },
  { // Entry 367
    -0x1.00155788dade20f3bd9fdc4d8c702791p-5,
    -0x1.fffffep-6
  },
  { // Entry 368
    0x1.001558891aee24b49dd3fdc5b66ee9f1p-5,
    0x1.p-5
  },
  { // Entry 369
    -0x1.001558891aee24b49dd3fdc5b66ee9f1p-5,
    -0x1.p-5
  },
  { // Entry 370
    0x1.00155a899b0e2db71e84d97e04e64ed3p-5,
    0x1.000002p-5
  },
  { // Entry 371
    -0x1.00155a899b0e2db71e84d97e04e64ed3p-5,
    -0x1.000002p-5
  },
  { // Entry 372
    0x1.000554887ad0c98e0e3a70d6796dd00ap-6,
    0x1.fffffep-7
  },
  { // Entry 373
    -0x1.000554887ad0c98e0e3a70d6796dd00ap-6,
    -0x1.fffffep-7
  },
  { // Entry 374
    0x1.000555888ad1c98e0d3a562aced328b5p-6,
    0x1.p-6
  },
  { // Entry 375
    -0x1.000555888ad1c98e0d3a562aced328b5p-6,
    -0x1.p-6
  },
  { // Entry 376
    0x1.00055788aad3c9ee173b60f77d5e4818p-6,
    0x1.000002p-6
  },
  { // Entry 377
    -0x1.00055788aad3c9ee173b60f77d5e4818p-6,
    -0x1.000002p-6
  },
  { // Entry 378
    0x1.0001545884919d3b03f04f2aec3aad64p-7,
    0x1.fffffep-8
  },
  { // Entry 379
    -0x1.0001545884919d3b03f04f2aec3aad64p-7,
    -0x1.fffffep-8
  },
  { // Entry 380
    0x1.000155588891ad3743d14fc45da12ef2p-7,
    0x1.p-7
  },
  { // Entry 381
    -0x1.000155588891ad3743d14fc45da12ef2p-7,
    -0x1.p-7
  },
  { // Entry 382
    0x1.000157589091cd47c4535d7818762b69p-7,
    0x1.000002p-7
  },
  { // Entry 383
    -0x1.000157589091cd47c4535d7818762b69p-7,
    -0x1.000002p-7
  },
  { // Entry 384
    0x1.000054558788ac1bed20f7e1abb63c0bp-8,
    0x1.fffffep-9
  },
  { // Entry 385
    -0x1.000054558788ac1bed20f7e1abb63c0bp-8,
    -0x1.fffffep-9
  },
  { // Entry 386
    0x1.000055558888ad1aee1ef9340407975ap-8,
    0x1.p-8
  },
  { // Entry 387
    -0x1.000055558888ad1aee1ef9340407975ap-8,
    -0x1.p-8
  },
  { // Entry 388
    0x1.000057558a88af1ef026fdeac0c26c29p-8,
    0x1.000002p-8
  },
  { // Entry 389
    -0x1.000057558a88af1ef026fdeac0c26c29p-8,
    -0x1.000002p-8
  },
  { // Entry 390
    0x1.000014555848890b11c5ac88518c9f8bp-9,
    0x1.fffffep-10
  },
  { // Entry 391
    -0x1.000014555848890b11c5ac88518c9f8bp-9,
    -0x1.fffffep-10
  },
  { // Entry 392
    0x1.000015555888891ad1c98c9e9b0230f4p-9,
    0x1.p-9
  },
  { // Entry 393
    -0x1.000015555888891ad1c98c9e9b0230f4p-9,
    -0x1.p-9
  },
  { // Entry 394
    0x1.000017555908893bd1d20d4b76ad6c40p-9,
    0x1.000002p-9
  },
  { // Entry 395
    -0x1.000017555908893bd1d20d4b76ad6c40p-9,
    -0x1.000002p-9
  },
  { // Entry 396
    0x1.0000045555788889e1ad293e1f844b3dp-10,
    0x1.fffffep-11
  },
  { // Entry 397
    -0x1.0000045555788889e1ad293e1f844b3dp-10,
    -0x1.fffffep-11
  },
  { // Entry 398
    0x1.000005555588888ad1ad374375aba09fp-10,
    0x1.p-10
  },
  { // Entry 399
    -0x1.000005555588888ad1ad374375aba09fp-10,
    -0x1.p-10
  },
  { // Entry 400
    0x1.0000075555a8888d11ad5f6e23264b7cp-10,
    0x1.000002p-10
  },
  { // Entry 401
    -0x1.0000075555a8888d11ad5f6e23264b7cp-10,
    -0x1.000002p-10
  },
  { // Entry 402
    0x1.fffffe0aaaaa8b11112f15a3536b318fp-15,
    0x1.fffffep-15
  },
  { // Entry 403
    -0x1.fffffe0aaaaa8b11112f15a3536b318fp-15,
    -0x1.fffffep-15
  },
  { // Entry 404
    0x1.000000055555558888888ad1ad1aee1ep-14,
    0x1.p-14
  },
  { // Entry 405
    -0x1.000000055555558888888ad1ad1aee1ep-14,
    -0x1.p-14
  },
  { // Entry 406
    0x1.000002055555758888ca8ad1dfe598dap-14,
    0x1.000002p-14
  },
  { // Entry 407
    -0x1.000002055555758888ca8ad1dfe598dap-14,
    -0x1.000002p-14
  },
  { // Entry 408
    0x1.fffffe00000000aaaaa8aaaaacab1110p-29,
    0x1.fffffep-29
  },
  { // Entry 409
    -0x1.fffffe00000000aaaaa8aaaaacab1110p-29,
    -0x1.fffffep-29
  },
  { // Entry 410
    0x1.00000000000000555555555555558888p-28,
    0x1.p-28
  },
  { // Entry 411
    -0x1.00000000000000555555555555558888p-28,
    -0x1.p-28
  },
  { // Entry 412
    0x1.0000020000000055555755555955888bp-28,
    0x1.000002p-28
  },
  { // Entry 413
    -0x1.0000020000000055555755555955888bp-28,
    -0x1.000002p-28
  },
  { // Entry 414
    0x1.fffffe000000000aaaaa8aaaaacaab11p-31,
    0x1.fffffep-31
  },
  { // Entry 415
    -0x1.fffffe000000000aaaaa8aaaaacaab11p-31,
    -0x1.fffffep-31
  },
  { // Entry 416
    0x1.00000000000000055555555555555588p-30,
    0x1.p-30
  },
  { // Entry 417
    -0x1.00000000000000055555555555555588p-30,
    -0x1.p-30
  },
  { // Entry 418
    0x1.00000200000000055555755555955588p-30,
    0x1.000002p-30
  },
  { // Entry 419
    -0x1.00000200000000055555755555955588p-30,
    -0x1.000002p-30
  },
  { // Entry 420
    -0x1.193eaa557add1b3dc34f47d111dfdba1p-1,
    -0x1.000002p-1
  },
  { // Entry 421
    0x1.193eaa557add1b3dc34f47d111dfdba1p-1,
    0x1.000002p-1
  },
  { // Entry 422
    -0x1.193ea7aad030a976a4198d55053b7cb5p-1,
    -0x1.p-1
  },
  { // Entry 423
    0x1.193ea7aad030a976a4198d55053b7cb5p-1,
    0x1.p-1
  },
  { // Entry 424
    -0x1.193ea6557adbc5e86add80b0ebf2cb85p-1,
    -0x1.fffffep-2
  },
  { // Entry 425
    0x1.193ea6557adbc5e86add80b0ebf2cb85p-1,
    0x1.fffffep-2
  },
  { // Entry 426
    -0x1.058af1ca33678565f2fe3a2d94083376p-2,
    -0x1.000002p-2
  },
  { // Entry 427
    0x1.058af1ca33678565f2fe3a2d94083376p-2,
    0x1.000002p-2
  },
  { // Entry 428
    -0x1.058aefa811451a7276bc2f82043b6a7dp-2,
    -0x1.p-2
  },
  { // Entry 429
    0x1.058aefa811451a7276bc2f82043b6a7dp-2,
    0x1.p-2
  },
  { // Entry 430
    -0x1.058aee9700341b95bc1c097b18171158p-2,
    -0x1.fffffep-3
  },
  { // Entry 431
    0x1.058aee9700341b95bc1c097b18171158p-2,
    0x1.fffffep-3
  },
  { // Entry 432
    -0x1.015893d20b718f3cd8df6c056dc045a9p-3,
    -0x1.000002p-3
  },
  { // Entry 433
    0x1.015893d20b718f3cd8df6c056dc045a9p-3,
    0x1.000002p-3
  },
  { // Entry 434
    -0x1.015891c9eaef7699467a0f6b916c6494p-3,
    -0x1.p-3
  },
  { // Entry 435
    0x1.015891c9eaef7699467a0f6b916c6494p-3,
    0x1.p-3
  },
  { // Entry 436
    -0x1.015890c5daae76a9c988ea53c9fdd571p-3,
    -0x1.fffffep-4
  },
  { // Entry 437
    0x1.015890c5daae76a9c988ea53c9fdd571p-3,
    0x1.fffffep-4
  },
  { // Entry 438
    -0x1.00558aaf395cd3d521277650da85a2b3p-4,
    -0x1.000002p-4
  },
  { // Entry 439
    0x1.00558aaf395cd3d521277650da85a2b3p-4,
    0x1.000002p-4
  },
  { // Entry 440
    -0x1.005588ad375acdcb1312a563c685255ep-4,
    -0x1.p-4
  },
  { // Entry 441
    0x1.005588ad375acdcb1312a563c685255ep-4,
    0x1.p-4
  },
  { // Entry 442
    -0x1.005587ac3659cdcc1515520e6dd371acp-4,
    -0x1.fffffep-5
  },
  { // Entry 443
    0x1.005587ac3659cdcc1515520e6dd371acp-4,
    0x1.fffffep-5
  },
  { // Entry 444
    -0x1.00155a899b0e2db71e84d97e04e64ed3p-5,
    -0x1.000002p-5
  },
  { // Entry 445
    0x1.00155a899b0e2db71e84d97e04e64ed3p-5,
    0x1.000002p-5
  },
  { // Entry 446
    -0x1.001558891aee24b49dd3fdc5b66ee9f1p-5,
    -0x1.p-5
  },
  { // Entry 447
    0x1.001558891aee24b49dd3fdc5b66ee9f1p-5,
    0x1.p-5
  },
  { // Entry 448
    -0x1.00155788dade20f3bd9fdc4d8c702791p-5,
    -0x1.fffffep-6
  },
  { // Entry 449
    0x1.00155788dade20f3bd9fdc4d8c702791p-5,
    0x1.fffffep-6
  },
  { // Entry 450
    -0x1.00055788aad3c9ee173b60f77d5e4818p-6,
    -0x1.000002p-6
  },
  { // Entry 451
    0x1.00055788aad3c9ee173b60f77d5e4818p-6,
    0x1.000002p-6
  },
  { // Entry 452
    -0x1.000555888ad1c98e0d3a562aced328b5p-6,
    -0x1.p-6
  },
  { // Entry 453
    0x1.000555888ad1c98e0d3a562aced328b5p-6,
    0x1.p-6
  },
  { // Entry 454
    -0x1.000554887ad0c98e0e3a70d6796dd00ap-6,
    -0x1.fffffep-7
  },
  { // Entry 455
    0x1.000554887ad0c98e0e3a70d6796dd00ap-6,
    0x1.fffffep-7
  },
  { // Entry 456
    -0x1.000157589091cd47c4535d7818762b69p-7,
    -0x1.000002p-7
  },
  { // Entry 457
    0x1.000157589091cd47c4535d7818762b69p-7,
    0x1.000002p-7
  },
  { // Entry 458
    -0x1.000155588891ad3743d14fc45da12ef2p-7,
    -0x1.p-7
  },
  { // Entry 459
    0x1.000155588891ad3743d14fc45da12ef2p-7,
    0x1.p-7
  },
  { // Entry 460
    -0x1.0001545884919d3b03f04f2aec3aad64p-7,
    -0x1.fffffep-8
  },
  { // Entry 461
    0x1.0001545884919d3b03f04f2aec3aad64p-7,
    0x1.fffffep-8
  },
  { // Entry 462
    -0x1.000057558a88af1ef026fdeac0c26c29p-8,
    -0x1.000002p-8
  },
  { // Entry 463
    0x1.000057558a88af1ef026fdeac0c26c29p-8,
    0x1.000002p-8
  },
  { // Entry 464
    -0x1.000055558888ad1aee1ef9340407975ap-8,
    -0x1.p-8
  },
  { // Entry 465
    0x1.000055558888ad1aee1ef9340407975ap-8,
    0x1.p-8
  },
  { // Entry 466
    -0x1.000054558788ac1bed20f7e1abb63c0bp-8,
    -0x1.fffffep-9
  },
  { // Entry 467
    0x1.000054558788ac1bed20f7e1abb63c0bp-8,
    0x1.fffffep-9
  },
  { // Entry 468
    -0x1.000017555908893bd1d20d4b76ad6c40p-9,
    -0x1.000002p-9
  },
  { // Entry 469
    0x1.000017555908893bd1d20d4b76ad6c40p-9,
    0x1.000002p-9
  },
  { // Entry 470
    -0x1.000015555888891ad1c98c9e9b0230f4p-9,
    -0x1.p-9
  },
  { // Entry 471
    0x1.000015555888891ad1c98c9e9b0230f4p-9,
    0x1.p-9
  },
  { // Entry 472
    -0x1.000014555848890b11c5ac88518c9f8bp-9,
    -0x1.fffffep-10
  },
  { // Entry 473
    0x1.000014555848890b11c5ac88518c9f8bp-9,
    0x1.fffffep-10
  },
  { // Entry 474
    -0x1.0000075555a8888d11ad5f6e23264b7cp-10,
    -0x1.000002p-10
  },
  { // Entry 475
    0x1.0000075555a8888d11ad5f6e23264b7cp-10,
    0x1.000002p-10
  },
  { // Entry 476
    -0x1.000005555588888ad1ad374375aba09fp-10,
    -0x1.p-10
  },
  { // Entry 477
    0x1.000005555588888ad1ad374375aba09fp-10,
    0x1.p-10
  },
  { // Entry 478
    -0x1.0000045555788889e1ad293e1f844b3dp-10,
    -0x1.fffffep-11
  },
  { // Entry 479
    0x1.0000045555788889e1ad293e1f844b3dp-10,
    0x1.fffffep-11
  },
  { // Entry 480
    -0x1.000002055555758888ca8ad1dfe598dap-14,
    -0x1.000002p-14
  },
  { // Entry 481
    0x1.000002055555758888ca8ad1dfe598dap-14,
    0x1.000002p-14
  },
  { // Entry 482
    -0x1.000000055555558888888ad1ad1aee1ep-14,
    -0x1.p-14
  },
  { // Entry 483
    0x1.000000055555558888888ad1ad1aee1ep-14,
    0x1.p-14
  },
  { // Entry 484
    -0x1.fffffe0aaaaa8b11112f15a3536b318fp-15,
    -0x1.fffffep-15
  },
  { // Entry 485
    0x1.fffffe0aaaaa8b11112f15a3536b318fp-15,
    0x1.fffffep-15
  },
  { // Entry 486
    -0x1.0000020000000055555755555955888bp-28,
    -0x1.000002p-28
  },
  { // Entry 487
    0x1.0000020000000055555755555955888bp-28,
    0x1.000002p-28
  },
  { // Entry 488
    -0x1.00000000000000555555555555558888p-28,
    -0x1.p-28
  },
  { // Entry 489
    0x1.00000000000000555555555555558888p-28,
    0x1.p-28
  },
  { // Entry 490
    -0x1.fffffe00000000aaaaa8aaaaacab1110p-29,
    -0x1.fffffep-29
  },
  { // Entry 491
    0x1.fffffe00000000aaaaa8aaaaacab1110p-29,
    0x1.fffffep-29
  },
  { // Entry 492
    -0x1.00000200000000055555755555955588p-30,
    -0x1.000002p-30
  },
  { // Entry 493
    0x1.00000200000000055555755555955588p-30,
    0x1.000002p-30
  },
  { // Entry 494
    -0x1.00000000000000055555555555555588p-30,
    -0x1.p-30
  },
  { // Entry 495
    0x1.00000000000000055555555555555588p-30,
    0x1.p-30
  },
  { // Entry 496
    -0x1.fffffe000000000aaaaa8aaaaacaab11p-31,
    -0x1.fffffep-31
  },
  { // Entry 497
    0x1.fffffe000000000aaaaa8aaaaacaab11p-31,
    0x1.fffffep-31
  },
  { // Entry 498
    HUGE_VALF,
    0x1.p0
  },
  { // Entry 499
    -HUGE_VALF,
    -0x1.p0
  },
  { // Entry 500
    0x1.1542456b37d42c1c6b731df2db40f6c7p3,
    0x1.fffffep-1
  },
  { // Entry 501
    -0x1.1542456b37d42c1c6b731df2db40f6c7p3,
    -0x1.fffffep-1
  },
  { // Entry 502
    0x1.0f2eb16521912336da989907b42e8493p0,
    0x1.921fb6p-1
  },
  { // Entry 503
    -0x1.0f2eb16521912336da989907b42e8493p0,
    -0x1.921fb6p-1
  },
  { // Entry 504
    0x1.000002p-126,
    0x1.000002p-126
  },
  { // Entry 505
    -0x1.000002p-126,
    -0x1.000002p-126
  },
  { // Entry 506
    0x1.p-126,
    0x1.p-126
  },
  { // Entry 507
    -0x1.p-126,
    -0x1.p-126
  },
  { // Entry 508
    0x1.fffffcp-127,
    0x1.fffffcp-127
  },
  { // Entry 509
    -0x1.fffffcp-127,
    -0x1.fffffcp-127
  },
  { // Entry 510
    0x1.fffff8p-127,
    0x1.fffff8p-127
  },
  { // Entry 511
    -0x1.fffff8p-127,
    -0x1.fffff8p-127
  },
  { // Entry 512
    0x1.p-148,
    0x1.p-148
  },
  { // Entry 513
    -0x1.p-148,
    -0x1.p-148
  },
  { // Entry 514
    0x1.p-149,
    0x1.p-149
  },
  { // Entry 515
    -0x1.p-149,
    -0x1.p-149
  },
  { // Entry 516
    0.0,
    0.0f
  },
  { // Entry 517
    -0.0,
    -0.0f
  }
};
