/*
 * Copyright (C) 2018 The Android Open Source Project
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

static const std::vector<float> sincosf_input0 = {
  0x1.459afcp-4,
  0x1.59abp-5,
  0x1.446ee6p-7,
  0x1.97d07ap-7,
  0x1.b03726p-5,
  0x1.1f609ap-8,
  0x1.85ffd8p-6,
  0x1.2e341p-5,
  0x1.d49c2p-7,
  0x1.a7d716p-6,
  0x1.8240e6p-7,
  0x1.58c1f6p-4,
  0x1.616cbep-5,
  0x1.98133ap-5,
  0x1.dcca54p-7,
  0x1.2a152ap-6,
  0x1.f6894ep-8,
  0x1.33ca2ap-4,
  0x1.5ae214p-5,
  0x1.b12626p-5,
  0x1.7d1e4cp-5,
  0x1.175212p-4,
  0x1.0ec2e6p-10,
  0x1.a9c074p-12,
  0x1.e1a29p-6,
  0x1.c5fd4p-7,
  0x1.1dcd4ep-4,
  0x1.9372c6p-8,
  0x1.0af046p-4,
  0x1.67b5e4p-4,
  0x1.fba9eep-6,
  0x1.0537a6p-4,
  0x1.c4376ep-5,
  0x1.7f9a5cp-5,
  0x1.9bb62p-6,
  0x1.b2a32ap-5,
  0x1.5b2058p-6,
  0x1.3ba422p-4,
  0x1.c66dc4p-5,
  0x1.30b1dap-6,
  0x1.64463cp-4,
  0x1.d3224ap-7,
  0x1.c111b6p-5,
  0x1.a8b876p-5,
  0x1.ea528ap-6,
  0x1.94b15ap-5,
  0x1.181806p-5,
  0x1.91fp-4,
  0x1.773656p-4,
  0x1.40272cp-7,
  0x1.e3b15ap-5,
  0x1.385f2ap-5,
  0x1.809466p-4,
  0x1.567efcp-5,
  0x1.0f722cp-4,
  0x1.4ffb48p-4,
  0x1.b37876p-6,
  0x1.4a32e8p-9,
  0x1.74b446p-4,
  0x1.f0ba44p-5,
  0x1.f0157p-6,
  0x1.172bfcp-6,
  0x1.650236p-5,
  0x1.31539ap-6,
  0x1.eda106p-5,
  0x1.8ed322p-4,
  0x1.4f016ep-5,
  0x1.6edfcep-7,
  0x1.f13d4p-6,
  0x1.188416p-4,
  0x1.ad35a6p-6,
  0x1.38c4f6p-7,
  0x1.fb2f56p-6,
  0x1.0ba31cp-6,
  0x1.4db74p-8,
  0x1.7ce126p-4,
  0x1.f1c1e6p-5,
  0x1.3049c2p-4,
  0x1.9d91c6p-5,
  0x1.e81efep-6,
  0x1.da11ep-5,
  0x1.bb9026p-5,
  0x1.dc4d4ep-5,
  0x1.d02f2p-6,
  0x1.8401b6p-4,
  0x1.f9c19ep-5,
  0x1.4b59d8p-6,
  0x1.64a4eep-4,
  0x1.ff6f94p-5,
  0x1.79d102p-5,
  0x1.78f09ep-6,
  0x1.79b4e8p-4,
  0x1.12e79ep-4,
  0x1.1e7c9p-5,
  0x1.100d5ap-4,
  0x1.2cfc6ep-7,
  0x1.f7d13ap-5,
  0x1.7d5eacp-5,
  0x1.24b4acp-4,
  0x1.98213ep-5,
  0x1.472d6cp-9,
  0x1.a5ce6ap-5,
  0x1.c88b8ap-6,
  0x1.1cdcfap-5,
  0x1.0c2cf2p-4,
  0x1.f38a4p-5,
  0x1.001742p-7,
  0x1.8b0f1p-5,
  0x1.30a95p-4,
  0x1.dde28ep-5,
  0x1.133a3cp-5,
  0x1.86af2p-7,
  0x1.47352ap-4,
  0x1.2c5f3p-4,
  0x1.b582bep-10,
  0x1.48acbp-5,
  0x1.399514p-4,
  0x1.36eb06p-5,
  0x1.0b3556p-7,
  0x1.6419eep-4,
  0x1.878de2p-4,
  0x1.74863p-4,
  0x1.eaf13p-6,
  0x1.8b5976p-5,
  0x1.443812p-4,
  0x1.07023ep-6,
  0x1.f732c4p-8,
  0x1.37bad4p-4,
  0x1.2ed27p-4,
  0x1.78e61ap-4,
  0x1.ffbeeep-5,
  0x1.74a066p-4,
  0x1.f637ep-5,
  0x1.6d472ep-4,
  0x1.3582fep-4,
  0x1.d99544p-5,
  0x1.17be36p-8,
  0x1.6a1f26p-4,
  0x1.df4a3ap-5,
  0x1.6edb54p-4,
  0x1.755816p-5,
  0x1.4f0adep-5,
  0x1.be03ep-6,
  0x1.46c94ap-5,
  0x1.86237ep-5,
  0x1.667686p-4,
  0x1.669efcp-4,
  0x1.21624ep-5,
  0x1.f11174p-7,
  0x1.ddb66ap-7,
  0x1.efd4dap-7,
  0x1.d012e6p-5,
  0x1.1a082ep-4,
  0x1.c70534p-6,
  0x1.ced2dap-5,
  0x1.9b4934p-8,
  0x1.8fa3ecp-4,
  0x1.a458dep-7,
  0x1.ef29c6p-6,
  0x1.ee9f1p-6,
  0x1.6cf89p-4,
  0x1.5d1e4p-5,
  0x1.11154cp-4,
  0x1.600fe4p-4,
  0x1.e8dd76p-5,
  0x1.1a6f38p-4,
  0x1.3cfcbep-4,
  0x1.59372p-5,
  0x1.2114d2p-4,
  0x1.f4347ap-7,
  0x1.07d586p-4,
  0x1.865ae8p-4,
  0x1.87f3e4p-4,
  0x1.34d92ep-4,
  0x1.024cd4p-6,
  0x1.51b154p-5,
  0x1.602f06p-4,
  0x1.0cc1fep-6,
  0x1.00bff8p-5,
  0x1.6a3cf4p-4,
  0x1.6aeba6p-5,
  0x1.047078p-4,
  0x1.f12fe6p-10,
  0x1.9c5776p-9,
  0x1.8b73a4p-5,
  0x1.1bb78cp-7,
  0x1.694cc2p-5,
  0x1.3f149ap-4,
  0x1.1058dp-4,
  0x1.6d45b6p-5,
  0x1.23daa6p-4,
  0x1.015308p-4,
  0x1.6a7506p-4,
  0x1.73314ep-6,
  0x1.c80b24p-5,
  0x1.b25a2p-7,
  0x1.3cfc88p-5,
  0x1.998078p-5,
  0x1.fe3c4ep-11,
  0x1.806876p-6,
  0x1.dc44bp-5,
  0x1.b93836p-5,
  0x1.811c4cp-5,
  0x1.a95a2p-5,
  0x1.c9b6fep-5,
  0x1.be8a14p-6,
  0x1.06867ep-4,
  0x1.557f24p-4,
  0x1.95c78ep-4,
  0x1.aaaa6ep-5,
  0x1.2487a8p-4,
  0x1.2c000ep-6,
  0x1.9279c4p-5,
  0x1.9753c6p-6,
  0x1.d3544p-5,
  0x1.354a76p-5,
  0x1.b9f544p-5,
  0x1.08f782p-9,
  0x1.6c41p-5,
  0x1.1fdc9p-4,
  0x1.40beap-4,
  0x1.2b358ep-5,
  0x1.247e5ap-4,
  0x1.db7916p-6,
  0x1.7c4a2cp-7,
  0x1.5aafe4p-4,
  0x1.46e4ecp-5,
  0x1.30a74ep-4,
  0x1.093388p-4,
  0x1.d75e96p-5,
  0x1.52839p-4,
  0x1.4d3adep-4,
  0x1.0c02cep-5,
  0x1.30cc2p-9,
  0x1.83d762p-6,
  0x1.5b2848p-7,
  0x1.82b852p-5,
  0x1.7e2c88p-4,
  0x1.8afb06p-4,
  0x1.a45806p-6,
  0x1.d9b764p-7,
  0x1.6fe366p-5,
  0x1.9ae58ap-5,
  0x1.201ce4p-5,
  0x1.05fb7ap-5,
  0x1.aed9eap-5,
  0x1.4f37b4p-6,
  0x1.233a3ap-4,
  0x1.475b46p-5,
  0x1.0fa902p-4,
  0x1.0afbacp-4,
  0x1.4cb46p-6,
  0x1.5f14a8p-4,
  0x1.0e1fcep-4,
  0x1.73f4e6p-4,
  0x1.167076p-5,
  0x1.1cc472p-6,
  0x1.8af546p-4,
  0x1.0b1a86p-4,
  0x1.f8476ap-5,
  0x1.ca82fap-7,
  0x1.1af77ep-4,
  0x1.cc9aa6p-5,
  0x1.344876p-5,
  0x1.379a8ep-7,
  0x1.17f1eep-6,
  0x1.9655b6p-6,
  0x1.8460e8p-4,
  0x1.13cfc2p-8,
  0x1.d6621ap-5,
  0x1.7f3374p-4,
  0x1.0e27b8p-6,
  0x1.20f2b6p-4,
  0x1.d14cbp-6,
  0x1.a5bc3ep-6,
  0x1.970eb6p-9,
  0x1.2c74f6p-4,
  0x1.9350a6p-4,
  0x1.6ed0a8p-4,
  0x1.a1b104p-5,
  0x1.9e69bep-5,
  0x1.53e41p-4,
  0x1.82c90ep-15,
  0x1.925566p-5,
  0x1.67707ep-4,
  0x1.656e26p-4,
  0x1.5813cep-5,
  0x1.aaf276p-7,
  0x1.4f6d6p-4,
  0x1.b0b68p-6,
  0x1.537cd2p-6,
  0x1.88474ep-4,
  0x1.2c4bfep-6,
  0x1.5a1412p-6,
  0x1.371b5cp-5,
  0x1.620588p-4,
  0x1.0fc7eep-4,
  0x1.a10ad6p-10,
  0x1.5c502ep-4,
  0x1.17f6f6p-12,
  0x1.b43b36p-6,
  0x1.3b77acp-9,
  0x1.c6d36ap-5,
  0x1.cf0e6p-5,
  0x1.2288e2p-6,
  0x1.669acep-4,
  0x1.07548p-9,
  0x1.dee49ep-7,
  0x1.ab6cdap-7,
  0x1.975b6cp-5,
  0x1.32e408p-4,
  0x1.cfb5bap-6,
  0x1.b7841ep-6,
  0x1.c39f6ep-5,
  0x1.3602d2p-6,
  0x1.f8aa26p-5,
  0x1.824ac6p-4,
  0x1.6a3a2ap-4,
  0x1.5b319p-4,
  0x1.c821c4p-5,
  0x1.f919eap-8,
  0x1.88cd0cp-7,
  0x1.59ec98p-6,
  0x1.342db8p-4,
  0x1.83581cp-5,
  0x1.afeeaap-8,
  0x1.058496p-4,
  0x1.11a38ep-15,
  0x1.2542f4p-4,
  0x1.e5e0dp-8,
  0x1.8db9cep-5,
  0x1.758012p-4,
  0x1.d6ee9ep-6,
  0x1.3ed86cp-4,
  0x1.a77584p-6,
  0x1.7ddee6p-5,
  0x1.77bd66p-5,
  0x1.347638p-6,
  0x1.fb3ffap-5,
  0x1.ffe06p-7,
  0x1.8f0976p-5,
  0x1.8b773ap-4,
  0x1.83285ep-4,
  0x1.fe767ep-7,
  0x1.f5748ep-5,
  0x1.93c3eap-6,
  0x1.4f772ep-5,
  0x1.0b51aep-7,
  0x1.5efc64p-10,
  0x1.3f02p-5,
  0x1.61d4bep-8,
  0x1.264688p-4,
  0x1.85681ap-5,
  0x1.396aa2p-4,
  0x1.1c1bcep-7,
  0x1.bce02ap-5,
  0x1.df8f1ap-11,
  0x1.2ede78p-5,
  0x1.96220ep-5,
  0x1.5aef2cp-5,
  0x1.c14106p-5,
  0x1.1cfc82p-6,
  0x1.1e3b9ap-5,
  0x1.302d5p-5,
  0x1.59b9d8p-4,
  0x1.e1491ep-5,
  0x1.fd6b1p-5,
  0x1.6e6abp-6,
  0x1.69a978p-6,
  0x1.05166p-4,
  0x1.5158ccp-4,
  0x1.17ae4ap-6,
  0x1.750996p-4,
  0x1.4e2d9ap-5,
  0x1.5c792ap-4,
  0x1.468d7ep-7,
  0x1.5a0cbep-6,
  0x1.1be7b2p-4,
  0x1.b97d06p-5,
  0x1.9165f8p-10,
  0x1.6bf068p-4,
  0x1.6f991cp-4,
  0x1.cdeeap-8,
  0x1.0e3e6ap-5,
  0x1.a9b8f6p-5,
  0x1.2882ccp-4,
  0x1.e87436p-7,
  0x1.9cdf6ep-5,
  0x1.2f18dep-7,
  0x1.4de616p-9,
  0x1.6a9554p-4,
  0x1.a1a8ap-5,
  0x1.8301e8p-4,
  0x1.76fdeap-6,
  0x1.20367ep-4,
  0x1.137d0cp-5,
  0x1.0911cep-4,
  0x1.f6c27ep-5,
  0x1.ccf49ep-5,
  0x1.4efd48p-5,
  0x1.9408c8p-4,
  0x1.fbbe3ep-5,
  0x1.210dcap-4,
  0x1.1a7786p-7,
  0x1.6fb552p-4,
  0x1.4a435ep-4,
  0x1.937036p-5,
  0x1.6ee204p-4,
  0x1.8639bep-4,
  0x1.50b8aep-4,
  0x1.54e32p-8,
  0x1.4ba9fep-4,
  0x1.1a9c5p-4,
  0x1.6ea838p-4,
  0x1.94622ap-4,
  0x1.7fd3aep-4,
  0x1.45fb3ep-6,
  0x1.88fec2p-6,
  0x1.3103c6p-5,
  0x1.da44c6p-5,
  0x1.4b3eb8p-5,
  0x1.4dbd88p-7,
  0x1.93d294p-7,
  0x1.b1c6cap-6,
  0x1.1e1324p-5,
  0x1.9c0a5p-13,
  0x1.83542ep-4,
  0x1.b0636p-9,
  0x1.b1ea2ap-6,
  0x1.c66f04p-6,
  0x1.5b2cbcp-5,
  0x1.8cfb36p-4,
  0x1.846eeep-4,
  0x1.07e2bep-5,
  0x1.9b6406p-5,
  0x1.db943ap-9,
  0x1.cb3e26p-5,
  0x1.095ddep-4,
  0x1.5ae608p-5,
  0x1.40ee8ap-5,
  0x1.a0268ep-6,
  0x1.e74ecp-6,
  0x1.554a44p-4,
  0x1.8a38p-8,
  0x1.e9cd2ap-6,
  0x1.a10374p-5,
  0x1.90ea2ep-4,
  0x1.0564b6p-5,
  0x1.83fac6p-4,
  0x1.bb7f86p-5,
  0x1.6c83dap-6,
  0x1.bd50fep-5,
  0x1.33e4fcp-4,
  0x1.df8124p-6,
  0x1.c9b6fp-5,
  0x1.4ff75ap-4,
  0x1.3d5356p-4,
  0x1.80fcc4p-4,
  0x1.8e4c7ep-6,
  0x1.94cbbap-5,
  0x1.da5cf6p-5,
  0x1.400d5cp-4,
  0x1.b70786p-6,
  0x1.d7895p-10,
  0x1.a53c84p-7,
  0x1.1a3b8p-4,
  0x1.55e476p-4,
  0x1.d3a11p-5,
  0x1.4ad8c8p-4,
  0x1.39b0aep-4,
  0x1.6452bcp-5,
  0x1.34bae2p-9,
  0x1.10a36ap-5,
  0x1.e6f4dp-7,
  0x1.56dc64p-5,
  0x1.dc63p-6,
  0x1.a0d92ep-6,
  0x1.66b49ap-6,
  0x1.4cea18p-5,
  0x1.3b7526p-4,
  0x1.0497ecp-4,
  0x1.2825fep-4,
  0x1.9b23cep-7,
  0x1.4300d6p-4,
  0x1.899a26p-6,
  0x1.1090fep-4,
  0x1.13912ep-4,
  0x1.01726ap-4,
  0x1.443886p-4,
  0x1.d20b86p-5,
  0x1.13fe36p-4,
  0x1.25db14p-5,
  0x1.9dcb6p-6,
  0x1.7002ep-4,
  0x1.08bfc8p-6,
  0x1.9536dap-4,
  0x1.6bdfaep-6,
  0x1.172e76p-4,
  0x1.6fa03p-4,
  0x1.e5ccfap-6,
  0x1.3a7106p-4,
  0x1.35a09ep-4,
  0x1.7da25ep-4,
  0x1.f9749ep-6,
  0x1.d889p-8,
  0x1.3b7ab2p-7,
  0x1.0c464cp-4,
  0x1.814c0ep-4,
  0x1.30b25ap-4,
  0x1.80f212p-10,
  0x1.c301fp-5,
  0x1.21fb16p-4,
};
static const std::vector<float> sincosf_input1 = {
  0x1.3abdd4p-2,
  0x1.5f3bcap-2,
  0x1.a6afd4p-3,
  0x1.137a5ep-2,
  0x1.ad273p-2,
  0x1.8033fcp-3,
  0x1.030016p-2,
  0x1.48f07ap-1,
  0x1.5bc7c8p-1,
  0x1.41605ap-2,
  0x1.47d10cp-1,
  0x1.4094a4p-1,
  0x1.2ac11p-2,
  0x1.7c23p-2,
  0x1.8bc87cp-2,
  0x1.d66c0cp-3,
  0x1.4a34aap-1,
  0x1.e10218p-2,
  0x1.31e672p-2,
  0x1.1770f2p-3,
  0x1.2879dep-2,
  0x1.be261ep-3,
  0x1.565cfcp-3,
  0x1.e1d7bp-3,
  0x1.2246a6p-1,
  0x1.c49eecp-3,
  0x1.e9e46ep-2,
  0x1.482cbcp-1,
  0x1.959cdcp-2,
  0x1.20be2p-2,
  0x1.90410ap-2,
  0x1.9ca6ccp-4,
  0x1.5a5d0cp-1,
  0x1.8f2042p-2,
  0x1.51cd86p-1,
  0x1.4178a2p-2,
  0x1.5b9516p-1,
  0x1.0fe872p-1,
  0x1.0412c8p-1,
  0x1.18c058p-1,
  0x1.1b902p-3,
  0x1.363d0ap-1,
  0x1.3d3352p-3,
  0x1.2a7b02p-1,
  0x1.3299d6p-1,
  0x1.a2638p-2,
  0x1.94b1c2p-3,
  0x1.4a819ep-3,
  0x1.c224a6p-2,
  0x1.6fb556p-2,
  0x1.fa9ceap-2,
  0x1.3c8d82p-1,
  0x1.54b60cp-1,
  0x1.ca258ap-4,
  0x1.d45be4p-3,
  0x1.39ec8ep-1,
  0x1.b5abep-3,
  0x1.965b6cp-3,
  0x1.a326fp-2,
  0x1.4eb8fcp-1,
  0x1.dc9d7p-2,
  0x1.165044p-1,
  0x1.c6a0e6p-4,
  0x1.6d1326p-2,
  0x1.10e5p-1,
  0x1.54f77cp-1,
  0x1.f433e2p-2,
  0x1.ef71ccp-3,
  0x1.88083ep-3,
  0x1.30927ap-1,
  0x1.005594p-1,
  0x1.8741b6p-2,
  0x1.1c42fp-3,
  0x1.e7acdep-2,
  0x1.05addep-3,
  0x1.7b88b4p-2,
  0x1.534638p-1,
  0x1.ff31acp-2,
  0x1.1ffd52p-1,
  0x1.a840ap-3,
  0x1.1e0264p-2,
  0x1.298abep-2,
  0x1.45e47cp-1,
  0x1.dd28f8p-3,
  0x1.480552p-2,
  0x1.0a3298p-1,
  0x1.537fc4p-1,
  0x1.4839d6p-2,
  0x1.048ed6p-1,
  0x1.3a9f1cp-3,
  0x1.30c616p-1,
  0x1.41c0e6p-1,
  0x1.63d6a2p-1,
  0x1.7e65f4p-3,
  0x1.3928a4p-1,
  0x1.2407c4p-1,
  0x1.836478p-2,
  0x1.3ffc1ap-1,
  0x1.1b5c8ep-2,
  0x1.f5d7f2p-2,
  0x1.7ff8dp-3,
  0x1.985f78p-3,
  0x1.b4bbbp-2,
  0x1.3db736p-2,
  0x1.5ec1fcp-2,
  0x1.3cde1p-1,
  0x1.33db4ap-2,
  0x1.ce8c1cp-2,
  0x1.1d2b86p-3,
  0x1.124382p-3,
  0x1.d04c2p-3,
  0x1.387104p-1,
  0x1.4c2048p-1,
  0x1.5bb824p-2,
  0x1.0ccfe2p-1,
  0x1.17d232p-1,
  0x1.4e5778p-1,
  0x1.01ebd4p-3,
  0x1.4d1fcp-2,
  0x1.06fabep-1,
  0x1.98352cp-3,
  0x1.4b23bep-2,
  0x1.d3dcdcp-3,
  0x1.1d406ap-3,
  0x1.0f8c18p-3,
  0x1.affb4ep-2,
  0x1.1153bap-1,
  0x1.1f881p-3,
  0x1.f4e204p-2,
  0x1.1c374ep-1,
  0x1.65246p-1,
  0x1.9a3b78p-2,
  0x1.2623p-1,
  0x1.755afap-3,
  0x1.86965ep-3,
  0x1.8fddc4p-3,
  0x1.9e5462p-2,
  0x1.e6c75ep-2,
  0x1.15f3b8p-1,
  0x1.5e26b6p-1,
  0x1.cd645ep-2,
  0x1.1d23ep-2,
  0x1.03edd6p-1,
  0x1.0f14dp-1,
  0x1.94b5b8p-2,
  0x1.3c3f98p-1,
  0x1.93d104p-3,
  0x1.b477d6p-4,
  0x1.44bc34p-3,
  0x1.d4dbcep-2,
  0x1.f6f502p-4,
  0x1.9d4676p-2,
  0x1.079638p-2,
  0x1.ef7f1cp-4,
  0x1.07cfb2p-1,
  0x1.b51fap-3,
  0x1.5ece0ep-1,
  0x1.1da3a2p-2,
  0x1.679c66p-2,
  0x1.1fb512p-1,
  0x1.201234p-1,
  0x1.93165ep-2,
  0x1.6c9bep-2,
  0x1.2ff44cp-3,
  0x1.3ee1e4p-1,
  0x1.0d1ddap-1,
  0x1.75c5acp-2,
  0x1.e05368p-2,
  0x1.66e30ep-2,
  0x1.3ce67p-1,
  0x1.b51598p-2,
  0x1.61f6f2p-1,
  0x1.0799b2p-1,
  0x1.53871p-2,
  0x1.5ce61p-1,
  0x1.5ff6c2p-1,
  0x1.0178a4p-1,
  0x1.0826e8p-2,
  0x1.4264bep-2,
  0x1.0ee04ap-2,
  0x1.8c43acp-2,
  0x1.4cf434p-3,
  0x1.029decp-1,
  0x1.5a48p-1,
  0x1.3f0a4ap-1,
  0x1.47f17cp-1,
  0x1.066be2p-2,
  0x1.4505cp-1,
  0x1.02ca14p-1,
  0x1.1c552ap-3,
  0x1.a3a7d4p-3,
  0x1.2984f8p-3,
  0x1.a3e09cp-2,
  0x1.6a4534p-2,
  0x1.9dac9p-3,
  0x1.c0f7c8p-3,
  0x1.39c1bp-2,
  0x1.be501ap-4,
  0x1.dd4edp-2,
  0x1.009c34p-3,
  0x1.2f4cecp-1,
  0x1.b70a1ep-2,
  0x1.59485ap-1,
  0x1.37f36ap-1,
  0x1.faef0ep-2,
  0x1.36f514p-1,
  0x1.4fc098p-1,
  0x1.ee479p-4,
  0x1.1f3a4ep-2,
  0x1.04ff68p-3,
  0x1.7f0a6ep-3,
  0x1.ed3544p-3,
  0x1.0762eep-1,
  0x1.a31526p-2,
  0x1.c4a2f2p-2,
  0x1.30f7aap-1,
  0x1.cdae98p-2,
  0x1.4207f6p-1,
  0x1.56d3c8p-3,
  0x1.4a60fcp-1,
  0x1.49a194p-1,
  0x1.ed6a6ap-4,
  0x1.5b3d5ap-1,
  0x1.7c913cp-3,
  0x1.ba8444p-3,
  0x1.9f2f82p-3,
  0x1.03d10ap-2,
  0x1.57980cp-3,
  0x1.e36694p-2,
  0x1.fb703ep-2,
  0x1.43bcb4p-2,
  0x1.2473c4p-2,
  0x1.0d055cp-1,
  0x1.3e7f28p-2,
  0x1.ec6568p-2,
  0x1.89cd6cp-2,
  0x1.e589cp-2,
  0x1.38a12cp-1,
  0x1.7b565p-2,
  0x1.c7a51cp-2,
  0x1.de2fdp-2,
  0x1.086912p-1,
  0x1.02bccp-2,
  0x1.4a6ab2p-2,
  0x1.e7da24p-2,
  0x1.ddbd4ep-2,
  0x1.b0764ap-4,
  0x1.412088p-1,
  0x1.22495p-2,
  0x1.4842b6p-1,
  0x1.05ddb8p-1,
  0x1.272adap-2,
  0x1.705bdcp-2,
  0x1.97e43ep-2,
  0x1.a7157p-3,
  0x1.29dc14p-2,
  0x1.6d86a6p-3,
  0x1.b9b73ap-2,
  0x1.9f6856p-2,
  0x1.4bac5p-1,
  0x1.76824ap-2,
  0x1.47d44ap-1,
  0x1.a9bc5ap-2,
  0x1.bf0f9ap-4,
  0x1.66182ap-3,
  0x1.e0d3e4p-3,
  0x1.19b42p-3,
  0x1.211852p-2,
  0x1.10232ap-2,
  0x1.047802p-2,
  0x1.ad73e8p-2,
  0x1.1b08cp-1,
  0x1.1aae46p-3,
  0x1.eda112p-2,
  0x1.0b6f0cp-1,
  0x1.293bp-3,
  0x1.1d27aep-3,
  0x1.55fd08p-3,
  0x1.3df3eep-2,
  0x1.3cea2ap-1,
  0x1.9ea864p-2,
  0x1.439accp-2,
  0x1.5f73dap-2,
  0x1.aa0578p-2,
  0x1.4832d4p-1,
  0x1.1dd3f4p-1,
  0x1.cb0caap-2,
  0x1.4955fep-1,
  0x1.9a4a2p-3,
  0x1.1749e4p-1,
  0x1.07f5ccp-3,
  0x1.f4d53ep-4,
  0x1.15b3dcp-2,
  0x1.31a292p-3,
  0x1.88b318p-3,
  0x1.f27bccp-2,
  0x1.542fa4p-1,
  0x1.28ee5p-1,
  0x1.252b68p-3,
  0x1.4855c6p-1,
  0x1.1571eep-2,
  0x1.1a0954p-2,
  0x1.b5df64p-4,
  0x1.ace87cp-3,
  0x1.6e7c98p-2,
  0x1.61453ap-2,
  0x1.bb34bcp-2,
  0x1.40f6a4p-2,
  0x1.4eaaeep-1,
  0x1.bf7c1ep-3,
  0x1.c4067p-2,
  0x1.2a8f7p-3,
  0x1.6c728ep-3,
  0x1.d8ebcp-3,
  0x1.0cbc88p-2,
  0x1.577044p-1,
  0x1.19da2p-2,
  0x1.25353cp-1,
  0x1.bfd288p-2,
  0x1.2521f6p-1,
  0x1.1feed6p-1,
  0x1.597c02p-1,
  0x1.215726p-1,
  0x1.5de45ap-2,
  0x1.7326bp-3,
  0x1.ae373p-2,
  0x1.dc8146p-2,
  0x1.dd88c4p-3,
  0x1.6e21ecp-3,
  0x1.d9a508p-3,
  0x1.0f4a18p-1,
  0x1.21b28ep-2,
  0x1.514f1p-3,
  0x1.77317p-2,
  0x1.66eafp-2,
  0x1.a370ap-2,
  0x1.518098p-1,
  0x1.d7a58cp-3,
  0x1.149e12p-1,
  0x1.6449f6p-1,
  0x1.3b4dbcp-3,
  0x1.1a68ecp-1,
  0x1.2a3188p-1,
  0x1.3fbb6p-1,
  0x1.1be802p-1,
  0x1.43937ap-2,
  0x1.1feee8p-1,
  0x1.c5b228p-4,
  0x1.02b5dep-1,
  0x1.3532e6p-2,
  0x1.2dee7ap-2,
  0x1.1766fcp-3,
  0x1.6576b2p-1,
  0x1.cd11c4p-3,
  0x1.153fap-2,
  0x1.25f1p-1,
  0x1.9cc1e8p-2,
  0x1.1f0db6p-1,
  0x1.11cb62p-1,
  0x1.5451fep-1,
  0x1.337948p-1,
  0x1.b6096ap-2,
  0x1.5fcb46p-1,
  0x1.cb2e2p-2,
  0x1.403324p-1,
  0x1.3f51f2p-1,
  0x1.38425ep-1,
  0x1.6ce2bp-2,
  0x1.5ded7p-3,
  0x1.3a863p-2,
  0x1.5cb812p-1,
  0x1.8733e4p-2,
  0x1.fe185ap-2,
  0x1.5e26fep-1,
  0x1.7903f6p-3,
  0x1.5caa1ap-1,
  0x1.403acp-3,
  0x1.fb7a7p-2,
  0x1.cf6826p-2,
  0x1.55bb42p-1,
  0x1.886722p-2,
  0x1.2c1a8cp-2,
  0x1.352d72p-1,
  0x1.5e54eep-1,
  0x1.4dcf6cp-3,
  0x1.5414d2p-2,
  0x1.025726p-3,
  0x1.59c5fep-2,
  0x1.03a8f8p-1,
  0x1.4ae814p-2,
  0x1.911578p-2,
  0x1.7927aep-2,
  0x1.606bcap-2,
  0x1.0dc9eap-1,
  0x1.5eeeeap-1,
  0x1.bba8d2p-2,
  0x1.9048d6p-2,
  0x1.7a71bap-2,
  0x1.00458cp-1,
  0x1.01935ep-1,
  0x1.1984e2p-1,
  0x1.bc48fp-2,
  0x1.973882p-2,
  0x1.3c11bcp-1,
  0x1.bf9532p-2,
  0x1.b60134p-2,
  0x1.4dc5d8p-1,
  0x1.178a7ep-2,
  0x1.4abdeap-1,
  0x1.40b534p-2,
  0x1.025ad2p-1,
  0x1.1f7abap-2,
  0x1.111b9ep-2,
  0x1.7548b4p-2,
  0x1.31de0cp-1,
  0x1.038b9p-3,
  0x1.f3e4bep-2,
  0x1.c1810cp-2,
  0x1.4086ecp-2,
  0x1.d44d8p-2,
  0x1.be8594p-3,
  0x1.d344cep-2,
  0x1.4f8b16p-2,
  0x1.0b5afep-1,
  0x1.eb93dp-4,
  0x1.f10c04p-3,
  0x1.1f3dd8p-1,
  0x1.de9618p-3,
  0x1.990718p-3,
  0x1.792208p-3,
  0x1.5d3566p-3,
  0x1.289946p-2,
  0x1.275e14p-2,
  0x1.3abd28p-1,
  0x1.d1abccp-2,
  0x1.ae4618p-2,
  0x1.5f36fp-3,
  0x1.537a32p-1,
  0x1.a736fcp-2,
  0x1.ff71dap-2,
  0x1.2acf36p-1,
  0x1.211884p-3,
  0x1.571022p-1,
  0x1.edebc4p-2,
  0x1.5a3d3cp-1,
  0x1.5d7bbcp-3,
  0x1.5dc9acp-1,
  0x1.5f9e76p-1,
  0x1.f6f9d4p-2,
  0x1.1fbc22p-1,
  0x1.c9c98cp-2,
  0x1.e89a16p-2,
  0x1.2c2b54p-1,
  0x1.0edc5ep-1,
  0x1.378564p-1,
  0x1.1b4b74p-2,
  0x1.5924ap-1,
  0x1.02a6a6p-1,
  0x1.128d5cp-1,
  0x1.64cc2cp-1,
  0x1.8bf11p-2,
  0x1.5e99eep-1,
  0x1.5c3748p-3,
  0x1.561be8p-1,
  0x1.f9df26p-2,
  0x1.29a93ap-1,
  0x1.0c6e12p-1,
  0x1.aa8798p-3,
  0x1.cb94f4p-2,
  0x1.4bd17cp-1,
  0x1.a562f4p-2,
  0x1.0fb314p-2,
  0x1.2718e6p-1,
  0x1.5b2926p-1,
  0x1.9729a8p-2,
  0x1.11a214p-1,
  0x1.402b36p-1,
  0x1.740468p-3,
  0x1.64107p-2,
  0x1.cf7db8p-3,
  0x1.5f708p-1,
  0x1.776634p-3,
  0x1.dcff5ap-2,
  0x1.f531f8p-3,
  0x1.1e6282p-1,
  0x1.1b59ecp-3,
  0x1.2ae8c2p-1,
  0x1.7a2dacp-2,
  0x1.23272ap-1,
  0x1.7902eep-3,
  0x1.58fb54p-1,
  0x1.04e27cp-3,
  0x1.391a04p-2,
  0x1.40f028p-1,
  0x1.f4b874p-3,
  0x1.bfd764p-3,
  0x1.4e31d2p-2,
  0x1.df3e56p-2,
  0x1.399a12p-2,
  0x1.9b53ecp-4,
  0x1.29ac24p-3,
  0x1.2b8e6ap-2,
  0x1.3bfaaep-1,
  0x1.46d9aep-2,
  0x1.2e9d12p-2,
  0x1.77c946p-3,
  0x1.51719p-1,
  0x1.44341ap-3,
  0x1.15aa4ap-1,
  0x1.79c7e2p-2,
  0x1.f9a8acp-3,
  0x1.522b2p-1,
};
static const std::vector<float> sincosf_input2 = {
  0x1.8b375p+0,
  0x1.7934c8p+1,
  0x1.249b4p+1,
  0x1.29d862p+0,
  0x1.cac54p+0,
  0x1.47c65cp+0,
  0x1.d45198p+0,
  0x1.36ac4p+1,
  0x1.635158p+1,
  0x1.6e833ap+1,
  0x1.8748b8p+0,
  0x1.3add66p+1,
  0x1.59a6e2p+0,
  0x1.5051d2p+1,
  0x1.2194b4p+0,
  0x1.b3343cp+0,
  0x1.58ff86p+1,
  0x1.3ac5fp+1,
  0x1.4f91bcp+1,
  0x1.363504p+1,
  0x1.650e8cp+1,
  0x1.0eb71p+1,
  0x1.176054p+1,
  0x1.0406c4p+1,
  0x1.2778acp+1,
  0x1.b24b94p+0,
  0x1.550c8cp+0,
  0x1.acc1c4p+0,
  0x1.c8df1p+0,
  0x1.e14e9p+0,
  0x1.ce7ae8p-1,
  0x1.368262p+1,
  0x1.6800dp-1,
  0x1.60480cp+0,
  0x1.158fecp+1,
  0x1.01c81cp+0,
  0x1.c1da44p+0,
  0x1.d46cdap-1,
  0x1.526d44p+1,
  0x1.1e8f76p+1,
  0x1.b7efc4p+0,
  0x1.57ec4p+1,
  0x1.5d1f04p+0,
  0x1.eb9008p+0,
  0x1.8685b8p+1,
  0x1.3e21d4p+1,
  0x1.003256p+1,
  0x1.94cd7p+0,
  0x1.89965p+0,
  0x1.599b7ep+1,
  0x1.05f5acp+1,
  0x1.5fa12cp+1,
  0x1.8f92fcp-1,
  0x1.611928p+1,
  0x1.77dc74p+1,
  0x1.13b3b6p+0,
  0x1.17ab6cp+1,
  0x1.a8b84ap+0,
  0x1.5c46e6p+0,
  0x1.e45686p-1,
  0x1.4b231cp+0,
  0x1.1ebb3ap+1,
  0x1.5b6414p+1,
  0x1.1e1898p+1,
  0x1.4a2448p+1,
  0x1.29dba4p+0,
  0x1.13d0c4p+1,
  0x1.5fb6cap+0,
  0x1.18e392p+1,
  0x1.5680b8p+0,
  0x1.23df18p+0,
  0x1.aa8068p+0,
  0x1.838278p+0,
  0x1.1af3fap+1,
  0x1.b46eep+0,
  0x1.c9ab6p-1,
  0x1.8b988cp+1,
  0x1.80736ep+1,
  0x1.e231f8p-1,
  0x1.e8e76p+0,
  0x1.0b31b2p+0,
  0x1.5e1b8p+0,
  0x1.41c05cp+0,
  0x1.9158c4p+0,
  0x1.648b6p+1,
  0x1.590752p+1,
  0x1.264b64p+0,
  0x1.4c1522p+1,
  0x1.903aacp+0,
  0x1.822d6p+0,
  0x1.6f1924p+1,
  0x1.d27174p+0,
  0x1.f8f43ap-1,
  0x1.70164ap+0,
  0x1.099638p+0,
  0x1.34e26ap+1,
  0x1.b20748p+0,
  0x1.60ff7ep+0,
  0x1.5819fcp+1,
  0x1.33901cp+0,
  0x1.73d868p+0,
  0x1.f289b4p-1,
  0x1.28f63p+1,
  0x1.df3a54p-1,
  0x1.3a3314p+1,
  0x1.5df792p+1,
  0x1.3ab4f8p+0,
  0x1.7c2ec4p+0,
  0x1.155e4ap+1,
  0x1.4b3a94p+0,
  0x1.192324p+1,
  0x1.c8dc4cp-1,
  0x1.852e68p+1,
  0x1.8c71ecp+0,
  0x1.14ca54p+1,
  0x1.eee1d4p+0,
  0x1.e19248p+0,
  0x1.7eae7cp+1,
  0x1.36bfa6p+1,
  0x1.2b96c4p+0,
  0x1.5ae652p+1,
  0x1.715bp+1,
  0x1.2facdp+1,
  0x1.1a3aa8p+0,
  0x1.5f2714p+1,
  0x1.499ce6p+1,
  0x1.1330aap+1,
  0x1.388ffcp+1,
  0x1.155fcap+1,
  0x1.d7684p+0,
  0x1.f78bf4p+0,
  0x1.16ee2p+1,
  0x1.48bc88p+0,
  0x1.dda62ap-1,
  0x1.0f071cp+0,
  0x1.c79d28p+0,
  0x1.5c007cp+1,
  0x1.775db8p+0,
  0x1.852138p+1,
  0x1.3ef1d8p+0,
  0x1.761a18p+1,
  0x1.1d74bcp+1,
  0x1.bfc0f4p-1,
  0x1.a8dec2p+0,
  0x1.451508p+0,
  0x1.2d928cp+1,
  0x1.1f6be8p+0,
  0x1.f365bp+0,
  0x1.f65878p+0,
  0x1.21b78ep+1,
  0x1.423694p+0,
  0x1.72ef86p+1,
  0x1.6b4204p+1,
  0x1.51a18ep+0,
  0x1.e6d964p+0,
  0x1.13e846p+0,
  0x1.10794p+1,
  0x1.ca122p+0,
  0x1.7f9a58p+1,
  0x1.d4de7p-1,
  0x1.3eda4cp+0,
  0x1.7ce822p+0,
  0x1.1e4814p+0,
  0x1.e64644p-1,
  0x1.3ec4b4p+0,
  0x1.1b300ap+1,
  0x1.6c19c8p+0,
  0x1.908198p+0,
  0x1.889fb2p+1,
  0x1.4b3836p+1,
  0x1.5b6d1p+1,
  0x1.86fa5ap+1,
  0x1.47fc78p+0,
  0x1.c33794p-1,
  0x1.e3cc34p+0,
  0x1.4273acp+0,
  0x1.3ee3acp+0,
  0x1.299234p+0,
  0x1.c96806p-1,
  0x1.ae356cp+0,
  0x1.60bcbcp+1,
  0x1.a58304p+0,
  0x1.5971b8p+1,
  0x1.7dd6d4p+1,
  0x1.77fd6cp-1,
  0x1.edabb4p-1,
  0x1.a40ce6p-1,
  0x1.53f0fep+1,
  0x1.9d26p-1,
  0x1.348a14p+0,
  0x1.b79146p-1,
  0x1.0c68a8p+1,
  0x1.3ade08p+0,
  0x1.3176p+0,
  0x1.f0abap-1,
  0x1.f4eccp+0,
  0x1.274d1ap+0,
  0x1.8bbb1p+0,
  0x1.b855a8p+0,
  0x1.50ad34p+0,
  0x1.6ab944p-1,
  0x1.6e7c86p+1,
  0x1.0ba982p+1,
  0x1.615e32p+0,
  0x1.e994e4p+0,
  0x1.d687b8p+0,
  0x1.7b694cp+0,
  0x1.9aa51cp-1,
  0x1.7a6eeap+1,
  0x1.1f9f4ep+1,
  0x1.ae6144p+0,
  0x1.d45678p+0,
  0x1.8afb76p+1,
  0x1.5f7132p+1,
  0x1.41a4e2p+1,
  0x1.b79f5p-1,
  0x1.0d5c7ep+1,
  0x1.946746p-1,
  0x1.27a60cp+1,
  0x1.2f5c76p+1,
  0x1.378fd6p+1,
  0x1.f6304cp+0,
  0x1.8359f8p+0,
  0x1.df19d2p-1,
  0x1.691898p+0,
  0x1.0247a2p+0,
  0x1.6e9ffep+1,
  0x1.356714p+0,
  0x1.15a8bap+0,
  0x1.ea52cp+0,
  0x1.2cc33p+0,
  0x1.2028f8p+1,
  0x1.f70354p+0,
  0x1.54b8f2p+0,
  0x1.98907cp+0,
  0x1.b32f2ap+0,
  0x1.131e9p+1,
  0x1.9980a8p+0,
  0x1.7f473p+0,
  0x1.921924p+0,
  0x1.e98a7cp-1,
  0x1.77e7ap+1,
  0x1.dd7b24p+0,
  0x1.4532cap+1,
  0x1.aad424p-1,
  0x1.1a2388p+1,
  0x1.7f38e2p+1,
  0x1.35e8cp+0,
  0x1.2c1e22p+1,
  0x1.f31538p+0,
  0x1.a288b2p+0,
  0x1.fdab5cp+0,
  0x1.a7c286p-1,
  0x1.41a39p+1,
  0x1.31f6b4p+1,
  0x1.6ac718p-1,
  0x1.04cc02p+0,
  0x1.09264ap+1,
  0x1.91cc0ap-1,
  0x1.e073b4p+0,
  0x1.136804p+0,
  0x1.5dd99ep+1,
  0x1.b9ad38p+0,
  0x1.856b16p+1,
  0x1.5ac3bcp+0,
  0x1.a878fap+0,
  0x1.645cd6p+1,
  0x1.d13df8p-1,
  0x1.07b234p+0,
  0x1.7bc346p+1,
  0x1.56b4a4p+0,
  0x1.cd24acp+0,
  0x1.198a2ep+1,
  0x1.b79484p+0,
  0x1.8b8f1p+1,
  0x1.50aa7ep+1,
  0x1.aabb3cp+0,
  0x1.2594a4p+1,
  0x1.c9f48p-1,
  0x1.3de0c8p+1,
  0x1.08e46p+0,
  0x1.93c88cp+0,
  0x1.d22162p-1,
  0x1.1cf8c6p+0,
  0x1.4faap+1,
  0x1.172c9cp+1,
  0x1.07bb2cp+0,
  0x1.028826p+0,
  0x1.80d69ep+1,
  0x1.ccaaecp+0,
  0x1.155c1ap+1,
  0x1.419c54p+0,
  0x1.928a9p-1,
  0x1.3287ccp+1,
  0x1.db5388p-1,
  0x1.0f3f52p+1,
  0x1.f70638p-1,
  0x1.cd2784p+0,
  0x1.358b6cp+1,
  0x1.f8dd74p+0,
  0x1.43012ep+1,
  0x1.5f422cp+0,
  0x1.72545cp+0,
  0x1.633b5ep+1,
  0x1.609868p+1,
  0x1.1ea412p+1,
  0x1.09e0bcp+1,
  0x1.36546ap+1,
  0x1.85b4b4p+0,
  0x1.dbcc3cp-1,
  0x1.9627c4p+0,
  0x1.803f74p-1,
  0x1.f625ap+0,
  0x1.c948ap+0,
  0x1.200fa2p+0,
  0x1.682c4p-1,
  0x1.88d3ap+1,
  0x1.2e6bfap+1,
  0x1.739f98p+1,
  0x1.3876cp+1,
  0x1.70f35ap+0,
  0x1.46691cp+1,
  0x1.40e0b6p+1,
  0x1.242c56p+1,
  0x1.0218bep+1,
  0x1.aa771p-1,
  0x1.7058fcp+1,
  0x1.1220a4p+1,
  0x1.3e8c5ap+1,
  0x1.27786ap+0,
  0x1.649aap+0,
  0x1.5f8d86p+1,
  0x1.4f78d6p+1,
  0x1.c3f9e4p-1,
  0x1.7f0cccp+0,
  0x1.b41548p-1,
  0x1.0ecfd2p+1,
  0x1.549cf4p+1,
  0x1.326bcp+1,
  0x1.40e388p+1,
  0x1.8a4a44p+1,
  0x1.8510aep+1,
  0x1.446f9p+1,
  0x1.7ee668p+0,
  0x1.a7de4p+0,
  0x1.fbe78p-1,
  0x1.5e3858p+1,
  0x1.a564f2p+0,
  0x1.07ed14p+0,
  0x1.9a3218p+0,
  0x1.bd36bp+0,
  0x1.6d860cp+1,
  0x1.ace02ap+0,
  0x1.45f40cp+0,
  0x1.2c1488p+0,
  0x1.41d564p+0,
  0x1.c25e68p+0,
  0x1.26e5d2p+1,
  0x1.950208p+0,
  0x1.0609cap+0,
  0x1.8ca2bp+0,
  0x1.35c56p+1,
  0x1.1aec24p+1,
  0x1.1fecb8p+1,
  0x1.aaaf18p-1,
  0x1.7b9fbap+1,
  0x1.7b41dp+0,
  0x1.0d44d6p+1,
  0x1.a6c594p+0,
  0x1.0aeb1cp+0,
  0x1.b70e5p+0,
  0x1.7be6e6p+0,
  0x1.56b2bep+1,
  0x1.84d292p+1,
  0x1.b25194p+0,
  0x1.d5c03p+0,
  0x1.0add6p+0,
  0x1.81a6b6p+1,
  0x1.ef097cp+0,
  0x1.789936p+0,
  0x1.232542p+0,
  0x1.8bede8p+1,
  0x1.be12b8p-1,
  0x1.8c9e3cp+1,
  0x1.594ccep+1,
  0x1.655492p+1,
  0x1.66682p+1,
  0x1.3aff58p+1,
  0x1.0d4c64p+1,
  0x1.84ff5ap+1,
  0x1.0ff04ep+1,
  0x1.83cef8p+1,
  0x1.a1d71p+0,
  0x1.8af7f8p+0,
  0x1.decd14p+0,
  0x1.73bf84p+0,
  0x1.4060eep+1,
  0x1.72d01ap+1,
  0x1.633c28p+0,
  0x1.7971a8p+0,
  0x1.4b837cp+0,
  0x1.46cfb6p+1,
  0x1.7e7dcap-1,
  0x1.4a33acp+1,
  0x1.fc34d8p+0,
  0x1.6aa758p+1,
  0x1.8fc4c8p+0,
  0x1.4fcfe6p+0,
  0x1.107894p+1,
  0x1.20742cp+1,
  0x1.573234p+1,
  0x1.1694f6p+1,
  0x1.9e11fcp+0,
  0x1.89f23p+0,
  0x1.823edap+1,
  0x1.7d36a6p+0,
  0x1.8089aap+1,
  0x1.6c5ca6p+0,
  0x1.525caep+1,
  0x1.2a98ap+1,
  0x1.40babp+1,
  0x1.863184p+1,
  0x1.73ad9p+0,
  0x1.864228p+1,
  0x1.989dacp+0,
  0x1.5bc018p+0,
  0x1.77b2ap-1,
  0x1.48ac6ep+1,
  0x1.4de9e6p+1,
  0x1.f6debcp+0,
  0x1.3054dap+0,
  0x1.624e22p+1,
  0x1.7cc9bp+1,
  0x1.a2afep+0,
  0x1.50da12p+1,
  0x1.2ee28p+1,
  0x1.7ef39cp+0,
  0x1.6a84fap-1,
  0x1.87e3c8p+0,
  0x1.5659p+1,
  0x1.1e4d68p+1,
  0x1.721042p+1,
  0x1.02b17cp+1,
  0x1.5c0182p+1,
  0x1.0d58c8p+0,
  0x1.a2a4fp+0,
  0x1.023084p+1,
  0x1.fe4b94p+0,
  0x1.cba3dp+0,
  0x1.2237e2p+0,
  0x1.0f0a4ap+1,
  0x1.97ddbep-1,
  0x1.d2ea7cp+0,
  0x1.53901ap+0,
  0x1.442cf6p+1,
  0x1.ddc894p-1,
  0x1.67e182p+1,
  0x1.bea10cp+0,
  0x1.2d5d6cp+1,
  0x1.62ed22p+1,
  0x1.393d42p+1,
  0x1.3ba55cp+0,
  0x1.fd8f6p-1,
  0x1.3ba084p+1,
  0x1.605e2cp+1,
  0x1.48ee46p+1,
  0x1.d4081p+0,
  0x1.011e1cp+0,
  0x1.42efcp+1,
  0x1.2ab478p+1,
  0x1.14b37ap+1,
  0x1.fb7f9p+0,
  0x1.b2697ep-1,
  0x1.8475cep-1,
  0x1.73a9c6p+1,
  0x1.d781p+0,
  0x1.2e7ecp+1,
  0x1.520c3ep+1,
  0x1.7c8568p+1,
  0x1.884fep+1,
  0x1.338194p+0,
  0x1.166f44p+0,
  0x1.1cd13ep+0,
  0x1.6d9e3p+1,
  0x1.227428p+1,
  0x1.61f258p+0,
  0x1.f224aap-1,
  0x1.5619ecp+0,
  0x1.28b934p+1,
  0x1.acd044p-1,
  0x1.b5de1ep-1,
  0x1.438e6ap+1,
  0x1.819dfp+1,
  0x1.2d7698p+0,
  0x1.e70ffp+0,
  0x1.0096fcp+0,
  0x1.7abf42p-1,
  0x1.0e9fa4p+0,
  0x1.a8f2e6p+0,
  0x1.7d3eep+1,
  0x1.472354p+1,
  0x1.88103p+0,
  0x1.4b6626p+1,
  0x1.0e2e1p+1,
  0x1.95a0fcp+0,
  0x1.64c654p+1,
  0x1.0feeaep+0,
  0x1.5f99eep+1,
  0x1.7cfa14p+1,
  0x1.e30e7ap-1,
  0x1.ebaf94p+0,
  0x1.be7a4p+0,
};
static const std::vector<float> sincosf_input3 = {
  0x1.1f54a8p-1,
  -0x1.5d0396p+1,
  0x1.acaf58p+0,
  -0x1.830ffcp+1,
  0x1.75597cp+1,
  0x1.cbe7ap-1,
  -0x1.5ac992p+1,
  -0x1.19d22ap+1,
  0x1.1525e8p+0,
  0x1.65aa3cp+1,
  0x1.fbd83p+0,
  0x1.383624p+1,
  0x1.acebp-3,
  0x1.2287c4p+1,
  -0x1.6f431ap+1,
  -0x1.81f15cp+1,
  0x1.3850bp+1,
  0x1.0fff88p+1,
  -0x1.5cec62p+1,
  -0x1.6afa66p+0,
  -0x1.850ca4p+0,
  -0x1.35b79cp+1,
  -0x1.23c13ep+0,
  0x1.41a1e4p+1,
  0x1.0dbdd8p+1,
  0x1.58fcc8p+1,
  -0x1.e71b6ep+0,
  0x1.706a6p+0,
  0x1.821798p+1,
  0x1.49e628p+1,
  -0x1.b06dbcp+0,
  0x1.8c8a98p+0,
  0x1.169aep-1,
  0x1.5e207cp+1,
  -0x1.4d98b8p-1,
  0x1.aa7098p+0,
  0x1.e3f38p-3,
  0x1.54ed24p+1,
  -0x1.134794p+1,
  -0x1.2fbf1p-2,
  -0x1.87f6f2p+1,
  0x1.323e08p+1,
  -0x1.0fdf5ep+1,
  -0x1.6e299ap+0,
  0x1.090ec4p+1,
  0x1.affc6p-1,
  0x1.fecacp+0,
  0x1.7dd14p-2,
  -0x1.3d876cp+0,
  -0x1.2c7bdap+1,
  0x1.d08d1p-1,
  -0x1.2dff78p-1,
  -0x1.8a524ep+1,
  0x1.23a0cp-1,
  0x1.72a08p-3,
  0x1.5539b4p+1,
  -0x1.339bfp+1,
  -0x1.54d41p-1,
  0x1.6fef74p+1,
  -0x1.f5134p-4,
  0x1.8811bp-2,
  -0x1.33188ap+1,
  0x1.246cap+0,
  0x1.299938p-1,
  -0x1.685f04p+0,
  0x1.3a92ep+0,
  -0x1.cd8a2ap+0,
  0x1.340a1cp+1,
  0x1.eadebp-1,
  -0x1.1497fp-1,
  0x1.1d6ecp-4,
  0x1.d5f288p+0,
  0x1.6aa3cp-1,
  -0x1.224e2p+1,
  0x1.c3fb3p+0,
  -0x1.1a591cp+1,
  -0x1.224cap+0,
  0x1.b06358p+0,
  -0x1.5b448cp+0,
  -0x1.4c6dbp-2,
  -0x1.7c58ap-3,
  0x1.341e2cp+1,
  0x1.88b9d8p-1,
  -0x1.42c1aep+0,
  -0x1.c274cp-3,
  -0x1.739d68p-1,
  0x1.a7879p-1,
  0x1.d1052p+0,
  -0x1.61bb6ap+1,
  -0x1.a795ep-1,
  0x1.322ccp-4,
  0x1.77e08cp+1,
  0x1.03e8c8p+0,
  0x1.450c38p+1,
  0x1.fca76p-2,
  -0x1.0795ep-3,
  0x1.72e598p-1,
  -0x1.38fd08p+0,
  0x1.5d406cp+1,
  -0x1.2ea498p+1,
  0x1.90eap-3,
  -0x1.3643bcp+0,
  0x1.5081e4p+1,
  -0x1.581978p+1,
  0x1.a57e5p-1,
  0x1.49f4dp+0,
  0x1.8f076p-1,
  0x1.fc9088p+0,
  0x1.04d154p+1,
  -0x1.0f095cp+1,
  0x1.3559c4p+1,
  -0x1.3b3dap-2,
  -0x1.383858p-1,
  0x1.e8af5p+0,
  0x1.df5438p+0,
  0x1.691e08p+0,
  0x1.87b4b8p+0,
  -0x1.7325d6p+1,
  0x1.c7d2a8p+0,
  0x1.0e6d14p+1,
  -0x1.98c98p-3,
  -0x1.63200ep+1,
  -0x1.914f8p+0,
  0x1.71a138p+0,
  -0x1.4844e4p+1,
  0x1.98fe4p-1,
  0x1.0a9174p+1,
  -0x1.773fcap+1,
  -0x1.a37bap-1,
  -0x1.50472cp+1,
  -0x1.cfb2p-2,
  -0x1.b2169p-2,
  -0x1.1117bcp+0,
  0x1.557e88p+0,
  0x1.2f009p+0,
  0x1.069704p+1,
  -0x1.cff21ap+0,
  -0x1.58a0fp-1,
  0x1.670ab8p+0,
  0x1.32afep+0,
  -0x1.0c8c98p+0,
  -0x1.2ffaecp+0,
  0x1.889dc8p+0,
  -0x1.b7175ep+0,
  -0x1.3d6a5cp+1,
  0x1.4d3p+1,
  0x1.72e144p+1,
  -0x1.2a458p+0,
  0x1.5480ap+0,
  -0x1.97978p-4,
  -0x1.4653fp-2,
  0x1.735498p+0,
  -0x1.51ce4cp+1,
  -0x1.16ec58p+0,
  0x1.59bb6p+1,
  0x1.4d0138p-1,
  -0x1.4e8ebcp+1,
  0x1.d301dp+0,
  -0x1.2fec26p+0,
  0x1.7d63dp-1,
  -0x1.824af2p+1,
  0x1.47c7ccp+1,
  -0x1.10ae18p+1,
  -0x1.76da6p-3,
  -0x1.12bp-5,
  0x1.06b7dp+0,
  -0x1.8be0bep+1,
  -0x1.86db4ap+0,
  -0x1.24088ap+0,
  -0x1.f6ada8p+0,
  -0x1.27b592p+0,
  0x1.8ca0e8p+1,
  -0x1.dbcd74p+0,
  -0x1.e9d71cp+0,
  0x1.0126ep+1,
  0x1.54ec1p+0,
  0x1.1aca5p+0,
  0x1.51ff6p-2,
  -0x1.8b89ccp+1,
  -0x1.bd81bcp+0,
  -0x1.43a74p-1,
  0x1.041dep+0,
  0x1.69da1p+1,
  -0x1.3d563cp+0,
  0x1.7449dp-1,
  -0x1.60ff4p+0,
  0x1.37dcbp+1,
  0x1.79795cp+1,
  -0x1.4caa3p-1,
  0x1.5b8494p+1,
  -0x1.789a08p+1,
  -0x1.139294p+0,
  -0x1.082698p-1,
  -0x1.b2389p-1,
  -0x1.76f8dep+0,
  0x1.080f2p+1,
  0x1.a5a428p-1,
  0x1.e5383p+0,
  0x1.42f8acp+1,
  -0x1.32929p-1,
  0x1.e2806p+0,
  0x1.f1a09p+0,
  -0x1.0bb5ep+1,
  0x1.1513dp+1,
  -0x1.25e4cp-1,
  0x1.562044p+1,
  -0x1.ad366p-1,
  0x1.0d837p+0,
  0x1.88067p+0,
  0x1.2b5c5p-1,
  -0x1.682fcp+0,
  -0x1.d1585p-2,
  0x1.3ce41p+0,
  -0x1.4f7b9ap+1,
  -0x1.a0544p-4,
  0x1.5996acp+1,
  0x1.87b24p-1,
  -0x1.f90d38p-1,
  -0x1.ae695p+0,
  0x1.26e51p-2,
  -0x1.6a81eap+0,
  -0x1.805584p+1,
  -0x1.cc051p-2,
  -0x1.0483cap+1,
  0x1.4af66cp+1,
  -0x1.3e46a2p+0,
  -0x1.79abaep+1,
  -0x1.331aeep+0,
  -0x1.62b68ap+1,
  0x1.634ba8p+0,
  -0x1.d5d34p+0,
  -0x1.145a64p+0,
  -0x1.4f6a58p+1,
  -0x1.70478p-1,
  0x1.520074p+1,
  0x1.759054p+1,
  -0x1.ad80ap-3,
  -0x1.4b2688p-1,
  -0x1.7fe8f4p+1,
  0x1.6cb374p+1,
  -0x1.91ea46p+0,
  -0x1.a4f1dap+0,
  -0x1.09dd6cp+0,
  -0x1.1bc55cp+0,
  0x1.f98de8p+0,
  0x1.77acc8p+1,
  0x1.0801cp-4,
  0x1.6b8aa4p+1,
  -0x1.69b1b8p-1,
  -0x1.0cebdap+1,
  -0x1.45fa3p+1,
  0x1.bb2f8p-3,
  0x1.c931p-2,
  0x1.01ea3p+1,
  0x1.585e78p+1,
  0x1.2dc148p-1,
  -0x1.2e5dp-6,
  0x1.46e12p+1,
  0x1.41866p+1,
  0x1.e4ec3p+0,
  -0x1.9f5588p-1,
  0x1.4611d8p+0,
  0x1.8745p-2,
  -0x1.718da2p+1,
  0x1.e60d2p-1,
  -0x1.45c4bap+1,
  0x1.418decp+1,
  0x1.389fap-2,
  -0x1.338224p+1,
  0x1.6bcdc8p+0,
  -0x1.15dd54p+0,
  -0x1.20a04p-3,
  -0x1.bae08p-5,
  0x1.874ac8p+0,
  -0x1.efe266p+0,
  -0x1.53e424p+0,
  -0x1.289dc8p-1,
  -0x1.86015cp+1,
  -0x1.ebc568p-1,
  0x1.fbf8bp-1,
  0x1.f7c4ep+0,
  0x1.855ffp+1,
  -0x1.a8a47p-1,
  0x1.074fe8p+1,
  0x1.091608p+0,
  0x1.f2117p-1,
  0x1.194f04p+1,
  -0x1.0dc22p+1,
  -0x1.1e8604p+1,
  0x1.826b08p-1,
  0x1.569874p+1,
  0x1.3c77p+0,
  0x1.787a28p+1,
  0x1.9e41d8p+0,
  -0x1.43a58p+0,
  0x1.fa373p+0,
  -0x1.2e9abp-2,
  -0x1.420f92p+0,
  -0x1.1a674ep+0,
  -0x1.9f2fb2p+0,
  0x1.18948p-5,
  0x1.80d89p+0,
  0x1.ae3e4p-4,
  0x1.e72fb8p+0,
  0x1.291cf8p-1,
  -0x1.2f28ep+0,
  -0x1.0dd378p-1,
  0x1.f9025p-2,
  -0x1.7261ecp+1,
  0x1.712fap+0,
  -0x1.73dc7cp+1,
  0x1.4738p-2,
  -0x1.e2bbdcp+0,
  0x1.36ae2cp+1,
  -0x1.3a571ep+0,
  -0x1.6b098ap+0,
  -0x1.af94dp-2,
  -0x1.86d746p+1,
  0x1.648c7cp+1,
  0x1.73d13cp+1,
  -0x1.19f07ap+0,
  0x1.64f48p+0,
  0x1.6c2868p+0,
  0x1.5f1a24p+1,
  -0x1.75b9fp-2,
  -0x1.1e1816p+1,
  0x1.28d11p-1,
  0x1.ecc608p+0,
  0x1.ee0b68p+0,
  -0x1.1d455p+0,
  -0x1.410ad2p+0,
  -0x1.df3bf8p-1,
  -0x1.808182p+0,
  -0x1.c7ddc2p+0,
  -0x1.28e568p+1,
  0x1.09c6d4p+1,
  0x1.ffdd3p-2,
  0x1.78e464p+1,
  0x1.400a2p-3,
  0x1.c1f868p-1,
  0x1.4d5b4p-2,
  -0x1.2c0d26p+1,
  0x1.860a5p+0,
  -0x1.7abbd8p+1,
  0x1.8f99ep+0,
  0x1.53f29p+0,
  -0x1.13b214p+1,
  0x1.250f1p-1,
  0x1.79318p-2,
  0x1.db6328p+0,
  -0x1.1c2a16p+1,
  0x1.993e48p+0,
  0x1.67863p+0,
  -0x1.49303cp+0,
  -0x1.02ee9cp+1,
  -0x1.265eccp+1,
  -0x1.25ee6p-2,
  -0x1.6aef76p+1,
  0x1.a3594p-3,
  0x1.78d8e8p+0,
  0x1.87e704p+1,
  -0x1.1b0454p+1,
  0x1.613c8p+0,
  -0x1.8ac80cp+1,
  0x1.7761ap-3,
  -0x1.647314p+0,
  -0x1.7e2d3p+1,
  -0x1.d666d8p+0,
  0x1.53d94p-1,
  0x1.30a9c4p+1,
  0x1.0e03b8p+0,
  -0x1.5d5476p+0,
  -0x1.c8eeep-3,
  0x1.9a54p-4,
  -0x1.0f0e48p+0,
  -0x1.737a88p+1,
  -0x1.6e3c18p-1,
  0x1.659998p+1,
  -0x1.523e82p+1,
  -0x1.75837p-2,
  0x1.fe4dep-3,
  -0x1.956686p+0,
  -0x1.61ed52p+0,
  -0x1.a4f31cp+0,
  -0x1.5f9914p+0,
  0x1.9bd8d8p+0,
  -0x1.68f8cep+0,
  0x1.e62e6p-1,
  -0x1.82bfd6p+1,
  0x1.ac9fap-2,
  -0x1.1bac64p+1,
  -0x1.8266e8p-1,
  -0x1.594b78p-1,
  0x1.d8c11p-2,
  -0x1.4c64cp+1,
  0x1.54aacp+0,
  0x1.0645a8p+1,
  0x1.43259p+1,
  0x1.faeb8p-5,
  -0x1.bd663p-2,
  -0x1.4093cap+1,
  -0x1.4cb9d2p+1,
  0x1.66f2f4p+1,
  -0x1.ee153p-2,
  -0x1.0d02fcp+1,
  -0x1.979bcp-3,
  -0x1.0a78ep+0,
  -0x1.6e2fbcp+1,
  0x1.3c94d8p+1,
  -0x1.7ceef4p+1,
  0x1.551db8p+1,
  0x1.d731e8p+0,
  -0x1.4866d8p+1,
  0x1.83d774p+1,
  0x1.6425d4p+1,
  -0x1.51a138p-1,
  0x1.0a1d18p+1,
  0x1.7a1ea8p+0,
  0x1.3ddf3p-2,
  0x1.d3379p-1,
  0x1.5d4ccp-1,
  0x1.d6e2d8p+0,
  0x1.057938p+0,
  0x1.7f026cp+1,
  0x1.60e43cp+1,
  -0x1.61f53ep+1,
  0x1.ef0e18p+0,
  -0x1.76bbfep+0,
  0x1.f8cbep-1,
  0x1.bc07cp+0,
  -0x1.4c154p-4,
  -0x1.c3ba48p-1,
  0x1.b3fbbp-2,
  -0x1.0cd0b4p+1,
  -0x1.202a72p+0,
  0x1.8867bp+1,
  0x1.29cd1p+1,
  0x1.8175p+1,
  0x1.31375p-1,
  0x1.c921b8p-1,
  -0x1.5321c4p+1,
  -0x1.22e46ap+0,
  0x1.1970ap+1,
  0x1.df02ap+0,
  -0x1.4d2cbcp+1,
  -0x1.b43e02p+0,
  0x1.13f444p+1,
  -0x1.5efb9p-2,
  -0x1.0289fp+0,
  -0x1.8e818p-5,
  -0x1.44336p+1,
  0x1.1f6c2p+1,
  0x1.866dc4p+1,
  -0x1.60688ep+1,
  -0x1.158eep-1,
  -0x1.f348a6p+0,
  0x1.5c19f8p-1,
  -0x1.bf6ee8p-1,
  -0x1.87416p-1,
  0x1.0fc118p-1,
  -0x1.a98e6ep+0,
  0x1.97ba88p+0,
  0x1.e8d7p-4,
  0x1.03d5f8p+0,
  -0x1.7a04dep+0,
  0x1.ab6d38p+0,
  0x1.0ad864p+1,
  0x1.5be57p+0,
  -0x1.381208p+1,
  0x1.60a12p-1,
  0x1.9a852p+0,
  0x1.02821p-1,
  -0x1.7aa292p+1,
  0x1.e195b8p+0,
  -0x1.4aae72p+0,
  0x1.3c3568p+1,
  0x1.3a51c8p-1,
  0x1.7c1934p+1,
  -0x1.41d9d8p+1,
  0x1.eabd4p+0,
  0x1.0c237cp+1,
  0x1.e3de18p+0,
  0x1.470f74p+1,
  0x1.40bc4cp+1,
  -0x1.4605b8p+0,
  -0x1.9de34ap+0,
  0x1.c7c3c8p+0,
  0x1.1ed6cp+0,
  0x1.0df5p+1,
  -0x1.67529cp+1,
  0x1.373fc8p-1,
  -0x1.9edda6p+0,
  0x1.8fe2dp-2,
  -0x1.88ce9ep+1,
  0x1.70db3p-2,
  -0x1.d877dp-1,
  -0x1.fb6dep-3,
  -0x1.1b10ccp+1,
  0x1.896ee8p+1,
  -0x1.ae6fep-3,
  0x1.6fac38p-1,
  -0x1.5e8adep+1,
  0x1.2239cp+1,
  -0x1.50ba38p+1,
  -0x1.45bb58p-1,
  -0x1.f66d72p+0,
  -0x1.cbf28p-2,
  0x1.03b9d8p+0,
  0x1.795158p+0,
  -0x1.3898d8p-1,
  -0x1.0b3f08p+1,
  -0x1.003636p+1,
};
static const std::vector<float> sincosf_input4 = {
  0x1.d9b006p+4,
  0x1.21f776p+4,
  0x1.d78bf2p+4,
  0x1.d01f9cp+4,
  0x1.febap+4,
  0x1.0347eep+5,
  0x1.c6a5ep+3,
  0x1.cb9c1cp+4,
  0x1.e22748p+4,
  0x1.093644p+5,
  0x1.9c9e18p+4,
  0x1.b8408p+3,
  0x1.f005fcp+4,
  0x1.dafbcep+4,
  0x1.079p+5,
  0x1.0271bcp+3,
  0x1.038e2ep+4,
  0x1.9a2e88p+4,
  0x1.df39cp+2,
  0x1.f5f49ap+4,
  0x1.14c78p+4,
  0x1.71158ap+4,
  0x1.785988p+2,
  0x1.b5e23cp+3,
  0x1.e29e8cp+2,
  0x1.f0f57ap+3,
  0x1.f38858p+3,
  0x1.a10754p+4,
  0x1.625cdcp+2,
  0x1.92c832p+4,
  0x1.baf03cp+4,
  0x1.669e62p+3,
  0x1.a69232p+4,
  0x1.442e7ep+2,
  0x1.481d76p+4,
  0x1.3054f4p+2,
  0x1.bba956p+3,
  0x1.4b457ap+4,
  0x1.74d012p+4,
  0x1.4bf2ap+4,
  0x1.d9667ep+4,
  0x1.8a658p+3,
  0x1.0eb286p+4,
  0x1.d00eap+2,
  0x1.03eeeep+5,
  0x1.8648dap+2,
  0x1.48b3bcp+4,
  0x1.110e8cp+4,
  0x1.0b478ep+3,
  0x1.745e64p+4,
  0x1.394c0ep+2,
  0x1.f391fep+3,
  0x1.a22588p+4,
  0x1.0b707ap+4,
  0x1.99f6fcp+4,
  0x1.f2f446p+3,
  0x1.8be6a6p+3,
  0x1.b644p+4,
  0x1.964954p+4,
  0x1.9d3dep+2,
  0x1.c510f2p+3,
  0x1.7fa968p+4,
  0x1.082516p+4,
  0x1.aa925p+4,
  0x1.3e5572p+3,
  0x1.c69b1ep+2,
  0x1.6af1e6p+3,
  0x1.64fa8cp+3,
  0x1.aa928cp+4,
  0x1.2a9efap+3,
  0x1.d30044p+4,
  0x1.f82834p+1,
  0x1.3e9f2ap+4,
  0x1.a9d3c8p+4,
  0x1.19d32p+3,
  0x1.0ea6f2p+4,
  0x1.00b9bcp+2,
  0x1.06f3acp+5,
  0x1.a8addap+4,
  0x1.75f7c4p+4,
  0x1.a2275cp+4,
  0x1.9379fcp+4,
  0x1.ca327cp+4,
  0x1.b713eap+3,
  0x1.90f2f4p+3,
  0x1.8cee9p+2,
  0x1.e56ce2p+3,
  0x1.472eecp+3,
  0x1.f9bbp+4,
  0x1.9039c4p+4,
  0x1.d7b0b4p+2,
  0x1.cb606ap+4,
  0x1.719b04p+3,
  0x1.151dcep+2,
  0x1.a2c4fp+2,
  0x1.e6a9b6p+4,
  0x1.c87b9cp+3,
  0x1.00142ap+4,
  0x1.b6bba4p+4,
  0x1.aa339p+4,
  0x1.3e524p+3,
  0x1.814514p+4,
  0x1.02c3cep+2,
  0x1.2d1f72p+3,
  0x1.93219ap+3,
  0x1.e83158p+1,
  0x1.c00772p+4,
  0x1.6779bap+3,
  0x1.cac1fp+3,
  0x1.aff6b6p+4,
  0x1.0ca9cep+4,
  0x1.581194p+3,
  0x1.60f9dcp+4,
  0x1.2f19e6p+3,
  0x1.245b84p+3,
  0x1.261c1ep+3,
  0x1.d60db8p+3,
  0x1.a30f2ap+4,
  0x1.ca4a26p+4,
  0x1.bf5d58p+3,
  0x1.69282p+4,
  0x1.4c6456p+4,
  0x1.b604b2p+4,
  0x1.ee5b12p+4,
  0x1.99d6e6p+4,
  0x1.478e32p+4,
  0x1.5b51acp+2,
  0x1.6a44a2p+3,
  0x1.c657c2p+4,
  0x1.dfc308p+4,
  0x1.fc88ccp+3,
  0x1.140ccap+4,
  0x1.47ce8cp+4,
  0x1.6f3f48p+4,
  0x1.5fc7f8p+4,
  0x1.1724cap+4,
  0x1.91891cp+4,
  0x1.3e6506p+4,
  0x1.8656bcp+3,
  0x1.c5f82ep+3,
  0x1.965e0cp+3,
  0x1.5cf48ap+4,
  0x1.932c7p+3,
  0x1.0a2962p+4,
  0x1.88bcc4p+4,
  0x1.b18a3cp+4,
  0x1.68e42p+4,
  0x1.85b798p+2,
  0x1.e8bc72p+3,
  0x1.81fedep+3,
  0x1.918042p+4,
  0x1.7c3728p+3,
  0x1.174ad4p+4,
  0x1.582e72p+4,
  0x1.af735ep+4,
  0x1.3f8476p+2,
  0x1.fde618p+3,
  0x1.e4d202p+3,
  0x1.750cb2p+3,
  0x1.071d9cp+5,
  0x1.3826f4p+3,
  0x1.e8e456p+4,
  0x1.662342p+4,
  0x1.d2a076p+3,
  0x1.d2f50ep+3,
  0x1.ecd11cp+4,
  0x1.fc5542p+3,
  0x1.f92eb4p+4,
  0x1.2166ep+2,
  0x1.0045dap+4,
  0x1.09b87cp+5,
  0x1.b427ecp+4,
  0x1.e51fc8p+4,
  0x1.f690eap+3,
  0x1.083d52p+5,
  0x1.7d15bp+4,
  0x1.ce6fbep+2,
  0x1.a6a036p+3,
  0x1.8a9ea4p+3,
  0x1.1098b6p+4,
  0x1.dd452cp+2,
  0x1.ca0608p+3,
  0x1.c3609p+2,
  0x1.358da6p+4,
  0x1.20c3c8p+3,
  0x1.9bd816p+4,
  0x1.02033ap+5,
  0x1.e3a1dep+4,
  0x1.a544fep+3,
  0x1.038cc6p+5,
  0x1.35d3e6p+4,
  0x1.5ec00ep+4,
  0x1.afa608p+3,
  0x1.16712ep+4,
  0x1.3de652p+4,
  0x1.5009dep+4,
  0x1.3574f4p+4,
  0x1.d7be58p+3,
  0x1.bc68e8p+2,
  0x1.095f3cp+5,
  0x1.79ae08p+4,
  0x1.c8733cp+3,
  0x1.53bf98p+3,
  0x1.c8968ep+3,
  0x1.ccf14cp+4,
  0x1.a75d54p+4,
  0x1.eb9c28p+4,
  0x1.9f6f94p+4,
  0x1.e8ac94p+2,
  0x1.a13bdep+2,
  0x1.d8268ap+3,
  0x1.399b68p+4,
  0x1.510a16p+4,
  0x1.bce66ap+4,
  0x1.4f90aep+4,
  0x1.f50a16p+4,
  0x1.36da48p+3,
  0x1.1b6eb8p+2,
  0x1.4c3ee8p+4,
  0x1.fd7ee8p+3,
  0x1.81a422p+4,
  0x1.ecd51ap+3,
  0x1.ebf874p+4,
  0x1.4e644p+3,
  0x1.98754ep+4,
  0x1.22c8d4p+3,
  0x1.b45e62p+4,
  0x1.c96f5p+4,
  0x1.42fdap+2,
  0x1.20228ep+4,
  0x1.da26f2p+3,
  0x1.7207e8p+4,
  0x1.8c7f4ep+4,
  0x1.29c686p+3,
  0x1.bec8f6p+4,
  0x1.bcd07cp+1,
  0x1.b84222p+3,
  0x1.dc4b4ap+4,
  0x1.f7bf54p+4,
  0x1.4d4adcp+4,
  0x1.53ec6ap+4,
  0x1.53bc8p+3,
  0x1.ff15cp+4,
  0x1.f0a64cp+4,
  0x1.eb078ap+4,
  0x1.0ab37cp+2,
  0x1.6d385ep+4,
  0x1.f7aa4ap+4,
  0x1.83d21cp+4,
  0x1.06c1aap+5,
  0x1.31ac66p+3,
  0x1.42b3fp+3,
  0x1.b345fcp+2,
  0x1.fabcbep+3,
  0x1.95f77p+4,
  0x1.16080ap+4,
  0x1.dea248p+4,
  0x1.0546a6p+5,
  0x1.b97b28p+4,
  0x1.e45098p+4,
  0x1.c929bp+3,
  0x1.28fe9ap+4,
  0x1.9af9e8p+2,
  0x1.b788fp+4,
  0x1.8e02c4p+4,
  0x1.755dfp+3,
  0x1.dfaec2p+4,
  0x1.aab09p+3,
  0x1.8079c6p+4,
  0x1.be8d54p+4,
  0x1.eca9aap+4,
  0x1.fca4d8p+3,
  0x1.9b096cp+3,
  0x1.1c290ap+4,
  0x1.01a39p+4,
  0x1.8f59c4p+4,
  0x1.03b19p+3,
  0x1.1e2d5p+4,
  0x1.6f1cbp+3,
  0x1.c93c1ep+3,
  0x1.9191aep+4,
  0x1.c14772p+2,
  0x1.cd788p+1,
  0x1.ca4074p+4,
  0x1.6a98fcp+3,
  0x1.fde204p+4,
  0x1.3c59ap+4,
  0x1.35125cp+3,
  0x1.b74914p+4,
  0x1.2eb1a8p+4,
  0x1.f57cfp+3,
  0x1.0a334ap+3,
  0x1.1ecf72p+4,
  0x1.e1214cp+4,
  0x1.73c0bp+3,
  0x1.823b22p+3,
  0x1.7156b8p+3,
  0x1.894a2ap+4,
  0x1.a58e6p+2,
  0x1.6e8994p+3,
  0x1.c32e84p+4,
  0x1.89e944p+3,
  0x1.8d77fp+2,
  0x1.6e0f5cp+4,
  0x1.0f7998p+2,
  0x1.bfcf76p+3,
  0x1.2872b2p+3,
  0x1.3c4abcp+3,
  0x1.ac2caap+4,
  0x1.078762p+5,
  0x1.a5fd0ep+4,
  0x1.3400a4p+4,
  0x1.b583c4p+4,
  0x1.1af9f4p+4,
  0x1.b0d008p+4,
  0x1.f2e008p+1,
  0x1.4e47eap+4,
  0x1.9d7c24p+4,
  0x1.99fdep+3,
  0x1.4243cp+3,
  0x1.3ad2a6p+3,
  0x1.b415f2p+3,
  0x1.100638p+3,
  0x1.a7879ap+4,
  0x1.b02518p+4,
  0x1.a5d3fep+3,
  0x1.5fedfcp+3,
  0x1.01756ap+5,
  0x1.fb27fap+4,
  0x1.3bcdcp+2,
  0x1.80311ap+4,
  0x1.f33ed2p+4,
  0x1.02dc32p+5,
  0x1.7685fap+3,
  0x1.d235e8p+3,
  0x1.7e562p+4,
  0x1.3cf0b2p+2,
  0x1.acf6ap+3,
  0x1.a42964p+3,
  0x1.178948p+3,
  0x1.46f674p+3,
  0x1.8b7f02p+2,
  0x1.a1f042p+3,
  0x1.fe4758p+1,
  0x1.5e217cp+4,
  0x1.400002p+4,
  0x1.da4dacp+4,
  0x1.5a8792p+4,
  0x1.72d808p+4,
  0x1.065256p+5,
  0x1.8bcc9ap+4,
  0x1.5a0eecp+4,
  0x1.7ea664p+2,
  0x1.6853b6p+4,
  0x1.f9077ap+4,
  0x1.ac2286p+4,
  0x1.ceeceap+3,
  0x1.f29254p+4,
  0x1.aaca38p+2,
  0x1.fbf222p+1,
  0x1.d33954p+1,
  0x1.6e6c58p+4,
  0x1.7e6b5cp+4,
  0x1.7c55b4p+3,
  0x1.e4371ep+4,
  0x1.e02304p+2,
  0x1.1e7092p+4,
  0x1.48e24cp+3,
  0x1.4fcbb6p+3,
  0x1.da9748p+4,
  0x1.aa8dcap+4,
  0x1.0a73d2p+4,
  0x1.b05c22p+4,
  0x1.f9e69p+4,
  0x1.41421ap+4,
  0x1.2004a6p+4,
  0x1.f7e3a2p+4,
  0x1.6daee4p+4,
  0x1.f505dcp+1,
  0x1.188de4p+3,
  0x1.4b1e08p+4,
  0x1.5a884ap+3,
  0x1.636968p+3,
  0x1.c63146p+4,
  0x1.8d75dcp+3,
  0x1.f57fc8p+4,
  0x1.422f22p+4,
  0x1.4a4648p+4,
  0x1.97b3e4p+2,
  0x1.aac73p+1,
  0x1.9b9edcp+4,
  0x1.888fb6p+4,
  0x1.21cbf2p+4,
  0x1.40a17p+3,
  0x1.df3d74p+4,
  0x1.e8acccp+4,
  0x1.84b146p+4,
  0x1.ca295p+4,
  0x1.20c3c8p+4,
  0x1.215d5ap+3,
  0x1.c54f64p+3,
  0x1.10fab6p+4,
  0x1.022ca8p+5,
  0x1.96c25cp+4,
  0x1.22c034p+3,
  0x1.c14e3ep+3,
  0x1.9288e4p+3,
  0x1.61481ap+4,
  0x1.167068p+3,
  0x1.a9809p+4,
  0x1.55fbf6p+3,
  0x1.196bc8p+2,
  0x1.1fc4ep+3,
  0x1.be704cp+3,
  0x1.ad1edcp+4,
  0x1.54bd56p+4,
  0x1.e85e14p+4,
  0x1.13b4c8p+3,
  0x1.7b4b1ep+4,
  0x1.8f19dcp+4,
  0x1.2e3b88p+4,
  0x1.9b9566p+3,
  0x1.013aa6p+5,
  0x1.15f566p+4,
  0x1.d3d786p+3,
  0x1.2bb3a4p+4,
  0x1.d0c012p+4,
  0x1.947eb8p+4,
  0x1.f47356p+4,
  0x1.30c408p+4,
  0x1.40abbep+3,
  0x1.5dfd3ap+3,
  0x1.3fd38p+3,
  0x1.0830c6p+3,
  0x1.47fb02p+4,
  0x1.9e73ep+2,
  0x1.f5c8f4p+1,
  0x1.7d004cp+2,
  0x1.cb6c52p+4,
  0x1.7b3a8p+4,
  0x1.0cf8d4p+3,
  0x1.ac16fep+4,
  0x1.a7ece4p+2,
  0x1.31558ep+4,
  0x1.616cfap+4,
  0x1.568cfcp+3,
  0x1.728ba4p+2,
  0x1.f7a77p+2,
  0x1.3bfap+4,
  0x1.bdcfc4p+3,
  0x1.0a9e4p+4,
  0x1.2acd32p+4,
  0x1.0194c2p+4,
  0x1.69b6bp+4,
  0x1.8739c2p+4,
  0x1.d0649p+3,
  0x1.d5fd24p+4,
  0x1.59ffc2p+4,
  0x1.1db42cp+3,
  0x1.04edfp+5,
  0x1.478eb8p+4,
  0x1.41e26ap+4,
  0x1.43b74ep+2,
  0x1.6b0c6ap+2,
  0x1.3a712p+4,
  0x1.a2cf0ep+4,
  0x1.46a6cep+3,
  0x1.723e36p+4,
  0x1.03c712p+4,
  0x1.feccdcp+4,
  0x1.378e1ep+4,
  0x1.36db7ap+4,
  0x1.38b218p+3,
  0x1.8788dap+4,
  0x1.24b5d2p+4,
  0x1.205a46p+2,
  0x1.480e56p+3,
  0x1.5b846ap+3,
  0x1.b4a0b8p+4,
  0x1.f1cfeep+3,
  0x1.ad833p+4,
  0x1.50a87p+4,
  0x1.28a382p+4,
  0x1.7d753ep+3,
  0x1.11e73cp+2,
  0x1.137bf8p+2,
  0x1.ffe5a6p+3,
  0x1.efab38p+3,
  0x1.8add74p+4,
  0x1.cdc3f6p+3,
  0x1.24b0e6p+3,
  0x1.9ee018p+4,
  0x1.7906f2p+4,
  0x1.1690bcp+4,
  0x1.5feadap+3,
  0x1.a58552p+2,
  0x1.95347ap+3,
  0x1.a2563ap+4,
  0x1.7889a8p+3,
  0x1.08137cp+4,
  0x1.a87f4cp+1,
  0x1.9840ecp+2,
  0x1.4de56ep+4,
  0x1.62b97ep+3,
  0x1.b4187ap+3,
  0x1.1b8f58p+3,
  0x1.aeb858p+4,
  0x1.b7b1bap+4,
  0x1.7ceb72p+4,
  0x1.fbb328p+4,
  0x1.74178ap+3,
  0x1.03b668p+4,
};
static const std::vector<float> sincosf_input5 = {
  0x1.a58d5p+9,
  0x1.438348p+8,
  0x1.a70332p+9,
  0x1.03e326p+9,
  0x1.d0eb62p+9,
  0x1.d73d76p+9,
  0x1.bdc7f6p+9,
  0x1.0e2808p+8,
  0x1.c8c1dap+9,
  0x1.55c5f6p+9,
  0x1.f0c75cp+6,
  0x1.12b71cp+7,
  0x1.cf863ep+8,
  0x1.6cbf66p+9,
  0x1.5b0cb8p+7,
  0x1.55a5c2p+9,
  0x1.2fbedp+7,
  0x1.7b3208p+8,
  0x1.85ceb4p+8,
  0x1.65ae0ep+8,
  0x1.e8014p+9,
  0x1.c68b08p+9,
  0x1.de043cp+9,
  0x1.85858cp+9,
  0x1.d82842p+8,
  0x1.beae4cp+9,
  0x1.2ec9dep+9,
  0x1.1fe07p+9,
  0x1.e57a3cp+6,
  0x1.21d12ep+8,
  0x1.d3b106p+9,
  0x1.172896p+7,
  0x1.7fd932p+7,
  0x1.ccb13cp+9,
  0x1.d85418p+9,
  0x1.dc8cd2p+8,
  0x1.db05bcp+9,
  0x1.f79c9p+8,
  0x1.ab3906p+7,
  0x1.27603cp+9,
  0x1.b59372p+9,
  0x1.190414p+7,
  0x1.7bd034p+9,
  0x1.62fb2cp+9,
  0x1.ad3ed6p+8,
  0x1.8f0ddcp+9,
  0x1.2c8cc8p+9,
  0x1.f10002p+8,
  0x1.ceeb9cp+9,
  0x1.56cea8p+8,
  0x1.4cb9f2p+8,
  0x1.e24fa2p+6,
  0x1.6e11p+9,
  0x1.9164dp+8,
  0x1.08d868p+9,
  0x1.35dedp+8,
  0x1.2bfbcp+9,
  0x1.3290f6p+9,
  0x1.878d1ap+8,
  0x1.405b0ep+9,
  0x1.b9a5b4p+9,
  0x1.bd96eap+8,
  0x1.61b97ap+9,
  0x1.143eb8p+9,
  0x1.06a794p+9,
  0x1.9287bcp+6,
  0x1.52b45p+9,
  0x1.e5a1fp+7,
  0x1.de9484p+7,
  0x1.beb85ap+9,
  0x1.0fef88p+7,
  0x1.9dfa7ep+9,
  0x1.66afa2p+8,
  0x1.8a2f5ep+7,
  0x1.9011f2p+9,
  0x1.6a0aap+9,
  0x1.03553cp+9,
  0x1.01086cp+8,
  0x1.d98c62p+7,
  0x1.04bc3ep+8,
  0x1.a790e8p+7,
  0x1.643b7ep+9,
  0x1.ee6e7ap+8,
  0x1.a39d52p+8,
  0x1.816d88p+7,
  0x1.d7e4dcp+8,
  0x1.a86616p+9,
  0x1.227074p+7,
  0x1.3f0f04p+8,
  0x1.3b6378p+7,
  0x1.47fcb6p+7,
  0x1.a15942p+9,
  0x1.1275c4p+9,
  0x1.964c26p+8,
  0x1.c86162p+9,
  0x1.61ae1cp+8,
  0x1.bd6c34p+9,
  0x1.e9c03ep+7,
  0x1.0bf7bep+7,
  0x1.e6d2e4p+9,
  0x1.d1490cp+8,
  0x1.c10be6p+9,
  0x1.7d42c4p+9,
  0x1.43ae2cp+8,
  0x1.82ccfp+9,
  0x1.ca5528p+9,
  0x1.1a3198p+9,
  0x1.98dd9cp+9,
  0x1.35e072p+9,
  0x1.23edaep+9,
  0x1.be91b4p+7,
  0x1.3c2016p+9,
  0x1.44b1dp+8,
  0x1.7a648ap+9,
  0x1.447abap+7,
  0x1.547fb8p+9,
  0x1.76ab38p+9,
  0x1.f8c2c6p+8,
  0x1.68a83cp+9,
  0x1.56f30ep+9,
  0x1.9b79bp+9,
  0x1.488772p+8,
  0x1.14c354p+9,
  0x1.baafb6p+9,
  0x1.a05d9ep+7,
  0x1.2ddc9cp+9,
  0x1.5a5376p+9,
  0x1.4b52cp+8,
  0x1.168e1ep+7,
  0x1.e2dec8p+9,
  0x1.41e5c8p+9,
  0x1.0b51dap+9,
  0x1.ca1244p+9,
  0x1.69b2dp+9,
  0x1.db8942p+9,
  0x1.84cdd8p+9,
  0x1.2399ap+9,
  0x1.8a3554p+8,
  0x1.df01aap+8,
  0x1.e03b4ep+7,
  0x1.f1591ep+6,
  0x1.257d02p+7,
  0x1.c8cae6p+7,
  0x1.17647ep+9,
  0x1.f0fdeep+9,
  0x1.d02362p+6,
  0x1.b8d7fep+9,
  0x1.a649cp+8,
  0x1.1cc578p+8,
  0x1.34508cp+7,
  0x1.d330ap+9,
  0x1.a2a332p+9,
  0x1.5cfaa4p+9,
  0x1.a0b3dep+9,
  0x1.5f06e8p+9,
  0x1.5b039ap+9,
  0x1.9fcd3ep+9,
  0x1.44a582p+9,
  0x1.74be88p+7,
  0x1.619a8cp+8,
  0x1.cedca6p+9,
  0x1.f6bfe2p+8,
  0x1.b0b69ep+9,
  0x1.b6fc96p+9,
  0x1.393de8p+9,
  0x1.4a59b2p+9,
  0x1.205de8p+9,
  0x1.0b7fb4p+9,
  0x1.9362ep+8,
  0x1.99e7f2p+7,
  0x1.2fb1a4p+8,
  0x1.2222d4p+9,
  0x1.b7009ap+9,
  0x1.23dd5cp+8,
  0x1.8bf2fap+9,
  0x1.a2418p+9,
  0x1.28ab3p+9,
  0x1.20ef26p+8,
  0x1.d6e53p+8,
  0x1.43808ap+9,
  0x1.99fdd4p+9,
  0x1.c28ep+7,
  0x1.b1c144p+8,
  0x1.2b1fa4p+7,
  0x1.1003cp+7,
  0x1.bcf53p+9,
  0x1.e9339ap+9,
  0x1.7820cp+9,
  0x1.bb7e5ap+9,
  0x1.350d5ap+7,
  0x1.745a32p+9,
  0x1.4358ap+9,
  0x1.dce282p+6,
  0x1.91dbaep+9,
  0x1.d90cf4p+8,
  0x1.11a80ap+8,
  0x1.986538p+8,
  0x1.06ea9ep+8,
  0x1.a0d218p+9,
  0x1.d03902p+9,
  0x1.a1fa7p+9,
  0x1.300118p+9,
  0x1.e99d7ap+9,
  0x1.644b1cp+9,
  0x1.e41afep+8,
  0x1.334a38p+7,
  0x1.6d70dap+8,
  0x1.d2d868p+9,
  0x1.c08c7ep+9,
  0x1.5539b4p+9,
  0x1.e39a9ep+8,
  0x1.37b61cp+9,
  0x1.a4d3aap+9,
  0x1.7555d6p+9,
  0x1.431de8p+7,
  0x1.d5fc94p+9,
  0x1.28092cp+9,
  0x1.93a8fp+9,
  0x1.9f55a8p+9,
  0x1.4643d2p+8,
  0x1.260698p+9,
  0x1.0616cap+9,
  0x1.3c171ep+9,
  0x1.a8c48p+9,
  0x1.c9a5bcp+9,
  0x1.a1bd8ep+8,
  0x1.0db7b2p+9,
  0x1.dc4d06p+6,
  0x1.56f8f8p+8,
  0x1.1e031p+9,
  0x1.ae95f6p+9,
  0x1.4eeb3p+8,
  0x1.c6b798p+9,
  0x1.97aadep+8,
  0x1.4e35d8p+8,
  0x1.abc94ep+9,
  0x1.f81574p+8,
  0x1.51843ep+7,
  0x1.437464p+8,
  0x1.7ef9ccp+9,
  0x1.910f5ap+9,
  0x1.416f9p+8,
  0x1.c9b2bp+9,
  0x1.547214p+9,
  0x1.a04846p+8,
  0x1.325306p+9,
  0x1.8d3a34p+7,
  0x1.7b5d48p+9,
  0x1.c7f67ep+9,
  0x1.ea508cp+7,
  0x1.87df1p+8,
  0x1.d28b56p+9,
  0x1.7cb404p+9,
  0x1.2a2c44p+8,
  0x1.f0c13p+8,
  0x1.8d211cp+9,
  0x1.b76e66p+8,
  0x1.385fa2p+9,
  0x1.c3fe6ap+9,
  0x1.4c26a4p+8,
  0x1.f4fbd4p+6,
  0x1.c8f658p+9,
  0x1.bef93cp+9,
  0x1.e2434ep+9,
  0x1.05d374p+9,
  0x1.c252c2p+6,
  0x1.6e4b62p+8,
  0x1.3f8a4p+7,
  0x1.93da56p+8,
  0x1.19831cp+9,
  0x1.138e7cp+9,
  0x1.237afp+8,
  0x1.cf3dbap+9,
  0x1.7e8c48p+7,
  0x1.481ccep+9,
  0x1.9cc84ap+9,
  0x1.0d9dcp+9,
  0x1.654dep+9,
  0x1.168e28p+9,
  0x1.c4e90ep+7,
  0x1.2d7d38p+9,
  0x1.3c52aap+9,
  0x1.745912p+7,
  0x1.5ef9bcp+8,
  0x1.d22404p+9,
  0x1.83a49p+8,
  0x1.18c9cep+7,
  0x1.176b2p+9,
  0x1.7d5684p+9,
  0x1.1fc3f4p+9,
  0x1.058e7p+7,
  0x1.86aa68p+7,
  0x1.1a4d58p+9,
  0x1.5de8bap+8,
  0x1.8b975p+9,
  0x1.8cea7p+7,
  0x1.debe9cp+7,
  0x1.0ed648p+8,
  0x1.f60024p+8,
  0x1.3157a4p+9,
  0x1.e1be62p+9,
  0x1.b9ed12p+9,
  0x1.bf1442p+8,
  0x1.1d1f7cp+9,
  0x1.7a16cep+7,
  0x1.046208p+9,
  0x1.4acb8cp+7,
  0x1.03db5ap+8,
  0x1.e51724p+9,
  0x1.71b228p+8,
  0x1.67219p+8,
  0x1.640e06p+9,
  0x1.f1ccaep+7,
  0x1.3efddp+7,
  0x1.4b8e38p+9,
  0x1.33782p+9,
  0x1.b3e11cp+9,
  0x1.284d4ep+9,
  0x1.58c496p+8,
  0x1.e074e4p+9,
  0x1.b9f05cp+9,
  0x1.622fa2p+9,
  0x1.88ff0cp+9,
  0x1.5461p+8,
  0x1.091de8p+9,
  0x1.9727fcp+9,
  0x1.1807cep+9,
  0x1.10e93p+8,
  0x1.90232ap+8,
  0x1.5813bap+9,
  0x1.0edc58p+9,
  0x1.99e58ep+9,
  0x1.086858p+8,
  0x1.d01232p+9,
  0x1.e9c72cp+8,
  0x1.8bc82cp+8,
  0x1.e43a8cp+8,
  0x1.f1e7ap+9,
  0x1.d49c7ep+9,
  0x1.3f9788p+9,
  0x1.728016p+9,
  0x1.56e6fcp+9,
  0x1.ee6ffep+9,
  0x1.053452p+8,
  0x1.46273p+8,
  0x1.50e7fap+7,
  0x1.287256p+8,
  0x1.5a9836p+9,
  0x1.b0ed0ep+9,
  0x1.320a22p+9,
  0x1.de35ccp+6,
  0x1.3a8ad8p+8,
  0x1.947d04p+9,
  0x1.ceb7ccp+8,
  0x1.d810dep+8,
  0x1.2ab464p+8,
  0x1.08b8d8p+9,
  0x1.8b8a4ap+9,
  0x1.6051f8p+9,
  0x1.df991ep+9,
  0x1.b467f8p+7,
  0x1.3be4b6p+8,
  0x1.587794p+9,
  0x1.9be00ap+7,
  0x1.54bb18p+9,
  0x1.95ad08p+9,
  0x1.e48a12p+7,
  0x1.87716ep+9,
  0x1.9aa8dap+9,
  0x1.33e4acp+8,
  0x1.9a013cp+7,
  0x1.fa74bp+7,
  0x1.16a6ap+9,
  0x1.832c46p+9,
  0x1.13cca4p+9,
  0x1.189dfep+9,
  0x1.a837fp+7,
  0x1.e61fecp+9,
  0x1.daf868p+6,
  0x1.08f726p+9,
  0x1.7e404cp+9,
  0x1.865fb4p+7,
  0x1.4e6adp+9,
  0x1.af287ap+8,
  0x1.f4904ep+8,
  0x1.9a0786p+8,
  0x1.df8514p+7,
  0x1.b91148p+8,
  0x1.170dp+7,
  0x1.11e8dp+7,
  0x1.df9d2p+9,
  0x1.17217ep+8,
  0x1.7d9408p+9,
  0x1.7ba4b8p+9,
  0x1.8f652ep+9,
  0x1.aa5444p+7,
  0x1.6da108p+7,
  0x1.6ec024p+7,
  0x1.f4733ep+8,
  0x1.af3bcp+9,
  0x1.c0b2b8p+8,
  0x1.c3ef32p+9,
  0x1.5e4c42p+9,
  0x1.8c2518p+7,
  0x1.c63a78p+7,
  0x1.ba0b02p+7,
  0x1.4df914p+9,
  0x1.01f2dp+9,
  0x1.76ac44p+9,
  0x1.76845p+7,
  0x1.f0b86p+8,
  0x1.def1b2p+9,
  0x1.54f5e8p+8,
  0x1.2aea6cp+8,
  0x1.5e8f2cp+9,
  0x1.e06afcp+7,
  0x1.dd7188p+9,
  0x1.a87494p+8,
  0x1.9a6a04p+8,
  0x1.3bb6cp+9,
  0x1.b5df6ap+9,
  0x1.eac37cp+9,
  0x1.3e471cp+7,
  0x1.457958p+9,
  0x1.84b278p+9,
  0x1.505a1p+9,
  0x1.7043f4p+7,
  0x1.11cfp+9,
  0x1.a26364p+8,
  0x1.eb975ap+9,
  0x1.e3b906p+6,
  0x1.2b92b8p+9,
  0x1.d1079ep+9,
  0x1.6e795cp+9,
  0x1.279da8p+8,
  0x1.3de18ap+9,
  0x1.5b33ecp+8,
  0x1.ca3058p+9,
  0x1.3bb5cep+9,
  0x1.bc3a3ep+9,
  0x1.d7c70ap+9,
  0x1.3562d6p+9,
  0x1.09d65cp+8,
  0x1.cc57ecp+9,
  0x1.8dac24p+9,
  0x1.23c146p+9,
  0x1.a1138p+8,
  0x1.456378p+7,
  0x1.f609b6p+7,
  0x1.6f0538p+9,
  0x1.ed2512p+9,
  0x1.0be67ep+7,
  0x1.1ceb8ap+9,
  0x1.caa9a6p+9,
  0x1.9d7336p+7,
  0x1.35a1c8p+9,
  0x1.e6b7ap+8,
  0x1.6595e2p+9,
  0x1.0ab05p+9,
  0x1.adb8ccp+7,
  0x1.aea1fcp+9,
  0x1.2ac79cp+9,
  0x1.bcc348p+9,
  0x1.6a0e52p+8,
  0x1.70eec2p+9,
  0x1.7a41c4p+7,
  0x1.598196p+9,
  0x1.9cb7ccp+9,
  0x1.675a3ep+9,
  0x1.4a69eap+9,
  0x1.bd07aep+6,
  0x1.0c9bp+8,
  0x1.1cf0d2p+7,
  0x1.3b711cp+9,
  0x1.25a83p+9,
  0x1.97acep+9,
  0x1.15eadp+9,
  0x1.55f7b4p+9,
  0x1.9b3d86p+9,
  0x1.257628p+9,
  0x1.5f96b8p+8,
  0x1.991ad4p+9,
  0x1.f48576p+8,
  0x1.6ea988p+8,
  0x1.6af9bap+8,
  0x1.7ceecp+9,
  0x1.f31982p+9,
  0x1.7c52cap+8,
  0x1.a9fc42p+8,
  0x1.2f641p+9,
  0x1.b4fde2p+6,
  0x1.8d06fap+9,
  0x1.0708a8p+8,
  0x1.9760fap+8,
  0x1.1cc328p+7,
  0x1.e819b4p+9,
  0x1.9c5e7ap+7,
  0x1.266414p+9,
  0x1.bd7a1cp+8,
  0x1.3dc13ap+8,
  0x1.26a3cap+9,
  0x1.53052ep+9,
  0x1.3ab898p+8,
  0x1.ce9b96p+9,
  0x1.90ec7p+9,
  0x1.4b0576p+7,
  0x1.f752acp+7,
  0x1.b6cdecp+9,
  0x1.83968p+9,
  0x1.15a5e8p+9,
  0x1.e9c90ap+7,
  0x1.9b097ep+9,
};
static const std::vector<float> sincosf_input6 = {
  0x1.e44094p+100,
  0x1.36e29p+106,
  0x1.b2e762p+105,
  0x1.b0674ap+102,
  0x1.e54982p+103,
  0x1.2c1c92p+106,
  0x1.167bfap+105,
  0x1.25bea6p+106,
  0x1.1681a6p+106,
  0x1.51c39cp+105,
  0x1.026514p+106,
  0x1.cc029ep+105,
  0x1.3372c8p+105,
  0x1.cb9c58p+104,
  0x1.219dccp+104,
  0x1.2b67bap+106,
  0x1.632382p+102,
  0x1.72928cp+104,
  0x1.28e0dep+106,
  0x1.637182p+105,
  0x1.4e0cdcp+105,
  0x1.65938ap+103,
  0x1.cba67ep+105,
  0x1.b99b64p+104,
  0x1.6f0626p+104,
  0x1.0917dep+106,
  0x1.4c4408p+104,
  0x1.9ddc02p+104,
  0x1.379e7ap+106,
  0x1.fece04p+104,
  0x1.05c4p+105,
  0x1.d331b8p+105,
  0x1.ec2b84p+103,
  0x1.bb2a04p+103,
  0x1.09a25ep+105,
  0x1.727284p+105,
  0x1.ab8524p+104,
  0x1.3ef73ep+103,
  0x1.36bfc4p+106,
  0x1.f98c64p+104,
  0x1.ca43e8p+105,
  0x1.1962c4p+105,
  0x1.9e160ep+103,
  0x1.ce05a2p+105,
  0x1.5daaacp+105,
  0x1.9721c2p+103,
  0x1.2ed026p+106,
  0x1.58bc64p+105,
  0x1.22707p+105,
  0x1.27d7bap+106,
  0x1.3b13dap+105,
  0x1.26c74ap+104,
  0x1.525ff8p+103,
  0x1.320bap+106,
  0x1.30ffc6p+105,
  0x1.d96674p+103,
  0x1.156f56p+105,
  0x1.341346p+102,
  0x1.664daep+105,
  0x1.83d14ep+105,
  0x1.b64312p+104,
  0x1.f150a6p+105,
  0x1.932fp+105,
  0x1.7a93aap+104,
  0x1.2d30a4p+106,
  0x1.11b068p+106,
  0x1.1906fp+106,
  0x1.e1c876p+105,
  0x1.24d782p+104,
  0x1.d03706p+102,
  0x1.28a0bcp+105,
  0x1.50f4bap+102,
  0x1.ef3a8ep+104,
  0x1.ff694ep+105,
  0x1.16f6dp+105,
  0x1.9bffep+104,
  0x1.afb792p+105,
  0x1.acb788p+105,
  0x1.022e76p+106,
  0x1.3cfa2ep+105,
  0x1.ba48p+101,
  0x1.8b2e0cp+104,
  0x1.5f220ep+104,
  0x1.0bd75ap+105,
  0x1.feef2ap+105,
  0x1.2557f4p+106,
  0x1.eaa76cp+101,
  0x1.58d384p+105,
  0x1.d9274p+105,
  0x1.d29002p+105,
  0x1.c16p+105,
  0x1.d2b92ep+105,
  0x1.5de6f2p+105,
  0x1.4301eep+104,
  0x1.519696p+105,
  0x1.7de692p+105,
  0x1.c4969cp+102,
  0x1.850e38p+105,
  0x1.410278p+104,
  0x1.e4bcacp+104,
  0x1.720d2p+105,
  0x1.281d2p+106,
  0x1.203418p+105,
  0x1.c143a4p+105,
  0x1.137ac2p+106,
  0x1.23164p+105,
  0x1.d28ab4p+105,
  0x1.6c19f2p+105,
  0x1.dcea32p+101,
  0x1.c1474ep+105,
  0x1.3490bap+104,
  0x1.43bd62p+105,
  0x1.d44c0cp+103,
  0x1.9ba2e6p+104,
  0x1.d59aecp+102,
  0x1.e2f2ecp+103,
  0x1.636b9ep+103,
  0x1.117c6p+106,
  0x1.d597ccp+101,
  0x1.37c64p+106,
  0x1.6d4b2cp+105,
  0x1.c8b9bap+105,
  0x1.33d526p+106,
  0x1.daa2d6p+103,
  0x1.3f44eep+104,
  0x1.1638aep+105,
  0x1.049f98p+104,
  0x1.024a7ap+106,
  0x1.968f4ap+104,
  0x1.35ddp+106,
  0x1.c6466cp+102,
  0x1.3040dap+106,
  0x1.12a0f2p+105,
  0x1.27dafp+104,
  0x1.97a38p+103,
  0x1.b7d40ap+104,
  0x1.2f4a7cp+105,
  0x1.a06d54p+102,
  0x1.35d068p+104,
  0x1.8f6a3p+105,
  0x1.2c402p+106,
  0x1.1e9296p+106,
  0x1.476236p+104,
  0x1.07efep+106,
  0x1.3baf24p+102,
  0x1.16e86ap+106,
  0x1.2e2d92p+105,
  0x1.1e5ce4p+105,
  0x1.39c434p+104,
  0x1.6a969ep+104,
  0x1.a58e42p+103,
  0x1.287decp+105,
  0x1.8b4de2p+104,
  0x1.e88492p+104,
  0x1.4ea74p+103,
  0x1.819808p+105,
  0x1.3dd952p+105,
  0x1.2ef72cp+106,
  0x1.468e02p+105,
  0x1.3d9472p+105,
  0x1.52e8d4p+103,
  0x1.f1936ap+103,
  0x1.72da8ep+105,
  0x1.9201a6p+105,
  0x1.27d542p+106,
  0x1.25a0d2p+106,
  0x1.b8e7aap+105,
  0x1.1095b2p+105,
  0x1.37ed0cp+106,
  0x1.b4ba18p+105,
  0x1.0540cp+105,
  0x1.2d27eep+106,
  0x1.ab11eep+105,
  0x1.ecff5cp+105,
  0x1.33b81ap+102,
  0x1.a1407ap+105,
  0x1.1d595ep+106,
  0x1.0170d2p+105,
  0x1.cad076p+105,
  0x1.2df588p+98,
  0x1.2e6fb8p+106,
  0x1.5d4988p+104,
  0x1.989c9ep+103,
  0x1.efc2b2p+104,
  0x1.907232p+105,
  0x1.2acedp+106,
  0x1.6a980cp+100,
  0x1.b5be2p+105,
  0x1.7df524p+105,
  0x1.64d5c8p+105,
  0x1.b47b72p+105,
  0x1.0c173ep+106,
  0x1.23b1c6p+105,
  0x1.ee66a8p+104,
  0x1.de04acp+103,
  0x1.409b3cp+105,
  0x1.48ddcap+105,
  0x1.346d2p+104,
  0x1.d1f64cp+105,
  0x1.7344ap+105,
  0x1.ed81dep+104,
  0x1.f1130ap+104,
  0x1.d9ba56p+105,
  0x1.77bcd4p+105,
  0x1.712286p+105,
  0x1.3a5ab8p+104,
  0x1.38e2f2p+106,
  0x1.f38da2p+105,
  0x1.a8e58ep+104,
  0x1.179e9ap+103,
  0x1.1766e2p+106,
  0x1.13e6dep+103,
  0x1.dc5c32p+105,
  0x1.838808p+105,
  0x1.68309ap+105,
  0x1.244118p+106,
  0x1.638aecp+105,
  0x1.1bc956p+105,
  0x1.5c377cp+104,
  0x1.694c12p+105,
  0x1.cfc0ccp+105,
  0x1.f3519ap+105,
  0x1.904b44p+104,
  0x1.0bcf8p+105,
  0x1.34a3f8p+106,
  0x1.35a37p+104,
  0x1.14c3e8p+106,
  0x1.232b32p+106,
  0x1.7c919ep+102,
  0x1.8574dp+105,
  0x1.88227ap+105,
  0x1.2d80d8p+106,
  0x1.08c13ap+105,
  0x1.169998p+104,
  0x1.da388ep+105,
  0x1.687abcp+103,
  0x1.bad1e4p+104,
  0x1.6b6cbep+105,
  0x1.0eac8p+106,
  0x1.08fa92p+105,
  0x1.a3eb14p+104,
  0x1.ab1c7cp+105,
  0x1.208244p+106,
  0x1.28bf0ap+106,
  0x1.b1825ep+105,
  0x1.cb61ecp+105,
  0x1.23bb2cp+105,
  0x1.390a8cp+106,
  0x1.77d34ap+105,
  0x1.283caep+106,
  0x1.2b735p+105,
  0x1.0db8ccp+106,
  0x1.e5f18ep+104,
  0x1.18fbdcp+105,
  0x1.a13adep+105,
  0x1.fa6be6p+105,
  0x1.df4596p+101,
  0x1.18bdep+105,
  0x1.08fc4ap+105,
  0x1.0fcb06p+105,
  0x1.04e53ap+106,
  0x1.b9452ap+104,
  0x1.183e32p+106,
  0x1.ca9258p+104,
  0x1.4bae9ap+103,
  0x1.fb1314p+104,
  0x1.9fe296p+105,
  0x1.131252p+106,
  0x1.b110acp+105,
  0x1.173b9ap+105,
  0x1.dcc2p+105,
  0x1.06f73p+105,
  0x1.e3dfbcp+104,
  0x1.d350cap+104,
  0x1.04bbfp+106,
  0x1.09012ep+105,
  0x1.419e9ep+105,
  0x1.8dacc6p+105,
  0x1.25592cp+105,
  0x1.d5a028p+103,
  0x1.cf753ep+103,
  0x1.e8167p+105,
  0x1.8ef30ap+105,
  0x1.1f49bap+104,
  0x1.5b6ca6p+103,
  0x1.78b72ep+104,
  0x1.c6b838p+105,
  0x1.2fb342p+106,
  0x1.08dfaap+103,
  0x1.23c0e6p+106,
  0x1.a2dc96p+105,
  0x1.6a428ap+103,
  0x1.25911ap+105,
  0x1.a1148cp+105,
  0x1.296faap+101,
  0x1.374b22p+104,
  0x1.c8795p+103,
  0x1.55b9c8p+100,
  0x1.a9e658p+105,
  0x1.77a89ep+104,
  0x1.c61a1ep+105,
  0x1.b60f42p+105,
  0x1.0dac4p+106,
  0x1.a1fc54p+103,
  0x1.ba77a4p+105,
  0x1.47c172p+103,
  0x1.e97d82p+105,
  0x1.548f34p+105,
  0x1.515ecap+105,
  0x1.346956p+105,
  0x1.3aaafap+105,
  0x1.08f86p+105,
  0x1.5ea00cp+105,
  0x1.202cfp+103,
  0x1.296e08p+105,
  0x1.62eb88p+103,
  0x1.45e7c8p+105,
  0x1.70f9bap+101,
  0x1.f19c74p+103,
  0x1.f9378p+97,
  0x1.d787cep+104,
  0x1.0ea13cp+105,
  0x1.105d84p+106,
  0x1.31aa4p+105,
  0x1.41344p+105,
  0x1.44d736p+103,
  0x1.ec3ccep+105,
  0x1.22fd5p+106,
  0x1.d3f69ep+105,
  0x1.1397c6p+106,
  0x1.1b8bp+106,
  0x1.1e9814p+105,
  0x1.5d79cap+104,
  0x1.194776p+103,
  0x1.a480f2p+105,
  0x1.69dfb6p+104,
  0x1.150dcp+105,
  0x1.48acfep+103,
  0x1.751852p+104,
  0x1.f595dep+104,
  0x1.eac8f2p+104,
  0x1.e873aap+102,
  0x1.948426p+104,
  0x1.33346cp+104,
  0x1.36b74p+104,
  0x1.33e9dp+106,
  0x1.4b602cp+105,
  0x1.b6297cp+102,
  0x1.4217e4p+103,
  0x1.a8ff48p+105,
  0x1.0eb3bap+106,
  0x1.8cd95p+104,
  0x1.060b48p+106,
  0x1.5aa7c4p+103,
  0x1.e5517ep+105,
  0x1.63db1ep+105,
  0x1.1d1d08p+106,
  0x1.9022e2p+105,
  0x1.0ddc18p+105,
  0x1.b4208cp+104,
  0x1.f0c21ap+100,
  0x1.07548cp+106,
  0x1.602328p+105,
  0x1.a2d1c6p+102,
  0x1.ab8df2p+104,
  0x1.374eep+106,
  0x1.fd98b2p+104,
  0x1.b08f78p+104,
  0x1.b2384ap+103,
  0x1.1b9308p+106,
  0x1.5837fep+105,
  0x1.8abba2p+103,
  0x1.0b54fap+106,
  0x1.2e41bp+106,
  0x1.470d88p+104,
  0x1.c6d472p+105,
  0x1.e98c34p+105,
  0x1.4691c8p+103,
  0x1.fb9258p+105,
  0x1.3adc78p+105,
  0x1.1aa5b4p+104,
  0x1.32d54ap+103,
  0x1.b4052ep+103,
  0x1.bab582p+104,
  0x1.c50892p+104,
  0x1.1383aep+106,
  0x1.460f9ep+104,
  0x1.2db9dcp+106,
  0x1.890a5ep+103,
  0x1.374a56p+106,
  0x1.35a3fep+106,
  0x1.d6e912p+104,
  0x1.a10c38p+104,
  0x1.267e56p+106,
  0x1.df0826p+105,
  0x1.b06af8p+105,
  0x1.517d2ap+104,
  0x1.c94678p+105,
  0x1.dd534p+102,
  0x1.d9b082p+103,
  0x1.a658d8p+103,
  0x1.9a1044p+105,
  0x1.8ceedap+104,
  0x1.0d811ep+106,
  0x1.d458p+104,
  0x1.8ed3c2p+104,
  0x1.deb20ap+104,
  0x1.bbd5bap+101,
  0x1.3a96cp+106,
  0x1.23d73ep+104,
  0x1.6b1f0ap+105,
  0x1.2355c4p+103,
  0x1.66ed88p+104,
  0x1.07c8acp+106,
  0x1.8a57bap+103,
  0x1.b69f3ap+104,
  0x1.d90426p+105,
  0x1.ca83b2p+105,
  0x1.7e159ap+104,
  0x1.1bc50cp+106,
  0x1.7c780cp+103,
  0x1.6a43fcp+105,
  0x1.8183e8p+105,
  0x1.b05838p+104,
  0x1.a9ab56p+104,
  0x1.fb30fep+103,
  0x1.4c0594p+101,
  0x1.871912p+103,
  0x1.175b1cp+105,
  0x1.8a5146p+105,
  0x1.29f71cp+106,
  0x1.b3bd0ap+105,
  0x1.16df22p+106,
  0x1.c1e5dap+105,
  0x1.c17e7ap+105,
  0x1.83d568p+104,
  0x1.0523ep+105,
  0x1.e6ae42p+104,
  0x1.b417fap+105,
  0x1.e9be28p+105,
  0x1.dc8cdp+104,
  0x1.8dc59ep+105,
  0x1.fc29a8p+103,
  0x1.ac20f4p+104,
  0x1.18241ap+105,
  0x1.f5e8cp+104,
  0x1.de7f5cp+105,
  0x1.4912p+103,
  0x1.d93e88p+103,
  0x1.17f482p+106,
  0x1.2ebe88p+105,
  0x1.0bebacp+103,
  0x1.c048cp+105,
  0x1.20e728p+106,
  0x1.f4e3b2p+105,
  0x1.2000b4p+104,
  0x1.d6e18ep+103,
  0x1.e12f5p+105,
  0x1.7b88d6p+105,
  0x1.73aa0cp+102,
  0x1.3be4d2p+105,
  0x1.63e1fap+105,
  0x1.1d1652p+104,
  0x1.3befap+102,
  0x1.c4fee6p+104,
  0x1.bf3abap+102,
  0x1.d12a76p+105,
  0x1.3e262p+103,
  0x1.9eddfap+104,
  0x1.389c76p+104,
  0x1.229d4p+106,
  0x1.01e9ecp+105,
  0x1.77f092p+104,
  0x1.a45126p+103,
  0x1.9eacdep+105,
  0x1.10e51cp+105,
  0x1.dd815p+103,
  0x1.7e13bp+105,
  0x1.455734p+105,
  0x1.1dd5eap+103,
  0x1.57394cp+105,
  0x1.278256p+106,
  0x1.b519fp+105,
  0x1.144998p+106,
  0x1.221f1cp+106,
  0x1.352638p+106,
  0x1.ef39f6p+105,
  0x1.a8af4p+105,
  0x1.2708a8p+104,
  0x1.200884p+106,
  0x1.c45f8ap+105,
  0x1.1d07ep+106,
  0x1.16422p+102,
  0x1.07234ap+106,
  0x1.343d5cp+105,
  0x1.08154ap+106,
  0x1.166866p+105,
  0x1.d4b9a2p+99,
  0x1.2661fap+106,
  0x1.29ba9cp+106,
  0x1.01938ep+105,
  0x1.18302cp+105,
  0x1.31b5d8p+104,
  0x1.89775cp+97,
  0x1.accdfep+103,
  0x1.ebc352p+102,
  0x1.21b17p+106,
  0x1.8559c6p+105,
  0x1.0837a6p+106,
  0x1.0c5fbap+106,
  0x1.15541ap+106,
  0x1.17e162p+106,
};
static const std::vector<float> sincosf_input7 = {
  0x1.66823p+127,
  0x1.cdee8ep+125,
  0x1.3241f6p+127,
  0x1.0bab12p+125,
  0x1.47c142p+126,
  0x1.18237ap+125,
  0x1.aa230ap+127,
  0x1.19f854p+126,
  0x1.9d7a76p+127,
  0x1.971a86p+124,
  0x1.00bf28p+123,
  0x1.a2eedap+126,
  0x1.760244p+127,
  0x1.50e15ap+126,
  0x1.c4d462p+127,
  0x1.10a28cp+127,
  0x1.433a4ap+127,
  0x1.0a4d6ep+127,
  0x1.fd76a4p+124,
  0x1.3c8582p+127,
  0x1.5e556p+126,
  0x1.ffb8b6p+125,
  0x1.0f81eap+126,
  0x1.368c2ep+126,
  0x1.0f1ac4p+127,
  0x1.27796p+127,
  0x1.50373ep+126,
  0x1.1299c6p+127,
  0x1.34b33ap+127,
  0x1.c31d06p+122,
  0x1.a31c84p+127,
  0x1.28aedap+126,
  0x1.fda94ep+126,
  0x1.12c172p+126,
  0x1.ca2bcap+127,
  0x1.f9079cp+126,
  0x1.dc5c18p+126,
  0x1.5d8066p+127,
  0x1.2dbb12p+125,
  0x1.09ca5ap+127,
  0x1.db67cep+125,
  0x1.b5755ap+127,
  0x1.99f6p+126,
  0x1.90e684p+127,
  0x1.510c5cp+127,
  0x1.726daap+125,
  0x1.e7de06p+127,
  0x1.f6c18ep+127,
  0x1.c1eafp+126,
  0x1.86ef0cp+126,
  0x1.051402p+127,
  0x1.ca4d9ep+127,
  0x1.7e9f9ap+120,
  0x1.e2e4p+126,
  0x1.da1834p+126,
  0x1.99ae12p+125,
  0x1.171bfap+124,
  0x1.0a84f6p+122,
  0x1.b9d428p+127,
  0x1.e27144p+125,
  0x1.1f754ap+127,
  0x1.b23d7ep+127,
  0x1.c56878p+126,
  0x1.ca196cp+127,
  0x1.7e16a4p+127,
  0x1.ef7446p+127,
  0x1.ddd388p+125,
  0x1.7e18cep+126,
  0x1.edf5bp+127,
  0x1.917ebap+124,
  0x1.0920f6p+126,
  0x1.9c225cp+127,
  0x1.e88c72p+123,
  0x1.19da36p+127,
  0x1.12f618p+127,
  0x1.79244ap+127,
  0x1.1c2cbcp+126,
  0x1.c0e9dep+127,
  0x1.f217ap+127,
  0x1.ed5a78p+127,
  0x1.39e9eap+126,
  0x1.37169cp+127,
  0x1.db789cp+127,
  0x1.36deccp+121,
  0x1.76a81cp+123,
  0x1.022b6cp+127,
  0x1.1462bp+127,
  0x1.c26bd6p+126,
  0x1.d63826p+125,
  0x1.28846p+127,
  0x1.59ae48p+126,
  0x1.d1f348p+127,
  0x1.0e90b2p+127,
  0x1.26dc72p+126,
  0x1.d9afbep+126,
  0x1.f2bba6p+126,
  0x1.28b52cp+126,
  0x1.adabbp+123,
  0x1.28a332p+125,
  0x1.4309e6p+127,
  0x1.ed2c1cp+126,
  0x1.433eccp+127,
  0x1.ebb6eep+127,
  0x1.830fbp+126,
  0x1.a0ac4p+124,
  0x1.9f7342p+124,
  0x1.7bef98p+126,
  0x1.1281cap+127,
  0x1.a653f6p+122,
  0x1.329328p+127,
  0x1.76bb3cp+124,
  0x1.7292d6p+125,
  0x1.e36fe8p+127,
  0x1.089b3ep+127,
  0x1.450b34p+126,
  0x1.77b268p+125,
  0x1.cb018ep+126,
  0x1.8c8c2ep+124,
  0x1.a06c4cp+127,
  0x1.461f2ep+126,
  0x1.03f9bep+126,
  0x1.fd18a6p+127,
  0x1.afa5f4p+127,
  0x1.1b5642p+126,
  0x1.c096b4p+123,
  0x1.e7d78p+127,
  0x1.6e2fcap+127,
  0x1.66067ep+126,
  0x1.d251f8p+127,
  0x1.439466p+127,
  0x1.1dc904p+126,
  0x1.79bbe6p+127,
  0x1.52a2bap+127,
  0x1.399754p+125,
  0x1.b22b3ap+125,
  0x1.83fea6p+124,
  0x1.d90378p+125,
  0x1.9e8dc8p+127,
  0x1.5e4b2p+127,
  0x1.72387ep+126,
  0x1.79b6acp+126,
  0x1.cefefp+127,
  0x1.caa272p+122,
  0x1.40a71ep+125,
  0x1.bde272p+126,
  0x1.08ff4cp+127,
  0x1.0ba12ap+126,
  0x1.df8588p+124,
  0x1.76f3dp+125,
  0x1.f71cf6p+127,
  0x1.c65e7cp+127,
  0x1.1b9ef6p+126,
  0x1.87492ap+127,
  0x1.222382p+126,
  0x1.5b8b52p+126,
  0x1.d17fb8p+125,
  0x1.d75a96p+124,
  0x1.c30d16p+127,
  0x1.e7bdd4p+125,
  0x1.83d51cp+127,
  0x1.a2a116p+127,
  0x1.cd4302p+127,
  0x1.9a8598p+126,
  0x1.b970e8p+126,
  0x1.d7876ap+127,
  0x1.74717ep+127,
  0x1.1fcf9ap+126,
  0x1.af6684p+125,
  0x1.b1df4ap+127,
  0x1.8725bcp+127,
  0x1.ab4962p+126,
  0x1.2fb354p+127,
  0x1.c3e7cep+123,
  0x1.d9e8fcp+125,
  0x1.a09a8cp+126,
  0x1.8e18dep+126,
  0x1.e80d9p+126,
  0x1.3cadf4p+127,
  0x1.3bc8ccp+127,
  0x1.50343p+127,
  0x1.336d7cp+126,
  0x1.e2c9aep+127,
  0x1.5dae1ap+124,
  0x1.83978ep+125,
  0x1.2c773ep+127,
  0x1.749a88p+127,
  0x1.173132p+127,
  0x1.be29c8p+127,
  0x1.8e5086p+127,
  0x1.f72e64p+126,
  0x1.3eca7p+126,
  0x1.f0a142p+126,
  0x1.5b3f8p+126,
  0x1.d55e42p+127,
  0x1.c81a8cp+127,
  0x1.b79606p+127,
  0x1.fc6f04p+127,
  0x1.58063ap+127,
  0x1.0d1a22p+127,
  0x1.069758p+126,
  0x1.62cd96p+126,
  0x1.281e62p+127,
  0x1.ce0452p+127,
  0x1.96091ep+127,
  0x1.aaf09cp+127,
  0x1.396d14p+127,
  0x1.22b532p+127,
  0x1.96bef6p+126,
  0x1.133f7ap+127,
  0x1.56a378p+127,
  0x1.4cac76p+124,
  0x1.5a9982p+127,
  0x1.1fec6cp+126,
  0x1.617aep+127,
  0x1.fb6e1ap+125,
  0x1.fbf4c2p+127,
  0x1.682c3ap+127,
  0x1.1b423ep+126,
  0x1.54b2a8p+127,
  0x1.220266p+126,
  0x1.28a24ep+127,
  0x1.0e7a56p+127,
  0x1.31abbap+126,
  0x1.1751b4p+127,
  0x1.ecfebap+125,
  0x1.f4bb3p+127,
  0x1.82e5ap+127,
  0x1.42668p+127,
  0x1.68f3fp+126,
  0x1.bcad04p+127,
  0x1.8d1a48p+127,
  0x1.d89f28p+125,
  0x1.14ed08p+127,
  0x1.b1e278p+126,
  0x1.aabd4ep+126,
  0x1.bb2f9ep+126,
  0x1.e3a244p+125,
  0x1.74b5e8p+126,
  0x1.4bb0ap+126,
  0x1.d306d8p+126,
  0x1.f9ccc4p+127,
  0x1.457a3p+126,
  0x1.3e3f22p+127,
  0x1.d2c572p+125,
  0x1.06614p+127,
  0x1.d620fep+127,
  0x1.edeedep+126,
  0x1.f38ebcp+124,
  0x1.d4c7d6p+124,
  0x1.2c215ep+125,
  0x1.82a0cp+127,
  0x1.374cc4p+127,
  0x1.6b78d6p+127,
  0x1.ec3888p+124,
  0x1.13ff7cp+125,
  0x1.fe7da4p+127,
  0x1.fe2b78p+127,
  0x1.93caa6p+127,
  0x1.9bfb5cp+126,
  0x1.d429cep+127,
  0x1.bac4eep+126,
  0x1.65e5c4p+127,
  0x1.b4c75p+127,
  0x1.005f34p+127,
  0x1.62c18p+127,
  0x1.2bb578p+126,
  0x1.5819d4p+127,
  0x1.f14b7ep+125,
  0x1.c12884p+127,
  0x1.ea20e4p+127,
  0x1.b39a3p+125,
  0x1.d1484cp+125,
  0x1.4a010ep+127,
  0x1.f61a9p+125,
  0x1.eba3f8p+127,
  0x1.c44ac2p+127,
  0x1.c85236p+126,
  0x1.373ef6p+126,
  0x1.b65944p+127,
  0x1.dfd602p+122,
  0x1.d1182ap+123,
  0x1.2e5376p+127,
  0x1.8719d6p+127,
  0x1.bc20eep+124,
  0x1.d275a6p+126,
  0x1.1ef032p+126,
  0x1.c50fb4p+127,
  0x1.34195cp+126,
  0x1.a0d1d6p+127,
  0x1.e5ee3ap+127,
  0x1.4c6afp+126,
  0x1.1c5a1cp+126,
  0x1.e4113p+124,
  0x1.ab666p+127,
  0x1.2ca26ap+124,
  0x1.86565cp+122,
  0x1.ba16ep+126,
  0x1.f21cd2p+126,
  0x1.f53658p+125,
  0x1.e5e022p+124,
  0x1.b070dap+125,
  0x1.7b9098p+127,
  0x1.b1ad22p+124,
  0x1.742ee6p+126,
  0x1.dcf93ep+127,
  0x1.c1ac14p+127,
  0x1.f81038p+124,
  0x1.4d8ffap+125,
  0x1.a8fdf4p+125,
  0x1.d4332ap+127,
  0x1.78dbacp+126,
  0x1.7cfcfp+125,
  0x1.464bcep+127,
  0x1.171a04p+123,
  0x1.fb2d7ep+127,
  0x1.2340bep+123,
  0x1.a53a92p+127,
  0x1.d0daaap+127,
  0x1.ba199cp+123,
  0x1.9c7d52p+126,
  0x1.a928ep+126,
  0x1.9fa44ep+127,
  0x1.8d2d1ap+127,
  0x1.81fdb6p+126,
  0x1.54129ep+126,
  0x1.e976f8p+126,
  0x1.bc0c0cp+127,
  0x1.42729cp+126,
  0x1.a24a0cp+125,
  0x1.170858p+125,
  0x1.66fa7ep+125,
  0x1.2007e2p+121,
  0x1.83ab7cp+127,
  0x1.dfe674p+127,
  0x1.1de1c4p+124,
  0x1.d19682p+127,
  0x1.e7e5f4p+126,
  0x1.638758p+127,
  0x1.49092p+127,
  0x1.fb0d18p+125,
  0x1.cca50ep+127,
  0x1.abc118p+127,
  0x1.e4d062p+127,
  0x1.abc75p+127,
  0x1.b0b0aep+127,
  0x1.2c9a02p+125,
  0x1.0ead8p+126,
  0x1.9cca28p+126,
  0x1.55554p+127,
  0x1.0c3d7ep+126,
  0x1.ef554p+126,
  0x1.ae6b4p+127,
  0x1.c48e9p+126,
  0x1.c4852p+127,
  0x1.f3e0ap+126,
  0x1.995e64p+127,
  0x1.3d5c84p+126,
  0x1.e9d07cp+125,
  0x1.13b1c4p+125,
  0x1.3102d4p+127,
  0x1.6b21b6p+127,
  0x1.73214ep+125,
  0x1.2a1bdcp+126,
  0x1.9deacep+126,
  0x1.8dfd08p+126,
  0x1.3e2074p+126,
  0x1.a6a1dap+127,
  0x1.45f596p+126,
  0x1.7a8c1p+126,
  0x1.b44ee4p+123,
  0x1.36b1a6p+125,
  0x1.cd9f7ap+125,
  0x1.55782ep+126,
  0x1.39db98p+127,
  0x1.d02d7p+127,
  0x1.b7d9d6p+127,
  0x1.51885cp+126,
  0x1.42465cp+127,
  0x1.9cdb78p+127,
  0x1.a112p+127,
  0x1.3f6248p+124,
  0x1.d926cep+124,
  0x1.c7058ep+126,
  0x1.f70d24p+127,
  0x1.df4ef2p+127,
  0x1.f1cafp+123,
  0x1.52ee0ap+127,
  0x1.48ed9ap+127,
  0x1.16408p+127,
  0x1.af82b2p+127,
  0x1.c37f68p+127,
  0x1.1b503ap+124,
  0x1.abde4p+127,
  0x1.8f1a12p+127,
  0x1.306a8ap+127,
  0x1.edee2p+125,
  0x1.da924ep+125,
  0x1.b4f604p+126,
  0x1.c0e08ep+127,
  0x1.f4f7d2p+126,
  0x1.555576p+127,
  0x1.aea3e8p+125,
  0x1.ca5122p+126,
  0x1.60b16p+127,
  0x1.d8b02p+125,
  0x1.96786ap+126,
  0x1.25c324p+127,
  0x1.aa5fd8p+124,
  0x1.c0ae5ap+127,
  0x1.fbc3cp+125,
  0x1.3f976ep+126,
  0x1.2995cep+127,
  0x1.a0f2a8p+127,
  0x1.7f21bcp+126,
  0x1.aab454p+127,
  0x1.45d4bep+124,
  0x1.d80dd4p+127,
  0x1.48884ep+126,
  0x1.90647ap+126,
  0x1.81aa7cp+125,
  0x1.29cdcep+126,
  0x1.bb5cd4p+125,
  0x1.b0b04ep+126,
  0x1.1d6ea8p+127,
  0x1.65a3d4p+127,
  0x1.ac1d1ep+126,
  0x1.83abf4p+127,
  0x1.79669ep+126,
  0x1.6e405ap+127,
  0x1.00c8e4p+124,
  0x1.cb928ep+125,
  0x1.5a588p+126,
  0x1.128eecp+126,
  0x1.c71488p+127,
  0x1.a9e0bap+127,
  0x1.895c98p+127,
  0x1.090fcp+127,
  0x1.3bf3eep+125,
  0x1.03fa94p+125,
  0x1.c0da42p+126,
  0x1.f2066cp+126,
  0x1.1d3bdcp+127,
  0x1.5d19fcp+124,
  0x1.2abe36p+127,
  0x1.ffd886p+127,
  0x1.82fdb2p+125,
  0x1.9b47ecp+124,
  0x1.85087p+127,
  0x1.fe5428p+127,
  0x1.fe18dcp+127,
  0x1.bf922ap+126,
  0x1.bb3ccep+127,
  0x1.c16f2ep+124,
  0x1.04d8f8p+127,
  0x1.29647p+127,
  0x1.1cedc2p+127,
  0x1.125f86p+126,
  0x1.c11efcp+124,
  0x1.7deff6p+124,
  0x1.9e7ccp+126,
  0x1.4f74ap+126,
  0x1.a7c806p+126,
  0x1.1ad406p+127,
  0x1.c149f8p+127,
  0x1.9d425ap+125,
  0x1.5ee562p+127,
  0x1.6c4072p+126,
  0x1.b2297cp+126,
  0x1.2c16bap+126,
  0x1.110888p+126,
  0x1.e65c8cp+125,
  0x1.aeb1f4p+126,
  0x1.3276cap+123,
  0x1.088156p+123,
  0x1.ea93fap+127,
  0x1.305792p+127,
  0x1.c5f63p+127,
  0x1.d4c652p+125,
  0x1.be1e4ap+126,
  0x1.50ae42p+127,
  0x1.0b6732p+124,
  0x1.70f1aap+125,
  0x1.6d715p+127,
  0x1.9edc2p+127,
  0x1.9c5ffcp+124,
  0x1.b60a9ap+127,
  0x1.53de68p+127,
  0x1.8388dp+127,
  0x1.4391d6p+124,
  0x1.e9c01ap+127,
  0x1.a4f264p+127,
  0x1.e94ab4p+126,
  0x1.9368c4p+127,
  0x1.19d3f2p+124,
  0x1.5dbe48p+126,
  0x1.85d08ep+127,
  0x1.9fcd96p+125,
  0x1.e69374p+126,
  0x1.6dc07p+127,
  0x1.8147c6p+124,
  0x1.4af02p+127,
  0x1.bac7p+127,
  0x1.0e6264p+127,
  0x1.5a8062p+127,
  0x1.9085dcp+127,
  0x1.9d2418p+126,
  0x1.56f498p+127,
  0x1.18d804p+127,
  0x1.5ecb68p+126,
  0x1.852936p+124,
  0x1.5132a8p+127,
  0x1.5557f6p+127,
};

struct sincosf_range {
  const char *label;
  std::vector<float> values;
};

static const std::vector<sincosf_range> sincosf_input = {
  {"0.0 <= x < 0.1", sincosf_input0},
  {"0.1 <= x < 0.7", sincosf_input1},
  {"0.7 <= x < 3.1", sincosf_input2},
  {"-3.1 <= x < 3.1", sincosf_input3},
  {"3.3 <= x < 33.3", sincosf_input4},
  {"100.0 <= x < 1000.0", sincosf_input5},
  {"1e6 <= x < 1e32", sincosf_input6},
  {"1e32 <= x < inf", sincosf_input7},
};
