# Bionic Kernel Header Files

Bionic comes with a processed set of all of the uapi Linux kernel headers that
can safely be included by userland applications and libraries.

These clean headers are automatically generated by several scripts located
in the `tools/` directory. The tools process the original
unmodified kernel headers in order to get rid of many annoying
declarations and constructs that usually result in compilation failure.

The 'clean headers' only contain type and macro definitions, with the
exception of a couple static inline functions used for performance
reason (e.g. optimized CPU-specific byte-swapping routines).

They can be included from C++, or when compiling code in strict ANSI mode.
They can be also included before or after any Bionic C library header.

Description of the directories involved in generating the parsed kernel headers:

  * `external/kernel-headers/original/uapi/`
    Contains the uapi kernel headers found in the Android kernel. Note this
    also includes the header files that are generated by building the kernel
    sources.

  * `external/kernel-headers/original/scsi/`
    Contains copies of the kernel scsi header files. These where never
    made into uapi files, but some user space code expects that these
    headers are available.

  * `external/kernel-headers/modified/scsi/`
    Contains hand-modified versions of a few files from `original/scsi/`
    that removes the kernel specific code from these files so they can
    be used as uapi headers. The tools to process the kernel headers will
    warn if any scsi header files have changed and require new versions
    to be hand-modified.

  * `bionic/libc/kernel/uapi/`
    Contains the cleaned kernel headers and mirrors the directory structure
    in `external/kernel-headers/original/uapi/`.

  * `bionic/libc/kernel/tools/`
    Contains various Python and shell scripts used to get and re-generate
    the headers.

The tools to get/parse the headers:

  * `tools/generate_uapi_headers.sh`
    Checks out the Android kernel and generates all uapi header files.
    copies all the changed files into external/kernel-headers.

  * `tools/clean_header.py`
    Prints the clean version of a given kernel header. With the -u option,
    this will also update the corresponding clean header file if its
    content has changed. You can also process more than one file with -u.

  * `tools/update_all.py`
    Automatically update all clean headers from the content of
    `external/kernel-headers/original/`.

## How To Update The Headers

IMPORTANT IMPORTANT:

WHEN UPDATING THE HEADERS, ALWAYS CHECK THAT THE NEW CLEAN HEADERS DO
NOT BREAK THE KERNEL <-> USER ABI, FOR EXAMPLE BY CHANGING THE SIZE
OF A GIVEN TYPE. THIS TASK CANNOT BE EASILY AUTOMATED AT THE MOMENT.

Download the Android mainline kernel source code:
```
  > mkdir kernel_src
  > cd kernel_src
  kernel_src> git clone https://android.googlesource.com/kernel/common/ -b android-mainline
```

The Android mainline kernel source has tags that indicate the kernel
version to which they correspond. The format of a tag is
android-mainline-XXX, where XXX is the kernel version. For example,
android-mainline-5.10 corresponds to linux stable kernel 5.10. To check out
a particular tag:
```
  kernel_src> cd common
  kernel_src/common> git checkout tags/android-mainline-XXX
```

It is expected that a kernel update should only be performed on a valid tag.
For testing purposes, it is possible that you can use the top of tree
version, but never use that as the basis for importing new kernel headers.

Before running the command to import the headers, make sure that you have
done a lunch TARGET. The script uses a variable set by the lunch command
to determine which directory to use as the destination directory.

After running lunch, run this command to import the headers into the Android
source tree if there is a kernel source tree already checked out:
```
  bionic/libc/kernel/tools/generate_uapi_headers.sh --use-kernel-dir kernel_src
```

Run this command to automatically download the latest version of the headers
and import them if there is no checked out kernel source tree:
```
  bionic/libc/kernel/tools/generate_uapi_headers.sh --download-kernel
```

Next, run this command to copy the parsed files to bionic/libc/kernel/uapi:
```
  bionic/libc/kernel/tools/update_all.py
```

After this, you will need to build/test the tree to make sure that these
changes do not introduce any errors.
