/*
 * Copyright 2020 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef FUZZER_MEDIAMIMETYPES_H_
#define FUZZER_MEDIAMIMETYPES_H_

#include <media/stagefright/foundation/MediaDefs.h>

namespace android {

static const std::vector<const char*> kMimeTypes {
    MEDIA_MIMETYPE_IMAGE_JPEG,
    MEDIA_MIMETYPE_IMAGE_ANDROID_HEIC,
    MEDIA_MIMETYPE_VIDEO_VP8,
    MEDIA_MIMETYPE_VIDEO_VP9,
    MEDIA_MIMETYPE_VIDEO_AV1,
    MEDIA_MIMETYPE_VIDEO_AVC,
    MEDIA_MIMETYPE_VIDEO_HEVC,
    MEDIA_MIMETYPE_VIDEO_MPEG4,
    MEDIA_MIMETYPE_VIDEO_H263,
    MEDIA_MIMETYPE_VIDEO_MPEG2,
    MEDIA_MIMETYPE_VIDEO_RAW,
    MEDIA_MIMETYPE_VIDEO_DOLBY_VISION,
    MEDIA_MIMETYPE_VIDEO_SCRAMBLED,
    MEDIA_MIMETYPE_VIDEO_DIVX,
    MEDIA_MIMETYPE_VIDEO_DIVX3,
    MEDIA_MIMETYPE_VIDEO_XVID,
    MEDIA_MIMETYPE_VIDEO_MJPEG,
    MEDIA_MIMETYPE_AUDIO_AMR_NB,
    MEDIA_MIMETYPE_AUDIO_AMR_WB,
    MEDIA_MIMETYPE_AUDIO_MPEG,
    MEDIA_MIMETYPE_AUDIO_MPEG_LAYER_I,
    MEDIA_MIMETYPE_AUDIO_MPEG_LAYER_II,
    MEDIA_MIMETYPE_AUDIO_MIDI,
    MEDIA_MIMETYPE_AUDIO_AAC,
    MEDIA_MIMETYPE_AUDIO_QCELP,
    MEDIA_MIMETYPE_AUDIO_VORBIS,
    MEDIA_MIMETYPE_AUDIO_OPUS,
    MEDIA_MIMETYPE_AUDIO_G711_ALAW,
    MEDIA_MIMETYPE_AUDIO_G711_MLAW,
    MEDIA_MIMETYPE_AUDIO_RAW,
    MEDIA_MIMETYPE_AUDIO_FLAC,
    MEDIA_MIMETYPE_AUDIO_AAC_ADTS,
    MEDIA_MIMETYPE_AUDIO_MSGSM,
    MEDIA_MIMETYPE_AUDIO_AC3,
    MEDIA_MIMETYPE_AUDIO_EAC3,
    MEDIA_MIMETYPE_AUDIO_EAC3_JOC,
    MEDIA_MIMETYPE_AUDIO_AC4,
    MEDIA_MIMETYPE_AUDIO_SCRAMBLED,
    MEDIA_MIMETYPE_AUDIO_ALAC,
    MEDIA_MIMETYPE_AUDIO_WMA,
    MEDIA_MIMETYPE_AUDIO_MS_ADPCM,
    MEDIA_MIMETYPE_AUDIO_DVI_IMA_ADPCM,
    MEDIA_MIMETYPE_CONTAINER_MPEG4,
    MEDIA_MIMETYPE_CONTAINER_WAV,
    MEDIA_MIMETYPE_CONTAINER_OGG,
    MEDIA_MIMETYPE_CONTAINER_MATROSKA,
    MEDIA_MIMETYPE_CONTAINER_MPEG2TS,
    MEDIA_MIMETYPE_CONTAINER_AVI,
    MEDIA_MIMETYPE_CONTAINER_MPEG2PS,
    MEDIA_MIMETYPE_CONTAINER_HEIF,
    MEDIA_MIMETYPE_TEXT_3GPP,
    MEDIA_MIMETYPE_TEXT_SUBRIP,
    MEDIA_MIMETYPE_TEXT_VTT,
    MEDIA_MIMETYPE_TEXT_CEA_608,
    MEDIA_MIMETYPE_TEXT_CEA_708,
    MEDIA_MIMETYPE_DATA_TIMED_ID3
};

}  // namespace android

#endif  // FUZZER_MEDIAMIMETYPES_H_
