/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//#define LOG_NDEBUG 0
#define LOG_TAG "C2Config"
#include <utils/Log.h>

/**
 * Define and initialize global config field descriptors in this cpp file
 */
#define __C2_GENERATE_GLOBAL_VARS__
#include <C2Config.h>

DEFINE_C2_ENUM_VALUE_CUSTOM_HELPER(C2Config::profile_t, ({
        { "unused", C2Config::PROFILE_UNUSED },
        { "aac-lc", C2Config::PROFILE_AAC_LC },
        { "aac-main", C2Config::PROFILE_AAC_MAIN },
        { "aac-ssr", C2Config::PROFILE_AAC_SSR },
        { "aac-ltp", C2Config::PROFILE_AAC_LTP },
        { "aac-he", C2Config::PROFILE_AAC_HE },
        { "aac-scalable", C2Config::PROFILE_AAC_SCALABLE },
        { "aac-er-lc", C2Config::PROFILE_AAC_ER_LC },
        { "aac-er-scalable", C2Config::PROFILE_AAC_ER_SCALABLE },
        { "aac-ld", C2Config::PROFILE_AAC_LD },
        { "aac-he-ps", C2Config::PROFILE_AAC_HE_PS },
        { "aac-eld", C2Config::PROFILE_AAC_ELD },
        { "aac-xhe", C2Config::PROFILE_AAC_XHE },
        { "mp2v-simple", C2Config::PROFILE_MP2V_SIMPLE },
        { "mp2v-main", C2Config::PROFILE_MP2V_MAIN },
        { "mp2v-snr-scalable", C2Config::PROFILE_MP2V_SNR_SCALABLE },
        { "mp2v-spatially-scalable", C2Config::PROFILE_MP2V_SPATIALLY_SCALABLE },
        { "mp2v-high", C2Config::PROFILE_MP2V_HIGH },
        { "mp2v-422", C2Config::PROFILE_MP2V_422 },
        { "mp2v-multiview", C2Config::PROFILE_MP2V_MULTIVIEW },
        { "h263-baseline", C2Config::PROFILE_H263_BASELINE },
        { "h263-h320", C2Config::PROFILE_H263_H320 },
        { "h263-v1bc", C2Config::PROFILE_H263_V1BC },
        { "h263-iswv2", C2Config::PROFILE_H263_ISWV2 },
        { "h263-iswv3", C2Config::PROFILE_H263_ISWV3 },
        { "h263-high-compression", C2Config::PROFILE_H263_HIGH_COMPRESSION },
        { "h263-internet", C2Config::PROFILE_H263_INTERNET },
        { "h263-interlace", C2Config::PROFILE_H263_INTERLACE },
        { "h263-high-latency", C2Config::PROFILE_H263_HIGH_LATENCY },
        { "mp4v-simple", C2Config::PROFILE_MP4V_SIMPLE },
        { "mp4v-simple-scalable", C2Config::PROFILE_MP4V_SIMPLE_SCALABLE },
        { "mp4v-core", C2Config::PROFILE_MP4V_CORE },
        { "mp4v-main", C2Config::PROFILE_MP4V_MAIN },
        { "mp4v-nbit", C2Config::PROFILE_MP4V_NBIT },
        { "mp4v-arts", C2Config::PROFILE_MP4V_ARTS },
        { "mp4v-core-scalable", C2Config::PROFILE_MP4V_CORE_SCALABLE },
        { "mp4v-ace", C2Config::PROFILE_MP4V_ACE },
        { "mp4v-advanced-core", C2Config::PROFILE_MP4V_ADVANCED_CORE },
        { "mp4v-simple-studio", C2Config::PROFILE_MP4V_SIMPLE_STUDIO },
        { "mp4v-core-studio", C2Config::PROFILE_MP4V_CORE_STUDIO },
        { "mp4v-advanced-simple", C2Config::PROFILE_MP4V_ADVANCED_SIMPLE },
        { "mp4v-fgs", C2Config::PROFILE_MP4V_FGS },
        { "avc-baseline", C2Config::PROFILE_AVC_BASELINE },
        { "avc-constrained-baseline", C2Config::PROFILE_AVC_CONSTRAINED_BASELINE },
        { "avc-main", C2Config::PROFILE_AVC_MAIN },
        { "avc-extended", C2Config::PROFILE_AVC_EXTENDED },
        { "avc-high", C2Config::PROFILE_AVC_HIGH },
        { "avc-progressive-high", C2Config::PROFILE_AVC_PROGRESSIVE_HIGH },
        { "avc-constrained-high", C2Config::PROFILE_AVC_CONSTRAINED_HIGH },
        { "avc-high-10", C2Config::PROFILE_AVC_HIGH_10 },
        { "avc-progressive-high-10", C2Config::PROFILE_AVC_PROGRESSIVE_HIGH_10 },
        { "avc-high-422", C2Config::PROFILE_AVC_HIGH_422 },
        { "avc-high-444-predictive", C2Config::PROFILE_AVC_HIGH_444_PREDICTIVE },
        { "avc-high-10-intra", C2Config::PROFILE_AVC_HIGH_10_INTRA },
        { "avc-high-422-intra", C2Config::PROFILE_AVC_HIGH_422_INTRA },
        { "avc-high-444-intra", C2Config::PROFILE_AVC_HIGH_444_INTRA },
        { "avc-cavlc-444-intra", C2Config::PROFILE_AVC_CAVLC_444_INTRA },
        { "avc-scalable-baseline", C2Config::PROFILE_AVC_SCALABLE_BASELINE },
        { "avc-scalable-constrained-baseline", C2Config::PROFILE_AVC_SCALABLE_CONSTRAINED_BASELINE },
        { "avc-scalable-high", C2Config::PROFILE_AVC_SCALABLE_HIGH },
        { "avc-scalable-constrained-high", C2Config::PROFILE_AVC_SCALABLE_CONSTRAINED_HIGH },
        { "avc-scalable-high-intra", C2Config::PROFILE_AVC_SCALABLE_HIGH_INTRA },
        { "avc-multiview-high", C2Config::PROFILE_AVC_MULTIVIEW_HIGH },
        { "avc-stereo-high", C2Config::PROFILE_AVC_STEREO_HIGH },
        { "avc-mfc-high", C2Config::PROFILE_AVC_MFC_HIGH },
        { "avc-multiview-depth-high", C2Config::PROFILE_AVC_MULTIVIEW_DEPTH_HIGH },
        { "avc-mfc-depth-high", C2Config::PROFILE_AVC_MFC_DEPTH_HIGH },
        { "avc-enhanced-multiview-depth-high", C2Config::PROFILE_AVC_ENHANCED_MULTIVIEW_DEPTH_HIGH },
        { "hevc-main", C2Config::PROFILE_HEVC_MAIN },
        { "hevc-main-10", C2Config::PROFILE_HEVC_MAIN_10 },
        { "hevc-main-still", C2Config::PROFILE_HEVC_MAIN_STILL },
        { "hevc-mono", C2Config::PROFILE_HEVC_MONO },
        { "hevc-mono-12", C2Config::PROFILE_HEVC_MONO_12 },
        { "hevc-mono-16", C2Config::PROFILE_HEVC_MONO_16 },
        { "hevc-main-12", C2Config::PROFILE_HEVC_MAIN_12 },
        { "hevc-main-422-10", C2Config::PROFILE_HEVC_MAIN_422_10 },
        { "hevc-main-422-12", C2Config::PROFILE_HEVC_MAIN_422_12 },
        { "hevc-main-444", C2Config::PROFILE_HEVC_MAIN_444 },
        { "hevc-main-444-10", C2Config::PROFILE_HEVC_MAIN_444_10 },
        { "hevc-main-444-12", C2Config::PROFILE_HEVC_MAIN_444_12 },
        { "hevc-main-intra", C2Config::PROFILE_HEVC_MAIN_INTRA },
        { "hevc-main-10-intra", C2Config::PROFILE_HEVC_MAIN_10_INTRA },
        { "hevc-main-12-intra", C2Config::PROFILE_HEVC_MAIN_12_INTRA },
        { "hevc-main-422-10-intra", C2Config::PROFILE_HEVC_MAIN_422_10_INTRA },
        { "hevc-main-422-12-intra", C2Config::PROFILE_HEVC_MAIN_422_12_INTRA },
        { "hevc-main-444-intra", C2Config::PROFILE_HEVC_MAIN_444_INTRA },
        { "hevc-main-444-10-intra", C2Config::PROFILE_HEVC_MAIN_444_10_INTRA },
        { "hevc-main-444-12-intra", C2Config::PROFILE_HEVC_MAIN_444_12_INTRA },
        { "hevc-main-444-16-intra", C2Config::PROFILE_HEVC_MAIN_444_16_INTRA },
        { "hevc-main-444-still", C2Config::PROFILE_HEVC_MAIN_444_STILL },
        { "hevc-main-444-16-still", C2Config::PROFILE_HEVC_MAIN_444_16_STILL },
        { "hevc-high-444", C2Config::PROFILE_HEVC_HIGH_444 },
        { "hevc-high-444-10", C2Config::PROFILE_HEVC_HIGH_444_10 },
        { "hevc-high-444-14", C2Config::PROFILE_HEVC_HIGH_444_14 },
        { "hevc-high-444-16-intra", C2Config::PROFILE_HEVC_HIGH_444_16_INTRA },
        { "hevc-sx-main", C2Config::PROFILE_HEVC_SX_MAIN },
        { "hevc-sx-main-10", C2Config::PROFILE_HEVC_SX_MAIN_10 },
        { "hevc-sx-main-444", C2Config::PROFILE_HEVC_SX_MAIN_444 },
        { "hevc-sx-main-444-10", C2Config::PROFILE_HEVC_SX_MAIN_444_10 },
        { "hevc-sx-high-444", C2Config::PROFILE_HEVC_SX_HIGH_444 },
        { "hevc-sx-high-444-10", C2Config::PROFILE_HEVC_SX_HIGH_444_10 },
        { "hevc-sx-high-444-14", C2Config::PROFILE_HEVC_SX_HIGH_444_14 },
        { "hevc-multiview-main", C2Config::PROFILE_HEVC_MULTIVIEW_MAIN },
        { "hevc-scalable-main", C2Config::PROFILE_HEVC_SCALABLE_MAIN },
        { "hevc-scalable-main-10", C2Config::PROFILE_HEVC_SCALABLE_MAIN_10 },
        { "hevc-scalable-mono", C2Config::PROFILE_HEVC_SCALABLE_MONO },
        { "hevc-scalable-mono-12", C2Config::PROFILE_HEVC_SCALABLE_MONO_12 },
        { "hevc-scalable-mono-16", C2Config::PROFILE_HEVC_SCALABLE_MONO_16 },
        { "hevc-scalable-main-444", C2Config::PROFILE_HEVC_SCALABLE_MAIN_444 },
        { "hevc-3d-main", C2Config::PROFILE_HEVC_3D_MAIN },
        { "vp9-0", C2Config::PROFILE_VP9_0 },
        { "vp9-1", C2Config::PROFILE_VP9_1 },
        { "vp9-2", C2Config::PROFILE_VP9_2 },
        { "vp9-3", C2Config::PROFILE_VP9_3 },
}))

DEFINE_C2_ENUM_VALUE_CUSTOM_HELPER(C2Config::level_t, ({
        { "unused", C2Config::LEVEL_UNUSED },
        { "mp2v-low", C2Config::LEVEL_MP2V_LOW },
        { "mp2v-main", C2Config::LEVEL_MP2V_MAIN },
        { "mp2v-high-1440", C2Config::LEVEL_MP2V_HIGH_1440 },
        { "mp2v-high", C2Config::LEVEL_MP2V_HIGH },
        { "mp2v-highp", C2Config::LEVEL_MP2V_HIGHP },
        { "h263-10", C2Config::LEVEL_H263_10 },
        { "h263-20", C2Config::LEVEL_H263_20 },
        { "h263-30", C2Config::LEVEL_H263_30 },
        { "h263-40", C2Config::LEVEL_H263_40 },
        { "h263-45", C2Config::LEVEL_H263_45 },
        { "h263-50", C2Config::LEVEL_H263_50 },
        { "h263-60", C2Config::LEVEL_H263_60 },
        { "h263-70", C2Config::LEVEL_H263_70 },
        { "mp4v-0", C2Config::LEVEL_MP4V_0 },
        { "mp4v-0b", C2Config::LEVEL_MP4V_0B },
        { "mp4v-1", C2Config::LEVEL_MP4V_1 },
        { "mp4v-2", C2Config::LEVEL_MP4V_2 },
        { "mp4v-3", C2Config::LEVEL_MP4V_3 },
        { "mp4v-3b", C2Config::LEVEL_MP4V_3B },
        { "mp4v-4", C2Config::LEVEL_MP4V_4 },
        { "mp4v-4a", C2Config::LEVEL_MP4V_4A },
        { "mp4v-5", C2Config::LEVEL_MP4V_5 },
        { "mp4v-6", C2Config::LEVEL_MP4V_6 },
        { "avc-1", C2Config::LEVEL_AVC_1 },
        { "avc-1b", C2Config::LEVEL_AVC_1B },
        { "avc-1.1", C2Config::LEVEL_AVC_1_1 },
        { "avc-1.2", C2Config::LEVEL_AVC_1_2 },
        { "avc-1.3", C2Config::LEVEL_AVC_1_3 },
        { "avc-2", C2Config::LEVEL_AVC_2 },
        { "avc-2.1", C2Config::LEVEL_AVC_2_1 },
        { "avc-2.2", C2Config::LEVEL_AVC_2_2 },
        { "avc-3", C2Config::LEVEL_AVC_3 },
        { "avc-3.1", C2Config::LEVEL_AVC_3_1 },
        { "avc-3.2", C2Config::LEVEL_AVC_3_2 },
        { "avc-4", C2Config::LEVEL_AVC_4 },
        { "avc-4.1", C2Config::LEVEL_AVC_4_1 },
        { "avc-4.2", C2Config::LEVEL_AVC_4_2 },
        { "avc-5", C2Config::LEVEL_AVC_5 },
        { "avc-5.1", C2Config::LEVEL_AVC_5_1 },
        { "avc-5.2", C2Config::LEVEL_AVC_5_2 },
        { "hevc-main-1", C2Config::LEVEL_HEVC_MAIN_1 },
        { "hevc-main-2", C2Config::LEVEL_HEVC_MAIN_2 },
        { "hevc-main-2.1", C2Config::LEVEL_HEVC_MAIN_2_1 },
        { "hevc-main-3", C2Config::LEVEL_HEVC_MAIN_3 },
        { "hevc-main-3.1", C2Config::LEVEL_HEVC_MAIN_3_1 },
        { "hevc-main-4", C2Config::LEVEL_HEVC_MAIN_4 },
        { "hevc-main-4.1", C2Config::LEVEL_HEVC_MAIN_4_1 },
        { "hevc-main-5", C2Config::LEVEL_HEVC_MAIN_5 },
        { "hevc-main-5.1", C2Config::LEVEL_HEVC_MAIN_5_1 },
        { "hevc-main-5.2", C2Config::LEVEL_HEVC_MAIN_5_2 },
        { "hevc-main-6", C2Config::LEVEL_HEVC_MAIN_6 },
        { "hevc-main-6.1", C2Config::LEVEL_HEVC_MAIN_6_1 },
        { "hevc-main-6.2", C2Config::LEVEL_HEVC_MAIN_6_2 },
        { "hevc-high-4", C2Config::LEVEL_HEVC_HIGH_4 },
        { "hevc-high-4.1", C2Config::LEVEL_HEVC_HIGH_4_1 },
        { "hevc-high-5", C2Config::LEVEL_HEVC_HIGH_5 },
        { "hevc-high-5.1", C2Config::LEVEL_HEVC_HIGH_5_1 },
        { "hevc-high-5.2", C2Config::LEVEL_HEVC_HIGH_5_2 },
        { "hevc-high-6", C2Config::LEVEL_HEVC_HIGH_6 },
        { "hevc-high-6.1", C2Config::LEVEL_HEVC_HIGH_6_1 },
        { "hevc-high-6.2", C2Config::LEVEL_HEVC_HIGH_6_2 },
        { "vp9-1", C2Config::LEVEL_VP9_1 },
        { "vp9-1.1", C2Config::LEVEL_VP9_1_1 },
        { "vp9-2", C2Config::LEVEL_VP9_2 },
        { "vp9-2.1", C2Config::LEVEL_VP9_2_1 },
        { "vp9-3", C2Config::LEVEL_VP9_3 },
        { "vp9-3.1", C2Config::LEVEL_VP9_3_1 },
        { "vp9-4", C2Config::LEVEL_VP9_4 },
        { "vp9-4.1", C2Config::LEVEL_VP9_4_1 },
        { "vp9-5", C2Config::LEVEL_VP9_5 },
        { "vp9-5.1", C2Config::LEVEL_VP9_5_1 },
        { "vp9-5.2", C2Config::LEVEL_VP9_5_2 },
        { "vp9-6", C2Config::LEVEL_VP9_6 },
        { "vp9-6.1", C2Config::LEVEL_VP9_6_1 },
        { "vp9-6.2", C2Config::LEVEL_VP9_6_2 },
}))

DEFINE_C2_ENUM_VALUE_CUSTOM_HELPER(C2BufferData::type_t, ({
        { "invalid",        C2BufferData::INVALID },
        { "linear",         C2BufferData::LINEAR },
        { "linear-chunks",  C2BufferData::LINEAR_CHUNKS },
        { "graphic",        C2BufferData::GRAPHIC },
        { "graphic-chunks", C2BufferData::GRAPHIC_CHUNKS },
}))


