/*
 * arch/arch/mach-ixp4xx/fsg-pci.c
 *
 * FSG board-level PCI initialization
 *
 * Author: Rod Whitby <rod@whitby.id.au>
 * Maintainer: http://www.nslu2-linux.org/
 *
 * based on ixdp425-pci.c:
 *	Copyright (C) 2002 Intel Corporation.
 *	Copyright (C) 2003-2004 MontaVista Software, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#include <linux/pci.h>
#include <linux/init.h>
#include <linux/irq.h>

#include <asm/mach/pci.h>
#include <asm/mach-types.h>

void __init fsg_pci_preinit(void)
{
	set_irq_type(IRQ_FSG_PCI_INTA, IRQT_LOW);
	set_irq_type(IRQ_FSG_PCI_INTB, IRQT_LOW);
	set_irq_type(IRQ_FSG_PCI_INTC, IRQT_LOW);

	ixp4xx_pci_preinit();
}

static int __init fsg_map_irq(struct pci_dev *dev, u8 slot, u8 pin)
{
	static int pci_irq_table[FSG_PCI_IRQ_LINES] = {
		IRQ_FSG_PCI_INTC,
		IRQ_FSG_PCI_INTB,
		IRQ_FSG_PCI_INTA,
	};

	int irq = -1;
	slot = slot - 11;

	if (slot >= 1 && slot <= FSG_PCI_MAX_DEV &&
	    pin >= 1 && pin <= FSG_PCI_IRQ_LINES)
		irq = pci_irq_table[(slot - 1)];
	printk(KERN_INFO "%s: Mapped slot %d pin %d to IRQ %d\n",
	       __func__, slot, pin, irq);

	return irq;
}

struct hw_pci fsg_pci __initdata = {
	.nr_controllers = 1,
	.preinit =	  fsg_pci_preinit,
	.swizzle =	  pci_std_swizzle,
	.setup =	  ixp4xx_setup,
	.scan =		  ixp4xx_scan_bus,
	.map_irq =	  fsg_map_irq,
};

int __init fsg_pci_init(void)
{
	if (machine_is_fsg())
		pci_common_init(&fsg_pci);
	return 0;
}

subsys_initcall(fsg_pci_init);
