#ifndef __ACPI_NUMA_H
#define __ACPI_NUMA_H

#ifdef CONFIG_ACPI_NUMA
#include <linux/kernel.h>

/* Proximity bitmap length */
#if MAX_NUMNODES > 256
#define MAX_PXM_DOMAINS MAX_NUMNODES
#else
#define MAX_PXM_DOMAINS (256)	/* Old pxm spec is defined 8 bit */
#endif

extern int pxm_to_node(int);
extern int node_to_pxm(int);
extern int __cpuinit acpi_map_pxm_to_node(int);
extern void __cpuinit acpi_unmap_pxm_to_node(int);

#endif				/* CONFIG_ACPI_NUMA */
#endif				/* __ACP_NUMA_H */
