#ifndef _ASM_SCORE_IRQ_H
#define _ASM_SCORE_IRQ_H

#define EXCEPTION_VECTOR_BASE_ADDR	0xa0000000
#define VECTOR_ADDRESS_OFFSET_MODE4	0
#define VECTOR_ADDRESS_OFFSET_MODE16	1

#define DEBUG_VECTOR_SIZE		(0x4)
#define DEBUG_VECTOR_BASE_ADDR		((EXCEPTION_VECTOR_BASE_ADDR) + 0x1fc)

#define GENERAL_VECTOR_SIZE		(0x10)
#define GENERAL_VECTOR_BASE_ADDR	((EXCEPTION_VECTOR_BASE_ADDR) + 0x200)

#define NR_IRQS				64
#define IRQ_VECTOR_SIZE			(0x10)
#define IRQ_VECTOR_BASE_ADDR		((EXCEPTION_VECTOR_BASE_ADDR) + 0x210)
#define IRQ_VECTOR_END_ADDR		((EXCEPTION_VECTOR_BASE_ADDR) + 0x5f0)

#define irq_canonicalize(irq)	(irq)

#define P_INT_PNDL		0x95F50000
#define P_INT_PNDH		0x95F50004
#define P_INT_PRIORITY_M	0x95F50008
#define P_INT_PRIORITY_SG0	0x95F50010
#define P_INT_PRIORITY_SG1	0x95F50014
#define P_INT_PRIORITY_SG2	0x95F50018
#define P_INT_PRIORITY_SG3	0x95F5001C
#define P_INT_MASKL		0x95F50020
#define P_INT_MASKH		0x95F50024

#define IRQ_TIMER (7)		/* Timer IRQ number of SPCT6600 */

#endif /* _ASM_SCORE_IRQ_H */
