/* linux/driver/spi/spi_aic3254_reg.h
 *
 * Copyright (C) 2010 HTC Corporation.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef __SPI_AIC3254_REG_H__
#define __SPI_AIC3254_REG_H__
/* The default setting for TI AIC3254 audio codec */
#if 0
static CODEC_SPI_CMD CODEC_INIT_REG[] = {
	/* A00,Initial */
	{'w', 0x00, 0x01},
	{'w', 0x01, 0x00},
	{'w', 0x02, 0x21},
	{'w', 0x7B, 0x01},
	{'w', 0x00, 0x00},
	{'w', 0x06, 0x18},
	{'w', 0x05, 0x51},
	{'w', 0x04, 0x03},
	{'w', 0x05, 0xD1},
	{'w', 0x0B, 0x83},
	{'w', 0x0C, 0x85},
	{'w', 0x12, 0x83},
	{'w', 0x13, 0x85},
	{'w', 0x00, 0x01},
	{'w', 0x0A, 0x3B},
	{'w', 0x0C, 0x08},
	{'w', 0x0D, 0x08},
	{'w', 0x0E, 0x08},
	{'w', 0x0F, 0x08},
	{'w', 0x10, 0x00},
	{'w', 0x11, 0x00},
	{'w', 0x12, 0x00},
	{'w', 0x13, 0x00},
	{'w', 0x00, 0x00},
	{'w', 0x40, 0x00},
	{'w', 0x52, 0x00},
	{'w', 0x1B, 0x00},
	{'w', 0x1E, 0x00}
};
#endif

static CODEC_SPI_CMD Uplink_EMIC[] = {
	{'w', 0x00, 0x01},
	{'w', 0x0F, 0x02},
	{'w', 0x09, 0x0D},
	{'w', 0x37, 0x08},
	{'w', 0x39, 0x80},
	{'w', 0x3B, 0x28},
	{'w', 0x3C, 0x28},
	{'w', 0x00, 0x00},
	{'w', 0x51, 0x40},
	{'w', 0x53, 0x00},
	{'w', 0x54, 0x00}
};

#if 0
static CODEC_SPI_CMD Uplink_IMIC[] = {
	/* A01,Call_Uplink_IMIC_Receiver */
	{'w', 0x00, 0x01},
	{'w', 0x34, 0x08},
	{'w', 0x36, 0x80},
	{'w', 0x3B, 0x28},
	{'w', 0x3C, 0x28},
	{'w', 0x00, 0x00},
	{'w', 0x51, 0x80},
	{'w', 0x53, 0x00},
	{'w', 0x54, 0x00}
};

static CODEC_SPI_CMD Uplink_IMIC_LineOut[] = {
	/* B02 */
	{'w', 0x00, 0x01},
	{'w', 0x0E, 0x02},
	{'w', 0x09, 0x3F},
	{'w', 0x12, 0x3E},
	{'w', 0x13, 0x3E},
	{'w', 0x00, 0x00},
	{'w', 0x41, 0x00},
	{'w', 0x42, 0x00},
	{'w', 0x3F, 0xF6}
};

static CODEC_SPI_CMD Uplink_EMIC_LineOut[] = {
	{'w', 0x00, 0x01},
	{'w', 0x0E, 0x02},
	{'w', 0x09, 0x3D},
	{'w', 0x12, 0x03},
	{'w', 0x13, 0x3E},
	{'w', 0x00, 0x00},
	{'w', 0x41, 0x00},
	{'w', 0x42, 0x00},
	{'w', 0x3F, 0xD6}
};
#endif

static CODEC_SPI_CMD Downlink_IMIC_Receiver[] = {
	/* B08 */
	{'w', 0x00, 0x01},
	{'w', 0x09, 0x3F},
	{'w', 0x10, 0x00},
	{'w', 0x11, 0x00},
	{'w', 0x0D, 0x10},
	{'w', 0x00, 0x00},
	{'w', 0x41, 0x0C},
	{'w', 0x42, 0x0C},
	{'w', 0x3F, 0xF6},
	{'w', 0x40, 0x80},
};

static CODEC_SPI_CMD CODEC_UPLINK_OFF[] = {
	/* A29,Uplink_Off */
	{'w', 0x00, 0x01},
	{'w', 0x34, 0x00},
	{'w', 0x36, 0x00},
	{'w', 0x39, 0x00},
	{'w', 0x37, 0x00},
	{'w', 0x3B, 0x80},
	{'w', 0x3C, 0x80},
	{'w', 0x00, 0x00},
	{'w', 0x52, 0x88},
	{'w', 0x53, 0x00},
	{'w', 0x54, 0x00},
	{'w', 0x54, 0x00}
};

static CODEC_SPI_CMD CODEC_UPLINK_ON[] = {
	/* A30, Uplink_Wakeup */
	{'w', 0x00, 0x01},
	{'w', 0x01, 0x08},
	{'w', 0x02, 0x21},
	{'w', 0x3D, 0x00},
	{'w', 0x47, 0x32},
	{'w', 0x00, 0x00},
	{'w', 0x3D, 0x01},
	{'w', 0x52, 0x00},
	{'w', 0x05, 0xD1},
	{'w', 0x12, 0x83},
	{'w', 0x13, 0x85},
	{'w', 0x1E, 0x94},
};

static CODEC_SPI_CMD CODEC_DOWNLINK_OFF[] = {
	/* B29,Downlink_Off */
	{'w', 0x00, 0x01},
	{'w', 0x09, 0x00},
	{'w', 0x10, 0x40},
	{'w', 0x11, 0x40},
	{'w', 0x12, 0x40},
	{'w', 0x13, 0x40},
	{'w', 0x00, 0x00},
	{'w', 0x3F, 0x16},
	{'w', 0x40, 0x0C},
	{'w', 0x41, 0x00},
	{'w', 0x42, 0x00},
	{'w', 0x40, 0x00},
	{'w', 0x0B, 0x03},
	{'w', 0x0C, 0x05},
};

static CODEC_SPI_CMD CODEC_DOWNLINK_ON[] = {
	/* B30, Downlink_Wakeup */
	{'w', 0x00, 0x01},
	{'w', 0x01, 0x08},
	{'w', 0x02, 0x21},
	{'w', 0x14, 0x25},
	{'w', 0x47, 0x32},
	{'w', 0x00, 0x00},
	{'w', 0x3C, 0x08},
	{'w', 0x40, 0x00},
	{'w', 0x05, 0xD1},
	{'w', 0x0B, 0x83},
	{'w', 0x0C, 0x85},
	{'w', 0x1E, 0x94}
};

static CODEC_SPI_CMD CODEC_POWER_OFF[] = {
	/* A31, Power_Off */
	{'w', 0x00, 0x00},
	{'w', 0x1E, 0x14},
	{'w', 0x0B, 0x03},
	{'w', 0x0C, 0x05},
	{'w', 0x12, 0x03},
	{'w', 0x13, 0x05},
	{'w', 0x05, 0x51},
	{'w', 0x51, 0x00},
	{'w', 0x3F, 0x16},
	{'w', 0x00, 0x01},
	{'w', 0x33, 0x00},
	{'w', 0x01, 0x00},
	{'w', 0x02, 0x28}
};

static CODEC_SPI_CMD FM_In_Headphone[] = {
	/* A22 */
	{'w', 0x00, 0x01},
	{'w', 0x0C, 0x02},
	{'w', 0x0D, 0x02},
	{'w', 0x09, 0x33},
	{'w', 0x34, 0x20},
	{'w', 0x36, 0x80},
	{'w', 0x37, 0x20},
	{'w', 0x39, 0x80},
	{'w', 0x3B, 0x28},
	{'w', 0x3C, 0x28},
	{'w', 0x00, 0x00},
	{'w', 0x51, 0xC0},
	{'w', 0x53, 0x00},
	{'w', 0x54, 0x00},
};

static CODEC_SPI_CMD FM_Out_Headphone[] = {
	/* B22 */
	{'w', 0x00, 0x01},
	{'w', 0x09, 0x33},
	{'w', 0x10, 0x3E},
	{'w', 0x11, 0x3E},
	{'w', 0x00, 0x00},
	{'w', 0x41, 0x00},
	{'w', 0x42, 0x00},
	{'w', 0x3F, 0xD6},
};

static CODEC_SPI_CMD FM_In_SPK[] = {
	/* A21 */
	{'w', 0x00, 0x01},
	{'w', 0x0C, 0x02},
	{'w', 0x0D, 0x02},
	{'w', 0x09, 0x33},
	{'w', 0x34, 0x20},
	{'w', 0x36, 0x80},
	{'w', 0x37, 0x20},
	{'w', 0x39, 0x80},
	{'w', 0x3B, 0x28},
	{'w', 0x3C, 0x28},
	{'w', 0x00, 0x00},
	{'w', 0x51, 0xC0},
	{'w', 0x53, 0x00},
	{'w', 0x54, 0x00},
};

static CODEC_SPI_CMD FM_Out_SPK[] = {
	/* B21 */
	{'w', 0x00, 0x01},
	{'w', 0x09, 0x33},
	{'w', 0x10, 0x00},
	{'w', 0x11, 0x00},
	{'w', 0x00, 0x00},
	{'w', 0x41, 0x00},
	{'w', 0x42, 0x00},
	{'w', 0x3F, 0x96},
	{'w', 0x40, 0x80},
};

static CODEC_SPI_CMD MECHA_Uplink_IMIC[] = {
	{'w', 0x00, 0x01},
	{'w', 0x34, 0x20},
	{'w', 0x36, 0x20},
	{'w', 0x37, 0x00},
	{'w', 0x39, 0x00},
	{'w', 0x3B, 0x28},

	{'w', 0x3C, 0xA8},
	{'w', 0x00, 0x00},
	{'w', 0x51, 0x80},
	{'w', 0x52, 0x08},
	{'w', 0x53, 0x00},
	{'w', 0x54, 0x00},
	{'w', 0x00, 0x01},
	{'w', 0x0E, 0x02},
	{'w', 0x0F, 0x02},
	{'w', 0x09, 0x3F},
	{'w', 0x12, 0x3E},
	{'w', 0x13, 0x3E},
	{'w', 0x00, 0x00},
	{'w', 0x40, 0x0C},
	{'w', 0x41, 0x00},
	{'w', 0x42, 0x00},
	{'w', 0x3F, 0xD6},
};

static CODEC_SPI_CMD CODEC_SET_VOLUME_L[] = {
	{'w', 0x00, 0x00},
	{'w', 0x41, 0x00}
};

static CODEC_SPI_CMD CODEC_SET_VOLUME_R[] = {
	{'w', 0x00, 0x00},
	{'w', 0x42, 0x00}
};

static CODEC_SPI_CMD CODEC_MICBIAS_ON[] = {
	{'w', 0x00, 0x01},
	{'w', 0x01, 0x08},
	{'w', 0x02, 0x21},
	{'w', 0x33, 0x68}
};

static CODEC_SPI_CMD CODEC_MICBIAS_OFF[] = {
	{'w', 0x00, 0x01},
	{'w', 0x33, 0x28}
};

#endif /* __SPI_AIC3254_REG_H__*/
