/*
 * NET		Generic infrastructure for INET6 connection oriented protocols.
 *
 * Authors:	Many people, see the TCPv6 sources
 *
 * 		From code originally in TCPv6
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the GNU General Public License
 *		as published by the Free Software Foundation; either version
 *		2 of the License, or (at your option) any later version.
 */
#ifndef _INET6_CONNECTION_SOCK_H
#define _INET6_CONNECTION_SOCK_H

#include <linux/types.h>

struct sock;
struct request_sock;

extern struct request_sock *inet6_csk_search_req(const struct sock *sk,
						 struct request_sock ***prevp,
						 const __u16 rport,
						 const struct in6_addr *raddr,
						 const struct in6_addr *laddr,
						 const int iif);

extern void inet6_csk_reqsk_queue_hash_add(struct sock *sk,
					   struct request_sock *req,
					   const unsigned long timeout);
#endif /* _INET6_CONNECTION_SOCK_H */
