/*
 * SH7203 Pinmux
 *
 *  Copyright (C) 2008  Magnus Damm
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 */

#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/gpio.h>
#include <asm/sh7203.h>

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PA7_DATA, PA6_DATA, PA5_DATA, PA4_DATA,
	PA3_DATA, PA2_DATA, PA1_DATA, PA0_DATA,
	PB12_DATA,
	PB11_DATA, PB10_DATA, PB9_DATA, PB8_DATA,
	PB7_DATA, PB6_DATA, PB5_DATA, PB4_DATA,
	PB3_DATA, PB2_DATA, PB1_DATA, PB0_DATA,
	PC14_DATA, PC13_DATA, PC12_DATA,
	PC11_DATA, PC10_DATA, PC9_DATA, PC8_DATA,
	PC7_DATA, PC6_DATA, PC5_DATA, PC4_DATA,
	PC3_DATA, PC2_DATA, PC1_DATA, PC0_DATA,
	PD15_DATA, PD14_DATA, PD13_DATA, PD12_DATA,
	PD11_DATA, PD10_DATA, PD9_DATA, PD8_DATA,
	PD7_DATA, PD6_DATA, PD5_DATA, PD4_DATA,
	PD3_DATA, PD2_DATA, PD1_DATA, PD0_DATA,
	PE15_DATA, PE14_DATA, PE13_DATA, PE12_DATA,
	PE11_DATA, PE10_DATA, PE9_DATA, PE8_DATA,
	PE7_DATA, PE6_DATA, PE5_DATA, PE4_DATA,
	PE3_DATA, PE2_DATA, PE1_DATA, PE0_DATA,
	PF30_DATA, PF29_DATA, PF28_DATA,
	PF27_DATA, PF26_DATA, PF25_DATA, PF24_DATA,
	PF23_DATA, PF22_DATA, PF21_DATA, PF20_DATA,
	PF19_DATA, PF18_DATA, PF17_DATA, PF16_DATA,
	PF15_DATA, PF14_DATA, PF13_DATA, PF12_DATA,
	PF11_DATA, PF10_DATA, PF9_DATA, PF8_DATA,
	PF7_DATA, PF6_DATA, PF5_DATA, PF4_DATA,
	PF3_DATA, PF2_DATA, PF1_DATA, PF0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	PA7_IN, PA6_IN, PA5_IN, PA4_IN,
	PA3_IN, PA2_IN, PA1_IN, PA0_IN,
	PB11_IN, PB10_IN, PB9_IN, PB8_IN,
	PB7_IN, PB6_IN, PB5_IN, PB4_IN,
	PB3_IN, PB2_IN, PB1_IN, PB0_IN,
	PC14_IN, PC13_IN, PC12_IN,
	PC11_IN, PC10_IN, PC9_IN, PC8_IN,
	PC7_IN, PC6_IN, PC5_IN, PC4_IN,
	PC3_IN, PC2_IN, PC1_IN, PC0_IN,
	PD15_IN, PD14_IN, PD13_IN, PD12_IN,
	PD11_IN, PD10_IN, PD9_IN, PD8_IN,
	PD7_IN, PD6_IN, PD5_IN, PD4_IN,
	PD3_IN, PD2_IN, PD1_IN, PD0_IN,
	PE15_IN, PE14_IN, PE13_IN, PE12_IN,
	PE11_IN, PE10_IN, PE9_IN, PE8_IN,
	PE7_IN, PE6_IN, PE5_IN, PE4_IN,
	PE3_IN, PE2_IN, PE1_IN, PE0_IN,
	PF30_IN, PF29_IN, PF28_IN,
	PF27_IN, PF26_IN, PF25_IN, PF24_IN,
	PF23_IN, PF22_IN, PF21_IN, PF20_IN,
	PF19_IN, PF18_IN, PF17_IN, PF16_IN,
	PF15_IN, PF14_IN, PF13_IN, PF12_IN,
	PF11_IN, PF10_IN, PF9_IN, PF8_IN,
	PF7_IN, PF6_IN, PF5_IN, PF4_IN,
	PF3_IN, PF2_IN, PF1_IN, PF0_IN,
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	PB12_OUT,
	PB11_OUT, PB10_OUT, PB9_OUT, PB8_OUT,
	PC14_OUT, PC13_OUT, PC12_OUT,
	PC11_OUT, PC10_OUT, PC9_OUT, PC8_OUT,
	PC7_OUT, PC6_OUT, PC5_OUT, PC4_OUT,
	PC3_OUT, PC2_OUT, PC1_OUT, PC0_OUT,
	PD15_OUT, PD14_OUT, PD13_OUT, PD12_OUT,
	PD11_OUT, PD10_OUT, PD9_OUT, PD8_OUT,
	PD7_OUT, PD6_OUT, PD5_OUT, PD4_OUT,
	PD3_OUT, PD2_OUT, PD1_OUT, PD0_OUT,
	PE15_OUT, PE14_OUT, PE13_OUT, PE12_OUT,
	PE11_OUT, PE10_OUT, PE9_OUT, PE8_OUT,
	PE7_OUT, PE6_OUT, PE5_OUT, PE4_OUT,
	PE3_OUT, PE2_OUT, PE1_OUT, PE0_OUT,
	PF30_OUT, PF29_OUT, PF28_OUT,
	PF27_OUT, PF26_OUT, PF25_OUT, PF24_OUT,
	PF23_OUT, PF22_OUT, PF21_OUT, PF20_OUT,
	PF19_OUT, PF18_OUT, PF17_OUT, PF16_OUT,
	PF15_OUT, PF14_OUT, PF13_OUT, PF12_OUT,
	PF11_OUT, PF10_OUT, PF9_OUT, PF8_OUT,
	PF7_OUT, PF6_OUT, PF5_OUT, PF4_OUT,
	PF3_OUT, PF2_OUT, PF1_OUT, PF0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	PB11_IOR_IN, PB11_IOR_OUT,
	PB10_IOR_IN, PB10_IOR_OUT,
	PB9_IOR_IN, PB9_IOR_OUT,
	PB8_IOR_IN, PB8_IOR_OUT,
	PB12MD_00, PB12MD_01, PB12MD_10, PB12MD_11,
	PB11MD_0, PB11MD_1,
	PB10MD_0, PB10MD_1,
	PB9MD_00, PB9MD_01, PB9MD_10,
	PB8MD_00, PB8MD_01, PB8MD_10,
	PB7MD_00, PB7MD_01, PB7MD_10, PB7MD_11,
	PB6MD_00, PB6MD_01, PB6MD_10, PB6MD_11,
	PB5MD_00, PB5MD_01, PB5MD_10, PB5MD_11,
	PB4MD_00, PB4MD_01, PB4MD_10, PB4MD_11,
	PB3MD_00, PB3MD_01, PB3MD_10, PB3MD_11,
	PB2MD_00, PB2MD_01, PB2MD_10, PB2MD_11,
	PB1MD_00, PB1MD_01, PB1MD_10, PB1MD_11,
	PB0MD_00, PB0MD_01, PB0MD_10, PB0MD_11,

	PB12IRQ_00, PB12IRQ_01, PB12IRQ_10,

	PC14MD_0, PC14MD_1,
	PC13MD_0, PC13MD_1,
	PC12MD_0, PC12MD_1,
	PC11MD_00, PC11MD_01, PC11MD_10,
	PC10MD_00, PC10MD_01, PC10MD_10,
	PC9MD_0, PC9MD_1,
	PC8MD_0, PC8MD_1,
	PC7MD_0, PC7MD_1,
	PC6MD_0, PC6MD_1,
	PC5MD_0, PC5MD_1,
	PC4MD_0, PC4MD_1,
	PC3MD_0, PC3MD_1,
	PC2MD_0, PC2MD_1,
	PC1MD_0, PC1MD_1,
	PC0MD_00, PC0MD_01, PC0MD_10,

	PD15MD_000, PD15MD_001, PD15MD_010, PD15MD_100, PD15MD_101,
	PD14MD_000, PD14MD_001, PD14MD_010, PD14MD_101,
	PD13MD_000, PD13MD_001, PD13MD_010, PD13MD_100, PD13MD_101,
	PD12MD_000, PD12MD_001, PD12MD_010, PD12MD_100, PD12MD_101,
	PD11MD_000, PD11MD_001, PD11MD_010, PD11MD_100, PD11MD_101,
	PD10MD_000, PD10MD_001, PD10MD_010, PD10MD_100, PD10MD_101,
	PD9MD_000, PD9MD_001, PD9MD_010, PD9MD_100, PD9MD_101,
	PD8MD_000, PD8MD_001, PD8MD_010, PD8MD_100, PD8MD_101,
	PD7MD_000, PD7MD_001, PD7MD_010, PD7MD_011, PD7MD_100, PD7MD_101,
	PD6MD_000, PD6MD_001, PD6MD_010, PD6MD_011, PD6MD_100, PD6MD_101,
	PD5MD_000, PD5MD_001, PD5MD_010, PD5MD_011, PD5MD_100, PD5MD_101,
	PD4MD_000, PD4MD_001, PD4MD_010, PD4MD_011, PD4MD_100, PD4MD_101,
	PD3MD_000, PD3MD_001, PD3MD_010, PD3MD_011, PD3MD_100, PD3MD_101,
	PD2MD_000, PD2MD_001, PD2MD_010, PD2MD_011, PD2MD_100, PD2MD_101,
	PD1MD_000, PD1MD_001, PD1MD_010, PD1MD_011, PD1MD_100, PD1MD_101,
	PD0MD_000, PD0MD_001, PD0MD_010, PD0MD_011, PD0MD_100, PD0MD_101,

	PE15MD_00, PE15MD_01, PE15MD_11,
	PE14MD_00, PE14MD_01, PE14MD_11,
	PE13MD_00, PE13MD_11,
	PE12MD_00, PE12MD_11,
	PE11MD_000, PE11MD_001, PE11MD_010, PE11MD_100,
	PE10MD_000, PE10MD_001, PE10MD_010, PE10MD_100,
	PE9MD_00, PE9MD_01, PE9MD_10, PE9MD_11,
	PE8MD_00, PE8MD_01, PE8MD_10, PE8MD_11,
	PE7MD_000, PE7MD_001, PE7MD_010, PE7MD_011, PE7MD_100,
	PE6MD_000, PE6MD_001, PE6MD_010, PE6MD_011, PE6MD_100,
	PE5MD_000, PE5MD_001, PE5MD_010, PE5MD_011, PE5MD_100,
	PE4MD_000, PE4MD_001, PE4MD_010, PE4MD_011, PE4MD_100,
	PE3MD_00, PE3MD_01, PE3MD_11,
	PE2MD_00, PE2MD_01, PE2MD_11,
	PE1MD_00, PE1MD_01, PE1MD_10, PE1MD_11,
	PE0MD_000, PE0MD_001, PE0MD_011, PE0MD_100,

	PF30MD_0, PF30MD_1,
	PF29MD_0, PF29MD_1,
	PF28MD_0, PF28MD_1,
	PF27MD_0, PF27MD_1,
	PF26MD_0, PF26MD_1,
	PF25MD_0, PF25MD_1,
	PF24MD_0, PF24MD_1,
	PF23MD_00, PF23MD_01, PF23MD_10,
	PF22MD_00, PF22MD_01, PF22MD_10,
	PF21MD_00, PF21MD_01, PF21MD_10,
	PF20MD_00, PF20MD_01, PF20MD_10,
	PF19MD_00, PF19MD_01, PF19MD_10,
	PF18MD_00, PF18MD_01, PF18MD_10,
	PF17MD_00, PF17MD_01, PF17MD_10,
	PF16MD_00, PF16MD_01, PF16MD_10,
	PF15MD_00, PF15MD_01, PF15MD_10,
	PF14MD_00, PF14MD_01, PF14MD_10,
	PF13MD_00, PF13MD_01, PF13MD_10,
	PF12MD_00, PF12MD_01, PF12MD_10,
	PF11MD_00, PF11MD_01, PF11MD_10,
	PF10MD_00, PF10MD_01, PF10MD_10,
	PF9MD_00, PF9MD_01, PF9MD_10,
	PF8MD_00, PF8MD_01, PF8MD_10,
	PF7MD_00, PF7MD_01, PF7MD_10, PF7MD_11,
	PF6MD_00, PF6MD_01, PF6MD_10, PF6MD_11,
	PF5MD_00, PF5MD_01, PF5MD_10, PF5MD_11,
	PF4MD_00, PF4MD_01, PF4MD_10, PF4MD_11,
	PF3MD_00, PF3MD_01, PF3MD_10, PF3MD_11,
	PF2MD_00, PF2MD_01, PF2MD_10, PF2MD_11,
	PF1MD_00, PF1MD_01, PF1MD_10, PF1MD_11,
	PF0MD_00, PF0MD_01, PF0MD_10, PF0MD_11,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	PINT7_PB_MARK, PINT6_PB_MARK, PINT5_PB_MARK, PINT4_PB_MARK,
	PINT3_PB_MARK, PINT2_PB_MARK, PINT1_PB_MARK, PINT0_PB_MARK,
	PINT7_PD_MARK, PINT6_PD_MARK, PINT5_PD_MARK, PINT4_PD_MARK,
	PINT3_PD_MARK, PINT2_PD_MARK, PINT1_PD_MARK, PINT0_PD_MARK,
	IRQ7_PB_MARK, IRQ6_PB_MARK, IRQ5_PB_MARK, IRQ4_PB_MARK,
	IRQ3_PB_MARK, IRQ2_PB_MARK, IRQ1_PB_MARK, IRQ0_PB_MARK,
	IRQ7_PD_MARK, IRQ6_PD_MARK, IRQ5_PD_MARK, IRQ4_PD_MARK,
	IRQ3_PD_MARK, IRQ2_PD_MARK, IRQ1_PD_MARK, IRQ0_PD_MARK,
	IRQ7_PE_MARK, IRQ6_PE_MARK, IRQ5_PE_MARK, IRQ4_PE_MARK,
	IRQ3_PE_MARK, IRQ2_PE_MARK, IRQ1_PE_MARK, IRQ0_PE_MARK,
	WDTOVF_MARK, IRQOUT_MARK, REFOUT_MARK, IRQOUT_REFOUT_MARK,
	UBCTRG_MARK,
	CTX1_MARK, CRX1_MARK, CTX0_MARK, CTX0_CTX1_MARK,
	CRX0_MARK, CRX0_CRX1_MARK,
	SDA3_MARK, SCL3_MARK,
	SDA2_MARK, SCL2_MARK,
	SDA1_MARK, SCL1_MARK,
	SDA0_MARK, SCL0_MARK,
	TEND0_PD_MARK, TEND0_PE_MARK, DACK0_PD_MARK, DACK0_PE_MARK,
	DREQ0_PD_MARK, DREQ0_PE_MARK, TEND1_PD_MARK, TEND1_PE_MARK,
	DACK1_PD_MARK, DACK1_PE_MARK, DREQ1_PD_MARK, DREQ1_PE_MARK,
	DACK2_MARK, DREQ2_MARK, DACK3_MARK, DREQ3_MARK,
	ADTRG_PD_MARK, ADTRG_PE_MARK,
	D31_MARK, D30_MARK, D29_MARK, D28_MARK,
	D27_MARK, D26_MARK, D25_MARK, D24_MARK,
	D23_MARK, D22_MARK, D21_MARK, D20_MARK,
	D19_MARK, D18_MARK, D17_MARK, D16_MARK,
	A25_MARK, A24_MARK, A23_MARK, A22_MARK,
	A21_MARK, CS4_MARK, MRES_MARK, BS_MARK,
	IOIS16_MARK, CS1_MARK, CS6_CE1B_MARK, CE2B_MARK,
	CS5_CE1A_MARK, CE2A_MARK, FRAME_MARK, WAIT_MARK,
	RDWR_MARK, CKE_MARK, CASU_MARK,	BREQ_MARK,
	RASU_MARK, BACK_MARK, CASL_MARK, RASL_MARK,
	WE3_DQMUU_AH_ICIO_WR_MARK, WE2_DQMUL_ICIORD_MARK,
	WE1_DQMLU_WE_MARK, WE0_DQMLL_MARK,
	CS3_MARK, CS2_MARK, A1_MARK, A0_MARK, CS7_MARK,
	TIOC4D_MARK, TIOC4C_MARK, TIOC4B_MARK, TIOC4A_MARK,
	TIOC3D_MARK, TIOC3C_MARK, TIOC3B_MARK, TIOC3A_MARK,
	TIOC2B_MARK, TIOC1B_MARK, TIOC2A_MARK, TIOC1A_MARK,
	TIOC0D_MARK, TIOC0C_MARK, TIOC0B_MARK, TIOC0A_MARK,
	TCLKD_PD_MARK, TCLKC_PD_MARK, TCLKB_PD_MARK, TCLKA_PD_MARK,
	TCLKD_PF_MARK, TCLKC_PF_MARK, TCLKB_PF_MARK, TCLKA_PF_MARK,
	SCS0_PD_MARK, SSO0_PD_MARK, SSI0_PD_MARK, SSCK0_PD_MARK,
	SCS0_PF_MARK, SSO0_PF_MARK, SSI0_PF_MARK, SSCK0_PF_MARK,
	SCS1_PD_MARK, SSO1_PD_MARK, SSI1_PD_MARK, SSCK1_PD_MARK,
	SCS1_PF_MARK, SSO1_PF_MARK, SSI1_PF_MARK, SSCK1_PF_MARK,
	TXD0_MARK, RXD0_MARK, SCK0_MARK,
	TXD1_MARK, RXD1_MARK, SCK1_MARK,
	TXD2_MARK, RXD2_MARK, SCK2_MARK,
	RTS3_MARK, CTS3_MARK, TXD3_MARK,
	RXD3_MARK, SCK3_MARK,
	AUDIO_CLK_MARK,
	SSIDATA3_MARK, SSIWS3_MARK, SSISCK3_MARK,
	SSIDATA2_MARK, SSIWS2_MARK, SSISCK2_MARK,
	SSIDATA1_MARK, SSIWS1_MARK, SSISCK1_MARK,
	SSIDATA0_MARK, SSIWS0_MARK, SSISCK0_MARK,
	FCE_MARK, FRB_MARK,
	NAF7_MARK, NAF6_MARK, NAF5_MARK, NAF4_MARK,
	NAF3_MARK, NAF2_MARK, NAF1_MARK, NAF0_MARK,
	FSC_MARK, FOE_MARK, FCDE_MARK, FWE_MARK,
	LCD_VEPWC_MARK, LCD_VCPWC_MARK,	LCD_CLK_MARK, LCD_FLM_MARK,
	LCD_M_DISP_MARK, LCD_CL2_MARK, LCD_CL1_MARK, LCD_DON_MARK,
	LCD_DATA15_MARK, LCD_DATA14_MARK, LCD_DATA13_MARK, LCD_DATA12_MARK,
	LCD_DATA11_MARK, LCD_DATA10_MARK, LCD_DATA9_MARK, LCD_DATA8_MARK,
	LCD_DATA7_MARK, LCD_DATA6_MARK, LCD_DATA5_MARK, LCD_DATA4_MARK,
	LCD_DATA3_MARK, LCD_DATA2_MARK, LCD_DATA1_MARK, LCD_DATA0_MARK,
	PINMUX_MARK_END,
};

static pinmux_enum_t pinmux_data[] = {

	/* PA */
	PINMUX_DATA(PA7_DATA, PA7_IN),
	PINMUX_DATA(PA6_DATA, PA6_IN),
	PINMUX_DATA(PA5_DATA, PA5_IN),
	PINMUX_DATA(PA4_DATA, PA4_IN),
	PINMUX_DATA(PA3_DATA, PA3_IN),
	PINMUX_DATA(PA2_DATA, PA2_IN),
	PINMUX_DATA(PA1_DATA, PA1_IN),
	PINMUX_DATA(PA0_DATA, PA0_IN),

	/* PB */
	PINMUX_DATA(PB12_DATA, PB12MD_00, PB12_OUT),
	PINMUX_DATA(WDTOVF_MARK, PB12MD_01),
	PINMUX_DATA(IRQOUT_MARK, PB12MD_10, PB12IRQ_00),
	PINMUX_DATA(REFOUT_MARK, PB12MD_10, PB12IRQ_01),
	PINMUX_DATA(IRQOUT_REFOUT_MARK, PB12MD_10, PB12IRQ_10),
	PINMUX_DATA(UBCTRG_MARK, PB12MD_11),

	PINMUX_DATA(PB11_DATA, PB11MD_0, PB11_IN, PB11_OUT),
	PINMUX_DATA(CTX1_MARK, PB11MD_1),

	PINMUX_DATA(PB10_DATA, PB10MD_0, PB10_IN, PB10_OUT),
	PINMUX_DATA(CRX1_MARK, PB10MD_1),

	PINMUX_DATA(PB9_DATA, PB9MD_00, PB9_IN, PB9_OUT),
	PINMUX_DATA(CTX0_MARK, PB9MD_01),
	PINMUX_DATA(CTX0_CTX1_MARK, PB9MD_10),

	PINMUX_DATA(PB8_DATA, PB8MD_00, PB8_IN, PB8_OUT),
	PINMUX_DATA(CRX0_MARK, PB8MD_01),
	PINMUX_DATA(CRX0_CRX1_MARK, PB8MD_10),

	PINMUX_DATA(PB7_DATA, PB7MD_00, PB7_IN),
	PINMUX_DATA(SDA3_MARK, PB7MD_01),
	PINMUX_DATA(PINT7_PB_MARK, PB7MD_10),
	PINMUX_DATA(IRQ7_PB_MARK, PB7MD_11),

	PINMUX_DATA(PB6_DATA, PB6MD_00, PB6_IN),
	PINMUX_DATA(SCL3_MARK, PB6MD_01),
	PINMUX_DATA(PINT6_PB_MARK, PB6MD_10),
	PINMUX_DATA(IRQ6_PB_MARK, PB6MD_11),

	PINMUX_DATA(PB5_DATA, PB5MD_00, PB5_IN),
	PINMUX_DATA(SDA2_MARK, PB6MD_01),
	PINMUX_DATA(PINT5_PB_MARK, PB6MD_10),
	PINMUX_DATA(IRQ5_PB_MARK, PB6MD_11),

	PINMUX_DATA(PB4_DATA, PB4MD_00, PB4_IN),
	PINMUX_DATA(SCL2_MARK, PB4MD_01),
	PINMUX_DATA(PINT4_PB_MARK, PB4MD_10),
	PINMUX_DATA(IRQ4_PB_MARK, PB4MD_11),

	PINMUX_DATA(PB3_DATA, PB3MD_00, PB3_IN),
	PINMUX_DATA(SDA1_MARK, PB3MD_01),
	PINMUX_DATA(PINT3_PB_MARK, PB3MD_10),
	PINMUX_DATA(IRQ3_PB_MARK, PB3MD_11),

	PINMUX_DATA(PB2_DATA, PB2MD_00, PB2_IN),
	PINMUX_DATA(SCL1_MARK, PB2MD_01),
	PINMUX_DATA(PINT2_PB_MARK, PB2MD_10),
	PINMUX_DATA(IRQ2_PB_MARK, PB2MD_11),

	PINMUX_DATA(PB1_DATA, PB1MD_00, PB1_IN),
	PINMUX_DATA(SDA0_MARK, PB1MD_01),
	PINMUX_DATA(PINT1_PB_MARK, PB1MD_10),
	PINMUX_DATA(IRQ1_PB_MARK, PB1MD_11),

	PINMUX_DATA(PB0_DATA, PB0MD_00, PB0_IN),
	PINMUX_DATA(SCL0_MARK, PB0MD_01),
	PINMUX_DATA(PINT0_PB_MARK, PB0MD_10),
	PINMUX_DATA(IRQ0_PB_MARK, PB0MD_11),

	/* PC */
	PINMUX_DATA(PC14_DATA, PC14MD_0, PC14_IN, PC14_OUT),
	PINMUX_DATA(WAIT_MARK, PC14MD_1),

	PINMUX_DATA(PC13_DATA, PC13MD_0, PC13_IN, PC13_OUT),
	PINMUX_DATA(RDWR_MARK, PC13MD_1),

	PINMUX_DATA(PC12_DATA, PC12MD_0, PC12_IN, PC12_OUT),
	PINMUX_DATA(CKE_MARK, PC12MD_1),

	PINMUX_DATA(PC11_DATA, PC11MD_00, PC11_IN, PC11_OUT),
	PINMUX_DATA(CASU_MARK, PC11MD_01),
	PINMUX_DATA(BREQ_MARK, PC11MD_10),

	PINMUX_DATA(PC10_DATA, PC10MD_00, PC10_IN, PC10_OUT),
	PINMUX_DATA(RASU_MARK, PC10MD_01),
	PINMUX_DATA(BACK_MARK, PC10MD_10),

	PINMUX_DATA(PC9_DATA, PC9MD_0, PC9_IN, PC9_OUT),
	PINMUX_DATA(CASL_MARK, PC9MD_1),

	PINMUX_DATA(PC8_DATA, PC8MD_0, PC8_IN, PC8_OUT),
	PINMUX_DATA(RASL_MARK, PC8MD_1),

	PINMUX_DATA(PC7_DATA, PC7MD_0, PC7_IN, PC7_OUT),
	PINMUX_DATA(WE3_DQMUU_AH_ICIO_WR_MARK, PC7MD_1),

	PINMUX_DATA(PC6_DATA, PC6MD_0, PC6_IN, PC6_OUT),
	PINMUX_DATA(WE2_DQMUL_ICIORD_MARK, PC6MD_1),

	PINMUX_DATA(PC5_DATA, PC5MD_0, PC5_IN, PC5_OUT),
	PINMUX_DATA(WE1_DQMLU_WE_MARK, PC5MD_1),

	PINMUX_DATA(PC4_DATA, PC4MD_0, PC4_IN, PC4_OUT),
	PINMUX_DATA(WE0_DQMLL_MARK, PC4MD_1),

	PINMUX_DATA(PC3_DATA, PC3MD_0, PC3_IN, PC3_OUT),
	PINMUX_DATA(CS3_MARK, PC3MD_1),

	PINMUX_DATA(PC2_DATA, PC2MD_0, PC2_IN, PC2_OUT),
	PINMUX_DATA(CS2_MARK, PC2MD_1),

	PINMUX_DATA(PC1_DATA, PC1MD_0, PC1_IN, PC1_OUT),
	PINMUX_DATA(A1_MARK, PC1MD_1),

	PINMUX_DATA(PC0_DATA, PC0MD_00, PC0_IN, PC0_OUT),
	PINMUX_DATA(A0_MARK, PC0MD_01),
	PINMUX_DATA(CS7_MARK, PC0MD_10),

	/* PD */
	PINMUX_DATA(PD15_DATA, PD15MD_000, PD15_IN, PD15_OUT),
	PINMUX_DATA(D31_MARK, PD15MD_001),
	PINMUX_DATA(PINT7_PD_MARK, PD15MD_010),
	PINMUX_DATA(ADTRG_PD_MARK, PD15MD_100),
	PINMUX_DATA(TIOC4D_MARK, PD15MD_101),

	PINMUX_DATA(PD14_DATA, PD14MD_000, PD14_IN, PD14_OUT),
	PINMUX_DATA(D30_MARK, PD14MD_001),
	PINMUX_DATA(PINT6_PD_MARK, PD14MD_010),
	PINMUX_DATA(TIOC4C_MARK, PD14MD_101),

	PINMUX_DATA(PD13_DATA, PD13MD_000, PD13_IN, PD13_OUT),
	PINMUX_DATA(D29_MARK, PD13MD_001),
	PINMUX_DATA(PINT5_PD_MARK, PD13MD_010),
	PINMUX_DATA(TEND1_PD_MARK, PD13MD_100),
	PINMUX_DATA(TIOC4B_MARK, PD13MD_101),

	PINMUX_DATA(PD12_DATA, PD12MD_000, PD12_IN, PD12_OUT),
	PINMUX_DATA(D28_MARK, PD12MD_001),
	PINMUX_DATA(PINT4_PD_MARK, PD12MD_010),
	PINMUX_DATA(DACK1_PD_MARK, PD12MD_100),
	PINMUX_DATA(TIOC4A_MARK, PD12MD_101),

	PINMUX_DATA(PD11_DATA, PD11MD_000, PD11_IN, PD11_OUT),
	PINMUX_DATA(D27_MARK, PD11MD_001),
	PINMUX_DATA(PINT3_PD_MARK, PD11MD_010),
	PINMUX_DATA(DREQ1_PD_MARK, PD11MD_100),
	PINMUX_DATA(TIOC3D_MARK, PD11MD_101),

	PINMUX_DATA(PD10_DATA, PD10MD_000, PD10_IN, PD10_OUT),
	PINMUX_DATA(D26_MARK, PD10MD_001),
	PINMUX_DATA(PINT2_PD_MARK, PD10MD_010),
	PINMUX_DATA(TEND0_PD_MARK, PD10MD_100),
	PINMUX_DATA(TIOC3C_MARK, PD10MD_101),

	PINMUX_DATA(PD9_DATA, PD9MD_000, PD9_IN, PD9_OUT),
	PINMUX_DATA(D25_MARK, PD9MD_001),
	PINMUX_DATA(PINT1_PD_MARK, PD9MD_010),
	PINMUX_DATA(DACK0_PD_MARK, PD9MD_100),
	PINMUX_DATA(TIOC3B_MARK, PD9MD_101),

	PINMUX_DATA(PD8_DATA, PD8MD_000, PD8_IN, PD8_OUT),
	PINMUX_DATA(D24_MARK, PD8MD_001),
	PINMUX_DATA(PINT0_PD_MARK, PD8MD_010),
	PINMUX_DATA(DREQ0_PD_MARK, PD8MD_100),
	PINMUX_DATA(TIOC3A_MARK, PD8MD_101),

	PINMUX_DATA(PD7_DATA, PD7MD_000, PD7_IN, PD7_OUT),
	PINMUX_DATA(D23_MARK, PD7MD_001),
	PINMUX_DATA(IRQ7_PD_MARK, PD7MD_010),
	PINMUX_DATA(SCS1_PD_MARK, PD7MD_011),
	PINMUX_DATA(TCLKD_PD_MARK, PD7MD_100),
	PINMUX_DATA(TIOC2B_MARK, PD7MD_101),

	PINMUX_DATA(PD6_DATA, PD6MD_000, PD6_IN, PD6_OUT),
	PINMUX_DATA(D22_MARK, PD6MD_001),
	PINMUX_DATA(IRQ6_PD_MARK, PD6MD_010),
	PINMUX_DATA(SSO1_PD_MARK, PD6MD_011),
	PINMUX_DATA(TCLKC_PD_MARK, PD6MD_100),
	PINMUX_DATA(TIOC2A_MARK, PD6MD_101),

	PINMUX_DATA(PD5_DATA, PD5MD_000, PD5_IN, PD5_OUT),
	PINMUX_DATA(D21_MARK, PD5MD_001),
	PINMUX_DATA(IRQ5_PD_MARK, PD5MD_010),
	PINMUX_DATA(SSI1_PD_MARK, PD5MD_011),
	PINMUX_DATA(TCLKB_PD_MARK, PD5MD_100),
	PINMUX_DATA(TIOC1B_MARK, PD5MD_101),

	PINMUX_DATA(PD4_DATA, PD4MD_000, PD4_IN, PD4_OUT),
	PINMUX_DATA(D20_MARK, PD4MD_001),
	PINMUX_DATA(IRQ4_PD_MARK, PD4MD_010),
	PINMUX_DATA(SSCK1_PD_MARK, PD4MD_011),
	PINMUX_DATA(TCLKA_PD_MARK, PD4MD_100),
	PINMUX_DATA(TIOC1A_MARK, PD4MD_101),

	PINMUX_DATA(PD3_DATA, PD3MD_000, PD3_IN, PD3_OUT),
	PINMUX_DATA(D19_MARK, PD3MD_001),
	PINMUX_DATA(IRQ3_PD_MARK, PD3MD_010),
	PINMUX_DATA(SCS0_PD_MARK, PD3MD_011),
	PINMUX_DATA(DACK3_MARK, PD3MD_100),
	PINMUX_DATA(TIOC0D_MARK, PD3MD_101),

	PINMUX_DATA(PD2_DATA, PD2MD_000, PD2_IN, PD2_OUT),
	PINMUX_DATA(D18_MARK, PD2MD_001),
	PINMUX_DATA(IRQ2_PD_MARK, PD2MD_010),
	PINMUX_DATA(SSO0_PD_MARK, PD2MD_011),
	PINMUX_DATA(DREQ3_MARK, PD2MD_100),
	PINMUX_DATA(TIOC0C_MARK, PD2MD_101),

	PINMUX_DATA(PD1_DATA, PD1MD_000, PD1_IN, PD1_OUT),
	PINMUX_DATA(D17_MARK, PD1MD_001),
	PINMUX_DATA(IRQ1_PD_MARK, PD1MD_010),
	PINMUX_DATA(SSI0_PD_MARK, PD1MD_011),
	PINMUX_DATA(DACK2_MARK, PD1MD_100),
	PINMUX_DATA(TIOC0B_MARK, PD1MD_101),

	PINMUX_DATA(PD0_DATA, PD0MD_000, PD0_IN, PD0_OUT),
	PINMUX_DATA(D16_MARK, PD0MD_001),
	PINMUX_DATA(IRQ0_PD_MARK, PD0MD_010),
	PINMUX_DATA(SSCK0_PD_MARK, PD0MD_011),
	PINMUX_DATA(DREQ2_MARK, PD0MD_100),
	PINMUX_DATA(TIOC0A_MARK, PD0MD_101),

	/* PE */
	PINMUX_DATA(PE15_DATA, PE15MD_00, PE15_IN, PE15_OUT),
	PINMUX_DATA(IOIS16_MARK, PE15MD_01),
	PINMUX_DATA(RTS3_MARK, PE15MD_11),

	PINMUX_DATA(PE14_DATA, PE14MD_00, PE14_IN, PE14_OUT),
	PINMUX_DATA(CS1_MARK, PE14MD_01),
	PINMUX_DATA(CTS3_MARK, PE14MD_11),

	PINMUX_DATA(PE13_DATA, PE13MD_00, PE13_IN, PE13_OUT),
	PINMUX_DATA(TXD3_MARK, PE13MD_11),

	PINMUX_DATA(PE12_DATA, PE12MD_00, PE12_IN, PE12_OUT),
	PINMUX_DATA(RXD3_MARK, PE12MD_11),

	PINMUX_DATA(PE11_DATA, PE11MD_000, PE11_IN, PE11_OUT),
	PINMUX_DATA(CS6_CE1B_MARK, PE11MD_001),
	PINMUX_DATA(IRQ7_PE_MARK, PE11MD_010),
	PINMUX_DATA(TEND1_PE_MARK, PE11MD_100),

	PINMUX_DATA(PE10_DATA, PE10MD_000, PE10_IN, PE10_OUT),
	PINMUX_DATA(CE2B_MARK, PE10MD_001),
	PINMUX_DATA(IRQ6_PE_MARK, PE10MD_010),
	PINMUX_DATA(TEND0_PE_MARK, PE10MD_100),

	PINMUX_DATA(PE9_DATA, PE9MD_00, PE9_IN, PE9_OUT),
	PINMUX_DATA(CS5_CE1A_MARK, PE9MD_01),
	PINMUX_DATA(IRQ5_PE_MARK, PE9MD_10),
	PINMUX_DATA(SCK3_MARK, PE9MD_11),

	PINMUX_DATA(PE8_DATA, PE8MD_00, PE8_IN, PE8_OUT),
	PINMUX_DATA(CE2A_MARK, PE8MD_01),
	PINMUX_DATA(IRQ4_PE_MARK, PE8MD_10),
	PINMUX_DATA(SCK2_MARK, PE8MD_11),

	PINMUX_DATA(PE7_DATA, PE7MD_000, PE7_IN, PE7_OUT),
	PINMUX_DATA(FRAME_MARK, PE7MD_001),
	PINMUX_DATA(IRQ3_PE_MARK, PE7MD_010),
	PINMUX_DATA(TXD2_MARK, PE7MD_011),
	PINMUX_DATA(DACK1_PE_MARK, PE7MD_100),

	PINMUX_DATA(PE6_DATA, PE6MD_000, PE6_IN, PE6_OUT),
	PINMUX_DATA(A25_MARK, PE6MD_001),
	PINMUX_DATA(IRQ2_PE_MARK, PE6MD_010),
	PINMUX_DATA(RXD2_MARK, PE6MD_011),
	PINMUX_DATA(DREQ1_PE_MARK, PE6MD_100),

	PINMUX_DATA(PE5_DATA, PE5MD_000, PE5_IN, PE5_OUT),
	PINMUX_DATA(A24_MARK, PE5MD_001),
	PINMUX_DATA(IRQ1_PE_MARK, PE5MD_010),
	PINMUX_DATA(TXD1_MARK, PE5MD_011),
	PINMUX_DATA(DACK0_PE_MARK, PE5MD_100),

	PINMUX_DATA(PE4_DATA, PE4MD_000, PE4_IN, PE4_OUT),
	PINMUX_DATA(A23_MARK, PE4MD_001),
	PINMUX_DATA(IRQ0_PE_MARK, PE4MD_010),
	PINMUX_DATA(RXD1_MARK, PE4MD_011),
	PINMUX_DATA(DREQ0_PE_MARK, PE4MD_100),

	PINMUX_DATA(PE3_DATA, PE3MD_00, PE3_IN, PE3_OUT),
	PINMUX_DATA(A22_MARK, PE3MD_01),
	PINMUX_DATA(SCK1_MARK, PE3MD_11),

	PINMUX_DATA(PE2_DATA, PE2MD_00, PE2_IN, PE2_OUT),
	PINMUX_DATA(A21_MARK, PE2MD_01),
	PINMUX_DATA(SCK0_MARK, PE2MD_11),

	PINMUX_DATA(PE1_DATA, PE1MD_00, PE1_IN, PE1_OUT),
	PINMUX_DATA(CS4_MARK, PE1MD_01),
	PINMUX_DATA(MRES_MARK, PE1MD_10),
	PINMUX_DATA(TXD0_MARK, PE1MD_11),

	PINMUX_DATA(PE0_DATA, PE0MD_000, PE0_IN, PE0_OUT),
	PINMUX_DATA(BS_MARK, PE0MD_001),
	PINMUX_DATA(RXD0_MARK, PE0MD_011),
	PINMUX_DATA(ADTRG_PE_MARK, PE0MD_100),

	/* PF */
	PINMUX_DATA(PF30_DATA, PF30MD_0, PF30_IN, PF30_OUT),
	PINMUX_DATA(AUDIO_CLK_MARK, PF30MD_1),

	PINMUX_DATA(PF29_DATA, PF29MD_0, PF29_IN, PF29_OUT),
	PINMUX_DATA(SSIDATA3_MARK, PF29MD_1),

	PINMUX_DATA(PF28_DATA, PF28MD_0, PF28_IN, PF28_OUT),
	PINMUX_DATA(SSIWS3_MARK, PF28MD_1),

	PINMUX_DATA(PF27_DATA, PF27MD_0, PF27_IN, PF27_OUT),
	PINMUX_DATA(SSISCK3_MARK, PF27MD_1),

	PINMUX_DATA(PF26_DATA, PF26MD_0, PF26_IN, PF26_OUT),
	PINMUX_DATA(SSIDATA2_MARK, PF26MD_1),

	PINMUX_DATA(PF25_DATA, PF25MD_0, PF25_IN, PF25_OUT),
	PINMUX_DATA(SSIWS2_MARK, PF25MD_1),

	PINMUX_DATA(PF24_DATA, PF24MD_0, PF24_IN, PF24_OUT),
	PINMUX_DATA(SSISCK2_MARK, PF24MD_1),

	PINMUX_DATA(PF23_DATA, PF23MD_00, PF23_IN, PF23_OUT),
	PINMUX_DATA(SSIDATA1_MARK, PF23MD_01),
	PINMUX_DATA(LCD_VEPWC_MARK, PF23MD_10),

	PINMUX_DATA(PF22_DATA, PF22MD_00, PF22_IN, PF22_OUT),
	PINMUX_DATA(SSIWS1_MARK, PF22MD_01),
	PINMUX_DATA(LCD_VCPWC_MARK, PF22MD_10),

	PINMUX_DATA(PF21_DATA, PF21MD_00, PF21_IN, PF21_OUT),
	PINMUX_DATA(SSISCK1_MARK, PF21MD_01),
	PINMUX_DATA(LCD_CLK_MARK, PF21MD_10),

	PINMUX_DATA(PF20_DATA, PF20MD_00, PF20_IN, PF20_OUT),
	PINMUX_DATA(SSIDATA0_MARK, PF20MD_01),
	PINMUX_DATA(LCD_FLM_MARK, PF20MD_10),

	PINMUX_DATA(PF19_DATA, PF19MD_00, PF19_IN, PF19_OUT),
	PINMUX_DATA(SSIWS0_MARK, PF19MD_01),
	PINMUX_DATA(LCD_M_DISP_MARK, PF19MD_10),

	PINMUX_DATA(PF18_DATA, PF18MD_00, PF18_IN, PF18_OUT),
	PINMUX_DATA(SSISCK0_MARK, PF18MD_01),
	PINMUX_DATA(LCD_CL2_MARK, PF18MD_10),

	PINMUX_DATA(PF17_DATA, PF17MD_00, PF17_IN, PF17_OUT),
	PINMUX_DATA(FCE_MARK, PF17MD_01),
	PINMUX_DATA(LCD_CL1_MARK, PF17MD_10),

	PINMUX_DATA(PF16_DATA, PF16MD_00, PF16_IN, PF16_OUT),
	PINMUX_DATA(FRB_MARK, PF16MD_01),
	PINMUX_DATA(LCD_DON_MARK, PF16MD_10),

	PINMUX_DATA(PF15_DATA, PF15MD_00, PF15_IN, PF15_OUT),
	PINMUX_DATA(NAF7_MARK, PF15MD_01),
	PINMUX_DATA(LCD_DATA15_MARK, PF15MD_10),

	PINMUX_DATA(PF14_DATA, PF14MD_00, PF14_IN, PF14_OUT),
	PINMUX_DATA(NAF6_MARK, PF14MD_01),
	PINMUX_DATA(LCD_DATA14_MARK, PF14MD_10),

	PINMUX_DATA(PF13_DATA, PF13MD_00, PF13_IN, PF13_OUT),
	PINMUX_DATA(NAF5_MARK, PF13MD_01),
	PINMUX_DATA(LCD_DATA13_MARK, PF13MD_10),

	PINMUX_DATA(PF12_DATA, PF12MD_00, PF12_IN, PF12_OUT),
	PINMUX_DATA(NAF4_MARK, PF12MD_01),
	PINMUX_DATA(LCD_DATA12_MARK, PF12MD_10),

	PINMUX_DATA(PF11_DATA, PF11MD_00, PF11_IN, PF11_OUT),
	PINMUX_DATA(NAF3_MARK, PF11MD_01),
	PINMUX_DATA(LCD_DATA11_MARK, PF11MD_10),

	PINMUX_DATA(PF10_DATA, PF10MD_00, PF10_IN, PF10_OUT),
	PINMUX_DATA(NAF2_MARK, PF10MD_01),
	PINMUX_DATA(LCD_DATA10_MARK, PF10MD_10),

	PINMUX_DATA(PF9_DATA, PF9MD_00, PF9_IN, PF9_OUT),
	PINMUX_DATA(NAF1_MARK, PF9MD_01),
	PINMUX_DATA(LCD_DATA9_MARK, PF9MD_10),

	PINMUX_DATA(PF8_DATA, PF8MD_00, PF8_IN, PF8_OUT),
	PINMUX_DATA(NAF0_MARK, PF8MD_01),
	PINMUX_DATA(LCD_DATA8_MARK, PF8MD_10),

	PINMUX_DATA(PF7_DATA, PF7MD_00, PF7_IN, PF7_OUT),
	PINMUX_DATA(FSC_MARK, PF7MD_01),
	PINMUX_DATA(LCD_DATA7_MARK, PF7MD_10),
	PINMUX_DATA(SCS1_PF_MARK, PF7MD_11),

	PINMUX_DATA(PF6_DATA, PF6MD_00, PF6_IN, PF6_OUT),
	PINMUX_DATA(FOE_MARK, PF6MD_01),
	PINMUX_DATA(LCD_DATA6_MARK, PF6MD_10),
	PINMUX_DATA(SSO1_PF_MARK, PF6MD_11),

	PINMUX_DATA(PF5_DATA, PF5MD_00, PF5_IN, PF5_OUT),
	PINMUX_DATA(FCDE_MARK, PF5MD_01),
	PINMUX_DATA(LCD_DATA5_MARK, PF5MD_10),
	PINMUX_DATA(SSI1_PF_MARK, PF5MD_11),

	PINMUX_DATA(PF4_DATA, PF4MD_00, PF4_IN, PF4_OUT),
	PINMUX_DATA(FWE_MARK, PF4MD_01),
	PINMUX_DATA(LCD_DATA4_MARK, PF4MD_10),
	PINMUX_DATA(SSCK1_PF_MARK, PF4MD_11),

	PINMUX_DATA(PF3_DATA, PF3MD_00, PF3_IN, PF3_OUT),
	PINMUX_DATA(TCLKD_PF_MARK, PF3MD_01),
	PINMUX_DATA(LCD_DATA3_MARK, PF3MD_10),
	PINMUX_DATA(SCS0_PF_MARK, PF3MD_11),

	PINMUX_DATA(PF2_DATA, PF2MD_00, PF2_IN, PF2_OUT),
	PINMUX_DATA(TCLKC_PF_MARK, PF2MD_01),
	PINMUX_DATA(LCD_DATA2_MARK, PF2MD_10),
	PINMUX_DATA(SSO0_PF_MARK, PF2MD_11),

	PINMUX_DATA(PF1_DATA, PF1MD_00, PF1_IN, PF1_OUT),
	PINMUX_DATA(TCLKB_PF_MARK, PF1MD_01),
	PINMUX_DATA(LCD_DATA1_MARK, PF1MD_10),
	PINMUX_DATA(SSI0_PF_MARK, PF1MD_11),

	PINMUX_DATA(PF0_DATA, PF0MD_00, PF0_IN, PF0_OUT),
	PINMUX_DATA(TCLKA_PF_MARK, PF0MD_01),
	PINMUX_DATA(LCD_DATA0_MARK, PF0MD_10),
	PINMUX_DATA(SSCK0_PF_MARK, PF0MD_11),
};

static struct pinmux_gpio pinmux_gpios[] = {

	/* PA */
	PINMUX_GPIO(GPIO_PA7, PA7_DATA),
	PINMUX_GPIO(GPIO_PA6, PA6_DATA),
	PINMUX_GPIO(GPIO_PA5, PA5_DATA),
	PINMUX_GPIO(GPIO_PA4, PA4_DATA),
	PINMUX_GPIO(GPIO_PA3, PA3_DATA),
	PINMUX_GPIO(GPIO_PA2, PA2_DATA),
	PINMUX_GPIO(GPIO_PA1, PA1_DATA),
	PINMUX_GPIO(GPIO_PA0, PA0_DATA),

	/* PB */
	PINMUX_GPIO(GPIO_PB12, PB12_DATA),
	PINMUX_GPIO(GPIO_PB11, PB11_DATA),
	PINMUX_GPIO(GPIO_PB10, PB10_DATA),
	PINMUX_GPIO(GPIO_PB9, PB9_DATA),
	PINMUX_GPIO(GPIO_PB8, PB8_DATA),
	PINMUX_GPIO(GPIO_PB7, PB7_DATA),
	PINMUX_GPIO(GPIO_PB6, PB6_DATA),
	PINMUX_GPIO(GPIO_PB5, PB5_DATA),
	PINMUX_GPIO(GPIO_PB4, PB4_DATA),
	PINMUX_GPIO(GPIO_PB3, PB3_DATA),
	PINMUX_GPIO(GPIO_PB2, PB2_DATA),
	PINMUX_GPIO(GPIO_PB1, PB1_DATA),
	PINMUX_GPIO(GPIO_PB0, PB0_DATA),

	/* PC */
	PINMUX_GPIO(GPIO_PC14, PC14_DATA),
	PINMUX_GPIO(GPIO_PC13, PC13_DATA),
	PINMUX_GPIO(GPIO_PC12, PC12_DATA),
	PINMUX_GPIO(GPIO_PC11, PC11_DATA),
	PINMUX_GPIO(GPIO_PC10, PC10_DATA),
	PINMUX_GPIO(GPIO_PC9, PC9_DATA),
	PINMUX_GPIO(GPIO_PC8, PC8_DATA),
	PINMUX_GPIO(GPIO_PC7, PC7_DATA),
	PINMUX_GPIO(GPIO_PC6, PC6_DATA),
	PINMUX_GPIO(GPIO_PC5, PC5_DATA),
	PINMUX_GPIO(GPIO_PC4, PC4_DATA),
	PINMUX_GPIO(GPIO_PC3, PC3_DATA),
	PINMUX_GPIO(GPIO_PC2, PC2_DATA),
	PINMUX_GPIO(GPIO_PC1, PC1_DATA),
	PINMUX_GPIO(GPIO_PC0, PC0_DATA),

	/* PD */
	PINMUX_GPIO(GPIO_PD15, PD15_DATA),
	PINMUX_GPIO(GPIO_PD14, PD14_DATA),
	PINMUX_GPIO(GPIO_PD13, PD13_DATA),
	PINMUX_GPIO(GPIO_PD12, PD12_DATA),
	PINMUX_GPIO(GPIO_PD11, PD11_DATA),
	PINMUX_GPIO(GPIO_PD10, PD10_DATA),
	PINMUX_GPIO(GPIO_PD9, PD9_DATA),
	PINMUX_GPIO(GPIO_PD8, PD8_DATA),
	PINMUX_GPIO(GPIO_PD7, PD7_DATA),
	PINMUX_GPIO(GPIO_PD6, PD6_DATA),
	PINMUX_GPIO(GPIO_PD5, PD5_DATA),
	PINMUX_GPIO(GPIO_PD4, PD4_DATA),
	PINMUX_GPIO(GPIO_PD3, PD3_DATA),
	PINMUX_GPIO(GPIO_PD2, PD2_DATA),
	PINMUX_GPIO(GPIO_PD1, PD1_DATA),
	PINMUX_GPIO(GPIO_PD0, PD0_DATA),

	/* PE */
	PINMUX_GPIO(GPIO_PE15, PE15_DATA),
	PINMUX_GPIO(GPIO_PE14, PE14_DATA),
	PINMUX_GPIO(GPIO_PE13, PE13_DATA),
	PINMUX_GPIO(GPIO_PE12, PE12_DATA),
	PINMUX_GPIO(GPIO_PE11, PE11_DATA),
	PINMUX_GPIO(GPIO_PE10, PE10_DATA),
	PINMUX_GPIO(GPIO_PE9, PE9_DATA),
	PINMUX_GPIO(GPIO_PE8, PE8_DATA),
	PINMUX_GPIO(GPIO_PE7, PE7_DATA),
	PINMUX_GPIO(GPIO_PE6, PE6_DATA),
	PINMUX_GPIO(GPIO_PE5, PE5_DATA),
	PINMUX_GPIO(GPIO_PE4, PE4_DATA),
	PINMUX_GPIO(GPIO_PE3, PE3_DATA),
	PINMUX_GPIO(GPIO_PE2, PE2_DATA),
	PINMUX_GPIO(GPIO_PE1, PE1_DATA),
	PINMUX_GPIO(GPIO_PE0, PE0_DATA),

	/* PF */
	PINMUX_GPIO(GPIO_PF30, PF30_DATA),
	PINMUX_GPIO(GPIO_PF29, PF29_DATA),
	PINMUX_GPIO(GPIO_PF28, PF28_DATA),
	PINMUX_GPIO(GPIO_PF27, PF27_DATA),
	PINMUX_GPIO(GPIO_PF26, PF26_DATA),
	PINMUX_GPIO(GPIO_PF25, PF25_DATA),
	PINMUX_GPIO(GPIO_PF24, PF24_DATA),
	PINMUX_GPIO(GPIO_PF23, PF23_DATA),
	PINMUX_GPIO(GPIO_PF22, PF22_DATA),
	PINMUX_GPIO(GPIO_PF21, PF21_DATA),
	PINMUX_GPIO(GPIO_PF20, PF20_DATA),
	PINMUX_GPIO(GPIO_PF19, PF19_DATA),
	PINMUX_GPIO(GPIO_PF18, PF18_DATA),
	PINMUX_GPIO(GPIO_PF17, PF17_DATA),
	PINMUX_GPIO(GPIO_PF16, PF16_DATA),
	PINMUX_GPIO(GPIO_PF15, PF15_DATA),
	PINMUX_GPIO(GPIO_PF14, PF14_DATA),
	PINMUX_GPIO(GPIO_PF13, PF13_DATA),
	PINMUX_GPIO(GPIO_PF12, PF12_DATA),
	PINMUX_GPIO(GPIO_PF11, PF11_DATA),
	PINMUX_GPIO(GPIO_PF10, PF10_DATA),
	PINMUX_GPIO(GPIO_PF9, PF9_DATA),
	PINMUX_GPIO(GPIO_PF8, PF8_DATA),
	PINMUX_GPIO(GPIO_PF7, PF7_DATA),
	PINMUX_GPIO(GPIO_PF6, PF6_DATA),
	PINMUX_GPIO(GPIO_PF5, PF5_DATA),
	PINMUX_GPIO(GPIO_PF4, PF4_DATA),
	PINMUX_GPIO(GPIO_PF3, PF3_DATA),
	PINMUX_GPIO(GPIO_PF2, PF2_DATA),
	PINMUX_GPIO(GPIO_PF1, PF1_DATA),
	PINMUX_GPIO(GPIO_PF0, PF0_DATA),

	/* INTC */
	PINMUX_GPIO(GPIO_FN_PINT7_PB, PINT7_PB_MARK),
	PINMUX_GPIO(GPIO_FN_PINT6_PB, PINT6_PB_MARK),
	PINMUX_GPIO(GPIO_FN_PINT5_PB, PINT5_PB_MARK),
	PINMUX_GPIO(GPIO_FN_PINT4_PB, PINT4_PB_MARK),
	PINMUX_GPIO(GPIO_FN_PINT3_PB, PINT3_PB_MARK),
	PINMUX_GPIO(GPIO_FN_PINT2_PB, PINT2_PB_MARK),
	PINMUX_GPIO(GPIO_FN_PINT1_PB, PINT1_PB_MARK),
	PINMUX_GPIO(GPIO_FN_PINT0_PB, PINT0_PB_MARK),
	PINMUX_GPIO(GPIO_FN_PINT7_PD, PINT7_PD_MARK),
	PINMUX_GPIO(GPIO_FN_PINT6_PD, PINT6_PD_MARK),
	PINMUX_GPIO(GPIO_FN_PINT5_PD, PINT5_PD_MARK),
	PINMUX_GPIO(GPIO_FN_PINT4_PD, PINT4_PD_MARK),
	PINMUX_GPIO(GPIO_FN_PINT3_PD, PINT3_PD_MARK),
	PINMUX_GPIO(GPIO_FN_PINT2_PD, PINT2_PD_MARK),
	PINMUX_GPIO(GPIO_FN_PINT1_PD, PINT1_PD_MARK),
	PINMUX_GPIO(GPIO_FN_PINT0_PD, PINT0_PD_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ7_PB, IRQ7_PB_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ6_PB, IRQ6_PB_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ5_PB, IRQ5_PB_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ4_PB, IRQ4_PB_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ3_PB, IRQ3_PB_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ2_PB, IRQ2_PB_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ1_PB, IRQ1_PB_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ0_PB, IRQ0_PB_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ7_PD, IRQ7_PD_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ6_PD, IRQ6_PD_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ5_PD, IRQ5_PD_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ4_PD, IRQ4_PD_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ3_PD, IRQ3_PD_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ2_PD, IRQ2_PD_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ1_PD, IRQ1_PD_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ0_PD, IRQ0_PD_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ7_PE, IRQ7_PE_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ6_PE, IRQ6_PE_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ5_PE, IRQ5_PE_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ4_PE, IRQ4_PE_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ3_PE, IRQ3_PE_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ2_PE, IRQ2_PE_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ1_PE, IRQ1_PE_MARK),
	PINMUX_GPIO(GPIO_FN_IRQ0_PE, IRQ0_PE_MARK),

	PINMUX_GPIO(GPIO_FN_WDTOVF, WDTOVF_MARK),
	PINMUX_GPIO(GPIO_FN_IRQOUT, IRQOUT_MARK),
	PINMUX_GPIO(GPIO_FN_REFOUT, REFOUT_MARK),
	PINMUX_GPIO(GPIO_FN_IRQOUT_REFOUT, IRQOUT_REFOUT_MARK),
	PINMUX_GPIO(GPIO_FN_UBCTRG, UBCTRG_MARK),

	/* CAN */
	PINMUX_GPIO(GPIO_FN_CTX1, CTX1_MARK),
	PINMUX_GPIO(GPIO_FN_CRX1, CRX1_MARK),
	PINMUX_GPIO(GPIO_FN_CTX0, CTX0_MARK),
	PINMUX_GPIO(GPIO_FN_CTX0_CTX1, CTX0_CTX1_MARK),
	PINMUX_GPIO(GPIO_FN_CRX0, CRX0_MARK),
	PINMUX_GPIO(GPIO_FN_CRX0_CRX1, CRX0_CRX1_MARK),

	/* IIC3 */
	PINMUX_GPIO(GPIO_FN_SDA3, SDA3_MARK),
	PINMUX_GPIO(GPIO_FN_SCL3, SCL3_MARK),
	PINMUX_GPIO(GPIO_FN_SDA2, SDA2_MARK),
	PINMUX_GPIO(GPIO_FN_SCL2, SCL2_MARK),
	PINMUX_GPIO(GPIO_FN_SDA1, SDA1_MARK),
	PINMUX_GPIO(GPIO_FN_SCL1, SCL1_MARK),
	PINMUX_GPIO(GPIO_FN_SDA0, SDA0_MARK),
	PINMUX_GPIO(GPIO_FN_SCL0, SCL0_MARK),

	/* DMAC */
	PINMUX_GPIO(GPIO_FN_TEND0_PD, TEND0_PD_MARK),
	PINMUX_GPIO(GPIO_FN_TEND0_PE, TEND0_PE_MARK),
	PINMUX_GPIO(GPIO_FN_DACK0_PD, DACK0_PD_MARK),
	PINMUX_GPIO(GPIO_FN_DACK0_PE, DACK0_PE_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ0_PD, DREQ0_PD_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ0_PE, DREQ0_PE_MARK),
	PINMUX_GPIO(GPIO_FN_TEND1_PD, TEND1_PD_MARK),
	PINMUX_GPIO(GPIO_FN_TEND1_PE, TEND1_PE_MARK),
	PINMUX_GPIO(GPIO_FN_DACK1_PD, DACK1_PD_MARK),
	PINMUX_GPIO(GPIO_FN_DACK1_PE, DACK1_PE_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ1_PD, DREQ1_PD_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ1_PE, DREQ1_PE_MARK),
	PINMUX_GPIO(GPIO_FN_DACK2, DACK2_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ2, DREQ2_MARK),
	PINMUX_GPIO(GPIO_FN_DACK3, DACK3_MARK),
	PINMUX_GPIO(GPIO_FN_DREQ3, DREQ3_MARK),

	/* ADC */
	PINMUX_GPIO(GPIO_FN_ADTRG_PD, ADTRG_PD_MARK),
	PINMUX_GPIO(GPIO_FN_ADTRG_PE, ADTRG_PE_MARK),

	/* BSC */
	PINMUX_GPIO(GPIO_FN_D31, D31_MARK),
	PINMUX_GPIO(GPIO_FN_D30, D30_MARK),
	PINMUX_GPIO(GPIO_FN_D29, D29_MARK),
	PINMUX_GPIO(GPIO_FN_D28, D28_MARK),
	PINMUX_GPIO(GPIO_FN_D27, D27_MARK),
	PINMUX_GPIO(GPIO_FN_D26, D26_MARK),
	PINMUX_GPIO(GPIO_FN_D25, D25_MARK),
	PINMUX_GPIO(GPIO_FN_D24, D24_MARK),
	PINMUX_GPIO(GPIO_FN_D23, D23_MARK),
	PINMUX_GPIO(GPIO_FN_D22, D22_MARK),
	PINMUX_GPIO(GPIO_FN_D21, D21_MARK),
	PINMUX_GPIO(GPIO_FN_D20, D20_MARK),
	PINMUX_GPIO(GPIO_FN_D19, D19_MARK),
	PINMUX_GPIO(GPIO_FN_D18, D18_MARK),
	PINMUX_GPIO(GPIO_FN_D17, D17_MARK),
	PINMUX_GPIO(GPIO_FN_D16, D16_MARK),
	PINMUX_GPIO(GPIO_FN_A25, A25_MARK),
	PINMUX_GPIO(GPIO_FN_A24, A24_MARK),
	PINMUX_GPIO(GPIO_FN_A23, A23_MARK),
	PINMUX_GPIO(GPIO_FN_A22, A22_MARK),
	PINMUX_GPIO(GPIO_FN_A21, A21_MARK),
	PINMUX_GPIO(GPIO_FN_CS4, CS4_MARK),
	PINMUX_GPIO(GPIO_FN_MRES, MRES_MARK),
	PINMUX_GPIO(GPIO_FN_BS, BS_MARK),
	PINMUX_GPIO(GPIO_FN_IOIS16, IOIS16_MARK),
	PINMUX_GPIO(GPIO_FN_CS1, CS1_MARK),
	PINMUX_GPIO(GPIO_FN_CS6_CE1B, CS6_CE1B_MARK),
	PINMUX_GPIO(GPIO_FN_CE2B, CE2B_MARK),
	PINMUX_GPIO(GPIO_FN_CS5_CE1A, CS5_CE1A_MARK),
	PINMUX_GPIO(GPIO_FN_CE2A, CE2A_MARK),
	PINMUX_GPIO(GPIO_FN_FRAME, FRAME_MARK),
	PINMUX_GPIO(GPIO_FN_WAIT, WAIT_MARK),
	PINMUX_GPIO(GPIO_FN_RDWR, RDWR_MARK),
	PINMUX_GPIO(GPIO_FN_CKE, CKE_MARK),
	PINMUX_GPIO(GPIO_FN_CASU, CASU_MARK),
	PINMUX_GPIO(GPIO_FN_BREQ, BREQ_MARK),
	PINMUX_GPIO(GPIO_FN_RASU, RASU_MARK),
	PINMUX_GPIO(GPIO_FN_BACK, BACK_MARK),
	PINMUX_GPIO(GPIO_FN_CASL, CASL_MARK),
	PINMUX_GPIO(GPIO_FN_RASL, RASL_MARK),
	PINMUX_GPIO(GPIO_FN_WE3_DQMUU_AH_ICIO_WR, WE3_DQMUU_AH_ICIO_WR_MARK),
	PINMUX_GPIO(GPIO_FN_WE2_DQMUL_ICIORD, WE2_DQMUL_ICIORD_MARK),
	PINMUX_GPIO(GPIO_FN_WE1_DQMLU_WE, WE1_DQMLU_WE_MARK),
	PINMUX_GPIO(GPIO_FN_WE0_DQMLL, WE0_DQMLL_MARK),
	PINMUX_GPIO(GPIO_FN_CS3, CS3_MARK),
	PINMUX_GPIO(GPIO_FN_CS2, CS2_MARK),
	PINMUX_GPIO(GPIO_FN_A1, A1_MARK),
	PINMUX_GPIO(GPIO_FN_A0, A0_MARK),
	PINMUX_GPIO(GPIO_FN_CS7, CS7_MARK),

	/* TMU */
	PINMUX_GPIO(GPIO_FN_TIOC4D, TIOC4D_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC4C, TIOC4C_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC4B, TIOC4B_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC4A, TIOC4A_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC3D, TIOC3D_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC3C, TIOC3C_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC3B, TIOC3B_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC3A, TIOC3A_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC2B, TIOC2B_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC1B, TIOC1B_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC2A, TIOC2A_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC1A, TIOC1A_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC0D, TIOC0D_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC0C, TIOC0C_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC0B, TIOC0B_MARK),
	PINMUX_GPIO(GPIO_FN_TIOC0A, TIOC0A_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKD_PD, TCLKD_PD_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKC_PD, TCLKC_PD_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKB_PD, TCLKB_PD_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKA_PD, TCLKA_PD_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKD_PF, TCLKD_PF_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKC_PF, TCLKC_PF_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKB_PF, TCLKB_PF_MARK),
	PINMUX_GPIO(GPIO_FN_TCLKA_PF, TCLKA_PF_MARK),

	/* SSU */
	PINMUX_GPIO(GPIO_FN_SCS0_PD, SCS0_PD_MARK),
	PINMUX_GPIO(GPIO_FN_SSO0_PD, SSO0_PD_MARK),
	PINMUX_GPIO(GPIO_FN_SSI0_PD, SSI0_PD_MARK),
	PINMUX_GPIO(GPIO_FN_SSCK0_PD, SSCK0_PD_MARK),
	PINMUX_GPIO(GPIO_FN_SCS0_PF, SCS0_PF_MARK),
	PINMUX_GPIO(GPIO_FN_SSO0_PF, SSO0_PF_MARK),
	PINMUX_GPIO(GPIO_FN_SSI0_PF, SSI0_PF_MARK),
	PINMUX_GPIO(GPIO_FN_SSCK0_PF, SSCK0_PF_MARK),
	PINMUX_GPIO(GPIO_FN_SCS1_PD, SCS1_PD_MARK),
	PINMUX_GPIO(GPIO_FN_SSO1_PD, SSO1_PD_MARK),
	PINMUX_GPIO(GPIO_FN_SSI1_PD, SSI1_PD_MARK),
	PINMUX_GPIO(GPIO_FN_SSCK1_PD, SSCK1_PD_MARK),
	PINMUX_GPIO(GPIO_FN_SCS1_PF, SCS1_PF_MARK),
	PINMUX_GPIO(GPIO_FN_SSO1_PF, SSO1_PF_MARK),
	PINMUX_GPIO(GPIO_FN_SSI1_PF, SSI1_PF_MARK),
	PINMUX_GPIO(GPIO_FN_SSCK1_PF, SSCK1_PF_MARK),

	/* SCIF */
	PINMUX_GPIO(GPIO_FN_TXD0, TXD0_MARK),
	PINMUX_GPIO(GPIO_FN_RXD0, RXD0_MARK),
	PINMUX_GPIO(GPIO_FN_SCK0, SCK0_MARK),
	PINMUX_GPIO(GPIO_FN_TXD1, TXD1_MARK),
	PINMUX_GPIO(GPIO_FN_RXD1, RXD1_MARK),
	PINMUX_GPIO(GPIO_FN_SCK1, SCK1_MARK),
	PINMUX_GPIO(GPIO_FN_TXD2, TXD2_MARK),
	PINMUX_GPIO(GPIO_FN_RXD2, RXD2_MARK),
	PINMUX_GPIO(GPIO_FN_SCK2, SCK2_MARK),
	PINMUX_GPIO(GPIO_FN_RTS3, RTS3_MARK),
	PINMUX_GPIO(GPIO_FN_CTS3, CTS3_MARK),
	PINMUX_GPIO(GPIO_FN_TXD3, TXD3_MARK),
	PINMUX_GPIO(GPIO_FN_RXD3, RXD3_MARK),
	PINMUX_GPIO(GPIO_FN_SCK3, SCK3_MARK),

	/* SSI */
	PINMUX_GPIO(GPIO_FN_AUDIO_CLK, AUDIO_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_SSIDATA3, SSIDATA3_MARK),
	PINMUX_GPIO(GPIO_FN_SSIWS3, SSIWS3_MARK),
	PINMUX_GPIO(GPIO_FN_SSISCK3, SSISCK3_MARK),
	PINMUX_GPIO(GPIO_FN_SSIDATA2, SSIDATA2_MARK),
	PINMUX_GPIO(GPIO_FN_SSIWS2, SSIWS2_MARK),
	PINMUX_GPIO(GPIO_FN_SSISCK2, SSISCK2_MARK),
	PINMUX_GPIO(GPIO_FN_SSIDATA1, SSIDATA1_MARK),
	PINMUX_GPIO(GPIO_FN_SSIWS1, SSIWS1_MARK),
	PINMUX_GPIO(GPIO_FN_SSISCK1, SSISCK1_MARK),
	PINMUX_GPIO(GPIO_FN_SSIDATA0, SSIDATA0_MARK),
	PINMUX_GPIO(GPIO_FN_SSIWS0, SSIWS0_MARK),
	PINMUX_GPIO(GPIO_FN_SSISCK0, SSISCK0_MARK),

	/* FLCTL */
	PINMUX_GPIO(GPIO_FN_FCE, FCE_MARK),
	PINMUX_GPIO(GPIO_FN_FRB, FRB_MARK),
	PINMUX_GPIO(GPIO_FN_NAF7, NAF7_MARK),
	PINMUX_GPIO(GPIO_FN_NAF6, NAF6_MARK),
	PINMUX_GPIO(GPIO_FN_NAF5, NAF5_MARK),
	PINMUX_GPIO(GPIO_FN_NAF4, NAF4_MARK),
	PINMUX_GPIO(GPIO_FN_NAF3, NAF3_MARK),
	PINMUX_GPIO(GPIO_FN_NAF2, NAF2_MARK),
	PINMUX_GPIO(GPIO_FN_NAF1, NAF1_MARK),
	PINMUX_GPIO(GPIO_FN_NAF0, NAF0_MARK),
	PINMUX_GPIO(GPIO_FN_FSC, FSC_MARK),
	PINMUX_GPIO(GPIO_FN_FOE, FOE_MARK),
	PINMUX_GPIO(GPIO_FN_FCDE, FCDE_MARK),
	PINMUX_GPIO(GPIO_FN_FWE, FWE_MARK),

	/* LCDC */
	PINMUX_GPIO(GPIO_FN_LCD_VEPWC, LCD_VEPWC_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_VCPWC, LCD_VCPWC_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_CLK, LCD_CLK_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_FLM, LCD_FLM_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_M_DISP, LCD_M_DISP_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_CL2, LCD_CL2_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_CL1, LCD_CL1_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DON, LCD_DON_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA15, LCD_DATA15_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA14, LCD_DATA14_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA13, LCD_DATA13_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA12, LCD_DATA12_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA11, LCD_DATA11_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA10, LCD_DATA10_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA9, LCD_DATA9_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA8, LCD_DATA8_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA7, LCD_DATA7_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA6, LCD_DATA6_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA5, LCD_DATA5_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA4, LCD_DATA4_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA3, LCD_DATA3_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA2, LCD_DATA2_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA1, LCD_DATA1_MARK),
	PINMUX_GPIO(GPIO_FN_LCD_DATA0, LCD_DATA0_MARK),
};

static struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("PBIORL", 0xfffe3886, 16, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		PB11_IN, PB11_OUT,
		PB10_IN, PB10_OUT,
		PB9_IN, PB9_OUT,
		PB8_IN, PB8_OUT,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0 }
	},
	{ PINMUX_CFG_REG("PBCRL4", 0xfffe3890, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB12MD_00, PB12MD_01, PB12MD_10, PB12MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCRL3", 0xfffe3892, 16, 4) {
		PB11MD_0, PB11MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB10MD_0, PB10MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB9MD_00, PB9MD_01, PB9MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB8MD_00, PB8MD_01, PB8MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCRL2", 0xfffe3894, 16, 4) {
		PB7MD_00, PB7MD_01, PB7MD_10, PB7MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB6MD_00, PB6MD_01, PB6MD_10, PB6MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB5MD_00, PB5MD_01, PB5MD_10, PB5MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB4MD_00, PB4MD_01, PB4MD_10, PB4MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PBCRL1", 0xfffe3896, 16, 4) {
		PB3MD_00, PB3MD_01, PB3MD_10, PB3MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB2MD_00, PB2MD_01, PB2MD_10, PB2MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB1MD_00, PB1MD_01, PB1MD_10, PB1MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB0MD_00, PB0MD_01, PB0MD_10, PB0MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("IFCR", 0xfffe38a2, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PB12IRQ_00, PB12IRQ_01, PB12IRQ_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PCIORL", 0xfffe3906, 16, 1) {
		0, 0,
		PC14_IN, PC14_OUT,
		PC13_IN, PC13_OUT,
		PC12_IN, PC12_OUT,
		PC11_IN, PC11_OUT,
		PC10_IN, PC10_OUT,
		PC9_IN, PC9_OUT,
		PC8_IN, PC8_OUT,
		PC7_IN, PC7_OUT,
		PC6_IN, PC6_OUT,
		PC5_IN, PC5_OUT,
		PC4_IN, PC4_OUT,
		PC3_IN, PC3_OUT,
		PC2_IN, PC2_OUT,
		PC1_IN, PC1_OUT,
		PC0_IN, PC0_OUT }
	},
	{ PINMUX_CFG_REG("PCCRL4", 0xfffe3910, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC14MD_0, PC14MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC13MD_0, PC13MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC12MD_0, PC12MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PCCRL3", 0xfffe3912, 16, 4) {
		PC11MD_00, PC11MD_01, PC11MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC10MD_00, PC10MD_01, PC10MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC9MD_0, PC9MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC8MD_0, PC8MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PCCRL2", 0xfffe3914, 16, 4) {
		PC7MD_0, PC7MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC6MD_0, PC6MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC5MD_0, PC5MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC4MD_0, PC4MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PCCRL1", 0xfffe3916, 16, 4) {
		PC3MD_0, PC3MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC2MD_0, PC2MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC1MD_0, PC1MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PC0MD_00, PC0MD_01, PC0MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDIORL", 0xfffe3986, 16, 1) {
		PD15_IN, PD15_OUT,
		PD14_IN, PD14_OUT,
		PD13_IN, PD13_OUT,
		PD12_IN, PD12_OUT,
		PD11_IN, PD11_OUT,
		PD10_IN, PD10_OUT,
		PD9_IN, PD9_OUT,
		PD8_IN, PD8_OUT,
		PD7_IN, PD7_OUT,
		PD6_IN, PD6_OUT,
		PD5_IN, PD5_OUT,
		PD4_IN, PD4_OUT,
		PD3_IN, PD3_OUT,
		PD2_IN, PD2_OUT,
		PD1_IN, PD1_OUT,
		PD0_IN, PD0_OUT }
	},
	{ PINMUX_CFG_REG("PDCRL4", 0xfffe3990, 16, 4) {
		PD15MD_000, PD15MD_001, PD15MD_010, 0,
		PD15MD_100, PD15MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD14MD_000, PD14MD_001, PD14MD_010, 0,
		0, PD14MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD13MD_000, PD13MD_001, PD13MD_010, 0,
		PD13MD_100, PD13MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD12MD_000, PD12MD_001, PD12MD_010, 0,
		PD12MD_100, PD12MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDCRL3", 0xfffe3992, 16, 4) {
		PD11MD_000, PD11MD_001, PD11MD_010, 0,
		PD11MD_100, PD11MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD10MD_000, PD10MD_001, PD10MD_010, 0,
		PD10MD_100, PD10MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD9MD_000, PD9MD_001, PD9MD_010, 0,
		PD9MD_100, PD9MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD8MD_000, PD8MD_001, PD8MD_010, 0,
		PD8MD_100, PD8MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDCRL2", 0xfffe3994, 16, 4) {
		PD7MD_000, PD7MD_001, PD7MD_010, PD7MD_011,
		PD7MD_100, PD7MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD6MD_000, PD6MD_001, PD6MD_010, PD6MD_011,
		PD6MD_100, PD6MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD5MD_000, PD5MD_001, PD5MD_010, PD5MD_011,
		PD5MD_100, PD5MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD4MD_000, PD4MD_001, PD4MD_010, PD4MD_011,
		PD4MD_100, PD4MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PDCRL1", 0xfffe3996, 16, 4) {
		PD3MD_000, PD3MD_001, PD3MD_010, PD3MD_011,
		PD3MD_100, PD3MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD2MD_000, PD2MD_001, PD2MD_010, PD2MD_011,
		PD2MD_100, PD2MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD1MD_000, PD1MD_001, PD1MD_010, PD1MD_011,
		PD1MD_100, PD1MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PD0MD_000, PD0MD_001, PD0MD_010, PD0MD_011,
		PD0MD_100, PD0MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PEIORL", 0xfffe3a06, 16, 1) {
		PE15_IN, PE15_OUT,
		PE14_IN, PE14_OUT,
		PE13_IN, PE13_OUT,
		PE12_IN, PE12_OUT,
		PE11_IN, PE11_OUT,
		PE10_IN, PE10_OUT,
		PE9_IN, PE9_OUT,
		PE8_IN, PE8_OUT,
		PE7_IN, PE7_OUT,
		PE6_IN, PE6_OUT,
		PE5_IN, PE5_OUT,
		PE4_IN, PE4_OUT,
		PE3_IN, PE3_OUT,
		PE2_IN, PE2_OUT,
		PE1_IN, PE1_OUT,
		PE0_IN, PE0_OUT }
	},
	{ PINMUX_CFG_REG("PECRL4", 0xfffe3a10, 16, 4) {
		PE15MD_00, PE15MD_01, 0, PE15MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE14MD_00, PE14MD_01, 0, PE14MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE13MD_00, 0, 0, PE13MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE12MD_00, 0, 0, PE12MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PECRL3", 0xfffe3a12, 16, 4) {
		PE11MD_000, PE11MD_001, PE11MD_010, 0,
		PE11MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE10MD_000, PE10MD_001, PE10MD_010, 0,
		PE10MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE9MD_00, PE9MD_01, PE9MD_10, PE9MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE8MD_00, PE8MD_01, PE8MD_10, PE8MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PECRL2", 0xfffe3a14, 16, 4) {
		PE7MD_000, PE7MD_001, PE7MD_010, PE7MD_011,
		PE7MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE6MD_000, PE6MD_001, PE6MD_010, PE6MD_011,
		PE6MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE5MD_000, PE5MD_001, PE5MD_010, PE5MD_011,
		PE5MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,

		PE4MD_000, PE4MD_001, PE4MD_010, PE4MD_011,
		PE4MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PECRL1", 0xfffe3a16, 16, 4) {
		PE3MD_00, PE3MD_01, 0, PE3MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE2MD_00, PE2MD_01, 0, PE2MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE1MD_00, PE1MD_01, PE1MD_10, PE1MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PE0MD_000, PE0MD_001, 0, PE0MD_011,
		PE0MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFIORH", 0xfffe3a84, 16, 1) {
		0, 0,
		PF30_IN, PF30_OUT,
		PF29_IN, PF29_OUT,
		PF28_IN, PF28_OUT,
		PF27_IN, PF27_OUT,
		PF26_IN, PF26_OUT,
		PF25_IN, PF25_OUT,
		PF24_IN, PF24_OUT,
		PF23_IN, PF23_OUT,
		PF22_IN, PF22_OUT,
		PF21_IN, PF21_OUT,
		PF20_IN, PF20_OUT,
		PF19_IN, PF19_OUT,
		PF18_IN, PF18_OUT,
		PF17_IN, PF17_OUT,
		PF16_IN, PF16_OUT }
	},
	{ PINMUX_CFG_REG("PFIORL", 0xfffe3a86, 16, 1) {
		PF15_IN, PF15_OUT,
		PF14_IN, PF14_OUT,
		PF13_IN, PF13_OUT,
		PF12_IN, PF12_OUT,
		PF11_IN, PF11_OUT,
		PF10_IN, PF10_OUT,
		PF9_IN, PF9_OUT,
		PF8_IN, PF8_OUT,
		PF7_IN, PF7_OUT,
		PF6_IN, PF6_OUT,
		PF5_IN, PF5_OUT,
		PF4_IN, PF4_OUT,
		PF3_IN, PF3_OUT,
		PF2_IN, PF2_OUT,
		PF1_IN, PF1_OUT,
		PF0_IN, PF0_OUT }
	},
	{ PINMUX_CFG_REG("PFCRH4", 0xfffe3a88, 16, 4) {
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF30MD_0, PF30MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF29MD_0, PF29MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF28MD_0, PF28MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRH3", 0xfffe3a8a, 16, 4) {
		PF27MD_0, PF27MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF26MD_0, PF26MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF25MD_0, PF25MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF24MD_0, PF24MD_1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRH2", 0xfffe3a8c, 16, 4) {
		PF23MD_00, PF23MD_01, PF23MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF22MD_00, PF22MD_01, PF22MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF21MD_00, PF21MD_01, PF21MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF20MD_00, PF20MD_01, PF20MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRH1", 0xfffe3a8e, 16, 4) {
		PF19MD_00, PF19MD_01, PF19MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF18MD_00, PF18MD_01, PF18MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF17MD_00, PF17MD_01, PF17MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF16MD_00, PF16MD_01, PF16MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRL4", 0xfffe3a90, 16, 4) {
		PF15MD_00, PF15MD_01, PF15MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF14MD_00, PF14MD_01, PF14MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF13MD_00, PF13MD_01, PF13MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF12MD_00, PF12MD_01, PF12MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRL3", 0xfffe3a92, 16, 4) {
		PF11MD_00, PF11MD_01, PF11MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF10MD_00, PF10MD_01, PF10MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF9MD_00, PF9MD_01, PF9MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF8MD_00, PF8MD_01, PF8MD_10, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRL2", 0xfffe3a94, 16, 4) {
		PF7MD_00, PF7MD_01, PF7MD_10, PF7MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF6MD_00, PF6MD_01, PF6MD_10, PF6MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF5MD_00, PF5MD_01, PF5MD_10, PF5MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF4MD_00, PF4MD_01, PF4MD_10, PF4MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ PINMUX_CFG_REG("PFCRL1", 0xfffe3a96, 16, 4) {
		PF3MD_00, PF3MD_01, PF3MD_10, PF3MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF2MD_00, PF2MD_01, PF2MD_10, PF2MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF1MD_00, PF1MD_01, PF1MD_10, PF1MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,

		PF0MD_00, PF0MD_01, PF0MD_10, PF0MD_11,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{}
};

static struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PADRL", 0xfffe3802, 16) {
		0, 0, 0, 0,
		0, 0, 0, 0,
		PA7_DATA, PA6_DATA, PA5_DATA, PA4_DATA,
		PA3_DATA, PA2_DATA, PA1_DATA, PA0_DATA }
	},
	{ PINMUX_DATA_REG("PBDRL", 0xfffe3882, 16) {
		0, 0, 0, PB12_DATA,
		PB11_DATA, PB10_DATA, PB9_DATA, PB8_DATA,
		PB7_DATA, PB6_DATA, PB5_DATA, PB4_DATA,
		PB3_DATA, PB2_DATA, PB1_DATA, PB0_DATA }
	},
	{ PINMUX_DATA_REG("PCDRL", 0xfffe3902, 16) {
		0, PC14_DATA, PC13_DATA, PC12_DATA,
		PC11_DATA, PC10_DATA, PC9_DATA, PC8_DATA,
		PC7_DATA, PC6_DATA, PC5_DATA, PC4_DATA,
		PC3_DATA, PC2_DATA, PC1_DATA, PC0_DATA }
	},
	{ PINMUX_DATA_REG("PDDRL", 0xfffe3982, 16) {
		PD15_DATA, PD14_DATA, PD13_DATA, PD12_DATA,
		PD11_DATA, PD10_DATA, PD9_DATA, PD8_DATA,
		PD7_DATA, PD6_DATA, PD5_DATA, PD4_DATA,
		PD3_DATA, PD2_DATA, PD1_DATA, PD0_DATA }
	},
	{ PINMUX_DATA_REG("PEDRL", 0xfffe3a02, 16) {
		PE15_DATA, PE14_DATA, PE13_DATA, PE12_DATA,
		PE11_DATA, PE10_DATA, PE9_DATA, PE8_DATA,
		PE7_DATA, PE6_DATA, PE5_DATA, PE4_DATA,
		PE3_DATA, PE2_DATA, PE1_DATA, PE0_DATA }
	},
	{ PINMUX_DATA_REG("PFDRH", 0xfffe3a80, 16) {
		0, PF30_DATA, PF29_DATA, PF28_DATA,
		PF27_DATA, PF26_DATA, PF25_DATA, PF24_DATA,
		PF23_DATA, PF22_DATA, PF21_DATA, PF20_DATA,
		PF19_DATA, PF18_DATA, PF17_DATA, PF16_DATA }
	},
	{ PINMUX_DATA_REG("PFDRL", 0xfffe3a82, 16) {
		PF15_DATA, PF14_DATA, PF13_DATA, PF12_DATA,
		PF11_DATA, PF10_DATA, PF9_DATA, PF8_DATA,
		PF7_DATA, PF6_DATA, PF5_DATA, PF4_DATA,
		PF3_DATA, PF2_DATA, PF1_DATA, PF0_DATA }
	},
	{ },
};

static struct pinmux_info sh7203_pinmux_info = {
	.name = "sh7203_pfc",
	.reserved_id = PINMUX_RESERVED,
	.data = { PINMUX_DATA_BEGIN, PINMUX_DATA_END },
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.mark = { PINMUX_MARK_BEGIN, PINMUX_MARK_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.first_gpio = GPIO_PA7,
	.last_gpio = GPIO_FN_LCD_DATA0,

	.gpios = pinmux_gpios,
	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.gpio_data = pinmux_data,
	.gpio_data_size = ARRAY_SIZE(pinmux_data),
};

static int __init plat_pinmux_setup(void)
{
	return register_pinmux(&sh7203_pinmux_info);
}

arch_initcall(plat_pinmux_setup);
