/* Copyright (c) 2008-2009, 2012 Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/time.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/fb.h>
#include "linux/proc_fs.h"

#include <mach/hardware.h>
#include <linux/io.h>

#include <asm/system.h>
#include <asm/mach-types.h>
#include <linux/semaphore.h>
#include <asm/div64.h>

#include "mdp.h"
#include "msm_fb.h"

static MDP_SCALE_MODE mdp_curr_up_scale_xy;
static MDP_SCALE_MODE mdp_curr_down_scale_x;
static MDP_SCALE_MODE mdp_curr_down_scale_y;

static long long mdp_do_div(long long num, long long den)
{
	do_div(num, den);
	return num;
}

struct mdp_table_entry mdp_gaussian_blur_table[] = {
	/* max variance */
	{ 0x5fffc, 0x20000080 },
	{ 0x50280, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50284, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50288, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x5028c, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50290, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50294, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50298, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x5029c, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502a0, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502a4, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502a8, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502ac, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502b0, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502b4, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502b8, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502bc, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502c0, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502c4, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502c8, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502cc, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502d0, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502d4, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502d8, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502dc, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502e0, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502e4, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502e8, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502ec, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502f0, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502f4, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502f8, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x502fc, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50300, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50304, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50308, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x5030c, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50310, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50314, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50318, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x5031c, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50320, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50324, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50328, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x5032c, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50330, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50334, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50338, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x5033c, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50340, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50344, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50348, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x5034c, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50350, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50354, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50358, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x5035c, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50360, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50364, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50368, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x5036c, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50370, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50374, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x50378, 0x20000080 },
	{ 0x5fffc, 0x20000080 },
	{ 0x5037c, 0x20000080 },
};

static void load_scale_table(
	struct mdp_table_entry *table, int len)
{
	int i;
	for (i = 0; i < len; i++)
		MDP_OUTP(MDP_BASE + table[i].reg, table[i].val);
}

static void mdp_load_pr_upscale_table(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50200, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50204, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50208, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5020c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50210, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50214, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50218, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5021c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50220, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50224, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50228, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5022c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50230, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50234, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50238, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5023c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50240, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50244, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50248, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5024c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50250, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50254, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50258, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5025c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50260, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50264, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50268, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5026c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50270, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50274, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50278, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5027c, 0x0);
}

static void mdp_load_pr_downscale_table_x_point2TOpoint4(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50280, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50284, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50288, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5028c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50290, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50294, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50298, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5029c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a0, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a4, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a8, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502ac, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b0, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b4, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b8, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502bc, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502cc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502dc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502ec, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502fc, 0x0);
}

static void mdp_load_pr_downscale_table_y_point2TOpoint4(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50300, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50304, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50308, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5030c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50310, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50314, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50318, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5031c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50320, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50324, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50328, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5032c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50330, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50334, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50338, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5033c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50340, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50344, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50348, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5034c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50350, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50354, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50358, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5035c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50360, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50364, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50368, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5036c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50370, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50374, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50378, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5037c, 0x0);
}

static void mdp_load_pr_downscale_table_x_point4TOpoint6(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50280, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50284, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50288, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5028c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50290, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50294, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50298, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5029c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a0, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a4, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a8, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502ac, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b0, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b4, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b8, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502bc, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502cc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502dc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502ec, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502fc, 0x0);
}

static void mdp_load_pr_downscale_table_y_point4TOpoint6(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50300, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50304, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50308, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5030c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50310, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50314, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50318, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5031c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50320, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50324, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50328, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5032c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50330, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50334, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50338, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5033c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50340, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50344, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50348, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5034c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50350, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50354, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50358, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5035c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50360, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50364, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50368, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5036c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50370, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50374, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50378, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5037c, 0x0);
}

static void mdp_load_pr_downscale_table_x_point6TOpoint8(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50280, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50284, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50288, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5028c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50290, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50294, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50298, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5029c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a0, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a4, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a8, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502ac, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b0, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b4, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b8, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502bc, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502cc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502dc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502ec, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502fc, 0x0);
}

static void mdp_load_pr_downscale_table_y_point6TOpoint8(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50300, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50304, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50308, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5030c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50310, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50314, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50318, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5031c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50320, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50324, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50328, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5032c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50330, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50334, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50338, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5033c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50340, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50344, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50348, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5034c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50350, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50354, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50358, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5035c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50360, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50364, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50368, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5036c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50370, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50374, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50378, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5037c, 0x0);
}

static void mdp_load_pr_downscale_table_x_point8TO1(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50280, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50284, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50288, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5028c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50290, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50294, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50298, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5029c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a0, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a4, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502a8, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502ac, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b0, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b4, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502b8, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x502bc, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502c8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502cc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502d8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502dc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502e8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502ec, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f0, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f4, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502f8, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x502fc, 0x0);
}

static void mdp_load_pr_downscale_table_y_point8TO1(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50300, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50304, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50308, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5030c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50310, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50314, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50318, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5031c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50320, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50324, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50328, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5032c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50330, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50334, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50338, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x5033c, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50340, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50344, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50348, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5034c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50350, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50354, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50358, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5035c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50360, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50364, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50368, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5036c, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50370, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50374, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x50378, 0x0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ff);
	MDP_OUTP(MDP_BASE + 0x5037c, 0x0);
}

static void mdp_load_bc_upscale_table(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50200, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xff80000d);
	MDP_OUTP(MDP_BASE + 0x50204, 0x7ec003f9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfec0001c);
	MDP_OUTP(MDP_BASE + 0x50208, 0x7d4003f3);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe40002b);
	MDP_OUTP(MDP_BASE + 0x5020c, 0x7b8003ed);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfd80003c);
	MDP_OUTP(MDP_BASE + 0x50210, 0x794003e8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfcc0004d);
	MDP_OUTP(MDP_BASE + 0x50214, 0x76c003e4);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfc40005f);
	MDP_OUTP(MDP_BASE + 0x50218, 0x73c003e0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfb800071);
	MDP_OUTP(MDP_BASE + 0x5021c, 0x708003de);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfac00085);
	MDP_OUTP(MDP_BASE + 0x50220, 0x6d0003db);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfa000098);
	MDP_OUTP(MDP_BASE + 0x50224, 0x698003d9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf98000ac);
	MDP_OUTP(MDP_BASE + 0x50228, 0x654003d8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf8c000c1);
	MDP_OUTP(MDP_BASE + 0x5022c, 0x610003d7);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf84000d5);
	MDP_OUTP(MDP_BASE + 0x50230, 0x5c8003d7);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf7c000e9);
	MDP_OUTP(MDP_BASE + 0x50234, 0x580003d7);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf74000fd);
	MDP_OUTP(MDP_BASE + 0x50238, 0x534003d8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6c00112);
	MDP_OUTP(MDP_BASE + 0x5023c, 0x4e8003d8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6800126);
	MDP_OUTP(MDP_BASE + 0x50240, 0x494003da);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf600013a);
	MDP_OUTP(MDP_BASE + 0x50244, 0x448003db);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf600014d);
	MDP_OUTP(MDP_BASE + 0x50248, 0x3f4003dd);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf5c00160);
	MDP_OUTP(MDP_BASE + 0x5024c, 0x3a4003df);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf5c00172);
	MDP_OUTP(MDP_BASE + 0x50250, 0x354003e1);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf5c00184);
	MDP_OUTP(MDP_BASE + 0x50254, 0x304003e3);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6000195);
	MDP_OUTP(MDP_BASE + 0x50258, 0x2b0003e6);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf64001a6);
	MDP_OUTP(MDP_BASE + 0x5025c, 0x260003e8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6c001b4);
	MDP_OUTP(MDP_BASE + 0x50260, 0x214003eb);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf78001c2);
	MDP_OUTP(MDP_BASE + 0x50264, 0x1c4003ee);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf80001cf);
	MDP_OUTP(MDP_BASE + 0x50268, 0x17c003f1);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf90001db);
	MDP_OUTP(MDP_BASE + 0x5026c, 0x134003f3);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfa0001e5);
	MDP_OUTP(MDP_BASE + 0x50270, 0xf0003f6);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfb4001ee);
	MDP_OUTP(MDP_BASE + 0x50274, 0xac003f9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfcc001f5);
	MDP_OUTP(MDP_BASE + 0x50278, 0x70003fb);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe4001fb);
	MDP_OUTP(MDP_BASE + 0x5027c, 0x34003fe);
}

static void mdp_load_bc_downscale_table_x_point2TOpoint4(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ac00084);
	MDP_OUTP(MDP_BASE + 0x50280, 0x23400083);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1b000084);
	MDP_OUTP(MDP_BASE + 0x50284, 0x23000083);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1b400084);
	MDP_OUTP(MDP_BASE + 0x50288, 0x23000082);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1b400085);
	MDP_OUTP(MDP_BASE + 0x5028c, 0x23000081);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1b800085);
	MDP_OUTP(MDP_BASE + 0x50290, 0x23000080);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1bc00086);
	MDP_OUTP(MDP_BASE + 0x50294, 0x22c0007f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1c000086);
	MDP_OUTP(MDP_BASE + 0x50298, 0x2280007f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1c400086);
	MDP_OUTP(MDP_BASE + 0x5029c, 0x2280007e);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1c800086);
	MDP_OUTP(MDP_BASE + 0x502a0, 0x2280007d);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1cc00086);
	MDP_OUTP(MDP_BASE + 0x502a4, 0x2240007d);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1cc00087);
	MDP_OUTP(MDP_BASE + 0x502a8, 0x2240007c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1d000087);
	MDP_OUTP(MDP_BASE + 0x502ac, 0x2240007b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1d400087);
	MDP_OUTP(MDP_BASE + 0x502b0, 0x2200007b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1d400088);
	MDP_OUTP(MDP_BASE + 0x502b4, 0x22400079);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1d800088);
	MDP_OUTP(MDP_BASE + 0x502b8, 0x22400078);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1dc00088);
	MDP_OUTP(MDP_BASE + 0x502bc, 0x22400077);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1dc00089);
	MDP_OUTP(MDP_BASE + 0x502c0, 0x22000077);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1e000089);
	MDP_OUTP(MDP_BASE + 0x502c4, 0x22000076);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1e400089);
	MDP_OUTP(MDP_BASE + 0x502c8, 0x22000075);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ec00088);
	MDP_OUTP(MDP_BASE + 0x502cc, 0x21c00075);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ec00089);
	MDP_OUTP(MDP_BASE + 0x502d0, 0x21c00074);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1f000089);
	MDP_OUTP(MDP_BASE + 0x502d4, 0x21c00073);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1f400089);
	MDP_OUTP(MDP_BASE + 0x502d8, 0x21800073);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1f40008a);
	MDP_OUTP(MDP_BASE + 0x502dc, 0x21800072);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1f80008a);
	MDP_OUTP(MDP_BASE + 0x502e0, 0x21800071);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1fc0008a);
	MDP_OUTP(MDP_BASE + 0x502e4, 0x21800070);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1fc0008b);
	MDP_OUTP(MDP_BASE + 0x502e8, 0x2180006f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x2000008c);
	MDP_OUTP(MDP_BASE + 0x502ec, 0x2140006e);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x2040008c);
	MDP_OUTP(MDP_BASE + 0x502f0, 0x2140006d);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x2080008c);
	MDP_OUTP(MDP_BASE + 0x502f4, 0x2100006d);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x20c0008c);
	MDP_OUTP(MDP_BASE + 0x502f8, 0x2100006c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x20c0008d);
	MDP_OUTP(MDP_BASE + 0x502fc, 0x2100006b);
}

static void mdp_load_bc_downscale_table_y_point2TOpoint4(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ac00084);
	MDP_OUTP(MDP_BASE + 0x50300, 0x23400083);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1b000084);
	MDP_OUTP(MDP_BASE + 0x50304, 0x23000083);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1b400084);
	MDP_OUTP(MDP_BASE + 0x50308, 0x23000082);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1b400085);
	MDP_OUTP(MDP_BASE + 0x5030c, 0x23000081);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1b800085);
	MDP_OUTP(MDP_BASE + 0x50310, 0x23000080);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1bc00086);
	MDP_OUTP(MDP_BASE + 0x50314, 0x22c0007f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1c000086);
	MDP_OUTP(MDP_BASE + 0x50318, 0x2280007f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1c400086);
	MDP_OUTP(MDP_BASE + 0x5031c, 0x2280007e);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1c800086);
	MDP_OUTP(MDP_BASE + 0x50320, 0x2280007d);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1cc00086);
	MDP_OUTP(MDP_BASE + 0x50324, 0x2240007d);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1cc00087);
	MDP_OUTP(MDP_BASE + 0x50328, 0x2240007c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1d000087);
	MDP_OUTP(MDP_BASE + 0x5032c, 0x2240007b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1d400087);
	MDP_OUTP(MDP_BASE + 0x50330, 0x2200007b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1d400088);
	MDP_OUTP(MDP_BASE + 0x50334, 0x22400079);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1d800088);
	MDP_OUTP(MDP_BASE + 0x50338, 0x22400078);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1dc00088);
	MDP_OUTP(MDP_BASE + 0x5033c, 0x22400077);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1dc00089);
	MDP_OUTP(MDP_BASE + 0x50340, 0x22000077);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1e000089);
	MDP_OUTP(MDP_BASE + 0x50344, 0x22000076);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1e400089);
	MDP_OUTP(MDP_BASE + 0x50348, 0x22000075);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ec00088);
	MDP_OUTP(MDP_BASE + 0x5034c, 0x21c00075);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ec00089);
	MDP_OUTP(MDP_BASE + 0x50350, 0x21c00074);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1f000089);
	MDP_OUTP(MDP_BASE + 0x50354, 0x21c00073);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1f400089);
	MDP_OUTP(MDP_BASE + 0x50358, 0x21800073);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1f40008a);
	MDP_OUTP(MDP_BASE + 0x5035c, 0x21800072);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1f80008a);
	MDP_OUTP(MDP_BASE + 0x50360, 0x21800071);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1fc0008a);
	MDP_OUTP(MDP_BASE + 0x50364, 0x21800070);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1fc0008b);
	MDP_OUTP(MDP_BASE + 0x50368, 0x2180006f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x2000008c);
	MDP_OUTP(MDP_BASE + 0x5036c, 0x2140006e);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x2040008c);
	MDP_OUTP(MDP_BASE + 0x50370, 0x2140006d);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x2080008c);
	MDP_OUTP(MDP_BASE + 0x50374, 0x2100006d);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x20c0008c);
	MDP_OUTP(MDP_BASE + 0x50378, 0x2100006c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x20c0008d);
	MDP_OUTP(MDP_BASE + 0x5037c, 0x2100006b);
}

static void mdp_load_bc_downscale_table_x_point4TOpoint6(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x740008c);
	MDP_OUTP(MDP_BASE + 0x50280, 0x33800088);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x800008e);
	MDP_OUTP(MDP_BASE + 0x50284, 0x33400084);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x8400092);
	MDP_OUTP(MDP_BASE + 0x50288, 0x33000080);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x9000094);
	MDP_OUTP(MDP_BASE + 0x5028c, 0x3300007b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x9c00098);
	MDP_OUTP(MDP_BASE + 0x50290, 0x32400077);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xa40009b);
	MDP_OUTP(MDP_BASE + 0x50294, 0x32000073);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xb00009d);
	MDP_OUTP(MDP_BASE + 0x50298, 0x31c0006f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xbc000a0);
	MDP_OUTP(MDP_BASE + 0x5029c, 0x3140006b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xc8000a2);
	MDP_OUTP(MDP_BASE + 0x502a0, 0x31000067);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xd8000a5);
	MDP_OUTP(MDP_BASE + 0x502a4, 0x30800062);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xe4000a8);
	MDP_OUTP(MDP_BASE + 0x502a8, 0x2fc0005f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xec000aa);
	MDP_OUTP(MDP_BASE + 0x502ac, 0x2fc0005b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf8000ad);
	MDP_OUTP(MDP_BASE + 0x502b0, 0x2f400057);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x108000b0);
	MDP_OUTP(MDP_BASE + 0x502b4, 0x2e400054);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x114000b2);
	MDP_OUTP(MDP_BASE + 0x502b8, 0x2e000050);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x124000b4);
	MDP_OUTP(MDP_BASE + 0x502bc, 0x2d80004c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x130000b6);
	MDP_OUTP(MDP_BASE + 0x502c0, 0x2d000049);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x140000b8);
	MDP_OUTP(MDP_BASE + 0x502c4, 0x2c800045);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x150000b9);
	MDP_OUTP(MDP_BASE + 0x502c8, 0x2c000042);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x15c000bd);
	MDP_OUTP(MDP_BASE + 0x502cc, 0x2b40003e);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x16c000bf);
	MDP_OUTP(MDP_BASE + 0x502d0, 0x2a80003b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x17c000bf);
	MDP_OUTP(MDP_BASE + 0x502d4, 0x2a000039);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x188000c2);
	MDP_OUTP(MDP_BASE + 0x502d8, 0x29400036);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x19c000c4);
	MDP_OUTP(MDP_BASE + 0x502dc, 0x28800032);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ac000c5);
	MDP_OUTP(MDP_BASE + 0x502e0, 0x2800002f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1bc000c7);
	MDP_OUTP(MDP_BASE + 0x502e4, 0x2740002c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1cc000c8);
	MDP_OUTP(MDP_BASE + 0x502e8, 0x26c00029);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1dc000c9);
	MDP_OUTP(MDP_BASE + 0x502ec, 0x26000027);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ec000cc);
	MDP_OUTP(MDP_BASE + 0x502f0, 0x25000024);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x200000cc);
	MDP_OUTP(MDP_BASE + 0x502f4, 0x24800021);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x210000cd);
	MDP_OUTP(MDP_BASE + 0x502f8, 0x23800020);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x220000ce);
	MDP_OUTP(MDP_BASE + 0x502fc, 0x2300001d);
}

static void mdp_load_bc_downscale_table_y_point4TOpoint6(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x740008c);
	MDP_OUTP(MDP_BASE + 0x50300, 0x33800088);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x800008e);
	MDP_OUTP(MDP_BASE + 0x50304, 0x33400084);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x8400092);
	MDP_OUTP(MDP_BASE + 0x50308, 0x33000080);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x9000094);
	MDP_OUTP(MDP_BASE + 0x5030c, 0x3300007b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x9c00098);
	MDP_OUTP(MDP_BASE + 0x50310, 0x32400077);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xa40009b);
	MDP_OUTP(MDP_BASE + 0x50314, 0x32000073);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xb00009d);
	MDP_OUTP(MDP_BASE + 0x50318, 0x31c0006f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xbc000a0);
	MDP_OUTP(MDP_BASE + 0x5031c, 0x3140006b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xc8000a2);
	MDP_OUTP(MDP_BASE + 0x50320, 0x31000067);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xd8000a5);
	MDP_OUTP(MDP_BASE + 0x50324, 0x30800062);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xe4000a8);
	MDP_OUTP(MDP_BASE + 0x50328, 0x2fc0005f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xec000aa);
	MDP_OUTP(MDP_BASE + 0x5032c, 0x2fc0005b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf8000ad);
	MDP_OUTP(MDP_BASE + 0x50330, 0x2f400057);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x108000b0);
	MDP_OUTP(MDP_BASE + 0x50334, 0x2e400054);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x114000b2);
	MDP_OUTP(MDP_BASE + 0x50338, 0x2e000050);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x124000b4);
	MDP_OUTP(MDP_BASE + 0x5033c, 0x2d80004c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x130000b6);
	MDP_OUTP(MDP_BASE + 0x50340, 0x2d000049);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x140000b8);
	MDP_OUTP(MDP_BASE + 0x50344, 0x2c800045);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x150000b9);
	MDP_OUTP(MDP_BASE + 0x50348, 0x2c000042);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x15c000bd);
	MDP_OUTP(MDP_BASE + 0x5034c, 0x2b40003e);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x16c000bf);
	MDP_OUTP(MDP_BASE + 0x50350, 0x2a80003b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x17c000bf);
	MDP_OUTP(MDP_BASE + 0x50354, 0x2a000039);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x188000c2);
	MDP_OUTP(MDP_BASE + 0x50358, 0x29400036);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x19c000c4);
	MDP_OUTP(MDP_BASE + 0x5035c, 0x28800032);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ac000c5);
	MDP_OUTP(MDP_BASE + 0x50360, 0x2800002f);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1bc000c7);
	MDP_OUTP(MDP_BASE + 0x50364, 0x2740002c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1cc000c8);
	MDP_OUTP(MDP_BASE + 0x50368, 0x26c00029);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1dc000c9);
	MDP_OUTP(MDP_BASE + 0x5036c, 0x26000027);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1ec000cc);
	MDP_OUTP(MDP_BASE + 0x50370, 0x25000024);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x200000cc);
	MDP_OUTP(MDP_BASE + 0x50374, 0x24800021);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x210000cd);
	MDP_OUTP(MDP_BASE + 0x50378, 0x23800020);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x220000ce);
	MDP_OUTP(MDP_BASE + 0x5037c, 0x2300001d);
}

static void mdp_load_bc_downscale_table_x_point6TOpoint8(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe000070);
	MDP_OUTP(MDP_BASE + 0x50280, 0x4bc00068);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe000078);
	MDP_OUTP(MDP_BASE + 0x50284, 0x4bc00060);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe000080);
	MDP_OUTP(MDP_BASE + 0x50288, 0x4b800059);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe000089);
	MDP_OUTP(MDP_BASE + 0x5028c, 0x4b000052);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe400091);
	MDP_OUTP(MDP_BASE + 0x50290, 0x4a80004b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe40009a);
	MDP_OUTP(MDP_BASE + 0x50294, 0x4a000044);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe8000a3);
	MDP_OUTP(MDP_BASE + 0x50298, 0x4940003d);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfec000ac);
	MDP_OUTP(MDP_BASE + 0x5029c, 0x48400037);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xff0000b4);
	MDP_OUTP(MDP_BASE + 0x502a0, 0x47800031);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xff8000bd);
	MDP_OUTP(MDP_BASE + 0x502a4, 0x4640002b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xc5);
	MDP_OUTP(MDP_BASE + 0x502a8, 0x45000026);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x8000ce);
	MDP_OUTP(MDP_BASE + 0x502ac, 0x43800021);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x10000d6);
	MDP_OUTP(MDP_BASE + 0x502b0, 0x4240001c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x18000df);
	MDP_OUTP(MDP_BASE + 0x502b4, 0x40800018);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x24000e6);
	MDP_OUTP(MDP_BASE + 0x502b8, 0x3f000014);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x30000ee);
	MDP_OUTP(MDP_BASE + 0x502bc, 0x3d400010);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x40000f5);
	MDP_OUTP(MDP_BASE + 0x502c0, 0x3b80000c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x50000fc);
	MDP_OUTP(MDP_BASE + 0x502c4, 0x39800009);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x6000102);
	MDP_OUTP(MDP_BASE + 0x502c8, 0x37c00006);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x7000109);
	MDP_OUTP(MDP_BASE + 0x502cc, 0x35800004);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x840010e);
	MDP_OUTP(MDP_BASE + 0x502d0, 0x33800002);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x9800114);
	MDP_OUTP(MDP_BASE + 0x502d4, 0x31400000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xac00119);
	MDP_OUTP(MDP_BASE + 0x502d8, 0x2f4003fe);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xc40011e);
	MDP_OUTP(MDP_BASE + 0x502dc, 0x2d0003fc);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xdc00121);
	MDP_OUTP(MDP_BASE + 0x502e0, 0x2b0003fb);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf400125);
	MDP_OUTP(MDP_BASE + 0x502e4, 0x28c003fa);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x11000128);
	MDP_OUTP(MDP_BASE + 0x502e8, 0x268003f9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x12c0012a);
	MDP_OUTP(MDP_BASE + 0x502ec, 0x244003f9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1480012c);
	MDP_OUTP(MDP_BASE + 0x502f0, 0x224003f8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1640012e);
	MDP_OUTP(MDP_BASE + 0x502f4, 0x200003f8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1800012f);
	MDP_OUTP(MDP_BASE + 0x502f8, 0x1e0003f8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1a00012f);
	MDP_OUTP(MDP_BASE + 0x502fc, 0x1c0003f8);
}

static void mdp_load_bc_downscale_table_y_point6TOpoint8(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe000070);
	MDP_OUTP(MDP_BASE + 0x50300, 0x4bc00068);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe000078);
	MDP_OUTP(MDP_BASE + 0x50304, 0x4bc00060);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe000080);
	MDP_OUTP(MDP_BASE + 0x50308, 0x4b800059);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe000089);
	MDP_OUTP(MDP_BASE + 0x5030c, 0x4b000052);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe400091);
	MDP_OUTP(MDP_BASE + 0x50310, 0x4a80004b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe40009a);
	MDP_OUTP(MDP_BASE + 0x50314, 0x4a000044);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe8000a3);
	MDP_OUTP(MDP_BASE + 0x50318, 0x4940003d);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfec000ac);
	MDP_OUTP(MDP_BASE + 0x5031c, 0x48400037);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xff0000b4);
	MDP_OUTP(MDP_BASE + 0x50320, 0x47800031);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xff8000bd);
	MDP_OUTP(MDP_BASE + 0x50324, 0x4640002b);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xc5);
	MDP_OUTP(MDP_BASE + 0x50328, 0x45000026);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x8000ce);
	MDP_OUTP(MDP_BASE + 0x5032c, 0x43800021);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x10000d6);
	MDP_OUTP(MDP_BASE + 0x50330, 0x4240001c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x18000df);
	MDP_OUTP(MDP_BASE + 0x50334, 0x40800018);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x24000e6);
	MDP_OUTP(MDP_BASE + 0x50338, 0x3f000014);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x30000ee);
	MDP_OUTP(MDP_BASE + 0x5033c, 0x3d400010);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x40000f5);
	MDP_OUTP(MDP_BASE + 0x50340, 0x3b80000c);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x50000fc);
	MDP_OUTP(MDP_BASE + 0x50344, 0x39800009);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x6000102);
	MDP_OUTP(MDP_BASE + 0x50348, 0x37c00006);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x7000109);
	MDP_OUTP(MDP_BASE + 0x5034c, 0x35800004);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x840010e);
	MDP_OUTP(MDP_BASE + 0x50350, 0x33800002);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x9800114);
	MDP_OUTP(MDP_BASE + 0x50354, 0x31400000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xac00119);
	MDP_OUTP(MDP_BASE + 0x50358, 0x2f4003fe);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xc40011e);
	MDP_OUTP(MDP_BASE + 0x5035c, 0x2d0003fc);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xdc00121);
	MDP_OUTP(MDP_BASE + 0x50360, 0x2b0003fb);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf400125);
	MDP_OUTP(MDP_BASE + 0x50364, 0x28c003fa);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x11000128);
	MDP_OUTP(MDP_BASE + 0x50368, 0x268003f9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x12c0012a);
	MDP_OUTP(MDP_BASE + 0x5036c, 0x244003f9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1480012c);
	MDP_OUTP(MDP_BASE + 0x50370, 0x224003f8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1640012e);
	MDP_OUTP(MDP_BASE + 0x50374, 0x200003f8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1800012f);
	MDP_OUTP(MDP_BASE + 0x50378, 0x1e0003f8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x1a00012f);
	MDP_OUTP(MDP_BASE + 0x5037c, 0x1c0003f8);
}

static void mdp_load_bc_downscale_table_x_point8TO1(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50280, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xff80000d);
	MDP_OUTP(MDP_BASE + 0x50284, 0x7ec003f9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfec0001c);
	MDP_OUTP(MDP_BASE + 0x50288, 0x7d4003f3);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe40002b);
	MDP_OUTP(MDP_BASE + 0x5028c, 0x7b8003ed);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfd80003c);
	MDP_OUTP(MDP_BASE + 0x50290, 0x794003e8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfcc0004d);
	MDP_OUTP(MDP_BASE + 0x50294, 0x76c003e4);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfc40005f);
	MDP_OUTP(MDP_BASE + 0x50298, 0x73c003e0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfb800071);
	MDP_OUTP(MDP_BASE + 0x5029c, 0x708003de);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfac00085);
	MDP_OUTP(MDP_BASE + 0x502a0, 0x6d0003db);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfa000098);
	MDP_OUTP(MDP_BASE + 0x502a4, 0x698003d9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf98000ac);
	MDP_OUTP(MDP_BASE + 0x502a8, 0x654003d8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf8c000c1);
	MDP_OUTP(MDP_BASE + 0x502ac, 0x610003d7);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf84000d5);
	MDP_OUTP(MDP_BASE + 0x502b0, 0x5c8003d7);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf7c000e9);
	MDP_OUTP(MDP_BASE + 0x502b4, 0x580003d7);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf74000fd);
	MDP_OUTP(MDP_BASE + 0x502b8, 0x534003d8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6c00112);
	MDP_OUTP(MDP_BASE + 0x502bc, 0x4e8003d8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6800126);
	MDP_OUTP(MDP_BASE + 0x502c0, 0x494003da);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf600013a);
	MDP_OUTP(MDP_BASE + 0x502c4, 0x448003db);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf600014d);
	MDP_OUTP(MDP_BASE + 0x502c8, 0x3f4003dd);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf5c00160);
	MDP_OUTP(MDP_BASE + 0x502cc, 0x3a4003df);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf5c00172);
	MDP_OUTP(MDP_BASE + 0x502d0, 0x354003e1);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf5c00184);
	MDP_OUTP(MDP_BASE + 0x502d4, 0x304003e3);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6000195);
	MDP_OUTP(MDP_BASE + 0x502d8, 0x2b0003e6);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf64001a6);
	MDP_OUTP(MDP_BASE + 0x502dc, 0x260003e8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6c001b4);
	MDP_OUTP(MDP_BASE + 0x502e0, 0x214003eb);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf78001c2);
	MDP_OUTP(MDP_BASE + 0x502e4, 0x1c4003ee);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf80001cf);
	MDP_OUTP(MDP_BASE + 0x502e8, 0x17c003f1);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf90001db);
	MDP_OUTP(MDP_BASE + 0x502ec, 0x134003f3);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfa0001e5);
	MDP_OUTP(MDP_BASE + 0x502f0, 0xf0003f6);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfb4001ee);
	MDP_OUTP(MDP_BASE + 0x502f4, 0xac003f9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfcc001f5);
	MDP_OUTP(MDP_BASE + 0x502f8, 0x70003fb);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe4001fb);
	MDP_OUTP(MDP_BASE + 0x502fc, 0x34003fe);
}

static void mdp_load_bc_downscale_table_y_point8TO1(void)
{
	MDP_OUTP(MDP_BASE + 0x5fffc, 0x0);
	MDP_OUTP(MDP_BASE + 0x50300, 0x7fc00000);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xff80000d);
	MDP_OUTP(MDP_BASE + 0x50304, 0x7ec003f9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfec0001c);
	MDP_OUTP(MDP_BASE + 0x50308, 0x7d4003f3);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe40002b);
	MDP_OUTP(MDP_BASE + 0x5030c, 0x7b8003ed);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfd80003c);
	MDP_OUTP(MDP_BASE + 0x50310, 0x794003e8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfcc0004d);
	MDP_OUTP(MDP_BASE + 0x50314, 0x76c003e4);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfc40005f);
	MDP_OUTP(MDP_BASE + 0x50318, 0x73c003e0);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfb800071);
	MDP_OUTP(MDP_BASE + 0x5031c, 0x708003de);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfac00085);
	MDP_OUTP(MDP_BASE + 0x50320, 0x6d0003db);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfa000098);
	MDP_OUTP(MDP_BASE + 0x50324, 0x698003d9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf98000ac);
	MDP_OUTP(MDP_BASE + 0x50328, 0x654003d8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf8c000c1);
	MDP_OUTP(MDP_BASE + 0x5032c, 0x610003d7);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf84000d5);
	MDP_OUTP(MDP_BASE + 0x50330, 0x5c8003d7);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf7c000e9);
	MDP_OUTP(MDP_BASE + 0x50334, 0x580003d7);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf74000fd);
	MDP_OUTP(MDP_BASE + 0x50338, 0x534003d8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6c00112);
	MDP_OUTP(MDP_BASE + 0x5033c, 0x4e8003d8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6800126);
	MDP_OUTP(MDP_BASE + 0x50340, 0x494003da);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf600013a);
	MDP_OUTP(MDP_BASE + 0x50344, 0x448003db);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf600014d);
	MDP_OUTP(MDP_BASE + 0x50348, 0x3f4003dd);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf5c00160);
	MDP_OUTP(MDP_BASE + 0x5034c, 0x3a4003df);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf5c00172);
	MDP_OUTP(MDP_BASE + 0x50350, 0x354003e1);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf5c00184);
	MDP_OUTP(MDP_BASE + 0x50354, 0x304003e3);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6000195);
	MDP_OUTP(MDP_BASE + 0x50358, 0x2b0003e6);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf64001a6);
	MDP_OUTP(MDP_BASE + 0x5035c, 0x260003e8);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf6c001b4);
	MDP_OUTP(MDP_BASE + 0x50360, 0x214003eb);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf78001c2);
	MDP_OUTP(MDP_BASE + 0x50364, 0x1c4003ee);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf80001cf);
	MDP_OUTP(MDP_BASE + 0x50368, 0x17c003f1);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xf90001db);
	MDP_OUTP(MDP_BASE + 0x5036c, 0x134003f3);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfa0001e5);
	MDP_OUTP(MDP_BASE + 0x50370, 0xf0003f6);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfb4001ee);
	MDP_OUTP(MDP_BASE + 0x50374, 0xac003f9);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfcc001f5);
	MDP_OUTP(MDP_BASE + 0x50378, 0x70003fb);
	MDP_OUTP(MDP_BASE + 0x5fffc, 0xfe4001fb);
	MDP_OUTP(MDP_BASE + 0x5037c, 0x34003fe);
}

static int mdp_get_edge_cond(MDPIBUF *iBuf, uint32 *dup, uint32 *dup2)
{
	uint32 reg;
	uint32 dst_roi_width;	/* Dimensions of DST ROI. */
	uint32 dst_roi_height;	/* Used to calculate scaling ratios. */

	/*
	 * positions of the luma pixel(relative to the image ) required for
	 * scaling the ROI
	 */
	int32 luma_interp_point_left = 0; /* left-most luma pixel needed */
	int32 luma_interp_point_right = 0; /* right-most luma pixel needed */
	int32 luma_interp_point_top = 0; /* top-most luma pixel needed */
	int32 luma_interp_point_bottom = 0; /* bottom-most luma pixel needed */

	/*
	 * positions of the chroma pixel(relative to the image ) required for
	 * interpolating a chroma value at all required luma positions
	 */
	/* left-most chroma pixel needed */
	int32 chroma_interp_point_left = 0;
	/* right-most chroma pixel needed */
	int32 chroma_interp_point_right = 0;
	/* top-most chroma pixel needed */
	int32 chroma_interp_point_top = 0;
	/* bottom-most chroma pixel needed */
	int32 chroma_interp_point_bottom = 0;

	/*
	 * a rectangular region within the chroma plane of the "image".
	 * Chroma pixels falling inside of this rectangle belongs to the ROI
	 */
	int32 chroma_bound_left = 0;
	int32 chroma_bound_right = 0;
	int32 chroma_bound_top = 0;
	int32 chroma_bound_bottom = 0;

	/*
	 * number of chroma pixels to replicate on the left, right,
	 * top and bottom edge of the ROI.
	 */
	int32 chroma_repeat_left = 0;
	int32 chroma_repeat_right = 0;
	int32 chroma_repeat_top = 0;
	int32 chroma_repeat_bottom = 0;

	/*
	 * number of luma pixels to replicate on the left, right,
	 * top and bottom edge of the ROI.
	 */
	int32 luma_repeat_left = 0;
	int32 luma_repeat_right = 0;
	int32 luma_repeat_top = 0;
	int32 luma_repeat_bottom = 0;

	boolean chroma_edge_enable;

	uint32 _is_scale_enabled = 0;
	uint32 _is_yuv_offsite_vertical = 0;

	/* fg edge duplicate */
	reg = 0x0;

	if (iBuf->mdpImg.mdpOp & MDPOP_ASCALE) {	/* if scaling enabled */

		_is_scale_enabled = 1;

		/*
		 * if rotation mode involves a 90 deg rotation, flip
		 * dst_roi_width with dst_roi_height.
		 * Scaling ratios is based on source ROI dimensions, and
		 * dst ROI dimensions before rotation.
		 */
		if (iBuf->mdpImg.mdpOp & MDPOP_ROT90) {
			dst_roi_width = iBuf->roi.dst_height;
			dst_roi_height = iBuf->roi.dst_width;
		} else {
			dst_roi_width = iBuf->roi.dst_width;
			dst_roi_height = iBuf->roi.dst_height;
		}

		/*
		 * Find out the luma pixels needed for scaling in the
		 * x direction (LEFT and RIGHT).  Locations of pixels are
		 * relative to the ROI. Upper-left corner of ROI corresponds
		 * to coordinates (0,0). Also set the number of luma pixel
		 * to repeat.
		 */
		if (iBuf->roi.width > 3 * dst_roi_width) {
			/* scale factor < 1/3 */
			luma_interp_point_left = 0;
			luma_interp_point_right = (iBuf->roi.width - 1);
			luma_repeat_left = 0;
			luma_repeat_right = 0;
		} else if (iBuf->roi.width == 3 * dst_roi_width) {
			/* scale factor == 1/3 */
			luma_interp_point_left = 0;
			luma_interp_point_right = (iBuf->roi.width - 1) + 1;
			luma_repeat_left = 0;
			luma_repeat_right = 1;
		} else if ((iBuf->roi.width > dst_roi_width) &&
			   (iBuf->roi.width < 3 * dst_roi_width)) {
			/* 1/3 < scale factor < 1 */
			luma_interp_point_left = -1;
			luma_interp_point_right = (iBuf->roi.width - 1) + 1;
			luma_repeat_left = 1;
			luma_repeat_right = 1;
		}

		else if (iBuf->roi.width == dst_roi_width) {
			/* scale factor == 1 */
			luma_interp_point_left = -1;
			luma_interp_point_right = (iBuf->roi.width - 1) + 2;
			luma_repeat_left = 1;
			luma_repeat_right = 2;
		} else {	/* (iBuf->roi.width < dst_roi_width) */
			  /* scale factor > 1 */
			luma_interp_point_left = -2;
			luma_interp_point_right = (iBuf->roi.width - 1) + 2;
			luma_repeat_left = 2;
			luma_repeat_right = 2;
		}

		/*
		 * Find out the number of pixels needed for scaling in the
		 * y direction (TOP and BOTTOM).  Locations of pixels are
		 * relative to the ROI. Upper-left corner of ROI corresponds
		 * to coordinates (0,0). Also set the number of luma pixel
		 * to repeat.
		 */
		if (iBuf->roi.height > 3 * dst_roi_height) {
			/* scale factor < 1/3 */
			luma_interp_point_top = 0;
			luma_interp_point_bottom = (iBuf->roi.height - 1);
			luma_repeat_top = 0;
			luma_repeat_bottom = 0;
		} else if (iBuf->roi.height == 3 * dst_roi_height) {
			/* scale factor == 1/3 */
			luma_interp_point_top = 0;
			luma_interp_point_bottom = (iBuf->roi.height - 1) + 1;
			luma_repeat_top = 0;
			luma_repeat_bottom = 1;
		} else if ((iBuf->roi.height > dst_roi_height) &&
			   (iBuf->roi.height < 3 * dst_roi_height)) {
			/* 1/3 < scale factor < 1 */
			luma_interp_point_top = -1;
			luma_interp_point_bottom = (iBuf->roi.height - 1) + 1;
			luma_repeat_top = 1;
			luma_repeat_bottom = 1;
		} else if (iBuf->roi.height == dst_roi_height) {
			/* scale factor == 1 */
			luma_interp_point_top = -1;
			luma_interp_point_bottom = (iBuf->roi.height - 1) + 2;
			luma_repeat_top = 1;
			luma_repeat_bottom = 2;
		} else {	/* (iBuf->roi.height < dst_roi_height) */
			 /* scale factor > 1 */
			luma_interp_point_top = -2;
			luma_interp_point_bottom = (iBuf->roi.height - 1) + 2;
			luma_repeat_top = 2;
			luma_repeat_bottom = 2;
		}
	}			/* if (iBuf->scale.scale_flag) */
	else {			/* scaling disabled */
		/*
		 * Since no scaling needed, Tile Fetch does not require any
		 * more luma pixel than what the ROI contains.
		 */
		luma_interp_point_left = (int32) 0;
		luma_interp_point_right = (int32) (iBuf->roi.width - 1);
		luma_interp_point_top = (int32) 0;
		luma_interp_point_bottom = (int32) (iBuf->roi.height - 1);

		luma_repeat_left = 0;
		luma_repeat_right = 0;
		luma_repeat_top = 0;
		luma_repeat_bottom = 0;
	}

	/* After adding the ROI offsets, we have locations of
	 * luma_interp_points relative to the image.
	 */
	luma_interp_point_left += (int32) (iBuf->roi.x);
	luma_interp_point_right += (int32) (iBuf->roi.x);
	luma_interp_point_top += (int32) (iBuf->roi.y);
	luma_interp_point_bottom += (int32) (iBuf->roi.y);

	/*
	 * After adding the ROI offsets, we have locations of
	 * chroma_interp_points relative to the image.
	 */
	chroma_interp_point_left = luma_interp_point_left;
	chroma_interp_point_right = luma_interp_point_right;
	chroma_interp_point_top = luma_interp_point_top;
	chroma_interp_point_bottom = luma_interp_point_bottom;

	chroma_edge_enable = TRUE;
	/* find out which chroma pixels are needed for chroma upsampling. */
	switch (iBuf->mdpImg.imgType) {
		/*
		 * cosite in horizontal axis
		 * fully sampled in vertical axis
		 */
	case MDP_Y_CBCR_H2V1:
	case MDP_Y_CRCB_H2V1:
	case MDP_YCRYCB_H2V1:
		/* floor( luma_interp_point_left / 2 ); */
		chroma_interp_point_left = luma_interp_point_left >> 1;
		/* floor( ( luma_interp_point_right + 1 ) / 2 ); */
		chroma_interp_point_right = (luma_interp_point_right + 1) >> 1;

		chroma_interp_point_top = luma_interp_point_top;
		chroma_interp_point_bottom = luma_interp_point_bottom;
		break;

		/*
		 * cosite in horizontal axis
		 * offsite in vertical axis
		 */
	case MDP_Y_CBCR_H2V2:
	case MDP_Y_CBCR_H2V2_ADRENO:
	case MDP_Y_CRCB_H2V2:
		/* floor( luma_interp_point_left / 2) */
		chroma_interp_point_left = luma_interp_point_left >> 1;

		/* floor( ( luma_interp_point_right + 1 )/ 2 ) */
		chroma_interp_point_right = (luma_interp_point_right + 1) >> 1;

		/* floor( (luma_interp_point_top - 1 ) / 2 ) */
		chroma_interp_point_top = (luma_interp_point_top - 1) >> 1;

		/* floor( ( luma_interp_point_bottom + 1 ) / 2 ) */
		chroma_interp_point_bottom =
		    (luma_interp_point_bottom + 1) >> 1;

		_is_yuv_offsite_vertical = 1;
		break;

	default:
		chroma_edge_enable = FALSE;
		chroma_interp_point_left = luma_interp_point_left;
		chroma_interp_point_right = luma_interp_point_right;
		chroma_interp_point_top = luma_interp_point_top;
		chroma_interp_point_bottom = luma_interp_point_bottom;

		break;
	}

	/* only if the image type is in YUV domain, we calculate chroma edge */
	if (chroma_edge_enable) {
		/* Defines which chroma pixels belongs to the roi */
		switch (iBuf->mdpImg.imgType) {
			/*
			 * Cosite in horizontal direction, and fully sampled
			 * in vertical direction.
			 */
		case MDP_Y_CBCR_H2V1:
		case MDP_Y_CRCB_H2V1:
		case MDP_YCRYCB_H2V1:
			/*
			 * width of chroma ROI is 1/2 of size of luma ROI
			 * height of chroma ROI same as size of luma ROI
			 */
			chroma_bound_left = iBuf->roi.x / 2;

			/* there are half as many chroma pixel as luma pixels */
			chroma_bound_right =
			    (iBuf->roi.width + iBuf->roi.x - 1) / 2;
			chroma_bound_top = iBuf->roi.y;
			chroma_bound_bottom =
			    (iBuf->roi.height + iBuf->roi.y - 1);
			break;

		case MDP_Y_CBCR_H2V2:
		case MDP_Y_CBCR_H2V2_ADRENO:
		case MDP_Y_CRCB_H2V2:
			/*
			 * cosite in horizontal dir, and offsite in vertical dir
			 * width of chroma ROI is 1/2 of size of luma ROI
			 * height of chroma ROI is 1/2 of size of luma ROI
			 */

			chroma_bound_left = iBuf->roi.x / 2;
			chroma_bound_right =
			    (iBuf->roi.width + iBuf->roi.x - 1) / 2;
			chroma_bound_top = iBuf->roi.y / 2;
			chroma_bound_bottom =
			    (iBuf->roi.height + iBuf->roi.y - 1) / 2;
			break;

		default:
			/*
			 * If no valid chroma sub-sampling format specified,
			 * assume 4:4:4 ( i.e. fully sampled).  Set ROI
			 * boundaries for chroma same as ROI boundaries for
			 * luma.
			 */
			chroma_bound_left = iBuf->roi.x;
			chroma_bound_right = iBuf->roi.width + iBuf->roi.x - 1;
			chroma_bound_top = iBuf->roi.y;
			chroma_bound_bottom =
			    (iBuf->roi.height + iBuf->roi.y - 1);
			break;
		}

		/*
		 * Knowing which chroma pixels are needed, and which chroma
		 * pixels belong to the ROI (i.e. available for fetching ),
		 * calculate how many chroma pixels Tile Fetch needs to
		 * duplicate.  If any required chroma pixels falls outside
		 * of the ROI, Tile Fetch must obtain them by replicating
		 * pixels.
		 */
		if (chroma_bound_left > chroma_interp_point_left)
			chroma_repeat_left =
			    chroma_bound_left - chroma_interp_point_left;
		else
			chroma_repeat_left = 0;

		if (chroma_interp_point_right > chroma_bound_right)
			chroma_repeat_right =
			    chroma_interp_point_right - chroma_bound_right;
		else
			chroma_repeat_right = 0;

		if (chroma_bound_top > chroma_interp_point_top)
			chroma_repeat_top =
			    chroma_bound_top - chroma_interp_point_top;
		else
			chroma_repeat_top = 0;

		if (chroma_interp_point_bottom > chroma_bound_bottom)
			chroma_repeat_bottom =
			    chroma_interp_point_bottom - chroma_bound_bottom;
		else
			chroma_repeat_bottom = 0;

		if (_is_scale_enabled && (iBuf->roi.height == 1)
		    && _is_yuv_offsite_vertical) {
			chroma_repeat_bottom = 3;
			chroma_repeat_top = 0;
		}
	}
	/* make sure chroma repeats are non-negative */
	if ((chroma_repeat_left < 0) || (chroma_repeat_right < 0) ||
	    (chroma_repeat_top < 0) || (chroma_repeat_bottom < 0))
		return -1;

	/* make sure chroma repeats are no larger than 3 pixels */
	if ((chroma_repeat_left > 3) || (chroma_repeat_right > 3) ||
	    (chroma_repeat_top > 3) || (chroma_repeat_bottom > 3))
		return -1;

	/* make sure luma repeats are non-negative */
	if ((luma_repeat_left < 0) || (luma_repeat_right < 0) ||
	    (luma_repeat_top < 0) || (luma_repeat_bottom < 0))
		return -1;

	/* make sure luma repeats are no larger than 3 pixels */
	if ((luma_repeat_left > 3) || (luma_repeat_right > 3) ||
	    (luma_repeat_top > 3) || (luma_repeat_bottom > 3))
		return -1;

	/* write chroma_repeat_left to register */
	reg |= (chroma_repeat_left & 3) << MDP_LEFT_CHROMA;

	/* write chroma_repeat_right to register */
	reg |= (chroma_repeat_right & 3) << MDP_RIGHT_CHROMA;

	/* write chroma_repeat_top to register */
	reg |= (chroma_repeat_top & 3) << MDP_TOP_CHROMA;

	/* write chroma_repeat_bottom to register */
	reg |= (chroma_repeat_bottom & 3) << MDP_BOTTOM_CHROMA;

	/* write luma_repeat_left to register */
	reg |= (luma_repeat_left & 3) << MDP_LEFT_LUMA;

	/* write luma_repeat_right to register */
	reg |= (luma_repeat_right & 3) << MDP_RIGHT_LUMA;

	/* write luma_repeat_top to register */
	reg |= (luma_repeat_top & 3) << MDP_TOP_LUMA;

	/* write luma_repeat_bottom to register */
	reg |= (luma_repeat_bottom & 3) << MDP_BOTTOM_LUMA;

	/* done with reg */
	*dup = reg;

	/* bg edge duplicate */
	reg = 0x0;

	switch (iBuf->ibuf_type) {
	case MDP_Y_CBCR_H2V2:
	case MDP_Y_CRCB_H2V2:
		/*
		 * Edge condition for MDP_Y_CRCB/CBCR_H2V2 cosite only.
		 * For 420 cosite, 1 chroma replicated on all sides except
		 * left, so reg 101b8 should be 0x0209. For 420 offsite,
		 * 1 chroma replicated all sides.
		 */
		if (iBuf->roi.lcd_y == 0) {
			reg |= BIT(MDP_TOP_CHROMA);
		}

		if ((iBuf->roi.lcd_y + iBuf->roi.dst_height) ==
		    iBuf->ibuf_height) {
			reg |= BIT(MDP_BOTTOM_CHROMA);
		}

		if (((iBuf->roi.lcd_x + iBuf->roi.dst_width) ==
		     iBuf->ibuf_width) && ((iBuf->roi.dst_width % 2) == 0)) {
			reg |= BIT(MDP_RIGHT_CHROMA);
		}

		break;

	case MDP_Y_CBCR_H2V1:
	case MDP_Y_CRCB_H2V1:
	case MDP_YCRYCB_H2V1:
		if (((iBuf->roi.lcd_x + iBuf->roi.dst_width) ==
		     iBuf->ibuf_width) && ((iBuf->roi.dst_width % 2) == 0)) {
			reg |= BIT(MDP_RIGHT_CHROMA);
		}
		break;
	default:
		break;
	}

	*dup2 = reg;

	return 0;
}

#define ADJUST_IP		/* for 1/3 scale factor fix */

static int mdp_calc_scale_params(
/* ROI origin coordinate for the dimension */
					uint32 org,
/* src ROI dimension */
					uint32 dim_in,
/* scaled ROI dimension*/
					uint32 dim_out,
/* is this ROI width dimension? */
					boolean is_W,
/* initial phase location address */
					int32 *phase_init_ptr,
/* phase increment location address */
					uint32 *phase_step_ptr,
/* ROI start over-fetch location address */
					uint32 *num_repl_beg_ptr,
/* ROI end over-fetch location address */
					uint32 *num_repl_end_ptr)
{
	boolean rpa_on = FALSE;
	int init_phase = 0;
	uint32 beg_of = 0;
	uint32 end_of = 0;
	uint64 numer = 0;
	uint64 denom = 0;
	/*uint64 inverter = 1; */
	int64 point5 = 1;
	int64 one = 1;
	int64 k1, k2, k3, k4;	/* linear equation coefficients */
	uint64 int_mask;
	uint64 fract_mask;
	uint64 Os;
	int64 Osprime;
	int64 Od;
	int64 Odprime;
	int64 Oreq;
	uint64 Es;
	uint64 Ed;
	uint64 Ereq;
#ifdef ADJUST_IP
	int64 IP64;
	int64 delta;
#endif
	uint32 mult;

	/*
	 * The phase accumulator should really be rational for all cases in a
	 * general purpose polyphase scaler for a tiled architecture with
	 * non-zero * origin capability because there is no way to represent
	 * certain scale factors in fixed point regardless of precision.
	 * The error incurred in attempting to use fixed point is most
	 * eggregious for SF where 1/SF is an integral multiple of 1/3.
	 *
	 * However, since the MDP2 has already been committed to HW, we
	 * only use the rational phase accumulator (RPA) when 1/SF is an
	 * integral multiple of 1/3.  This will help minimize regressions in
	 * matching the HW to the C-Sim.
	 */
	/*
	 * Set the RPA flag for this dimension.
	 *
	 * In order for 1/SF (dim_in/dim_out) to be an integral multiple of
	 * 1/3, dim_out must be an integral multiple of 3.
	 */
	if (!(dim_out % 3)) {
		mult = dim_out / 3;
		rpa_on = (!(dim_in % mult));
	}

	numer = dim_out;
	denom = dim_in;

	/*
	 * convert to U30.34 before division
	 *
	 * The K vectors carry 4 extra bits of precision
	 * and are rounded.
	 *
	 * We initially go 5 bits over then round by adding
	 * 1 and right shifting by 1
	 * so final result is U31.33
	 */
	numer <<= PQF_PLUS_5;

	/* now calculate the scale factor (aka k3) */
	k3 = ((mdp_do_div(numer, denom) + 1) >> 1);

	/* check scale factor for legal range [0.25 - 4.0] */
	if (((k3 >> 4) < (1LL << PQF_MINUS_2)) ||
	    ((k3 >> 4) > (1LL << PQF_PLUS_2))) {
		return -1;
	}

	/* calculate inverse scale factor (aka k1) for phase init */
	numer = dim_in;
	denom = dim_out;
	numer <<= PQF_PLUS_5;
	k1 = ((mdp_do_div(numer, denom) + 1) >> 1);

	/*
	 * calculate initial phase and ROI overfetch
	 */
	/* convert point5 & one to S39.24 (will always be positive) */
	point5 <<= (PQF_PLUS_4 - 1);
	one <<= PQF_PLUS_4;
	k2 = ((k1 - one) >> 1);
	init_phase = (int)(k2 >> 4);
	k4 = ((k3 - one) >> 1);
	if (k3 == one) {
		/* the simple case; SF = 1.0 */
		beg_of = 1;
		end_of = 2;
	} else {
		/* calculate the masks */
		fract_mask = one - 1;
		int_mask = ~fract_mask;

		if (!rpa_on) {
			/*
			 * FIXED POINT IMPLEMENTATION
			 */
			if (!org) {
				/* A fairly simple case; ROI origin = 0 */
				if (k1 < one) {
					/* upscaling */
					beg_of = end_of = 2;
				}
				/* 0.33 <= SF < 1.0 */
				else if (k1 < (3LL << PQF_PLUS_4))
					beg_of = end_of = 1;
				/* 0.33 == SF */
				else if (k1 == (3LL << PQF_PLUS_4)) {
					beg_of = 0;
					end_of = 1;
				}
				/* 0.25 <= SF < 0.33 */
				else
					beg_of = end_of = 0;
			} else {
				/*
				 * The complicated case; ROI origin != 0
				 * init_phase needs to be adjusted
				 * OF is also position dependent
				 */

				/* map (org - .5) into destination space */
				Os = ((uint64) org << 1) - 1;
				Od = ((k3 * Os) >> 1) + k4;

				/* take the ceiling */
				Odprime = (Od & int_mask);
				if (Odprime != Od)
					Odprime += one;

				/* now map that back to source space */
				Osprime = (k1 * (Odprime >> PQF_PLUS_4)) + k2;

				/* then floor & decrement to calculate the required
				   starting coordinate */
				Oreq = (Osprime & int_mask) - one;

				/* calculate end coord in destination space then map to
				   source space */
				Ed = Odprime +
				    ((uint64) dim_out << PQF_PLUS_4) - one;
				Es = (k1 * (Ed >> PQF_PLUS_4)) + k2;

				/* now floor & increment by 2 to calculate the required
				   ending coordinate */
				Ereq = (Es & int_mask) + (one << 1);

				/* calculate initial phase */
#ifdef ADJUST_IP

				IP64 = Osprime - Oreq;
				delta = ((int64) (org) << PQF_PLUS_4) - Oreq;
				IP64 -= delta;

				/* limit to valid range before the left shift */
				delta = (IP64 & (1LL << 63)) ? 4 : -4;
				delta <<= PQF_PLUS_4;
				while (abs((int)(IP64 >> PQF_PLUS_4)) > 4)
					IP64 += delta;

				/* right shift to account for extra bits of precision */
				init_phase = (int)(IP64 >> 4);

#else /* ADJUST_IP */

				/* just calculate the real initial phase */
				init_phase = (int)((Osprime - Oreq) >> 4);

#endif /* ADJUST_IP */

				/* calculate the overfetch */
				beg_of = org - (uint32) (Oreq >> PQF_PLUS_4);
				end_of =
				    (uint32) (Ereq >> PQF_PLUS_4) - (org +
								     dim_in -
								     1);
			}
		} else {
			/*
			 * RPA IMPLEMENTATION
			 *
			 * init_phase needs to be calculated in all RPA_on cases
			 * because it's a numerator, not a fixed point value.
			 */

			/* map (org - .5) into destination space */
			Os = ((uint64) org << PQF_PLUS_4) - point5;
			Od = mdp_do_div((dim_out * (Os + point5)),
					dim_in) - point5;

			/* take the ceiling */
			Odprime = (Od & int_mask);
			if (Odprime != Od)
				Odprime += one;

			/* now map that back to source space */
			Osprime =
			    mdp_do_div((dim_in * (Odprime + point5)),
				       dim_out) - point5;

			/* then floor & decrement to calculate the required
			   starting coordinate */
			Oreq = (Osprime & int_mask) - one;

			/* calculate end coord in destination space then map to
			   source space */
			Ed = Odprime + ((uint64) dim_out << PQF_PLUS_4) - one;
			Es = mdp_do_div((dim_in * (Ed + point5)),
					dim_out) - point5;

			/* now floor & increment by 2 to calculate the required
			   ending coordinate */
			Ereq = (Es & int_mask) + (one << 1);

			/* calculate initial phase */

#ifdef ADJUST_IP

			IP64 = Osprime - Oreq;
			delta = ((int64) (org) << PQF_PLUS_4) - Oreq;
			IP64 -= delta;

			/* limit to valid range before the left shift */
			delta = (IP64 & (1LL << 63)) ? 4 : -4;
			delta <<= PQF_PLUS_4;
			while (abs((int)(IP64 >> PQF_PLUS_4)) > 4)
				IP64 += delta;

			/* right shift to account for extra bits of precision */
			init_phase = (int)(IP64 >> 4);

#else /* ADJUST_IP */

			/* just calculate the real initial phase */
			init_phase = (int)((Osprime - Oreq) >> 4);

#endif /* ADJUST_IP */

			/* calculate the overfetch */
			beg_of = org - (uint32) (Oreq >> PQF_PLUS_4);
			end_of =
			    (uint32) (Ereq >> PQF_PLUS_4) - (org + dim_in - 1);
		}
	}

	/* return the scale parameters */
	*phase_init_ptr = init_phase;
	*phase_step_ptr = (uint32) (k1 >> 4);
	*num_repl_beg_ptr = beg_of;
	*num_repl_end_ptr = end_of;

	return 0;
}

static uint8 *mdp_adjust_rot_addr(MDPIBUF *iBuf, uint8 *addr, uint32 uv)
{
	uint32 dest_ystride = iBuf->ibuf_width * iBuf->bpp;
	uint32 h_slice = 1;

	if (uv && ((iBuf->ibuf_type == MDP_Y_CBCR_H2V2) ||
		(iBuf->ibuf_type == MDP_Y_CRCB_H2V2)))
		h_slice = 2;

	if (MDP_CHKBIT(iBuf->mdpImg.mdpOp, MDPOP_ROT90) ^
	    MDP_CHKBIT(iBuf->mdpImg.mdpOp, MDPOP_LR)) {
		addr =
		    addr + (iBuf->roi.dst_width -
			    MIN(16, iBuf->roi.dst_width)) * iBuf->bpp;
	}
	if (MDP_CHKBIT(iBuf->mdpImg.mdpOp, MDPOP_UD)) {
		addr =
		    addr + ((iBuf->roi.dst_height -
			MIN(16, iBuf->roi.dst_height))/h_slice) * dest_ystride;
	}

	return addr;
}

void mdp_set_scale(MDPIBUF *iBuf,
		   uint32 dst_roi_width,
		   uint32 dst_roi_height,
		   boolean inputRGB, boolean outputRGB, uint32 *pppop_reg_ptr)
{
	uint32 dst_roi_width_scale;
	uint32 dst_roi_height_scale;
	boolean use_pr;
	uint32 phasex_step = 0;
	uint32 phasey_step = 0;
	int32 phasex_init = 0;
	int32 phasey_init = 0;
	uint32 lines_dup = 0;
	uint32 lines_dup_bg = 0;
	uint32 dummy;
	uint32 mdp_blur = 0;

	if (iBuf->mdpImg.mdpOp & MDPOP_ASCALE) {
		if (iBuf->mdpImg.mdpOp & MDPOP_ROT90) {
			dst_roi_width_scale = dst_roi_height;
			dst_roi_height_scale = dst_roi_width;
		} else {
			dst_roi_width_scale = dst_roi_width;
			dst_roi_height_scale = dst_roi_height;
		}

		mdp_blur = iBuf->mdpImg.mdpOp & MDPOP_BLUR;

		if ((dst_roi_width_scale != iBuf->roi.width) ||
		    (dst_roi_height_scale != iBuf->roi.height) ||
			mdp_blur) {
			*pppop_reg_ptr |=
			    (PPP_OP_SCALE_Y_ON | PPP_OP_SCALE_X_ON);

		/* let's use SHIM logic to calculate the partial ROI scaling */
#if 0
			phasex_step =
			    (uint32) mdp_do_div(0x20000000 * iBuf->roi.width,
						dst_roi_width_scale);
			phasey_step =
			    (uint32) mdp_do_div(0x20000000 * iBuf->roi.height,
						dst_roi_height_scale);

/*
    phasex_step= ((long long) iBuf->roi.width * 0x20000000)/dst_roi_width_scale;
    phasey_step= ((long long)iBuf->roi.height * 0x20000000)/dst_roi_height_scale;
*/

			phasex_init =
			    (((long long)phasex_step - 0x20000000) >> 1);
			phasey_init =
			    (((long long)phasey_step - 0x20000000) >> 1);

#else
			mdp_calc_scale_params(iBuf->roi.x, iBuf->roi.width,
					      dst_roi_width_scale, 1,
					      &phasex_init, &phasex_step,
					      &dummy, &dummy);
			mdp_calc_scale_params(iBuf->roi.y, iBuf->roi.height,
					      dst_roi_height_scale, 0,
					      &phasey_init, &phasey_step,
					      &dummy, &dummy);
#endif
			MDP_OUTP(MDP_CMD_DEBUG_ACCESS_BASE + 0x013c,
				 phasex_init);
			MDP_OUTP(MDP_CMD_DEBUG_ACCESS_BASE + 0x0140,
				 phasey_init);
			MDP_OUTP(MDP_CMD_DEBUG_ACCESS_BASE + 0x0144,
				 phasex_step);
			MDP_OUTP(MDP_CMD_DEBUG_ACCESS_BASE + 0x0148,
				 phasey_step);

			/* disable the pixel repeat option for scaling */
			use_pr = false;

			if ((dst_roi_width_scale > iBuf->roi.width) ||
			    (dst_roi_height_scale > iBuf->roi.height)) {
				if ((use_pr)
				    && (mdp_curr_up_scale_xy !=
					MDP_PR_SCALE_UP)) {
					mdp_load_pr_upscale_table();
					mdp_curr_up_scale_xy = MDP_PR_SCALE_UP;
				} else if ((!use_pr)
					   && (mdp_curr_up_scale_xy !=
					       MDP_BC_SCALE_UP)) {
					mdp_load_bc_upscale_table();
					mdp_curr_up_scale_xy = MDP_BC_SCALE_UP;
				}
			}

			if (mdp_blur) {
				load_scale_table(mdp_gaussian_blur_table,
					ARRAY_SIZE(mdp_gaussian_blur_table));
				mdp_curr_down_scale_x = MDP_SCALE_BLUR;
				mdp_curr_down_scale_y = MDP_SCALE_BLUR;
			}

			/* 0.2 < x <= 1 scaling factor */
			if ((dst_roi_width_scale <= iBuf->roi.width) &&
				!mdp_blur) {
				if (((dst_roi_width_scale * 10) /
				     iBuf->roi.width) > 8) {
					if ((use_pr)
					    && (mdp_curr_down_scale_x !=
						MDP_PR_SCALE_POINT8_1)) {
						mdp_load_pr_downscale_table_x_point8TO1
						    ();
						mdp_curr_down_scale_x =
						    MDP_PR_SCALE_POINT8_1;
					} else if ((!use_pr)
						   && (mdp_curr_down_scale_x !=
						       MDP_BC_SCALE_POINT8_1)) {
						mdp_load_bc_downscale_table_x_point8TO1
						    ();
						mdp_curr_down_scale_x =
						    MDP_BC_SCALE_POINT8_1;
					}
				} else
				    if (((dst_roi_width_scale * 10) /
					 iBuf->roi.width) > 6) {
					if ((use_pr)
					    && (mdp_curr_down_scale_x !=
						MDP_PR_SCALE_POINT6_POINT8)) {
						mdp_load_pr_downscale_table_x_point6TOpoint8
						    ();
						mdp_curr_down_scale_x =
						    MDP_PR_SCALE_POINT6_POINT8;
					} else if ((!use_pr)
						   && (mdp_curr_down_scale_x !=
						       MDP_BC_SCALE_POINT6_POINT8))
					{
						mdp_load_bc_downscale_table_x_point6TOpoint8
						    ();
						mdp_curr_down_scale_x =
						    MDP_BC_SCALE_POINT6_POINT8;
					}
				} else
				    if (((dst_roi_width_scale * 10) /
					 iBuf->roi.width) > 4) {
					if ((use_pr)
					    && (mdp_curr_down_scale_x !=
						MDP_PR_SCALE_POINT4_POINT6)) {
						mdp_load_pr_downscale_table_x_point4TOpoint6
						    ();
						mdp_curr_down_scale_x =
						    MDP_PR_SCALE_POINT4_POINT6;
					} else if ((!use_pr)
						   && (mdp_curr_down_scale_x !=
						       MDP_BC_SCALE_POINT4_POINT6))
					{
						mdp_load_bc_downscale_table_x_point4TOpoint6
						    ();
						mdp_curr_down_scale_x =
						    MDP_BC_SCALE_POINT4_POINT6;
					}
				} else {
					if ((use_pr)
					    && (mdp_curr_down_scale_x !=
						MDP_PR_SCALE_POINT2_POINT4)) {
						mdp_load_pr_downscale_table_x_point2TOpoint4
						    ();
						mdp_curr_down_scale_x =
						    MDP_PR_SCALE_POINT2_POINT4;
					} else if ((!use_pr)
						   && (mdp_curr_down_scale_x !=
						       MDP_BC_SCALE_POINT2_POINT4))
					{
						mdp_load_bc_downscale_table_x_point2TOpoint4
						    ();
						mdp_curr_down_scale_x =
						    MDP_BC_SCALE_POINT2_POINT4;
					}
				}
			}
			/* 0.2 < y <= 1 scaling factor */
			if ((dst_roi_height_scale <= iBuf->roi.height) &&
				!mdp_blur) {
				if (((dst_roi_height_scale * 10) /
				     iBuf->roi.height) > 8) {
					if ((use_pr)
					    && (mdp_curr_down_scale_y !=
						MDP_PR_SCALE_POINT8_1)) {
						mdp_load_pr_downscale_table_y_point8TO1
						    ();
						mdp_curr_down_scale_y =
						    MDP_PR_SCALE_POINT8_1;
					} else if ((!use_pr)
						   && (mdp_curr_down_scale_y !=
						       MDP_BC_SCALE_POINT8_1)) {
						mdp_load_bc_downscale_table_y_point8TO1
						    ();
						mdp_curr_down_scale_y =
						    MDP_BC_SCALE_POINT8_1;
					}
				} else
				    if (((dst_roi_height_scale * 10) /
					 iBuf->roi.height) > 6) {
					if ((use_pr)
					    && (mdp_curr_down_scale_y !=
						MDP_PR_SCALE_POINT6_POINT8)) {
						mdp_load_pr_downscale_table_y_point6TOpoint8
						    ();
						mdp_curr_down_scale_y =
						    MDP_PR_SCALE_POINT6_POINT8;
					} else if ((!use_pr)
						   && (mdp_curr_down_scale_y !=
						       MDP_BC_SCALE_POINT6_POINT8))
					{
						mdp_load_bc_downscale_table_y_point6TOpoint8
						    ();
						mdp_curr_down_scale_y =
						    MDP_BC_SCALE_POINT6_POINT8;
					}
				} else
				    if (((dst_roi_height_scale * 10) /
					 iBuf->roi.height) > 4) {
					if ((use_pr)
					    && (mdp_curr_down_scale_y !=
						MDP_PR_SCALE_POINT4_POINT6)) {
						mdp_load_pr_downscale_table_y_point4TOpoint6
						    ();
						mdp_curr_down_scale_y =
						    MDP_PR_SCALE_POINT4_POINT6;
					} else if ((!use_pr)
						   && (mdp_curr_down_scale_y !=
						       MDP_BC_SCALE_POINT4_POINT6))
					{
						mdp_load_bc_downscale_table_y_point4TOpoint6
						    ();
						mdp_curr_down_scale_y =
						    MDP_BC_SCALE_POINT4_POINT6;
					}
				} else {
					if ((use_pr)
					    && (mdp_curr_down_scale_y !=
						MDP_PR_SCALE_POINT2_POINT4)) {
						mdp_load_pr_downscale_table_y_point2TOpoint4
						    ();
						mdp_curr_down_scale_y =
						    MDP_PR_SCALE_POINT2_POINT4;
					} else if ((!use_pr)
						   && (mdp_curr_down_scale_y !=
						       MDP_BC_SCALE_POINT2_POINT4))
					{
						mdp_load_bc_downscale_table_y_point2TOpoint4
						    ();
						mdp_curr_down_scale_y =
						    MDP_BC_SCALE_POINT2_POINT4;
					}
				}
			}
		} else {
			iBuf->mdpImg.mdpOp &= ~(MDPOP_ASCALE);
		}
	}
	/* setting edge condition here after scaling check */
	if (mdp_get_edge_cond(iBuf, &lines_dup, &lines_dup_bg))
		printk(KERN_ERR "msm_fb: mdp_get_edge_cond() error!\n");

	MDP_OUTP(MDP_CMD_DEBUG_ACCESS_BASE + 0x01b8, lines_dup);
	MDP_OUTP(MDP_CMD_DEBUG_ACCESS_BASE + 0x01bc, lines_dup_bg);
}

void mdp_init_scale_table(void)
{
	mdp_curr_up_scale_xy = MDP_INIT_SCALE;
	mdp_curr_down_scale_x = MDP_INIT_SCALE;
	mdp_curr_down_scale_y = MDP_INIT_SCALE;
}

void mdp_adjust_start_addr(uint8 **src0,
			   uint8 **src1,
			   int v_slice,
			   int h_slice,
			   int x,
			   int y,
			   uint32 width,
			   uint32 height, int bpp, MDPIBUF *iBuf, int layer)
{
	*src0 += (x + y * width) * bpp;

	/* if it's dest/bg buffer, we need to adjust it for rotation */
	if (layer != 0)
		*src0 = mdp_adjust_rot_addr(iBuf, *src0, 0);

	if (*src1) {
		/*
		 * MDP_Y_CBCR_H2V2/MDP_Y_CRCB_H2V2 cosite for now
		 * we need to shift x direction same as y dir for offsite
		 */
		*src1 +=
		    ((x / h_slice) * h_slice +
		     ((y == 0) ? 0 : ((y + 1) / v_slice - 1) * width)) * bpp;

		/* if it's dest/bg buffer, we need to adjust it for rotation */
		if (layer != 0)
			*src1 = mdp_adjust_rot_addr(iBuf, *src1, 1);
	}
}

void mdp_set_blend_attr(MDPIBUF *iBuf,
			uint32 *alpha,
			uint32 *tpVal,
			uint32 perPixelAlpha, uint32 *pppop_reg_ptr)
{
	if (perPixelAlpha) {
		*pppop_reg_ptr |= PPP_OP_ROT_ON |
		    PPP_OP_BLEND_ON | PPP_OP_BLEND_SRCPIXEL_ALPHA;
	} else {
		if ((iBuf->mdpImg.mdpOp & MDPOP_ALPHAB)
		    && (iBuf->mdpImg.alpha == 0xff)) {
			iBuf->mdpImg.mdpOp &= ~(MDPOP_ALPHAB);
		}

		if ((iBuf->mdpImg.mdpOp & MDPOP_ALPHAB)
		    && (iBuf->mdpImg.mdpOp & MDPOP_TRANSP)) {
			*pppop_reg_ptr |=
			    PPP_OP_ROT_ON | PPP_OP_BLEND_ON |
			    PPP_OP_BLEND_CONSTANT_ALPHA |
			    PPP_OP_BLEND_ALPHA_BLEND_NORMAL |
			    PPP_BLEND_CALPHA_TRNASP;

			*alpha = iBuf->mdpImg.alpha;
			*tpVal = iBuf->mdpImg.tpVal;
		} else {
			if (iBuf->mdpImg.mdpOp & MDPOP_TRANSP) {
				*pppop_reg_ptr |= PPP_OP_ROT_ON |
				    PPP_OP_BLEND_ON |
				    PPP_OP_BLEND_SRCPIXEL_TRANSP;
				*tpVal = iBuf->mdpImg.tpVal;
			} else if (iBuf->mdpImg.mdpOp & MDPOP_ALPHAB) {
				*pppop_reg_ptr |= PPP_OP_ROT_ON |
				    PPP_OP_BLEND_ON |
				    PPP_OP_BLEND_ALPHA_BLEND_NORMAL |
				    PPP_OP_BLEND_CONSTANT_ALPHA;
				*alpha = iBuf->mdpImg.alpha;
			}
		}
	}
}
