/* arch/arm/mach-msm/panel_id.h
 * Copyright (C) 2010 HTC Corporation.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#ifndef __PANEL_ID_H
#define __PANEL_ID_H

extern int panel_type;


#define BL_SHIFT        16
#define BL_MASK         (0x7 << BL_SHIFT)

#define BL_SPI          (0 << BL_SHIFT)
#define BL_MDDI         (1 << BL_SHIFT)
#define BL_I2C          (2 << BL_SHIFT)
#define BL_UP           (3 << BL_SHIFT)
#define BL_MIPI         (4 << BL_SHIFT)
#define BL_PMIC         (5 << BL_SHIFT)

#define IF_SHIFT        19
#define IF_MASK         (0x7 << IF_SHIFT)

#define IF_LCDC         (0 << IF_SHIFT)
#define IF_MDDI         (1 << IF_SHIFT)
#define IF_MIPI         (2 << IF_SHIFT)

#define DEPTH_SHIFT     22
#define DEPTH_MASK      (0x7 << DEPTH_SHIFT)

#define DEPTH_RGB565    (0 << DEPTH_SHIFT)
#define DEPTH_RGB666    (1 << DEPTH_SHIFT)
#define DEPTH_RGB888    (2 << DEPTH_SHIFT)


#define REV_SHIFT       25
#define REV_MASK        (0x7 << REV_SHIFT)

#define REV_0           (0 << REV_SHIFT)
#define REV_1           (1 << REV_SHIFT)
#define REV_2           (2 << REV_SHIFT)
#define REV_3           (3 << REV_SHIFT)
#define REV_4		(4 << REV_SHIFT)

#define MIPI_MODE_SHIFT	28
#define MIPI_MODE_MASK	(0x3 << MIPI_MODE_SHIFT)

#define MIPI_CMD		(0 << MIPI_MODE_SHIFT)
#define MIPI_VIDEO_ONLY	(1 << MIPI_MODE_SHIFT)

#define PANEL_ID_NONE		(0x0)

#define PANEL_ID_START          0x0F

#define PANEL_ID_SAG_SONY      (0x10 | BL_SPI	| IF_LCDC | DEPTH_RGB666)
#define PANEL_ID_SPADE_AUO_N90      	(0x11 | BL_UP | IF_LCDC | DEPTH_RGB888)
#define PANEL_ID_SPADE_SHA_N90      	(0x12 | BL_UP | IF_LCDC | DEPTH_RGB888)
#define PANEL_ID_SAG_HITACHI   (0x13 | BL_MDDI | IF_MDDI | DEPTH_RGB666)
#define PANEL_ID_ICN_SHARP	(0x14 | BL_MDDI | IF_MDDI | DEPTH_RGB666)
#define PANEL_ID_FLR_SMD_XC	(0x15 | BL_UP	| IF_LCDC | DEPTH_RGB888)
#define PANEL_ID_ICN_TPO	(0x16 | BL_MDDI | IF_MDDI | DEPTH_RGB666)
#define PANEL_ID_VIVOW_HITACHI	(0x17 | BL_MDDI | IF_MDDI | DEPTH_RGB666)
#define PANEL_ID_BLS_HITACHI	(0x17 | BL_MDDI | IF_MDDI | DEPTH_RGB666)
#define PANEL_ID_BLSC_HITACHI	(0x17 | BL_MDDI | IF_MDDI | DEPTH_RGB666)
#define PANEL_ID_FLR_LG_XC	(0x18 | BL_UP	| IF_LCDC | DEPTH_RGB888)

#define PANEL_ID_PYD_SHARP_WVGA	(0x20 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_PYD_SHARP	(0x21 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_PYD_AUO_NT	(0x22 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_PYD_AUO_OTM	(0x22 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_DOT_SONY	(0x24 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_DOT_SONY_C3	(0x24 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_DOT_HITACHI	(0x25 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_SHR_SHARP_NT	(0x26 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_EXP_SMD	(0x27 | BL_UP	| IF_LCDC | DEPTH_RGB888)
#define PANEL_ID_EXP_LG	(0x28 | BL_UP	| IF_LCDC | DEPTH_RGB888)
#define PANEL_ID_VERDI_AUO	(0x29 | BL_PMIC | IF_LCDC | DEPTH_RGB666)
#define PANEL_ID_VERDI_AUO_RGB888	(0x29 | BL_PMIC | IF_LCDC | DEPTH_RGB888)
#define PANEL_ID_VERDI_SAMSUNG	(0x2A | BL_PMIC | IF_LCDC | DEPTH_RGB888)
#define PANEL_ID_KIM_SONY	(0x2B | BL_MDDI | IF_MDDI | DEPTH_RGB888)
#define PANEL_ID_KIM_SONY_C2	(0x2B | BL_MDDI | IF_MDDI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_RIR_SHARP_NT (0x2C | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_SHR_SHARP_OTM (0x2D | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_SHR_SHARP_OTM_C2 (0x2D | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_RIR_AUO_OTM (0x2E | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_RIR_AUO_OTM_C2 (0x2E | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_RIR_AUO_OTM_C3 (0x2E | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_HOY_SONY_OTM (0x2F | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_EXP_LG_WS2	(0x30 | BL_UP	| IF_LCDC | DEPTH_RGB888)
#define PANEL_ID_RIR_SHARP_OTM (0x31 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_RIR_AUO_NT (0x32 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_RUBY_SHARP (0x33 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_KIM_SAMSUNG	(0x36 | BL_MDDI | IF_MDDI | DEPTH_RGB888)
#define PANEL_ID_BLS_SONY	(0x37 | BL_MDDI | IF_MDDI | DEPTH_RGB888)
#define PANEL_ID_BLSC_SONY	(0x37 | BL_MDDI | IF_MDDI | DEPTH_RGB888)
#define PANEL_ID_RUY_SHARP_NT	(0X38 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_RUY_SHARP_NT_C2 (0X38 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_RUY_SHARP_NT_C2O (0X38 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_VIG_SHARP_HX	(0x39 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_VIG_SHARP_HX_C2	(0x39 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_VIG_SHARP_HX_C25	(0x39 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_VIG_SHARP_HX_C3	(0x39 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_3)
#define PANEL_ID_RUE_SONY_NT	(0x3A | BL_MDDI | IF_MDDI | DEPTH_RGB888)
#define PANEL_ID_VIG_CHIMEI_HX	(0x3B | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_VIG_CHIMEI_HX_C25	(0x3B | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_VIG_CHIMEI_HX_C3	(0x3B | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_TAGH_HITACHI	(0x40 | BL_MDDI | IF_MDDI | DEPTH_RGB666)
#define PANEL_ID_TAGH_HITACHI_LT	(0x40 | BL_MDDI | IF_MDDI | DEPTH_RGB666 | REV_1)
#define PANEL_ID_FIGHTER_SAMSUNG_NT	(0x44 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_FIGHTER_SAMSUNG_NT_C2	(0x44 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_FIGHTER_SAMSUNG_NT_C3	(0x44 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_FIGHTER_SONY_OTM (0x45 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_FIGHTER_SONY_OTM_C1_1 (0x45 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_FIGHTER_SONY_OTM_MP (0x45 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_FIGHTER_LG_NT (0x46 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_FIGHTER_LG_NT_C2 (0x46 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_FIGHTER_LG_NT_MP (0x46 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_VILLE_SAMSUNG_SG (0x43 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_VILLE_SAMSUNG_SG_C2 (0x43 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_ELITE_SONY_NT (0x47 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_ELITE_SONY_NT_C1 (0x47 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_ELITE_SONY_NT_C2 (0x47 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_ELITE_SHARP_HX (0x48 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_TAI_HITACHI_NT (0x49 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_TAI_HITACHI_NT_C1 (0x49 | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_JET_SONY_NT (0x4B | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_JET_SONY_NT_C1 (0x4B | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_JET_SONY_NT_C2 (0x4B | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_JET_AUO_NT    (0x4C | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_JET_AUO_NT_C2    (0x4C | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_JET_AUO_NT_C3    (0x4C | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_3)
#define PANEL_ID_JET_AUO_NT_C3_1    (0x4C | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_4)
#define PANEL_ID_VALENTE_SAMSUNG_SG (0x4D | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_VALENTE_SAMSUNG_SG_C2 (0x4D | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_VALENTE_SAMSUNG_SG_C3 (0x4D | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_ELITE_SHARP_NT (0x4E | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_ELITE_SHARP_NT_C1 (0x4E | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_1)
#define PANEL_ID_ELITE_SHARP_NT_C2 (0x4E | BL_MIPI | IF_MIPI | DEPTH_RGB888 | REV_2)
#define PANEL_ID_VILLE_AUO (0x53 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_DLX_SHARP_RENESAS  (0x5B | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_DLX_SONY_RENESAS  (0x5C | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_K2_WL_AUO (0x5D | BL_MIPI | IF_MIPI | DEPTH_RGB888 | MIPI_VIDEO_ONLY)
#define PANEL_ID_OPA_SHARP_HX  (0x5E | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_IMN_SHARP_HX (0x60 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_DLXJ_SHARP_RENESAS  (0x63 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_DLXJ_SONY_RENESAS  (0x64 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_M7_JDI_SAMSUNG  (0x65 | BL_MIPI | IF_MIPI | DEPTH_RGB888)
#define PANEL_ID_M7_SHARP_NT  (0x66 | BL_MIPI | IF_MIPI | DEPTH_RGB888)

#define PANEL_ID_END            0xFFFF

#endif	

