/*
 * Copyright (c) 2012, Code Aurora Forum. All rights reserved.
 *
 * Previously licensed under the ISC license by Qualcomm Atheros, Inc.
 *
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#if !defined( BAP_HDD_MAIN_H )
#define BAP_HDD_MAIN_H

/**===========================================================================
  
  \file  BAP_HDD_MAIN_H.h
  
  \brief Linux HDD Adapter Type
         Copyright 2008 (c) Qualcomm, Incorporated.
         All Rights Reserved.
         Qualcomm Confidential and Proprietary.
  
  ==========================================================================*/
  
/*--------------------------------------------------------------------------- 
  Include files
  -------------------------------------------------------------------------*/ 
  
#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include <vos_list.h>
#include <vos_types.h>

/*----------------------------------------------------------------------------
 * Preprocessor Definitions and Constants
 * -------------------------------------------------------------------------*/
#define BSL_MAX_CLIENTS               1
#define BSL_MAX_PHY_LINK_PER_CLIENT   1

/*--------------------------------------------------------------------------- 
  Function declarations and documenation
  -------------------------------------------------------------------------*/ 

/**---------------------------------------------------------------------------
  
  \brief BSL_Init() - Initialize the BSL Misc char driver
  
  This is called in by WLANBAP_Open() as part of bringing up the BT-AMP PAL (BAP)
  WLANBAP_Open() will pass in the device context created.
  
  \param  - NA
  
  \return - 0 for success non-zero for failure
              
  --------------------------------------------------------------------------*/
int BSL_Init (void *pCtx);

/**---------------------------------------------------------------------------
  
  \brief BSL_Deinit() - De-initialize the BSL Misc char driver
  
  This is called in by WLANBAP_Close() as part of bringing down the BT-AMP PAL (BAP)
  
  \param  - NA
  
  \return - 0 for success non-zero for failure
              
  --------------------------------------------------------------------------*/

int BSL_Deinit(void *pCtx);



#endif    // end #if !defined( BAP_HDD_MAIN_H )
