/*
 * Copyright (c) 2012, Code Aurora Forum. All rights reserved.
 *
 * Previously licensed under the ISC license by Qualcomm Atheros, Inc.
 *
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/**
  */

/**
  * \file dot11f.c
  *
  * \brief Structures, functions & definitions for
  * working with 802.11 Frames
  *
  *
  * Copyright (C) 2012 Airgo Networks, Incorporated.
  *
  *
  * This file was automatically generated by 'framesc'
  * Tue May 15 13:12:01 2012 from the following file(s):
  *
  * dot11f.frms
  * 
  * PLEASE DON'T EDIT THIS FILE BY HAND!
  *
  *
  */

#if !defined  ANI_OS_TYPE_OSX && !defined ANI_OS_TYPE_LINUX && !defined ANI_OS_TYPE_ANDROID
#include <memory.h> /* For memcpy */
#include <stdio.h>  /* For _vsnprintf */
#include <stddef.h> /* For offsetof */
#endif

#include <aniGlobal.h>
#include <utilsApi.h>
#include "dot11fdefs.h"
#include "dot11f.h"

#if defined ( _MSC_VER )
#   pragma warning (disable: 4244)
#   pragma warning (disable: 4505)
#   pragma warning (disable: 4702)
#   pragma warning (disable: 4996) /* ... was declared deprecated */
#endif /* Microsoft C/C++ */

typedef unsigned char tFRAMES_BOOL;
typedef void (*pfnGeneric_t)(void);

typedef struct sFFDefn {
    const char  *name;
    tANI_U32 offset;
    tANI_U16 sig;
    tANI_U8  size;
} tFFDefn;

typedef struct sIEDefn {
    tANI_U32  offset;
    tANI_U32  presenceOffset;
    tANI_U32  countOffset;
    const char   *name;
    tANI_U16  arraybound;
    tANI_U16  minSize;
    tANI_U16  maxSize;
    tANI_U16  sig;
    unsigned char oui[5];
    unsigned char noui;
    tANI_U8   eid;
    tFRAMES_BOOL  fMandatory;
} tIEDefn;

#if !defined(countof)
#define countof(x) ( sizeof( (x) ) / sizeof( (x)[0] ) )
#endif

#if ! defined(DOT11F_MEMCPY)
#   define DOT11F_MEMCPY(ctx, dst, src, len) \
        memcpy( (dst), (src), (len) )        \

#endif

#if ! defined(DOT11F_MEMCMP)
#   define DOT11F_MEMCMP(ctx, lhs, rhs, len) \
        memcmp( (lhs), (rhs), (len) )        \

#endif

#ifndef DOT11F_HAVE_LOG_SEVERITIES
#   define FRLOG_OFF ( 0 )
#   define FRLOGP    ( 1 )
#   define FRLOGE    ( 2 )
#   define FRLOGW    ( 3 )
#   define FRLOG1    ( 4 )
#   define FRLOG2    ( 5 )
#   define FRLOG3    ( 6 )
#   define FRLOG4    ( 7 )
#endif

#define FRFL(x) x

#ifdef DOT11F_ENABLE_LOGGING

#ifndef DOT11F_HAVE_LOG_MACROS

#include <stdio.h>
#include <stdarg.h>

#ifndef DOT11F_LOG_GATE
#   define DOT11F_LOG_GATE FRLOGW
#endif // DOT11F_LOG_GATE

#ifdef WIN32

#if defined ( _CONSOLE ) || defined ( _WINDOWS ) || defined ( _DLL ) || defined ( _LIB )
#include <windows.h>
#define DBGPRINT OutputDebugStringA
#else  /* Not User mode */
#define DBGPRINT DbgPrint
#endif /* User mode */

static void framesLog(tpAniSirGlobal pCtx, int nSev,
                      const char *lpszFormat, ...)
{
#ifdef WLAN_DEBUG
    va_list val;
    char buffer[1024];
    (void)pCtx;
    if ( nSev <= DOT11F_LOG_GATE )
    {
        va_start(val, lpszFormat);
        _vsnprintf(buffer, 1024, lpszFormat, val);
        va_end(val);
        DBGPRINT(buffer);
    }
#endif
}
static void framesDump(tpAniSirGlobal pCtx, int nSev, tANI_U8 *pBuf, int nBuf)
{
#ifdef WLAN_DEBUG
    char buffer[35];
    int i, offset;
    pCtx;
    offset = 0;
    if ( nSev > DOT11F_LOG_GATE ) return;
    for (i = 0; i < nBuf/8; ++i)
    {
        _snprintf(buffer, 35, "%08x: %02x %02x %02x %02x %02x %02x %02x %02x\n", offset, *pBuf, *(pBuf + 1), *(pBuf + 2), *(pBuf + 3), *(pBuf + 4), *(pBuf + 5), *(pBuf + 6), *(pBuf + 7));
        pBuf += 8; offset += 8;
        DBGPRINT(buffer);
    }
    _snprintf(buffer, 35, "%08x: ", offset);
    DBGPRINT(buffer);
    for (i = 0; i < nBuf % 8; ++i)
    {
        _snprintf(buffer, 35, "%02x ", *pBuf);
        ++pBuf;
        DBGPRINT(buffer);
    }
    DBGPRINT("\n");
#endif
}

#elif defined OS_X /* Not WIN32 */
static void framesLog(tpAniSirGlobal pCtx, int nSev,
                      const char *lpszFormat, ...)
{// To fill in when needed using IOLog

}

static void framesDump(tpAniSirGlobal pCtx, int nSev, tANI_U8 *pBuf, int nBuf)
{
}

#elif defined LINUX

static void framesLog(tpAniSirGlobal pCtx, int nSev,
                      const char *lpszFormat, ...)
{
#ifdef WLAN_DEBUG
    va_list marker;
    (void)pCtx;
    if ( nSev <= DOT11F_LOG_GATE )
    {
        va_start( marker, lpszFormat );
        vprintf(lpszFormat, marker);
        va_end( marker );
    }
#endif
}

static void framesDump(tpAniSirGlobal pCtx, int nSev, tANI_U8 *pBuf, int nBuf)
{
#ifdef WLAN_DEBUG
    char buffer[35];
    int i, offset;
    (void)pCtx;
    offset = 0;
    if ( nSev > DOT11F_LOG_GATE ) return;
    for (i = 0; i < nBuf/8; ++i)
    {
        printf("%08x: %02x %02x %02x %02x %02x %02x %02x %02x\n", offset, *pBuf, *(pBuf + 1), *(pBuf + 2), *(pBuf + 3), *(pBuf + 4), *(pBuf + 5), *(pBuf + 6), *(pBuf + 7));
        pBuf += 8; offset += 8;
    }
    printf("%08x: ", offset);
    for (i = 0; i < nBuf % 8; ++i)
    {
        printf("%02x ", *pBuf);
        ++pBuf;
    }
    printf("\n");
#endif
}

#endif /* WIN32 */

#define FRAMES_LOG0(ctx, sev, fmt) \
     framesLog((ctx), (sev), (fmt));
#define FRAMES_LOG1(ctx, sev, fmt, p1) \
     framesLog((ctx), (sev), (fmt), (p1));
#define FRAMES_LOG2(ctx, sev, fmt, p1, p2) \
     framesLog((ctx), (sev), (fmt), (p1), (p2));
#define FRAMES_LOG3(ctx, sev, fmt, p1, p2, p3) \
     framesLog((ctx), (sev), (fmt), (p1), (p2), (p3));
#define FRAMES_DUMP(ctx, sev, p, n) \
     framesDump((ctx), (sev), (p), (n));
#ifndef FRAMES_SEV_FOR_FRAME
#   define FRAMES_SEV_FOR_FRAME(ctx, sig) FRLOG3
#endif

#endif /* End DOT11F_HAVE_LOG_MACROS */

#else  // ! DOT11F_ENABLE_LOGGING
#   define FRAMES_LOG0(ctx, sev, fmt)
#   define FRAMES_LOG1(ctx, sev, fmt, p1)
#   define FRAMES_LOG2(ctx, sev, fmt, p1, p2)
#   define FRAMES_LOG3(ctx, sev, fmt, p1, p2, p3)
#   define FRAMES_DUMP(ctx, sev, p, n)
#   ifndef FRAMES_SEV_FOR_FRAME
#       define FRAMES_SEV_FOR_FRAME(ctx, sig) FRLOG3
#   endif
#endif // DOT11F_ENABLE_LOGGING

#if defined( DOT11F_ENABLE_DBG_BREAK ) && defined ( WIN32 )
#   define FRAMES_DBG_BREAK() { _asm int 3 }
#else
#   define FRAMES_DBG_BREAK()
#endif

#if ! defined(DOT11F_PARAMETER_CHECK)
#   if defined (DOT11F_HAVE_WIN32_API)

#       define DOT11F_PARAMETER_CHECK(pBuf, nBuf, pFrm, nFrm) \
        if (!pBuf || IsBadReadPtr(pBuf, nBuf)) return DOT11F_BAD_INPUT_BUFFER; \
        if (!pFrm || IsBadWritePtr(pFrm, nFrm)) return DOT11F_BAD_OUTPUT_BUFFER \

#       define DOT11F_PARAMETER_CHECK2(pSrc, pBuf, nBuf, pnConsumed) \
        if (!pSrc || IsBadReadPtr(pSrc, 4)) return DOT11F_BAD_INPUT_BUFFER; \
        if (!pBuf || IsBadWritePtr(pBuf, nBuf)) return DOT11F_BAD_OUTPUT_BUFFER; \
        if (!nBuf) return DOT11F_BAD_OUTPUT_BUFFER; \
        if (IsBadWritePtr(pnConsumed, 4)) return DOT11F_BAD_OUTPUT_BUFFER \

#   else

#       define DOT11F_PARAMETER_CHECK(pBuf, nBuf, pFrm, nFrm) \
        if (!pBuf) return DOT11F_BAD_INPUT_BUFFER; \
        if (!pFrm) return DOT11F_BAD_OUTPUT_BUFFER \

#       define DOT11F_PARAMETER_CHECK2(pSrc, pBuf, nBuf, pnConsumed) \
        if (!pSrc) return DOT11F_BAD_INPUT_BUFFER; \
        if (!pBuf) return DOT11F_BAD_OUTPUT_BUFFER; \
        if (!nBuf) return DOT11F_BAD_OUTPUT_BUFFER; \
        if (!pnConsumed) return DOT11F_BAD_OUTPUT_BUFFER \

#   endif
#endif

static void framesntohs(tpAniSirGlobal    pCtx,
                        tANI_U16 *pOut,
                        tANI_U8  *pIn,
                        tFRAMES_BOOL  fMsb)
{
    (void)pCtx;
#   if defined ( DOT11F_LITTLE_ENDIAN_HOST )
    if ( !fMsb )
    {
        DOT11F_MEMCPY(pCtx, ( tANI_U16* )pOut, pIn, 2);
    }
    else
    {
        *pOut = ( tANI_U16 )( *pIn << 8 ) | *( pIn + 1 );
    }
#   else
    if ( !fMsb )
    {
        *pOut = ( tANI_U16 )( *pIn | ( *( pIn + 1 ) << 8 ) );
    }
    else
    {
        DOT11F_MEMCPY(pCtx, ( tANI_U16* )pOut, pIn, 2);
    }
#   endif
}

static void framesntohl(tpAniSirGlobal    pCtx,
                        tANI_U32 *pOut,
                        tANI_U8  *pIn,
                        tFRAMES_BOOL  fMsb)
{
    (void)pCtx;
#   if defined ( DOT11F_LITTLE_ENDIAN_HOST )
    if ( !fMsb )
    {
        DOT11F_MEMCPY(pCtx, ( tANI_U32* )pOut, pIn, 4);
    }
    else
    {
        *pOut = ( tANI_U32 )( *pIn         << 24 ) |
                ( *( pIn + 1 ) << 16 ) |
                ( *( pIn + 2 ) <<  8 ) |
                ( *( pIn + 3 ) );
    }
#   else
    if ( !fMsb )
    {
        *pOut = ( tANI_U32 )( *( pIn + 3 ) << 24 ) |
                                ( *( pIn + 2 ) << 16 ) |
                                ( *( pIn + 1 ) <<  8 ) |
                                ( *( pIn ) );
    }
    else
    {
        *pOut = * ( tANI_U32* )pIn;
    }
#   endif
}

static void framesntohq(tpAniSirGlobal    pCtx,
                        tDOT11F_U64 *pOut,
                        tANI_U8  *pIn,
                        tFRAMES_BOOL  fMsb)
{
#   if defined ( DOT11F_LITTLE_ENDIAN_HOST )
    framesntohl( pCtx, &((*pOut)[0]), pIn, fMsb);
    framesntohl( pCtx, &((*pOut)[1]), pIn + 4, fMsb);
#   else
    framesntohl( pCtx, &((*pOut)[1]), pIn, fMsb);
    framesntohl( pCtx, &((*pOut)[0]), pIn + 4, fMsb);
#   endif
}

static void frameshtons(tpAniSirGlobal    pCtx
,                        tANI_U8  *pOut,
                        tANI_U16  pIn,
                        tFRAMES_BOOL  fMsb)
{
    (void)pCtx;
#   if defined ( DOT11F_LITTLE_ENDIAN_HOST )
    if ( !fMsb )
    {
        DOT11F_MEMCPY(pCtx, pOut, &pIn, 2);
    }
    else
    {
        *pOut         = ( pIn & 0xff00 ) >> 8;
        *( pOut + 1 ) = pIn & 0xff;
    }
#   else
    if ( !fMsb )
    {
        *pOut         = pIn & 0xff;
        *( pOut + 1 ) = ( pIn & 0xff00 ) >> 8;
    }
    else
    {
        DOT11F_MEMCPY(pCtx, pOut, &pIn, 2);
    }
#   endif
}

static void frameshtonl(tpAniSirGlobal    pCtx,
                        tANI_U8  *pOut,
                        tANI_U32  pIn,
                        tFRAMES_BOOL  fMsb)
{
    (void)pCtx;
#   if defined ( DOT11F_LITTLE_ENDIAN_HOST )
    if ( !fMsb )
    {
        DOT11F_MEMCPY(pCtx, pOut, &pIn, 4);
    }
    else
    {
        *pOut         = ( pIn & 0xff000000 ) >> 24;
        *( pOut + 1 ) = ( pIn & 0x00ff0000 ) >> 16;
        *( pOut + 2 ) = ( pIn & 0x0000ff00 ) >>  8;
        *( pOut + 3 ) = ( pIn & 0x000000ff );
    }
#   else
    if ( !fMsb )
    {
        *( pOut     ) = ( pIn & 0x000000ff );
        *( pOut + 1 ) = ( pIn & 0x0000ff00 ) >>  8;
        *( pOut + 2 ) = ( pIn & 0x00ff0000 ) >> 16;
        *( pOut + 3 ) = ( pIn & 0xff000000 ) >> 24;
    }
    else
    {
        DOT11F_MEMCPY(pCtx, pOut, &pIn, 4);
    }
#   endif
}

static void frameshtonq(tpAniSirGlobal    pCtx,
                        tANI_U8  *pOut,
                        tDOT11F_U64  pIn,
                        tFRAMES_BOOL  fMsb)
{
#   if defined ( DOT11F_LITTLE_ENDIAN_HOST )
    frameshtonl( pCtx, pOut, pIn[0], fMsb);
    frameshtonl( pCtx, pOut + 4, pIn[1], fMsb);
#   else
    frameshtonl( pCtx, pOut + 4, pIn[1], fMsb);
    frameshtonl( pCtx, pOut, pIn[0], fMsb);
#   endif
}
static const tIEDefn* FindIEDefn(tpAniSirGlobal pCtx,
                           tANI_U8 *pBuf,
                           tANI_U32 nBuf,
                           const tIEDefn  IEs[])
{
    const tIEDefn *pIe;

    (void)pCtx;

    pIe = &(IEs[0]);
    while (0xff != pIe->eid)
    {
        if (*pBuf == pIe->eid)
        {
            if (0 == pIe->noui) return pIe;

            if ( ( nBuf > (tANI_U32)(pIe->noui + 2) ) &&
                 ( !DOT11F_MEMCMP(pCtx, pBuf + 2, pIe->oui, pIe->noui) ) )
                return pIe;
        }

        ++pIe;
    }

    return NULL;
}

static tANI_U32 GetContainerIesLen(tpAniSirGlobal pCtx,
                             tANI_U8 *pBuf,
                             tANI_U32  nBuf,
                             tANI_U8 *pnConsumed,
                             const tIEDefn  IEs[])
{
    const tIEDefn *pIe, *pIeFirst;
    tANI_U8 *pBufRemaining = pBuf;
    tANI_U8 len = 0;

    (void)pCtx;

    pIeFirst = &(IEs[0]);

    if( *pBufRemaining != pIeFirst->eid )
         return DOT11F_INTERNAL_ERROR;
    len += *(pBufRemaining+1);
    pBufRemaining += len + 2;
    while ( len < nBuf )
    {
        if( NULL == (pIe =  FindIEDefn(pCtx, pBufRemaining, nBuf + len, IEs)))
             break;
        if( pIe->eid == pIeFirst->eid )
             break;
        len += *(pBufRemaining + 1) + 2;
        pBufRemaining += *(pBufRemaining + 1) + 2;
    }

    *pnConsumed = len;
    return DOT11F_PARSE_SUCCESS;
   
}



static tANI_U32 UnpackCore(tpAniSirGlobal pCtx,
                           tANI_U8 *pBuf,
                           tANI_U32 nBuf,
                           const tFFDefn  FFs[],
                           const tIEDefn  IEs[],
                           tANI_U8 *pFrm,
                           size_t   nFrm);
static tANI_U32 PackCore(tpAniSirGlobal pCtx,
                             tANI_U8 *pSrc,
                             tANI_U8 *pBuf,
                             tANI_U32  nBuf,
                             tANI_U32 *pnConsumed,
                             const tFFDefn  FFs[],
                             const tIEDefn  IEs[]);
static tANI_U32 GetPackedSizeCore(tpAniSirGlobal pCtx,
                                      tANI_U8 *pFrm,
                                      tANI_U32 *pnNeeded,
                                      const tIEDefn  IEs[]);


tANI_U32 dot11fUnpackTlvCommonFunc(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tANI_U8 *pDstPresent, tANI_U8 *pDstField)
{
   tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)tlvlen; /* Shutup the compiler */

    *pDstPresent = 1;
    *pDstField = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvCommonFunc. */

tANI_U32 dot11fUnpackTlvCommonFunc2(tpAniSirGlobal  pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tANI_U8 *pDstPresent, tANI_U16 *pDstState)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)tlvlen; /* Shutup the compiler */

    *pDstPresent = 1;
    framesntohs(pCtx, pDstState, pBuf, 1);
    (void)pCtx;
    return status;

} /* End dot11fUnpackTlvCommonFunc2. */
                                           
void dot11fUnpackFfCommonFunc(tpAniSirGlobal pCtx,
                            tANI_U8 *pBuf, tANI_U16 *pDstField)
{
    framesntohs(pCtx, pDstField, pBuf, 0);
    (void)pCtx;
} /* End dot11fUnpackFfCommonFunc. */

tANI_U32 dot11fUnpackIeCommonFunc(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen,
                                         tANI_U8 *pDstPresent , tANI_U8 *pDstField)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)ielen;
    (void)pBuf; 
    if ((*pDstPresent)) status = DOT11F_DUPLICATE_IE;
    *pDstPresent = 1;
    *pDstField = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeComonFunc. */
typedef struct sTLVDefn {
    tANI_U32   offset;
    tANI_U32   presenceOffset;
    const char *   name;
    tANI_U16   sig;
    tANI_U32   id;
    tANI_U32   pec;
    tANI_U32   minSize;
    tANI_U32   maxSize;
    tANI_U8    fMandatory;
    tANI_U8    sType;
    tANI_U8    sLen;
    tANI_U8    fMsb;
} tTLVDefn;

static const tTLVDefn* FindTLVDefn( tpAniSirGlobal    pCtx,
                              tANI_U8  *pBuf,
                              tANI_U32  nBuf,
                              const tTLVDefn      TLVs[ ] )
{
    const tTLVDefn *pTlv;
    tANI_U32   pec;
    tANI_U16   id;

    pTlv = &( TLVs[ 0 ] );
    (void)pCtx;
    if ( pTlv->sType == 2 )
       framesntohs( pCtx, &id, pBuf, 1 );
    else
       id = *pBuf;

    while ( 0xffff != pTlv->id )
    {
        if ( id == pTlv->id )
        {
            if ( 0 == pTlv->pec ) return pTlv;

            if( nBuf > 5 )
            {
                pec =  ( ( * ( pBuf + 4 ) ) << 16 ) |
                       ( ( * ( pBuf + 5 ) ) <<  8 ) |
                           * ( pBuf + 6 );
                if ( pec == pTlv->pec )
                {
                    return pTlv;
                }
            }
        }

        ++pTlv;
    }

    return NULL;
}

static tANI_U32 UnpackTlvCore( tpAniSirGlobal   pCtx,
                            tANI_U8 *pBuf,
                            tANI_U32 nBuf,
                            const tTLVDefn     TLVs[ ],
                            tANI_U8 *pFrm,
                            size_t       nFrm );
static tANI_U32 PackTlvCore(tpAniSirGlobal pCtx,
                                tANI_U8 *pSrc,
                                tANI_U8 *pBuf,
                                tANI_U32  nBuf,
                                tANI_U32 *pnConsumed,
                                const tTLVDefn  TLVs[],
                                tANI_U32 *pidx);
static tANI_U32 GetPackedSizeTlvCore(tpAniSirGlobal pCtx,
                                         tANI_U8 *pFrm,
                                         tANI_U32 *pnNeeded,
                                         const tTLVDefn  TLVs[]);

#define SigFfAID ( 0x0001 )

void dot11fUnpackFfAction(tpAniSirGlobal pCtx,
                          tANI_U8 *pBuf,
                          tDot11fFfAction *pDst)
{
    pDst->action = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfAction. */

#define SigFfAction ( 0x0002 )

void dot11fUnpackFfAddBAParameterSet(tpAniSirGlobal pCtx,
                                     tANI_U8 *pBuf,
                                     tDot11fFfAddBAParameterSet *pDst)
{
    tANI_U16 tmp0__;
    framesntohs(pCtx, &tmp0__, pBuf, 0);
    pDst->amsduSupported = tmp0__ >> 0 & 0x1;
    pDst->policy = tmp0__ >> 1 & 0x1;
    pDst->tid = tmp0__ >> 2 & 0xf;
    pDst->bufferSize = tmp0__ >> 6 & 0x3ff;
    (void)pCtx;
} /* End dot11fUnpackFfAddBAParameterSet. */

#define SigFfAddBAParameterSet ( 0x0003 )

#define SigFfAuthAlgo ( 0x0004 )

#define SigFfAuthSeqNo ( 0x0005 )

void dot11fUnpackFfBAStartingSequenceControl(tpAniSirGlobal pCtx,
                                             tANI_U8 *pBuf,
                                             tDot11fFfBAStartingSequenceControl *pDst)
{
    tANI_U16 tmp1__;
    framesntohs(pCtx, &tmp1__, pBuf, 0);
    pDst->fragNumber = tmp1__ >> 0 & 0xf;
    pDst->ssn = tmp1__ >> 4 & 0xfff;
    (void)pCtx;
} /* End dot11fUnpackFfBAStartingSequenceControl. */

#define SigFfBAStartingSequenceControl ( 0x0006 )

#define SigFfBATimeout ( 0x0007 )

#define SigFfBeaconInterval ( 0x0008 )

void dot11fUnpackFfCapabilities(tpAniSirGlobal pCtx,
                                tANI_U8 *pBuf,
                                tDot11fFfCapabilities *pDst)
{
    tANI_U16 tmp2__;
    framesntohs(pCtx, &tmp2__, pBuf, 0);
    pDst->ess = tmp2__ >> 0 & 0x1;
    pDst->ibss = tmp2__ >> 1 & 0x1;
    pDst->cfPollable = tmp2__ >> 2 & 0x1;
    pDst->cfPollReq = tmp2__ >> 3 & 0x1;
    pDst->privacy = tmp2__ >> 4 & 0x1;
    pDst->shortPreamble = tmp2__ >> 5 & 0x1;
    pDst->pbcc = tmp2__ >> 6 & 0x1;
    pDst->channelAgility = tmp2__ >> 7 & 0x1;
    pDst->spectrumMgt = tmp2__ >> 8 & 0x1;
    pDst->qos = tmp2__ >> 9 & 0x1;
    pDst->shortSlotTime = tmp2__ >> 10 & 0x1;
    pDst->apsd = tmp2__ >> 11 & 0x1;
    pDst->rrm = tmp2__ >> 12 & 0x1;
    pDst->dsssOfdm = tmp2__ >> 13 & 0x1;
    pDst->delayedBA = tmp2__ >> 14 & 0x1;
    pDst->immediateBA = tmp2__ >> 15 & 0x1;
    (void)pCtx;
} /* End dot11fUnpackFfCapabilities. */

#define SigFfCapabilities ( 0x0009 )

void dot11fUnpackFfCategory(tpAniSirGlobal pCtx,
                            tANI_U8 *pBuf,
                            tDot11fFfCategory *pDst)
{
    pDst->category = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfCategory. */

#define SigFfCategory ( 0x000a )

void dot11fUnpackFfCurrentAPAddress(tpAniSirGlobal pCtx,
                                    tANI_U8 *pBuf,
                                    tDot11fFfCurrentAPAddress *pDst)
{
    DOT11F_MEMCPY(pCtx, pDst->mac, pBuf, 6);
    (void)pCtx;
} /* End dot11fUnpackFfCurrentAPAddress. */

#define SigFfCurrentAPAddress ( 0x000b )

void dot11fUnpackFfDelBAParameterSet(tpAniSirGlobal pCtx,
                                     tANI_U8 *pBuf,
                                     tDot11fFfDelBAParameterSet *pDst)
{
    tANI_U16 tmp3__;
    framesntohs(pCtx, &tmp3__, pBuf, 0);
    pDst->reserved = tmp3__ >> 0 & 0x7ff;
    pDst->initiator = tmp3__ >> 11 & 0x1;
    pDst->tid = tmp3__ >> 12 & 0xf;
    (void)pCtx;
} /* End dot11fUnpackFfDelBAParameterSet. */

#define SigFfDelBAParameterSet ( 0x000c )

void dot11fUnpackFfDialogToken(tpAniSirGlobal pCtx,
                               tANI_U8 *pBuf,
                               tDot11fFfDialogToken *pDst)
{
    pDst->token = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfDialogToken. */

#define SigFfDialogToken ( 0x000d )

void dot11fUnpackFfLinkMargin(tpAniSirGlobal pCtx,
                              tANI_U8 *pBuf,
                              tDot11fFfLinkMargin *pDst)
{
    pDst->linkMargin = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfLinkMargin. */

#define SigFfLinkMargin ( 0x000e )

#define SigFfListenInterval ( 0x000f )

void dot11fUnpackFfMaxTxPower(tpAniSirGlobal pCtx,
                              tANI_U8 *pBuf,
                              tDot11fFfMaxTxPower *pDst)
{
    pDst->maxTxPower = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfMaxTxPower. */

#define SigFfMaxTxPower ( 0x0010 )

void dot11fUnpackFfNumOfRepetitions(tpAniSirGlobal pCtx,
                                    tANI_U8 *pBuf,
                                    tDot11fFfNumOfRepetitions *pDst)
{
    framesntohs(pCtx, &pDst->repetitions, pBuf, 0);
    (void)pCtx;
} /* End dot11fUnpackFfNumOfRepetitions. */

#define SigFfNumOfRepetitions ( 0x0011 )

void dot11fUnpackFfP2POUI(tpAniSirGlobal pCtx,
                          tANI_U8 *pBuf,
                          tDot11fFfP2POUI *pDst)
{
    framesntohl(pCtx, &pDst->oui, pBuf, 0);
    (void)pCtx;
} /* End dot11fUnpackFfP2POUI. */

#define SigFfP2POUI ( 0x0012 )

void dot11fUnpackFfP2POUISubType(tpAniSirGlobal pCtx,
                                 tANI_U8 *pBuf,
                                 tDot11fFfP2POUISubType *pDst)
{
    pDst->ouiSubtype = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfP2POUISubType. */

#define SigFfP2POUISubType ( 0x0013 )

void dot11fUnpackFfRCPI(tpAniSirGlobal pCtx,
                        tANI_U8 *pBuf,
                        tDot11fFfRCPI *pDst)
{
    pDst->rcpi = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfRCPI. */

#define SigFfRCPI ( 0x0014 )

void dot11fUnpackFfRSNI(tpAniSirGlobal pCtx,
                        tANI_U8 *pBuf,
                        tDot11fFfRSNI *pDst)
{
    pDst->rsni = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfRSNI. */

#define SigFfRSNI ( 0x0015 )

#define SigFfReason ( 0x0016 )

void dot11fUnpackFfRxAntennaId(tpAniSirGlobal pCtx,
                               tANI_U8 *pBuf,
                               tDot11fFfRxAntennaId *pDst)
{
    pDst->antennaId = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfRxAntennaId. */

#define SigFfRxAntennaId ( 0x0017 )

void dot11fUnpackFfSMPowerModeSet(tpAniSirGlobal pCtx,
                                  tANI_U8 *pBuf,
                                  tDot11fFfSMPowerModeSet *pDst)
{
    tANI_U8 tmp4__;
    tmp4__ = *pBuf;
    pDst->PowerSave_En = tmp4__ >> 0 & 0x1;
    pDst->Mode = tmp4__ >> 1 & 0x1;
    pDst->reserved = tmp4__ >> 2 & 0x3f;
    (void)pCtx;
} /* End dot11fUnpackFfSMPowerModeSet. */

#define SigFfSMPowerModeSet ( 0x0018 )

#define SigFfStatus ( 0x0019 )

void dot11fUnpackFfStatusCode(tpAniSirGlobal pCtx,
                              tANI_U8 *pBuf,
                              tDot11fFfStatusCode *pDst)
{
    pDst->statusCode = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfStatusCode. */

#define SigFfStatusCode ( 0x001a )

void dot11fUnpackFfTPCEleID(tpAniSirGlobal pCtx,
                            tANI_U8 *pBuf,
                            tDot11fFfTPCEleID *pDst)
{
    pDst->TPCId = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfTPCEleID. */

#define SigFfTPCEleID ( 0x001b )

void dot11fUnpackFfTPCEleLen(tpAniSirGlobal pCtx,
                             tANI_U8 *pBuf,
                             tDot11fFfTPCEleLen *pDst)
{
    pDst->TPCLen = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfTPCEleLen. */

#define SigFfTPCEleLen ( 0x001c )

void dot11fUnpackFfTSInfo(tpAniSirGlobal pCtx,
                          tANI_U8 *pBuf,
                          tDot11fFfTSInfo *pDst)
{
    tANI_U32 tmp5__;
    framesntohl(pCtx, &tmp5__, pBuf, 0);
    pDst->traffic_type = tmp5__ >> 0 & 0x1;
    pDst->tsid = tmp5__ >> 1 & 0xf;
    pDst->direction = tmp5__ >> 5 & 0x3;
    pDst->access_policy = tmp5__ >> 7 & 0x3;
    pDst->aggregation = tmp5__ >> 9 & 0x1;
    pDst->psb = tmp5__ >> 10 & 0x1;
    pDst->user_priority = tmp5__ >> 11 & 0x7;
    pDst->tsinfo_ack_pol = tmp5__ >> 14 & 0x3;
    pDst->schedule = tmp5__ >> 16 & 0x1;
    pDst->unused = tmp5__ >> 17 & 0x7fff;
    (void)pCtx;
} /* End dot11fUnpackFfTSInfo. */

#define SigFfTSInfo ( 0x001d )

void dot11fUnpackFfTimeStamp(tpAniSirGlobal pCtx,
                             tANI_U8 *pBuf,
                             tDot11fFfTimeStamp *pDst)
{
    framesntohq(pCtx, &pDst->timestamp, pBuf, 0);
    (void)pCtx;
} /* End dot11fUnpackFfTimeStamp. */

#define SigFfTimeStamp ( 0x001e )

void dot11fUnpackFfTxAntennaId(tpAniSirGlobal pCtx,
                               tANI_U8 *pBuf,
                               tDot11fFfTxAntennaId *pDst)
{
    pDst->antennaId = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfTxAntennaId. */

#define SigFfTxAntennaId ( 0x001f )

void dot11fUnpackFfTxPower(tpAniSirGlobal pCtx,
                           tANI_U8 *pBuf,
                           tDot11fFfTxPower *pDst)
{
    pDst->txPower = *pBuf;
    (void)pCtx;
} /* End dot11fUnpackFfTxPower. */

#define SigFfTxPower ( 0x0020 )

tANI_U32 dot11fUnpackTlvAuthorizedMACs(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVAuthorizedMACs *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->mac, pBuf, 6);
    pBuf += 6;
    tlvlen -= (tANI_U8)6;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvAuthorizedMACs. */

#define SigTlvAuthorizedMACs ( 0x0001 )


#define SigTlvRequestToEnroll ( 0x0002 )


tANI_U32 dot11fUnpackTlvVersion2(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVVersion2 *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp6__;
    pDst->present = 1;
    tmp6__ = *pBuf;
    pBuf += 1;
    tlvlen -= 1;
    pDst->minor = tmp6__ >> 0 & 0xf;
    pDst->major = tmp6__ >> 4 & 0xf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvVersion2. */

#define SigTlvVersion2 ( 0x0003 )


#define SigTlvAPSetupLocked ( 0x0004 )


#define SigTlvAssociationState ( 0x0005 )


tANI_U32 dot11fUnpackTlvChannelList(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVChannelList *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->countryString, pBuf, 3);
    pBuf += 3;
    tlvlen -= (tANI_U8)3;
    pDst->num_channelList = (tANI_U8)( tlvlen );
    if (tlvlen > 251){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->channelList, pBuf, ( tlvlen ) );
    pBuf += ( tlvlen );
    tlvlen -= ( tlvlen );
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvChannelList. */

#define SigTlvChannelList ( 0x0006 )


#define SigTlvConfigMethods ( 0x0007 )


#define SigTlvConfigurationError ( 0x0008 )


tANI_U32 dot11fUnpackTlvConfigurationTimeout(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVConfigurationTimeout *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    pDst->GOConfigTimeout = *pBuf;
    pBuf += 1;
    tlvlen -= (tANI_U8)1;
    pDst->CLConfigTimeout = *pBuf;
    pBuf += 1;
    tlvlen -= (tANI_U8)1;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvConfigurationTimeout. */

#define SigTlvConfigurationTimeout ( 0x0009 )


tANI_U32 dot11fUnpackTlvDeviceName(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVDeviceName *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    pDst->num_text = (tANI_U8)( tlvlen );
    if (tlvlen > 32){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->text, pBuf, ( tlvlen ) );
    pBuf += ( tlvlen );
    tlvlen -= ( tlvlen );
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvDeviceName. */

#define SigTlvDeviceName ( 0x000a )


#define SigTlvDevicePasswordID ( 0x000b )


tANI_U32 dot11fUnpackTlvExtendedListenTiming(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVExtendedListenTiming *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->availibilityPeriod, pBuf, 0);
    pBuf += 2;
    tlvlen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->availibilityInterval, pBuf, 0);
    pBuf += 2;
    tlvlen -= (tANI_U8)2;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvExtendedListenTiming. */

#define SigTlvExtendedListenTiming ( 0x000c )


#define SigTlvGOIntent ( 0x000d )


tANI_U32 dot11fUnpackTlvIntendedP2PInterfaceAddress(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVIntendedP2PInterfaceAddress *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->P2PInterfaceAddress, pBuf, 6);
    pBuf += 6;
    tlvlen -= (tANI_U8)6;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvIntendedP2PInterfaceAddress. */

#define SigTlvIntendedP2PInterfaceAddress ( 0x000e )


#define SigTlvInvitationFlags ( 0x000f )


tANI_U32 dot11fUnpackTlvListenChannel(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVListenChannel *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->countryString, pBuf, 3);
    pBuf += 3;
    tlvlen -= (tANI_U8)3;
    pDst->regulatoryClass = *pBuf;
    pBuf += 1;
    tlvlen -= (tANI_U8)1;
    pDst->channel = *pBuf;
    pBuf += 1;
    tlvlen -= (tANI_U8)1;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvListenChannel. */

#define SigTlvListenChannel ( 0x0010 )


tANI_U32 dot11fUnpackTlvManufacturer(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVManufacturer *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    pDst->num_name = (tANI_U8)( tlvlen );
    if (tlvlen > 64){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->name, pBuf, ( tlvlen ) );
    pBuf += ( tlvlen );
    tlvlen -= ( tlvlen );
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvManufacturer. */

#define SigTlvManufacturer ( 0x0011 )


#define SigTlvMinorReasonCode ( 0x0012 )


tANI_U32 dot11fUnpackTlvModelName(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVModelName *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    pDst->num_text = (tANI_U8)( tlvlen );
    if (tlvlen > 32){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->text, pBuf, ( tlvlen ) );
    pBuf += ( tlvlen );
    tlvlen -= ( tlvlen );
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvModelName. */

#define SigTlvModelName ( 0x0013 )


tANI_U32 dot11fUnpackTlvModelNumber(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVModelNumber *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    pDst->num_text = (tANI_U8)( tlvlen );
    if (tlvlen > 32){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->text, pBuf, ( tlvlen ) );
    pBuf += ( tlvlen );
    tlvlen -= ( tlvlen );
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvModelNumber. */

#define SigTlvModelNumber ( 0x0014 )


tANI_U32 dot11fUnpackTlvNoticeOfAbsence(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVNoticeOfAbsence *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    pDst->index = *pBuf;
    pBuf += 1;
    tlvlen -= (tANI_U8)1;
    pDst->CTSWindowOppPS = *pBuf;
    pBuf += 1;
    tlvlen -= (tANI_U8)1;
    pDst->num_NoADesc = (tANI_U8)( tlvlen );
    if (tlvlen > 36){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->NoADesc, pBuf, ( tlvlen ) );
    pBuf += ( tlvlen );
    tlvlen -= ( tlvlen );
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvNoticeOfAbsence. */

#define SigTlvNoticeOfAbsence ( 0x0015 )


tANI_U32 dot11fUnpackTlvOperatingChannel(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVOperatingChannel *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->countryString, pBuf, 3);
    pBuf += 3;
    tlvlen -= (tANI_U8)3;
    pDst->regulatoryClass = *pBuf;
    pBuf += 1;
    tlvlen -= (tANI_U8)1;
    pDst->channel = *pBuf;
    pBuf += 1;
    tlvlen -= (tANI_U8)1;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvOperatingChannel. */

#define SigTlvOperatingChannel ( 0x0016 )


tANI_U32 dot11fUnpackTlvP2PCapability(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVP2PCapability *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    pDst->deviceCapability = *pBuf;
    pBuf += 1;
    tlvlen -= (tANI_U8)1;
    pDst->groupCapability = *pBuf;
    pBuf += 1;
    tlvlen -= (tANI_U8)1;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvP2PCapability. */

#define SigTlvP2PCapability ( 0x0017 )


tANI_U32 dot11fUnpackTlvP2PDeviceId(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVP2PDeviceId *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->P2PDeviceAddress, pBuf, 6);
    pBuf += 6;
    tlvlen -= (tANI_U8)6;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvP2PDeviceId. */

#define SigTlvP2PDeviceId ( 0x0018 )


    static const tTLVDefn TLVS_P2PDeviceInfo[] = {
        {offsetof(tDot11fTLVP2PDeviceInfo, DeviceName), offsetof(tDot11fTLVDeviceName, present), "DeviceName", SigTlvDeviceName, DOT11F_TLV_DEVICENAME, 0, 4, 36, 1, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackTlvP2PDeviceInfo(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVP2PDeviceInfo *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->P2PDeviceAddress, pBuf, 6);
    pBuf += 6;
    tlvlen -= (tANI_U8)6;
    framesntohs(pCtx, &pDst->configMethod, pBuf, 0);
    pBuf += 2;
    tlvlen -= (tANI_U8)2;
    DOT11F_MEMCPY(pCtx, pDst->primaryDeviceType, pBuf, 8);
    pBuf += 8;
    tlvlen -= (tANI_U8)8;
    (void)pCtx;
    status |= UnpackTlvCore(pCtx,
                        pBuf,
                        tlvlen,
                        TLVS_P2PDeviceInfo,
                        ( tANI_U8* )pDst,
                        sizeof(*pDst));
    return status;
} /* End dot11fUnpackTlvP2PDeviceInfo. */

#define SigTlvP2PDeviceInfo ( 0x0019 )


tANI_U32 dot11fUnpackTlvP2PGroupBssid(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVP2PGroupBssid *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->P2PGroupBssid, pBuf, 6);
    pBuf += 6;
    tlvlen -= (tANI_U8)6;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvP2PGroupBssid. */

#define SigTlvP2PGroupBssid ( 0x001a )


tANI_U32 dot11fUnpackTlvP2PGroupId(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVP2PGroupId *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->deviceAddress, pBuf, 6);
    pBuf += 6;
    tlvlen -= (tANI_U8)6;
    pDst->num_ssid = (tANI_U8)( tlvlen );
    if (tlvlen > 32){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->ssid, pBuf, ( tlvlen ) );
    pBuf += ( tlvlen );
    tlvlen -= ( tlvlen );
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvP2PGroupId. */

#define SigTlvP2PGroupId ( 0x001b )


tANI_U32 dot11fUnpackTlvP2PGroupInfo(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVP2PGroupInfo *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    pDst->num_P2PClientInfoDesc = (tANI_U8)( tlvlen );
    DOT11F_MEMCPY(pCtx, pDst->P2PClientInfoDesc, pBuf, ( tlvlen ) );
    pBuf += ( tlvlen );
    tlvlen -= ( tlvlen );
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvP2PGroupInfo. */

#define SigTlvP2PGroupInfo ( 0x001c )


#define SigTlvP2PStatus ( 0x001d )


tANI_U32 dot11fUnpackTlvPrimaryDeviceType(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVPrimaryDeviceType *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)tlvlen; /* Shutup the compiler */
    pDst->present = 1;
    framesntohs(pCtx, &pDst->primary_category, pBuf, 1);
    pBuf += 2;
    tlvlen -= (tANI_U8)2;
    DOT11F_MEMCPY(pCtx, pDst->oui, pBuf, 4);
    pBuf += 4;
    tlvlen -= (tANI_U8)4;
    framesntohs(pCtx, &pDst->sub_category, pBuf, 1);
    pBuf += 2;
    tlvlen -= (tANI_U8)2;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvPrimaryDeviceType. */

#define SigTlvPrimaryDeviceType ( 0x001e )


#define SigTlvRFBands ( 0x001f )


tANI_U32 dot11fUnpackTlvRequestDeviceType(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVRequestDeviceType *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->primary_category, pBuf, 1);
    pBuf += 2;
    tlvlen -= (tANI_U8)2;
    DOT11F_MEMCPY(pCtx, pDst->oui, pBuf, 4);
    pBuf += 4;
    tlvlen -= (tANI_U8)4;
    framesntohs(pCtx, &pDst->sub_category, pBuf, 1);
    pBuf += 2;
    tlvlen -= (tANI_U8)2;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvRequestDeviceType. */

#define SigTlvRequestDeviceType ( 0x0020 )


#define SigTlvRequestType ( 0x0021 )


#define SigTlvResponseType ( 0x0022 )


#define SigTlvSelectedRegistrar ( 0x0023 )


#define SigTlvSelectedRegistrarConfigMethods ( 0x0024 )


tANI_U32 dot11fUnpackTlvSerialNumber(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVSerialNumber *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    pDst->num_text = (tANI_U8)( tlvlen );
    if (tlvlen > 32){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->text, pBuf, ( tlvlen ) );
    pBuf += ( tlvlen );
    tlvlen -= ( tlvlen );
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvSerialNumber. */

#define SigTlvSerialNumber ( 0x0025 )


tANI_U32 dot11fUnpackTlvUUID_E(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVUUID_E *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->uuid, pBuf, 16);
    pBuf += 16;
    tlvlen -= (tANI_U8)16;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvUUID_E. */

#define SigTlvUUID_E ( 0x0026 )


tANI_U32 dot11fUnpackTlvUUID_R(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVUUID_R *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->uuid, pBuf, 16);
    pBuf += 16;
    tlvlen -= (tANI_U8)16;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvUUID_R. */

#define SigTlvUUID_R ( 0x0027 )


    static const tTLVDefn TLVS_VendorExtension[] = {
        {offsetof(tDot11fTLVVendorExtension, Version2), offsetof(tDot11fTLVVersion2, present), "Version2", SigTlvVersion2, DOT11F_TLV_VERSION2, 0, 3, 3, 0, 1, 1, 1, },
        {offsetof(tDot11fTLVVendorExtension, AuthorizedMACs), offsetof(tDot11fTLVAuthorizedMACs, present), "AuthorizedMACs", SigTlvAuthorizedMACs, DOT11F_TLV_AUTHORIZEDMACS, 0, 8, 8, 0, 1, 1, 1, },
        {offsetof(tDot11fTLVVendorExtension, RequestToEnroll), offsetof(tDot11fTLVRequestToEnroll, present), "RequestToEnroll", SigTlvRequestToEnroll, DOT11F_TLV_REQUESTTOENROLL, 0, 3, 3, 0, 1, 1, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackTlvVendorExtension(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVVendorExtension *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->vendorId, pBuf, 3);
    pBuf += 3;
    tlvlen -= (tANI_U8)3;
    (void)pCtx;
    status |= UnpackTlvCore(pCtx,
                        pBuf,
                        tlvlen,
                        TLVS_VendorExtension,
                        ( tANI_U8* )pDst,
                        sizeof(*pDst));
    return status;
} /* End dot11fUnpackTlvVendorExtension. */

#define SigTlvVendorExtension ( 0x0028 )


tANI_U32 dot11fUnpackTlvVersion(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVVersion *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp7__;
    pDst->present = 1;
    tmp7__ = *pBuf;
    pBuf += 1;
    tlvlen -= 1;
    pDst->minor = tmp7__ >> 0 & 0xf;
    pDst->major = tmp7__ >> 4 & 0xf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvVersion. */

#define SigTlvVersion ( 0x0029 )


#define SigTlvWPSState ( 0x002a )


tANI_U32 dot11fUnpackTlvP2PInterface(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U16 tlvlen, tDot11fTLVP2PInterface *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->P2PDeviceAddress, pBuf, 6);
    pBuf += 6;
    tlvlen -= (tANI_U8)6;
    (void)pCtx;
    return status;
} /* End dot11fUnpackTlvP2PInterface. */

#define SigTlvP2PInterface ( 0x002b )


#define SigTlvP2PManageability ( 0x002c )


tANI_U32 dot11fUnpackIeAPName(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEAPName *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_name = (tANI_U8)( ielen );
    if (ielen > 32){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->name, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeAPName. */

#define SigIeAPName ( 0x0001 )


tANI_U32 dot11fUnpackIeBPIndicator(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEBPIndicator *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->indicator = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->type = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeBPIndicator. */

#define SigIeBPIndicator ( 0x0002 )


tANI_U32 dot11fUnpackIeCondensedCountryStr(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIECondensedCountryStr *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->countryStr, pBuf, 2);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeCondensedCountryStr. */

#define SigIeCondensedCountryStr ( 0x0003 )


tANI_U32 dot11fUnpackIeGTK(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEGTK *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U16 tmp8__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &tmp8__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->keyId = tmp8__ >> 0 & 0x3;
    pDst->reserved = tmp8__ >> 2 & 0x3feb;
    pDst->keyLength = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    DOT11F_MEMCPY(pCtx, pDst->RSC, pBuf, 8);
    pBuf += 8;
    ielen -= (tANI_U8)8;
    pDst->num_key = (tANI_U8)( ielen );
    if (ielen > 32){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->key, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeGTK. */

#define SigIeGTK ( 0x0004 )


#define SigIeHCF ( 0x0005 )


tANI_U32 dot11fUnpackIeLLAttr(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIELLAttr *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohl(pCtx, &pDst->defer_threshold, pBuf, 1);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeLLAttr. */

#define SigIeLLAttr ( 0x0006 )


tANI_U32 dot11fUnpackIeLoadBalance(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIELoadBalance *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->bssid, pBuf, 6);
    pBuf += 6;
    ielen -= (tANI_U8)6;
    pDst->channel = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeLoadBalance. */

#define SigIeLoadBalance ( 0x0007 )


tANI_U32 dot11fUnpackIeLoadInfo(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIELoadInfo *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->num_stas, pBuf, 1);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->channel_util, pBuf, 1);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeLoadInfo. */

#define SigIeLoadInfo ( 0x0008 )


#define SigIePropAssocType ( 0x0009 )


tANI_U32 dot11fUnpackIePropCapability(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEPropCapability *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->capability, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIePropCapability. */

#define SigIePropCapability ( 0x000a )


tANI_U32 dot11fUnpackIePropChannSwitchAnn(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEPropChannSwitchAnn *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->mode = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->primary_channel = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->sub_band = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->channel_switch_count = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIePropChannSwitchAnn. */

#define SigIePropChannSwitchAnn ( 0x000b )


tANI_U32 dot11fUnpackIePropEDCAParams(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEPropEDCAParams *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp9__;
    tANI_U8 tmp10__;
    tANI_U8 tmp11__;
    tANI_U8 tmp12__;
    tANI_U8 tmp13__;
    tANI_U8 tmp14__;
    tANI_U8 tmp15__;
    tANI_U8 tmp16__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->qos = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->reserved = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    tmp9__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbe_aifsn = tmp9__ >> 0 & 0xf;
    pDst->acbe_acm = tmp9__ >> 4 & 0x1;
    pDst->acbe_aci = tmp9__ >> 5 & 0x3;
    pDst->unused1 = tmp9__ >> 7 & 0x1;
    tmp10__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbe_min = tmp10__ >> 0 & 0xf;
    pDst->acbe_max = tmp10__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acbe_txoplimit, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    tmp11__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbk_aifsn = tmp11__ >> 0 & 0xf;
    pDst->acbk_acm = tmp11__ >> 4 & 0x1;
    pDst->acbk_aci = tmp11__ >> 5 & 0x3;
    pDst->unused2 = tmp11__ >> 7 & 0x1;
    tmp12__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbk_min = tmp12__ >> 0 & 0xf;
    pDst->acbk_max = tmp12__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acbk_txoplimit, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    tmp13__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvi_aifsn = tmp13__ >> 0 & 0xf;
    pDst->acvi_acm = tmp13__ >> 4 & 0x1;
    pDst->acvi_aci = tmp13__ >> 5 & 0x3;
    pDst->unused3 = tmp13__ >> 7 & 0x1;
    tmp14__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvi_min = tmp14__ >> 0 & 0xf;
    pDst->acvi_max = tmp14__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acvi_txoplimit, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    tmp15__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvo_aifsn = tmp15__ >> 0 & 0xf;
    pDst->acvo_acm = tmp15__ >> 4 & 0x1;
    pDst->acvo_aci = tmp15__ >> 5 & 0x3;
    pDst->unused4 = tmp15__ >> 7 & 0x1;
    tmp16__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvo_min = tmp16__ >> 0 & 0xf;
    pDst->acvo_max = tmp16__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acvo_txoplimit, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIePropEDCAParams. */

#define SigIePropEDCAParams ( 0x000c )


tANI_U32 dot11fUnpackIePropQuietBSS(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEPropQuietBSS *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->quiet_count = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->quiet_period = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    framesntohs(pCtx, &pDst->quiet_duration, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->quiet_offset, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIePropQuietBSS. */

#define SigIePropQuietBSS ( 0x000d )


tANI_U32 dot11fUnpackIePropSuppRates(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEPropSuppRates *pDst)
{
    tANI_U8 i;
    tANI_U8 rate_indx = 0;
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    for (i = 0; i < ielen; i++) {
        if ((DOT11F_IS_BG_RATE(pBuf[i] & 0x7F)) && 
            (rate_indx < 12)) {
            pDst->rates[rate_indx++] = pBuf[i];
        }
    }

    if(rate_indx == 0) {
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    pDst->num_rates = rate_indx;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIePropSuppRates. */

#define SigIePropSuppRates ( 0x000e )


tANI_U32 dot11fUnpackIeR0KH_ID(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIER0KH_ID *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_PMK_R0_ID = (tANI_U8)( ielen );
    if (ielen > 48){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->PMK_R0_ID, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeR0KH_ID. */

#define SigIeR0KH_ID ( 0x000f )


tANI_U32 dot11fUnpackIeR1KH_ID(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIER1KH_ID *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->PMK_R1_ID, pBuf, 6);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeR1KH_ID. */

#define SigIeR1KH_ID ( 0x0010 )


tANI_U32 dot11fUnpackIeTSFInfo(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIETSFInfo *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->TsfOffset, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->BeaconIntvl, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeTSFInfo. */

#define SigIeTSFInfo ( 0x0011 )


tANI_U32 dot11fUnpackIeTaurus(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIETaurus *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U16 tmp17__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->baTIDBitmap, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->baPolicy, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &tmp17__, pBuf, 0);
    pDst->baBufferSize = tmp17__ >> 0 & 0xfff;
    pDst->rsvd = tmp17__ >> 12 & 0xf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeTaurus. */

#define SigIeTaurus ( 0x0012 )


tANI_U32 dot11fUnpackIeTitan(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIETitan *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->concat_tcid_bitmap = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->compression_tcid_bitmap = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->cb_state = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->rev_fcs_state = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeTitan. */

#define SigIeTitan ( 0x0013 )


#define SigIeTriggerStaBgScan ( 0x0014 )


tANI_U32 dot11fUnpackIeVersion(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEVersion *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohl(pCtx, &pDst->chip_rev, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    pDst->card_type = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->num_build_version = (tANI_U8)( ielen );
    if (ielen > 20){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->build_version, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeVersion. */

#define SigIeVersion ( 0x0015 )


tANI_U32 dot11fUnpackIeWDS(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWDS *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_wdsData = (tANI_U8)( ielen );
    if (ielen > 64){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->wdsData, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWDS. */

#define SigIeWDS ( 0x0016 )


tANI_U32 dot11fUnpackIeAPChannelReport(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEAPChannelReport *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->regulatoryClass = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->num_channelList = (tANI_U8)( ielen );
    if (ielen > 50){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->channelList, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeAPChannelReport. */

#define SigIeAPChannelReport ( 0x0017 )


tANI_U32 dot11fUnpackIeBcnReportingDetail(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEBcnReportingDetail *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->reportingDetail = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeBcnReportingDetail. */

#define SigIeBcnReportingDetail ( 0x0018 )


tANI_U32 dot11fUnpackIeBeaconReportFrmBody(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEBeaconReportFrmBody *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_reportedFields = (tANI_U8)( ielen );
    if (ielen > 224){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->reportedFields, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeBeaconReportFrmBody. */

#define SigIeBeaconReportFrmBody ( 0x0019 )


tANI_U32 dot11fUnpackIeBeaconReporting(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEBeaconReporting *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->reportingCondition = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->threshold = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeBeaconReporting. */

#define SigIeBeaconReporting ( 0x001a )


tANI_U32 dot11fUnpackIeMeasurementPilot(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEMeasurementPilot *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->measurementPilot = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->num_vendorSpecific = (tANI_U8)( ielen );
    DOT11F_MEMCPY(pCtx, pDst->vendorSpecific, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeMeasurementPilot. */

#define SigIeMeasurementPilot ( 0x001b )


tANI_U32 dot11fUnpackIeMultiBssid(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEMultiBssid *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->maxBSSIDIndicator = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->num_vendorSpecific = (tANI_U8)( ielen );
    DOT11F_MEMCPY(pCtx, pDst->vendorSpecific, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeMultiBssid. */

#define SigIeMultiBssid ( 0x001c )


tANI_U32 dot11fUnpackIeRICData(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIERICData *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->Identifier = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->resourceDescCount = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    framesntohs(pCtx, &pDst->statusCode, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeRICData. */

#define SigIeRICData ( 0x001d )


tANI_U32 dot11fUnpackIeRICDescriptor(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIERICDescriptor *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->resourceType = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->num_variableData = (tANI_U8)( ielen );
    DOT11F_MEMCPY(pCtx, pDst->variableData, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeRICDescriptor. */

#define SigIeRICDescriptor ( 0x001e )


tANI_U32 dot11fUnpackIeRRMEnabledCap(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIERRMEnabledCap *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp18__;
    tANI_U8 tmp19__;
    tANI_U8 tmp20__;
    tANI_U8 tmp21__;
    tANI_U8 tmp22__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    tmp18__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->LinkMeasurement = tmp18__ >> 0 & 0x1;
    pDst->NeighborRpt = tmp18__ >> 1 & 0x1;
    pDst->parallel = tmp18__ >> 2 & 0x1;
    pDst->repeated = tmp18__ >> 3 & 0x1;
    pDst->BeaconPassive = tmp18__ >> 4 & 0x1;
    pDst->BeaconActive = tmp18__ >> 5 & 0x1;
    pDst->BeaconTable = tmp18__ >> 6 & 0x1;
    pDst->BeaconRepCond = tmp18__ >> 7 & 0x1;
    tmp19__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->FrameMeasurement = tmp19__ >> 0 & 0x1;
    pDst->ChannelLoad = tmp19__ >> 1 & 0x1;
    pDst->NoiseHistogram = tmp19__ >> 2 & 0x1;
    pDst->statistics = tmp19__ >> 3 & 0x1;
    pDst->LCIMeasurement = tmp19__ >> 4 & 0x1;
    pDst->LCIAzimuth = tmp19__ >> 5 & 0x1;
    pDst->TCMCapability = tmp19__ >> 6 & 0x1;
    pDst->triggeredTCM = tmp19__ >> 7 & 0x1;
    tmp20__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->APChanReport = tmp20__ >> 0 & 0x1;
    pDst->RRMMIBEnabled = tmp20__ >> 1 & 0x1;
    pDst->operatingChanMax = tmp20__ >> 2 & 0x7;
    pDst->nonOperatinChanMax = tmp20__ >> 5 & 0x7;
    tmp21__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->MeasurementPilot = tmp21__ >> 0 & 0x7;
    pDst->MeasurementPilotEnabled = tmp21__ >> 3 & 0x1;
    pDst->NeighborTSFOffset = tmp21__ >> 4 & 0x1;
    pDst->RCPIMeasurement = tmp21__ >> 5 & 0x1;
    pDst->RSNIMeasurement = tmp21__ >> 6 & 0x1;
    pDst->BssAvgAccessDelay = tmp21__ >> 7 & 0x1;
    tmp22__ = *pBuf;
    pDst->BSSAvailAdmission = tmp22__ >> 0 & 0x1;
    pDst->AntennaInformation = tmp22__ >> 1 & 0x1;
    pDst->reserved = tmp22__ >> 2 & 0x3f;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeRRMEnabledCap. */

#define SigIeRRMEnabledCap ( 0x001f )


tANI_U32 dot11fUnpackIeRequestedInfo(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIERequestedInfo *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_requested_eids = (tANI_U8)( ielen );
    DOT11F_MEMCPY(pCtx, pDst->requested_eids, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeRequestedInfo. */

#define SigIeRequestedInfo ( 0x0020 )


tANI_U32 dot11fUnpackIeSSID(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIESSID *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present)
    {
        status = DOT11F_DUPLICATE_IE;
        return status;
    }
    pDst->present = 1;
    pDst->num_ssid = (tANI_U8)( ielen );
    if (ielen > 32){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->ssid, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeSSID. */

#define SigIeSSID ( 0x0021 )


tANI_U32 dot11fUnpackIeSchedule(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIESchedule *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U16 tmp23__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &tmp23__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->aggregation = tmp23__ >> 0 & 0x1;
    pDst->tsid = tmp23__ >> 1 & 0xf;
    pDst->direction = tmp23__ >> 5 & 0x3;
    pDst->reserved = tmp23__ >> 7 & 0x1ff;
    framesntohl(pCtx, &pDst->service_start_time, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->service_interval, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohs(pCtx, &pDst->max_service_dur, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->spec_interval, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeSchedule. */

#define SigIeSchedule ( 0x0022 )


tANI_U32 dot11fUnpackIeTCLAS(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIETCLAS *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->user_priority = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->classifier_type = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->classifier_mask = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    switch (pDst->classifier_type)
    {
        case 0:
            DOT11F_MEMCPY(pCtx, pDst->info.EthParams.source, pBuf, 6);
            pBuf += 6;
            ielen -= (tANI_U8)6;
            DOT11F_MEMCPY(pCtx, pDst->info.EthParams.dest, pBuf, 6);
            pBuf += 6;
            ielen -= (tANI_U8)6;
            framesntohs(pCtx, &pDst->info.EthParams.type, pBuf, 0);
            pBuf += 2;
            ielen -= (tANI_U8)2;
        break;
        case 1:
            pDst->info.IpParams.version = *pBuf;
            pBuf += 1;
            ielen -= (tANI_U8)1;
            switch (pDst->info.IpParams.version)
            {
                case 4:
                    DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV4Params.source, pBuf, 4);
                    pBuf += 4;
                    ielen -= (tANI_U8)4;
                    DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV4Params.dest, pBuf, 4);
                    pBuf += 4;
                    ielen -= (tANI_U8)4;
                    framesntohs(pCtx, &pDst->info.IpParams.params.IpV4Params.src_port, pBuf, 0);
                    pBuf += 2;
                    ielen -= (tANI_U8)2;
                    framesntohs(pCtx, &pDst->info.IpParams.params.IpV4Params.dest_port, pBuf, 0);
                    pBuf += 2;
                    ielen -= (tANI_U8)2;
                    pDst->info.IpParams.params.IpV4Params.DSCP = *pBuf;
                    pBuf += 1;
                    ielen -= (tANI_U8)1;
                    pDst->info.IpParams.params.IpV4Params.proto = *pBuf;
                    pBuf += 1;
                    ielen -= (tANI_U8)1;
                    pDst->info.IpParams.params.IpV4Params.reserved = *pBuf;
                    pBuf += 1;
                    ielen -= (tANI_U8)1;
                break;
                case 6:
                    DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.source, pBuf, 16);
                    pBuf += 16;
                    ielen -= (tANI_U8)16;
                    DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.dest, pBuf, 16);
                    pBuf += 16;
                    ielen -= (tANI_U8)16;
                    framesntohs(pCtx, &pDst->info.IpParams.params.IpV6Params.src_port, pBuf, 0);
                    pBuf += 2;
                    ielen -= (tANI_U8)2;
                    framesntohs(pCtx, &pDst->info.IpParams.params.IpV6Params.dest_port, pBuf, 0);
                    pBuf += 2;
                    ielen -= (tANI_U8)2;
                    DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.flow_label, pBuf, 3);
                    pBuf += 3;
                    ielen -= (tANI_U8)3;
                break;
            }
        break;
        case 2:
            framesntohs(pCtx, &pDst->info.Params8021dq.tag_type, pBuf, 0);
            pBuf += 2;
            ielen -= (tANI_U8)2;
        break;
    }
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeTCLAS. */

#define SigIeTCLAS ( 0x0023 )


#define SigIeTCLASSPROC ( 0x0024 )


tANI_U32 dot11fUnpackIeTSDelay(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIETSDelay *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohl(pCtx, &pDst->delay, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeTSDelay. */

#define SigIeTSDelay ( 0x0025 )


tANI_U32 dot11fUnpackIeTSPEC(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIETSPEC *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U16 tmp24__;
    tANI_U8 tmp25__;
    tANI_U16 tmp26__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &tmp24__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->traffic_type = tmp24__ >> 0 & 0x1;
    pDst->tsid = tmp24__ >> 1 & 0xf;
    pDst->direction = tmp24__ >> 5 & 0x3;
    pDst->access_policy = tmp24__ >> 7 & 0x3;
    pDst->aggregation = tmp24__ >> 9 & 0x1;
    pDst->psb = tmp24__ >> 10 & 0x1;
    pDst->user_priority = tmp24__ >> 11 & 0x7;
    pDst->tsinfo_ack_pol = tmp24__ >> 14 & 0x3;
    tmp25__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->schedule = tmp25__ >> 0 & 0x1;
    pDst->unused = tmp25__ >> 1 & 0x7f;
    framesntohs(pCtx, &tmp26__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->size = tmp26__ >> 0 & 0x7fff;
    pDst->fixed = tmp26__ >> 15 & 0x1;
    framesntohs(pCtx, &pDst->max_msdu_size, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohl(pCtx, &pDst->min_service_int, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->max_service_int, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->inactivity_int, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->suspension_int, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->service_start_time, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->min_data_rate, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->mean_data_rate, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->peak_data_rate, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->burst_size, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->delay_bound, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->min_phy_rate, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohs(pCtx, &pDst->surplus_bw_allowance, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->medium_time, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeTSPEC. */

#define SigIeTSPEC ( 0x0026 )


tANI_U32 dot11fUnpackIeWMMSchedule(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWMMSchedule *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U16 tmp27__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->version = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    if (pDst->version != 0x1)
    {
            pDst->present = 0;
            return ( status | DOT11F_BAD_FIXED_VALUE );
    }
    framesntohs(pCtx, &tmp27__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->aggregation = tmp27__ >> 0 & 0x1;
    pDst->tsid = tmp27__ >> 1 & 0xf;
    pDst->direction = tmp27__ >> 5 & 0x3;
    pDst->reserved = tmp27__ >> 7 & 0x1ff;
    framesntohl(pCtx, &pDst->service_start_time, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->service_interval, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohs(pCtx, &pDst->max_service_dur, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->spec_interval, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWMMSchedule. */

#define SigIeWMMSchedule ( 0x0027 )


tANI_U32 dot11fUnpackIeWMMTCLAS(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWMMTCLAS *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->version = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    if (pDst->version != 0x1)
    {
            pDst->present = 0;
            return ( status | DOT11F_BAD_FIXED_VALUE );
    }
    pDst->user_priority = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->classifier_type = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->classifier_mask = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    switch (pDst->classifier_type)
    {
        case 0:
            DOT11F_MEMCPY(pCtx, pDst->info.EthParams.source, pBuf, 6);
            pBuf += 6;
            ielen -= (tANI_U8)6;
            DOT11F_MEMCPY(pCtx, pDst->info.EthParams.dest, pBuf, 6);
            pBuf += 6;
            ielen -= (tANI_U8)6;
            framesntohs(pCtx, &pDst->info.EthParams.type, pBuf, 0);
            pBuf += 2;
            ielen -= (tANI_U8)2;
        break;
        case 1:
            pDst->info.IpParams.version = *pBuf;
            pBuf += 1;
            ielen -= (tANI_U8)1;
            switch (pDst->info.IpParams.version)
            {
                case 4:
                    DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV4Params.source, pBuf, 4);
                    pBuf += 4;
                    ielen -= (tANI_U8)4;
                    DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV4Params.dest, pBuf, 4);
                    pBuf += 4;
                    ielen -= (tANI_U8)4;
                    framesntohs(pCtx, &pDst->info.IpParams.params.IpV4Params.src_port, pBuf, 0);
                    pBuf += 2;
                    ielen -= (tANI_U8)2;
                    framesntohs(pCtx, &pDst->info.IpParams.params.IpV4Params.dest_port, pBuf, 0);
                    pBuf += 2;
                    ielen -= (tANI_U8)2;
                    pDst->info.IpParams.params.IpV4Params.DSCP = *pBuf;
                    pBuf += 1;
                    ielen -= (tANI_U8)1;
                    pDst->info.IpParams.params.IpV4Params.proto = *pBuf;
                    pBuf += 1;
                    ielen -= (tANI_U8)1;
                    pDst->info.IpParams.params.IpV4Params.reserved = *pBuf;
                    pBuf += 1;
                    ielen -= (tANI_U8)1;
                break;
                case 6:
                    DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.source, pBuf, 16);
                    pBuf += 16;
                    ielen -= (tANI_U8)16;
                    DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.dest, pBuf, 16);
                    pBuf += 16;
                    ielen -= (tANI_U8)16;
                    framesntohs(pCtx, &pDst->info.IpParams.params.IpV6Params.src_port, pBuf, 0);
                    pBuf += 2;
                    ielen -= (tANI_U8)2;
                    framesntohs(pCtx, &pDst->info.IpParams.params.IpV6Params.dest_port, pBuf, 0);
                    pBuf += 2;
                    ielen -= (tANI_U8)2;
                    DOT11F_MEMCPY(pCtx, pDst->info.IpParams.params.IpV6Params.flow_label, pBuf, 3);
                    pBuf += 3;
                    ielen -= (tANI_U8)3;
                break;
            }
        break;
        case 2:
            framesntohs(pCtx, &pDst->info.Params8021dq.tag_type, pBuf, 0);
            pBuf += 2;
            ielen -= (tANI_U8)2;
        break;
    }
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWMMTCLAS. */

#define SigIeWMMTCLAS ( 0x0028 )


tANI_U32 dot11fUnpackIeWMMTCLASPROC(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWMMTCLASPROC *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->version = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    if (pDst->version != 0x1)
    {
            pDst->present = 0;
            return ( status | DOT11F_BAD_FIXED_VALUE );
    }
    pDst->processing = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWMMTCLASPROC. */

#define SigIeWMMTCLASPROC ( 0x0029 )


tANI_U32 dot11fUnpackIeWMMTSDelay(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWMMTSDelay *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->version = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    if (pDst->version != 0x1)
    {
            pDst->present = 0;
            return ( status | DOT11F_BAD_FIXED_VALUE );
    }
    framesntohl(pCtx, &pDst->delay, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWMMTSDelay. */

#define SigIeWMMTSDelay ( 0x002a )


tANI_U32 dot11fUnpackIeWMMTSPEC(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWMMTSPEC *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U16 tmp28__;
    tANI_U8 tmp29__;
    tANI_U16 tmp30__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->version = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    if (pDst->version != 0x1)
    {
            pDst->present = 0;
            return ( status | DOT11F_BAD_FIXED_VALUE );
    }
    framesntohs(pCtx, &tmp28__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->traffic_type = tmp28__ >> 0 & 0x1;
    pDst->tsid = tmp28__ >> 1 & 0xf;
    pDst->direction = tmp28__ >> 5 & 0x3;
    pDst->access_policy = tmp28__ >> 7 & 0x3;
    pDst->aggregation = tmp28__ >> 9 & 0x1;
    pDst->psb = tmp28__ >> 10 & 0x1;
    pDst->user_priority = tmp28__ >> 11 & 0x7;
    pDst->tsinfo_ack_pol = tmp28__ >> 14 & 0x3;
    tmp29__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->tsinfo_rsvd = tmp29__ >> 0 & 0x7f;
    pDst->burst_size_defn = tmp29__ >> 7 & 0x1;
    framesntohs(pCtx, &tmp30__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->size = tmp30__ >> 0 & 0x7fff;
    pDst->fixed = tmp30__ >> 15 & 0x1;
    framesntohs(pCtx, &pDst->max_msdu_size, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohl(pCtx, &pDst->min_service_int, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->max_service_int, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->inactivity_int, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->suspension_int, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->service_start_time, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->min_data_rate, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->mean_data_rate, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->peak_data_rate, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->burst_size, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->delay_bound, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohl(pCtx, &pDst->min_phy_rate, pBuf, 0);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohs(pCtx, &pDst->surplus_bw_allowance, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->medium_time, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWMMTSPEC. */

#define SigIeWMMTSPEC ( 0x002b )


    static const tFFDefn FFS_Airgo[ ] = {
        { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_Airgo[ ] = {
        {offsetof(tDot11fIEAirgo, PropSuppRates), offsetof(tDot11fIEPropSuppRates, present), 0, "PropSuppRates" , 0, 3, 14, SigIePropSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_PROPSUPPRATES, 0, },
        {offsetof(tDot11fIEAirgo, APName), offsetof(tDot11fIEAPName, present), 0, "APName" , 0, 3, 34, SigIeAPName, {0, 0, 0, 0, 0}, 0, DOT11F_EID_APNAME, 0, },
        {offsetof(tDot11fIEAirgo, HCF), offsetof(tDot11fIEHCF, present), 0, "HCF" , 0, 3, 3, SigIeHCF, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HCF, 0, },
        {offsetof(tDot11fIEAirgo, WDS), offsetof(tDot11fIEWDS, present), 0, "WDS" , 0, 2, 66, SigIeWDS, {0, 0, 0, 0, 0}, 0, DOT11F_EID_WDS, 0, },
        {offsetof(tDot11fIEAirgo, BPIndicator), offsetof(tDot11fIEBPIndicator, present), 0, "BPIndicator" , 0, 4, 4, SigIeBPIndicator, {0, 0, 0, 0, 0}, 0, DOT11F_EID_BPINDICATOR, 0, },
        {offsetof(tDot11fIEAirgo, LoadInfo), offsetof(tDot11fIELoadInfo, present), 0, "LoadInfo" , 0, 6, 6, SigIeLoadInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_LOADINFO, 0, },
        {offsetof(tDot11fIEAirgo, LoadBalance), offsetof(tDot11fIELoadBalance, present), 0, "LoadBalance" , 0, 9, 9, SigIeLoadBalance, {0, 0, 0, 0, 0}, 0, DOT11F_EID_LOADBALANCE, 0, },
        {offsetof(tDot11fIEAirgo, PropAssocType), offsetof(tDot11fIEPropAssocType, present), 0, "PropAssocType" , 0, 3, 3, SigIePropAssocType, {0, 0, 0, 0, 0}, 0, DOT11F_EID_PROPASSOCTYPE, 0, },
        {offsetof(tDot11fIEAirgo, LLAttr), offsetof(tDot11fIELLAttr, present), 0, "LLAttr" , 0, 6, 6, SigIeLLAttr, {0, 0, 0, 0, 0}, 0, DOT11F_EID_LLATTR, 0, },
        {offsetof(tDot11fIEAirgo, PropCapability), offsetof(tDot11fIEPropCapability, present), 0, "PropCapability" , 0, 4, 4, SigIePropCapability, {0, 0, 0, 0, 0}, 0, DOT11F_EID_PROPCAPABILITY, 0, },
        {offsetof(tDot11fIEAirgo, Version), offsetof(tDot11fIEVersion, present), 0, "Version" , 0, 7, 27, SigIeVersion, {0, 0, 0, 0, 0}, 0, DOT11F_EID_VERSION, 0, },
        {offsetof(tDot11fIEAirgo, PropEDCAParams), offsetof(tDot11fIEPropEDCAParams, present), 0, "PropEDCAParams" , 0, 20, 20, SigIePropEDCAParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_PROPEDCAPARAMS, 0, },
        {offsetof(tDot11fIEAirgo, Titan), offsetof(tDot11fIETitan, present), 0, "Titan" , 0, 6, 6, SigIeTitan, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TITAN, 0, },
        {offsetof(tDot11fIEAirgo, PropChannSwitchAnn), offsetof(tDot11fIEPropChannSwitchAnn, present), 0, "PropChannSwitchAnn" , 0, 6, 6, SigIePropChannSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_PROPCHANNSWITCHANN, 0, },
        {offsetof(tDot11fIEAirgo, PropQuietBSS), offsetof(tDot11fIEPropQuietBSS, present), 0, "PropQuietBSS" , 0, 8, 8, SigIePropQuietBSS, {0, 0, 0, 0, 0}, 0, DOT11F_EID_PROPQUIETBSS, 0, },
        {offsetof(tDot11fIEAirgo, TriggerStaBgScan), offsetof(tDot11fIETriggerStaBgScan, present), 0, "TriggerStaBgScan" , 0, 3, 3, SigIeTriggerStaBgScan, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TRIGGERSTABGSCAN, 0, },
        {offsetof(tDot11fIEAirgo, Taurus), offsetof(tDot11fIETaurus, present), 0, "Taurus" , 0, 8, 8, SigIeTaurus, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TAURUS, 0, },
        {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
    };

tANI_U32 dot11fUnpackIeAirgo(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEAirgo *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    (void)pCtx;
    status |= UnpackCore(pCtx,
                     pBuf,
                     ielen,
                     FFS_Airgo,
                     IES_Airgo,
                     ( tANI_U8* )pDst,
                     sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeAirgo. */

#define SigIeAirgo ( 0x002c )


tANI_U32 dot11fUnpackIeCCXCckmOpaque(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIECCXCckmOpaque *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_data = (tANI_U8)( ielen );
    if (ielen > 20){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->data, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeCCXCckmOpaque. */

#define SigIeCCXCckmOpaque ( 0x002d )


tANI_U32 dot11fUnpackIeCCXRadMgmtCap(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIECCXRadMgmtCap *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp31__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->mgmt_state = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    tmp31__ = *pBuf;
    pDst->mbssid_mask = tmp31__ >> 0 & 0x7;
    pDst->reserved = tmp31__ >> 3 & 0x1f;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeCCXRadMgmtCap. */

#define SigIeCCXRadMgmtCap ( 0x002e )


tANI_U32 dot11fUnpackIeCCXTrafStrmMet(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIECCXTrafStrmMet *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->tsid = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->state = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    framesntohs(pCtx, &pDst->msmt_interval, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeCCXTrafStrmMet. */

#define SigIeCCXTrafStrmMet ( 0x002f )


tANI_U32 dot11fUnpackIeCCXTrafStrmRateSet(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIECCXTrafStrmRateSet *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->tsid = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->num_tsrates = (tANI_U8)( ielen );
    if (ielen > 8){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->tsrates, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeCCXTrafStrmRateSet. */

#define SigIeCCXTrafStrmRateSet ( 0x0030 )


tANI_U32 dot11fUnpackIeCCXTxmitPower(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIECCXTxmitPower *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->power_limit = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->reserved = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeCCXTxmitPower. */

#define SigIeCCXTxmitPower ( 0x0031 )


tANI_U32 dot11fUnpackIeCCXVersion(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIECCXVersion *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->version = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeCCXVersion. */

#define SigIeCCXVersion ( 0x0032 )


tANI_U32 dot11fUnpackIeCFParams(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIECFParams *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->cfp_count = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->cfp_period = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    framesntohs(pCtx, &pDst->cfp_maxduration, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->cfp_durremaining, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeCFParams. */

#define SigIeCFParams ( 0x0033 )


tANI_U32 dot11fUnpackIeChallengeText(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEChallengeText *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_text = (tANI_U8)( ielen );
    if (ielen > 253){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->text, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeChallengeText. */

#define SigIeChallengeText ( 0x0034 )


tANI_U32 dot11fUnpackIeChanSwitchAnn(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEChanSwitchAnn *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->switchMode = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->newChannel = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->switchCount = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeChanSwitchAnn. */

#define SigIeChanSwitchAnn ( 0x0035 )


tANI_U32 dot11fUnpackIeCountry(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIECountry *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->country, pBuf, 3);
    pBuf += 3;
    ielen -= (tANI_U8)3;
    if ( ! ielen )
    {
        pDst->num_triplets = 0U;
        return 0U;
    }
    else
    {
        pDst->num_triplets = (tANI_U8)( ielen / 3 );
        if (ielen / 3 > 84){
                pDst->present = 0;
                return DOT11F_SKIPPED_BAD_IE;
        }

        DOT11F_MEMCPY(pCtx, pDst->triplets, pBuf, ( ielen ) );
    }
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeCountry. */

#define SigIeCountry ( 0x0036 )


#define SigIeDSParams ( 0x0037 )


tANI_U32 dot11fUnpackIeEDCAParamSet(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEEDCAParamSet *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp32__;
    tANI_U8 tmp33__;
    tANI_U8 tmp34__;
    tANI_U8 tmp35__;
    tANI_U8 tmp36__;
    tANI_U8 tmp37__;
    tANI_U8 tmp38__;
    tANI_U8 tmp39__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->qos = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->reserved = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    tmp32__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbe_aifsn = tmp32__ >> 0 & 0xf;
    pDst->acbe_acm = tmp32__ >> 4 & 0x1;
    pDst->acbe_aci = tmp32__ >> 5 & 0x3;
    pDst->unused1 = tmp32__ >> 7 & 0x1;
    tmp33__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbe_acwmin = tmp33__ >> 0 & 0xf;
    pDst->acbe_acwmax = tmp33__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acbe_txoplimit, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    tmp34__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbk_aifsn = tmp34__ >> 0 & 0xf;
    pDst->acbk_acm = tmp34__ >> 4 & 0x1;
    pDst->acbk_aci = tmp34__ >> 5 & 0x3;
    pDst->unused2 = tmp34__ >> 7 & 0x1;
    tmp35__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbk_acwmin = tmp35__ >> 0 & 0xf;
    pDst->acbk_acwmax = tmp35__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acbk_txoplimit, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    tmp36__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvi_aifsn = tmp36__ >> 0 & 0xf;
    pDst->acvi_acm = tmp36__ >> 4 & 0x1;
    pDst->acvi_aci = tmp36__ >> 5 & 0x3;
    pDst->unused3 = tmp36__ >> 7 & 0x1;
    tmp37__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvi_acwmin = tmp37__ >> 0 & 0xf;
    pDst->acvi_acwmax = tmp37__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acvi_txoplimit, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    tmp38__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvo_aifsn = tmp38__ >> 0 & 0xf;
    pDst->acvo_acm = tmp38__ >> 4 & 0x1;
    pDst->acvo_aci = tmp38__ >> 5 & 0x3;
    pDst->unused4 = tmp38__ >> 7 & 0x1;
    tmp39__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvo_acwmin = tmp39__ >> 0 & 0xf;
    pDst->acvo_acwmax = tmp39__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acvo_txoplimit, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeEDCAParamSet. */

#define SigIeEDCAParamSet ( 0x0038 )


tANI_U32 dot11fUnpackIeERPInfo(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEERPInfo *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp40__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    tmp40__ = *pBuf;
    pDst->non_erp_present = tmp40__ >> 0 & 0x1;
    pDst->use_prot = tmp40__ >> 1 & 0x1;
    pDst->barker_preamble = tmp40__ >> 2 & 0x1;
    pDst->unused = tmp40__ >> 3 & 0x1f;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeERPInfo. */

#define SigIeERPInfo ( 0x0039 )


#define SigIeExtChanSwitchAnn ( 0x003a )


tANI_U32 dot11fUnpackIeExtSuppRates(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEExtSuppRates *pDst)
{
    tANI_U8 i;
    tANI_U8 rate_indx = 0;
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    for (i = 0; i < ielen; i++) {
        if ((DOT11F_IS_BG_RATE(pBuf[i] & 0x7F)) && 
            (rate_indx < 12)) {
            pDst->rates[rate_indx++] = pBuf[i];
        }
    }

    if(rate_indx == 0) {
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    pDst->num_rates = rate_indx;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeExtSuppRates. */

#define SigIeExtSuppRates ( 0x003b )


tANI_U32 dot11fUnpackIeFHParamSet(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEFHParamSet *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->dwell_time, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    pDst->hop_set = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->hop_pattern = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->hop_index = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeFHParamSet. */

#define SigIeFHParamSet ( 0x003c )


tANI_U32 dot11fUnpackIeFHParams(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEFHParams *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->radix = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->nchannels = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeFHParams. */

#define SigIeFHParams ( 0x003d )


tANI_U32 dot11fUnpackIeFHPattTable(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEFHPattTable *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->flag = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->nsets = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->modulus = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->offset = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->num_randtable = (tANI_U8)( ielen );
    if (ielen > 251){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->randtable, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeFHPattTable. */

#define SigIeFHPattTable ( 0x003e )


    static const tFFDefn FFS_FTInfo[ ] = {
        { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_FTInfo[ ] = {
        {offsetof(tDot11fIEFTInfo, R1KH_ID), offsetof(tDot11fIER1KH_ID, present), 0, "R1KH_ID" , 0, 8, 8, SigIeR1KH_ID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_R1KH_ID, 0, },
        {offsetof(tDot11fIEFTInfo, GTK), offsetof(tDot11fIEGTK, present), 0, "GTK" , 0, 18, 45, SigIeGTK, {0, 0, 0, 0, 0}, 0, DOT11F_EID_GTK, 0, },
        {offsetof(tDot11fIEFTInfo, R0KH_ID), offsetof(tDot11fIER0KH_ID, present), 0, "R0KH_ID" , 0, 3, 50, SigIeR0KH_ID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_R0KH_ID, 0, },
        {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
    };

tANI_U32 dot11fUnpackIeFTInfo(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEFTInfo *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U16 tmp41__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &tmp41__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->reserved = tmp41__ >> 0 & 0xff;
    pDst->IECount = tmp41__ >> 8 & 0xff;
    DOT11F_MEMCPY(pCtx, pDst->MIC, pBuf, 16);
    pBuf += 16;
    ielen -= (tANI_U8)16;
    DOT11F_MEMCPY(pCtx, pDst->Anonce, pBuf, 32);
    pBuf += 32;
    ielen -= (tANI_U8)32;
    DOT11F_MEMCPY(pCtx, pDst->Snonce, pBuf, 32);
    pBuf += 32;
    ielen -= (tANI_U8)32;
    (void)pCtx;
    status |= UnpackCore(pCtx,
                     pBuf,
                     ielen,
                     FFS_FTInfo,
                     IES_FTInfo,
                     ( tANI_U8* )pDst,
                     sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeFTInfo. */

#define SigIeFTInfo ( 0x003f )


tANI_U32 dot11fUnpackIeFTTimeoutInterval(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEFTTimeoutInterval *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->timeoutType = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    framesntohl(pCtx, &pDst->timeoutValue, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeFTTimeoutInterval. */

#define SigIeFTTimeoutInterval ( 0x0040 )


tANI_U32 dot11fUnpackIeHTCaps(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEHTCaps *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U16 tmp42__;
    tANI_U8 tmp43__;
    tANI_U16 tmp44__;
    tANI_U32 tmp45__;
    tANI_U8 tmp46__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &tmp42__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->advCodingCap = tmp42__ >> 0 & 0x1;
    pDst->supportedChannelWidthSet = tmp42__ >> 1 & 0x1;
    pDst->mimoPowerSave = tmp42__ >> 2 & 0x3;
    pDst->greenField = tmp42__ >> 4 & 0x1;
    pDst->shortGI20MHz = tmp42__ >> 5 & 0x1;
    pDst->shortGI40MHz = tmp42__ >> 6 & 0x1;
    pDst->txSTBC = tmp42__ >> 7 & 0x1;
    pDst->rxSTBC = tmp42__ >> 8 & 0x3;
    pDst->delayedBA = tmp42__ >> 10 & 0x1;
    pDst->maximalAMSDUsize = tmp42__ >> 11 & 0x1;
    pDst->dsssCckMode40MHz = tmp42__ >> 12 & 0x1;
    pDst->psmp = tmp42__ >> 13 & 0x1;
    pDst->stbcControlFrame = tmp42__ >> 14 & 0x1;
    pDst->lsigTXOPProtection = tmp42__ >> 15 & 0x1;
    tmp43__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->maxRxAMPDUFactor = tmp43__ >> 0 & 0x3;
    pDst->mpduDensity = tmp43__ >> 2 & 0x7;
    pDst->reserved1 = tmp43__ >> 5 & 0x7;
    DOT11F_MEMCPY(pCtx, pDst->supportedMCSSet, pBuf, 16);
    pBuf += 16;
    ielen -= (tANI_U8)16;
    framesntohs(pCtx, &tmp44__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->pco = tmp44__ >> 0 & 0x1;
    pDst->transitionTime = tmp44__ >> 1 & 0x3;
    pDst->reserved2 = tmp44__ >> 3 & 0x1f;
    pDst->mcsFeedback = tmp44__ >> 8 & 0x3;
    pDst->reserved3 = tmp44__ >> 10 & 0x3f;
    framesntohl(pCtx, &tmp45__, pBuf, 0);
    pBuf += 4;
    ielen -= 4;
    pDst->txBF = tmp45__ >> 0 & 0x1;
    pDst->rxStaggeredSounding = tmp45__ >> 1 & 0x1;
    pDst->txStaggeredSounding = tmp45__ >> 2 & 0x1;
    pDst->rxZLF = tmp45__ >> 3 & 0x1;
    pDst->txZLF = tmp45__ >> 4 & 0x1;
    pDst->implicitTxBF = tmp45__ >> 5 & 0x1;
    pDst->calibration = tmp45__ >> 6 & 0x3;
    pDst->explicitCSITxBF = tmp45__ >> 8 & 0x1;
    pDst->explicitUncompressedSteeringMatrix = tmp45__ >> 9 & 0x1;
    pDst->explicitBFCSIFeedback = tmp45__ >> 10 & 0x7;
    pDst->explicitUncompressedSteeringMatrixFeedback = tmp45__ >> 13 & 0x7;
    pDst->explicitCompressedSteeringMatrixFeedback = tmp45__ >> 16 & 0x7;
    pDst->csiNumBFAntennae = tmp45__ >> 19 & 0x3;
    pDst->uncompressedSteeringMatrixBFAntennae = tmp45__ >> 21 & 0x3;
    pDst->compressedSteeringMatrixBFAntennae = tmp45__ >> 23 & 0x3;
    pDst->reserved4 = tmp45__ >> 25 & 0x7f;
    tmp46__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->antennaSelection = tmp46__ >> 0 & 0x1;
    pDst->explicitCSIFeedbackTx = tmp46__ >> 1 & 0x1;
    pDst->antennaIndicesFeedbackTx = tmp46__ >> 2 & 0x1;
    pDst->explicitCSIFeedback = tmp46__ >> 3 & 0x1;
    pDst->antennaIndicesFeedback = tmp46__ >> 4 & 0x1;
    pDst->rxAS = tmp46__ >> 5 & 0x1;
    pDst->txSoundingPPDUs = tmp46__ >> 6 & 0x1;
    pDst->reserved5 = tmp46__ >> 7 & 0x1;
    pDst->num_rsvd = (tANI_U8)( ielen );
    if (ielen > 32){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->rsvd, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeHTCaps. */

#define SigIeHTCaps ( 0x0041 )


tANI_U32 dot11fUnpackIeHTInfo(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEHTInfo *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp47__;
    tANI_U16 tmp48__;
    tANI_U16 tmp49__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->primaryChannel = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    tmp47__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->secondaryChannelOffset = tmp47__ >> 0 & 0x3;
    pDst->recommendedTxWidthSet = tmp47__ >> 2 & 0x1;
    pDst->rifsMode = tmp47__ >> 3 & 0x1;
    pDst->controlledAccessOnly = tmp47__ >> 4 & 0x1;
    pDst->serviceIntervalGranularity = tmp47__ >> 5 & 0x7;
    framesntohs(pCtx, &tmp48__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->opMode = tmp48__ >> 0 & 0x3;
    pDst->nonGFDevicesPresent = tmp48__ >> 2 & 0x1;
    pDst->transmitBurstLimit = tmp48__ >> 3 & 0x1;
    pDst->obssNonHTStaPresent = tmp48__ >> 4 & 0x1;
    pDst->reserved = tmp48__ >> 5 & 0x7ff;
    framesntohs(pCtx, &tmp49__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->basicSTBCMCS = tmp49__ >> 0 & 0x7f;
    pDst->dualCTSProtection = tmp49__ >> 7 & 0x1;
    pDst->secondaryBeacon = tmp49__ >> 8 & 0x1;
    pDst->lsigTXOPProtectionFullSupport = tmp49__ >> 9 & 0x1;
    pDst->pcoActive = tmp49__ >> 10 & 0x1;
    pDst->pcoPhase = tmp49__ >> 11 & 0x1;
    pDst->reserved2 = tmp49__ >> 12 & 0xf;
    DOT11F_MEMCPY(pCtx, pDst->basicMCSSet, pBuf, 16);
    pBuf += 16;
    ielen -= (tANI_U8)16;
    pDst->num_rsvd = (tANI_U8)( ielen );
    if (ielen > 32){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->rsvd, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeHTInfo. */

#define SigIeHTInfo ( 0x0042 )


tANI_U32 dot11fUnpackIeIBSSParams(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEIBSSParams *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->atim, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeIBSSParams. */

#define SigIeIBSSParams ( 0x0043 )


static const tFFDefn FFS_reportBeacon[ ] = {
{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_reportBeacon[ ] = {
        {offsetof(tDot11fIEMeasurementReport, report.Beacon.BeaconReportFrmBody), offsetof(tDot11fIEBeaconReportFrmBody, present), 0, "BeaconReportFrmBody" , 0, 2, 226, SigIeBeaconReportFrmBody, {0, 0, 0, 0, 0}, 0, DOT11F_EID_BEACONREPORTFRMBODY, 0, },
{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

tANI_U32 dot11fUnpackIeMeasurementReport(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEMeasurementReport *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp50__;
    tANI_U8 tmp51__;
    tANI_U8 tmp52__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->token = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    tmp50__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->late = tmp50__ >> 0 & 0x1;
    pDst->incapable = tmp50__ >> 1 & 0x1;
    pDst->refused = tmp50__ >> 2 & 0x1;
    pDst->unused = tmp50__ >> 3 & 0x1f;
    pDst->type = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    if ( ! ielen )
    {
        return 0U;
    }
    else
    {
        switch (pDst->type)
        {
            case 0:
                pDst->report.Basic.channel = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                framesntohq(pCtx, &pDst->report.Basic.meas_start_time, pBuf, 0);
                pBuf += 8;
                ielen -= (tANI_U8)8;
                framesntohs(pCtx, &pDst->report.Basic.meas_duration, pBuf, 0);
                pBuf += 2;
                ielen -= (tANI_U8)2;
                tmp51__ = *pBuf;
                pBuf += 1;
                ielen -= 1;
                pDst->report.Basic.bss = tmp51__ >> 0 & 0x1;
                pDst->report.Basic.ofdm_preamble = tmp51__ >> 1 & 0x1;
                pDst->report.Basic.unid_signal = tmp51__ >> 2 & 0x1;
                pDst->report.Basic.rader = tmp51__ >> 3 & 0x1;
                pDst->report.Basic.unmeasured = tmp51__ >> 4 & 0x1;
                pDst->report.Basic.unused = tmp51__ >> 5 & 0x7;
            break;
            case 1:
                pDst->report.CCA.channel = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                framesntohq(pCtx, &pDst->report.CCA.meas_start_time, pBuf, 0);
                pBuf += 8;
                ielen -= (tANI_U8)8;
                framesntohs(pCtx, &pDst->report.CCA.meas_duration, pBuf, 0);
                pBuf += 2;
                ielen -= (tANI_U8)2;
                pDst->report.CCA.cca_busy_fraction = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
            break;
            case 2:
                pDst->report.RPIHistogram.channel = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                framesntohq(pCtx, &pDst->report.RPIHistogram.meas_start_time, pBuf, 0);
                pBuf += 8;
                ielen -= (tANI_U8)8;
                framesntohs(pCtx, &pDst->report.RPIHistogram.meas_duration, pBuf, 0);
                pBuf += 2;
                ielen -= (tANI_U8)2;
                pDst->report.RPIHistogram.rpi0_density = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                pDst->report.RPIHistogram.rpi1_density = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                pDst->report.RPIHistogram.rpi2_density = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                pDst->report.RPIHistogram.rpi3_density = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                pDst->report.RPIHistogram.rpi4_density = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                pDst->report.RPIHistogram.rpi5_density = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                pDst->report.RPIHistogram.rpi6_density = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                pDst->report.RPIHistogram.rpi7_density = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
            break;
            case 5:
                pDst->report.Beacon.regClass = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                pDst->report.Beacon.channel = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                framesntohq(pCtx, &pDst->report.Beacon.meas_start_time, pBuf, 0);
                pBuf += 8;
                ielen -= (tANI_U8)8;
                framesntohs(pCtx, &pDst->report.Beacon.meas_duration, pBuf, 0);
                pBuf += 2;
                ielen -= (tANI_U8)2;
                tmp52__ = *pBuf;
                pBuf += 1;
                ielen -= 1;
                pDst->report.Beacon.condensed_PHY = tmp52__ >> 0 & 0x7f;
                pDst->report.Beacon.reported_frame_type = tmp52__ >> 7 & 0x1;
                pDst->report.Beacon.RCPI = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                pDst->report.Beacon.RSNI = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                DOT11F_MEMCPY(pCtx, pDst->report.Beacon.BSSID, pBuf, 6);
                pBuf += 6;
                ielen -= (tANI_U8)6;
                pDst->report.Beacon.antenna_id = *pBuf;
                pBuf += 1;
                ielen -= (tANI_U8)1;
                framesntohl(pCtx, &pDst->report.Beacon.parent_TSF, pBuf, 0);
                pBuf += 4;
                ielen -= (tANI_U8)4;
            status |= UnpackCore(pCtx,
                     pBuf,
                     ielen,
                     FFS_reportBeacon,
                     IES_reportBeacon,
                     ( tANI_U8* )pDst,
                     sizeof(*pDst));
            break;
        }
    }
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeMeasurementReport. */

#define SigIeMeasurementReport ( 0x0044 )


static const tFFDefn FFS_measurement_requestBeacon[ ] = {
{ NULL, 0, 0, 0,},
};

static const tIEDefn IES_measurement_requestBeacon[ ] = {
        {offsetof(tDot11fIEMeasurementRequest, measurement_request.Beacon.SSID), offsetof(tDot11fIESSID, present), 0, "SSID" , 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 0, },
        {offsetof(tDot11fIEMeasurementRequest, measurement_request.Beacon.BeaconReporting), offsetof(tDot11fIEBeaconReporting, present), 0, "BeaconReporting" , 0, 4, 4, SigIeBeaconReporting, {0, 0, 0, 0, 0}, 0, DOT11F_EID_BEACONREPORTING, 0, },
        {offsetof(tDot11fIEMeasurementRequest, measurement_request.Beacon.BcnReportingDetail), offsetof(tDot11fIEBcnReportingDetail, present), 0, "BcnReportingDetail" , 0, 3, 3, SigIeBcnReportingDetail, {0, 0, 0, 0, 0}, 0, DOT11F_EID_BCNREPORTINGDETAIL, 0, },
        {offsetof(tDot11fIEMeasurementRequest, measurement_request.Beacon.RequestedInfo), offsetof(tDot11fIERequestedInfo, present), 0, "RequestedInfo" , 0, 2, 257, SigIeRequestedInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_REQUESTEDINFO, 0, },
        {offsetof(tDot11fIEMeasurementRequest, measurement_request.Beacon.APChannelReport), offsetof(tDot11fIEAPChannelReport, present), offsetof(tDot11fIEMeasurementRequest, measurement_request.Beacon.num_APChannelReport), "APChannelReport" , 2, 3, 53, SigIeAPChannelReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_APCHANNELREPORT, 0, },
{0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
};

tANI_U32 dot11fUnpackIeMeasurementRequest(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEMeasurementRequest *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp53__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->measurement_token = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    tmp53__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->parallel = tmp53__ >> 0 & 0x1;
    pDst->enable = tmp53__ >> 1 & 0x1;
    pDst->request = tmp53__ >> 2 & 0x1;
    pDst->report = tmp53__ >> 3 & 0x1;
    pDst->durationMandatory = tmp53__ >> 4 & 0x1;
    pDst->unused = tmp53__ >> 5 & 0x7;
    pDst->measurement_type = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    switch (pDst->measurement_type)
    {
        case 0:
            pDst->measurement_request.Basic.channel_no = *pBuf;
            pBuf += 1;
            ielen -= (tANI_U8)1;
            DOT11F_MEMCPY(pCtx, pDst->measurement_request.Basic.meas_start_time, pBuf, 8);
            pBuf += 8;
            ielen -= (tANI_U8)8;
            framesntohs(pCtx, &pDst->measurement_request.Basic.meas_duration, pBuf, 0);
            pBuf += 2;
            ielen -= (tANI_U8)2;
        break;
        case 1:
            pDst->measurement_request.CCA.channel_no = *pBuf;
            pBuf += 1;
            ielen -= (tANI_U8)1;
            DOT11F_MEMCPY(pCtx, pDst->measurement_request.CCA.meas_start_time, pBuf, 8);
            pBuf += 8;
            ielen -= (tANI_U8)8;
            framesntohs(pCtx, &pDst->measurement_request.CCA.meas_duration, pBuf, 0);
            pBuf += 2;
            ielen -= (tANI_U8)2;
        break;
        case 2:
            pDst->measurement_request.RPIHistogram.channel_no = *pBuf;
            pBuf += 1;
            ielen -= (tANI_U8)1;
            DOT11F_MEMCPY(pCtx, pDst->measurement_request.RPIHistogram.meas_start_time, pBuf, 8);
            pBuf += 8;
            ielen -= (tANI_U8)8;
            framesntohs(pCtx, &pDst->measurement_request.RPIHistogram.meas_duration, pBuf, 0);
            pBuf += 2;
            ielen -= (tANI_U8)2;
        break;
        case 5:
            pDst->measurement_request.Beacon.regClass = *pBuf;
            pBuf += 1;
            ielen -= (tANI_U8)1;
            pDst->measurement_request.Beacon.channel = *pBuf;
            pBuf += 1;
            ielen -= (tANI_U8)1;
            framesntohs(pCtx, &pDst->measurement_request.Beacon.randomization, pBuf, 0);
            pBuf += 2;
            ielen -= (tANI_U8)2;
            framesntohs(pCtx, &pDst->measurement_request.Beacon.meas_duration, pBuf, 0);
            pBuf += 2;
            ielen -= (tANI_U8)2;
            pDst->measurement_request.Beacon.meas_mode = *pBuf;
            pBuf += 1;
            ielen -= (tANI_U8)1;
            DOT11F_MEMCPY(pCtx, pDst->measurement_request.Beacon.BSSID, pBuf, 6);
            pBuf += 6;
            ielen -= (tANI_U8)6;
        status |= UnpackCore(pCtx,
                     pBuf,
                     ielen,
                     FFS_measurement_requestBeacon,
                     IES_measurement_requestBeacon,
                     ( tANI_U8* )pDst,
                     sizeof(*pDst));
        break;
    }
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeMeasurementRequest. */

#define SigIeMeasurementRequest ( 0x0045 )


tANI_U32 dot11fUnpackIeMobilityDomain(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEMobilityDomain *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp54__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->MDID, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    tmp54__ = *pBuf;
    pDst->overDSCap = tmp54__ >> 0 & 0x1;
    pDst->resourceReqCap = tmp54__ >> 1 & 0x1;
    pDst->reserved = tmp54__ >> 2 & 0x3f;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeMobilityDomain. */

#define SigIeMobilityDomain ( 0x0046 )


    static const tFFDefn FFS_NeighborReport[ ] = {
        { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_NeighborReport[ ] = {
        {offsetof(tDot11fIENeighborReport, TSFInfo), offsetof(tDot11fIETSFInfo, present), 0, "TSFInfo" , 0, 6, 6, SigIeTSFInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TSFINFO, 0, },
        {offsetof(tDot11fIENeighborReport, CondensedCountryStr), offsetof(tDot11fIECondensedCountryStr, present), 0, "CondensedCountryStr" , 0, 4, 4, SigIeCondensedCountryStr, {0, 0, 0, 0, 0}, 0, DOT11F_EID_CONDENSEDCOUNTRYSTR, 0, },
        {offsetof(tDot11fIENeighborReport, MeasurementPilot), offsetof(tDot11fIEMeasurementPilot, present), 0, "MeasurementPilot" , 0, 3, 258, SigIeMeasurementPilot, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MEASUREMENTPILOT, 0, },
        {offsetof(tDot11fIENeighborReport, RRMEnabledCap), offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap" , 0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RRMENABLEDCAP, 0, },
        {offsetof(tDot11fIENeighborReport, MultiBssid), offsetof(tDot11fIEMultiBssid, present), 0, "MultiBssid" , 0, 3, 258, SigIeMultiBssid, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MULTIBSSID, 0, },
        {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
    };

tANI_U32 dot11fUnpackIeNeighborReport(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIENeighborReport *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp55__;
    tANI_U8 tmp56__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    DOT11F_MEMCPY(pCtx, pDst->bssid, pBuf, 6);
    pBuf += 6;
    ielen -= (tANI_U8)6;
    tmp55__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->APReachability = tmp55__ >> 0 & 0x3;
    pDst->Security = tmp55__ >> 2 & 0x1;
    pDst->KeyScope = tmp55__ >> 3 & 0x1;
    pDst->SpecMgmtCap = tmp55__ >> 4 & 0x1;
    pDst->QosCap = tmp55__ >> 5 & 0x1;
    pDst->apsd = tmp55__ >> 6 & 0x1;
    pDst->rrm = tmp55__ >> 7 & 0x1;
    tmp56__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->DelayedBA = tmp56__ >> 0 & 0x1;
    pDst->ImmBA = tmp56__ >> 1 & 0x1;
    pDst->MobilityDomain = tmp56__ >> 2 & 0x1;
    pDst->reserved = tmp56__ >> 3 & 0x1f;
    framesntohs(pCtx, &pDst->reserved1, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    pDst->regulatoryClass = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->channel = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->PhyType = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    (void)pCtx;
    status |= UnpackCore(pCtx,
                     pBuf,
                     ielen,
                     FFS_NeighborReport,
                     IES_NeighborReport,
                     ( tANI_U8* )pDst,
                     sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeNeighborReport. */

#define SigIeNeighborReport ( 0x0047 )


    static const tTLVDefn TLVS_P2PAssocReq[ ] = {
        {offsetof(tDot11fIEP2PAssocReq, P2PCapability), offsetof(tDot11fTLVP2PCapability, present), "P2PCapability", SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PAssocReq, ExtendedListenTiming), offsetof(tDot11fTLVExtendedListenTiming, present), "ExtendedListenTiming", SigTlvExtendedListenTiming, DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PAssocReq, P2PDeviceInfo), offsetof(tDot11fTLVP2PDeviceInfo, present), "P2PDeviceInfo", SigTlvP2PDeviceInfo, DOT11F_TLV_P2PDEVICEINFO, 0, 19, 55, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PAssocReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PAssocReq *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PAssocReq,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PAssocReq. */

#define SigIeP2PAssocReq ( 0x0048 )


    static const tTLVDefn TLVS_P2PAssocRes[ ] = {
        {offsetof(tDot11fIEP2PAssocRes, P2PStatus), offsetof(tDot11fTLVP2PStatus, present), "P2PStatus", SigTlvP2PStatus, DOT11F_TLV_P2PSTATUS, 0, 4, 4, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PAssocRes, ExtendedListenTiming), offsetof(tDot11fTLVExtendedListenTiming, present), "ExtendedListenTiming", SigTlvExtendedListenTiming, DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PAssocRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PAssocRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PAssocRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PAssocRes. */

#define SigIeP2PAssocRes ( 0x0049 )


    static const tTLVDefn TLVS_P2PBeacon[ ] = {
        {offsetof(tDot11fIEP2PBeacon, P2PCapability), offsetof(tDot11fTLVP2PCapability, present), "P2PCapability", SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PBeacon, P2PDeviceId), offsetof(tDot11fTLVP2PDeviceId, present), "P2PDeviceId", SigTlvP2PDeviceId, DOT11F_TLV_P2PDEVICEID, 0, 9, 9, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PBeacon, NoticeOfAbsence), offsetof(tDot11fTLVNoticeOfAbsence, present), "NoticeOfAbsence", SigTlvNoticeOfAbsence, DOT11F_TLV_NOTICEOFABSENCE, 0, 5, 41, 0, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PBeacon(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PBeacon *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PBeacon,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PBeacon. */

#define SigIeP2PBeacon ( 0x004a )


    static const tTLVDefn TLVS_P2PBeaconProbeRes[ ] = {
        {offsetof(tDot11fIEP2PBeaconProbeRes, P2PCapability), offsetof(tDot11fTLVP2PCapability, present), "P2PCapability", SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PBeaconProbeRes, P2PDeviceId), offsetof(tDot11fTLVP2PDeviceId, present), "P2PDeviceId", SigTlvP2PDeviceId, DOT11F_TLV_P2PDEVICEID, 0, 9, 9, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PBeaconProbeRes, ExtendedListenTiming), offsetof(tDot11fTLVExtendedListenTiming, present), "ExtendedListenTiming", SigTlvExtendedListenTiming, DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PBeaconProbeRes, NoticeOfAbsence), offsetof(tDot11fTLVNoticeOfAbsence, present), "NoticeOfAbsence", SigTlvNoticeOfAbsence, DOT11F_TLV_NOTICEOFABSENCE, 0, 5, 41, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PBeaconProbeRes, P2PDeviceInfo), offsetof(tDot11fTLVP2PDeviceInfo, present), "P2PDeviceInfo", SigTlvP2PDeviceInfo, DOT11F_TLV_P2PDEVICEINFO, 0, 19, 55, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PBeaconProbeRes, P2PGroupInfo), offsetof(tDot11fTLVP2PGroupInfo, present), "P2PGroupInfo", SigTlvP2PGroupInfo, DOT11F_TLV_P2PGROUPINFO, 0, 3, 1027, 0, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PBeaconProbeRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PBeaconProbeRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PBeaconProbeRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PBeaconProbeRes. */

#define SigIeP2PBeaconProbeRes ( 0x004b )


    static const tTLVDefn TLVS_P2PDeAuth[ ] = {
        {offsetof(tDot11fIEP2PDeAuth, MinorReasonCode), offsetof(tDot11fTLVMinorReasonCode, present), "MinorReasonCode", SigTlvMinorReasonCode, DOT11F_TLV_MINORREASONCODE, 0, 4, 4, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PDeAuth(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PDeAuth *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PDeAuth,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PDeAuth. */

#define SigIeP2PDeAuth ( 0x004c )


    static const tTLVDefn TLVS_P2PDeviceDiscoverabilityReq[ ] = {
        {offsetof(tDot11fIEP2PDeviceDiscoverabilityReq, P2PDeviceId), offsetof(tDot11fTLVP2PDeviceId, present), "P2PDeviceId", SigTlvP2PDeviceId, DOT11F_TLV_P2PDEVICEID, 0, 9, 9, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PDeviceDiscoverabilityReq, P2PGroupId), offsetof(tDot11fTLVP2PGroupId, present), "P2PGroupId", SigTlvP2PGroupId, DOT11F_TLV_P2PGROUPID, 0, 9, 41, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PDeviceDiscoverabilityReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PDeviceDiscoverabilityReq *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PDeviceDiscoverabilityReq,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PDeviceDiscoverabilityReq. */

#define SigIeP2PDeviceDiscoverabilityReq ( 0x004d )


    static const tTLVDefn TLVS_P2PDeviceDiscoverabilityRes[ ] = {
        {offsetof(tDot11fIEP2PDeviceDiscoverabilityRes, P2PStatus), offsetof(tDot11fTLVP2PStatus, present), "P2PStatus", SigTlvP2PStatus, DOT11F_TLV_P2PSTATUS, 0, 4, 4, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PDeviceDiscoverabilityRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PDeviceDiscoverabilityRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PDeviceDiscoverabilityRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PDeviceDiscoverabilityRes. */

#define SigIeP2PDeviceDiscoverabilityRes ( 0x004e )


    static const tTLVDefn TLVS_P2PDisAssoc[ ] = {
        {offsetof(tDot11fIEP2PDisAssoc, MinorReasonCode), offsetof(tDot11fTLVMinorReasonCode, present), "MinorReasonCode", SigTlvMinorReasonCode, DOT11F_TLV_MINORREASONCODE, 0, 4, 4, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PDisAssoc(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PDisAssoc *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PDisAssoc,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PDisAssoc. */

#define SigIeP2PDisAssoc ( 0x004f )


    static const tTLVDefn TLVS_P2PGONegCnf[ ] = {
        {offsetof(tDot11fIEP2PGONegCnf, P2PStatus), offsetof(tDot11fTLVP2PStatus, present), "P2PStatus", SigTlvP2PStatus, DOT11F_TLV_P2PSTATUS, 0, 4, 4, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegCnf, P2PCapability), offsetof(tDot11fTLVP2PCapability, present), "P2PCapability", SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegCnf, OperatingChannel), offsetof(tDot11fTLVOperatingChannel, present), "OperatingChannel", SigTlvOperatingChannel, DOT11F_TLV_OPERATINGCHANNEL, 0, 8, 8, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegCnf, ChannelList), offsetof(tDot11fTLVChannelList, present), "ChannelList", SigTlvChannelList, DOT11F_TLV_CHANNELLIST, 0, 6, 257, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegCnf, P2PGroupId), offsetof(tDot11fTLVP2PGroupId, present), "P2PGroupId", SigTlvP2PGroupId, DOT11F_TLV_P2PGROUPID, 0, 9, 41, 0, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PGONegCnf(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PGONegCnf *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PGONegCnf,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PGONegCnf. */

#define SigIeP2PGONegCnf ( 0x0050 )


    static const tTLVDefn TLVS_P2PGONegReq[ ] = {
        {offsetof(tDot11fIEP2PGONegReq, P2PCapability), offsetof(tDot11fTLVP2PCapability, present), "P2PCapability", SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegReq, GOIntent), offsetof(tDot11fTLVGOIntent, present), "GOIntent", SigTlvGOIntent, DOT11F_TLV_GOINTENT, 0, 4, 4, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegReq, ConfigurationTimeout), offsetof(tDot11fTLVConfigurationTimeout, present), "ConfigurationTimeout", SigTlvConfigurationTimeout, DOT11F_TLV_CONFIGURATIONTIMEOUT, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegReq, ListenChannel), offsetof(tDot11fTLVListenChannel, present), "ListenChannel", SigTlvListenChannel, DOT11F_TLV_LISTENCHANNEL, 0, 8, 8, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegReq, ExtendedListenTiming), offsetof(tDot11fTLVExtendedListenTiming, present), "ExtendedListenTiming", SigTlvExtendedListenTiming, DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegReq, IntendedP2PInterfaceAddress), offsetof(tDot11fTLVIntendedP2PInterfaceAddress, present), "IntendedP2PInterfaceAddress", SigTlvIntendedP2PInterfaceAddress, DOT11F_TLV_INTENDEDP2PINTERFACEADDRESS, 0, 9, 9, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegReq, ChannelList), offsetof(tDot11fTLVChannelList, present), "ChannelList", SigTlvChannelList, DOT11F_TLV_CHANNELLIST, 0, 6, 257, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegReq, P2PDeviceInfo), offsetof(tDot11fTLVP2PDeviceInfo, present), "P2PDeviceInfo", SigTlvP2PDeviceInfo, DOT11F_TLV_P2PDEVICEINFO, 0, 19, 55, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegReq, OperatingChannel), offsetof(tDot11fTLVOperatingChannel, present), "OperatingChannel", SigTlvOperatingChannel, DOT11F_TLV_OPERATINGCHANNEL, 0, 8, 8, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PGONegReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PGONegReq *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PGONegReq,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PGONegReq. */

#define SigIeP2PGONegReq ( 0x0051 )


    static const tTLVDefn TLVS_P2PGONegRes[ ] = {
        {offsetof(tDot11fIEP2PGONegRes, P2PStatus), offsetof(tDot11fTLVP2PStatus, present), "P2PStatus", SigTlvP2PStatus, DOT11F_TLV_P2PSTATUS, 0, 4, 4, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegRes, P2PCapability), offsetof(tDot11fTLVP2PCapability, present), "P2PCapability", SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegRes, GOIntent), offsetof(tDot11fTLVGOIntent, present), "GOIntent", SigTlvGOIntent, DOT11F_TLV_GOINTENT, 0, 4, 4, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegRes, ConfigurationTimeout), offsetof(tDot11fTLVConfigurationTimeout, present), "ConfigurationTimeout", SigTlvConfigurationTimeout, DOT11F_TLV_CONFIGURATIONTIMEOUT, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegRes, OperatingChannel), offsetof(tDot11fTLVOperatingChannel, present), "OperatingChannel", SigTlvOperatingChannel, DOT11F_TLV_OPERATINGCHANNEL, 0, 8, 8, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegRes, IntendedP2PInterfaceAddress), offsetof(tDot11fTLVIntendedP2PInterfaceAddress, present), "IntendedP2PInterfaceAddress", SigTlvIntendedP2PInterfaceAddress, DOT11F_TLV_INTENDEDP2PINTERFACEADDRESS, 0, 9, 9, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegRes, ChannelList), offsetof(tDot11fTLVChannelList, present), "ChannelList", SigTlvChannelList, DOT11F_TLV_CHANNELLIST, 0, 6, 257, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegRes, P2PDeviceInfo), offsetof(tDot11fTLVP2PDeviceInfo, present), "P2PDeviceInfo", SigTlvP2PDeviceInfo, DOT11F_TLV_P2PDEVICEINFO, 0, 19, 55, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PGONegRes, P2PGroupId), offsetof(tDot11fTLVP2PGroupId, present), "P2PGroupId", SigTlvP2PGroupId, DOT11F_TLV_P2PGROUPID, 0, 9, 41, 0, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PGONegRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PGONegRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PGONegRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PGONegRes. */

#define SigIeP2PGONegRes ( 0x0052 )


    static const tTLVDefn TLVS_P2PGONegWPS[ ] = {
        {offsetof(tDot11fIEP2PGONegWPS, Version), offsetof(tDot11fTLVVersion, present), "Version", SigTlvVersion, DOT11F_TLV_VERSION, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEP2PGONegWPS, DevicePasswordID), offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID", SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID, 0, 6, 6, 1, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PGONegWPS(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PGONegWPS *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PGONegWPS,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PGONegWPS. */

#define SigIeP2PGONegWPS ( 0x0053 )


tANI_U32 dot11fUnpackIeP2PIEOpaque(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PIEOpaque *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_data = (tANI_U8)( ielen );
    if (ielen > 249){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->data, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeP2PIEOpaque. */

#define SigIeP2PIEOpaque ( 0x0054 )


    static const tTLVDefn TLVS_P2PInvitationReq[ ] = {
        {offsetof(tDot11fIEP2PInvitationReq, ConfigurationTimeout), offsetof(tDot11fTLVConfigurationTimeout, present), "ConfigurationTimeout", SigTlvConfigurationTimeout, DOT11F_TLV_CONFIGURATIONTIMEOUT, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PInvitationReq, InvitationFlags), offsetof(tDot11fTLVInvitationFlags, present), "InvitationFlags", SigTlvInvitationFlags, DOT11F_TLV_INVITATIONFLAGS, 0, 4, 4, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PInvitationReq, OperatingChannel), offsetof(tDot11fTLVOperatingChannel, present), "OperatingChannel", SigTlvOperatingChannel, DOT11F_TLV_OPERATINGCHANNEL, 0, 8, 8, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PInvitationReq, P2PGroupBssid), offsetof(tDot11fTLVP2PGroupBssid, present), "P2PGroupBssid", SigTlvP2PGroupBssid, DOT11F_TLV_P2PGROUPBSSID, 0, 9, 9, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PInvitationReq, ChannelList), offsetof(tDot11fTLVChannelList, present), "ChannelList", SigTlvChannelList, DOT11F_TLV_CHANNELLIST, 0, 6, 257, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PInvitationReq, P2PGroupId), offsetof(tDot11fTLVP2PGroupId, present), "P2PGroupId", SigTlvP2PGroupId, DOT11F_TLV_P2PGROUPID, 0, 9, 41, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PInvitationReq, P2PDeviceInfo), offsetof(tDot11fTLVP2PDeviceInfo, present), "P2PDeviceInfo", SigTlvP2PDeviceInfo, DOT11F_TLV_P2PDEVICEINFO, 0, 19, 55, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PInvitationReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PInvitationReq *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PInvitationReq,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PInvitationReq. */

#define SigIeP2PInvitationReq ( 0x0055 )


    static const tTLVDefn TLVS_P2PInvitationRes[ ] = {
        {offsetof(tDot11fIEP2PInvitationRes, P2PStatus), offsetof(tDot11fTLVP2PStatus, present), "P2PStatus", SigTlvP2PStatus, DOT11F_TLV_P2PSTATUS, 0, 4, 4, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PInvitationRes, ConfigurationTimeout), offsetof(tDot11fTLVConfigurationTimeout, present), "ConfigurationTimeout", SigTlvConfigurationTimeout, DOT11F_TLV_CONFIGURATIONTIMEOUT, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PInvitationRes, OperatingChannel), offsetof(tDot11fTLVOperatingChannel, present), "OperatingChannel", SigTlvOperatingChannel, DOT11F_TLV_OPERATINGCHANNEL, 0, 8, 8, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PInvitationRes, P2PGroupBssid), offsetof(tDot11fTLVP2PGroupBssid, present), "P2PGroupBssid", SigTlvP2PGroupBssid, DOT11F_TLV_P2PGROUPBSSID, 0, 9, 9, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PInvitationRes, ChannelList), offsetof(tDot11fTLVChannelList, present), "ChannelList", SigTlvChannelList, DOT11F_TLV_CHANNELLIST, 0, 6, 257, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PInvitationRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PInvitationRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PInvitationRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PInvitationRes. */

#define SigIeP2PInvitationRes ( 0x0056 )


    static const tTLVDefn TLVS_P2PNoticeOfAbsence[ ] = {
        {offsetof(tDot11fIEP2PNoticeOfAbsence, NoticeOfAbsence), offsetof(tDot11fTLVNoticeOfAbsence, present), "NoticeOfAbsence", SigTlvNoticeOfAbsence, DOT11F_TLV_NOTICEOFABSENCE, 0, 5, 41, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PNoticeOfAbsence(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PNoticeOfAbsence *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PNoticeOfAbsence,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PNoticeOfAbsence. */

#define SigIeP2PNoticeOfAbsence ( 0x0057 )


    static const tTLVDefn TLVS_P2PPresenceResponse[ ] = {
        {offsetof(tDot11fIEP2PPresenceResponse, P2PStatus), offsetof(tDot11fTLVP2PStatus, present), "P2PStatus", SigTlvP2PStatus, DOT11F_TLV_P2PSTATUS, 0, 4, 4, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PPresenceResponse, NoticeOfAbsence), offsetof(tDot11fTLVNoticeOfAbsence, present), "NoticeOfAbsence", SigTlvNoticeOfAbsence, DOT11F_TLV_NOTICEOFABSENCE, 0, 5, 41, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PPresenceResponse(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PPresenceResponse *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PPresenceResponse,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PPresenceResponse. */

#define SigIeP2PPresenceResponse ( 0x0058 )


    static const tTLVDefn TLVS_P2PProbeReq[ ] = {
        {offsetof(tDot11fIEP2PProbeReq, P2PCapability), offsetof(tDot11fTLVP2PCapability, present), "P2PCapability", SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PProbeReq, P2PDeviceId), offsetof(tDot11fTLVP2PDeviceId, present), "P2PDeviceId", SigTlvP2PDeviceId, DOT11F_TLV_P2PDEVICEID, 0, 9, 9, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PProbeReq, ListenChannel), offsetof(tDot11fTLVListenChannel, present), "ListenChannel", SigTlvListenChannel, DOT11F_TLV_LISTENCHANNEL, 0, 8, 8, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PProbeReq, ExtendedListenTiming), offsetof(tDot11fTLVExtendedListenTiming, present), "ExtendedListenTiming", SigTlvExtendedListenTiming, DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PProbeReq, OperatingChannel), offsetof(tDot11fTLVOperatingChannel, present), "OperatingChannel", SigTlvOperatingChannel, DOT11F_TLV_OPERATINGCHANNEL, 0, 8, 8, 0, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PProbeReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PProbeReq *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PProbeReq,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PProbeReq. */

#define SigIeP2PProbeReq ( 0x0059 )


    static const tTLVDefn TLVS_P2PProbeRes[ ] = {
        {offsetof(tDot11fIEP2PProbeRes, P2PCapability), offsetof(tDot11fTLVP2PCapability, present), "P2PCapability", SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PProbeRes, ExtendedListenTiming), offsetof(tDot11fTLVExtendedListenTiming, present), "ExtendedListenTiming", SigTlvExtendedListenTiming, DOT11F_TLV_EXTENDEDLISTENTIMING, 0, 7, 7, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PProbeRes, NoticeOfAbsence), offsetof(tDot11fTLVNoticeOfAbsence, present), "NoticeOfAbsence", SigTlvNoticeOfAbsence, DOT11F_TLV_NOTICEOFABSENCE, 0, 5, 41, 0, 1, 2, 0, },
        {offsetof(tDot11fIEP2PProbeRes, P2PDeviceInfo), offsetof(tDot11fTLVP2PDeviceInfo, present), "P2PDeviceInfo", SigTlvP2PDeviceInfo, DOT11F_TLV_P2PDEVICEINFO, 0, 19, 55, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PProbeRes, P2PGroupInfo), offsetof(tDot11fTLVP2PGroupInfo, present), "P2PGroupInfo", SigTlvP2PGroupInfo, DOT11F_TLV_P2PGROUPINFO, 0, 3, 1027, 0, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PProbeRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PProbeRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PProbeRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PProbeRes. */

#define SigIeP2PProbeRes ( 0x005a )


    static const tTLVDefn TLVS_P2PProvisionDiscoveryReq[ ] = {
        {offsetof(tDot11fIEP2PProvisionDiscoveryReq, P2PCapability), offsetof(tDot11fTLVP2PCapability, present), "P2PCapability", SigTlvP2PCapability, DOT11F_TLV_P2PCAPABILITY, 0, 5, 5, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PProvisionDiscoveryReq, P2PDeviceInfo), offsetof(tDot11fTLVP2PDeviceInfo, present), "P2PDeviceInfo", SigTlvP2PDeviceInfo, DOT11F_TLV_P2PDEVICEINFO, 0, 19, 55, 1, 1, 2, 0, },
        {offsetof(tDot11fIEP2PProvisionDiscoveryReq, P2PGroupId), offsetof(tDot11fTLVP2PGroupId, present), "P2PGroupId", SigTlvP2PGroupId, DOT11F_TLV_P2PGROUPID, 0, 9, 41, 1, 1, 2, 0, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PProvisionDiscoveryReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PProvisionDiscoveryReq *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PProvisionDiscoveryReq,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PProvisionDiscoveryReq. */

#define SigIeP2PProvisionDiscoveryReq ( 0x005b )


    static const tTLVDefn TLVS_P2PWSCProvisionDiscoveryRes[ ] = {
        {offsetof(tDot11fIEP2PWSCProvisionDiscoveryRes, ConfigMethods), offsetof(tDot11fTLVConfigMethods, present), "ConfigMethods", SigTlvConfigMethods, DOT11F_TLV_CONFIGMETHODS, 0, 6, 6, 1, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeP2PWSCProvisionDiscoveryRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEP2PWSCProvisionDiscoveryRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_P2PWSCProvisionDiscoveryRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeP2PWSCProvisionDiscoveryRes. */

#define SigIeP2PWSCProvisionDiscoveryRes ( 0x005c )


tANI_U32 dot11fUnpackIePowerCaps(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEPowerCaps *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->minTxPower = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->maxTxPower = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIePowerCaps. */

#define SigIePowerCaps ( 0x005d )


tANI_U32 dot11fUnpackIePowerConstraints(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEPowerConstraints *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->localPowerConstraints = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIePowerConstraints. */

#define SigIePowerConstraints ( 0x005e )


tANI_U32 dot11fUnpackIeQBSSLoad(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEQBSSLoad *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->stacount, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    pDst->chautil = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    framesntohs(pCtx, &pDst->avail, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeQBSSLoad. */

#define SigIeQBSSLoad ( 0x005f )


tANI_U32 dot11fUnpackIeQOSCapsAp(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEQOSCapsAp *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp57__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    tmp57__ = *pBuf;
    pDst->reserved = tmp57__ >> 0 & 0x1;
    pDst->txopreq = tmp57__ >> 1 & 0x1;
    pDst->qreq = tmp57__ >> 2 & 0x1;
    pDst->qack = tmp57__ >> 3 & 0x1;
    pDst->count = tmp57__ >> 4 & 0xf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeQOSCapsAp. */

#define SigIeQOSCapsAp ( 0x0060 )


tANI_U32 dot11fUnpackIeQOSCapsStation(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEQOSCapsStation *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp58__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    tmp58__ = *pBuf;
    pDst->more_data_ack = tmp58__ >> 0 & 0x1;
    pDst->max_sp_length = tmp58__ >> 1 & 0x3;
    pDst->qack = tmp58__ >> 3 & 0x1;
    pDst->acbe_uapsd = tmp58__ >> 4 & 0x1;
    pDst->acbk_uapsd = tmp58__ >> 5 & 0x1;
    pDst->acvi_uapsd = tmp58__ >> 6 & 0x1;
    pDst->acvo_uapsd = tmp58__ >> 7 & 0x1;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeQOSCapsStation. */

#define SigIeQOSCapsStation ( 0x0061 )


tANI_U32 dot11fUnpackIeQuiet(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEQuiet *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->count = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->period = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    framesntohs(pCtx, &pDst->duration, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    framesntohs(pCtx, &pDst->offset, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeQuiet. */

#define SigIeQuiet ( 0x0062 )


tANI_U32 dot11fUnpackIeRCPIIE(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIERCPIIE *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->rcpi = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeRCPIIE. */

#define SigIeRCPIIE ( 0x0063 )


    static const tFFDefn FFS_RICDataDesc[ ] = {
        { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_RICDataDesc[ ] = {
        {offsetof(tDot11fIERICDataDesc, RICData), offsetof(tDot11fIERICData, present), 0, "RICData" , 0, 6, 6, SigIeRICData, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RICDATA, 1, },
        {offsetof(tDot11fIERICDataDesc, RICDescriptor), offsetof(tDot11fIERICDescriptor, present), 0, "RICDescriptor" , 0, 3, 258, SigIeRICDescriptor, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RICDESCRIPTOR, 0, },
        {offsetof(tDot11fIERICDataDesc, TSPEC), offsetof(tDot11fIETSPEC, present), 0, "TSPEC" , 0, 57, 57, SigIeTSPEC, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TSPEC, 0, },
        {offsetof(tDot11fIERICDataDesc, TCLAS), offsetof(tDot11fIETCLAS, present), offsetof(tDot11fIERICDataDesc, num_TCLAS), "TCLAS" , 2, 7, 45, SigIeTCLAS, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TCLAS, 0, },
        {offsetof(tDot11fIERICDataDesc, TCLASSPROC), offsetof(tDot11fIETCLASSPROC, present), 0, "TCLASSPROC" , 0, 3, 3, SigIeTCLASSPROC, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TCLASSPROC, 0, },
        {offsetof(tDot11fIERICDataDesc, TSDelay), offsetof(tDot11fIETSDelay, present), 0, "TSDelay" , 0, 6, 6, SigIeTSDelay, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TSDELAY, 0, },
        {offsetof(tDot11fIERICDataDesc, Schedule), offsetof(tDot11fIESchedule, present), 0, "Schedule" , 0, 16, 16, SigIeSchedule, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SCHEDULE, 0, },
        {offsetof(tDot11fIERICDataDesc, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC, present), 0, "WMMTSPEC" , 0, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2}, 5, DOT11F_EID_WMMTSPEC, 0, },
        {offsetof(tDot11fIERICDataDesc, WMMTCLAS), offsetof(tDot11fIEWMMTCLAS, present), offsetof(tDot11fIERICDataDesc, num_WMMTCLAS), "WMMTCLAS" , 2, 13, 51, SigIeWMMTCLAS, {0, 80, 242, 2, 6}, 5, DOT11F_EID_WMMTCLAS, 0, },
        {offsetof(tDot11fIERICDataDesc, WMMTCLASPROC), offsetof(tDot11fIEWMMTCLASPROC, present), 0, "WMMTCLASPROC" , 0, 9, 9, SigIeWMMTCLASPROC, {0, 80, 242, 2, 7}, 5, DOT11F_EID_WMMTCLASPROC, 0, },
        {offsetof(tDot11fIERICDataDesc, WMMTSDelay), offsetof(tDot11fIEWMMTSDelay, present), 0, "WMMTSDelay" , 0, 12, 12, SigIeWMMTSDelay, {0, 80, 242, 2, 8}, 5, DOT11F_EID_WMMTSDELAY, 0, },
        {offsetof(tDot11fIERICDataDesc, WMMSchedule), offsetof(tDot11fIEWMMSchedule, present), 0, "WMMSchedule" , 0, 22, 22, SigIeWMMSchedule, {0, 80, 242, 2, 9}, 5, DOT11F_EID_WMMSCHEDULE, 0, },
        {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },
    };

tANI_U32 dot11fUnpackIeRICDataDesc(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIERICDataDesc *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    (void)pCtx;
    status |= UnpackCore(pCtx,
                     pBuf,
                     ielen,
                     FFS_RICDataDesc,
                     IES_RICDataDesc,
                     ( tANI_U8* )pDst,
                     sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeRICDataDesc. */

#define SigIeRICDataDesc ( 0x0064 )


tANI_U32 dot11fUnpackIeRSN(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIERSN *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U16 tmp59__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->version, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    if (pDst->version != 0x1)
    {
            pDst->present = 0;
            return ( status | DOT11F_BAD_FIXED_VALUE );
    }
    DOT11F_MEMCPY(pCtx, pDst->gp_cipher_suite, pBuf, 4);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    if ( ! ielen )
    {
        pDst->pwise_cipher_suite_count = 0U;
        pDst->akm_suite_count = 0U;
        pDst->pmkid_count = 0U;
        return 0U;
    }
    else
    {
        framesntohs(pCtx, &pDst->pwise_cipher_suite_count, pBuf, 0);
        pBuf += 2;
        ielen -= (tANI_U8)2;
    }
    if (pDst->pwise_cipher_suite_count > 4){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->pwise_cipher_suites, pBuf, ( pDst->pwise_cipher_suite_count * 4 ) );
    pBuf += ( pDst->pwise_cipher_suite_count * 4 );
    ielen -= ( pDst->pwise_cipher_suite_count * 4 );
    if ( ! ielen )
    {
        pDst->akm_suite_count = 0U;
        pDst->pmkid_count = 0U;
        return 0U;
    }
    else
    {
        framesntohs(pCtx, &pDst->akm_suite_count, pBuf, 0);
        pBuf += 2;
        ielen -= (tANI_U8)2;
    }
    if (pDst->akm_suite_count > 4){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->akm_suites, pBuf, ( pDst->akm_suite_count * 4 ) );
    pBuf += ( pDst->akm_suite_count * 4 );
    ielen -= ( pDst->akm_suite_count * 4 );
    framesntohs(pCtx, &tmp59__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->preauth = tmp59__ >> 0 & 0x1;
    pDst->no_pwise = tmp59__ >> 1 & 0x1;
    pDst->PTKSA_replay_counter = tmp59__ >> 2 & 0x3;
    pDst->GTKSA_replay_counter = tmp59__ >> 4 & 0x3;
    pDst->reserved = tmp59__ >> 6 & 0x3ff;
    if ( ! ielen )
    {
        pDst->pmkid_count = 0U;
        return 0U;
    }
    else
    {
        framesntohs(pCtx, &pDst->pmkid_count, pBuf, 0);
        pBuf += 2;
        ielen -= (tANI_U8)2;
    }
    if (pDst->pmkid_count > 4){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->pmkid, pBuf, ( pDst->pmkid_count * 16 ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeRSN. */

#define SigIeRSN ( 0x0065 )


tANI_U32 dot11fUnpackIeRSNIIE(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIERSNIIE *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->rsni = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeRSNIIE. */

#define SigIeRSNIIE ( 0x0066 )


tANI_U32 dot11fUnpackIeRSNOpaque(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIERSNOpaque *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_data = (tANI_U8)( ielen );
    if (ielen > 253){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->data, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeRSNOpaque. */

#define SigIeRSNOpaque ( 0x0067 )


tANI_U32 dot11fUnpackIeSuppChannels(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIESuppChannels *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_bands = (tANI_U8)( ielen / 2 );
    if (ielen / 2 > 48){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->bands, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeSuppChannels. */

#define SigIeSuppChannels ( 0x0068 )


tANI_U32 dot11fUnpackIeSuppRates(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIESuppRates *pDst)
{
    tANI_U8 i;
    tANI_U8 rate_indx = 0;
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    for (i = 0; i < ielen; i++) {
        if ((DOT11F_IS_BG_RATE(pBuf[i] & 0x7F)) && 
            (rate_indx < 12)) {
            pDst->rates[rate_indx++] = pBuf[i];
        }
    }

    if(rate_indx == 0) {
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    pDst->num_rates = rate_indx;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeSuppRates. */

#define SigIeSuppRates ( 0x0069 )


tANI_U32 dot11fUnpackIeTIM(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIETIM *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->dtim_count = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->dtim_period = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->bmpctl = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->num_vbmp = (tANI_U8)( ielen );
    if (ielen > 251){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->vbmp, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeTIM. */

#define SigIeTIM ( 0x006a )


tANI_U32 dot11fUnpackIeTPCReport(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIETPCReport *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->tx_power = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->link_margin = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeTPCReport. */

#define SigIeTPCReport ( 0x006b )


tANI_U32 dot11fUnpackIeTPCRequest(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIETPCRequest *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeTPCRequest. */

#define SigIeTPCRequest ( 0x006c )


tANI_U32 dot11fUnpackIeWAPI(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWAPI *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U16 tmp60__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->version, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    if (pDst->version != 0x1)
    {
            pDst->present = 0;
            return ( status | DOT11F_BAD_FIXED_VALUE );
    }
    framesntohs(pCtx, &pDst->akm_suite_count, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    if (pDst->akm_suite_count > 4){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->akm_suites, pBuf, ( pDst->akm_suite_count * 4 ) );
    pBuf += ( pDst->akm_suite_count * 4 );
    ielen -= ( pDst->akm_suite_count * 4 );
    framesntohs(pCtx, &pDst->unicast_cipher_suite_count, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    if (pDst->unicast_cipher_suite_count > 4){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->unicast_cipher_suites, pBuf, ( pDst->unicast_cipher_suite_count * 4 ) );
    pBuf += ( pDst->unicast_cipher_suite_count * 4 );
    ielen -= ( pDst->unicast_cipher_suite_count * 4 );
    DOT11F_MEMCPY(pCtx, pDst->multicast_cipher_suite, pBuf, 4);
    pBuf += 4;
    ielen -= (tANI_U8)4;
    framesntohs(pCtx, &tmp60__, pBuf, 0);
    pBuf += 2;
    ielen -= 2;
    pDst->preauth = tmp60__ >> 0 & 0x1;
    pDst->reserved = tmp60__ >> 1 & 0x7fff;
    if ( ! ielen )
    {
        pDst->bkid_count = 0U;
        return 0U;
    }
    else
    {
        framesntohs(pCtx, &pDst->bkid_count, pBuf, 0);
        pBuf += 2;
        ielen -= (tANI_U8)2;
    }
    if (pDst->bkid_count > 4){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->bkid, pBuf, ( pDst->bkid_count * 16 ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWAPI. */

#define SigIeWAPI ( 0x006d )


tANI_U32 dot11fUnpackIeWAPIOpaque(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWAPIOpaque *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_data = (tANI_U8)( ielen );
    if (ielen > 253){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->data, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWAPIOpaque. */

#define SigIeWAPIOpaque ( 0x006e )


tANI_U32 dot11fUnpackIeWFATPC(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWFATPC *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->txPower = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->linkMargin = *pBuf;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWFATPC. */

#define SigIeWFATPC ( 0x006f )


tANI_U32 dot11fUnpackIeWMMCaps(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWMMCaps *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp61__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->version = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    if (pDst->version != 0x1)
    {
            pDst->present = 0;
            return ( status | DOT11F_BAD_FIXED_VALUE );
    }
    tmp61__ = *pBuf;
    pDst->reserved = tmp61__ >> 0 & 0xf;
    pDst->qack = tmp61__ >> 4 & 0x1;
    pDst->queue_request = tmp61__ >> 5 & 0x1;
    pDst->txop_request = tmp61__ >> 6 & 0x1;
    pDst->more_ack = tmp61__ >> 7 & 0x1;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWMMCaps. */

#define SigIeWMMCaps ( 0x0070 )


tANI_U32 dot11fUnpackIeWMMInfoAp(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWMMInfoAp *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp62__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->version = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    tmp62__ = *pBuf;
    pDst->param_set_count = tmp62__ >> 0 & 0xf;
    pDst->reserved = tmp62__ >> 4 & 0x7;
    pDst->uapsd = tmp62__ >> 7 & 0x1;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWMMInfoAp. */

#define SigIeWMMInfoAp ( 0x0071 )


tANI_U32 dot11fUnpackIeWMMInfoStation(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWMMInfoStation *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp63__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->version = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    tmp63__ = *pBuf;
    pDst->acvo_uapsd = tmp63__ >> 0 & 0x1;
    pDst->acvi_uapsd = tmp63__ >> 1 & 0x1;
    pDst->acbk_uapsd = tmp63__ >> 2 & 0x1;
    pDst->acbe_uapsd = tmp63__ >> 3 & 0x1;
    pDst->reserved1 = tmp63__ >> 4 & 0x1;
    pDst->max_sp_length = tmp63__ >> 5 & 0x3;
    pDst->reserved2 = tmp63__ >> 7 & 0x1;
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWMMInfoStation. */

#define SigIeWMMInfoStation ( 0x0072 )


tANI_U32 dot11fUnpackIeWMMParams(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWMMParams *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    tANI_U8 tmp64__;
    tANI_U8 tmp65__;
    tANI_U8 tmp66__;
    tANI_U8 tmp67__;
    tANI_U8 tmp68__;
    tANI_U8 tmp69__;
    tANI_U8 tmp70__;
    tANI_U8 tmp71__;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->version = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    if (pDst->version != 0x1)
    {
            pDst->present = 0;
            return ( status | DOT11F_BAD_FIXED_VALUE );
    }
    pDst->qosInfo = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    pDst->reserved2 = *pBuf;
    pBuf += 1;
    ielen -= (tANI_U8)1;
    tmp64__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbe_aifsn = tmp64__ >> 0 & 0xf;
    pDst->acbe_acm = tmp64__ >> 4 & 0x1;
    pDst->acbe_aci = tmp64__ >> 5 & 0x3;
    pDst->unused1 = tmp64__ >> 7 & 0x1;
    tmp65__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbe_acwmin = tmp65__ >> 0 & 0xf;
    pDst->acbe_acwmax = tmp65__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acbe_txoplimit, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    tmp66__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbk_aifsn = tmp66__ >> 0 & 0xf;
    pDst->acbk_acm = tmp66__ >> 4 & 0x1;
    pDst->acbk_aci = tmp66__ >> 5 & 0x3;
    pDst->unused2 = tmp66__ >> 7 & 0x1;
    tmp67__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acbk_acwmin = tmp67__ >> 0 & 0xf;
    pDst->acbk_acwmax = tmp67__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acbk_txoplimit, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    tmp68__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvi_aifsn = tmp68__ >> 0 & 0xf;
    pDst->acvi_acm = tmp68__ >> 4 & 0x1;
    pDst->acvi_aci = tmp68__ >> 5 & 0x3;
    pDst->unused3 = tmp68__ >> 7 & 0x1;
    tmp69__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvi_acwmin = tmp69__ >> 0 & 0xf;
    pDst->acvi_acwmax = tmp69__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acvi_txoplimit, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    tmp70__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvo_aifsn = tmp70__ >> 0 & 0xf;
    pDst->acvo_acm = tmp70__ >> 4 & 0x1;
    pDst->acvo_aci = tmp70__ >> 5 & 0x3;
    pDst->unused4 = tmp70__ >> 7 & 0x1;
    tmp71__ = *pBuf;
    pBuf += 1;
    ielen -= 1;
    pDst->acvo_acwmin = tmp71__ >> 0 & 0xf;
    pDst->acvo_acwmax = tmp71__ >> 4 & 0xf;
    framesntohs(pCtx, &pDst->acvo_txoplimit, pBuf, 0);
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWMMParams. */

#define SigIeWMMParams ( 0x0073 )


tANI_U32 dot11fUnpackIeWPA(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWPA *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    framesntohs(pCtx, &pDst->version, pBuf, 0);
    pBuf += 2;
    ielen -= (tANI_U8)2;
    if (pDst->version != 0x1)
    {
            pDst->present = 0;
            return ( status | DOT11F_BAD_FIXED_VALUE );
    }
    if ( ! ielen )
    {
        pDst->multicast_cipher_present = 0U;
        pDst->unicast_cipher_count = 0U;
        pDst->auth_suite_count = 0U;
        return 0U;
    }
    else
    {
        pDst->multicast_cipher_present = 1U;
        DOT11F_MEMCPY(pCtx, pDst->multicast_cipher, pBuf, 4);
        pBuf += 4;
        ielen -= (tANI_U8)4;
    }
    if ( ! ielen )
    {
        pDst->unicast_cipher_count = 0U;
        pDst->auth_suite_count = 0U;
        return 0U;
    }
    else
    {
        framesntohs(pCtx, &pDst->unicast_cipher_count, pBuf, 0);
        pBuf += 2;
        ielen -= (tANI_U8)2;
    }
    if (pDst->unicast_cipher_count > 4){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->unicast_ciphers, pBuf, ( pDst->unicast_cipher_count * 4 ) );
    pBuf += ( pDst->unicast_cipher_count * 4 );
    ielen -= ( pDst->unicast_cipher_count * 4 );
    if ( ! ielen )
    {
        pDst->auth_suite_count = 0U;
        return 0U;
    }
    else
    {
        framesntohs(pCtx, &pDst->auth_suite_count, pBuf, 0);
        pBuf += 2;
        ielen -= (tANI_U8)2;
    }
    if (pDst->auth_suite_count > 4){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->auth_suites, pBuf, ( pDst->auth_suite_count * 4 ) );
    pBuf += ( pDst->auth_suite_count * 4 );
    ielen -= ( pDst->auth_suite_count * 4 );
    if ( ! ielen )
    {
        return 0U;
    }
    else
    {
        framesntohs(pCtx, &pDst->caps, pBuf, 0);
    }
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWPA. */

#define SigIeWPA ( 0x0074 )


tANI_U32 dot11fUnpackIeWPAOpaque(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWPAOpaque *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_data = (tANI_U8)( ielen );
    if (ielen > 249){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->data, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWPAOpaque. */

#define SigIeWPAOpaque ( 0x0075 )


    static const tTLVDefn TLVS_WSC[ ] = {
        {offsetof(tDot11fIEWSC, Version), offsetof(tDot11fTLVVersion, present), "Version", SigTlvVersion, DOT11F_TLV_VERSION, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, WPSState), offsetof(tDot11fTLVWPSState, present), "WPSState", SigTlvWPSState, DOT11F_TLV_WPSSTATE, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, APSetupLocked), offsetof(tDot11fTLVAPSetupLocked, present), "APSetupLocked", SigTlvAPSetupLocked, DOT11F_TLV_APSETUPLOCKED, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, SelectedRegistrarConfigMethods), offsetof(tDot11fTLVSelectedRegistrarConfigMethods, present), "SelectedRegistrarConfigMethods", SigTlvSelectedRegistrarConfigMethods, DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, UUID_E), offsetof(tDot11fTLVUUID_E, present), "UUID_E", SigTlvUUID_E, DOT11F_TLV_UUID_E, 0, 20, 20, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, UUID_R), offsetof(tDot11fTLVUUID_R, present), "UUID_R", SigTlvUUID_R, DOT11F_TLV_UUID_R, 0, 20, 20, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, RFBands), offsetof(tDot11fTLVRFBands, present), "RFBands", SigTlvRFBands, DOT11F_TLV_RFBANDS, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, SelectedRegistrar), offsetof(tDot11fTLVSelectedRegistrar, present), "SelectedRegistrar", SigTlvSelectedRegistrar, DOT11F_TLV_SELECTEDREGISTRAR, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, ConfigMethods), offsetof(tDot11fTLVConfigMethods, present), "ConfigMethods", SigTlvConfigMethods, DOT11F_TLV_CONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, AssociationState), offsetof(tDot11fTLVAssociationState, present), "AssociationState", SigTlvAssociationState, DOT11F_TLV_ASSOCIATIONSTATE, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, ConfigurationError), offsetof(tDot11fTLVConfigurationError, present), "ConfigurationError", SigTlvConfigurationError, DOT11F_TLV_CONFIGURATIONERROR, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, Manufacturer), offsetof(tDot11fTLVManufacturer, present), "Manufacturer", SigTlvManufacturer, DOT11F_TLV_MANUFACTURER, 0, 4, 68, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, ModelName), offsetof(tDot11fTLVModelName, present), "ModelName", SigTlvModelName, DOT11F_TLV_MODELNAME, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, ModelNumber), offsetof(tDot11fTLVModelNumber, present), "ModelNumber", SigTlvModelNumber, DOT11F_TLV_MODELNUMBER, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, SerialNumber), offsetof(tDot11fTLVSerialNumber, present), "SerialNumber", SigTlvSerialNumber, DOT11F_TLV_SERIALNUMBER, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, DeviceName), offsetof(tDot11fTLVDeviceName, present), "DeviceName", SigTlvDeviceName, DOT11F_TLV_DEVICENAME, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, DevicePasswordID), offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID", SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, PrimaryDeviceType), offsetof(tDot11fTLVPrimaryDeviceType, present), "PrimaryDeviceType", SigTlvPrimaryDeviceType, DOT11F_TLV_PRIMARYDEVICETYPE, 0, 12, 12, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, RequestType), offsetof(tDot11fTLVRequestType, present), "RequestType", SigTlvRequestType, DOT11F_TLV_REQUESTTYPE, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, ResponseType), offsetof(tDot11fTLVResponseType, present), "ResponseType", SigTlvResponseType, DOT11F_TLV_RESPONSETYPE, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, VendorExtension), offsetof(tDot11fTLVVendorExtension, present), "VendorExtension", SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION, 0, 7, 21, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWSC, RequestDeviceType), offsetof(tDot11fTLVRequestDeviceType, present), "RequestDeviceType", SigTlvRequestDeviceType, DOT11F_TLV_REQUESTDEVICETYPE, 0, 12, 12, 0, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeWSC(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWSC *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_WSC,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeWSC. */

#define SigIeWSC ( 0x0076 )


    static const tTLVDefn TLVS_WscAssocReq[ ] = {
        {offsetof(tDot11fIEWscAssocReq, Version), offsetof(tDot11fTLVVersion, present), "Version", SigTlvVersion, DOT11F_TLV_VERSION, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscAssocReq, RequestType), offsetof(tDot11fTLVRequestType, present), "RequestType", SigTlvRequestType, DOT11F_TLV_REQUESTTYPE, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscAssocReq, VendorExtension), offsetof(tDot11fTLVVendorExtension, present), "VendorExtension", SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION, 0, 7, 21, 0, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeWscAssocReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWscAssocReq *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_WscAssocReq,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeWscAssocReq. */

#define SigIeWscAssocReq ( 0x0077 )


    static const tTLVDefn TLVS_WscAssocRes[ ] = {
        {offsetof(tDot11fIEWscAssocRes, Version), offsetof(tDot11fTLVVersion, present), "Version", SigTlvVersion, DOT11F_TLV_VERSION, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscAssocRes, ResponseType), offsetof(tDot11fTLVResponseType, present), "ResponseType", SigTlvResponseType, DOT11F_TLV_RESPONSETYPE, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscAssocRes, VendorExtension), offsetof(tDot11fTLVVendorExtension, present), "VendorExtension", SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION, 0, 7, 21, 0, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeWscAssocRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWscAssocRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_WscAssocRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeWscAssocRes. */

#define SigIeWscAssocRes ( 0x0078 )


    static const tTLVDefn TLVS_WscBeacon[ ] = {
        {offsetof(tDot11fIEWscBeacon, Version), offsetof(tDot11fTLVVersion, present), "Version", SigTlvVersion, DOT11F_TLV_VERSION, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeacon, WPSState), offsetof(tDot11fTLVWPSState, present), "WPSState", SigTlvWPSState, DOT11F_TLV_WPSSTATE, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeacon, APSetupLocked), offsetof(tDot11fTLVAPSetupLocked, present), "APSetupLocked", SigTlvAPSetupLocked, DOT11F_TLV_APSETUPLOCKED, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeacon, SelectedRegistrar), offsetof(tDot11fTLVSelectedRegistrar, present), "SelectedRegistrar", SigTlvSelectedRegistrar, DOT11F_TLV_SELECTEDREGISTRAR, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeacon, DevicePasswordID), offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID", SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeacon, SelectedRegistrarConfigMethods), offsetof(tDot11fTLVSelectedRegistrarConfigMethods, present), "SelectedRegistrarConfigMethods", SigTlvSelectedRegistrarConfigMethods, DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeacon, UUID_E), offsetof(tDot11fTLVUUID_E, present), "UUID_E", SigTlvUUID_E, DOT11F_TLV_UUID_E, 0, 20, 20, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeacon, RFBands), offsetof(tDot11fTLVRFBands, present), "RFBands", SigTlvRFBands, DOT11F_TLV_RFBANDS, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeacon, VendorExtension), offsetof(tDot11fTLVVendorExtension, present), "VendorExtension", SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION, 0, 7, 21, 0, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeWscBeacon(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWscBeacon *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_WscBeacon,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeWscBeacon. */

#define SigIeWscBeacon ( 0x0079 )


    static const tTLVDefn TLVS_WscBeaconProbeRes[ ] = {
        {offsetof(tDot11fIEWscBeaconProbeRes, Version), offsetof(tDot11fTLVVersion, present), "Version", SigTlvVersion, DOT11F_TLV_VERSION, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, WPSState), offsetof(tDot11fTLVWPSState, present), "WPSState", SigTlvWPSState, DOT11F_TLV_WPSSTATE, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, APSetupLocked), offsetof(tDot11fTLVAPSetupLocked, present), "APSetupLocked", SigTlvAPSetupLocked, DOT11F_TLV_APSETUPLOCKED, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, SelectedRegistrar), offsetof(tDot11fTLVSelectedRegistrar, present), "SelectedRegistrar", SigTlvSelectedRegistrar, DOT11F_TLV_SELECTEDREGISTRAR, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, DevicePasswordID), offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID", SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, SelectedRegistrarConfigMethods), offsetof(tDot11fTLVSelectedRegistrarConfigMethods, present), "SelectedRegistrarConfigMethods", SigTlvSelectedRegistrarConfigMethods, DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, ResponseType), offsetof(tDot11fTLVResponseType, present), "ResponseType", SigTlvResponseType, DOT11F_TLV_RESPONSETYPE, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, UUID_E), offsetof(tDot11fTLVUUID_E, present), "UUID_E", SigTlvUUID_E, DOT11F_TLV_UUID_E, 0, 20, 20, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, Manufacturer), offsetof(tDot11fTLVManufacturer, present), "Manufacturer", SigTlvManufacturer, DOT11F_TLV_MANUFACTURER, 0, 4, 68, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, ModelName), offsetof(tDot11fTLVModelName, present), "ModelName", SigTlvModelName, DOT11F_TLV_MODELNAME, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, ModelNumber), offsetof(tDot11fTLVModelNumber, present), "ModelNumber", SigTlvModelNumber, DOT11F_TLV_MODELNUMBER, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, SerialNumber), offsetof(tDot11fTLVSerialNumber, present), "SerialNumber", SigTlvSerialNumber, DOT11F_TLV_SERIALNUMBER, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, PrimaryDeviceType), offsetof(tDot11fTLVPrimaryDeviceType, present), "PrimaryDeviceType", SigTlvPrimaryDeviceType, DOT11F_TLV_PRIMARYDEVICETYPE, 0, 12, 12, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, DeviceName), offsetof(tDot11fTLVDeviceName, present), "DeviceName", SigTlvDeviceName, DOT11F_TLV_DEVICENAME, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, ConfigMethods), offsetof(tDot11fTLVConfigMethods, present), "ConfigMethods", SigTlvConfigMethods, DOT11F_TLV_CONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, RFBands), offsetof(tDot11fTLVRFBands, present), "RFBands", SigTlvRFBands, DOT11F_TLV_RFBANDS, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscBeaconProbeRes, VendorExtension), offsetof(tDot11fTLVVendorExtension, present), "VendorExtension", SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION, 0, 7, 21, 0, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeWscBeaconProbeRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWscBeaconProbeRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_WscBeaconProbeRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeWscBeaconProbeRes. */

#define SigIeWscBeaconProbeRes ( 0x007a )


tANI_U32 dot11fUnpackIeWscIEOpaque(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWscIEOpaque *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void) pBuf; (void)ielen; /* Shutup the compiler */
    if (pDst->present) status = DOT11F_DUPLICATE_IE;
    pDst->present = 1;
    pDst->num_data = (tANI_U8)( ielen );
    if (ielen > 249){
        pDst->present = 0;
        return DOT11F_SKIPPED_BAD_IE;
    }

    DOT11F_MEMCPY(pCtx, pDst->data, pBuf, ( ielen ) );
    (void)pCtx;
    return status;
} /* End dot11fUnpackIeWscIEOpaque. */

#define SigIeWscIEOpaque ( 0x007b )


    static const tTLVDefn TLVS_WscProbeReq[ ] = {
        {offsetof(tDot11fIEWscProbeReq, Version), offsetof(tDot11fTLVVersion, present), "Version", SigTlvVersion, DOT11F_TLV_VERSION, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, RequestType), offsetof(tDot11fTLVRequestType, present), "RequestType", SigTlvRequestType, DOT11F_TLV_REQUESTTYPE, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, ConfigMethods), offsetof(tDot11fTLVConfigMethods, present), "ConfigMethods", SigTlvConfigMethods, DOT11F_TLV_CONFIGMETHODS, 0, 6, 6, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, UUID_E), offsetof(tDot11fTLVUUID_E, present), "UUID_E", SigTlvUUID_E, DOT11F_TLV_UUID_E, 0, 20, 20, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, PrimaryDeviceType), offsetof(tDot11fTLVPrimaryDeviceType, present), "PrimaryDeviceType", SigTlvPrimaryDeviceType, DOT11F_TLV_PRIMARYDEVICETYPE, 0, 12, 12, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, RFBands), offsetof(tDot11fTLVRFBands, present), "RFBands", SigTlvRFBands, DOT11F_TLV_RFBANDS, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, AssociationState), offsetof(tDot11fTLVAssociationState, present), "AssociationState", SigTlvAssociationState, DOT11F_TLV_ASSOCIATIONSTATE, 0, 6, 6, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, ConfigurationError), offsetof(tDot11fTLVConfigurationError, present), "ConfigurationError", SigTlvConfigurationError, DOT11F_TLV_CONFIGURATIONERROR, 0, 6, 6, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, DevicePasswordID), offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID", SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID, 0, 6, 6, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, Manufacturer), offsetof(tDot11fTLVManufacturer, present), "Manufacturer", SigTlvManufacturer, DOT11F_TLV_MANUFACTURER, 0, 4, 68, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, ModelName), offsetof(tDot11fTLVModelName, present), "ModelName", SigTlvModelName, DOT11F_TLV_MODELNAME, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, ModelNumber), offsetof(tDot11fTLVModelNumber, present), "ModelNumber", SigTlvModelNumber, DOT11F_TLV_MODELNUMBER, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, DeviceName), offsetof(tDot11fTLVDeviceName, present), "DeviceName", SigTlvDeviceName, DOT11F_TLV_DEVICENAME, 0, 4, 36, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, VendorExtension), offsetof(tDot11fTLVVendorExtension, present), "VendorExtension", SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION, 0, 7, 21, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeReq, RequestDeviceType), offsetof(tDot11fTLVRequestDeviceType, present), "RequestDeviceType", SigTlvRequestDeviceType, DOT11F_TLV_REQUESTDEVICETYPE, 0, 12, 12, 0, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeWscProbeReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWscProbeReq *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_WscProbeReq,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeWscProbeReq. */

#define SigIeWscProbeReq ( 0x007c )


    static const tTLVDefn TLVS_WscProbeRes[ ] = {
        {offsetof(tDot11fIEWscProbeRes, Version), offsetof(tDot11fTLVVersion, present), "Version", SigTlvVersion, DOT11F_TLV_VERSION, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, WPSState), offsetof(tDot11fTLVWPSState, present), "WPSState", SigTlvWPSState, DOT11F_TLV_WPSSTATE, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, APSetupLocked), offsetof(tDot11fTLVAPSetupLocked, present), "APSetupLocked", SigTlvAPSetupLocked, DOT11F_TLV_APSETUPLOCKED, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, SelectedRegistrar), offsetof(tDot11fTLVSelectedRegistrar, present), "SelectedRegistrar", SigTlvSelectedRegistrar, DOT11F_TLV_SELECTEDREGISTRAR, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, DevicePasswordID), offsetof(tDot11fTLVDevicePasswordID, present), "DevicePasswordID", SigTlvDevicePasswordID, DOT11F_TLV_DEVICEPASSWORDID, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, SelectedRegistrarConfigMethods), offsetof(tDot11fTLVSelectedRegistrarConfigMethods, present), "SelectedRegistrarConfigMethods", SigTlvSelectedRegistrarConfigMethods, DOT11F_TLV_SELECTEDREGISTRARCONFIGMETHODS, 0, 6, 6, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, ResponseType), offsetof(tDot11fTLVResponseType, present), "ResponseType", SigTlvResponseType, DOT11F_TLV_RESPONSETYPE, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, UUID_E), offsetof(tDot11fTLVUUID_E, present), "UUID_E", SigTlvUUID_E, DOT11F_TLV_UUID_E, 0, 20, 20, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, Manufacturer), offsetof(tDot11fTLVManufacturer, present), "Manufacturer", SigTlvManufacturer, DOT11F_TLV_MANUFACTURER, 0, 4, 68, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, ModelName), offsetof(tDot11fTLVModelName, present), "ModelName", SigTlvModelName, DOT11F_TLV_MODELNAME, 0, 4, 36, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, ModelNumber), offsetof(tDot11fTLVModelNumber, present), "ModelNumber", SigTlvModelNumber, DOT11F_TLV_MODELNUMBER, 0, 4, 36, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, SerialNumber), offsetof(tDot11fTLVSerialNumber, present), "SerialNumber", SigTlvSerialNumber, DOT11F_TLV_SERIALNUMBER, 0, 4, 36, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, PrimaryDeviceType), offsetof(tDot11fTLVPrimaryDeviceType, present), "PrimaryDeviceType", SigTlvPrimaryDeviceType, DOT11F_TLV_PRIMARYDEVICETYPE, 0, 12, 12, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, DeviceName), offsetof(tDot11fTLVDeviceName, present), "DeviceName", SigTlvDeviceName, DOT11F_TLV_DEVICENAME, 0, 4, 36, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, ConfigMethods), offsetof(tDot11fTLVConfigMethods, present), "ConfigMethods", SigTlvConfigMethods, DOT11F_TLV_CONFIGMETHODS, 0, 6, 6, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, RFBands), offsetof(tDot11fTLVRFBands, present), "RFBands", SigTlvRFBands, DOT11F_TLV_RFBANDS, 0, 5, 5, 0, 2, 2, 1, },
        {offsetof(tDot11fIEWscProbeRes, VendorExtension), offsetof(tDot11fTLVVendorExtension, present), "VendorExtension", SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION, 0, 7, 21, 0, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeWscProbeRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWscProbeRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_WscProbeRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeWscProbeRes. */

#define SigIeWscProbeRes ( 0x007d )


    static const tTLVDefn TLVS_WscReassocRes[ ] = {
        {offsetof(tDot11fIEWscReassocRes, Version), offsetof(tDot11fTLVVersion, present), "Version", SigTlvVersion, DOT11F_TLV_VERSION, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscReassocRes, ResponseType), offsetof(tDot11fTLVResponseType, present), "ResponseType", SigTlvResponseType, DOT11F_TLV_RESPONSETYPE, 0, 5, 5, 1, 2, 2, 1, },
        {offsetof(tDot11fIEWscReassocRes, VendorExtension), offsetof(tDot11fTLVVendorExtension, present), "VendorExtension", SigTlvVendorExtension, DOT11F_TLV_VENDOREXTENSION, 0, 7, 21, 0, 2, 2, 1, },
        {0, 0, NULL, 0, 0xffff, 0, 0, 0, 0, 0, 0},
    };

tANI_U32 dot11fUnpackIeWscReassocRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U8 ielen, tDot11fIEWscReassocRes *pDst)
{
    tANI_U32 status = DOT11F_PARSE_SUCCESS;
    (void)pBuf; (void)ielen; /* Shutup the compiler */
    pDst->present = 1;
    status = UnpackTlvCore(pCtx,pBuf,ielen,TLVS_WscReassocRes,(tANI_U8*)pDst,sizeof(*pDst));
    return status;
} /* End dot11fUnpackIeWscReassocRes. */

#define SigIeWscReassocRes ( 0x007e )


    static const tFFDefn FFS_AddBAReq[] = {
        { "Category", offsetof(tDot11fAddBAReq, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fAddBAReq, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fAddBAReq, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
        { "AddBAParameterSet", offsetof(tDot11fAddBAReq, AddBAParameterSet), SigFfAddBAParameterSet , DOT11F_FF_ADDBAPARAMETERSET_LEN, },
        { "BATimeout", offsetof(tDot11fAddBAReq, BATimeout), SigFfBATimeout , DOT11F_FF_BATIMEOUT_LEN, },
        { "BAStartingSequenceControl", offsetof(tDot11fAddBAReq, BAStartingSequenceControl), SigFfBAStartingSequenceControl , DOT11F_FF_BASTARTINGSEQUENCECONTROL_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_AddBAReq[] = {
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackAddBAReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fAddBAReq *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_AddBAReq, IES_AddBAReq, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("Unpacked the AddBAReq:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("AddBAParameterSet:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("amsduSupported (1): %d\n"), pFrm->AddBAParameterSet.amsduSupported);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("policy (1): %d\n"), pFrm->AddBAParameterSet.policy);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("tid (4): %d\n"), pFrm->AddBAParameterSet.tid);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("bufferSize (10): %d\n"), pFrm->AddBAParameterSet.bufferSize);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("BATimeout:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), ( tANI_U8* )&pFrm->BATimeout.timeout, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("BAStartingSequenceControl:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("fragNumber (4): %d\n"), pFrm->BAStartingSequenceControl.fragNumber);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBAREQ), FRFL("ssn (12): %d\n"), pFrm->BAStartingSequenceControl.ssn);
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackAddBAReq. */

    static const tFFDefn FFS_AddBARsp[] = {
        { "Category", offsetof(tDot11fAddBARsp, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fAddBARsp, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fAddBARsp, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
        { "Status", offsetof(tDot11fAddBARsp, Status), SigFfStatus , DOT11F_FF_STATUS_LEN, },
        { "AddBAParameterSet", offsetof(tDot11fAddBARsp, AddBAParameterSet), SigFfAddBAParameterSet , DOT11F_FF_ADDBAPARAMETERSET_LEN, },
        { "BATimeout", offsetof(tDot11fAddBARsp, BATimeout), SigFfBATimeout , DOT11F_FF_BATIMEOUT_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_AddBARsp[] = {
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackAddBARsp(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fAddBARsp *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_AddBARsp, IES_AddBARsp, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("Unpacked the AddBARsp:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("Status:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), ( tANI_U8* )&pFrm->Status.status, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("AddBAParameterSet:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("amsduSupported (1): %d\n"), pFrm->AddBAParameterSet.amsduSupported);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("policy (1): %d\n"), pFrm->AddBAParameterSet.policy);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("tid (4): %d\n"), pFrm->AddBAParameterSet.tid);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("bufferSize (10): %d\n"), pFrm->AddBAParameterSet.bufferSize);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), FRFL("BATimeout:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDBARSP), ( tANI_U8* )&pFrm->BATimeout.timeout, 2);
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackAddBARsp. */

    static const tFFDefn FFS_AddTSRequest[] = {
        { "Category", offsetof(tDot11fAddTSRequest, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fAddTSRequest, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fAddTSRequest, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_AddTSRequest[] = {
        {offsetof(tDot11fAddTSRequest, TSPEC), offsetof(tDot11fIETSPEC, present), 0, "TSPEC" , 0, 57, 57, SigIeTSPEC, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TSPEC, 1, },
        {offsetof(tDot11fAddTSRequest, TCLAS), offsetof(tDot11fIETCLAS, present), offsetof(tDot11fAddTSRequest, num_TCLAS), "TCLAS" , 2, 7, 45, SigIeTCLAS, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TCLAS, 0, },
        {offsetof(tDot11fAddTSRequest, TCLASSPROC), offsetof(tDot11fIETCLASSPROC, present), 0, "TCLASSPROC" , 0, 3, 3, SigIeTCLASSPROC, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TCLASSPROC, 0, },
        {offsetof(tDot11fAddTSRequest, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC, present), 0, "WMMTSPEC" , 0, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2}, 5, DOT11F_EID_WMMTSPEC, 0, },
        {offsetof(tDot11fAddTSRequest, WMMTCLAS), offsetof(tDot11fIEWMMTCLAS, present), offsetof(tDot11fAddTSRequest, num_WMMTCLAS), "WMMTCLAS" , 2, 13, 51, SigIeWMMTCLAS, {0, 80, 242, 2, 6}, 5, DOT11F_EID_WMMTCLAS, 0, },
        {offsetof(tDot11fAddTSRequest, WMMTCLASPROC), offsetof(tDot11fIEWMMTCLASPROC, present), 0, "WMMTCLASPROC" , 0, 9, 9, SigIeWMMTCLASPROC, {0, 80, 242, 2, 7}, 5, DOT11F_EID_WMMTCLASPROC, 0, },
        {offsetof(tDot11fAddTSRequest, CCXTrafStrmRateSet), offsetof(tDot11fIECCXTrafStrmRateSet, present), 0, "CCXTrafStrmRateSet" , 0, 7, 15, SigIeCCXTrafStrmRateSet, {0, 64, 150, 8, 0}, 4, DOT11F_EID_CCXTRAFSTRMRATESET, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackAddTSRequest(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fAddTSRequest *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_AddTSRequest, IES_AddTSRequest, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("Unpacked the AddTSRequest:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("TSPEC:\n"));
        if (!pFrm->TSPEC.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("traffic_type (1): %d\n"), pFrm->TSPEC.traffic_type);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("tsid (4): %d\n"), pFrm->TSPEC.tsid);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("direction (2): %d\n"), pFrm->TSPEC.direction);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("access_policy (2): %d\n"), pFrm->TSPEC.access_policy);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("aggregation (1): %d\n"), pFrm->TSPEC.aggregation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("psb (1): %d\n"), pFrm->TSPEC.psb);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("user_priority (3): %d\n"), pFrm->TSPEC.user_priority);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->TSPEC.tsinfo_ack_pol);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("schedule (1): %d\n"), pFrm->TSPEC.schedule);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("unused (7): %d\n"), pFrm->TSPEC.unused);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("size (15): %d\n"), pFrm->TSPEC.size);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("fixed (1): %d\n"), pFrm->TSPEC.fixed);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.max_msdu_size, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.min_service_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.max_service_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.inactivity_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.suspension_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.service_start_time, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.min_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.mean_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.peak_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.burst_size, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.delay_bound, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.min_phy_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.surplus_bw_allowance, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TSPEC.medium_time, 2);
        }
        for (i = 0; i < pFrm->num_TCLAS; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("TCLAS[%d]:\n"), i);
            if (!pFrm->TCLAS[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].user_priority, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].classifier_type, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].classifier_mask, 1);
                switch (pFrm->TCLAS[i].classifier_type)
                {
                    case 0:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.EthParams.source, 6);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.EthParams.dest, 6);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.EthParams.type, 2);
                    break;
                    case 1:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.version, 1);
                        switch (pFrm->TCLAS[i].info.IpParams.version)
                        {
                            case 4:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.source, 4);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.dest, 4);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.src_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.dest_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.DSCP, 1);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.proto, 1);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.reserved, 1);
                            break;
                            case 6:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV6Params.source, 16);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV6Params.dest, 16);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV6Params.src_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV6Params.dest_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV6Params.flow_label, 3);
                            break;
                        }
                    break;
                    case 2:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLAS[i].info.Params8021dq.tag_type, 2);
                    break;
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("TCLASSPROC:\n"));
        if (!pFrm->TCLASSPROC.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->TCLASSPROC.processing, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("WMMTSPEC:\n"));
        if (!pFrm->WMMTSPEC.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("traffic_type (1): %d\n"), pFrm->WMMTSPEC.traffic_type);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("tsid (4): %d\n"), pFrm->WMMTSPEC.tsid);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("direction (2): %d\n"), pFrm->WMMTSPEC.direction);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("access_policy (2): %d\n"), pFrm->WMMTSPEC.access_policy);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("aggregation (1): %d\n"), pFrm->WMMTSPEC.aggregation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("psb (1): %d\n"), pFrm->WMMTSPEC.psb);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("user_priority (3): %d\n"), pFrm->WMMTSPEC.user_priority);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->WMMTSPEC.tsinfo_ack_pol);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("tsinfo_rsvd (7): %d\n"), pFrm->WMMTSPEC.tsinfo_rsvd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("burst_size_defn (1): %d\n"), pFrm->WMMTSPEC.burst_size_defn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("size (15): %d\n"), pFrm->WMMTSPEC.size);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("fixed (1): %d\n"), pFrm->WMMTSPEC.fixed);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.max_msdu_size, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.min_service_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.max_service_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.inactivity_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.suspension_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.service_start_time, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.min_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.mean_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.peak_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.burst_size, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.delay_bound, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.min_phy_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.surplus_bw_allowance, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTSPEC.medium_time, 2);
        }
        for (i = 0; i < pFrm->num_WMMTCLAS; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("WMMTCLAS[%d]:\n"), i);
            if (!pFrm->WMMTCLAS[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].version, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].user_priority, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].classifier_type, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].classifier_mask, 1);
                switch (pFrm->WMMTCLAS[i].classifier_type)
                {
                    case 0:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.EthParams.source, 6);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.EthParams.dest, 6);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.EthParams.type, 2);
                    break;
                    case 1:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.version, 1);
                        switch (pFrm->WMMTCLAS[i].info.IpParams.version)
                        {
                            case 4:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.source, 4);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.dest, 4);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.src_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.dest_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.DSCP, 1);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.proto, 1);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.reserved, 1);
                            break;
                            case 6:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV6Params.source, 16);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV6Params.dest, 16);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV6Params.src_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV6Params.dest_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV6Params.flow_label, 3);
                            break;
                        }
                    break;
                    case 2:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.Params8021dq.tag_type, 2);
                    break;
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("WMMTCLASPROC:\n"));
        if (!pFrm->WMMTCLASPROC.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLASPROC.version, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->WMMTCLASPROC.processing, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("CCXTrafStrmRateSet:\n"));
        if (!pFrm->CCXTrafStrmRateSet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* )&pFrm->CCXTrafStrmRateSet.tsid, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), FRFL("num_tsrates: %d.\n"), pFrm->CCXTrafStrmRateSet.num_tsrates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSREQUEST), ( tANI_U8* ) pFrm->CCXTrafStrmRateSet.tsrates, pFrm->CCXTrafStrmRateSet.num_tsrates);
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackAddTSRequest. */

    static const tFFDefn FFS_AddTSResponse[] = {
        { "Category", offsetof(tDot11fAddTSResponse, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fAddTSResponse, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fAddTSResponse, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
        { "Status", offsetof(tDot11fAddTSResponse, Status), SigFfStatus , DOT11F_FF_STATUS_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_AddTSResponse[] = {
        {offsetof(tDot11fAddTSResponse, TSDelay), offsetof(tDot11fIETSDelay, present), 0, "TSDelay" , 0, 6, 6, SigIeTSDelay, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TSDELAY, 1, },
        {offsetof(tDot11fAddTSResponse, TSPEC), offsetof(tDot11fIETSPEC, present), 0, "TSPEC" , 0, 57, 57, SigIeTSPEC, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TSPEC, 1, },
        {offsetof(tDot11fAddTSResponse, TCLAS), offsetof(tDot11fIETCLAS, present), offsetof(tDot11fAddTSResponse, num_TCLAS), "TCLAS" , 2, 7, 45, SigIeTCLAS, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TCLAS, 0, },
        {offsetof(tDot11fAddTSResponse, TCLASSPROC), offsetof(tDot11fIETCLASSPROC, present), 0, "TCLASSPROC" , 0, 3, 3, SigIeTCLASSPROC, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TCLASSPROC, 0, },
        {offsetof(tDot11fAddTSResponse, Schedule), offsetof(tDot11fIESchedule, present), 0, "Schedule" , 0, 16, 16, SigIeSchedule, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SCHEDULE, 0, },
        {offsetof(tDot11fAddTSResponse, WMMTSDelay), offsetof(tDot11fIEWMMTSDelay, present), 0, "WMMTSDelay" , 0, 12, 12, SigIeWMMTSDelay, {0, 80, 242, 2, 8}, 5, DOT11F_EID_WMMTSDELAY, 0, },
        {offsetof(tDot11fAddTSResponse, WMMSchedule), offsetof(tDot11fIEWMMSchedule, present), 0, "WMMSchedule" , 0, 22, 22, SigIeWMMSchedule, {0, 80, 242, 2, 9}, 5, DOT11F_EID_WMMSCHEDULE, 0, },
        {offsetof(tDot11fAddTSResponse, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC, present), 0, "WMMTSPEC" , 0, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2}, 5, DOT11F_EID_WMMTSPEC, 0, },
        {offsetof(tDot11fAddTSResponse, WMMTCLAS), offsetof(tDot11fIEWMMTCLAS, present), offsetof(tDot11fAddTSResponse, num_WMMTCLAS), "WMMTCLAS" , 2, 13, 51, SigIeWMMTCLAS, {0, 80, 242, 2, 6}, 5, DOT11F_EID_WMMTCLAS, 0, },
        {offsetof(tDot11fAddTSResponse, WMMTCLASPROC), offsetof(tDot11fIEWMMTCLASPROC, present), 0, "WMMTCLASPROC" , 0, 9, 9, SigIeWMMTCLASPROC, {0, 80, 242, 2, 7}, 5, DOT11F_EID_WMMTCLASPROC, 0, },
        {offsetof(tDot11fAddTSResponse, CCXTrafStrmMet), offsetof(tDot11fIECCXTrafStrmMet, present), 0, "CCXTrafStrmMet" , 0, 10, 10, SigIeCCXTrafStrmMet, {0, 64, 150, 7, 0}, 4, DOT11F_EID_CCXTRAFSTRMMET, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackAddTSResponse(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fAddTSResponse *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_AddTSResponse, IES_AddTSResponse, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Unpacked the AddTSResponse:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Status:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->Status.status, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("TSDelay:\n"));
        if (!pFrm->TSDelay.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSDelay.delay, 4);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("TSPEC:\n"));
        if (!pFrm->TSPEC.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("traffic_type (1): %d\n"), pFrm->TSPEC.traffic_type);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("tsid (4): %d\n"), pFrm->TSPEC.tsid);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("direction (2): %d\n"), pFrm->TSPEC.direction);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("access_policy (2): %d\n"), pFrm->TSPEC.access_policy);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("aggregation (1): %d\n"), pFrm->TSPEC.aggregation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("psb (1): %d\n"), pFrm->TSPEC.psb);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("user_priority (3): %d\n"), pFrm->TSPEC.user_priority);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->TSPEC.tsinfo_ack_pol);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("schedule (1): %d\n"), pFrm->TSPEC.schedule);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("unused (7): %d\n"), pFrm->TSPEC.unused);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("size (15): %d\n"), pFrm->TSPEC.size);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("fixed (1): %d\n"), pFrm->TSPEC.fixed);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.max_msdu_size, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.min_service_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.max_service_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.inactivity_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.suspension_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.service_start_time, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.min_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.mean_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.peak_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.burst_size, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.delay_bound, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.min_phy_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.surplus_bw_allowance, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TSPEC.medium_time, 2);
        }
        for (i = 0; i < pFrm->num_TCLAS; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("TCLAS[%d]:\n"), i);
            if (!pFrm->TCLAS[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].user_priority, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].classifier_type, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].classifier_mask, 1);
                switch (pFrm->TCLAS[i].classifier_type)
                {
                    case 0:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.EthParams.source, 6);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.EthParams.dest, 6);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.EthParams.type, 2);
                    break;
                    case 1:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.version, 1);
                        switch (pFrm->TCLAS[i].info.IpParams.version)
                        {
                            case 4:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.source, 4);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.dest, 4);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.src_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.dest_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.DSCP, 1);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.proto, 1);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV4Params.reserved, 1);
                            break;
                            case 6:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV6Params.source, 16);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV6Params.dest, 16);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV6Params.src_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV6Params.dest_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.IpParams.params.IpV6Params.flow_label, 3);
                            break;
                        }
                    break;
                    case 2:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLAS[i].info.Params8021dq.tag_type, 2);
                    break;
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("TCLASSPROC:\n"));
        if (!pFrm->TCLASSPROC.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->TCLASSPROC.processing, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Schedule:\n"));
        if (!pFrm->Schedule.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("aggregation (1): %d\n"), pFrm->Schedule.aggregation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("tsid (4): %d\n"), pFrm->Schedule.tsid);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("direction (2): %d\n"), pFrm->Schedule.direction);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("reserved (9): %d\n"), pFrm->Schedule.reserved);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->Schedule.service_start_time, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->Schedule.service_interval, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->Schedule.max_service_dur, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->Schedule.spec_interval, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("WMMTSDelay:\n"));
        if (!pFrm->WMMTSDelay.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSDelay.version, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSDelay.delay, 4);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("WMMSchedule:\n"));
        if (!pFrm->WMMSchedule.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMSchedule.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("aggregation (1): %d\n"), pFrm->WMMSchedule.aggregation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("tsid (4): %d\n"), pFrm->WMMSchedule.tsid);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("direction (2): %d\n"), pFrm->WMMSchedule.direction);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("reserved (9): %d\n"), pFrm->WMMSchedule.reserved);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMSchedule.service_start_time, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMSchedule.service_interval, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMSchedule.max_service_dur, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMSchedule.spec_interval, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("WMMTSPEC:\n"));
        if (!pFrm->WMMTSPEC.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("traffic_type (1): %d\n"), pFrm->WMMTSPEC.traffic_type);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("tsid (4): %d\n"), pFrm->WMMTSPEC.tsid);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("direction (2): %d\n"), pFrm->WMMTSPEC.direction);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("access_policy (2): %d\n"), pFrm->WMMTSPEC.access_policy);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("aggregation (1): %d\n"), pFrm->WMMTSPEC.aggregation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("psb (1): %d\n"), pFrm->WMMTSPEC.psb);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("user_priority (3): %d\n"), pFrm->WMMTSPEC.user_priority);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->WMMTSPEC.tsinfo_ack_pol);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("tsinfo_rsvd (7): %d\n"), pFrm->WMMTSPEC.tsinfo_rsvd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("burst_size_defn (1): %d\n"), pFrm->WMMTSPEC.burst_size_defn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("size (15): %d\n"), pFrm->WMMTSPEC.size);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("fixed (1): %d\n"), pFrm->WMMTSPEC.fixed);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.max_msdu_size, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.min_service_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.max_service_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.inactivity_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.suspension_int, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.service_start_time, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.min_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.mean_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.peak_data_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.burst_size, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.delay_bound, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.min_phy_rate, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.surplus_bw_allowance, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC.medium_time, 2);
        }
        for (i = 0; i < pFrm->num_WMMTCLAS; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("WMMTCLAS[%d]:\n"), i);
            if (!pFrm->WMMTCLAS[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].version, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].user_priority, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].classifier_type, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].classifier_mask, 1);
                switch (pFrm->WMMTCLAS[i].classifier_type)
                {
                    case 0:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.EthParams.source, 6);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.EthParams.dest, 6);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.EthParams.type, 2);
                    break;
                    case 1:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.version, 1);
                        switch (pFrm->WMMTCLAS[i].info.IpParams.version)
                        {
                            case 4:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.source, 4);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.dest, 4);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.src_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.dest_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.DSCP, 1);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.proto, 1);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV4Params.reserved, 1);
                            break;
                            case 6:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV6Params.source, 16);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV6Params.dest, 16);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV6Params.src_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV6Params.dest_port, 2);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.IpParams.params.IpV6Params.flow_label, 3);
                            break;
                        }
                    break;
                    case 2:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLAS[i].info.Params8021dq.tag_type, 2);
                    break;
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("WMMTCLASPROC:\n"));
        if (!pFrm->WMMTCLASPROC.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLASPROC.version, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->WMMTCLASPROC.processing, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("CCXTrafStrmMet:\n"));
        if (!pFrm->CCXTrafStrmMet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->CCXTrafStrmMet.tsid, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->CCXTrafStrmMet.state, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ADDTSRESPONSE), ( tANI_U8* )&pFrm->CCXTrafStrmMet.msmt_interval, 2);
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackAddTSResponse. */

    static const tFFDefn FFS_AssocRequest[] = {
        { "Capabilities", offsetof(tDot11fAssocRequest, Capabilities), SigFfCapabilities , DOT11F_FF_CAPABILITIES_LEN, },
        { "ListenInterval", offsetof(tDot11fAssocRequest, ListenInterval), SigFfListenInterval , DOT11F_FF_LISTENINTERVAL_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_AssocRequest[] = {
        {offsetof(tDot11fAssocRequest, SSID), offsetof(tDot11fIESSID, present), 0, "SSID" , 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 1, },
        {offsetof(tDot11fAssocRequest, SuppRates), offsetof(tDot11fIESuppRates, present), 0, "SuppRates" , 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPRATES, 1, },
        {offsetof(tDot11fAssocRequest, ExtSuppRates), offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates" , 0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTSUPPRATES, 0, },
        {offsetof(tDot11fAssocRequest, PowerCaps), offsetof(tDot11fIEPowerCaps, present), 0, "PowerCaps" , 0, 4, 4, SigIePowerCaps, {0, 0, 0, 0, 0}, 0, DOT11F_EID_POWERCAPS, 0, },
        {offsetof(tDot11fAssocRequest, SuppChannels), offsetof(tDot11fIESuppChannels, present), 0, "SuppChannels" , 0, 4, 98, SigIeSuppChannels, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPCHANNELS, 0, },
        {offsetof(tDot11fAssocRequest, RSNOpaque), offsetof(tDot11fIERSNOpaque, present), 0, "RSNOpaque" , 0, 8, 255, SigIeRSNOpaque, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSNOPAQUE, 0, },
        {offsetof(tDot11fAssocRequest, QOSCapsStation), offsetof(tDot11fIEQOSCapsStation, present), 0, "QOSCapsStation" , 0, 3, 3, SigIeQOSCapsStation, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QOSCAPSSTATION, 0, },
        {offsetof(tDot11fAssocRequest, RRMEnabledCap), offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap" , 0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RRMENABLEDCAP, 0, },
        {offsetof(tDot11fAssocRequest, MobilityDomain), offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain" , 0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MOBILITYDOMAIN, 0, },
        {offsetof(tDot11fAssocRequest, WPAOpaque), offsetof(tDot11fIEWPAOpaque, present), 0, "WPAOpaque" , 0, 8, 255, SigIeWPAOpaque, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPAOPAQUE, 0, },
        {offsetof(tDot11fAssocRequest, HTCaps), offsetof(tDot11fIEHTCaps, present), 0, "HTCaps" , 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTCAPS, 0, },
        {offsetof(tDot11fAssocRequest, WMMCaps), offsetof(tDot11fIEWMMCaps, present), 0, "WMMCaps" , 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5}, 5, DOT11F_EID_WMMCAPS, 0, },
        {offsetof(tDot11fAssocRequest, WMMInfoStation), offsetof(tDot11fIEWMMInfoStation, present), 0, "WMMInfoStation" , 0, 9, 9, SigIeWMMInfoStation, {0, 80, 242, 2, 0}, 5, DOT11F_EID_WMMINFOSTATION, 0, },
        {offsetof(tDot11fAssocRequest, Airgo), offsetof(tDot11fIEAirgo, present), 0, "Airgo" , 0, 5, 232, SigIeAirgo, {0, 10, 245, 0, 0}, 3, DOT11F_EID_AIRGO, 0, },
        {offsetof(tDot11fAssocRequest, WscIEOpaque), offsetof(tDot11fIEWscIEOpaque, present), 0, "WscIEOpaque" , 0, 8, 255, SigIeWscIEOpaque, {0, 80, 242, 4, 0}, 4, DOT11F_EID_WSCIEOPAQUE, 0, },
        {offsetof(tDot11fAssocRequest, WAPIOpaque), offsetof(tDot11fIEWAPIOpaque, present), 0, "WAPIOpaque" , 0, 8, 255, SigIeWAPIOpaque, {0, 0, 0, 0, 0}, 0, DOT11F_EID_WAPIOPAQUE, 0, },
        {offsetof(tDot11fAssocRequest, CCXRadMgmtCap), offsetof(tDot11fIECCXRadMgmtCap, present), 0, "CCXRadMgmtCap" , 0, 8, 8, SigIeCCXRadMgmtCap, {0, 64, 150, 1, 0}, 4, DOT11F_EID_CCXRADMGMTCAP, 0, },
        {offsetof(tDot11fAssocRequest, CCXVersion), offsetof(tDot11fIECCXVersion, present), 0, "CCXVersion" , 0, 7, 7, SigIeCCXVersion, {0, 64, 150, 3, 0}, 4, DOT11F_EID_CCXVERSION, 0, },
        {offsetof(tDot11fAssocRequest, P2PIEOpaque), offsetof(tDot11fIEP2PIEOpaque, present), 0, "P2PIEOpaque" , 0, 8, 255, SigIeP2PIEOpaque, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PIEOPAQUE, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackAssocRequest(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fAssocRequest *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_AssocRequest, IES_AssocRequest, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Unpacked the AssocRequest:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Capabilities:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("ess (1): %d\n"), pFrm->Capabilities.ess);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("ibss (1): %d\n"), pFrm->Capabilities.ibss);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("cfPollable (1): %d\n"), pFrm->Capabilities.cfPollable);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("cfPollReq (1): %d\n"), pFrm->Capabilities.cfPollReq);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("privacy (1): %d\n"), pFrm->Capabilities.privacy);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("shortPreamble (1): %d\n"), pFrm->Capabilities.shortPreamble);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("pbcc (1): %d\n"), pFrm->Capabilities.pbcc);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("channelAgility (1): %d\n"), pFrm->Capabilities.channelAgility);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("spectrumMgt (1): %d\n"), pFrm->Capabilities.spectrumMgt);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("qos (1): %d\n"), pFrm->Capabilities.qos);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("shortSlotTime (1): %d\n"), pFrm->Capabilities.shortSlotTime);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("apsd (1): %d\n"), pFrm->Capabilities.apsd);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("rrm (1): %d\n"), pFrm->Capabilities.rrm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("dsssOfdm (1): %d\n"), pFrm->Capabilities.dsssOfdm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("delayedBA (1): %d\n"), pFrm->Capabilities.delayedBA);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("immediateBA (1): %d\n"), pFrm->Capabilities.immediateBA);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("ListenInterval:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->ListenInterval.interval, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("SSID:\n"));
        if (!pFrm->SSID.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_ssid: %d.\n"), pFrm->SSID.num_ssid);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->SSID.ssid, pFrm->SSID.num_ssid);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("SuppRates:\n"));
        if (!pFrm->SuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_rates: %d.\n"), pFrm->SuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->SuppRates.rates, pFrm->SuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("ExtSuppRates:\n"));
        if (!pFrm->ExtSuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_rates: %d.\n"), pFrm->ExtSuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->ExtSuppRates.rates, pFrm->ExtSuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("PowerCaps:\n"));
        if (!pFrm->PowerCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->PowerCaps.minTxPower, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->PowerCaps.maxTxPower, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("SuppChannels:\n"));
        if (!pFrm->SuppChannels.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_bands: %d.\n"), pFrm->SuppChannels.num_bands);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->SuppChannels.bands, 2 * pFrm->SuppChannels.num_bands);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("RSNOpaque:\n"));
        if (!pFrm->RSNOpaque.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_data: %d.\n"), pFrm->RSNOpaque.num_data);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->RSNOpaque.data, pFrm->RSNOpaque.num_data);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("QOSCapsStation:\n"));
        if (!pFrm->QOSCapsStation.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("more_data_ack (1): %d\n"), pFrm->QOSCapsStation.more_data_ack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("max_sp_length (2): %d\n"), pFrm->QOSCapsStation.max_sp_length);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("qack (1): %d\n"), pFrm->QOSCapsStation.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbe_uapsd (1): %d\n"), pFrm->QOSCapsStation.acbe_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbk_uapsd (1): %d\n"), pFrm->QOSCapsStation.acbk_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvi_uapsd (1): %d\n"), pFrm->QOSCapsStation.acvi_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvo_uapsd (1): %d\n"), pFrm->QOSCapsStation.acvo_uapsd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("RRMEnabledCap:\n"));
        if (!pFrm->RRMEnabledCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("LinkMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LinkMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("NeighborRpt (1): %d\n"), pFrm->RRMEnabledCap.NeighborRpt);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("parallel (1): %d\n"), pFrm->RRMEnabledCap.parallel);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("repeated (1): %d\n"), pFrm->RRMEnabledCap.repeated);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("BeaconPassive (1): %d\n"), pFrm->RRMEnabledCap.BeaconPassive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("BeaconActive (1): %d\n"), pFrm->RRMEnabledCap.BeaconActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("BeaconTable (1): %d\n"), pFrm->RRMEnabledCap.BeaconTable);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("BeaconRepCond (1): %d\n"), pFrm->RRMEnabledCap.BeaconRepCond);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("FrameMeasurement (1): %d\n"), pFrm->RRMEnabledCap.FrameMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("ChannelLoad (1): %d\n"), pFrm->RRMEnabledCap.ChannelLoad);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("NoiseHistogram (1): %d\n"), pFrm->RRMEnabledCap.NoiseHistogram);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("statistics (1): %d\n"), pFrm->RRMEnabledCap.statistics);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("LCIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LCIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("LCIAzimuth (1): %d\n"), pFrm->RRMEnabledCap.LCIAzimuth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("TCMCapability (1): %d\n"), pFrm->RRMEnabledCap.TCMCapability);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("triggeredTCM (1): %d\n"), pFrm->RRMEnabledCap.triggeredTCM);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("APChanReport (1): %d\n"), pFrm->RRMEnabledCap.APChanReport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("RRMMIBEnabled (1): %d\n"), pFrm->RRMEnabledCap.RRMMIBEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("operatingChanMax (3): %d\n"), pFrm->RRMEnabledCap.operatingChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("nonOperatinChanMax (3): %d\n"), pFrm->RRMEnabledCap.nonOperatinChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("MeasurementPilot (3): %d\n"), pFrm->RRMEnabledCap.MeasurementPilot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("MeasurementPilotEnabled (1): %d\n"), pFrm->RRMEnabledCap.MeasurementPilotEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("NeighborTSFOffset (1): %d\n"), pFrm->RRMEnabledCap.NeighborTSFOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("RCPIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RCPIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("RSNIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RSNIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("BssAvgAccessDelay (1): %d\n"), pFrm->RRMEnabledCap.BssAvgAccessDelay);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("BSSAvailAdmission (1): %d\n"), pFrm->RRMEnabledCap.BSSAvailAdmission);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("AntennaInformation (1): %d\n"), pFrm->RRMEnabledCap.AntennaInformation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved (6): %d\n"), pFrm->RRMEnabledCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("MobilityDomain:\n"));
        if (!pFrm->MobilityDomain.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->MobilityDomain.MDID, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("overDSCap (1): %d\n"), pFrm->MobilityDomain.overDSCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("resourceReqCap (1): %d\n"), pFrm->MobilityDomain.resourceReqCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved (6): %d\n"), pFrm->MobilityDomain.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("WPAOpaque:\n"));
        if (!pFrm->WPAOpaque.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_data: %d.\n"), pFrm->WPAOpaque.num_data);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->WPAOpaque.data, pFrm->WPAOpaque.num_data);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("HTCaps:\n"));
        if (!pFrm->HTCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("advCodingCap (1): %d\n"), pFrm->HTCaps.advCodingCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("supportedChannelWidthSet (1): %d\n"), pFrm->HTCaps.supportedChannelWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("mimoPowerSave (2): %d\n"), pFrm->HTCaps.mimoPowerSave);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("greenField (1): %d\n"), pFrm->HTCaps.greenField);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("shortGI20MHz (1): %d\n"), pFrm->HTCaps.shortGI20MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("shortGI40MHz (1): %d\n"), pFrm->HTCaps.shortGI40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("txSTBC (1): %d\n"), pFrm->HTCaps.txSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("rxSTBC (2): %d\n"), pFrm->HTCaps.rxSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("delayedBA (1): %d\n"), pFrm->HTCaps.delayedBA);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("maximalAMSDUsize (1): %d\n"), pFrm->HTCaps.maximalAMSDUsize);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("dsssCckMode40MHz (1): %d\n"), pFrm->HTCaps.dsssCckMode40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("psmp (1): %d\n"), pFrm->HTCaps.psmp);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("stbcControlFrame (1): %d\n"), pFrm->HTCaps.stbcControlFrame);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("lsigTXOPProtection (1): %d\n"), pFrm->HTCaps.lsigTXOPProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("maxRxAMPDUFactor (2): %d\n"), pFrm->HTCaps.maxRxAMPDUFactor);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("mpduDensity (3): %d\n"), pFrm->HTCaps.mpduDensity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved1 (3): %d\n"), pFrm->HTCaps.reserved1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->HTCaps.supportedMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("pco (1): %d\n"), pFrm->HTCaps.pco);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("transitionTime (2): %d\n"), pFrm->HTCaps.transitionTime);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved2 (5): %d\n"), pFrm->HTCaps.reserved2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("mcsFeedback (2): %d\n"), pFrm->HTCaps.mcsFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved3 (6): %d\n"), pFrm->HTCaps.reserved3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("txBF (1): %d\n"), pFrm->HTCaps.txBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("rxStaggeredSounding (1): %d\n"), pFrm->HTCaps.rxStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("txStaggeredSounding (1): %d\n"), pFrm->HTCaps.txStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("rxZLF (1): %d\n"), pFrm->HTCaps.rxZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("txZLF (1): %d\n"), pFrm->HTCaps.txZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("implicitTxBF (1): %d\n"), pFrm->HTCaps.implicitTxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("calibration (2): %d\n"), pFrm->HTCaps.calibration);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("explicitCSITxBF (1): %d\n"), pFrm->HTCaps.explicitCSITxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("explicitUncompressedSteeringMatrix (1): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrix);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("explicitBFCSIFeedback (3): %d\n"), pFrm->HTCaps.explicitBFCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("explicitUncompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("explicitCompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitCompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("csiNumBFAntennae (2): %d\n"), pFrm->HTCaps.csiNumBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("uncompressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.uncompressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("compressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.compressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved4 (7): %d\n"), pFrm->HTCaps.reserved4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("antennaSelection (1): %d\n"), pFrm->HTCaps.antennaSelection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("explicitCSIFeedbackTx (1): %d\n"), pFrm->HTCaps.explicitCSIFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("antennaIndicesFeedbackTx (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("explicitCSIFeedback (1): %d\n"), pFrm->HTCaps.explicitCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("antennaIndicesFeedback (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("rxAS (1): %d\n"), pFrm->HTCaps.rxAS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("txSoundingPPDUs (1): %d\n"), pFrm->HTCaps.txSoundingPPDUs);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved5 (1): %d\n"), pFrm->HTCaps.reserved5);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_rsvd: %d.\n"), pFrm->HTCaps.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->HTCaps.rsvd, pFrm->HTCaps.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("WMMCaps:\n"));
        if (!pFrm->WMMCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->WMMCaps.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved (4): %d\n"), pFrm->WMMCaps.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("qack (1): %d\n"), pFrm->WMMCaps.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("queue_request (1): %d\n"), pFrm->WMMCaps.queue_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("txop_request (1): %d\n"), pFrm->WMMCaps.txop_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("more_ack (1): %d\n"), pFrm->WMMCaps.more_ack);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("WMMInfoStation:\n"));
        if (!pFrm->WMMInfoStation.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->WMMInfoStation.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvo_uapsd (1): %d\n"), pFrm->WMMInfoStation.acvo_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvi_uapsd (1): %d\n"), pFrm->WMMInfoStation.acvi_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbk_uapsd (1): %d\n"), pFrm->WMMInfoStation.acbk_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbe_uapsd (1): %d\n"), pFrm->WMMInfoStation.acbe_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved1 (1): %d\n"), pFrm->WMMInfoStation.reserved1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("max_sp_length (2): %d\n"), pFrm->WMMInfoStation.max_sp_length);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved2 (1): %d\n"), pFrm->WMMInfoStation.reserved2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Airgo:\n"));
        if (!pFrm->Airgo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("PropSuppRates:\n"));
            if (!pFrm->Airgo.PropSuppRates.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_rates: %d.\n"), pFrm->Airgo.PropSuppRates.num_rates);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->Airgo.PropSuppRates.rates, pFrm->Airgo.PropSuppRates.num_rates);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("APName:\n"));
            if (!pFrm->Airgo.APName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_name: %d.\n"), pFrm->Airgo.APName.num_name);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->Airgo.APName.name, pFrm->Airgo.APName.num_name);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("HCF:\n"));
            if (!pFrm->Airgo.HCF.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.HCF.enabled, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("WDS:\n"));
            if (!pFrm->Airgo.WDS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_wdsData: %d.\n"), pFrm->Airgo.WDS.num_wdsData);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->Airgo.WDS.wdsData, pFrm->Airgo.WDS.num_wdsData);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("BPIndicator:\n"));
            if (!pFrm->Airgo.BPIndicator.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.BPIndicator.indicator, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.BPIndicator.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("LoadInfo:\n"));
            if (!pFrm->Airgo.LoadInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.LoadInfo.num_stas, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.LoadInfo.channel_util, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("LoadBalance:\n"));
            if (!pFrm->Airgo.LoadBalance.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.LoadBalance.bssid, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.LoadBalance.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("PropAssocType:\n"));
            if (!pFrm->Airgo.PropAssocType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropAssocType.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("LLAttr:\n"));
            if (!pFrm->Airgo.LLAttr.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.LLAttr.defer_threshold, 4);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("PropCapability:\n"));
            if (!pFrm->Airgo.PropCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropCapability.capability, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Version:\n"));
            if (!pFrm->Airgo.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Version.chip_rev, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Version.card_type, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_build_version: %d.\n"), pFrm->Airgo.Version.num_build_version);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->Airgo.Version.build_version, pFrm->Airgo.Version.num_build_version);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("PropEDCAParams:\n"));
            if (!pFrm->Airgo.PropEDCAParams.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.qos, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.reserved, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbe_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbe_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbe_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("unused1 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbe_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbe_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbe_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbk_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbk_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbk_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("unused2 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbk_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acbk_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbk_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvi_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvi_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvi_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("unused3 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvi_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvi_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvi_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvo_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvo_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvo_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("unused4 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused4);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvo_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("acvo_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvo_txoplimit, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Titan:\n"));
            if (!pFrm->Airgo.Titan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Titan.concat_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Titan.compression_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Titan.cb_state, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Titan.rev_fcs_state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("PropChannSwitchAnn:\n"));
            if (!pFrm->Airgo.PropChannSwitchAnn.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.mode, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.primary_channel, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.sub_band, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.channel_switch_count, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("PropQuietBSS:\n"));
            if (!pFrm->Airgo.PropQuietBSS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_count, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_period, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_duration, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_offset, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("TriggerStaBgScan:\n"));
            if (!pFrm->Airgo.TriggerStaBgScan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.TriggerStaBgScan.enable, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Taurus:\n"));
            if (!pFrm->Airgo.Taurus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Taurus.baTIDBitmap, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Taurus.baPolicy, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("baBufferSize (12): %d\n"), pFrm->Airgo.Taurus.baBufferSize);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("rsvd (4): %d\n"), pFrm->Airgo.Taurus.rsvd);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("WscIEOpaque:\n"));
        if (!pFrm->WscIEOpaque.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_data: %d.\n"), pFrm->WscIEOpaque.num_data);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->WscIEOpaque.data, pFrm->WscIEOpaque.num_data);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("WAPIOpaque:\n"));
        if (!pFrm->WAPIOpaque.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_data: %d.\n"), pFrm->WAPIOpaque.num_data);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->WAPIOpaque.data, pFrm->WAPIOpaque.num_data);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("CCXRadMgmtCap:\n"));
        if (!pFrm->CCXRadMgmtCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->CCXRadMgmtCap.mgmt_state, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("mbssid_mask (3): %d\n"), pFrm->CCXRadMgmtCap.mbssid_mask);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("reserved (5): %d\n"), pFrm->CCXRadMgmtCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("CCXVersion:\n"));
        if (!pFrm->CCXVersion.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* )&pFrm->CCXVersion.version, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("P2PIEOpaque:\n"));
        if (!pFrm->P2PIEOpaque.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), FRFL("num_data: %d.\n"), pFrm->P2PIEOpaque.num_data);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCREQUEST), ( tANI_U8* ) pFrm->P2PIEOpaque.data, pFrm->P2PIEOpaque.num_data);
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackAssocRequest. */

    static const tFFDefn FFS_AssocResponse[] = {
        { "Capabilities", offsetof(tDot11fAssocResponse, Capabilities), SigFfCapabilities , DOT11F_FF_CAPABILITIES_LEN, },
        { "Status", offsetof(tDot11fAssocResponse, Status), SigFfStatus , DOT11F_FF_STATUS_LEN, },
        { "AID", offsetof(tDot11fAssocResponse, AID), SigFfAID , DOT11F_FF_AID_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_AssocResponse[] = {
        {offsetof(tDot11fAssocResponse, SuppRates), offsetof(tDot11fIESuppRates, present), 0, "SuppRates" , 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPRATES, 1, },
        {offsetof(tDot11fAssocResponse, ExtSuppRates), offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates" , 0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTSUPPRATES, 0, },
        {offsetof(tDot11fAssocResponse, EDCAParamSet), offsetof(tDot11fIEEDCAParamSet, present), 0, "EDCAParamSet" , 0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EDCAPARAMSET, 0, },
        {offsetof(tDot11fAssocResponse, RCPIIE), offsetof(tDot11fIERCPIIE, present), 0, "RCPIIE" , 0, 3, 3, SigIeRCPIIE, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RCPIIE, 0, },
        {offsetof(tDot11fAssocResponse, RSNIIE), offsetof(tDot11fIERSNIIE, present), 0, "RSNIIE" , 0, 3, 3, SigIeRSNIIE, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSNIIE, 0, },
        {offsetof(tDot11fAssocResponse, RRMEnabledCap), offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap" , 0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RRMENABLEDCAP, 0, },
        {offsetof(tDot11fAssocResponse, MobilityDomain), offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain" , 0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MOBILITYDOMAIN, 0, },
        {offsetof(tDot11fAssocResponse, FTInfo), offsetof(tDot11fIEFTInfo, present), 0, "FTInfo" , 0, 84, 187, SigIeFTInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FTINFO, 0, },
        {offsetof(tDot11fAssocResponse, RICDataDesc), offsetof(tDot11fIERICDataDesc, present), offsetof(tDot11fAssocResponse, num_RICDataDesc), "RICDataDesc" , 2, 2, 550, SigIeRICDataDesc, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RICDATADESC, 0, },
        {offsetof(tDot11fAssocResponse, WPA), offsetof(tDot11fIEWPA, present), 0, "WPA" , 0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPA, 0, },
        {offsetof(tDot11fAssocResponse, HTCaps), offsetof(tDot11fIEHTCaps, present), 0, "HTCaps" , 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTCAPS, 0, },
        {offsetof(tDot11fAssocResponse, HTInfo), offsetof(tDot11fIEHTInfo, present), 0, "HTInfo" , 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTINFO, 0, },
        {offsetof(tDot11fAssocResponse, WMMParams), offsetof(tDot11fIEWMMParams, present), 0, "WMMParams" , 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1}, 5, DOT11F_EID_WMMPARAMS, 0, },
        {offsetof(tDot11fAssocResponse, WMMCaps), offsetof(tDot11fIEWMMCaps, present), 0, "WMMCaps" , 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5}, 5, DOT11F_EID_WMMCAPS, 0, },
        {offsetof(tDot11fAssocResponse, CCXRadMgmtCap), offsetof(tDot11fIECCXRadMgmtCap, present), 0, "CCXRadMgmtCap" , 0, 8, 8, SigIeCCXRadMgmtCap, {0, 64, 150, 1, 0}, 4, DOT11F_EID_CCXRADMGMTCAP, 0, },
        {offsetof(tDot11fAssocResponse, CCXTrafStrmMet), offsetof(tDot11fIECCXTrafStrmMet, present), 0, "CCXTrafStrmMet" , 0, 10, 10, SigIeCCXTrafStrmMet, {0, 64, 150, 7, 0}, 4, DOT11F_EID_CCXTRAFSTRMMET, 0, },
        {offsetof(tDot11fAssocResponse, CCXTxmitPower), offsetof(tDot11fIECCXTxmitPower, present), 0, "CCXTxmitPower" , 0, 8, 8, SigIeCCXTxmitPower, {0, 64, 150, 0, 0}, 4, DOT11F_EID_CCXTXMITPOWER, 0, },
        {offsetof(tDot11fAssocResponse, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC, present), offsetof(tDot11fAssocResponse, num_WMMTSPEC), "WMMTSPEC" , 4, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2}, 5, DOT11F_EID_WMMTSPEC, 0, },
        {offsetof(tDot11fAssocResponse, Airgo), offsetof(tDot11fIEAirgo, present), 0, "Airgo" , 0, 5, 232, SigIeAirgo, {0, 10, 245, 0, 0}, 3, DOT11F_EID_AIRGO, 0, },
        {offsetof(tDot11fAssocResponse, WscAssocRes), offsetof(tDot11fIEWscAssocRes, present), 0, "WscAssocRes" , 0, 6, 37, SigIeWscAssocRes, {0, 80, 242, 4, 0}, 4, DOT11F_EID_WSCASSOCRES, 0, },
        {offsetof(tDot11fAssocResponse, P2PAssocRes), offsetof(tDot11fIEP2PAssocRes, present), 0, "P2PAssocRes" , 0, 6, 17, SigIeP2PAssocRes, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PASSOCRES, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackAssocResponse(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fAssocResponse *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_AssocResponse, IES_AssocResponse, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Unpacked the AssocResponse:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Capabilities:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("ess (1): %d\n"), pFrm->Capabilities.ess);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("ibss (1): %d\n"), pFrm->Capabilities.ibss);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("cfPollable (1): %d\n"), pFrm->Capabilities.cfPollable);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("cfPollReq (1): %d\n"), pFrm->Capabilities.cfPollReq);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("privacy (1): %d\n"), pFrm->Capabilities.privacy);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("shortPreamble (1): %d\n"), pFrm->Capabilities.shortPreamble);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("pbcc (1): %d\n"), pFrm->Capabilities.pbcc);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("channelAgility (1): %d\n"), pFrm->Capabilities.channelAgility);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("spectrumMgt (1): %d\n"), pFrm->Capabilities.spectrumMgt);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("qos (1): %d\n"), pFrm->Capabilities.qos);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("shortSlotTime (1): %d\n"), pFrm->Capabilities.shortSlotTime);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("apsd (1): %d\n"), pFrm->Capabilities.apsd);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("rrm (1): %d\n"), pFrm->Capabilities.rrm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("dsssOfdm (1): %d\n"), pFrm->Capabilities.dsssOfdm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("delayedBA (1): %d\n"), pFrm->Capabilities.delayedBA);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("immediateBA (1): %d\n"), pFrm->Capabilities.immediateBA);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Status:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Status.status, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("AID:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->AID.associd, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("SuppRates:\n"));
        if (!pFrm->SuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_rates: %d.\n"), pFrm->SuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->SuppRates.rates, pFrm->SuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("ExtSuppRates:\n"));
        if (!pFrm->ExtSuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_rates: %d.\n"), pFrm->ExtSuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->ExtSuppRates.rates, pFrm->ExtSuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("EDCAParamSet:\n"));
        if (!pFrm->EDCAParamSet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.qos, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.reserved, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_aifsn (4): %d\n"), pFrm->EDCAParamSet.acbe_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_acm (1): %d\n"), pFrm->EDCAParamSet.acbe_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_aci (2): %d\n"), pFrm->EDCAParamSet.acbe_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused1 (1): %d\n"), pFrm->EDCAParamSet.unused1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_acwmin (4): %d\n"), pFrm->EDCAParamSet.acbe_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_acwmax (4): %d\n"), pFrm->EDCAParamSet.acbe_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.acbe_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_aifsn (4): %d\n"), pFrm->EDCAParamSet.acbk_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_acm (1): %d\n"), pFrm->EDCAParamSet.acbk_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_aci (2): %d\n"), pFrm->EDCAParamSet.acbk_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused2 (1): %d\n"), pFrm->EDCAParamSet.unused2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_acwmin (4): %d\n"), pFrm->EDCAParamSet.acbk_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_acwmax (4): %d\n"), pFrm->EDCAParamSet.acbk_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.acbk_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_aifsn (4): %d\n"), pFrm->EDCAParamSet.acvi_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_acm (1): %d\n"), pFrm->EDCAParamSet.acvi_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_aci (2): %d\n"), pFrm->EDCAParamSet.acvi_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused3 (1): %d\n"), pFrm->EDCAParamSet.unused3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_acwmin (4): %d\n"), pFrm->EDCAParamSet.acvi_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_acwmax (4): %d\n"), pFrm->EDCAParamSet.acvi_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.acvi_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_aifsn (4): %d\n"), pFrm->EDCAParamSet.acvo_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_acm (1): %d\n"), pFrm->EDCAParamSet.acvo_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_aci (2): %d\n"), pFrm->EDCAParamSet.acvo_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused4 (1): %d\n"), pFrm->EDCAParamSet.unused4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_acwmin (4): %d\n"), pFrm->EDCAParamSet.acvo_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_acwmax (4): %d\n"), pFrm->EDCAParamSet.acvo_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.acvo_txoplimit, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("RCPIIE:\n"));
        if (!pFrm->RCPIIE.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RCPIIE.rcpi, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("RSNIIE:\n"));
        if (!pFrm->RSNIIE.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RSNIIE.rsni, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("RRMEnabledCap:\n"));
        if (!pFrm->RRMEnabledCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("LinkMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LinkMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("NeighborRpt (1): %d\n"), pFrm->RRMEnabledCap.NeighborRpt);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("parallel (1): %d\n"), pFrm->RRMEnabledCap.parallel);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("repeated (1): %d\n"), pFrm->RRMEnabledCap.repeated);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("BeaconPassive (1): %d\n"), pFrm->RRMEnabledCap.BeaconPassive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("BeaconActive (1): %d\n"), pFrm->RRMEnabledCap.BeaconActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("BeaconTable (1): %d\n"), pFrm->RRMEnabledCap.BeaconTable);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("BeaconRepCond (1): %d\n"), pFrm->RRMEnabledCap.BeaconRepCond);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("FrameMeasurement (1): %d\n"), pFrm->RRMEnabledCap.FrameMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("ChannelLoad (1): %d\n"), pFrm->RRMEnabledCap.ChannelLoad);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("NoiseHistogram (1): %d\n"), pFrm->RRMEnabledCap.NoiseHistogram);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("statistics (1): %d\n"), pFrm->RRMEnabledCap.statistics);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("LCIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LCIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("LCIAzimuth (1): %d\n"), pFrm->RRMEnabledCap.LCIAzimuth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("TCMCapability (1): %d\n"), pFrm->RRMEnabledCap.TCMCapability);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("triggeredTCM (1): %d\n"), pFrm->RRMEnabledCap.triggeredTCM);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("APChanReport (1): %d\n"), pFrm->RRMEnabledCap.APChanReport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("RRMMIBEnabled (1): %d\n"), pFrm->RRMEnabledCap.RRMMIBEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("operatingChanMax (3): %d\n"), pFrm->RRMEnabledCap.operatingChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("nonOperatinChanMax (3): %d\n"), pFrm->RRMEnabledCap.nonOperatinChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("MeasurementPilot (3): %d\n"), pFrm->RRMEnabledCap.MeasurementPilot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("MeasurementPilotEnabled (1): %d\n"), pFrm->RRMEnabledCap.MeasurementPilotEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("NeighborTSFOffset (1): %d\n"), pFrm->RRMEnabledCap.NeighborTSFOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("RCPIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RCPIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("RSNIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RSNIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("BssAvgAccessDelay (1): %d\n"), pFrm->RRMEnabledCap.BssAvgAccessDelay);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("BSSAvailAdmission (1): %d\n"), pFrm->RRMEnabledCap.BSSAvailAdmission);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("AntennaInformation (1): %d\n"), pFrm->RRMEnabledCap.AntennaInformation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved (6): %d\n"), pFrm->RRMEnabledCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("MobilityDomain:\n"));
        if (!pFrm->MobilityDomain.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->MobilityDomain.MDID, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("overDSCap (1): %d\n"), pFrm->MobilityDomain.overDSCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("resourceReqCap (1): %d\n"), pFrm->MobilityDomain.resourceReqCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved (6): %d\n"), pFrm->MobilityDomain.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("FTInfo:\n"));
        if (!pFrm->FTInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved (8): %d\n"), pFrm->FTInfo.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("IECount (8): %d\n"), pFrm->FTInfo.IECount);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->FTInfo.MIC, 16);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->FTInfo.Anonce, 32);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->FTInfo.Snonce, 32);
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("R1KH_ID:\n"));
            if (!pFrm->FTInfo.R1KH_ID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->FTInfo.R1KH_ID.PMK_R1_ID, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("GTK:\n"));
            if (!pFrm->FTInfo.GTK.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("keyId (2): %d\n"), pFrm->FTInfo.GTK.keyId);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved (14): %d\n"), pFrm->FTInfo.GTK.reserved);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->FTInfo.GTK.keyLength, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->FTInfo.GTK.RSC, 8);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_key: %d.\n"), pFrm->FTInfo.GTK.num_key);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->FTInfo.GTK.key, pFrm->FTInfo.GTK.num_key);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("R0KH_ID:\n"));
            if (!pFrm->FTInfo.R0KH_ID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_PMK_R0_ID: %d.\n"), pFrm->FTInfo.R0KH_ID.num_PMK_R0_ID);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->FTInfo.R0KH_ID.PMK_R0_ID, pFrm->FTInfo.R0KH_ID.num_PMK_R0_ID);
            }
        }
        for (i = 0; i < pFrm->num_RICDataDesc; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("RICDataDesc[%d]:\n"), i);
            if (!pFrm->RICDataDesc[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("RICData:\n"));
                if (!pFrm->RICDataDesc[i].RICData.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].RICData.Identifier, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].RICData.resourceDescCount, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].RICData.statusCode, 2);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("RICDescriptor:\n"));
                if (!pFrm->RICDataDesc[i].RICDescriptor.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].RICDescriptor.resourceType, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_variableData: %d.\n"), pFrm->RICDataDesc[i].RICDescriptor.num_variableData);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->RICDataDesc[i].RICDescriptor.variableData, pFrm->RICDataDesc[i].RICDescriptor.num_variableData);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("TSPEC:\n"));
                if (!pFrm->RICDataDesc[i].TSPEC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("traffic_type (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.traffic_type);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].TSPEC.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].TSPEC.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("access_policy (2): %d\n"), pFrm->RICDataDesc[i].TSPEC.access_policy);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("psb (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.psb);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("user_priority (3): %d\n"), pFrm->RICDataDesc[i].TSPEC.user_priority);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->RICDataDesc[i].TSPEC.tsinfo_ack_pol);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("schedule (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.schedule);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused (7): %d\n"), pFrm->RICDataDesc[i].TSPEC.unused);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("size (15): %d\n"), pFrm->RICDataDesc[i].TSPEC.size);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("fixed (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.fixed);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.max_msdu_size, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.min_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.max_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.inactivity_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.suspension_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.min_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.mean_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.peak_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.burst_size, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.delay_bound, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.min_phy_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.surplus_bw_allowance, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.medium_time, 2);
                }
                for (i = 0; i < pFrm->RICDataDesc[i].num_TCLAS; ++i)
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("TCLAS[%d]:\n"), i);
                    if (!pFrm->RICDataDesc[i].TCLAS[i].present)
                    {
                        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                    }
                    else
                    {
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].user_priority, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].classifier_type, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].classifier_mask, 1);
                        switch (pFrm->RICDataDesc[i].TCLAS[i].classifier_type)
                        {
                            case 0:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.EthParams.source, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.EthParams.dest, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.EthParams.type, 2);
                            break;
                            case 1:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.version, 1);
                                switch (pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.version)
                                {
                                    case 4:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.source, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.dest, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.DSCP, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.proto, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.reserved, 1);
                                    break;
                                    case 6:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.source, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.dest, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.flow_label, 3);
                                    break;
                                }
                            break;
                            case 2:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.Params8021dq.tag_type, 2);
                            break;
                        }
                    }
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("TCLASSPROC:\n"));
                if (!pFrm->RICDataDesc[i].TCLASSPROC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLASSPROC.processing, 1);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("TSDelay:\n"));
                if (!pFrm->RICDataDesc[i].TSDelay.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].TSDelay.delay, 4);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Schedule:\n"));
                if (!pFrm->RICDataDesc[i].Schedule.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].Schedule.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].Schedule.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].Schedule.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved (9): %d\n"), pFrm->RICDataDesc[i].Schedule.reserved);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.service_interval, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.max_service_dur, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.spec_interval, 2);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WMMTSPEC:\n"));
                if (!pFrm->RICDataDesc[i].WMMTSPEC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.version, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("traffic_type (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.traffic_type);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("access_policy (2): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.access_policy);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("psb (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.psb);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("user_priority (3): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.user_priority);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.tsinfo_ack_pol);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("tsinfo_rsvd (7): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.tsinfo_rsvd);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("burst_size_defn (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.burst_size_defn);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("size (15): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.size);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("fixed (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.fixed);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.max_msdu_size, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.min_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.max_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.inactivity_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.suspension_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.min_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.mean_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.peak_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.burst_size, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.delay_bound, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.min_phy_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.surplus_bw_allowance, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.medium_time, 2);
                }
                for (i = 0; i < pFrm->RICDataDesc[i].num_WMMTCLAS; ++i)
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WMMTCLAS[%d]:\n"), i);
                    if (!pFrm->RICDataDesc[i].WMMTCLAS[i].present)
                    {
                        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                    }
                    else
                    {
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].version, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].user_priority, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].classifier_type, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].classifier_mask, 1);
                        switch (pFrm->RICDataDesc[i].WMMTCLAS[i].classifier_type)
                        {
                            case 0:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.EthParams.source, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.EthParams.dest, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.EthParams.type, 2);
                            break;
                            case 1:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.version, 1);
                                switch (pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.version)
                                {
                                    case 4:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.source, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.dest, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.DSCP, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.proto, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.reserved, 1);
                                    break;
                                    case 6:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.source, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.dest, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.flow_label, 3);
                                    break;
                                }
                            break;
                            case 2:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.Params8021dq.tag_type, 2);
                            break;
                        }
                    }
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WMMTCLASPROC:\n"));
                if (!pFrm->RICDataDesc[i].WMMTCLASPROC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLASPROC.version, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLASPROC.processing, 1);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WMMTSDelay:\n"));
                if (!pFrm->RICDataDesc[i].WMMTSDelay.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSDelay.version, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSDelay.delay, 4);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WMMSchedule:\n"));
                if (!pFrm->RICDataDesc[i].WMMSchedule.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.version, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved (9): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.reserved);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.service_interval, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.max_service_dur, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.spec_interval, 2);
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WPA:\n"));
        if (!pFrm->WPA.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WPA.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WPA.multicast_cipher, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WPA.unicast_cipher_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->WPA.unicast_ciphers, 4 * pFrm->WPA.unicast_cipher_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WPA.auth_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->WPA.auth_suites, 4 * pFrm->WPA.auth_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WPA.caps, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("HTCaps:\n"));
        if (!pFrm->HTCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("advCodingCap (1): %d\n"), pFrm->HTCaps.advCodingCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("supportedChannelWidthSet (1): %d\n"), pFrm->HTCaps.supportedChannelWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("mimoPowerSave (2): %d\n"), pFrm->HTCaps.mimoPowerSave);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("greenField (1): %d\n"), pFrm->HTCaps.greenField);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("shortGI20MHz (1): %d\n"), pFrm->HTCaps.shortGI20MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("shortGI40MHz (1): %d\n"), pFrm->HTCaps.shortGI40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("txSTBC (1): %d\n"), pFrm->HTCaps.txSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("rxSTBC (2): %d\n"), pFrm->HTCaps.rxSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("delayedBA (1): %d\n"), pFrm->HTCaps.delayedBA);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("maximalAMSDUsize (1): %d\n"), pFrm->HTCaps.maximalAMSDUsize);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("dsssCckMode40MHz (1): %d\n"), pFrm->HTCaps.dsssCckMode40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("psmp (1): %d\n"), pFrm->HTCaps.psmp);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("stbcControlFrame (1): %d\n"), pFrm->HTCaps.stbcControlFrame);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("lsigTXOPProtection (1): %d\n"), pFrm->HTCaps.lsigTXOPProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("maxRxAMPDUFactor (2): %d\n"), pFrm->HTCaps.maxRxAMPDUFactor);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("mpduDensity (3): %d\n"), pFrm->HTCaps.mpduDensity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved1 (3): %d\n"), pFrm->HTCaps.reserved1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->HTCaps.supportedMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("pco (1): %d\n"), pFrm->HTCaps.pco);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("transitionTime (2): %d\n"), pFrm->HTCaps.transitionTime);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved2 (5): %d\n"), pFrm->HTCaps.reserved2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("mcsFeedback (2): %d\n"), pFrm->HTCaps.mcsFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved3 (6): %d\n"), pFrm->HTCaps.reserved3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("txBF (1): %d\n"), pFrm->HTCaps.txBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("rxStaggeredSounding (1): %d\n"), pFrm->HTCaps.rxStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("txStaggeredSounding (1): %d\n"), pFrm->HTCaps.txStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("rxZLF (1): %d\n"), pFrm->HTCaps.rxZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("txZLF (1): %d\n"), pFrm->HTCaps.txZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("implicitTxBF (1): %d\n"), pFrm->HTCaps.implicitTxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("calibration (2): %d\n"), pFrm->HTCaps.calibration);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("explicitCSITxBF (1): %d\n"), pFrm->HTCaps.explicitCSITxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("explicitUncompressedSteeringMatrix (1): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrix);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("explicitBFCSIFeedback (3): %d\n"), pFrm->HTCaps.explicitBFCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("explicitUncompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("explicitCompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitCompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("csiNumBFAntennae (2): %d\n"), pFrm->HTCaps.csiNumBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("uncompressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.uncompressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("compressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.compressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved4 (7): %d\n"), pFrm->HTCaps.reserved4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("antennaSelection (1): %d\n"), pFrm->HTCaps.antennaSelection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("explicitCSIFeedbackTx (1): %d\n"), pFrm->HTCaps.explicitCSIFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("antennaIndicesFeedbackTx (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("explicitCSIFeedback (1): %d\n"), pFrm->HTCaps.explicitCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("antennaIndicesFeedback (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("rxAS (1): %d\n"), pFrm->HTCaps.rxAS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("txSoundingPPDUs (1): %d\n"), pFrm->HTCaps.txSoundingPPDUs);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved5 (1): %d\n"), pFrm->HTCaps.reserved5);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_rsvd: %d.\n"), pFrm->HTCaps.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->HTCaps.rsvd, pFrm->HTCaps.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("HTInfo:\n"));
        if (!pFrm->HTInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->HTInfo.primaryChannel, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("secondaryChannelOffset (2): %d\n"), pFrm->HTInfo.secondaryChannelOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("recommendedTxWidthSet (1): %d\n"), pFrm->HTInfo.recommendedTxWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("rifsMode (1): %d\n"), pFrm->HTInfo.rifsMode);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("controlledAccessOnly (1): %d\n"), pFrm->HTInfo.controlledAccessOnly);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("serviceIntervalGranularity (3): %d\n"), pFrm->HTInfo.serviceIntervalGranularity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("opMode (2): %d\n"), pFrm->HTInfo.opMode);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("nonGFDevicesPresent (1): %d\n"), pFrm->HTInfo.nonGFDevicesPresent);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("transmitBurstLimit (1): %d\n"), pFrm->HTInfo.transmitBurstLimit);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("obssNonHTStaPresent (1): %d\n"), pFrm->HTInfo.obssNonHTStaPresent);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved (11): %d\n"), pFrm->HTInfo.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("basicSTBCMCS (7): %d\n"), pFrm->HTInfo.basicSTBCMCS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("dualCTSProtection (1): %d\n"), pFrm->HTInfo.dualCTSProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("secondaryBeacon (1): %d\n"), pFrm->HTInfo.secondaryBeacon);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("lsigTXOPProtectionFullSupport (1): %d\n"), pFrm->HTInfo.lsigTXOPProtectionFullSupport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("pcoActive (1): %d\n"), pFrm->HTInfo.pcoActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("pcoPhase (1): %d\n"), pFrm->HTInfo.pcoPhase);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved2 (4): %d\n"), pFrm->HTInfo.reserved2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->HTInfo.basicMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_rsvd: %d.\n"), pFrm->HTInfo.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->HTInfo.rsvd, pFrm->HTInfo.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WMMParams:\n"));
        if (!pFrm->WMMParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMParams.version, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMParams.qosInfo, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMParams.reserved2, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_aifsn (4): %d\n"), pFrm->WMMParams.acbe_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_acm (1): %d\n"), pFrm->WMMParams.acbe_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_aci (2): %d\n"), pFrm->WMMParams.acbe_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused1 (1): %d\n"), pFrm->WMMParams.unused1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_acwmin (4): %d\n"), pFrm->WMMParams.acbe_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_acwmax (4): %d\n"), pFrm->WMMParams.acbe_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMParams.acbe_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_aifsn (4): %d\n"), pFrm->WMMParams.acbk_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_acm (1): %d\n"), pFrm->WMMParams.acbk_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_aci (2): %d\n"), pFrm->WMMParams.acbk_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused2 (1): %d\n"), pFrm->WMMParams.unused2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_acwmin (4): %d\n"), pFrm->WMMParams.acbk_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_acwmax (4): %d\n"), pFrm->WMMParams.acbk_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMParams.acbk_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_aifsn (4): %d\n"), pFrm->WMMParams.acvi_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_acm (1): %d\n"), pFrm->WMMParams.acvi_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_aci (2): %d\n"), pFrm->WMMParams.acvi_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused3 (1): %d\n"), pFrm->WMMParams.unused3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_acwmin (4): %d\n"), pFrm->WMMParams.acvi_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_acwmax (4): %d\n"), pFrm->WMMParams.acvi_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMParams.acvi_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_aifsn (4): %d\n"), pFrm->WMMParams.acvo_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_acm (1): %d\n"), pFrm->WMMParams.acvo_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_aci (2): %d\n"), pFrm->WMMParams.acvo_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused4 (1): %d\n"), pFrm->WMMParams.unused4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_acwmin (4): %d\n"), pFrm->WMMParams.acvo_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_acwmax (4): %d\n"), pFrm->WMMParams.acvo_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMParams.acvo_txoplimit, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WMMCaps:\n"));
        if (!pFrm->WMMCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMCaps.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved (4): %d\n"), pFrm->WMMCaps.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("qack (1): %d\n"), pFrm->WMMCaps.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("queue_request (1): %d\n"), pFrm->WMMCaps.queue_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("txop_request (1): %d\n"), pFrm->WMMCaps.txop_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("more_ack (1): %d\n"), pFrm->WMMCaps.more_ack);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("CCXRadMgmtCap:\n"));
        if (!pFrm->CCXRadMgmtCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->CCXRadMgmtCap.mgmt_state, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("mbssid_mask (3): %d\n"), pFrm->CCXRadMgmtCap.mbssid_mask);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("reserved (5): %d\n"), pFrm->CCXRadMgmtCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("CCXTrafStrmMet:\n"));
        if (!pFrm->CCXTrafStrmMet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->CCXTrafStrmMet.tsid, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->CCXTrafStrmMet.state, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->CCXTrafStrmMet.msmt_interval, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("CCXTxmitPower:\n"));
        if (!pFrm->CCXTxmitPower.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->CCXTxmitPower.power_limit, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->CCXTxmitPower.reserved, 1);
        }
        for (i = 0; i < pFrm->num_WMMTSPEC; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WMMTSPEC[%d]:\n"), i);
            if (!pFrm->WMMTSPEC[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].version, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("traffic_type (1): %d\n"), pFrm->WMMTSPEC[i].traffic_type);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("tsid (4): %d\n"), pFrm->WMMTSPEC[i].tsid);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("direction (2): %d\n"), pFrm->WMMTSPEC[i].direction);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("access_policy (2): %d\n"), pFrm->WMMTSPEC[i].access_policy);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("aggregation (1): %d\n"), pFrm->WMMTSPEC[i].aggregation);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("psb (1): %d\n"), pFrm->WMMTSPEC[i].psb);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("user_priority (3): %d\n"), pFrm->WMMTSPEC[i].user_priority);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->WMMTSPEC[i].tsinfo_ack_pol);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("tsinfo_rsvd (7): %d\n"), pFrm->WMMTSPEC[i].tsinfo_rsvd);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("burst_size_defn (1): %d\n"), pFrm->WMMTSPEC[i].burst_size_defn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("size (15): %d\n"), pFrm->WMMTSPEC[i].size);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("fixed (1): %d\n"), pFrm->WMMTSPEC[i].fixed);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].max_msdu_size, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].min_service_int, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].max_service_int, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].inactivity_int, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].suspension_int, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].service_start_time, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].min_data_rate, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].mean_data_rate, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].peak_data_rate, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].burst_size, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].delay_bound, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].min_phy_rate, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].surplus_bw_allowance, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WMMTSPEC[i].medium_time, 2);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Airgo:\n"));
        if (!pFrm->Airgo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("PropSuppRates:\n"));
            if (!pFrm->Airgo.PropSuppRates.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_rates: %d.\n"), pFrm->Airgo.PropSuppRates.num_rates);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->Airgo.PropSuppRates.rates, pFrm->Airgo.PropSuppRates.num_rates);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("APName:\n"));
            if (!pFrm->Airgo.APName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_name: %d.\n"), pFrm->Airgo.APName.num_name);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->Airgo.APName.name, pFrm->Airgo.APName.num_name);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("HCF:\n"));
            if (!pFrm->Airgo.HCF.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.HCF.enabled, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WDS:\n"));
            if (!pFrm->Airgo.WDS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_wdsData: %d.\n"), pFrm->Airgo.WDS.num_wdsData);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->Airgo.WDS.wdsData, pFrm->Airgo.WDS.num_wdsData);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("BPIndicator:\n"));
            if (!pFrm->Airgo.BPIndicator.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.BPIndicator.indicator, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.BPIndicator.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("LoadInfo:\n"));
            if (!pFrm->Airgo.LoadInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.LoadInfo.num_stas, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.LoadInfo.channel_util, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("LoadBalance:\n"));
            if (!pFrm->Airgo.LoadBalance.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.LoadBalance.bssid, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.LoadBalance.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("PropAssocType:\n"));
            if (!pFrm->Airgo.PropAssocType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropAssocType.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("LLAttr:\n"));
            if (!pFrm->Airgo.LLAttr.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.LLAttr.defer_threshold, 4);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("PropCapability:\n"));
            if (!pFrm->Airgo.PropCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropCapability.capability, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Version:\n"));
            if (!pFrm->Airgo.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.Version.chip_rev, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.Version.card_type, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("num_build_version: %d.\n"), pFrm->Airgo.Version.num_build_version);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* ) pFrm->Airgo.Version.build_version, pFrm->Airgo.Version.num_build_version);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("PropEDCAParams:\n"));
            if (!pFrm->Airgo.PropEDCAParams.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.qos, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.reserved, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused1 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbe_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbe_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused2 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acbk_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbk_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused3 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvi_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvi_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("unused4 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused4);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("acvo_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvo_txoplimit, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Titan:\n"));
            if (!pFrm->Airgo.Titan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.Titan.concat_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.Titan.compression_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.Titan.cb_state, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.Titan.rev_fcs_state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("PropChannSwitchAnn:\n"));
            if (!pFrm->Airgo.PropChannSwitchAnn.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.mode, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.primary_channel, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.sub_band, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.channel_switch_count, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("PropQuietBSS:\n"));
            if (!pFrm->Airgo.PropQuietBSS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_count, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_period, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_duration, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_offset, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("TriggerStaBgScan:\n"));
            if (!pFrm->Airgo.TriggerStaBgScan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.TriggerStaBgScan.enable, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Taurus:\n"));
            if (!pFrm->Airgo.Taurus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.Taurus.baTIDBitmap, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->Airgo.Taurus.baPolicy, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("baBufferSize (12): %d\n"), pFrm->Airgo.Taurus.baBufferSize);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("rsvd (4): %d\n"), pFrm->Airgo.Taurus.rsvd);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("WscAssocRes:\n"));
        if (!pFrm->WscAssocRes.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Version:\n"));
            if (!pFrm->WscAssocRes.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("minor (4): %d\n"), pFrm->WscAssocRes.Version.minor);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("major (4): %d\n"), pFrm->WscAssocRes.Version.major);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("ResponseType:\n"));
            if (!pFrm->WscAssocRes.ResponseType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WscAssocRes.ResponseType.resType, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("VendorExtension:\n"));
            if (!pFrm->WscAssocRes.VendorExtension.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WscAssocRes.VendorExtension.vendorId, 3);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Version2:\n"));
                if (!pFrm->WscAssocRes.VendorExtension.Version2.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("minor (4): %d\n"), pFrm->WscAssocRes.VendorExtension.Version2.minor);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("major (4): %d\n"), pFrm->WscAssocRes.VendorExtension.Version2.major);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("AuthorizedMACs:\n"));
                if (!pFrm->WscAssocRes.VendorExtension.AuthorizedMACs.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WscAssocRes.VendorExtension.AuthorizedMACs.mac, 6);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("RequestToEnroll:\n"));
                if (!pFrm->WscAssocRes.VendorExtension.RequestToEnroll.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->WscAssocRes.VendorExtension.RequestToEnroll.req, 1);
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("P2PAssocRes:\n"));
        if (!pFrm->P2PAssocRes.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("P2PStatus:\n"));
            if (!pFrm->P2PAssocRes.P2PStatus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->P2PAssocRes.P2PStatus.status, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("ExtendedListenTiming:\n"));
            if (!pFrm->P2PAssocRes.ExtendedListenTiming.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->P2PAssocRes.ExtendedListenTiming.availibilityPeriod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_ASSOCRESPONSE), ( tANI_U8* )&pFrm->P2PAssocRes.ExtendedListenTiming.availibilityInterval, 2);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackAssocResponse. */

    static const tFFDefn FFS_Authentication[] = {
        { "AuthAlgo", offsetof(tDot11fAuthentication, AuthAlgo), SigFfAuthAlgo , DOT11F_FF_AUTHALGO_LEN, },
        { "AuthSeqNo", offsetof(tDot11fAuthentication, AuthSeqNo), SigFfAuthSeqNo , DOT11F_FF_AUTHSEQNO_LEN, },
        { "Status", offsetof(tDot11fAuthentication, Status), SigFfStatus , DOT11F_FF_STATUS_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_Authentication[] = {
        {offsetof(tDot11fAuthentication, ChallengeText), offsetof(tDot11fIEChallengeText, present), 0, "ChallengeText" , 0, 3, 255, SigIeChallengeText, {0, 0, 0, 0, 0}, 0, DOT11F_EID_CHALLENGETEXT, 0, },
        {offsetof(tDot11fAuthentication, RSNOpaque), offsetof(tDot11fIERSNOpaque, present), 0, "RSNOpaque" , 0, 8, 255, SigIeRSNOpaque, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSNOPAQUE, 0, },
        {offsetof(tDot11fAuthentication, MobilityDomain), offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain" , 0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MOBILITYDOMAIN, 0, },
        {offsetof(tDot11fAuthentication, FTInfo), offsetof(tDot11fIEFTInfo, present), 0, "FTInfo" , 0, 84, 187, SigIeFTInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FTINFO, 0, },
        {offsetof(tDot11fAuthentication, FTTimeoutInterval), offsetof(tDot11fIEFTTimeoutInterval, present), 0, "FTTimeoutInterval" , 0, 7, 7, SigIeFTTimeoutInterval, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FTTIMEOUTINTERVAL, 0, },
        {offsetof(tDot11fAuthentication, RICDataDesc), offsetof(tDot11fIERICDataDesc, present), offsetof(tDot11fAuthentication, num_RICDataDesc), "RICDataDesc" , 2, 2, 550, SigIeRICDataDesc, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RICDATADESC, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackAuthentication(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fAuthentication *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_Authentication, IES_Authentication, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Unpacked the Authentication:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("AuthAlgo:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->AuthAlgo.algo, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("AuthSeqNo:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->AuthSeqNo.no, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Status:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->Status.status, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("ChallengeText:\n"));
        if (!pFrm->ChallengeText.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("num_text: %d.\n"), pFrm->ChallengeText.num_text);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* ) pFrm->ChallengeText.text, pFrm->ChallengeText.num_text);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("RSNOpaque:\n"));
        if (!pFrm->RSNOpaque.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("num_data: %d.\n"), pFrm->RSNOpaque.num_data);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* ) pFrm->RSNOpaque.data, pFrm->RSNOpaque.num_data);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("MobilityDomain:\n"));
        if (!pFrm->MobilityDomain.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->MobilityDomain.MDID, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("overDSCap (1): %d\n"), pFrm->MobilityDomain.overDSCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("resourceReqCap (1): %d\n"), pFrm->MobilityDomain.resourceReqCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("reserved (6): %d\n"), pFrm->MobilityDomain.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("FTInfo:\n"));
        if (!pFrm->FTInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("reserved (8): %d\n"), pFrm->FTInfo.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("IECount (8): %d\n"), pFrm->FTInfo.IECount);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->FTInfo.MIC, 16);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->FTInfo.Anonce, 32);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->FTInfo.Snonce, 32);
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("R1KH_ID:\n"));
            if (!pFrm->FTInfo.R1KH_ID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->FTInfo.R1KH_ID.PMK_R1_ID, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("GTK:\n"));
            if (!pFrm->FTInfo.GTK.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("keyId (2): %d\n"), pFrm->FTInfo.GTK.keyId);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("reserved (14): %d\n"), pFrm->FTInfo.GTK.reserved);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->FTInfo.GTK.keyLength, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->FTInfo.GTK.RSC, 8);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("num_key: %d.\n"), pFrm->FTInfo.GTK.num_key);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* ) pFrm->FTInfo.GTK.key, pFrm->FTInfo.GTK.num_key);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("R0KH_ID:\n"));
            if (!pFrm->FTInfo.R0KH_ID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("num_PMK_R0_ID: %d.\n"), pFrm->FTInfo.R0KH_ID.num_PMK_R0_ID);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* ) pFrm->FTInfo.R0KH_ID.PMK_R0_ID, pFrm->FTInfo.R0KH_ID.num_PMK_R0_ID);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("FTTimeoutInterval:\n"));
        if (!pFrm->FTTimeoutInterval.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->FTTimeoutInterval.timeoutType, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->FTTimeoutInterval.timeoutValue, 4);
        }
        for (i = 0; i < pFrm->num_RICDataDesc; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("RICDataDesc[%d]:\n"), i);
            if (!pFrm->RICDataDesc[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("RICData:\n"));
                if (!pFrm->RICDataDesc[i].RICData.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].RICData.Identifier, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].RICData.resourceDescCount, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].RICData.statusCode, 2);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("RICDescriptor:\n"));
                if (!pFrm->RICDataDesc[i].RICDescriptor.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].RICDescriptor.resourceType, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("num_variableData: %d.\n"), pFrm->RICDataDesc[i].RICDescriptor.num_variableData);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* ) pFrm->RICDataDesc[i].RICDescriptor.variableData, pFrm->RICDataDesc[i].RICDescriptor.num_variableData);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("TSPEC:\n"));
                if (!pFrm->RICDataDesc[i].TSPEC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("traffic_type (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.traffic_type);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].TSPEC.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].TSPEC.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("access_policy (2): %d\n"), pFrm->RICDataDesc[i].TSPEC.access_policy);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("psb (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.psb);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("user_priority (3): %d\n"), pFrm->RICDataDesc[i].TSPEC.user_priority);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->RICDataDesc[i].TSPEC.tsinfo_ack_pol);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("schedule (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.schedule);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("unused (7): %d\n"), pFrm->RICDataDesc[i].TSPEC.unused);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("size (15): %d\n"), pFrm->RICDataDesc[i].TSPEC.size);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("fixed (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.fixed);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.max_msdu_size, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.min_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.max_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.inactivity_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.suspension_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.min_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.mean_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.peak_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.burst_size, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.delay_bound, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.min_phy_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.surplus_bw_allowance, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.medium_time, 2);
                }
                for (i = 0; i < pFrm->RICDataDesc[i].num_TCLAS; ++i)
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("TCLAS[%d]:\n"), i);
                    if (!pFrm->RICDataDesc[i].TCLAS[i].present)
                    {
                        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                    }
                    else
                    {
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].user_priority, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].classifier_type, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].classifier_mask, 1);
                        switch (pFrm->RICDataDesc[i].TCLAS[i].classifier_type)
                        {
                            case 0:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.EthParams.source, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.EthParams.dest, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.EthParams.type, 2);
                            break;
                            case 1:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.version, 1);
                                switch (pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.version)
                                {
                                    case 4:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.source, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.dest, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.DSCP, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.proto, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.reserved, 1);
                                    break;
                                    case 6:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.source, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.dest, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.flow_label, 3);
                                    break;
                                }
                            break;
                            case 2:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.Params8021dq.tag_type, 2);
                            break;
                        }
                    }
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("TCLASSPROC:\n"));
                if (!pFrm->RICDataDesc[i].TCLASSPROC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLASSPROC.processing, 1);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("TSDelay:\n"));
                if (!pFrm->RICDataDesc[i].TSDelay.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].TSDelay.delay, 4);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Schedule:\n"));
                if (!pFrm->RICDataDesc[i].Schedule.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].Schedule.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].Schedule.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].Schedule.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("reserved (9): %d\n"), pFrm->RICDataDesc[i].Schedule.reserved);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.service_interval, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.max_service_dur, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.spec_interval, 2);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("WMMTSPEC:\n"));
                if (!pFrm->RICDataDesc[i].WMMTSPEC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.version, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("traffic_type (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.traffic_type);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("access_policy (2): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.access_policy);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("psb (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.psb);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("user_priority (3): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.user_priority);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.tsinfo_ack_pol);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("tsinfo_rsvd (7): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.tsinfo_rsvd);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("burst_size_defn (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.burst_size_defn);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("size (15): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.size);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("fixed (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.fixed);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.max_msdu_size, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.min_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.max_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.inactivity_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.suspension_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.min_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.mean_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.peak_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.burst_size, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.delay_bound, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.min_phy_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.surplus_bw_allowance, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.medium_time, 2);
                }
                for (i = 0; i < pFrm->RICDataDesc[i].num_WMMTCLAS; ++i)
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("WMMTCLAS[%d]:\n"), i);
                    if (!pFrm->RICDataDesc[i].WMMTCLAS[i].present)
                    {
                        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                    }
                    else
                    {
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].version, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].user_priority, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].classifier_type, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].classifier_mask, 1);
                        switch (pFrm->RICDataDesc[i].WMMTCLAS[i].classifier_type)
                        {
                            case 0:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.EthParams.source, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.EthParams.dest, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.EthParams.type, 2);
                            break;
                            case 1:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.version, 1);
                                switch (pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.version)
                                {
                                    case 4:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.source, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.dest, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.DSCP, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.proto, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.reserved, 1);
                                    break;
                                    case 6:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.source, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.dest, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.flow_label, 3);
                                    break;
                                }
                            break;
                            case 2:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.Params8021dq.tag_type, 2);
                            break;
                        }
                    }
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("WMMTCLASPROC:\n"));
                if (!pFrm->RICDataDesc[i].WMMTCLASPROC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLASPROC.version, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLASPROC.processing, 1);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("WMMTSDelay:\n"));
                if (!pFrm->RICDataDesc[i].WMMTSDelay.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSDelay.version, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSDelay.delay, 4);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("WMMSchedule:\n"));
                if (!pFrm->RICDataDesc[i].WMMSchedule.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.version, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), FRFL("reserved (9): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.reserved);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.service_interval, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.max_service_dur, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_AUTHENTICATION), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.spec_interval, 2);
                }
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackAuthentication. */

    static const tFFDefn FFS_Beacon[] = {
        { "TimeStamp", offsetof(tDot11fBeacon, TimeStamp), SigFfTimeStamp , DOT11F_FF_TIMESTAMP_LEN, },
        { "BeaconInterval", offsetof(tDot11fBeacon, BeaconInterval), SigFfBeaconInterval , DOT11F_FF_BEACONINTERVAL_LEN, },
        { "Capabilities", offsetof(tDot11fBeacon, Capabilities), SigFfCapabilities , DOT11F_FF_CAPABILITIES_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_Beacon[] = {
        {offsetof(tDot11fBeacon, SSID), offsetof(tDot11fIESSID, present), 0, "SSID" , 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 1, },
        {offsetof(tDot11fBeacon, SuppRates), offsetof(tDot11fIESuppRates, present), 0, "SuppRates" , 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPRATES, 1, },
        {offsetof(tDot11fBeacon, FHParamSet), offsetof(tDot11fIEFHParamSet, present), 0, "FHParamSet" , 0, 7, 7, SigIeFHParamSet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FHPARAMSET, 0, },
        {offsetof(tDot11fBeacon, DSParams), offsetof(tDot11fIEDSParams, present), 0, "DSParams" , 0, 3, 3, SigIeDSParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_DSPARAMS, 0, },
        {offsetof(tDot11fBeacon, CFParams), offsetof(tDot11fIECFParams, present), 0, "CFParams" , 0, 8, 8, SigIeCFParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_CFPARAMS, 0, },
        {offsetof(tDot11fBeacon, IBSSParams), offsetof(tDot11fIEIBSSParams, present), 0, "IBSSParams" , 0, 4, 4, SigIeIBSSParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_IBSSPARAMS, 0, },
        {offsetof(tDot11fBeacon, TIM), offsetof(tDot11fIETIM, present), 0, "TIM" , 0, 6, 256, SigIeTIM, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TIM, 0, },
        {offsetof(tDot11fBeacon, Country), offsetof(tDot11fIECountry, present), 0, "Country" , 0, 5, 257, SigIeCountry, {0, 0, 0, 0, 0}, 0, DOT11F_EID_COUNTRY, 0, },
        {offsetof(tDot11fBeacon, FHParams), offsetof(tDot11fIEFHParams, present), 0, "FHParams" , 0, 4, 4, SigIeFHParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FHPARAMS, 0, },
        {offsetof(tDot11fBeacon, FHPattTable), offsetof(tDot11fIEFHPattTable, present), 0, "FHPattTable" , 0, 6, 257, SigIeFHPattTable, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FHPATTTABLE, 0, },
        {offsetof(tDot11fBeacon, PowerConstraints), offsetof(tDot11fIEPowerConstraints, present), 0, "PowerConstraints" , 0, 3, 3, SigIePowerConstraints, {0, 0, 0, 0, 0}, 0, DOT11F_EID_POWERCONSTRAINTS, 0, },
        {offsetof(tDot11fBeacon, ChanSwitchAnn), offsetof(tDot11fIEChanSwitchAnn, present), 0, "ChanSwitchAnn" , 0, 5, 5, SigIeChanSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_CHANSWITCHANN, 0, },
        {offsetof(tDot11fBeacon, Quiet), offsetof(tDot11fIEQuiet, present), 0, "Quiet" , 0, 8, 8, SigIeQuiet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QUIET, 0, },
        {offsetof(tDot11fBeacon, TPCReport), offsetof(tDot11fIETPCReport, present), 0, "TPCReport" , 0, 4, 4, SigIeTPCReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TPCREPORT, 0, },
        {offsetof(tDot11fBeacon, ERPInfo), offsetof(tDot11fIEERPInfo, present), 0, "ERPInfo" , 0, 3, 3, SigIeERPInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_ERPINFO, 0, },
        {offsetof(tDot11fBeacon, ExtSuppRates), offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates" , 0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTSUPPRATES, 0, },
        {offsetof(tDot11fBeacon, RSN), offsetof(tDot11fIERSN, present), 0, "RSN" , 0, 8, 112, SigIeRSN, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSN, 0, },
        {offsetof(tDot11fBeacon, QBSSLoad), offsetof(tDot11fIEQBSSLoad, present), 0, "QBSSLoad" , 0, 7, 7, SigIeQBSSLoad, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QBSSLOAD, 0, },
        {offsetof(tDot11fBeacon, EDCAParamSet), offsetof(tDot11fIEEDCAParamSet, present), 0, "EDCAParamSet" , 0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EDCAPARAMSET, 0, },
        {offsetof(tDot11fBeacon, QOSCapsAp), offsetof(tDot11fIEQOSCapsAp, present), 0, "QOSCapsAp" , 0, 3, 3, SigIeQOSCapsAp, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QOSCAPSAP, 0, },
        {offsetof(tDot11fBeacon, APChannelReport), offsetof(tDot11fIEAPChannelReport, present), 0, "APChannelReport" , 0, 3, 53, SigIeAPChannelReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_APCHANNELREPORT, 0, },
        {offsetof(tDot11fBeacon, RRMEnabledCap), offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap" , 0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RRMENABLEDCAP, 0, },
        {offsetof(tDot11fBeacon, MobilityDomain), offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain" , 0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MOBILITYDOMAIN, 0, },
        {offsetof(tDot11fBeacon, WPA), offsetof(tDot11fIEWPA, present), 0, "WPA" , 0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPA, 0, },
        {offsetof(tDot11fBeacon, HTCaps), offsetof(tDot11fIEHTCaps, present), 0, "HTCaps" , 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTCAPS, 0, },
        {offsetof(tDot11fBeacon, HTInfo), offsetof(tDot11fIEHTInfo, present), 0, "HTInfo" , 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTINFO, 0, },
        {offsetof(tDot11fBeacon, ExtChanSwitchAnn), offsetof(tDot11fIEExtChanSwitchAnn, present), 0, "ExtChanSwitchAnn" , 0, 3, 3, SigIeExtChanSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTCHANSWITCHANN, 0, },
        {offsetof(tDot11fBeacon, WMMInfoAp), offsetof(tDot11fIEWMMInfoAp, present), 0, "WMMInfoAp" , 0, 9, 9, SigIeWMMInfoAp, {0, 80, 242, 2, 0}, 5, DOT11F_EID_WMMINFOAP, 0, },
        {offsetof(tDot11fBeacon, WMMParams), offsetof(tDot11fIEWMMParams, present), 0, "WMMParams" , 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1}, 5, DOT11F_EID_WMMPARAMS, 0, },
        {offsetof(tDot11fBeacon, WMMCaps), offsetof(tDot11fIEWMMCaps, present), 0, "WMMCaps" , 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5}, 5, DOT11F_EID_WMMCAPS, 0, },
        {offsetof(tDot11fBeacon, WAPI), offsetof(tDot11fIEWAPI, present), 0, "WAPI" , 0, 14, 112, SigIeWAPI, {0, 0, 0, 0, 0}, 0, DOT11F_EID_WAPI, 0, },
        {offsetof(tDot11fBeacon, CCXRadMgmtCap), offsetof(tDot11fIECCXRadMgmtCap, present), 0, "CCXRadMgmtCap" , 0, 8, 8, SigIeCCXRadMgmtCap, {0, 64, 150, 1, 0}, 4, DOT11F_EID_CCXRADMGMTCAP, 0, },
        {offsetof(tDot11fBeacon, CCXTrafStrmMet), offsetof(tDot11fIECCXTrafStrmMet, present), 0, "CCXTrafStrmMet" , 0, 10, 10, SigIeCCXTrafStrmMet, {0, 64, 150, 7, 0}, 4, DOT11F_EID_CCXTRAFSTRMMET, 0, },
        {offsetof(tDot11fBeacon, CCXTxmitPower), offsetof(tDot11fIECCXTxmitPower, present), 0, "CCXTxmitPower" , 0, 8, 8, SigIeCCXTxmitPower, {0, 64, 150, 0, 0}, 4, DOT11F_EID_CCXTXMITPOWER, 0, },
        {offsetof(tDot11fBeacon, Airgo), offsetof(tDot11fIEAirgo, present), 0, "Airgo" , 0, 5, 232, SigIeAirgo, {0, 10, 245, 0, 0}, 3, DOT11F_EID_AIRGO, 0, },
        {offsetof(tDot11fBeacon, WscBeacon), offsetof(tDot11fIEWscBeacon, present), 0, "WscBeacon" , 0, 6, 84, SigIeWscBeacon, {0, 80, 242, 4, 0}, 4, DOT11F_EID_WSCBEACON, 0, },
        {offsetof(tDot11fBeacon, P2PBeacon), offsetof(tDot11fIEP2PBeacon, present), 0, "P2PBeacon" , 0, 6, 61, SigIeP2PBeacon, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PBEACON, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackBeacon(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fBeacon *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_Beacon, IES_Beacon, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Unpacked the Beacon:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("TimeStamp:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->TimeStamp.timestamp, 8);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("BeaconInterval:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->BeaconInterval.interval, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Capabilities:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("ess (1): %d\n"), pFrm->Capabilities.ess);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("ibss (1): %d\n"), pFrm->Capabilities.ibss);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("cfPollable (1): %d\n"), pFrm->Capabilities.cfPollable);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("cfPollReq (1): %d\n"), pFrm->Capabilities.cfPollReq);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("privacy (1): %d\n"), pFrm->Capabilities.privacy);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("shortPreamble (1): %d\n"), pFrm->Capabilities.shortPreamble);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("pbcc (1): %d\n"), pFrm->Capabilities.pbcc);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("channelAgility (1): %d\n"), pFrm->Capabilities.channelAgility);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("spectrumMgt (1): %d\n"), pFrm->Capabilities.spectrumMgt);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("qos (1): %d\n"), pFrm->Capabilities.qos);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("shortSlotTime (1): %d\n"), pFrm->Capabilities.shortSlotTime);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("apsd (1): %d\n"), pFrm->Capabilities.apsd);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("rrm (1): %d\n"), pFrm->Capabilities.rrm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("dsssOfdm (1): %d\n"), pFrm->Capabilities.dsssOfdm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("delayedBA (1): %d\n"), pFrm->Capabilities.delayedBA);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("immediateBA (1): %d\n"), pFrm->Capabilities.immediateBA);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("SSID:\n"));
        if (!pFrm->SSID.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_ssid: %d.\n"), pFrm->SSID.num_ssid);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->SSID.ssid, pFrm->SSID.num_ssid);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("SuppRates:\n"));
        if (!pFrm->SuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_rates: %d.\n"), pFrm->SuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->SuppRates.rates, pFrm->SuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("FHParamSet:\n"));
        if (!pFrm->FHParamSet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->FHParamSet.dwell_time, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->FHParamSet.hop_set, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->FHParamSet.hop_pattern, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->FHParamSet.hop_index, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("DSParams:\n"));
        if (!pFrm->DSParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->DSParams.curr_channel, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("CFParams:\n"));
        if (!pFrm->CFParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->CFParams.cfp_count, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->CFParams.cfp_period, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->CFParams.cfp_maxduration, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->CFParams.cfp_durremaining, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("IBSSParams:\n"));
        if (!pFrm->IBSSParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->IBSSParams.atim, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("TIM:\n"));
        if (!pFrm->TIM.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->TIM.dtim_count, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->TIM.dtim_period, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->TIM.bmpctl, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_vbmp: %d.\n"), pFrm->TIM.num_vbmp);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->TIM.vbmp, pFrm->TIM.num_vbmp);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Country:\n"));
        if (!pFrm->Country.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Country.country, 3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_triplets: %d.\n"), pFrm->Country.num_triplets);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->Country.triplets, 3 * pFrm->Country.num_triplets);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("FHParams:\n"));
        if (!pFrm->FHParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->FHParams.radix, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->FHParams.nchannels, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("FHPattTable:\n"));
        if (!pFrm->FHPattTable.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->FHPattTable.flag, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->FHPattTable.nsets, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->FHPattTable.modulus, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->FHPattTable.offset, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_randtable: %d.\n"), pFrm->FHPattTable.num_randtable);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->FHPattTable.randtable, pFrm->FHPattTable.num_randtable);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("PowerConstraints:\n"));
        if (!pFrm->PowerConstraints.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->PowerConstraints.localPowerConstraints, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("ChanSwitchAnn:\n"));
        if (!pFrm->ChanSwitchAnn.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->ChanSwitchAnn.switchMode, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->ChanSwitchAnn.newChannel, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->ChanSwitchAnn.switchCount, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Quiet:\n"));
        if (!pFrm->Quiet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Quiet.count, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Quiet.period, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Quiet.duration, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Quiet.offset, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("TPCReport:\n"));
        if (!pFrm->TPCReport.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->TPCReport.tx_power, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->TPCReport.link_margin, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("ERPInfo:\n"));
        if (!pFrm->ERPInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("non_erp_present (1): %d\n"), pFrm->ERPInfo.non_erp_present);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("use_prot (1): %d\n"), pFrm->ERPInfo.use_prot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("barker_preamble (1): %d\n"), pFrm->ERPInfo.barker_preamble);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused (5): %d\n"), pFrm->ERPInfo.unused);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("ExtSuppRates:\n"));
        if (!pFrm->ExtSuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_rates: %d.\n"), pFrm->ExtSuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->ExtSuppRates.rates, pFrm->ExtSuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("RSN:\n"));
        if (!pFrm->RSN.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->RSN.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->RSN.gp_cipher_suite, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->RSN.pwise_cipher_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->RSN.pwise_cipher_suites, 4 * pFrm->RSN.pwise_cipher_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->RSN.akm_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->RSN.akm_suites, 4 * pFrm->RSN.akm_suite_count);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("preauth (1): %d\n"), pFrm->RSN.preauth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("no_pwise (1): %d\n"), pFrm->RSN.no_pwise);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("PTKSA_replay_counter (2): %d\n"), pFrm->RSN.PTKSA_replay_counter);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("GTKSA_replay_counter (2): %d\n"), pFrm->RSN.GTKSA_replay_counter);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved (10): %d\n"), pFrm->RSN.reserved);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->RSN.pmkid_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->RSN.pmkid, 16 * pFrm->RSN.pmkid_count);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("QBSSLoad:\n"));
        if (!pFrm->QBSSLoad.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->QBSSLoad.stacount, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->QBSSLoad.chautil, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->QBSSLoad.avail, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("EDCAParamSet:\n"));
        if (!pFrm->EDCAParamSet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->EDCAParamSet.qos, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->EDCAParamSet.reserved, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_aifsn (4): %d\n"), pFrm->EDCAParamSet.acbe_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_acm (1): %d\n"), pFrm->EDCAParamSet.acbe_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_aci (2): %d\n"), pFrm->EDCAParamSet.acbe_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused1 (1): %d\n"), pFrm->EDCAParamSet.unused1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_acwmin (4): %d\n"), pFrm->EDCAParamSet.acbe_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_acwmax (4): %d\n"), pFrm->EDCAParamSet.acbe_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->EDCAParamSet.acbe_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_aifsn (4): %d\n"), pFrm->EDCAParamSet.acbk_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_acm (1): %d\n"), pFrm->EDCAParamSet.acbk_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_aci (2): %d\n"), pFrm->EDCAParamSet.acbk_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused2 (1): %d\n"), pFrm->EDCAParamSet.unused2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_acwmin (4): %d\n"), pFrm->EDCAParamSet.acbk_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_acwmax (4): %d\n"), pFrm->EDCAParamSet.acbk_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->EDCAParamSet.acbk_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_aifsn (4): %d\n"), pFrm->EDCAParamSet.acvi_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_acm (1): %d\n"), pFrm->EDCAParamSet.acvi_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_aci (2): %d\n"), pFrm->EDCAParamSet.acvi_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused3 (1): %d\n"), pFrm->EDCAParamSet.unused3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_acwmin (4): %d\n"), pFrm->EDCAParamSet.acvi_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_acwmax (4): %d\n"), pFrm->EDCAParamSet.acvi_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->EDCAParamSet.acvi_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_aifsn (4): %d\n"), pFrm->EDCAParamSet.acvo_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_acm (1): %d\n"), pFrm->EDCAParamSet.acvo_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_aci (2): %d\n"), pFrm->EDCAParamSet.acvo_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused4 (1): %d\n"), pFrm->EDCAParamSet.unused4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_acwmin (4): %d\n"), pFrm->EDCAParamSet.acvo_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_acwmax (4): %d\n"), pFrm->EDCAParamSet.acvo_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->EDCAParamSet.acvo_txoplimit, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("QOSCapsAp:\n"));
        if (!pFrm->QOSCapsAp.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved (1): %d\n"), pFrm->QOSCapsAp.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("txopreq (1): %d\n"), pFrm->QOSCapsAp.txopreq);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("qreq (1): %d\n"), pFrm->QOSCapsAp.qreq);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("qack (1): %d\n"), pFrm->QOSCapsAp.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("count (4): %d\n"), pFrm->QOSCapsAp.count);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("APChannelReport:\n"));
        if (!pFrm->APChannelReport.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->APChannelReport.regulatoryClass, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_channelList: %d.\n"), pFrm->APChannelReport.num_channelList);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->APChannelReport.channelList, pFrm->APChannelReport.num_channelList);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("RRMEnabledCap:\n"));
        if (!pFrm->RRMEnabledCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("LinkMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LinkMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("NeighborRpt (1): %d\n"), pFrm->RRMEnabledCap.NeighborRpt);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("parallel (1): %d\n"), pFrm->RRMEnabledCap.parallel);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("repeated (1): %d\n"), pFrm->RRMEnabledCap.repeated);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("BeaconPassive (1): %d\n"), pFrm->RRMEnabledCap.BeaconPassive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("BeaconActive (1): %d\n"), pFrm->RRMEnabledCap.BeaconActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("BeaconTable (1): %d\n"), pFrm->RRMEnabledCap.BeaconTable);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("BeaconRepCond (1): %d\n"), pFrm->RRMEnabledCap.BeaconRepCond);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("FrameMeasurement (1): %d\n"), pFrm->RRMEnabledCap.FrameMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("ChannelLoad (1): %d\n"), pFrm->RRMEnabledCap.ChannelLoad);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("NoiseHistogram (1): %d\n"), pFrm->RRMEnabledCap.NoiseHistogram);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("statistics (1): %d\n"), pFrm->RRMEnabledCap.statistics);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("LCIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LCIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("LCIAzimuth (1): %d\n"), pFrm->RRMEnabledCap.LCIAzimuth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("TCMCapability (1): %d\n"), pFrm->RRMEnabledCap.TCMCapability);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("triggeredTCM (1): %d\n"), pFrm->RRMEnabledCap.triggeredTCM);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("APChanReport (1): %d\n"), pFrm->RRMEnabledCap.APChanReport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("RRMMIBEnabled (1): %d\n"), pFrm->RRMEnabledCap.RRMMIBEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("operatingChanMax (3): %d\n"), pFrm->RRMEnabledCap.operatingChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("nonOperatinChanMax (3): %d\n"), pFrm->RRMEnabledCap.nonOperatinChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("MeasurementPilot (3): %d\n"), pFrm->RRMEnabledCap.MeasurementPilot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("MeasurementPilotEnabled (1): %d\n"), pFrm->RRMEnabledCap.MeasurementPilotEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("NeighborTSFOffset (1): %d\n"), pFrm->RRMEnabledCap.NeighborTSFOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("RCPIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RCPIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("RSNIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RSNIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("BssAvgAccessDelay (1): %d\n"), pFrm->RRMEnabledCap.BssAvgAccessDelay);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("BSSAvailAdmission (1): %d\n"), pFrm->RRMEnabledCap.BSSAvailAdmission);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("AntennaInformation (1): %d\n"), pFrm->RRMEnabledCap.AntennaInformation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved (6): %d\n"), pFrm->RRMEnabledCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("MobilityDomain:\n"));
        if (!pFrm->MobilityDomain.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->MobilityDomain.MDID, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("overDSCap (1): %d\n"), pFrm->MobilityDomain.overDSCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("resourceReqCap (1): %d\n"), pFrm->MobilityDomain.resourceReqCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved (6): %d\n"), pFrm->MobilityDomain.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("WPA:\n"));
        if (!pFrm->WPA.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WPA.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WPA.multicast_cipher, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WPA.unicast_cipher_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->WPA.unicast_ciphers, 4 * pFrm->WPA.unicast_cipher_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WPA.auth_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->WPA.auth_suites, 4 * pFrm->WPA.auth_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WPA.caps, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("HTCaps:\n"));
        if (!pFrm->HTCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("advCodingCap (1): %d\n"), pFrm->HTCaps.advCodingCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("supportedChannelWidthSet (1): %d\n"), pFrm->HTCaps.supportedChannelWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("mimoPowerSave (2): %d\n"), pFrm->HTCaps.mimoPowerSave);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("greenField (1): %d\n"), pFrm->HTCaps.greenField);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("shortGI20MHz (1): %d\n"), pFrm->HTCaps.shortGI20MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("shortGI40MHz (1): %d\n"), pFrm->HTCaps.shortGI40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("txSTBC (1): %d\n"), pFrm->HTCaps.txSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("rxSTBC (2): %d\n"), pFrm->HTCaps.rxSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("delayedBA (1): %d\n"), pFrm->HTCaps.delayedBA);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("maximalAMSDUsize (1): %d\n"), pFrm->HTCaps.maximalAMSDUsize);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("dsssCckMode40MHz (1): %d\n"), pFrm->HTCaps.dsssCckMode40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("psmp (1): %d\n"), pFrm->HTCaps.psmp);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("stbcControlFrame (1): %d\n"), pFrm->HTCaps.stbcControlFrame);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("lsigTXOPProtection (1): %d\n"), pFrm->HTCaps.lsigTXOPProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("maxRxAMPDUFactor (2): %d\n"), pFrm->HTCaps.maxRxAMPDUFactor);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("mpduDensity (3): %d\n"), pFrm->HTCaps.mpduDensity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved1 (3): %d\n"), pFrm->HTCaps.reserved1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->HTCaps.supportedMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("pco (1): %d\n"), pFrm->HTCaps.pco);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("transitionTime (2): %d\n"), pFrm->HTCaps.transitionTime);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved2 (5): %d\n"), pFrm->HTCaps.reserved2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("mcsFeedback (2): %d\n"), pFrm->HTCaps.mcsFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved3 (6): %d\n"), pFrm->HTCaps.reserved3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("txBF (1): %d\n"), pFrm->HTCaps.txBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("rxStaggeredSounding (1): %d\n"), pFrm->HTCaps.rxStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("txStaggeredSounding (1): %d\n"), pFrm->HTCaps.txStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("rxZLF (1): %d\n"), pFrm->HTCaps.rxZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("txZLF (1): %d\n"), pFrm->HTCaps.txZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("implicitTxBF (1): %d\n"), pFrm->HTCaps.implicitTxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("calibration (2): %d\n"), pFrm->HTCaps.calibration);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("explicitCSITxBF (1): %d\n"), pFrm->HTCaps.explicitCSITxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("explicitUncompressedSteeringMatrix (1): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrix);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("explicitBFCSIFeedback (3): %d\n"), pFrm->HTCaps.explicitBFCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("explicitUncompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("explicitCompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitCompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("csiNumBFAntennae (2): %d\n"), pFrm->HTCaps.csiNumBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("uncompressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.uncompressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("compressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.compressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved4 (7): %d\n"), pFrm->HTCaps.reserved4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("antennaSelection (1): %d\n"), pFrm->HTCaps.antennaSelection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("explicitCSIFeedbackTx (1): %d\n"), pFrm->HTCaps.explicitCSIFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("antennaIndicesFeedbackTx (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("explicitCSIFeedback (1): %d\n"), pFrm->HTCaps.explicitCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("antennaIndicesFeedback (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("rxAS (1): %d\n"), pFrm->HTCaps.rxAS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("txSoundingPPDUs (1): %d\n"), pFrm->HTCaps.txSoundingPPDUs);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved5 (1): %d\n"), pFrm->HTCaps.reserved5);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_rsvd: %d.\n"), pFrm->HTCaps.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->HTCaps.rsvd, pFrm->HTCaps.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("HTInfo:\n"));
        if (!pFrm->HTInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->HTInfo.primaryChannel, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("secondaryChannelOffset (2): %d\n"), pFrm->HTInfo.secondaryChannelOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("recommendedTxWidthSet (1): %d\n"), pFrm->HTInfo.recommendedTxWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("rifsMode (1): %d\n"), pFrm->HTInfo.rifsMode);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("controlledAccessOnly (1): %d\n"), pFrm->HTInfo.controlledAccessOnly);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("serviceIntervalGranularity (3): %d\n"), pFrm->HTInfo.serviceIntervalGranularity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("opMode (2): %d\n"), pFrm->HTInfo.opMode);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("nonGFDevicesPresent (1): %d\n"), pFrm->HTInfo.nonGFDevicesPresent);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("transmitBurstLimit (1): %d\n"), pFrm->HTInfo.transmitBurstLimit);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("obssNonHTStaPresent (1): %d\n"), pFrm->HTInfo.obssNonHTStaPresent);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved (11): %d\n"), pFrm->HTInfo.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("basicSTBCMCS (7): %d\n"), pFrm->HTInfo.basicSTBCMCS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("dualCTSProtection (1): %d\n"), pFrm->HTInfo.dualCTSProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("secondaryBeacon (1): %d\n"), pFrm->HTInfo.secondaryBeacon);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("lsigTXOPProtectionFullSupport (1): %d\n"), pFrm->HTInfo.lsigTXOPProtectionFullSupport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("pcoActive (1): %d\n"), pFrm->HTInfo.pcoActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("pcoPhase (1): %d\n"), pFrm->HTInfo.pcoPhase);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved2 (4): %d\n"), pFrm->HTInfo.reserved2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->HTInfo.basicMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_rsvd: %d.\n"), pFrm->HTInfo.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->HTInfo.rsvd, pFrm->HTInfo.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("ExtChanSwitchAnn:\n"));
        if (!pFrm->ExtChanSwitchAnn.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->ExtChanSwitchAnn.secondaryChannelOffset, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("WMMInfoAp:\n"));
        if (!pFrm->WMMInfoAp.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WMMInfoAp.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("param_set_count (4): %d\n"), pFrm->WMMInfoAp.param_set_count);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved (3): %d\n"), pFrm->WMMInfoAp.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("uapsd (1): %d\n"), pFrm->WMMInfoAp.uapsd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("WMMParams:\n"));
        if (!pFrm->WMMParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WMMParams.version, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WMMParams.qosInfo, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WMMParams.reserved2, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_aifsn (4): %d\n"), pFrm->WMMParams.acbe_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_acm (1): %d\n"), pFrm->WMMParams.acbe_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_aci (2): %d\n"), pFrm->WMMParams.acbe_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused1 (1): %d\n"), pFrm->WMMParams.unused1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_acwmin (4): %d\n"), pFrm->WMMParams.acbe_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_acwmax (4): %d\n"), pFrm->WMMParams.acbe_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WMMParams.acbe_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_aifsn (4): %d\n"), pFrm->WMMParams.acbk_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_acm (1): %d\n"), pFrm->WMMParams.acbk_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_aci (2): %d\n"), pFrm->WMMParams.acbk_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused2 (1): %d\n"), pFrm->WMMParams.unused2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_acwmin (4): %d\n"), pFrm->WMMParams.acbk_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_acwmax (4): %d\n"), pFrm->WMMParams.acbk_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WMMParams.acbk_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_aifsn (4): %d\n"), pFrm->WMMParams.acvi_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_acm (1): %d\n"), pFrm->WMMParams.acvi_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_aci (2): %d\n"), pFrm->WMMParams.acvi_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused3 (1): %d\n"), pFrm->WMMParams.unused3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_acwmin (4): %d\n"), pFrm->WMMParams.acvi_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_acwmax (4): %d\n"), pFrm->WMMParams.acvi_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WMMParams.acvi_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_aifsn (4): %d\n"), pFrm->WMMParams.acvo_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_acm (1): %d\n"), pFrm->WMMParams.acvo_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_aci (2): %d\n"), pFrm->WMMParams.acvo_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused4 (1): %d\n"), pFrm->WMMParams.unused4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_acwmin (4): %d\n"), pFrm->WMMParams.acvo_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_acwmax (4): %d\n"), pFrm->WMMParams.acvo_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WMMParams.acvo_txoplimit, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("WMMCaps:\n"));
        if (!pFrm->WMMCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WMMCaps.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved (4): %d\n"), pFrm->WMMCaps.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("qack (1): %d\n"), pFrm->WMMCaps.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("queue_request (1): %d\n"), pFrm->WMMCaps.queue_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("txop_request (1): %d\n"), pFrm->WMMCaps.txop_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("more_ack (1): %d\n"), pFrm->WMMCaps.more_ack);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("WAPI:\n"));
        if (!pFrm->WAPI.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WAPI.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WAPI.akm_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->WAPI.akm_suites, 4 * pFrm->WAPI.akm_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WAPI.unicast_cipher_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->WAPI.unicast_cipher_suites, 4 * pFrm->WAPI.unicast_cipher_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WAPI.multicast_cipher_suite, 4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("preauth (1): %d\n"), pFrm->WAPI.preauth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved (15): %d\n"), pFrm->WAPI.reserved);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WAPI.bkid_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->WAPI.bkid, 16 * pFrm->WAPI.bkid_count);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("CCXRadMgmtCap:\n"));
        if (!pFrm->CCXRadMgmtCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->CCXRadMgmtCap.mgmt_state, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("mbssid_mask (3): %d\n"), pFrm->CCXRadMgmtCap.mbssid_mask);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("reserved (5): %d\n"), pFrm->CCXRadMgmtCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("CCXTrafStrmMet:\n"));
        if (!pFrm->CCXTrafStrmMet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->CCXTrafStrmMet.tsid, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->CCXTrafStrmMet.state, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->CCXTrafStrmMet.msmt_interval, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("CCXTxmitPower:\n"));
        if (!pFrm->CCXTxmitPower.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->CCXTxmitPower.power_limit, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->CCXTxmitPower.reserved, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Airgo:\n"));
        if (!pFrm->Airgo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("PropSuppRates:\n"));
            if (!pFrm->Airgo.PropSuppRates.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_rates: %d.\n"), pFrm->Airgo.PropSuppRates.num_rates);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->Airgo.PropSuppRates.rates, pFrm->Airgo.PropSuppRates.num_rates);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("APName:\n"));
            if (!pFrm->Airgo.APName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_name: %d.\n"), pFrm->Airgo.APName.num_name);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->Airgo.APName.name, pFrm->Airgo.APName.num_name);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("HCF:\n"));
            if (!pFrm->Airgo.HCF.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.HCF.enabled, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("WDS:\n"));
            if (!pFrm->Airgo.WDS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_wdsData: %d.\n"), pFrm->Airgo.WDS.num_wdsData);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->Airgo.WDS.wdsData, pFrm->Airgo.WDS.num_wdsData);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("BPIndicator:\n"));
            if (!pFrm->Airgo.BPIndicator.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.BPIndicator.indicator, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.BPIndicator.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("LoadInfo:\n"));
            if (!pFrm->Airgo.LoadInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.LoadInfo.num_stas, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.LoadInfo.channel_util, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("LoadBalance:\n"));
            if (!pFrm->Airgo.LoadBalance.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.LoadBalance.bssid, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.LoadBalance.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("PropAssocType:\n"));
            if (!pFrm->Airgo.PropAssocType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropAssocType.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("LLAttr:\n"));
            if (!pFrm->Airgo.LLAttr.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.LLAttr.defer_threshold, 4);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("PropCapability:\n"));
            if (!pFrm->Airgo.PropCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropCapability.capability, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Version:\n"));
            if (!pFrm->Airgo.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.Version.chip_rev, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.Version.card_type, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_build_version: %d.\n"), pFrm->Airgo.Version.num_build_version);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->Airgo.Version.build_version, pFrm->Airgo.Version.num_build_version);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("PropEDCAParams:\n"));
            if (!pFrm->Airgo.PropEDCAParams.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.qos, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.reserved, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused1 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbe_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbe_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused2 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acbk_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbk_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused3 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvi_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvi_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("unused4 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused4);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("acvo_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvo_txoplimit, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Titan:\n"));
            if (!pFrm->Airgo.Titan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.Titan.concat_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.Titan.compression_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.Titan.cb_state, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.Titan.rev_fcs_state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("PropChannSwitchAnn:\n"));
            if (!pFrm->Airgo.PropChannSwitchAnn.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.mode, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.primary_channel, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.sub_band, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.channel_switch_count, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("PropQuietBSS:\n"));
            if (!pFrm->Airgo.PropQuietBSS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_count, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_period, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_duration, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_offset, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("TriggerStaBgScan:\n"));
            if (!pFrm->Airgo.TriggerStaBgScan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.TriggerStaBgScan.enable, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Taurus:\n"));
            if (!pFrm->Airgo.Taurus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.Taurus.baTIDBitmap, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->Airgo.Taurus.baPolicy, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("baBufferSize (12): %d\n"), pFrm->Airgo.Taurus.baBufferSize);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("rsvd (4): %d\n"), pFrm->Airgo.Taurus.rsvd);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("WscBeacon:\n"));
        if (!pFrm->WscBeacon.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Version:\n"));
            if (!pFrm->WscBeacon.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("minor (4): %d\n"), pFrm->WscBeacon.Version.minor);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("major (4): %d\n"), pFrm->WscBeacon.Version.major);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("WPSState:\n"));
            if (!pFrm->WscBeacon.WPSState.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WscBeacon.WPSState.state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("APSetupLocked:\n"));
            if (!pFrm->WscBeacon.APSetupLocked.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WscBeacon.APSetupLocked.fLocked, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("SelectedRegistrar:\n"));
            if (!pFrm->WscBeacon.SelectedRegistrar.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WscBeacon.SelectedRegistrar.selected, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("DevicePasswordID:\n"));
            if (!pFrm->WscBeacon.DevicePasswordID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WscBeacon.DevicePasswordID.id, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("SelectedRegistrarConfigMethods:\n"));
            if (!pFrm->WscBeacon.SelectedRegistrarConfigMethods.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WscBeacon.SelectedRegistrarConfigMethods.methods, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("UUID_E:\n"));
            if (!pFrm->WscBeacon.UUID_E.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WscBeacon.UUID_E.uuid, 16);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("RFBands:\n"));
            if (!pFrm->WscBeacon.RFBands.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WscBeacon.RFBands.bands, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("VendorExtension:\n"));
            if (!pFrm->WscBeacon.VendorExtension.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WscBeacon.VendorExtension.vendorId, 3);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Version2:\n"));
                if (!pFrm->WscBeacon.VendorExtension.Version2.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("minor (4): %d\n"), pFrm->WscBeacon.VendorExtension.Version2.minor);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("major (4): %d\n"), pFrm->WscBeacon.VendorExtension.Version2.major);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("AuthorizedMACs:\n"));
                if (!pFrm->WscBeacon.VendorExtension.AuthorizedMACs.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WscBeacon.VendorExtension.AuthorizedMACs.mac, 6);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("RequestToEnroll:\n"));
                if (!pFrm->WscBeacon.VendorExtension.RequestToEnroll.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->WscBeacon.VendorExtension.RequestToEnroll.req, 1);
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("P2PBeacon:\n"));
        if (!pFrm->P2PBeacon.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("P2PCapability:\n"));
            if (!pFrm->P2PBeacon.P2PCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->P2PBeacon.P2PCapability.deviceCapability, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->P2PBeacon.P2PCapability.groupCapability, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("P2PDeviceId:\n"));
            if (!pFrm->P2PBeacon.P2PDeviceId.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->P2PBeacon.P2PDeviceId.P2PDeviceAddress, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("NoticeOfAbsence:\n"));
            if (!pFrm->P2PBeacon.NoticeOfAbsence.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->P2PBeacon.NoticeOfAbsence.index, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* )&pFrm->P2PBeacon.NoticeOfAbsence.CTSWindowOppPS, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), FRFL("num_NoADesc: %d.\n"), pFrm->P2PBeacon.NoticeOfAbsence.num_NoADesc);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON), ( tANI_U8* ) pFrm->P2PBeacon.NoticeOfAbsence.NoADesc, pFrm->P2PBeacon.NoticeOfAbsence.num_NoADesc);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackBeacon. */

    static const tFFDefn FFS_Beacon1[] = {
        { "TimeStamp", offsetof(tDot11fBeacon1, TimeStamp), SigFfTimeStamp , DOT11F_FF_TIMESTAMP_LEN, },
        { "BeaconInterval", offsetof(tDot11fBeacon1, BeaconInterval), SigFfBeaconInterval , DOT11F_FF_BEACONINTERVAL_LEN, },
        { "Capabilities", offsetof(tDot11fBeacon1, Capabilities), SigFfCapabilities , DOT11F_FF_CAPABILITIES_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_Beacon1[] = {
        {offsetof(tDot11fBeacon1, SSID), offsetof(tDot11fIESSID, present), 0, "SSID" , 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 1, },
        {offsetof(tDot11fBeacon1, SuppRates), offsetof(tDot11fIESuppRates, present), 0, "SuppRates" , 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPRATES, 1, },
        {offsetof(tDot11fBeacon1, DSParams), offsetof(tDot11fIEDSParams, present), 0, "DSParams" , 0, 3, 3, SigIeDSParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_DSPARAMS, 0, },
        {offsetof(tDot11fBeacon1, IBSSParams), offsetof(tDot11fIEIBSSParams, present), 0, "IBSSParams" , 0, 4, 4, SigIeIBSSParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_IBSSPARAMS, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackBeacon1(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fBeacon1 *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_Beacon1, IES_Beacon1, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("Unpacked the Beacon1:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("TimeStamp:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), ( tANI_U8* )&pFrm->TimeStamp.timestamp, 8);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("BeaconInterval:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), ( tANI_U8* )&pFrm->BeaconInterval.interval, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("Capabilities:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("ess (1): %d\n"), pFrm->Capabilities.ess);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("ibss (1): %d\n"), pFrm->Capabilities.ibss);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("cfPollable (1): %d\n"), pFrm->Capabilities.cfPollable);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("cfPollReq (1): %d\n"), pFrm->Capabilities.cfPollReq);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("privacy (1): %d\n"), pFrm->Capabilities.privacy);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("shortPreamble (1): %d\n"), pFrm->Capabilities.shortPreamble);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("pbcc (1): %d\n"), pFrm->Capabilities.pbcc);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("channelAgility (1): %d\n"), pFrm->Capabilities.channelAgility);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("spectrumMgt (1): %d\n"), pFrm->Capabilities.spectrumMgt);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("qos (1): %d\n"), pFrm->Capabilities.qos);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("shortSlotTime (1): %d\n"), pFrm->Capabilities.shortSlotTime);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("apsd (1): %d\n"), pFrm->Capabilities.apsd);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("rrm (1): %d\n"), pFrm->Capabilities.rrm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("dsssOfdm (1): %d\n"), pFrm->Capabilities.dsssOfdm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("delayedBA (1): %d\n"), pFrm->Capabilities.delayedBA);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("immediateBA (1): %d\n"), pFrm->Capabilities.immediateBA);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("SSID:\n"));
        if (!pFrm->SSID.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("num_ssid: %d.\n"), pFrm->SSID.num_ssid);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), ( tANI_U8* ) pFrm->SSID.ssid, pFrm->SSID.num_ssid);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("SuppRates:\n"));
        if (!pFrm->SuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("num_rates: %d.\n"), pFrm->SuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), ( tANI_U8* ) pFrm->SuppRates.rates, pFrm->SuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("DSParams:\n"));
        if (!pFrm->DSParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), ( tANI_U8* )&pFrm->DSParams.curr_channel, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("IBSSParams:\n"));
        if (!pFrm->IBSSParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON1), ( tANI_U8* )&pFrm->IBSSParams.atim, 2);
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackBeacon1. */

    static const tFFDefn FFS_Beacon2[] = {
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_Beacon2[] = {
        {offsetof(tDot11fBeacon2, Country), offsetof(tDot11fIECountry, present), 0, "Country" , 0, 5, 257, SigIeCountry, {0, 0, 0, 0, 0}, 0, DOT11F_EID_COUNTRY, 0, },
        {offsetof(tDot11fBeacon2, PowerConstraints), offsetof(tDot11fIEPowerConstraints, present), 0, "PowerConstraints" , 0, 3, 3, SigIePowerConstraints, {0, 0, 0, 0, 0}, 0, DOT11F_EID_POWERCONSTRAINTS, 0, },
        {offsetof(tDot11fBeacon2, ChanSwitchAnn), offsetof(tDot11fIEChanSwitchAnn, present), 0, "ChanSwitchAnn" , 0, 5, 5, SigIeChanSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_CHANSWITCHANN, 0, },
        {offsetof(tDot11fBeacon2, Quiet), offsetof(tDot11fIEQuiet, present), 0, "Quiet" , 0, 8, 8, SigIeQuiet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QUIET, 0, },
        {offsetof(tDot11fBeacon2, TPCReport), offsetof(tDot11fIETPCReport, present), 0, "TPCReport" , 0, 4, 4, SigIeTPCReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TPCREPORT, 0, },
        {offsetof(tDot11fBeacon2, ERPInfo), offsetof(tDot11fIEERPInfo, present), 0, "ERPInfo" , 0, 3, 3, SigIeERPInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_ERPINFO, 0, },
        {offsetof(tDot11fBeacon2, ExtSuppRates), offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates" , 0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTSUPPRATES, 0, },
        {offsetof(tDot11fBeacon2, RSN), offsetof(tDot11fIERSN, present), 0, "RSN" , 0, 8, 112, SigIeRSN, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSN, 0, },
        {offsetof(tDot11fBeacon2, EDCAParamSet), offsetof(tDot11fIEEDCAParamSet, present), 0, "EDCAParamSet" , 0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EDCAPARAMSET, 0, },
        {offsetof(tDot11fBeacon2, APChannelReport), offsetof(tDot11fIEAPChannelReport, present), 0, "APChannelReport" , 0, 3, 53, SigIeAPChannelReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_APCHANNELREPORT, 0, },
        {offsetof(tDot11fBeacon2, RRMEnabledCap), offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap" , 0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RRMENABLEDCAP, 0, },
        {offsetof(tDot11fBeacon2, MobilityDomain), offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain" , 0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MOBILITYDOMAIN, 0, },
        {offsetof(tDot11fBeacon2, WPA), offsetof(tDot11fIEWPA, present), 0, "WPA" , 0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPA, 0, },
        {offsetof(tDot11fBeacon2, HTCaps), offsetof(tDot11fIEHTCaps, present), 0, "HTCaps" , 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTCAPS, 0, },
        {offsetof(tDot11fBeacon2, HTInfo), offsetof(tDot11fIEHTInfo, present), 0, "HTInfo" , 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTINFO, 0, },
        {offsetof(tDot11fBeacon2, ExtChanSwitchAnn), offsetof(tDot11fIEExtChanSwitchAnn, present), 0, "ExtChanSwitchAnn" , 0, 3, 3, SigIeExtChanSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTCHANSWITCHANN, 0, },
        {offsetof(tDot11fBeacon2, WMMInfoAp), offsetof(tDot11fIEWMMInfoAp, present), 0, "WMMInfoAp" , 0, 9, 9, SigIeWMMInfoAp, {0, 80, 242, 2, 0}, 5, DOT11F_EID_WMMINFOAP, 0, },
        {offsetof(tDot11fBeacon2, WMMParams), offsetof(tDot11fIEWMMParams, present), 0, "WMMParams" , 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1}, 5, DOT11F_EID_WMMPARAMS, 0, },
        {offsetof(tDot11fBeacon2, WMMCaps), offsetof(tDot11fIEWMMCaps, present), 0, "WMMCaps" , 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5}, 5, DOT11F_EID_WMMCAPS, 0, },
        {offsetof(tDot11fBeacon2, Airgo), offsetof(tDot11fIEAirgo, present), 0, "Airgo" , 0, 5, 232, SigIeAirgo, {0, 10, 245, 0, 0}, 3, DOT11F_EID_AIRGO, 0, },
        {offsetof(tDot11fBeacon2, WscBeacon), offsetof(tDot11fIEWscBeacon, present), 0, "WscBeacon" , 0, 6, 84, SigIeWscBeacon, {0, 80, 242, 4, 0}, 4, DOT11F_EID_WSCBEACON, 0, },
        {offsetof(tDot11fBeacon2, WAPI), offsetof(tDot11fIEWAPI, present), 0, "WAPI" , 0, 14, 112, SigIeWAPI, {0, 0, 0, 0, 0}, 0, DOT11F_EID_WAPI, 0, },
        {offsetof(tDot11fBeacon2, CCXRadMgmtCap), offsetof(tDot11fIECCXRadMgmtCap, present), 0, "CCXRadMgmtCap" , 0, 8, 8, SigIeCCXRadMgmtCap, {0, 64, 150, 1, 0}, 4, DOT11F_EID_CCXRADMGMTCAP, 0, },
        {offsetof(tDot11fBeacon2, CCXTrafStrmMet), offsetof(tDot11fIECCXTrafStrmMet, present), 0, "CCXTrafStrmMet" , 0, 10, 10, SigIeCCXTrafStrmMet, {0, 64, 150, 7, 0}, 4, DOT11F_EID_CCXTRAFSTRMMET, 0, },
        {offsetof(tDot11fBeacon2, CCXTxmitPower), offsetof(tDot11fIECCXTxmitPower, present), 0, "CCXTxmitPower" , 0, 8, 8, SigIeCCXTxmitPower, {0, 64, 150, 0, 0}, 4, DOT11F_EID_CCXTXMITPOWER, 0, },
        {offsetof(tDot11fBeacon2, P2PBeacon), offsetof(tDot11fIEP2PBeacon, present), 0, "P2PBeacon" , 0, 6, 61, SigIeP2PBeacon, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PBEACON, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackBeacon2(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fBeacon2 *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_Beacon2, IES_Beacon2, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Unpacked the Beacon2:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Country:\n"));
        if (!pFrm->Country.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Country.country, 3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("num_triplets: %d.\n"), pFrm->Country.num_triplets);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->Country.triplets, 3 * pFrm->Country.num_triplets);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("PowerConstraints:\n"));
        if (!pFrm->PowerConstraints.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->PowerConstraints.localPowerConstraints, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("ChanSwitchAnn:\n"));
        if (!pFrm->ChanSwitchAnn.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->ChanSwitchAnn.switchMode, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->ChanSwitchAnn.newChannel, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->ChanSwitchAnn.switchCount, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Quiet:\n"));
        if (!pFrm->Quiet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Quiet.count, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Quiet.period, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Quiet.duration, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Quiet.offset, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("TPCReport:\n"));
        if (!pFrm->TPCReport.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->TPCReport.tx_power, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->TPCReport.link_margin, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("ERPInfo:\n"));
        if (!pFrm->ERPInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("non_erp_present (1): %d\n"), pFrm->ERPInfo.non_erp_present);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("use_prot (1): %d\n"), pFrm->ERPInfo.use_prot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("barker_preamble (1): %d\n"), pFrm->ERPInfo.barker_preamble);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused (5): %d\n"), pFrm->ERPInfo.unused);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("ExtSuppRates:\n"));
        if (!pFrm->ExtSuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("num_rates: %d.\n"), pFrm->ExtSuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->ExtSuppRates.rates, pFrm->ExtSuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("RSN:\n"));
        if (!pFrm->RSN.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->RSN.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->RSN.gp_cipher_suite, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->RSN.pwise_cipher_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->RSN.pwise_cipher_suites, 4 * pFrm->RSN.pwise_cipher_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->RSN.akm_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->RSN.akm_suites, 4 * pFrm->RSN.akm_suite_count);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("preauth (1): %d\n"), pFrm->RSN.preauth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("no_pwise (1): %d\n"), pFrm->RSN.no_pwise);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("PTKSA_replay_counter (2): %d\n"), pFrm->RSN.PTKSA_replay_counter);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("GTKSA_replay_counter (2): %d\n"), pFrm->RSN.GTKSA_replay_counter);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved (10): %d\n"), pFrm->RSN.reserved);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->RSN.pmkid_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->RSN.pmkid, 16 * pFrm->RSN.pmkid_count);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("EDCAParamSet:\n"));
        if (!pFrm->EDCAParamSet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->EDCAParamSet.qos, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->EDCAParamSet.reserved, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_aifsn (4): %d\n"), pFrm->EDCAParamSet.acbe_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_acm (1): %d\n"), pFrm->EDCAParamSet.acbe_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_aci (2): %d\n"), pFrm->EDCAParamSet.acbe_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused1 (1): %d\n"), pFrm->EDCAParamSet.unused1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_acwmin (4): %d\n"), pFrm->EDCAParamSet.acbe_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_acwmax (4): %d\n"), pFrm->EDCAParamSet.acbe_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->EDCAParamSet.acbe_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_aifsn (4): %d\n"), pFrm->EDCAParamSet.acbk_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_acm (1): %d\n"), pFrm->EDCAParamSet.acbk_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_aci (2): %d\n"), pFrm->EDCAParamSet.acbk_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused2 (1): %d\n"), pFrm->EDCAParamSet.unused2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_acwmin (4): %d\n"), pFrm->EDCAParamSet.acbk_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_acwmax (4): %d\n"), pFrm->EDCAParamSet.acbk_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->EDCAParamSet.acbk_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_aifsn (4): %d\n"), pFrm->EDCAParamSet.acvi_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_acm (1): %d\n"), pFrm->EDCAParamSet.acvi_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_aci (2): %d\n"), pFrm->EDCAParamSet.acvi_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused3 (1): %d\n"), pFrm->EDCAParamSet.unused3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_acwmin (4): %d\n"), pFrm->EDCAParamSet.acvi_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_acwmax (4): %d\n"), pFrm->EDCAParamSet.acvi_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->EDCAParamSet.acvi_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_aifsn (4): %d\n"), pFrm->EDCAParamSet.acvo_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_acm (1): %d\n"), pFrm->EDCAParamSet.acvo_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_aci (2): %d\n"), pFrm->EDCAParamSet.acvo_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused4 (1): %d\n"), pFrm->EDCAParamSet.unused4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_acwmin (4): %d\n"), pFrm->EDCAParamSet.acvo_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_acwmax (4): %d\n"), pFrm->EDCAParamSet.acvo_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->EDCAParamSet.acvo_txoplimit, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("APChannelReport:\n"));
        if (!pFrm->APChannelReport.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->APChannelReport.regulatoryClass, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("num_channelList: %d.\n"), pFrm->APChannelReport.num_channelList);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->APChannelReport.channelList, pFrm->APChannelReport.num_channelList);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("RRMEnabledCap:\n"));
        if (!pFrm->RRMEnabledCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("LinkMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LinkMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("NeighborRpt (1): %d\n"), pFrm->RRMEnabledCap.NeighborRpt);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("parallel (1): %d\n"), pFrm->RRMEnabledCap.parallel);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("repeated (1): %d\n"), pFrm->RRMEnabledCap.repeated);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("BeaconPassive (1): %d\n"), pFrm->RRMEnabledCap.BeaconPassive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("BeaconActive (1): %d\n"), pFrm->RRMEnabledCap.BeaconActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("BeaconTable (1): %d\n"), pFrm->RRMEnabledCap.BeaconTable);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("BeaconRepCond (1): %d\n"), pFrm->RRMEnabledCap.BeaconRepCond);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("FrameMeasurement (1): %d\n"), pFrm->RRMEnabledCap.FrameMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("ChannelLoad (1): %d\n"), pFrm->RRMEnabledCap.ChannelLoad);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("NoiseHistogram (1): %d\n"), pFrm->RRMEnabledCap.NoiseHistogram);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("statistics (1): %d\n"), pFrm->RRMEnabledCap.statistics);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("LCIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LCIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("LCIAzimuth (1): %d\n"), pFrm->RRMEnabledCap.LCIAzimuth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("TCMCapability (1): %d\n"), pFrm->RRMEnabledCap.TCMCapability);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("triggeredTCM (1): %d\n"), pFrm->RRMEnabledCap.triggeredTCM);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("APChanReport (1): %d\n"), pFrm->RRMEnabledCap.APChanReport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("RRMMIBEnabled (1): %d\n"), pFrm->RRMEnabledCap.RRMMIBEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("operatingChanMax (3): %d\n"), pFrm->RRMEnabledCap.operatingChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("nonOperatinChanMax (3): %d\n"), pFrm->RRMEnabledCap.nonOperatinChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("MeasurementPilot (3): %d\n"), pFrm->RRMEnabledCap.MeasurementPilot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("MeasurementPilotEnabled (1): %d\n"), pFrm->RRMEnabledCap.MeasurementPilotEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("NeighborTSFOffset (1): %d\n"), pFrm->RRMEnabledCap.NeighborTSFOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("RCPIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RCPIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("RSNIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RSNIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("BssAvgAccessDelay (1): %d\n"), pFrm->RRMEnabledCap.BssAvgAccessDelay);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("BSSAvailAdmission (1): %d\n"), pFrm->RRMEnabledCap.BSSAvailAdmission);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("AntennaInformation (1): %d\n"), pFrm->RRMEnabledCap.AntennaInformation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved (6): %d\n"), pFrm->RRMEnabledCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("MobilityDomain:\n"));
        if (!pFrm->MobilityDomain.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->MobilityDomain.MDID, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("overDSCap (1): %d\n"), pFrm->MobilityDomain.overDSCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("resourceReqCap (1): %d\n"), pFrm->MobilityDomain.resourceReqCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved (6): %d\n"), pFrm->MobilityDomain.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("WPA:\n"));
        if (!pFrm->WPA.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WPA.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WPA.multicast_cipher, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WPA.unicast_cipher_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->WPA.unicast_ciphers, 4 * pFrm->WPA.unicast_cipher_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WPA.auth_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->WPA.auth_suites, 4 * pFrm->WPA.auth_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WPA.caps, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("HTCaps:\n"));
        if (!pFrm->HTCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("advCodingCap (1): %d\n"), pFrm->HTCaps.advCodingCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("supportedChannelWidthSet (1): %d\n"), pFrm->HTCaps.supportedChannelWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("mimoPowerSave (2): %d\n"), pFrm->HTCaps.mimoPowerSave);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("greenField (1): %d\n"), pFrm->HTCaps.greenField);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("shortGI20MHz (1): %d\n"), pFrm->HTCaps.shortGI20MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("shortGI40MHz (1): %d\n"), pFrm->HTCaps.shortGI40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("txSTBC (1): %d\n"), pFrm->HTCaps.txSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("rxSTBC (2): %d\n"), pFrm->HTCaps.rxSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("delayedBA (1): %d\n"), pFrm->HTCaps.delayedBA);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("maximalAMSDUsize (1): %d\n"), pFrm->HTCaps.maximalAMSDUsize);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("dsssCckMode40MHz (1): %d\n"), pFrm->HTCaps.dsssCckMode40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("psmp (1): %d\n"), pFrm->HTCaps.psmp);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("stbcControlFrame (1): %d\n"), pFrm->HTCaps.stbcControlFrame);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("lsigTXOPProtection (1): %d\n"), pFrm->HTCaps.lsigTXOPProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("maxRxAMPDUFactor (2): %d\n"), pFrm->HTCaps.maxRxAMPDUFactor);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("mpduDensity (3): %d\n"), pFrm->HTCaps.mpduDensity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved1 (3): %d\n"), pFrm->HTCaps.reserved1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->HTCaps.supportedMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("pco (1): %d\n"), pFrm->HTCaps.pco);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("transitionTime (2): %d\n"), pFrm->HTCaps.transitionTime);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved2 (5): %d\n"), pFrm->HTCaps.reserved2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("mcsFeedback (2): %d\n"), pFrm->HTCaps.mcsFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved3 (6): %d\n"), pFrm->HTCaps.reserved3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("txBF (1): %d\n"), pFrm->HTCaps.txBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("rxStaggeredSounding (1): %d\n"), pFrm->HTCaps.rxStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("txStaggeredSounding (1): %d\n"), pFrm->HTCaps.txStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("rxZLF (1): %d\n"), pFrm->HTCaps.rxZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("txZLF (1): %d\n"), pFrm->HTCaps.txZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("implicitTxBF (1): %d\n"), pFrm->HTCaps.implicitTxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("calibration (2): %d\n"), pFrm->HTCaps.calibration);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("explicitCSITxBF (1): %d\n"), pFrm->HTCaps.explicitCSITxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("explicitUncompressedSteeringMatrix (1): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrix);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("explicitBFCSIFeedback (3): %d\n"), pFrm->HTCaps.explicitBFCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("explicitUncompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("explicitCompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitCompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("csiNumBFAntennae (2): %d\n"), pFrm->HTCaps.csiNumBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("uncompressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.uncompressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("compressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.compressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved4 (7): %d\n"), pFrm->HTCaps.reserved4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("antennaSelection (1): %d\n"), pFrm->HTCaps.antennaSelection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("explicitCSIFeedbackTx (1): %d\n"), pFrm->HTCaps.explicitCSIFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("antennaIndicesFeedbackTx (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("explicitCSIFeedback (1): %d\n"), pFrm->HTCaps.explicitCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("antennaIndicesFeedback (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("rxAS (1): %d\n"), pFrm->HTCaps.rxAS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("txSoundingPPDUs (1): %d\n"), pFrm->HTCaps.txSoundingPPDUs);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved5 (1): %d\n"), pFrm->HTCaps.reserved5);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("num_rsvd: %d.\n"), pFrm->HTCaps.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->HTCaps.rsvd, pFrm->HTCaps.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("HTInfo:\n"));
        if (!pFrm->HTInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->HTInfo.primaryChannel, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("secondaryChannelOffset (2): %d\n"), pFrm->HTInfo.secondaryChannelOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("recommendedTxWidthSet (1): %d\n"), pFrm->HTInfo.recommendedTxWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("rifsMode (1): %d\n"), pFrm->HTInfo.rifsMode);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("controlledAccessOnly (1): %d\n"), pFrm->HTInfo.controlledAccessOnly);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("serviceIntervalGranularity (3): %d\n"), pFrm->HTInfo.serviceIntervalGranularity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("opMode (2): %d\n"), pFrm->HTInfo.opMode);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("nonGFDevicesPresent (1): %d\n"), pFrm->HTInfo.nonGFDevicesPresent);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("transmitBurstLimit (1): %d\n"), pFrm->HTInfo.transmitBurstLimit);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("obssNonHTStaPresent (1): %d\n"), pFrm->HTInfo.obssNonHTStaPresent);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved (11): %d\n"), pFrm->HTInfo.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("basicSTBCMCS (7): %d\n"), pFrm->HTInfo.basicSTBCMCS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("dualCTSProtection (1): %d\n"), pFrm->HTInfo.dualCTSProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("secondaryBeacon (1): %d\n"), pFrm->HTInfo.secondaryBeacon);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("lsigTXOPProtectionFullSupport (1): %d\n"), pFrm->HTInfo.lsigTXOPProtectionFullSupport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("pcoActive (1): %d\n"), pFrm->HTInfo.pcoActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("pcoPhase (1): %d\n"), pFrm->HTInfo.pcoPhase);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved2 (4): %d\n"), pFrm->HTInfo.reserved2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->HTInfo.basicMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("num_rsvd: %d.\n"), pFrm->HTInfo.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->HTInfo.rsvd, pFrm->HTInfo.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("ExtChanSwitchAnn:\n"));
        if (!pFrm->ExtChanSwitchAnn.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->ExtChanSwitchAnn.secondaryChannelOffset, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("WMMInfoAp:\n"));
        if (!pFrm->WMMInfoAp.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WMMInfoAp.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("param_set_count (4): %d\n"), pFrm->WMMInfoAp.param_set_count);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved (3): %d\n"), pFrm->WMMInfoAp.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("uapsd (1): %d\n"), pFrm->WMMInfoAp.uapsd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("WMMParams:\n"));
        if (!pFrm->WMMParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WMMParams.version, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WMMParams.qosInfo, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WMMParams.reserved2, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_aifsn (4): %d\n"), pFrm->WMMParams.acbe_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_acm (1): %d\n"), pFrm->WMMParams.acbe_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_aci (2): %d\n"), pFrm->WMMParams.acbe_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused1 (1): %d\n"), pFrm->WMMParams.unused1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_acwmin (4): %d\n"), pFrm->WMMParams.acbe_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_acwmax (4): %d\n"), pFrm->WMMParams.acbe_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WMMParams.acbe_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_aifsn (4): %d\n"), pFrm->WMMParams.acbk_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_acm (1): %d\n"), pFrm->WMMParams.acbk_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_aci (2): %d\n"), pFrm->WMMParams.acbk_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused2 (1): %d\n"), pFrm->WMMParams.unused2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_acwmin (4): %d\n"), pFrm->WMMParams.acbk_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_acwmax (4): %d\n"), pFrm->WMMParams.acbk_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WMMParams.acbk_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_aifsn (4): %d\n"), pFrm->WMMParams.acvi_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_acm (1): %d\n"), pFrm->WMMParams.acvi_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_aci (2): %d\n"), pFrm->WMMParams.acvi_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused3 (1): %d\n"), pFrm->WMMParams.unused3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_acwmin (4): %d\n"), pFrm->WMMParams.acvi_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_acwmax (4): %d\n"), pFrm->WMMParams.acvi_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WMMParams.acvi_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_aifsn (4): %d\n"), pFrm->WMMParams.acvo_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_acm (1): %d\n"), pFrm->WMMParams.acvo_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_aci (2): %d\n"), pFrm->WMMParams.acvo_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused4 (1): %d\n"), pFrm->WMMParams.unused4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_acwmin (4): %d\n"), pFrm->WMMParams.acvo_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_acwmax (4): %d\n"), pFrm->WMMParams.acvo_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WMMParams.acvo_txoplimit, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("WMMCaps:\n"));
        if (!pFrm->WMMCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WMMCaps.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved (4): %d\n"), pFrm->WMMCaps.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("qack (1): %d\n"), pFrm->WMMCaps.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("queue_request (1): %d\n"), pFrm->WMMCaps.queue_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("txop_request (1): %d\n"), pFrm->WMMCaps.txop_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("more_ack (1): %d\n"), pFrm->WMMCaps.more_ack);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Airgo:\n"));
        if (!pFrm->Airgo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("PropSuppRates:\n"));
            if (!pFrm->Airgo.PropSuppRates.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("num_rates: %d.\n"), pFrm->Airgo.PropSuppRates.num_rates);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->Airgo.PropSuppRates.rates, pFrm->Airgo.PropSuppRates.num_rates);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("APName:\n"));
            if (!pFrm->Airgo.APName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("num_name: %d.\n"), pFrm->Airgo.APName.num_name);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->Airgo.APName.name, pFrm->Airgo.APName.num_name);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("HCF:\n"));
            if (!pFrm->Airgo.HCF.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.HCF.enabled, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("WDS:\n"));
            if (!pFrm->Airgo.WDS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("num_wdsData: %d.\n"), pFrm->Airgo.WDS.num_wdsData);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->Airgo.WDS.wdsData, pFrm->Airgo.WDS.num_wdsData);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("BPIndicator:\n"));
            if (!pFrm->Airgo.BPIndicator.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.BPIndicator.indicator, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.BPIndicator.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("LoadInfo:\n"));
            if (!pFrm->Airgo.LoadInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.LoadInfo.num_stas, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.LoadInfo.channel_util, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("LoadBalance:\n"));
            if (!pFrm->Airgo.LoadBalance.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.LoadBalance.bssid, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.LoadBalance.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("PropAssocType:\n"));
            if (!pFrm->Airgo.PropAssocType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropAssocType.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("LLAttr:\n"));
            if (!pFrm->Airgo.LLAttr.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.LLAttr.defer_threshold, 4);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("PropCapability:\n"));
            if (!pFrm->Airgo.PropCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropCapability.capability, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Version:\n"));
            if (!pFrm->Airgo.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.Version.chip_rev, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.Version.card_type, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("num_build_version: %d.\n"), pFrm->Airgo.Version.num_build_version);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->Airgo.Version.build_version, pFrm->Airgo.Version.num_build_version);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("PropEDCAParams:\n"));
            if (!pFrm->Airgo.PropEDCAParams.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.qos, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.reserved, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused1 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbe_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbe_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused2 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acbk_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbk_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused3 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvi_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvi_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("unused4 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused4);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("acvo_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvo_txoplimit, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Titan:\n"));
            if (!pFrm->Airgo.Titan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.Titan.concat_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.Titan.compression_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.Titan.cb_state, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.Titan.rev_fcs_state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("PropChannSwitchAnn:\n"));
            if (!pFrm->Airgo.PropChannSwitchAnn.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.mode, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.primary_channel, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.sub_band, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.channel_switch_count, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("PropQuietBSS:\n"));
            if (!pFrm->Airgo.PropQuietBSS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_count, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_period, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_duration, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_offset, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("TriggerStaBgScan:\n"));
            if (!pFrm->Airgo.TriggerStaBgScan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.TriggerStaBgScan.enable, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Taurus:\n"));
            if (!pFrm->Airgo.Taurus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.Taurus.baTIDBitmap, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->Airgo.Taurus.baPolicy, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("baBufferSize (12): %d\n"), pFrm->Airgo.Taurus.baBufferSize);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("rsvd (4): %d\n"), pFrm->Airgo.Taurus.rsvd);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("WscBeacon:\n"));
        if (!pFrm->WscBeacon.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Version:\n"));
            if (!pFrm->WscBeacon.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("minor (4): %d\n"), pFrm->WscBeacon.Version.minor);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("major (4): %d\n"), pFrm->WscBeacon.Version.major);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("WPSState:\n"));
            if (!pFrm->WscBeacon.WPSState.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WscBeacon.WPSState.state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("APSetupLocked:\n"));
            if (!pFrm->WscBeacon.APSetupLocked.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WscBeacon.APSetupLocked.fLocked, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("SelectedRegistrar:\n"));
            if (!pFrm->WscBeacon.SelectedRegistrar.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WscBeacon.SelectedRegistrar.selected, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("DevicePasswordID:\n"));
            if (!pFrm->WscBeacon.DevicePasswordID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WscBeacon.DevicePasswordID.id, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("SelectedRegistrarConfigMethods:\n"));
            if (!pFrm->WscBeacon.SelectedRegistrarConfigMethods.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WscBeacon.SelectedRegistrarConfigMethods.methods, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("UUID_E:\n"));
            if (!pFrm->WscBeacon.UUID_E.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WscBeacon.UUID_E.uuid, 16);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("RFBands:\n"));
            if (!pFrm->WscBeacon.RFBands.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WscBeacon.RFBands.bands, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("VendorExtension:\n"));
            if (!pFrm->WscBeacon.VendorExtension.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WscBeacon.VendorExtension.vendorId, 3);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Version2:\n"));
                if (!pFrm->WscBeacon.VendorExtension.Version2.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("minor (4): %d\n"), pFrm->WscBeacon.VendorExtension.Version2.minor);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("major (4): %d\n"), pFrm->WscBeacon.VendorExtension.Version2.major);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("AuthorizedMACs:\n"));
                if (!pFrm->WscBeacon.VendorExtension.AuthorizedMACs.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WscBeacon.VendorExtension.AuthorizedMACs.mac, 6);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("RequestToEnroll:\n"));
                if (!pFrm->WscBeacon.VendorExtension.RequestToEnroll.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WscBeacon.VendorExtension.RequestToEnroll.req, 1);
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("WAPI:\n"));
        if (!pFrm->WAPI.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WAPI.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WAPI.akm_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->WAPI.akm_suites, 4 * pFrm->WAPI.akm_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WAPI.unicast_cipher_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->WAPI.unicast_cipher_suites, 4 * pFrm->WAPI.unicast_cipher_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WAPI.multicast_cipher_suite, 4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("preauth (1): %d\n"), pFrm->WAPI.preauth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved (15): %d\n"), pFrm->WAPI.reserved);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->WAPI.bkid_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->WAPI.bkid, 16 * pFrm->WAPI.bkid_count);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("CCXRadMgmtCap:\n"));
        if (!pFrm->CCXRadMgmtCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->CCXRadMgmtCap.mgmt_state, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("mbssid_mask (3): %d\n"), pFrm->CCXRadMgmtCap.mbssid_mask);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("reserved (5): %d\n"), pFrm->CCXRadMgmtCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("CCXTrafStrmMet:\n"));
        if (!pFrm->CCXTrafStrmMet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->CCXTrafStrmMet.tsid, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->CCXTrafStrmMet.state, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->CCXTrafStrmMet.msmt_interval, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("CCXTxmitPower:\n"));
        if (!pFrm->CCXTxmitPower.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->CCXTxmitPower.power_limit, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->CCXTxmitPower.reserved, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("P2PBeacon:\n"));
        if (!pFrm->P2PBeacon.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("P2PCapability:\n"));
            if (!pFrm->P2PBeacon.P2PCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->P2PBeacon.P2PCapability.deviceCapability, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->P2PBeacon.P2PCapability.groupCapability, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("P2PDeviceId:\n"));
            if (!pFrm->P2PBeacon.P2PDeviceId.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->P2PBeacon.P2PDeviceId.P2PDeviceAddress, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("NoticeOfAbsence:\n"));
            if (!pFrm->P2PBeacon.NoticeOfAbsence.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->P2PBeacon.NoticeOfAbsence.index, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* )&pFrm->P2PBeacon.NoticeOfAbsence.CTSWindowOppPS, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), FRFL("num_NoADesc: %d.\n"), pFrm->P2PBeacon.NoticeOfAbsence.num_NoADesc);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACON2), ( tANI_U8* ) pFrm->P2PBeacon.NoticeOfAbsence.NoADesc, pFrm->P2PBeacon.NoticeOfAbsence.num_NoADesc);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackBeacon2. */

    static const tFFDefn FFS_BeaconIEs[] = {
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_BeaconIEs[] = {
        {offsetof(tDot11fBeaconIEs, SSID), offsetof(tDot11fIESSID, present), 0, "SSID" , 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 1, },
        {offsetof(tDot11fBeaconIEs, SuppRates), offsetof(tDot11fIESuppRates, present), 0, "SuppRates" , 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPRATES, 1, },
        {offsetof(tDot11fBeaconIEs, FHParamSet), offsetof(tDot11fIEFHParamSet, present), 0, "FHParamSet" , 0, 7, 7, SigIeFHParamSet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FHPARAMSET, 0, },
        {offsetof(tDot11fBeaconIEs, DSParams), offsetof(tDot11fIEDSParams, present), 0, "DSParams" , 0, 3, 3, SigIeDSParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_DSPARAMS, 0, },
        {offsetof(tDot11fBeaconIEs, CFParams), offsetof(tDot11fIECFParams, present), 0, "CFParams" , 0, 8, 8, SigIeCFParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_CFPARAMS, 0, },
        {offsetof(tDot11fBeaconIEs, IBSSParams), offsetof(tDot11fIEIBSSParams, present), 0, "IBSSParams" , 0, 4, 4, SigIeIBSSParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_IBSSPARAMS, 0, },
        {offsetof(tDot11fBeaconIEs, TIM), offsetof(tDot11fIETIM, present), 0, "TIM" , 0, 6, 256, SigIeTIM, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TIM, 0, },
        {offsetof(tDot11fBeaconIEs, Country), offsetof(tDot11fIECountry, present), 0, "Country" , 0, 5, 257, SigIeCountry, {0, 0, 0, 0, 0}, 0, DOT11F_EID_COUNTRY, 0, },
        {offsetof(tDot11fBeaconIEs, FHParams), offsetof(tDot11fIEFHParams, present), 0, "FHParams" , 0, 4, 4, SigIeFHParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FHPARAMS, 0, },
        {offsetof(tDot11fBeaconIEs, FHPattTable), offsetof(tDot11fIEFHPattTable, present), 0, "FHPattTable" , 0, 6, 257, SigIeFHPattTable, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FHPATTTABLE, 0, },
        {offsetof(tDot11fBeaconIEs, PowerConstraints), offsetof(tDot11fIEPowerConstraints, present), 0, "PowerConstraints" , 0, 3, 3, SigIePowerConstraints, {0, 0, 0, 0, 0}, 0, DOT11F_EID_POWERCONSTRAINTS, 0, },
        {offsetof(tDot11fBeaconIEs, ChanSwitchAnn), offsetof(tDot11fIEChanSwitchAnn, present), 0, "ChanSwitchAnn" , 0, 5, 5, SigIeChanSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_CHANSWITCHANN, 0, },
        {offsetof(tDot11fBeaconIEs, Quiet), offsetof(tDot11fIEQuiet, present), 0, "Quiet" , 0, 8, 8, SigIeQuiet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QUIET, 0, },
        {offsetof(tDot11fBeaconIEs, TPCReport), offsetof(tDot11fIETPCReport, present), 0, "TPCReport" , 0, 4, 4, SigIeTPCReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TPCREPORT, 0, },
        {offsetof(tDot11fBeaconIEs, ERPInfo), offsetof(tDot11fIEERPInfo, present), 0, "ERPInfo" , 0, 3, 3, SigIeERPInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_ERPINFO, 0, },
        {offsetof(tDot11fBeaconIEs, ExtSuppRates), offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates" , 0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTSUPPRATES, 0, },
        {offsetof(tDot11fBeaconIEs, RSN), offsetof(tDot11fIERSN, present), 0, "RSN" , 0, 8, 112, SigIeRSN, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSN, 0, },
        {offsetof(tDot11fBeaconIEs, QBSSLoad), offsetof(tDot11fIEQBSSLoad, present), 0, "QBSSLoad" , 0, 7, 7, SigIeQBSSLoad, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QBSSLOAD, 0, },
        {offsetof(tDot11fBeaconIEs, EDCAParamSet), offsetof(tDot11fIEEDCAParamSet, present), 0, "EDCAParamSet" , 0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EDCAPARAMSET, 0, },
        {offsetof(tDot11fBeaconIEs, QOSCapsAp), offsetof(tDot11fIEQOSCapsAp, present), 0, "QOSCapsAp" , 0, 3, 3, SigIeQOSCapsAp, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QOSCAPSAP, 0, },
        {offsetof(tDot11fBeaconIEs, APChannelReport), offsetof(tDot11fIEAPChannelReport, present), 0, "APChannelReport" , 0, 3, 53, SigIeAPChannelReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_APCHANNELREPORT, 0, },
        {offsetof(tDot11fBeaconIEs, RRMEnabledCap), offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap" , 0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RRMENABLEDCAP, 0, },
        {offsetof(tDot11fBeaconIEs, MobilityDomain), offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain" , 0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MOBILITYDOMAIN, 0, },
        {offsetof(tDot11fBeaconIEs, WPA), offsetof(tDot11fIEWPA, present), 0, "WPA" , 0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPA, 0, },
        {offsetof(tDot11fBeaconIEs, HTCaps), offsetof(tDot11fIEHTCaps, present), 0, "HTCaps" , 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTCAPS, 0, },
        {offsetof(tDot11fBeaconIEs, HTInfo), offsetof(tDot11fIEHTInfo, present), 0, "HTInfo" , 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTINFO, 0, },
        {offsetof(tDot11fBeaconIEs, ExtChanSwitchAnn), offsetof(tDot11fIEExtChanSwitchAnn, present), 0, "ExtChanSwitchAnn" , 0, 3, 3, SigIeExtChanSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTCHANSWITCHANN, 0, },
        {offsetof(tDot11fBeaconIEs, WMMInfoAp), offsetof(tDot11fIEWMMInfoAp, present), 0, "WMMInfoAp" , 0, 9, 9, SigIeWMMInfoAp, {0, 80, 242, 2, 0}, 5, DOT11F_EID_WMMINFOAP, 0, },
        {offsetof(tDot11fBeaconIEs, WMMParams), offsetof(tDot11fIEWMMParams, present), 0, "WMMParams" , 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1}, 5, DOT11F_EID_WMMPARAMS, 0, },
        {offsetof(tDot11fBeaconIEs, WMMCaps), offsetof(tDot11fIEWMMCaps, present), 0, "WMMCaps" , 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5}, 5, DOT11F_EID_WMMCAPS, 0, },
        {offsetof(tDot11fBeaconIEs, WAPI), offsetof(tDot11fIEWAPI, present), 0, "WAPI" , 0, 14, 112, SigIeWAPI, {0, 0, 0, 0, 0}, 0, DOT11F_EID_WAPI, 0, },
        {offsetof(tDot11fBeaconIEs, CCXVersion), offsetof(tDot11fIECCXVersion, present), 0, "CCXVersion" , 0, 7, 7, SigIeCCXVersion, {0, 64, 150, 3, 0}, 4, DOT11F_EID_CCXVERSION, 0, },
        {offsetof(tDot11fBeaconIEs, CCXRadMgmtCap), offsetof(tDot11fIECCXRadMgmtCap, present), 0, "CCXRadMgmtCap" , 0, 8, 8, SigIeCCXRadMgmtCap, {0, 64, 150, 1, 0}, 4, DOT11F_EID_CCXRADMGMTCAP, 0, },
        {offsetof(tDot11fBeaconIEs, CCXTrafStrmMet), offsetof(tDot11fIECCXTrafStrmMet, present), 0, "CCXTrafStrmMet" , 0, 10, 10, SigIeCCXTrafStrmMet, {0, 64, 150, 7, 0}, 4, DOT11F_EID_CCXTRAFSTRMMET, 0, },
        {offsetof(tDot11fBeaconIEs, CCXTxmitPower), offsetof(tDot11fIECCXTxmitPower, present), 0, "CCXTxmitPower" , 0, 8, 8, SigIeCCXTxmitPower, {0, 64, 150, 0, 0}, 4, DOT11F_EID_CCXTXMITPOWER, 0, },
        {offsetof(tDot11fBeaconIEs, Airgo), offsetof(tDot11fIEAirgo, present), 0, "Airgo" , 0, 5, 232, SigIeAirgo, {0, 10, 245, 0, 0}, 3, DOT11F_EID_AIRGO, 0, },
        {offsetof(tDot11fBeaconIEs, WscBeaconProbeRes), offsetof(tDot11fIEWscBeaconProbeRes, present), 0, "WscBeaconProbeRes" , 0, 6, 319, SigIeWscBeaconProbeRes, {0, 80, 242, 4, 0}, 4, DOT11F_EID_WSCBEACONPROBERES, 0, },
        {offsetof(tDot11fBeaconIEs, P2PBeaconProbeRes), offsetof(tDot11fIEP2PBeaconProbeRes, present), 0, "P2PBeaconProbeRes" , 0, 6, 1150, SigIeP2PBeaconProbeRes, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PBEACONPROBERES, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackBeaconIEs(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fBeaconIEs *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_BeaconIEs, IES_BeaconIEs, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Unpacked the BeaconIEs:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("SSID:\n"));
        if (!pFrm->SSID.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_ssid: %d.\n"), pFrm->SSID.num_ssid);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->SSID.ssid, pFrm->SSID.num_ssid);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("SuppRates:\n"));
        if (!pFrm->SuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_rates: %d.\n"), pFrm->SuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->SuppRates.rates, pFrm->SuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("FHParamSet:\n"));
        if (!pFrm->FHParamSet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->FHParamSet.dwell_time, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->FHParamSet.hop_set, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->FHParamSet.hop_pattern, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->FHParamSet.hop_index, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("DSParams:\n"));
        if (!pFrm->DSParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->DSParams.curr_channel, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("CFParams:\n"));
        if (!pFrm->CFParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CFParams.cfp_count, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CFParams.cfp_period, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CFParams.cfp_maxduration, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CFParams.cfp_durremaining, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("IBSSParams:\n"));
        if (!pFrm->IBSSParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->IBSSParams.atim, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("TIM:\n"));
        if (!pFrm->TIM.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->TIM.dtim_count, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->TIM.dtim_period, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->TIM.bmpctl, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_vbmp: %d.\n"), pFrm->TIM.num_vbmp);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->TIM.vbmp, pFrm->TIM.num_vbmp);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Country:\n"));
        if (!pFrm->Country.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Country.country, 3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_triplets: %d.\n"), pFrm->Country.num_triplets);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->Country.triplets, 3 * pFrm->Country.num_triplets);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("FHParams:\n"));
        if (!pFrm->FHParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->FHParams.radix, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->FHParams.nchannels, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("FHPattTable:\n"));
        if (!pFrm->FHPattTable.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->FHPattTable.flag, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->FHPattTable.nsets, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->FHPattTable.modulus, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->FHPattTable.offset, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_randtable: %d.\n"), pFrm->FHPattTable.num_randtable);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->FHPattTable.randtable, pFrm->FHPattTable.num_randtable);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("PowerConstraints:\n"));
        if (!pFrm->PowerConstraints.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->PowerConstraints.localPowerConstraints, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("ChanSwitchAnn:\n"));
        if (!pFrm->ChanSwitchAnn.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->ChanSwitchAnn.switchMode, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->ChanSwitchAnn.newChannel, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->ChanSwitchAnn.switchCount, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Quiet:\n"));
        if (!pFrm->Quiet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Quiet.count, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Quiet.period, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Quiet.duration, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Quiet.offset, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("TPCReport:\n"));
        if (!pFrm->TPCReport.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->TPCReport.tx_power, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->TPCReport.link_margin, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("ERPInfo:\n"));
        if (!pFrm->ERPInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("non_erp_present (1): %d\n"), pFrm->ERPInfo.non_erp_present);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("use_prot (1): %d\n"), pFrm->ERPInfo.use_prot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("barker_preamble (1): %d\n"), pFrm->ERPInfo.barker_preamble);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused (5): %d\n"), pFrm->ERPInfo.unused);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("ExtSuppRates:\n"));
        if (!pFrm->ExtSuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_rates: %d.\n"), pFrm->ExtSuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->ExtSuppRates.rates, pFrm->ExtSuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("RSN:\n"));
        if (!pFrm->RSN.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->RSN.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->RSN.gp_cipher_suite, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->RSN.pwise_cipher_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->RSN.pwise_cipher_suites, 4 * pFrm->RSN.pwise_cipher_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->RSN.akm_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->RSN.akm_suites, 4 * pFrm->RSN.akm_suite_count);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("preauth (1): %d\n"), pFrm->RSN.preauth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("no_pwise (1): %d\n"), pFrm->RSN.no_pwise);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("PTKSA_replay_counter (2): %d\n"), pFrm->RSN.PTKSA_replay_counter);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("GTKSA_replay_counter (2): %d\n"), pFrm->RSN.GTKSA_replay_counter);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved (10): %d\n"), pFrm->RSN.reserved);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->RSN.pmkid_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->RSN.pmkid, 16 * pFrm->RSN.pmkid_count);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("QBSSLoad:\n"));
        if (!pFrm->QBSSLoad.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->QBSSLoad.stacount, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->QBSSLoad.chautil, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->QBSSLoad.avail, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("EDCAParamSet:\n"));
        if (!pFrm->EDCAParamSet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->EDCAParamSet.qos, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->EDCAParamSet.reserved, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_aifsn (4): %d\n"), pFrm->EDCAParamSet.acbe_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_acm (1): %d\n"), pFrm->EDCAParamSet.acbe_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_aci (2): %d\n"), pFrm->EDCAParamSet.acbe_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused1 (1): %d\n"), pFrm->EDCAParamSet.unused1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_acwmin (4): %d\n"), pFrm->EDCAParamSet.acbe_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_acwmax (4): %d\n"), pFrm->EDCAParamSet.acbe_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->EDCAParamSet.acbe_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_aifsn (4): %d\n"), pFrm->EDCAParamSet.acbk_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_acm (1): %d\n"), pFrm->EDCAParamSet.acbk_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_aci (2): %d\n"), pFrm->EDCAParamSet.acbk_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused2 (1): %d\n"), pFrm->EDCAParamSet.unused2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_acwmin (4): %d\n"), pFrm->EDCAParamSet.acbk_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_acwmax (4): %d\n"), pFrm->EDCAParamSet.acbk_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->EDCAParamSet.acbk_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_aifsn (4): %d\n"), pFrm->EDCAParamSet.acvi_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_acm (1): %d\n"), pFrm->EDCAParamSet.acvi_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_aci (2): %d\n"), pFrm->EDCAParamSet.acvi_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused3 (1): %d\n"), pFrm->EDCAParamSet.unused3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_acwmin (4): %d\n"), pFrm->EDCAParamSet.acvi_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_acwmax (4): %d\n"), pFrm->EDCAParamSet.acvi_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->EDCAParamSet.acvi_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_aifsn (4): %d\n"), pFrm->EDCAParamSet.acvo_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_acm (1): %d\n"), pFrm->EDCAParamSet.acvo_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_aci (2): %d\n"), pFrm->EDCAParamSet.acvo_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused4 (1): %d\n"), pFrm->EDCAParamSet.unused4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_acwmin (4): %d\n"), pFrm->EDCAParamSet.acvo_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_acwmax (4): %d\n"), pFrm->EDCAParamSet.acvo_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->EDCAParamSet.acvo_txoplimit, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("QOSCapsAp:\n"));
        if (!pFrm->QOSCapsAp.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved (1): %d\n"), pFrm->QOSCapsAp.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("txopreq (1): %d\n"), pFrm->QOSCapsAp.txopreq);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("qreq (1): %d\n"), pFrm->QOSCapsAp.qreq);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("qack (1): %d\n"), pFrm->QOSCapsAp.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("count (4): %d\n"), pFrm->QOSCapsAp.count);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("APChannelReport:\n"));
        if (!pFrm->APChannelReport.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->APChannelReport.regulatoryClass, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_channelList: %d.\n"), pFrm->APChannelReport.num_channelList);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->APChannelReport.channelList, pFrm->APChannelReport.num_channelList);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("RRMEnabledCap:\n"));
        if (!pFrm->RRMEnabledCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("LinkMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LinkMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("NeighborRpt (1): %d\n"), pFrm->RRMEnabledCap.NeighborRpt);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("parallel (1): %d\n"), pFrm->RRMEnabledCap.parallel);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("repeated (1): %d\n"), pFrm->RRMEnabledCap.repeated);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("BeaconPassive (1): %d\n"), pFrm->RRMEnabledCap.BeaconPassive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("BeaconActive (1): %d\n"), pFrm->RRMEnabledCap.BeaconActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("BeaconTable (1): %d\n"), pFrm->RRMEnabledCap.BeaconTable);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("BeaconRepCond (1): %d\n"), pFrm->RRMEnabledCap.BeaconRepCond);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("FrameMeasurement (1): %d\n"), pFrm->RRMEnabledCap.FrameMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("ChannelLoad (1): %d\n"), pFrm->RRMEnabledCap.ChannelLoad);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("NoiseHistogram (1): %d\n"), pFrm->RRMEnabledCap.NoiseHistogram);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("statistics (1): %d\n"), pFrm->RRMEnabledCap.statistics);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("LCIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LCIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("LCIAzimuth (1): %d\n"), pFrm->RRMEnabledCap.LCIAzimuth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("TCMCapability (1): %d\n"), pFrm->RRMEnabledCap.TCMCapability);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("triggeredTCM (1): %d\n"), pFrm->RRMEnabledCap.triggeredTCM);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("APChanReport (1): %d\n"), pFrm->RRMEnabledCap.APChanReport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("RRMMIBEnabled (1): %d\n"), pFrm->RRMEnabledCap.RRMMIBEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("operatingChanMax (3): %d\n"), pFrm->RRMEnabledCap.operatingChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("nonOperatinChanMax (3): %d\n"), pFrm->RRMEnabledCap.nonOperatinChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("MeasurementPilot (3): %d\n"), pFrm->RRMEnabledCap.MeasurementPilot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("MeasurementPilotEnabled (1): %d\n"), pFrm->RRMEnabledCap.MeasurementPilotEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("NeighborTSFOffset (1): %d\n"), pFrm->RRMEnabledCap.NeighborTSFOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("RCPIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RCPIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("RSNIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RSNIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("BssAvgAccessDelay (1): %d\n"), pFrm->RRMEnabledCap.BssAvgAccessDelay);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("BSSAvailAdmission (1): %d\n"), pFrm->RRMEnabledCap.BSSAvailAdmission);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("AntennaInformation (1): %d\n"), pFrm->RRMEnabledCap.AntennaInformation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved (6): %d\n"), pFrm->RRMEnabledCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("MobilityDomain:\n"));
        if (!pFrm->MobilityDomain.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->MobilityDomain.MDID, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("overDSCap (1): %d\n"), pFrm->MobilityDomain.overDSCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("resourceReqCap (1): %d\n"), pFrm->MobilityDomain.resourceReqCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved (6): %d\n"), pFrm->MobilityDomain.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("WPA:\n"));
        if (!pFrm->WPA.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WPA.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WPA.multicast_cipher, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WPA.unicast_cipher_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->WPA.unicast_ciphers, 4 * pFrm->WPA.unicast_cipher_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WPA.auth_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->WPA.auth_suites, 4 * pFrm->WPA.auth_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WPA.caps, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("HTCaps:\n"));
        if (!pFrm->HTCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("advCodingCap (1): %d\n"), pFrm->HTCaps.advCodingCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("supportedChannelWidthSet (1): %d\n"), pFrm->HTCaps.supportedChannelWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("mimoPowerSave (2): %d\n"), pFrm->HTCaps.mimoPowerSave);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("greenField (1): %d\n"), pFrm->HTCaps.greenField);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("shortGI20MHz (1): %d\n"), pFrm->HTCaps.shortGI20MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("shortGI40MHz (1): %d\n"), pFrm->HTCaps.shortGI40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("txSTBC (1): %d\n"), pFrm->HTCaps.txSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("rxSTBC (2): %d\n"), pFrm->HTCaps.rxSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("delayedBA (1): %d\n"), pFrm->HTCaps.delayedBA);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("maximalAMSDUsize (1): %d\n"), pFrm->HTCaps.maximalAMSDUsize);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("dsssCckMode40MHz (1): %d\n"), pFrm->HTCaps.dsssCckMode40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("psmp (1): %d\n"), pFrm->HTCaps.psmp);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("stbcControlFrame (1): %d\n"), pFrm->HTCaps.stbcControlFrame);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("lsigTXOPProtection (1): %d\n"), pFrm->HTCaps.lsigTXOPProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("maxRxAMPDUFactor (2): %d\n"), pFrm->HTCaps.maxRxAMPDUFactor);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("mpduDensity (3): %d\n"), pFrm->HTCaps.mpduDensity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved1 (3): %d\n"), pFrm->HTCaps.reserved1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->HTCaps.supportedMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("pco (1): %d\n"), pFrm->HTCaps.pco);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("transitionTime (2): %d\n"), pFrm->HTCaps.transitionTime);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved2 (5): %d\n"), pFrm->HTCaps.reserved2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("mcsFeedback (2): %d\n"), pFrm->HTCaps.mcsFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved3 (6): %d\n"), pFrm->HTCaps.reserved3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("txBF (1): %d\n"), pFrm->HTCaps.txBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("rxStaggeredSounding (1): %d\n"), pFrm->HTCaps.rxStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("txStaggeredSounding (1): %d\n"), pFrm->HTCaps.txStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("rxZLF (1): %d\n"), pFrm->HTCaps.rxZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("txZLF (1): %d\n"), pFrm->HTCaps.txZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("implicitTxBF (1): %d\n"), pFrm->HTCaps.implicitTxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("calibration (2): %d\n"), pFrm->HTCaps.calibration);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("explicitCSITxBF (1): %d\n"), pFrm->HTCaps.explicitCSITxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("explicitUncompressedSteeringMatrix (1): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrix);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("explicitBFCSIFeedback (3): %d\n"), pFrm->HTCaps.explicitBFCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("explicitUncompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("explicitCompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitCompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("csiNumBFAntennae (2): %d\n"), pFrm->HTCaps.csiNumBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("uncompressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.uncompressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("compressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.compressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved4 (7): %d\n"), pFrm->HTCaps.reserved4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("antennaSelection (1): %d\n"), pFrm->HTCaps.antennaSelection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("explicitCSIFeedbackTx (1): %d\n"), pFrm->HTCaps.explicitCSIFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("antennaIndicesFeedbackTx (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("explicitCSIFeedback (1): %d\n"), pFrm->HTCaps.explicitCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("antennaIndicesFeedback (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("rxAS (1): %d\n"), pFrm->HTCaps.rxAS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("txSoundingPPDUs (1): %d\n"), pFrm->HTCaps.txSoundingPPDUs);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved5 (1): %d\n"), pFrm->HTCaps.reserved5);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_rsvd: %d.\n"), pFrm->HTCaps.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->HTCaps.rsvd, pFrm->HTCaps.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("HTInfo:\n"));
        if (!pFrm->HTInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->HTInfo.primaryChannel, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("secondaryChannelOffset (2): %d\n"), pFrm->HTInfo.secondaryChannelOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("recommendedTxWidthSet (1): %d\n"), pFrm->HTInfo.recommendedTxWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("rifsMode (1): %d\n"), pFrm->HTInfo.rifsMode);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("controlledAccessOnly (1): %d\n"), pFrm->HTInfo.controlledAccessOnly);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("serviceIntervalGranularity (3): %d\n"), pFrm->HTInfo.serviceIntervalGranularity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("opMode (2): %d\n"), pFrm->HTInfo.opMode);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("nonGFDevicesPresent (1): %d\n"), pFrm->HTInfo.nonGFDevicesPresent);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("transmitBurstLimit (1): %d\n"), pFrm->HTInfo.transmitBurstLimit);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("obssNonHTStaPresent (1): %d\n"), pFrm->HTInfo.obssNonHTStaPresent);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved (11): %d\n"), pFrm->HTInfo.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("basicSTBCMCS (7): %d\n"), pFrm->HTInfo.basicSTBCMCS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("dualCTSProtection (1): %d\n"), pFrm->HTInfo.dualCTSProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("secondaryBeacon (1): %d\n"), pFrm->HTInfo.secondaryBeacon);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("lsigTXOPProtectionFullSupport (1): %d\n"), pFrm->HTInfo.lsigTXOPProtectionFullSupport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("pcoActive (1): %d\n"), pFrm->HTInfo.pcoActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("pcoPhase (1): %d\n"), pFrm->HTInfo.pcoPhase);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved2 (4): %d\n"), pFrm->HTInfo.reserved2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->HTInfo.basicMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_rsvd: %d.\n"), pFrm->HTInfo.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->HTInfo.rsvd, pFrm->HTInfo.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("ExtChanSwitchAnn:\n"));
        if (!pFrm->ExtChanSwitchAnn.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->ExtChanSwitchAnn.secondaryChannelOffset, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("WMMInfoAp:\n"));
        if (!pFrm->WMMInfoAp.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WMMInfoAp.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("param_set_count (4): %d\n"), pFrm->WMMInfoAp.param_set_count);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved (3): %d\n"), pFrm->WMMInfoAp.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("uapsd (1): %d\n"), pFrm->WMMInfoAp.uapsd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("WMMParams:\n"));
        if (!pFrm->WMMParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WMMParams.version, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WMMParams.qosInfo, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WMMParams.reserved2, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_aifsn (4): %d\n"), pFrm->WMMParams.acbe_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_acm (1): %d\n"), pFrm->WMMParams.acbe_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_aci (2): %d\n"), pFrm->WMMParams.acbe_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused1 (1): %d\n"), pFrm->WMMParams.unused1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_acwmin (4): %d\n"), pFrm->WMMParams.acbe_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_acwmax (4): %d\n"), pFrm->WMMParams.acbe_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WMMParams.acbe_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_aifsn (4): %d\n"), pFrm->WMMParams.acbk_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_acm (1): %d\n"), pFrm->WMMParams.acbk_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_aci (2): %d\n"), pFrm->WMMParams.acbk_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused2 (1): %d\n"), pFrm->WMMParams.unused2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_acwmin (4): %d\n"), pFrm->WMMParams.acbk_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_acwmax (4): %d\n"), pFrm->WMMParams.acbk_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WMMParams.acbk_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_aifsn (4): %d\n"), pFrm->WMMParams.acvi_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_acm (1): %d\n"), pFrm->WMMParams.acvi_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_aci (2): %d\n"), pFrm->WMMParams.acvi_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused3 (1): %d\n"), pFrm->WMMParams.unused3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_acwmin (4): %d\n"), pFrm->WMMParams.acvi_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_acwmax (4): %d\n"), pFrm->WMMParams.acvi_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WMMParams.acvi_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_aifsn (4): %d\n"), pFrm->WMMParams.acvo_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_acm (1): %d\n"), pFrm->WMMParams.acvo_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_aci (2): %d\n"), pFrm->WMMParams.acvo_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused4 (1): %d\n"), pFrm->WMMParams.unused4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_acwmin (4): %d\n"), pFrm->WMMParams.acvo_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_acwmax (4): %d\n"), pFrm->WMMParams.acvo_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WMMParams.acvo_txoplimit, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("WMMCaps:\n"));
        if (!pFrm->WMMCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WMMCaps.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved (4): %d\n"), pFrm->WMMCaps.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("qack (1): %d\n"), pFrm->WMMCaps.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("queue_request (1): %d\n"), pFrm->WMMCaps.queue_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("txop_request (1): %d\n"), pFrm->WMMCaps.txop_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("more_ack (1): %d\n"), pFrm->WMMCaps.more_ack);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("WAPI:\n"));
        if (!pFrm->WAPI.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WAPI.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WAPI.akm_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->WAPI.akm_suites, 4 * pFrm->WAPI.akm_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WAPI.unicast_cipher_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->WAPI.unicast_cipher_suites, 4 * pFrm->WAPI.unicast_cipher_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WAPI.multicast_cipher_suite, 4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("preauth (1): %d\n"), pFrm->WAPI.preauth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved (15): %d\n"), pFrm->WAPI.reserved);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WAPI.bkid_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->WAPI.bkid, 16 * pFrm->WAPI.bkid_count);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("CCXVersion:\n"));
        if (!pFrm->CCXVersion.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CCXVersion.version, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("CCXRadMgmtCap:\n"));
        if (!pFrm->CCXRadMgmtCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CCXRadMgmtCap.mgmt_state, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("mbssid_mask (3): %d\n"), pFrm->CCXRadMgmtCap.mbssid_mask);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("reserved (5): %d\n"), pFrm->CCXRadMgmtCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("CCXTrafStrmMet:\n"));
        if (!pFrm->CCXTrafStrmMet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CCXTrafStrmMet.tsid, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CCXTrafStrmMet.state, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CCXTrafStrmMet.msmt_interval, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("CCXTxmitPower:\n"));
        if (!pFrm->CCXTxmitPower.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CCXTxmitPower.power_limit, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->CCXTxmitPower.reserved, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Airgo:\n"));
        if (!pFrm->Airgo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("PropSuppRates:\n"));
            if (!pFrm->Airgo.PropSuppRates.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_rates: %d.\n"), pFrm->Airgo.PropSuppRates.num_rates);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->Airgo.PropSuppRates.rates, pFrm->Airgo.PropSuppRates.num_rates);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("APName:\n"));
            if (!pFrm->Airgo.APName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_name: %d.\n"), pFrm->Airgo.APName.num_name);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->Airgo.APName.name, pFrm->Airgo.APName.num_name);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("HCF:\n"));
            if (!pFrm->Airgo.HCF.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.HCF.enabled, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("WDS:\n"));
            if (!pFrm->Airgo.WDS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_wdsData: %d.\n"), pFrm->Airgo.WDS.num_wdsData);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->Airgo.WDS.wdsData, pFrm->Airgo.WDS.num_wdsData);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("BPIndicator:\n"));
            if (!pFrm->Airgo.BPIndicator.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.BPIndicator.indicator, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.BPIndicator.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("LoadInfo:\n"));
            if (!pFrm->Airgo.LoadInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.LoadInfo.num_stas, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.LoadInfo.channel_util, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("LoadBalance:\n"));
            if (!pFrm->Airgo.LoadBalance.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.LoadBalance.bssid, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.LoadBalance.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("PropAssocType:\n"));
            if (!pFrm->Airgo.PropAssocType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropAssocType.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("LLAttr:\n"));
            if (!pFrm->Airgo.LLAttr.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.LLAttr.defer_threshold, 4);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("PropCapability:\n"));
            if (!pFrm->Airgo.PropCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropCapability.capability, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Version:\n"));
            if (!pFrm->Airgo.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.Version.chip_rev, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.Version.card_type, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_build_version: %d.\n"), pFrm->Airgo.Version.num_build_version);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->Airgo.Version.build_version, pFrm->Airgo.Version.num_build_version);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("PropEDCAParams:\n"));
            if (!pFrm->Airgo.PropEDCAParams.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.qos, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.reserved, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused1 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbe_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbe_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused2 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acbk_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbk_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused3 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvi_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvi_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("unused4 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused4);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("acvo_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvo_txoplimit, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Titan:\n"));
            if (!pFrm->Airgo.Titan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.Titan.concat_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.Titan.compression_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.Titan.cb_state, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.Titan.rev_fcs_state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("PropChannSwitchAnn:\n"));
            if (!pFrm->Airgo.PropChannSwitchAnn.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.mode, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.primary_channel, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.sub_band, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.channel_switch_count, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("PropQuietBSS:\n"));
            if (!pFrm->Airgo.PropQuietBSS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_count, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_period, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_duration, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_offset, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("TriggerStaBgScan:\n"));
            if (!pFrm->Airgo.TriggerStaBgScan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.TriggerStaBgScan.enable, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Taurus:\n"));
            if (!pFrm->Airgo.Taurus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.Taurus.baTIDBitmap, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->Airgo.Taurus.baPolicy, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("baBufferSize (12): %d\n"), pFrm->Airgo.Taurus.baBufferSize);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("rsvd (4): %d\n"), pFrm->Airgo.Taurus.rsvd);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("WscBeaconProbeRes:\n"));
        if (!pFrm->WscBeaconProbeRes.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Version:\n"));
            if (!pFrm->WscBeaconProbeRes.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("minor (4): %d\n"), pFrm->WscBeaconProbeRes.Version.minor);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("major (4): %d\n"), pFrm->WscBeaconProbeRes.Version.major);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("WPSState:\n"));
            if (!pFrm->WscBeaconProbeRes.WPSState.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.WPSState.state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("APSetupLocked:\n"));
            if (!pFrm->WscBeaconProbeRes.APSetupLocked.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.APSetupLocked.fLocked, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("SelectedRegistrar:\n"));
            if (!pFrm->WscBeaconProbeRes.SelectedRegistrar.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.SelectedRegistrar.selected, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("DevicePasswordID:\n"));
            if (!pFrm->WscBeaconProbeRes.DevicePasswordID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.DevicePasswordID.id, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("SelectedRegistrarConfigMethods:\n"));
            if (!pFrm->WscBeaconProbeRes.SelectedRegistrarConfigMethods.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.SelectedRegistrarConfigMethods.methods, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("ResponseType:\n"));
            if (!pFrm->WscBeaconProbeRes.ResponseType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.ResponseType.resType, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("UUID_E:\n"));
            if (!pFrm->WscBeaconProbeRes.UUID_E.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.UUID_E.uuid, 16);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Manufacturer:\n"));
            if (!pFrm->WscBeaconProbeRes.Manufacturer.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_name: %d.\n"), pFrm->WscBeaconProbeRes.Manufacturer.num_name);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->WscBeaconProbeRes.Manufacturer.name, pFrm->WscBeaconProbeRes.Manufacturer.num_name);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("ModelName:\n"));
            if (!pFrm->WscBeaconProbeRes.ModelName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_text: %d.\n"), pFrm->WscBeaconProbeRes.ModelName.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->WscBeaconProbeRes.ModelName.text, pFrm->WscBeaconProbeRes.ModelName.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("ModelNumber:\n"));
            if (!pFrm->WscBeaconProbeRes.ModelNumber.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_text: %d.\n"), pFrm->WscBeaconProbeRes.ModelNumber.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->WscBeaconProbeRes.ModelNumber.text, pFrm->WscBeaconProbeRes.ModelNumber.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("SerialNumber:\n"));
            if (!pFrm->WscBeaconProbeRes.SerialNumber.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_text: %d.\n"), pFrm->WscBeaconProbeRes.SerialNumber.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->WscBeaconProbeRes.SerialNumber.text, pFrm->WscBeaconProbeRes.SerialNumber.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("PrimaryDeviceType:\n"));
            if (!pFrm->WscBeaconProbeRes.PrimaryDeviceType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.PrimaryDeviceType.primary_category, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.PrimaryDeviceType.oui, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.PrimaryDeviceType.sub_category, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("DeviceName:\n"));
            if (!pFrm->WscBeaconProbeRes.DeviceName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_text: %d.\n"), pFrm->WscBeaconProbeRes.DeviceName.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->WscBeaconProbeRes.DeviceName.text, pFrm->WscBeaconProbeRes.DeviceName.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("ConfigMethods:\n"));
            if (!pFrm->WscBeaconProbeRes.ConfigMethods.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.ConfigMethods.methods, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("RFBands:\n"));
            if (!pFrm->WscBeaconProbeRes.RFBands.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.RFBands.bands, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("VendorExtension:\n"));
            if (!pFrm->WscBeaconProbeRes.VendorExtension.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.VendorExtension.vendorId, 3);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Version2:\n"));
                if (!pFrm->WscBeaconProbeRes.VendorExtension.Version2.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("minor (4): %d\n"), pFrm->WscBeaconProbeRes.VendorExtension.Version2.minor);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("major (4): %d\n"), pFrm->WscBeaconProbeRes.VendorExtension.Version2.major);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("AuthorizedMACs:\n"));
                if (!pFrm->WscBeaconProbeRes.VendorExtension.AuthorizedMACs.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.VendorExtension.AuthorizedMACs.mac, 6);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("RequestToEnroll:\n"));
                if (!pFrm->WscBeaconProbeRes.VendorExtension.RequestToEnroll.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->WscBeaconProbeRes.VendorExtension.RequestToEnroll.req, 1);
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("P2PBeaconProbeRes:\n"));
        if (!pFrm->P2PBeaconProbeRes.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("P2PCapability:\n"));
            if (!pFrm->P2PBeaconProbeRes.P2PCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->P2PBeaconProbeRes.P2PCapability.deviceCapability, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->P2PBeaconProbeRes.P2PCapability.groupCapability, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("P2PDeviceId:\n"));
            if (!pFrm->P2PBeaconProbeRes.P2PDeviceId.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->P2PBeaconProbeRes.P2PDeviceId.P2PDeviceAddress, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("ExtendedListenTiming:\n"));
            if (!pFrm->P2PBeaconProbeRes.ExtendedListenTiming.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->P2PBeaconProbeRes.ExtendedListenTiming.availibilityPeriod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->P2PBeaconProbeRes.ExtendedListenTiming.availibilityInterval, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("NoticeOfAbsence:\n"));
            if (!pFrm->P2PBeaconProbeRes.NoticeOfAbsence.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->P2PBeaconProbeRes.NoticeOfAbsence.index, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->P2PBeaconProbeRes.NoticeOfAbsence.CTSWindowOppPS, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_NoADesc: %d.\n"), pFrm->P2PBeaconProbeRes.NoticeOfAbsence.num_NoADesc);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->P2PBeaconProbeRes.NoticeOfAbsence.NoADesc, pFrm->P2PBeaconProbeRes.NoticeOfAbsence.num_NoADesc);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("P2PDeviceInfo:\n"));
            if (!pFrm->P2PBeaconProbeRes.P2PDeviceInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->P2PBeaconProbeRes.P2PDeviceInfo.P2PDeviceAddress, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->P2PBeaconProbeRes.P2PDeviceInfo.configMethod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* )&pFrm->P2PBeaconProbeRes.P2PDeviceInfo.primaryDeviceType, 8);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("DeviceName:\n"));
                if (!pFrm->P2PBeaconProbeRes.P2PDeviceInfo.DeviceName.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_text: %d.\n"), pFrm->P2PBeaconProbeRes.P2PDeviceInfo.DeviceName.num_text);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->P2PBeaconProbeRes.P2PDeviceInfo.DeviceName.text, pFrm->P2PBeaconProbeRes.P2PDeviceInfo.DeviceName.num_text);
                }
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("P2PGroupInfo:\n"));
            if (!pFrm->P2PBeaconProbeRes.P2PGroupInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), FRFL("num_P2PClientInfoDesc: %d.\n"), pFrm->P2PBeaconProbeRes.P2PGroupInfo.num_P2PClientInfoDesc);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_BEACONIES), ( tANI_U8* ) pFrm->P2PBeaconProbeRes.P2PGroupInfo.P2PClientInfoDesc, pFrm->P2PBeaconProbeRes.P2PGroupInfo.num_P2PClientInfoDesc);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackBeaconIEs. */

    static const tFFDefn FFS_ChannelSwitch[] = {
        { "Category", offsetof(tDot11fChannelSwitch, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fChannelSwitch, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_ChannelSwitch[] = {
        {offsetof(tDot11fChannelSwitch, ChanSwitchAnn), offsetof(tDot11fIEChanSwitchAnn, present), 0, "ChanSwitchAnn" , 0, 5, 5, SigIeChanSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_CHANSWITCHANN, 1, },
        {offsetof(tDot11fChannelSwitch, ExtChanSwitchAnn), offsetof(tDot11fIEExtChanSwitchAnn, present), 0, "ExtChanSwitchAnn" , 0, 3, 3, SigIeExtChanSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTCHANSWITCHANN, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackChannelSwitch(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fChannelSwitch *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_ChannelSwitch, IES_ChannelSwitch, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), FRFL("Unpacked the ChannelSwitch:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), FRFL("ChanSwitchAnn:\n"));
        if (!pFrm->ChanSwitchAnn.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), ( tANI_U8* )&pFrm->ChanSwitchAnn.switchMode, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), ( tANI_U8* )&pFrm->ChanSwitchAnn.newChannel, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), ( tANI_U8* )&pFrm->ChanSwitchAnn.switchCount, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), FRFL("ExtChanSwitchAnn:\n"));
        if (!pFrm->ExtChanSwitchAnn.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_CHANNELSWITCH), ( tANI_U8* )&pFrm->ExtChanSwitchAnn.secondaryChannelOffset, 1);
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackChannelSwitch. */

    static const tFFDefn FFS_DeAuth[] = {
        { "Reason", offsetof(tDot11fDeAuth, Reason), SigFfReason , DOT11F_FF_REASON_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_DeAuth[] = {
        {offsetof(tDot11fDeAuth, P2PDeAuth), offsetof(tDot11fIEP2PDeAuth, present), 0, "P2PDeAuth" , 0, 6, 10, SigIeP2PDeAuth, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PDEAUTH, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackDeAuth(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fDeAuth *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_DeAuth, IES_DeAuth, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEAUTH), FRFL("Unpacked the DeAuth:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEAUTH), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEAUTH), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEAUTH), FRFL("Reason:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEAUTH), ( tANI_U8* )&pFrm->Reason.code, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEAUTH), FRFL("P2PDeAuth:\n"));
        if (!pFrm->P2PDeAuth.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEAUTH), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEAUTH), FRFL("MinorReasonCode:\n"));
            if (!pFrm->P2PDeAuth.MinorReasonCode.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEAUTH), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEAUTH), ( tANI_U8* )&pFrm->P2PDeAuth.MinorReasonCode.minorReasonCode, 1);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackDeAuth. */

    static const tFFDefn FFS_DelBAInd[] = {
        { "Category", offsetof(tDot11fDelBAInd, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fDelBAInd, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DelBAParameterSet", offsetof(tDot11fDelBAInd, DelBAParameterSet), SigFfDelBAParameterSet , DOT11F_FF_DELBAPARAMETERSET_LEN, },
        { "Reason", offsetof(tDot11fDelBAInd, Reason), SigFfReason , DOT11F_FF_REASON_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_DelBAInd[] = {
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackDelBAInd(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fDelBAInd *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_DelBAInd, IES_DelBAInd, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), FRFL("Unpacked the DelBAInd:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), FRFL("DelBAParameterSet:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), FRFL("reserved (11): %d\n"), pFrm->DelBAParameterSet.reserved);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), FRFL("initiator (1): %d\n"), pFrm->DelBAParameterSet.initiator);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), FRFL("tid (4): %d\n"), pFrm->DelBAParameterSet.tid);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), FRFL("Reason:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELBAIND), ( tANI_U8* )&pFrm->Reason.code, 2);
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackDelBAInd. */

    static const tFFDefn FFS_DelTS[] = {
        { "Category", offsetof(tDot11fDelTS, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fDelTS, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "TSInfo", offsetof(tDot11fDelTS, TSInfo), SigFfTSInfo , DOT11F_FF_TSINFO_LEN, },
        { "Reason", offsetof(tDot11fDelTS, Reason), SigFfReason , DOT11F_FF_REASON_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_DelTS[] = {
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackDelTS(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fDelTS *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_DelTS, IES_DelTS, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("Unpacked the DelTS:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("TSInfo:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("traffic_type (1): %d\n"), pFrm->TSInfo.traffic_type);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("tsid (4): %d\n"), pFrm->TSInfo.tsid);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("direction (2): %d\n"), pFrm->TSInfo.direction);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("access_policy (2): %d\n"), pFrm->TSInfo.access_policy);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("aggregation (1): %d\n"), pFrm->TSInfo.aggregation);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("psb (1): %d\n"), pFrm->TSInfo.psb);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("user_priority (3): %d\n"), pFrm->TSInfo.user_priority);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->TSInfo.tsinfo_ack_pol);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("schedule (1): %d\n"), pFrm->TSInfo.schedule);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("unused (15): %d\n"), pFrm->TSInfo.unused);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), FRFL("Reason:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DELTS), ( tANI_U8* )&pFrm->Reason.code, 2);
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackDelTS. */

    static const tFFDefn FFS_DeviceDiscoverabilityReq[] = {
        { "Category", offsetof(tDot11fDeviceDiscoverabilityReq, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fDeviceDiscoverabilityReq, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "P2POUI", offsetof(tDot11fDeviceDiscoverabilityReq, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fDeviceDiscoverabilityReq, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fDeviceDiscoverabilityReq, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_DeviceDiscoverabilityReq[] = {
        {offsetof(tDot11fDeviceDiscoverabilityReq, P2PDeviceDiscoverabilityReq), offsetof(tDot11fIEP2PDeviceDiscoverabilityReq, present), 0, "P2PDeviceDiscoverabilityReq" , 0, 6, 56, SigIeP2PDeviceDiscoverabilityReq, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PDEVICEDISCOVERABILITYREQ, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackDeviceDiscoverabilityReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fDeviceDiscoverabilityReq *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_DeviceDiscoverabilityReq, IES_DeviceDiscoverabilityReq, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("Unpacked the DeviceDiscoverabilityReq:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("P2PDeviceDiscoverabilityReq:\n"));
        if (!pFrm->P2PDeviceDiscoverabilityReq.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("P2PDeviceId:\n"));
            if (!pFrm->P2PDeviceDiscoverabilityReq.P2PDeviceId.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), ( tANI_U8* )&pFrm->P2PDeviceDiscoverabilityReq.P2PDeviceId.P2PDeviceAddress, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("P2PGroupId:\n"));
            if (!pFrm->P2PDeviceDiscoverabilityReq.P2PGroupId.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), ( tANI_U8* )&pFrm->P2PDeviceDiscoverabilityReq.P2PGroupId.deviceAddress, 6);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), FRFL("num_ssid: %d.\n"), pFrm->P2PDeviceDiscoverabilityReq.P2PGroupId.num_ssid);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYREQ), ( tANI_U8* ) pFrm->P2PDeviceDiscoverabilityReq.P2PGroupId.ssid, pFrm->P2PDeviceDiscoverabilityReq.P2PGroupId.num_ssid);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackDeviceDiscoverabilityReq. */

    static const tFFDefn FFS_DeviceDiscoverabilityRes[] = {
        { "Category", offsetof(tDot11fDeviceDiscoverabilityRes, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fDeviceDiscoverabilityRes, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "P2POUI", offsetof(tDot11fDeviceDiscoverabilityRes, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fDeviceDiscoverabilityRes, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fDeviceDiscoverabilityRes, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_DeviceDiscoverabilityRes[] = {
        {offsetof(tDot11fDeviceDiscoverabilityRes, P2PDeviceDiscoverabilityRes), offsetof(tDot11fIEP2PDeviceDiscoverabilityRes, present), 0, "P2PDeviceDiscoverabilityRes" , 0, 6, 10, SigIeP2PDeviceDiscoverabilityRes, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PDEVICEDISCOVERABILITYRES, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackDeviceDiscoverabilityRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fDeviceDiscoverabilityRes *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_DeviceDiscoverabilityRes, IES_DeviceDiscoverabilityRes, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("Unpacked the DeviceDiscoverabilityRes:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("P2PDeviceDiscoverabilityRes:\n"));
        if (!pFrm->P2PDeviceDiscoverabilityRes.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("P2PStatus:\n"));
            if (!pFrm->P2PDeviceDiscoverabilityRes.P2PStatus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DEVICEDISCOVERABILITYRES), ( tANI_U8* )&pFrm->P2PDeviceDiscoverabilityRes.P2PStatus.status, 1);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackDeviceDiscoverabilityRes. */

    static const tFFDefn FFS_Disassociation[] = {
        { "Reason", offsetof(tDot11fDisassociation, Reason), SigFfReason , DOT11F_FF_REASON_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_Disassociation[] = {
        {offsetof(tDot11fDisassociation, P2PDisAssoc), offsetof(tDot11fIEP2PDisAssoc, present), 0, "P2PDisAssoc" , 0, 6, 10, SigIeP2PDisAssoc, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PDISASSOC, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackDisassociation(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fDisassociation *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_Disassociation, IES_Disassociation, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DISASSOCIATION), FRFL("Unpacked the Disassociation:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DISASSOCIATION), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DISASSOCIATION), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DISASSOCIATION), FRFL("Reason:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DISASSOCIATION), ( tANI_U8* )&pFrm->Reason.code, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DISASSOCIATION), FRFL("P2PDisAssoc:\n"));
        if (!pFrm->P2PDisAssoc.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DISASSOCIATION), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DISASSOCIATION), FRFL("MinorReasonCode:\n"));
            if (!pFrm->P2PDisAssoc.MinorReasonCode.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DISASSOCIATION), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_DISASSOCIATION), ( tANI_U8* )&pFrm->P2PDisAssoc.MinorReasonCode.minorReasonCode, 1);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackDisassociation. */

    static const tFFDefn FFS_GODiscoverabilityReq[] = {
        { "Category", offsetof(tDot11fGODiscoverabilityReq, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "P2POUI", offsetof(tDot11fGODiscoverabilityReq, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fGODiscoverabilityReq, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fGODiscoverabilityReq, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_GODiscoverabilityReq[] = {
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackGODiscoverabilityReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fGODiscoverabilityReq *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_GODiscoverabilityReq, IES_GODiscoverabilityReq, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), FRFL("Unpacked the GODiscoverabilityReq:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GODISCOVERABILITYREQ), ( tANI_U8* )&pFrm->DialogToken.token, 1);
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackGODiscoverabilityReq. */

    static const tFFDefn FFS_GONegCnf[] = {
        { "Category", offsetof(tDot11fGONegCnf, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fGONegCnf, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "P2POUI", offsetof(tDot11fGONegCnf, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fGONegCnf, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fGONegCnf, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_GONegCnf[] = {
        {offsetof(tDot11fGONegCnf, P2PGONegCnf), offsetof(tDot11fIEP2PGONegCnf, present), 0, "P2PGONegCnf" , 0, 6, 321, SigIeP2PGONegCnf, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PGONEGCNF, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackGONegCnf(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fGONegCnf *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_GONegCnf, IES_GONegCnf, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("Unpacked the GONegCnf:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("P2PGONegCnf:\n"));
        if (!pFrm->P2PGONegCnf.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("P2PStatus:\n"));
            if (!pFrm->P2PGONegCnf.P2PStatus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->P2PGONegCnf.P2PStatus.status, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("P2PCapability:\n"));
            if (!pFrm->P2PGONegCnf.P2PCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->P2PGONegCnf.P2PCapability.deviceCapability, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->P2PGONegCnf.P2PCapability.groupCapability, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("OperatingChannel:\n"));
            if (!pFrm->P2PGONegCnf.OperatingChannel.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->P2PGONegCnf.OperatingChannel.countryString, 3);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->P2PGONegCnf.OperatingChannel.regulatoryClass, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->P2PGONegCnf.OperatingChannel.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("ChannelList:\n"));
            if (!pFrm->P2PGONegCnf.ChannelList.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->P2PGONegCnf.ChannelList.countryString, 3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("num_channelList: %d.\n"), pFrm->P2PGONegCnf.ChannelList.num_channelList);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* ) pFrm->P2PGONegCnf.ChannelList.channelList, pFrm->P2PGONegCnf.ChannelList.num_channelList);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("P2PGroupId:\n"));
            if (!pFrm->P2PGONegCnf.P2PGroupId.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* )&pFrm->P2PGONegCnf.P2PGroupId.deviceAddress, 6);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), FRFL("num_ssid: %d.\n"), pFrm->P2PGONegCnf.P2PGroupId.num_ssid);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGCNF), ( tANI_U8* ) pFrm->P2PGONegCnf.P2PGroupId.ssid, pFrm->P2PGONegCnf.P2PGroupId.num_ssid);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackGONegCnf. */

    static const tFFDefn FFS_GONegReq[] = {
        { "Category", offsetof(tDot11fGONegReq, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fGONegReq, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "P2POUI", offsetof(tDot11fGONegReq, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fGONegReq, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fGONegReq, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_GONegReq[] = {
        {offsetof(tDot11fGONegReq, P2PGONegWPS), offsetof(tDot11fIEP2PGONegWPS, present), 0, "P2PGONegWPS" , 0, 6, 17, SigIeP2PGONegWPS, {0, 80, 242, 4, 0}, 4, DOT11F_EID_P2PGONEGWPS, 1, },
        {offsetof(tDot11fGONegReq, P2PGONegReq), offsetof(tDot11fIEP2PGONegReq, present), 0, "P2PGONegReq" , 0, 6, 364, SigIeP2PGONegReq, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PGONEGREQ, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackGONegReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fGONegReq *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_GONegReq, IES_GONegReq, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Unpacked the GONegReq:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("P2PGONegWPS:\n"));
        if (!pFrm->P2PGONegWPS.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Version:\n"));
            if (!pFrm->P2PGONegWPS.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("minor (4): %d\n"), pFrm->P2PGONegWPS.Version.minor);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("major (4): %d\n"), pFrm->P2PGONegWPS.Version.major);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("DevicePasswordID:\n"));
            if (!pFrm->P2PGONegWPS.DevicePasswordID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegWPS.DevicePasswordID.id, 2);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("P2PGONegReq:\n"));
        if (!pFrm->P2PGONegReq.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("P2PCapability:\n"));
            if (!pFrm->P2PGONegReq.P2PCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.P2PCapability.deviceCapability, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.P2PCapability.groupCapability, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("GOIntent:\n"));
            if (!pFrm->P2PGONegReq.GOIntent.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.GOIntent.GOIntent, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("ConfigurationTimeout:\n"));
            if (!pFrm->P2PGONegReq.ConfigurationTimeout.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.ConfigurationTimeout.GOConfigTimeout, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.ConfigurationTimeout.CLConfigTimeout, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("ListenChannel:\n"));
            if (!pFrm->P2PGONegReq.ListenChannel.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.ListenChannel.countryString, 3);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.ListenChannel.regulatoryClass, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.ListenChannel.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("ExtendedListenTiming:\n"));
            if (!pFrm->P2PGONegReq.ExtendedListenTiming.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.ExtendedListenTiming.availibilityPeriod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.ExtendedListenTiming.availibilityInterval, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("IntendedP2PInterfaceAddress:\n"));
            if (!pFrm->P2PGONegReq.IntendedP2PInterfaceAddress.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.IntendedP2PInterfaceAddress.P2PInterfaceAddress, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("ChannelList:\n"));
            if (!pFrm->P2PGONegReq.ChannelList.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.ChannelList.countryString, 3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("num_channelList: %d.\n"), pFrm->P2PGONegReq.ChannelList.num_channelList);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* ) pFrm->P2PGONegReq.ChannelList.channelList, pFrm->P2PGONegReq.ChannelList.num_channelList);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("P2PDeviceInfo:\n"));
            if (!pFrm->P2PGONegReq.P2PDeviceInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.P2PDeviceInfo.P2PDeviceAddress, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.P2PDeviceInfo.configMethod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.P2PDeviceInfo.primaryDeviceType, 8);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("DeviceName:\n"));
                if (!pFrm->P2PGONegReq.P2PDeviceInfo.DeviceName.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("num_text: %d.\n"), pFrm->P2PGONegReq.P2PDeviceInfo.DeviceName.num_text);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* ) pFrm->P2PGONegReq.P2PDeviceInfo.DeviceName.text, pFrm->P2PGONegReq.P2PDeviceInfo.DeviceName.num_text);
                }
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("OperatingChannel:\n"));
            if (!pFrm->P2PGONegReq.OperatingChannel.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.OperatingChannel.countryString, 3);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.OperatingChannel.regulatoryClass, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGREQ), ( tANI_U8* )&pFrm->P2PGONegReq.OperatingChannel.channel, 1);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackGONegReq. */

    static const tFFDefn FFS_GONegRes[] = {
        { "Category", offsetof(tDot11fGONegRes, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fGONegRes, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "P2POUI", offsetof(tDot11fGONegRes, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fGONegRes, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fGONegRes, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_GONegRes[] = {
        {offsetof(tDot11fGONegRes, P2PGONegWPS), offsetof(tDot11fIEP2PGONegWPS, present), 0, "P2PGONegWPS" , 0, 6, 17, SigIeP2PGONegWPS, {0, 80, 242, 4, 0}, 4, DOT11F_EID_P2PGONEGWPS, 1, },
        {offsetof(tDot11fGONegRes, P2PGONegRes), offsetof(tDot11fIEP2PGONegRes, present), 0, "P2PGONegRes" , 0, 6, 394, SigIeP2PGONegRes, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PGONEGRES, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackGONegRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fGONegRes *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_GONegRes, IES_GONegRes, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Unpacked the GONegRes:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("P2PGONegWPS:\n"));
        if (!pFrm->P2PGONegWPS.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Version:\n"));
            if (!pFrm->P2PGONegWPS.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("minor (4): %d\n"), pFrm->P2PGONegWPS.Version.minor);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("major (4): %d\n"), pFrm->P2PGONegWPS.Version.major);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("DevicePasswordID:\n"));
            if (!pFrm->P2PGONegWPS.DevicePasswordID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegWPS.DevicePasswordID.id, 2);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("P2PGONegRes:\n"));
        if (!pFrm->P2PGONegRes.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("P2PStatus:\n"));
            if (!pFrm->P2PGONegRes.P2PStatus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.P2PStatus.status, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("P2PCapability:\n"));
            if (!pFrm->P2PGONegRes.P2PCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.P2PCapability.deviceCapability, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.P2PCapability.groupCapability, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("GOIntent:\n"));
            if (!pFrm->P2PGONegRes.GOIntent.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.GOIntent.GOIntent, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("ConfigurationTimeout:\n"));
            if (!pFrm->P2PGONegRes.ConfigurationTimeout.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.ConfigurationTimeout.GOConfigTimeout, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.ConfigurationTimeout.CLConfigTimeout, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("OperatingChannel:\n"));
            if (!pFrm->P2PGONegRes.OperatingChannel.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.OperatingChannel.countryString, 3);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.OperatingChannel.regulatoryClass, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.OperatingChannel.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("IntendedP2PInterfaceAddress:\n"));
            if (!pFrm->P2PGONegRes.IntendedP2PInterfaceAddress.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.IntendedP2PInterfaceAddress.P2PInterfaceAddress, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("ChannelList:\n"));
            if (!pFrm->P2PGONegRes.ChannelList.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.ChannelList.countryString, 3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("num_channelList: %d.\n"), pFrm->P2PGONegRes.ChannelList.num_channelList);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* ) pFrm->P2PGONegRes.ChannelList.channelList, pFrm->P2PGONegRes.ChannelList.num_channelList);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("P2PDeviceInfo:\n"));
            if (!pFrm->P2PGONegRes.P2PDeviceInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.P2PDeviceInfo.P2PDeviceAddress, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.P2PDeviceInfo.configMethod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.P2PDeviceInfo.primaryDeviceType, 8);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("DeviceName:\n"));
                if (!pFrm->P2PGONegRes.P2PDeviceInfo.DeviceName.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("num_text: %d.\n"), pFrm->P2PGONegRes.P2PDeviceInfo.DeviceName.num_text);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* ) pFrm->P2PGONegRes.P2PDeviceInfo.DeviceName.text, pFrm->P2PGONegRes.P2PDeviceInfo.DeviceName.num_text);
                }
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("P2PGroupId:\n"));
            if (!pFrm->P2PGONegRes.P2PGroupId.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* )&pFrm->P2PGONegRes.P2PGroupId.deviceAddress, 6);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), FRFL("num_ssid: %d.\n"), pFrm->P2PGONegRes.P2PGroupId.num_ssid);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_GONEGRES), ( tANI_U8* ) pFrm->P2PGONegRes.P2PGroupId.ssid, pFrm->P2PGONegRes.P2PGroupId.num_ssid);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackGONegRes. */

    static const tFFDefn FFS_InvitationReq[] = {
        { "Category", offsetof(tDot11fInvitationReq, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fInvitationReq, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "P2POUI", offsetof(tDot11fInvitationReq, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fInvitationReq, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fInvitationReq, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_InvitationReq[] = {
        {offsetof(tDot11fInvitationReq, P2PInvitationReq), offsetof(tDot11fIEP2PInvitationReq, present), 0, "P2PInvitationReq" , 0, 6, 385, SigIeP2PInvitationReq, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PINVITATIONREQ, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackInvitationReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fInvitationReq *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_InvitationReq, IES_InvitationReq, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Unpacked the InvitationReq:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("P2PInvitationReq:\n"));
        if (!pFrm->P2PInvitationReq.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("ConfigurationTimeout:\n"));
            if (!pFrm->P2PInvitationReq.ConfigurationTimeout.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.ConfigurationTimeout.GOConfigTimeout, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.ConfigurationTimeout.CLConfigTimeout, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("InvitationFlags:\n"));
            if (!pFrm->P2PInvitationReq.InvitationFlags.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.InvitationFlags.invitationFlags, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("OperatingChannel:\n"));
            if (!pFrm->P2PInvitationReq.OperatingChannel.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.OperatingChannel.countryString, 3);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.OperatingChannel.regulatoryClass, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.OperatingChannel.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("P2PGroupBssid:\n"));
            if (!pFrm->P2PInvitationReq.P2PGroupBssid.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.P2PGroupBssid.P2PGroupBssid, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("ChannelList:\n"));
            if (!pFrm->P2PInvitationReq.ChannelList.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.ChannelList.countryString, 3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("num_channelList: %d.\n"), pFrm->P2PInvitationReq.ChannelList.num_channelList);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* ) pFrm->P2PInvitationReq.ChannelList.channelList, pFrm->P2PInvitationReq.ChannelList.num_channelList);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("P2PGroupId:\n"));
            if (!pFrm->P2PInvitationReq.P2PGroupId.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.P2PGroupId.deviceAddress, 6);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("num_ssid: %d.\n"), pFrm->P2PInvitationReq.P2PGroupId.num_ssid);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* ) pFrm->P2PInvitationReq.P2PGroupId.ssid, pFrm->P2PInvitationReq.P2PGroupId.num_ssid);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("P2PDeviceInfo:\n"));
            if (!pFrm->P2PInvitationReq.P2PDeviceInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.P2PDeviceInfo.P2PDeviceAddress, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.P2PDeviceInfo.configMethod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* )&pFrm->P2PInvitationReq.P2PDeviceInfo.primaryDeviceType, 8);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("DeviceName:\n"));
                if (!pFrm->P2PInvitationReq.P2PDeviceInfo.DeviceName.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), FRFL("num_text: %d.\n"), pFrm->P2PInvitationReq.P2PDeviceInfo.DeviceName.num_text);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONREQ), ( tANI_U8* ) pFrm->P2PInvitationReq.P2PDeviceInfo.DeviceName.text, pFrm->P2PInvitationReq.P2PDeviceInfo.DeviceName.num_text);
                }
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackInvitationReq. */

    static const tFFDefn FFS_InvitationRes[] = {
        { "Category", offsetof(tDot11fInvitationRes, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fInvitationRes, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "P2POUI", offsetof(tDot11fInvitationRes, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fInvitationRes, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fInvitationRes, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_InvitationRes[] = {
        {offsetof(tDot11fInvitationRes, P2PInvitationRes), offsetof(tDot11fIEP2PInvitationRes, present), 0, "P2PInvitationRes" , 0, 6, 289, SigIeP2PInvitationRes, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PINVITATIONRES, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackInvitationRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fInvitationRes *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_InvitationRes, IES_InvitationRes, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("Unpacked the InvitationRes:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("P2PInvitationRes:\n"));
        if (!pFrm->P2PInvitationRes.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("P2PStatus:\n"));
            if (!pFrm->P2PInvitationRes.P2PStatus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->P2PInvitationRes.P2PStatus.status, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("ConfigurationTimeout:\n"));
            if (!pFrm->P2PInvitationRes.ConfigurationTimeout.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->P2PInvitationRes.ConfigurationTimeout.GOConfigTimeout, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->P2PInvitationRes.ConfigurationTimeout.CLConfigTimeout, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("OperatingChannel:\n"));
            if (!pFrm->P2PInvitationRes.OperatingChannel.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->P2PInvitationRes.OperatingChannel.countryString, 3);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->P2PInvitationRes.OperatingChannel.regulatoryClass, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->P2PInvitationRes.OperatingChannel.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("P2PGroupBssid:\n"));
            if (!pFrm->P2PInvitationRes.P2PGroupBssid.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->P2PInvitationRes.P2PGroupBssid.P2PGroupBssid, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("ChannelList:\n"));
            if (!pFrm->P2PInvitationRes.ChannelList.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* )&pFrm->P2PInvitationRes.ChannelList.countryString, 3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), FRFL("num_channelList: %d.\n"), pFrm->P2PInvitationRes.ChannelList.num_channelList);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_INVITATIONRES), ( tANI_U8* ) pFrm->P2PInvitationRes.ChannelList.channelList, pFrm->P2PInvitationRes.ChannelList.num_channelList);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackInvitationRes. */

    static const tFFDefn FFS_LinkMeasurementReport[] = {
        { "Category", offsetof(tDot11fLinkMeasurementReport, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fLinkMeasurementReport, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fLinkMeasurementReport, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
        { "TPCEleID", offsetof(tDot11fLinkMeasurementReport, TPCEleID), SigFfTPCEleID , DOT11F_FF_TPCELEID_LEN, },
        { "TPCEleLen", offsetof(tDot11fLinkMeasurementReport, TPCEleLen), SigFfTPCEleLen , DOT11F_FF_TPCELELEN_LEN, },
        { "TxPower", offsetof(tDot11fLinkMeasurementReport, TxPower), SigFfTxPower , DOT11F_FF_TXPOWER_LEN, },
        { "LinkMargin", offsetof(tDot11fLinkMeasurementReport, LinkMargin), SigFfLinkMargin , DOT11F_FF_LINKMARGIN_LEN, },
        { "RxAntennaId", offsetof(tDot11fLinkMeasurementReport, RxAntennaId), SigFfRxAntennaId , DOT11F_FF_RXANTENNAID_LEN, },
        { "TxAntennaId", offsetof(tDot11fLinkMeasurementReport, TxAntennaId), SigFfTxAntennaId , DOT11F_FF_TXANTENNAID_LEN, },
        { "RCPI", offsetof(tDot11fLinkMeasurementReport, RCPI), SigFfRCPI , DOT11F_FF_RCPI_LEN, },
        { "RSNI", offsetof(tDot11fLinkMeasurementReport, RSNI), SigFfRSNI , DOT11F_FF_RSNI_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_LinkMeasurementReport[] = {
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackLinkMeasurementReport(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fLinkMeasurementReport *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_LinkMeasurementReport, IES_LinkMeasurementReport, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("Unpacked the LinkMeasurementReport:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("TPCEleID:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->TPCEleID.TPCId, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("TPCEleLen:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->TPCEleLen.TPCLen, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("TxPower:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->TxPower.txPower, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("LinkMargin:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->LinkMargin.linkMargin, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("RxAntennaId:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->RxAntennaId.antennaId, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("TxAntennaId:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->TxAntennaId.antennaId, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("RCPI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->RCPI.rcpi, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), FRFL("RSNI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREPORT), ( tANI_U8* )&pFrm->RSNI.rsni, 1);
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackLinkMeasurementReport. */

    static const tFFDefn FFS_LinkMeasurementRequest[] = {
        { "Category", offsetof(tDot11fLinkMeasurementRequest, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fLinkMeasurementRequest, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fLinkMeasurementRequest, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
        { "TxPower", offsetof(tDot11fLinkMeasurementRequest, TxPower), SigFfTxPower , DOT11F_FF_TXPOWER_LEN, },
        { "MaxTxPower", offsetof(tDot11fLinkMeasurementRequest, MaxTxPower), SigFfMaxTxPower , DOT11F_FF_MAXTXPOWER_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_LinkMeasurementRequest[] = {
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackLinkMeasurementRequest(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fLinkMeasurementRequest *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_LinkMeasurementRequest, IES_LinkMeasurementRequest, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), FRFL("Unpacked the LinkMeasurementRequest:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), FRFL("TxPower:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->TxPower.txPower, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), FRFL("MaxTxPower:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_LINKMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MaxTxPower.maxTxPower, 1);
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackLinkMeasurementRequest. */

    static const tFFDefn FFS_MeasurementReport[] = {
        { "Category", offsetof(tDot11fMeasurementReport, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fMeasurementReport, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fMeasurementReport, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_MeasurementReport[] = {
        {offsetof(tDot11fMeasurementReport, MeasurementReport), offsetof(tDot11fIEMeasurementReport, present), 0, "MeasurementReport" , 0, 5, 31, SigIeMeasurementReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MEASUREMENTREPORT, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackMeasurementReport(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fMeasurementReport *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_MeasurementReport, IES_MeasurementReport, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("Unpacked the MeasurementReport:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("MeasurementReport:\n"));
        if (!pFrm->MeasurementReport.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.token, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("late (1): %d\n"), pFrm->MeasurementReport.late);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("incapable (1): %d\n"), pFrm->MeasurementReport.incapable);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("refused (1): %d\n"), pFrm->MeasurementReport.refused);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("unused (5): %d\n"), pFrm->MeasurementReport.unused);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.type, 1);
            switch (pFrm->MeasurementReport.type)
            {
                case 0:
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Basic.channel, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Basic.meas_start_time, 8);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Basic.meas_duration, 2);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("bss (1): %d\n"), pFrm->MeasurementReport.report.Basic.bss);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("ofdm_preamble (1): %d\n"), pFrm->MeasurementReport.report.Basic.ofdm_preamble);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("unid_signal (1): %d\n"), pFrm->MeasurementReport.report.Basic.unid_signal);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("rader (1): %d\n"), pFrm->MeasurementReport.report.Basic.rader);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("unmeasured (1): %d\n"), pFrm->MeasurementReport.report.Basic.unmeasured);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("unused (3): %d\n"), pFrm->MeasurementReport.report.Basic.unused);
                break;
                case 1:
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.CCA.channel, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.CCA.meas_start_time, 8);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.CCA.meas_duration, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.CCA.cca_busy_fraction, 1);
                break;
                case 2:
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.channel, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.meas_start_time, 8);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.meas_duration, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.rpi0_density, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.rpi1_density, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.rpi2_density, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.rpi3_density, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.rpi4_density, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.rpi5_density, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.rpi6_density, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.RPIHistogram.rpi7_density, 1);
                break;
                case 5:
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Beacon.regClass, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Beacon.channel, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Beacon.meas_start_time, 8);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Beacon.meas_duration, 2);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("condensed_PHY (7): %d\n"), pFrm->MeasurementReport.report.Beacon.condensed_PHY);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), FRFL("reported_frame_type (1): %d\n"), pFrm->MeasurementReport.report.Beacon.reported_frame_type);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Beacon.RCPI, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Beacon.RSNI, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Beacon.BSSID, 6);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Beacon.antenna_id, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport.report.Beacon.parent_TSF, 4);
                break;
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackMeasurementReport. */

    static const tFFDefn FFS_MeasurementRequest[] = {
        { "Category", offsetof(tDot11fMeasurementRequest, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fMeasurementRequest, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fMeasurementRequest, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_MeasurementRequest[] = {
        {offsetof(tDot11fMeasurementRequest, MeasurementRequest), offsetof(tDot11fIEMeasurementRequest, present), offsetof(tDot11fMeasurementRequest, num_MeasurementRequest), "MeasurementRequest" , 4, 16, 18, SigIeMeasurementRequest, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MEASUREMENTREQUEST, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackMeasurementRequest(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fMeasurementRequest *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_MeasurementRequest, IES_MeasurementRequest, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("Unpacked the MeasurementRequest:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        for (i = 0; i < pFrm->num_MeasurementRequest; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("MeasurementRequest[%d]:\n"), i);
            if (!pFrm->MeasurementRequest[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_token, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("parallel (1): %d\n"), pFrm->MeasurementRequest[i].parallel);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("enable (1): %d\n"), pFrm->MeasurementRequest[i].enable);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("request (1): %d\n"), pFrm->MeasurementRequest[i].request);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("report (1): %d\n"), pFrm->MeasurementRequest[i].report);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("durationMandatory (1): %d\n"), pFrm->MeasurementRequest[i].durationMandatory);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), FRFL("unused (3): %d\n"), pFrm->MeasurementRequest[i].unused);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_type, 1);
                switch (pFrm->MeasurementRequest[i].measurement_type)
                {
                    case 0:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Basic.channel_no, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Basic.meas_start_time, 8);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Basic.meas_duration, 2);
                    break;
                    case 1:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.CCA.channel_no, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.CCA.meas_start_time, 8);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.CCA.meas_duration, 2);
                    break;
                    case 2:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.RPIHistogram.channel_no, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.RPIHistogram.meas_start_time, 8);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.RPIHistogram.meas_duration, 2);
                    break;
                    case 5:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.regClass, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.channel, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.randomization, 2);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.meas_duration, 2);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.meas_mode, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_MEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.BSSID, 6);
                    break;
                }
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackMeasurementRequest. */

    static const tFFDefn FFS_NeighborReportRequest[] = {
        { "Category", offsetof(tDot11fNeighborReportRequest, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fNeighborReportRequest, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fNeighborReportRequest, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_NeighborReportRequest[] = {
        {offsetof(tDot11fNeighborReportRequest, SSID), offsetof(tDot11fIESSID, present), 0, "SSID" , 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackNeighborReportRequest(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fNeighborReportRequest *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_NeighborReportRequest, IES_NeighborReportRequest, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), FRFL("Unpacked the NeighborReportRequest:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), FRFL("SSID:\n"));
        if (!pFrm->SSID.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), FRFL("num_ssid: %d.\n"), pFrm->SSID.num_ssid);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTREQUEST), ( tANI_U8* ) pFrm->SSID.ssid, pFrm->SSID.num_ssid);
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackNeighborReportRequest. */

    static const tFFDefn FFS_NeighborReportResponse[] = {
        { "Category", offsetof(tDot11fNeighborReportResponse, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fNeighborReportResponse, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fNeighborReportResponse, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_NeighborReportResponse[] = {
        {offsetof(tDot11fNeighborReportResponse, NeighborReport), offsetof(tDot11fIENeighborReport, present), offsetof(tDot11fNeighborReportResponse, num_NeighborReport), "NeighborReport" , 4, 15, 548, SigIeNeighborReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_NEIGHBORREPORT, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackNeighborReportResponse(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fNeighborReportResponse *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_NeighborReportResponse, IES_NeighborReportResponse, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("Unpacked the NeighborReportResponse:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        for (i = 0; i < pFrm->num_NeighborReport; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("NeighborReport[%d]:\n"), i);
            if (!pFrm->NeighborReport[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->NeighborReport[i].bssid, 6);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("APReachability (2): %d\n"), pFrm->NeighborReport[i].APReachability);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("Security (1): %d\n"), pFrm->NeighborReport[i].Security);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("KeyScope (1): %d\n"), pFrm->NeighborReport[i].KeyScope);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("SpecMgmtCap (1): %d\n"), pFrm->NeighborReport[i].SpecMgmtCap);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("QosCap (1): %d\n"), pFrm->NeighborReport[i].QosCap);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("apsd (1): %d\n"), pFrm->NeighborReport[i].apsd);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("rrm (1): %d\n"), pFrm->NeighborReport[i].rrm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("DelayedBA (1): %d\n"), pFrm->NeighborReport[i].DelayedBA);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("ImmBA (1): %d\n"), pFrm->NeighborReport[i].ImmBA);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("MobilityDomain (1): %d\n"), pFrm->NeighborReport[i].MobilityDomain);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("reserved (5): %d\n"), pFrm->NeighborReport[i].reserved);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->NeighborReport[i].reserved1, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->NeighborReport[i].regulatoryClass, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->NeighborReport[i].channel, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->NeighborReport[i].PhyType, 1);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("TSFInfo:\n"));
                if (!pFrm->NeighborReport[i].TSFInfo.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->NeighborReport[i].TSFInfo.TsfOffset, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->NeighborReport[i].TSFInfo.BeaconIntvl, 2);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("CondensedCountryStr:\n"));
                if (!pFrm->NeighborReport[i].CondensedCountryStr.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->NeighborReport[i].CondensedCountryStr.countryStr, 2);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("MeasurementPilot:\n"));
                if (!pFrm->NeighborReport[i].MeasurementPilot.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->NeighborReport[i].MeasurementPilot.measurementPilot, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("num_vendorSpecific: %d.\n"), pFrm->NeighborReport[i].MeasurementPilot.num_vendorSpecific);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* ) pFrm->NeighborReport[i].MeasurementPilot.vendorSpecific, pFrm->NeighborReport[i].MeasurementPilot.num_vendorSpecific);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("RRMEnabledCap:\n"));
                if (!pFrm->NeighborReport[i].RRMEnabledCap.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("LinkMeasurement (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.LinkMeasurement);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("NeighborRpt (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.NeighborRpt);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("parallel (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.parallel);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("repeated (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.repeated);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("BeaconPassive (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.BeaconPassive);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("BeaconActive (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.BeaconActive);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("BeaconTable (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.BeaconTable);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("BeaconRepCond (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.BeaconRepCond);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("FrameMeasurement (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.FrameMeasurement);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("ChannelLoad (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.ChannelLoad);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("NoiseHistogram (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.NoiseHistogram);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("statistics (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.statistics);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("LCIMeasurement (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.LCIMeasurement);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("LCIAzimuth (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.LCIAzimuth);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("TCMCapability (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.TCMCapability);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("triggeredTCM (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.triggeredTCM);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("APChanReport (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.APChanReport);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("RRMMIBEnabled (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.RRMMIBEnabled);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("operatingChanMax (3): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.operatingChanMax);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("nonOperatinChanMax (3): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.nonOperatinChanMax);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("MeasurementPilot (3): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.MeasurementPilot);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("MeasurementPilotEnabled (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.MeasurementPilotEnabled);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("NeighborTSFOffset (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.NeighborTSFOffset);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("RCPIMeasurement (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.RCPIMeasurement);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("RSNIMeasurement (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.RSNIMeasurement);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("BssAvgAccessDelay (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.BssAvgAccessDelay);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("BSSAvailAdmission (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.BSSAvailAdmission);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("AntennaInformation (1): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.AntennaInformation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("reserved (6): %d\n"), pFrm->NeighborReport[i].RRMEnabledCap.reserved);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("MultiBssid:\n"));
                if (!pFrm->NeighborReport[i].MultiBssid.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* )&pFrm->NeighborReport[i].MultiBssid.maxBSSIDIndicator, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), FRFL("num_vendorSpecific: %d.\n"), pFrm->NeighborReport[i].MultiBssid.num_vendorSpecific);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NEIGHBORREPORTRESPONSE), ( tANI_U8* ) pFrm->NeighborReport[i].MultiBssid.vendorSpecific, pFrm->NeighborReport[i].MultiBssid.num_vendorSpecific);
                }
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackNeighborReportResponse. */

    static const tFFDefn FFS_NoticeOfAbs[] = {
        { "Category", offsetof(tDot11fNoticeOfAbs, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "P2POUI", offsetof(tDot11fNoticeOfAbs, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fNoticeOfAbs, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fNoticeOfAbs, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_NoticeOfAbs[] = {
        {offsetof(tDot11fNoticeOfAbs, P2PNoticeOfAbsence), offsetof(tDot11fIEP2PNoticeOfAbsence, present), 0, "P2PNoticeOfAbsence" , 0, 6, 47, SigIeP2PNoticeOfAbsence, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PNOTICEOFABSENCE, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackNoticeOfAbs(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fNoticeOfAbs *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_NoticeOfAbs, IES_NoticeOfAbs, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("Unpacked the NoticeOfAbs:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("P2PNoticeOfAbsence:\n"));
        if (!pFrm->P2PNoticeOfAbsence.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("NoticeOfAbsence:\n"));
            if (!pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), ( tANI_U8* )&pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.index, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), ( tANI_U8* )&pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.CTSWindowOppPS, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), FRFL("num_NoADesc: %d.\n"), pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.num_NoADesc);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_NOTICEOFABS), ( tANI_U8* ) pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.NoADesc, pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.num_NoADesc);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackNoticeOfAbs. */

    static const tFFDefn FFS_PresenceReq[] = {
        { "Category", offsetof(tDot11fPresenceReq, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "P2POUI", offsetof(tDot11fPresenceReq, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fPresenceReq, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fPresenceReq, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_PresenceReq[] = {
        {offsetof(tDot11fPresenceReq, P2PNoticeOfAbsence), offsetof(tDot11fIEP2PNoticeOfAbsence, present), 0, "P2PNoticeOfAbsence" , 0, 6, 47, SigIeP2PNoticeOfAbsence, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PNOTICEOFABSENCE, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackPresenceReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fPresenceReq *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_PresenceReq, IES_PresenceReq, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("Unpacked the PresenceReq:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("P2PNoticeOfAbsence:\n"));
        if (!pFrm->P2PNoticeOfAbsence.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("NoticeOfAbsence:\n"));
            if (!pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), ( tANI_U8* )&pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.index, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), ( tANI_U8* )&pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.CTSWindowOppPS, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), FRFL("num_NoADesc: %d.\n"), pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.num_NoADesc);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCEREQ), ( tANI_U8* ) pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.NoADesc, pFrm->P2PNoticeOfAbsence.NoticeOfAbsence.num_NoADesc);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackPresenceReq. */

    static const tFFDefn FFS_PresenceRes[] = {
        { "Category", offsetof(tDot11fPresenceRes, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "P2POUI", offsetof(tDot11fPresenceRes, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fPresenceRes, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fPresenceRes, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_PresenceRes[] = {
        {offsetof(tDot11fPresenceRes, P2PPresenceResponse), offsetof(tDot11fIEP2PPresenceResponse, present), 0, "P2PPresenceResponse" , 0, 6, 51, SigIeP2PPresenceResponse, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PPRESENCERESPONSE, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackPresenceRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fPresenceRes *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_PresenceRes, IES_PresenceRes, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("Unpacked the PresenceRes:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("P2PPresenceResponse:\n"));
        if (!pFrm->P2PPresenceResponse.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("P2PStatus:\n"));
            if (!pFrm->P2PPresenceResponse.P2PStatus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), ( tANI_U8* )&pFrm->P2PPresenceResponse.P2PStatus.status, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("NoticeOfAbsence:\n"));
            if (!pFrm->P2PPresenceResponse.NoticeOfAbsence.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), ( tANI_U8* )&pFrm->P2PPresenceResponse.NoticeOfAbsence.index, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), ( tANI_U8* )&pFrm->P2PPresenceResponse.NoticeOfAbsence.CTSWindowOppPS, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), FRFL("num_NoADesc: %d.\n"), pFrm->P2PPresenceResponse.NoticeOfAbsence.num_NoADesc);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PRESENCERES), ( tANI_U8* ) pFrm->P2PPresenceResponse.NoticeOfAbsence.NoADesc, pFrm->P2PPresenceResponse.NoticeOfAbsence.num_NoADesc);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackPresenceRes. */

    static const tFFDefn FFS_ProbeRequest[] = {
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_ProbeRequest[] = {
        {offsetof(tDot11fProbeRequest, SSID), offsetof(tDot11fIESSID, present), 0, "SSID" , 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 1, },
        {offsetof(tDot11fProbeRequest, SuppRates), offsetof(tDot11fIESuppRates, present), 0, "SuppRates" , 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPRATES, 1, },
        {offsetof(tDot11fProbeRequest, RequestedInfo), offsetof(tDot11fIERequestedInfo, present), 0, "RequestedInfo" , 0, 2, 257, SigIeRequestedInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_REQUESTEDINFO, 0, },
        {offsetof(tDot11fProbeRequest, ExtSuppRates), offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates" , 0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTSUPPRATES, 0, },
        {offsetof(tDot11fProbeRequest, DSParams), offsetof(tDot11fIEDSParams, present), 0, "DSParams" , 0, 3, 3, SigIeDSParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_DSPARAMS, 0, },
        {offsetof(tDot11fProbeRequest, HTCaps), offsetof(tDot11fIEHTCaps, present), 0, "HTCaps" , 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTCAPS, 0, },
        {offsetof(tDot11fProbeRequest, WscProbeReq), offsetof(tDot11fIEWscProbeReq, present), 0, "WscProbeReq" , 0, 6, 286, SigIeWscProbeReq, {0, 80, 242, 4, 0}, 4, DOT11F_EID_WSCPROBEREQ, 0, },
        {offsetof(tDot11fProbeRequest, WFATPC), offsetof(tDot11fIEWFATPC, present), 0, "WFATPC" , 0, 9, 9, SigIeWFATPC, {0, 80, 242, 8, 0}, 5, DOT11F_EID_WFATPC, 0, },
        {offsetof(tDot11fProbeRequest, P2PProbeReq), offsetof(tDot11fIEP2PProbeReq, present), 0, "P2PProbeReq" , 0, 6, 43, SigIeP2PProbeReq, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PPROBEREQ, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackProbeRequest(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fProbeRequest *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_ProbeRequest, IES_ProbeRequest, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Unpacked the ProbeRequest:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("SSID:\n"));
        if (!pFrm->SSID.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("num_ssid: %d.\n"), pFrm->SSID.num_ssid);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* ) pFrm->SSID.ssid, pFrm->SSID.num_ssid);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("SuppRates:\n"));
        if (!pFrm->SuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("num_rates: %d.\n"), pFrm->SuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* ) pFrm->SuppRates.rates, pFrm->SuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("RequestedInfo:\n"));
        if (!pFrm->RequestedInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("num_requested_eids: %d.\n"), pFrm->RequestedInfo.num_requested_eids);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* ) pFrm->RequestedInfo.requested_eids, pFrm->RequestedInfo.num_requested_eids);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("ExtSuppRates:\n"));
        if (!pFrm->ExtSuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("num_rates: %d.\n"), pFrm->ExtSuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* ) pFrm->ExtSuppRates.rates, pFrm->ExtSuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("DSParams:\n"));
        if (!pFrm->DSParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->DSParams.curr_channel, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("HTCaps:\n"));
        if (!pFrm->HTCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("advCodingCap (1): %d\n"), pFrm->HTCaps.advCodingCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("supportedChannelWidthSet (1): %d\n"), pFrm->HTCaps.supportedChannelWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("mimoPowerSave (2): %d\n"), pFrm->HTCaps.mimoPowerSave);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("greenField (1): %d\n"), pFrm->HTCaps.greenField);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("shortGI20MHz (1): %d\n"), pFrm->HTCaps.shortGI20MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("shortGI40MHz (1): %d\n"), pFrm->HTCaps.shortGI40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("txSTBC (1): %d\n"), pFrm->HTCaps.txSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("rxSTBC (2): %d\n"), pFrm->HTCaps.rxSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("delayedBA (1): %d\n"), pFrm->HTCaps.delayedBA);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("maximalAMSDUsize (1): %d\n"), pFrm->HTCaps.maximalAMSDUsize);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("dsssCckMode40MHz (1): %d\n"), pFrm->HTCaps.dsssCckMode40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("psmp (1): %d\n"), pFrm->HTCaps.psmp);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("stbcControlFrame (1): %d\n"), pFrm->HTCaps.stbcControlFrame);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("lsigTXOPProtection (1): %d\n"), pFrm->HTCaps.lsigTXOPProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("maxRxAMPDUFactor (2): %d\n"), pFrm->HTCaps.maxRxAMPDUFactor);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("mpduDensity (3): %d\n"), pFrm->HTCaps.mpduDensity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("reserved1 (3): %d\n"), pFrm->HTCaps.reserved1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->HTCaps.supportedMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("pco (1): %d\n"), pFrm->HTCaps.pco);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("transitionTime (2): %d\n"), pFrm->HTCaps.transitionTime);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("reserved2 (5): %d\n"), pFrm->HTCaps.reserved2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("mcsFeedback (2): %d\n"), pFrm->HTCaps.mcsFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("reserved3 (6): %d\n"), pFrm->HTCaps.reserved3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("txBF (1): %d\n"), pFrm->HTCaps.txBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("rxStaggeredSounding (1): %d\n"), pFrm->HTCaps.rxStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("txStaggeredSounding (1): %d\n"), pFrm->HTCaps.txStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("rxZLF (1): %d\n"), pFrm->HTCaps.rxZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("txZLF (1): %d\n"), pFrm->HTCaps.txZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("implicitTxBF (1): %d\n"), pFrm->HTCaps.implicitTxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("calibration (2): %d\n"), pFrm->HTCaps.calibration);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("explicitCSITxBF (1): %d\n"), pFrm->HTCaps.explicitCSITxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("explicitUncompressedSteeringMatrix (1): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrix);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("explicitBFCSIFeedback (3): %d\n"), pFrm->HTCaps.explicitBFCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("explicitUncompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("explicitCompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitCompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("csiNumBFAntennae (2): %d\n"), pFrm->HTCaps.csiNumBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("uncompressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.uncompressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("compressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.compressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("reserved4 (7): %d\n"), pFrm->HTCaps.reserved4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("antennaSelection (1): %d\n"), pFrm->HTCaps.antennaSelection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("explicitCSIFeedbackTx (1): %d\n"), pFrm->HTCaps.explicitCSIFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("antennaIndicesFeedbackTx (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("explicitCSIFeedback (1): %d\n"), pFrm->HTCaps.explicitCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("antennaIndicesFeedback (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("rxAS (1): %d\n"), pFrm->HTCaps.rxAS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("txSoundingPPDUs (1): %d\n"), pFrm->HTCaps.txSoundingPPDUs);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("reserved5 (1): %d\n"), pFrm->HTCaps.reserved5);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("num_rsvd: %d.\n"), pFrm->HTCaps.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* ) pFrm->HTCaps.rsvd, pFrm->HTCaps.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("WscProbeReq:\n"));
        if (!pFrm->WscProbeReq.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Version:\n"));
            if (!pFrm->WscProbeReq.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("minor (4): %d\n"), pFrm->WscProbeReq.Version.minor);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("major (4): %d\n"), pFrm->WscProbeReq.Version.major);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("RequestType:\n"));
            if (!pFrm->WscProbeReq.RequestType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.RequestType.reqType, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("ConfigMethods:\n"));
            if (!pFrm->WscProbeReq.ConfigMethods.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.ConfigMethods.methods, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("UUID_E:\n"));
            if (!pFrm->WscProbeReq.UUID_E.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.UUID_E.uuid, 16);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("PrimaryDeviceType:\n"));
            if (!pFrm->WscProbeReq.PrimaryDeviceType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.PrimaryDeviceType.primary_category, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.PrimaryDeviceType.oui, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.PrimaryDeviceType.sub_category, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("RFBands:\n"));
            if (!pFrm->WscProbeReq.RFBands.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.RFBands.bands, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("AssociationState:\n"));
            if (!pFrm->WscProbeReq.AssociationState.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.AssociationState.state, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("ConfigurationError:\n"));
            if (!pFrm->WscProbeReq.ConfigurationError.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.ConfigurationError.error, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("DevicePasswordID:\n"));
            if (!pFrm->WscProbeReq.DevicePasswordID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.DevicePasswordID.id, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Manufacturer:\n"));
            if (!pFrm->WscProbeReq.Manufacturer.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("num_name: %d.\n"), pFrm->WscProbeReq.Manufacturer.num_name);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* ) pFrm->WscProbeReq.Manufacturer.name, pFrm->WscProbeReq.Manufacturer.num_name);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("ModelName:\n"));
            if (!pFrm->WscProbeReq.ModelName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("num_text: %d.\n"), pFrm->WscProbeReq.ModelName.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* ) pFrm->WscProbeReq.ModelName.text, pFrm->WscProbeReq.ModelName.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("ModelNumber:\n"));
            if (!pFrm->WscProbeReq.ModelNumber.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("num_text: %d.\n"), pFrm->WscProbeReq.ModelNumber.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* ) pFrm->WscProbeReq.ModelNumber.text, pFrm->WscProbeReq.ModelNumber.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("DeviceName:\n"));
            if (!pFrm->WscProbeReq.DeviceName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("num_text: %d.\n"), pFrm->WscProbeReq.DeviceName.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* ) pFrm->WscProbeReq.DeviceName.text, pFrm->WscProbeReq.DeviceName.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("VendorExtension:\n"));
            if (!pFrm->WscProbeReq.VendorExtension.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.VendorExtension.vendorId, 3);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Version2:\n"));
                if (!pFrm->WscProbeReq.VendorExtension.Version2.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("minor (4): %d\n"), pFrm->WscProbeReq.VendorExtension.Version2.minor);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("major (4): %d\n"), pFrm->WscProbeReq.VendorExtension.Version2.major);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("AuthorizedMACs:\n"));
                if (!pFrm->WscProbeReq.VendorExtension.AuthorizedMACs.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.VendorExtension.AuthorizedMACs.mac, 6);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("RequestToEnroll:\n"));
                if (!pFrm->WscProbeReq.VendorExtension.RequestToEnroll.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.VendorExtension.RequestToEnroll.req, 1);
                }
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("RequestDeviceType:\n"));
            if (!pFrm->WscProbeReq.RequestDeviceType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.RequestDeviceType.primary_category, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.RequestDeviceType.oui, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WscProbeReq.RequestDeviceType.sub_category, 2);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("WFATPC:\n"));
        if (!pFrm->WFATPC.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WFATPC.txPower, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->WFATPC.linkMargin, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("P2PProbeReq:\n"));
        if (!pFrm->P2PProbeReq.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("P2PCapability:\n"));
            if (!pFrm->P2PProbeReq.P2PCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.P2PCapability.deviceCapability, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.P2PCapability.groupCapability, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("P2PDeviceId:\n"));
            if (!pFrm->P2PProbeReq.P2PDeviceId.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.P2PDeviceId.P2PDeviceAddress, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("ListenChannel:\n"));
            if (!pFrm->P2PProbeReq.ListenChannel.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.ListenChannel.countryString, 3);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.ListenChannel.regulatoryClass, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.ListenChannel.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("ExtendedListenTiming:\n"));
            if (!pFrm->P2PProbeReq.ExtendedListenTiming.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.ExtendedListenTiming.availibilityPeriod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.ExtendedListenTiming.availibilityInterval, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("OperatingChannel:\n"));
            if (!pFrm->P2PProbeReq.OperatingChannel.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.OperatingChannel.countryString, 3);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.OperatingChannel.regulatoryClass, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBEREQUEST), ( tANI_U8* )&pFrm->P2PProbeReq.OperatingChannel.channel, 1);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackProbeRequest. */

    static const tFFDefn FFS_ProbeResponse[] = {
        { "TimeStamp", offsetof(tDot11fProbeResponse, TimeStamp), SigFfTimeStamp , DOT11F_FF_TIMESTAMP_LEN, },
        { "BeaconInterval", offsetof(tDot11fProbeResponse, BeaconInterval), SigFfBeaconInterval , DOT11F_FF_BEACONINTERVAL_LEN, },
        { "Capabilities", offsetof(tDot11fProbeResponse, Capabilities), SigFfCapabilities , DOT11F_FF_CAPABILITIES_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_ProbeResponse[] = {
        {offsetof(tDot11fProbeResponse, SSID), offsetof(tDot11fIESSID, present), 0, "SSID" , 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 1, },
        {offsetof(tDot11fProbeResponse, SuppRates), offsetof(tDot11fIESuppRates, present), 0, "SuppRates" , 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPRATES, 1, },
        {offsetof(tDot11fProbeResponse, FHParamSet), offsetof(tDot11fIEFHParamSet, present), 0, "FHParamSet" , 0, 7, 7, SigIeFHParamSet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FHPARAMSET, 0, },
        {offsetof(tDot11fProbeResponse, DSParams), offsetof(tDot11fIEDSParams, present), 0, "DSParams" , 0, 3, 3, SigIeDSParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_DSPARAMS, 0, },
        {offsetof(tDot11fProbeResponse, CFParams), offsetof(tDot11fIECFParams, present), 0, "CFParams" , 0, 8, 8, SigIeCFParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_CFPARAMS, 0, },
        {offsetof(tDot11fProbeResponse, IBSSParams), offsetof(tDot11fIEIBSSParams, present), 0, "IBSSParams" , 0, 4, 4, SigIeIBSSParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_IBSSPARAMS, 0, },
        {offsetof(tDot11fProbeResponse, Country), offsetof(tDot11fIECountry, present), 0, "Country" , 0, 5, 257, SigIeCountry, {0, 0, 0, 0, 0}, 0, DOT11F_EID_COUNTRY, 0, },
        {offsetof(tDot11fProbeResponse, FHParams), offsetof(tDot11fIEFHParams, present), 0, "FHParams" , 0, 4, 4, SigIeFHParams, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FHPARAMS, 0, },
        {offsetof(tDot11fProbeResponse, FHPattTable), offsetof(tDot11fIEFHPattTable, present), 0, "FHPattTable" , 0, 6, 257, SigIeFHPattTable, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FHPATTTABLE, 0, },
        {offsetof(tDot11fProbeResponse, PowerConstraints), offsetof(tDot11fIEPowerConstraints, present), 0, "PowerConstraints" , 0, 3, 3, SigIePowerConstraints, {0, 0, 0, 0, 0}, 0, DOT11F_EID_POWERCONSTRAINTS, 0, },
        {offsetof(tDot11fProbeResponse, ChanSwitchAnn), offsetof(tDot11fIEChanSwitchAnn, present), 0, "ChanSwitchAnn" , 0, 5, 5, SigIeChanSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_CHANSWITCHANN, 0, },
        {offsetof(tDot11fProbeResponse, Quiet), offsetof(tDot11fIEQuiet, present), 0, "Quiet" , 0, 8, 8, SigIeQuiet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QUIET, 0, },
        {offsetof(tDot11fProbeResponse, TPCReport), offsetof(tDot11fIETPCReport, present), 0, "TPCReport" , 0, 4, 4, SigIeTPCReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_TPCREPORT, 0, },
        {offsetof(tDot11fProbeResponse, ERPInfo), offsetof(tDot11fIEERPInfo, present), 0, "ERPInfo" , 0, 3, 3, SigIeERPInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_ERPINFO, 0, },
        {offsetof(tDot11fProbeResponse, ExtSuppRates), offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates" , 0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTSUPPRATES, 0, },
        {offsetof(tDot11fProbeResponse, RSN), offsetof(tDot11fIERSN, present), 0, "RSN" , 0, 8, 112, SigIeRSN, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSN, 0, },
        {offsetof(tDot11fProbeResponse, QBSSLoad), offsetof(tDot11fIEQBSSLoad, present), 0, "QBSSLoad" , 0, 7, 7, SigIeQBSSLoad, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QBSSLOAD, 0, },
        {offsetof(tDot11fProbeResponse, EDCAParamSet), offsetof(tDot11fIEEDCAParamSet, present), 0, "EDCAParamSet" , 0, 20, 20, SigIeEDCAParamSet, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EDCAPARAMSET, 0, },
        {offsetof(tDot11fProbeResponse, RRMEnabledCap), offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap" , 0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RRMENABLEDCAP, 0, },
        {offsetof(tDot11fProbeResponse, APChannelReport), offsetof(tDot11fIEAPChannelReport, present), 0, "APChannelReport" , 0, 3, 53, SigIeAPChannelReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_APCHANNELREPORT, 0, },
        {offsetof(tDot11fProbeResponse, MobilityDomain), offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain" , 0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MOBILITYDOMAIN, 0, },
        {offsetof(tDot11fProbeResponse, WPA), offsetof(tDot11fIEWPA, present), 0, "WPA" , 0, 8, 50, SigIeWPA, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPA, 0, },
        {offsetof(tDot11fProbeResponse, HTCaps), offsetof(tDot11fIEHTCaps, present), 0, "HTCaps" , 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTCAPS, 0, },
        {offsetof(tDot11fProbeResponse, HTInfo), offsetof(tDot11fIEHTInfo, present), 0, "HTInfo" , 0, 24, 56, SigIeHTInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTINFO, 0, },
        {offsetof(tDot11fProbeResponse, ExtChanSwitchAnn), offsetof(tDot11fIEExtChanSwitchAnn, present), 0, "ExtChanSwitchAnn" , 0, 3, 3, SigIeExtChanSwitchAnn, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTCHANSWITCHANN, 0, },
        {offsetof(tDot11fProbeResponse, WMMInfoAp), offsetof(tDot11fIEWMMInfoAp, present), 0, "WMMInfoAp" , 0, 9, 9, SigIeWMMInfoAp, {0, 80, 242, 2, 0}, 5, DOT11F_EID_WMMINFOAP, 0, },
        {offsetof(tDot11fProbeResponse, WMMParams), offsetof(tDot11fIEWMMParams, present), 0, "WMMParams" , 0, 26, 26, SigIeWMMParams, {0, 80, 242, 2, 1}, 5, DOT11F_EID_WMMPARAMS, 0, },
        {offsetof(tDot11fProbeResponse, WMMCaps), offsetof(tDot11fIEWMMCaps, present), 0, "WMMCaps" , 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5}, 5, DOT11F_EID_WMMCAPS, 0, },
        {offsetof(tDot11fProbeResponse, WAPI), offsetof(tDot11fIEWAPI, present), 0, "WAPI" , 0, 14, 112, SigIeWAPI, {0, 0, 0, 0, 0}, 0, DOT11F_EID_WAPI, 0, },
        {offsetof(tDot11fProbeResponse, CCXRadMgmtCap), offsetof(tDot11fIECCXRadMgmtCap, present), 0, "CCXRadMgmtCap" , 0, 8, 8, SigIeCCXRadMgmtCap, {0, 64, 150, 1, 0}, 4, DOT11F_EID_CCXRADMGMTCAP, 0, },
        {offsetof(tDot11fProbeResponse, CCXTrafStrmMet), offsetof(tDot11fIECCXTrafStrmMet, present), 0, "CCXTrafStrmMet" , 0, 10, 10, SigIeCCXTrafStrmMet, {0, 64, 150, 7, 0}, 4, DOT11F_EID_CCXTRAFSTRMMET, 0, },
        {offsetof(tDot11fProbeResponse, CCXTxmitPower), offsetof(tDot11fIECCXTxmitPower, present), 0, "CCXTxmitPower" , 0, 8, 8, SigIeCCXTxmitPower, {0, 64, 150, 0, 0}, 4, DOT11F_EID_CCXTXMITPOWER, 0, },
        {offsetof(tDot11fProbeResponse, Airgo), offsetof(tDot11fIEAirgo, present), 0, "Airgo" , 0, 5, 232, SigIeAirgo, {0, 10, 245, 0, 0}, 3, DOT11F_EID_AIRGO, 0, },
        {offsetof(tDot11fProbeResponse, WscProbeRes), offsetof(tDot11fIEWscProbeRes, present), 0, "WscProbeRes" , 0, 6, 319, SigIeWscProbeRes, {0, 80, 242, 4, 0}, 4, DOT11F_EID_WSCPROBERES, 0, },
        {offsetof(tDot11fProbeResponse, P2PProbeRes), offsetof(tDot11fIEP2PProbeRes, present), 0, "P2PProbeRes" , 0, 6, 1141, SigIeP2PProbeRes, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PPROBERES, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackProbeResponse(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fProbeResponse *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_ProbeResponse, IES_ProbeResponse, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Unpacked the ProbeResponse:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("TimeStamp:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->TimeStamp.timestamp, 8);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("BeaconInterval:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->BeaconInterval.interval, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Capabilities:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ess (1): %d\n"), pFrm->Capabilities.ess);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ibss (1): %d\n"), pFrm->Capabilities.ibss);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("cfPollable (1): %d\n"), pFrm->Capabilities.cfPollable);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("cfPollReq (1): %d\n"), pFrm->Capabilities.cfPollReq);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("privacy (1): %d\n"), pFrm->Capabilities.privacy);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("shortPreamble (1): %d\n"), pFrm->Capabilities.shortPreamble);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("pbcc (1): %d\n"), pFrm->Capabilities.pbcc);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("channelAgility (1): %d\n"), pFrm->Capabilities.channelAgility);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("spectrumMgt (1): %d\n"), pFrm->Capabilities.spectrumMgt);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("qos (1): %d\n"), pFrm->Capabilities.qos);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("shortSlotTime (1): %d\n"), pFrm->Capabilities.shortSlotTime);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("apsd (1): %d\n"), pFrm->Capabilities.apsd);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("rrm (1): %d\n"), pFrm->Capabilities.rrm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("dsssOfdm (1): %d\n"), pFrm->Capabilities.dsssOfdm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("delayedBA (1): %d\n"), pFrm->Capabilities.delayedBA);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("immediateBA (1): %d\n"), pFrm->Capabilities.immediateBA);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("SSID:\n"));
        if (!pFrm->SSID.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_ssid: %d.\n"), pFrm->SSID.num_ssid);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->SSID.ssid, pFrm->SSID.num_ssid);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("SuppRates:\n"));
        if (!pFrm->SuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_rates: %d.\n"), pFrm->SuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->SuppRates.rates, pFrm->SuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("FHParamSet:\n"));
        if (!pFrm->FHParamSet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->FHParamSet.dwell_time, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->FHParamSet.hop_set, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->FHParamSet.hop_pattern, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->FHParamSet.hop_index, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("DSParams:\n"));
        if (!pFrm->DSParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->DSParams.curr_channel, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("CFParams:\n"));
        if (!pFrm->CFParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->CFParams.cfp_count, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->CFParams.cfp_period, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->CFParams.cfp_maxduration, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->CFParams.cfp_durremaining, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("IBSSParams:\n"));
        if (!pFrm->IBSSParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->IBSSParams.atim, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Country:\n"));
        if (!pFrm->Country.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Country.country, 3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_triplets: %d.\n"), pFrm->Country.num_triplets);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->Country.triplets, 3 * pFrm->Country.num_triplets);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("FHParams:\n"));
        if (!pFrm->FHParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->FHParams.radix, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->FHParams.nchannels, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("FHPattTable:\n"));
        if (!pFrm->FHPattTable.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->FHPattTable.flag, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->FHPattTable.nsets, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->FHPattTable.modulus, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->FHPattTable.offset, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_randtable: %d.\n"), pFrm->FHPattTable.num_randtable);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->FHPattTable.randtable, pFrm->FHPattTable.num_randtable);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("PowerConstraints:\n"));
        if (!pFrm->PowerConstraints.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->PowerConstraints.localPowerConstraints, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ChanSwitchAnn:\n"));
        if (!pFrm->ChanSwitchAnn.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->ChanSwitchAnn.switchMode, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->ChanSwitchAnn.newChannel, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->ChanSwitchAnn.switchCount, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Quiet:\n"));
        if (!pFrm->Quiet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Quiet.count, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Quiet.period, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Quiet.duration, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Quiet.offset, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("TPCReport:\n"));
        if (!pFrm->TPCReport.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->TPCReport.tx_power, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->TPCReport.link_margin, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ERPInfo:\n"));
        if (!pFrm->ERPInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("non_erp_present (1): %d\n"), pFrm->ERPInfo.non_erp_present);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("use_prot (1): %d\n"), pFrm->ERPInfo.use_prot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("barker_preamble (1): %d\n"), pFrm->ERPInfo.barker_preamble);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused (5): %d\n"), pFrm->ERPInfo.unused);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ExtSuppRates:\n"));
        if (!pFrm->ExtSuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_rates: %d.\n"), pFrm->ExtSuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->ExtSuppRates.rates, pFrm->ExtSuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("RSN:\n"));
        if (!pFrm->RSN.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->RSN.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->RSN.gp_cipher_suite, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->RSN.pwise_cipher_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->RSN.pwise_cipher_suites, 4 * pFrm->RSN.pwise_cipher_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->RSN.akm_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->RSN.akm_suites, 4 * pFrm->RSN.akm_suite_count);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("preauth (1): %d\n"), pFrm->RSN.preauth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("no_pwise (1): %d\n"), pFrm->RSN.no_pwise);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("PTKSA_replay_counter (2): %d\n"), pFrm->RSN.PTKSA_replay_counter);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("GTKSA_replay_counter (2): %d\n"), pFrm->RSN.GTKSA_replay_counter);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved (10): %d\n"), pFrm->RSN.reserved);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->RSN.pmkid_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->RSN.pmkid, 16 * pFrm->RSN.pmkid_count);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("QBSSLoad:\n"));
        if (!pFrm->QBSSLoad.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->QBSSLoad.stacount, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->QBSSLoad.chautil, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->QBSSLoad.avail, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("EDCAParamSet:\n"));
        if (!pFrm->EDCAParamSet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.qos, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.reserved, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_aifsn (4): %d\n"), pFrm->EDCAParamSet.acbe_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_acm (1): %d\n"), pFrm->EDCAParamSet.acbe_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_aci (2): %d\n"), pFrm->EDCAParamSet.acbe_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused1 (1): %d\n"), pFrm->EDCAParamSet.unused1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_acwmin (4): %d\n"), pFrm->EDCAParamSet.acbe_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_acwmax (4): %d\n"), pFrm->EDCAParamSet.acbe_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.acbe_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_aifsn (4): %d\n"), pFrm->EDCAParamSet.acbk_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_acm (1): %d\n"), pFrm->EDCAParamSet.acbk_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_aci (2): %d\n"), pFrm->EDCAParamSet.acbk_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused2 (1): %d\n"), pFrm->EDCAParamSet.unused2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_acwmin (4): %d\n"), pFrm->EDCAParamSet.acbk_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_acwmax (4): %d\n"), pFrm->EDCAParamSet.acbk_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.acbk_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_aifsn (4): %d\n"), pFrm->EDCAParamSet.acvi_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_acm (1): %d\n"), pFrm->EDCAParamSet.acvi_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_aci (2): %d\n"), pFrm->EDCAParamSet.acvi_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused3 (1): %d\n"), pFrm->EDCAParamSet.unused3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_acwmin (4): %d\n"), pFrm->EDCAParamSet.acvi_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_acwmax (4): %d\n"), pFrm->EDCAParamSet.acvi_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.acvi_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_aifsn (4): %d\n"), pFrm->EDCAParamSet.acvo_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_acm (1): %d\n"), pFrm->EDCAParamSet.acvo_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_aci (2): %d\n"), pFrm->EDCAParamSet.acvo_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused4 (1): %d\n"), pFrm->EDCAParamSet.unused4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_acwmin (4): %d\n"), pFrm->EDCAParamSet.acvo_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_acwmax (4): %d\n"), pFrm->EDCAParamSet.acvo_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->EDCAParamSet.acvo_txoplimit, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("RRMEnabledCap:\n"));
        if (!pFrm->RRMEnabledCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("LinkMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LinkMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("NeighborRpt (1): %d\n"), pFrm->RRMEnabledCap.NeighborRpt);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("parallel (1): %d\n"), pFrm->RRMEnabledCap.parallel);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("repeated (1): %d\n"), pFrm->RRMEnabledCap.repeated);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("BeaconPassive (1): %d\n"), pFrm->RRMEnabledCap.BeaconPassive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("BeaconActive (1): %d\n"), pFrm->RRMEnabledCap.BeaconActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("BeaconTable (1): %d\n"), pFrm->RRMEnabledCap.BeaconTable);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("BeaconRepCond (1): %d\n"), pFrm->RRMEnabledCap.BeaconRepCond);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("FrameMeasurement (1): %d\n"), pFrm->RRMEnabledCap.FrameMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ChannelLoad (1): %d\n"), pFrm->RRMEnabledCap.ChannelLoad);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("NoiseHistogram (1): %d\n"), pFrm->RRMEnabledCap.NoiseHistogram);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("statistics (1): %d\n"), pFrm->RRMEnabledCap.statistics);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("LCIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LCIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("LCIAzimuth (1): %d\n"), pFrm->RRMEnabledCap.LCIAzimuth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("TCMCapability (1): %d\n"), pFrm->RRMEnabledCap.TCMCapability);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("triggeredTCM (1): %d\n"), pFrm->RRMEnabledCap.triggeredTCM);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("APChanReport (1): %d\n"), pFrm->RRMEnabledCap.APChanReport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("RRMMIBEnabled (1): %d\n"), pFrm->RRMEnabledCap.RRMMIBEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("operatingChanMax (3): %d\n"), pFrm->RRMEnabledCap.operatingChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("nonOperatinChanMax (3): %d\n"), pFrm->RRMEnabledCap.nonOperatinChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("MeasurementPilot (3): %d\n"), pFrm->RRMEnabledCap.MeasurementPilot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("MeasurementPilotEnabled (1): %d\n"), pFrm->RRMEnabledCap.MeasurementPilotEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("NeighborTSFOffset (1): %d\n"), pFrm->RRMEnabledCap.NeighborTSFOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("RCPIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RCPIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("RSNIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RSNIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("BssAvgAccessDelay (1): %d\n"), pFrm->RRMEnabledCap.BssAvgAccessDelay);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("BSSAvailAdmission (1): %d\n"), pFrm->RRMEnabledCap.BSSAvailAdmission);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("AntennaInformation (1): %d\n"), pFrm->RRMEnabledCap.AntennaInformation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved (6): %d\n"), pFrm->RRMEnabledCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("APChannelReport:\n"));
        if (!pFrm->APChannelReport.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->APChannelReport.regulatoryClass, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_channelList: %d.\n"), pFrm->APChannelReport.num_channelList);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->APChannelReport.channelList, pFrm->APChannelReport.num_channelList);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("MobilityDomain:\n"));
        if (!pFrm->MobilityDomain.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->MobilityDomain.MDID, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("overDSCap (1): %d\n"), pFrm->MobilityDomain.overDSCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("resourceReqCap (1): %d\n"), pFrm->MobilityDomain.resourceReqCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved (6): %d\n"), pFrm->MobilityDomain.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("WPA:\n"));
        if (!pFrm->WPA.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WPA.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WPA.multicast_cipher, 4);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WPA.unicast_cipher_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->WPA.unicast_ciphers, 4 * pFrm->WPA.unicast_cipher_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WPA.auth_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->WPA.auth_suites, 4 * pFrm->WPA.auth_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WPA.caps, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("HTCaps:\n"));
        if (!pFrm->HTCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("advCodingCap (1): %d\n"), pFrm->HTCaps.advCodingCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("supportedChannelWidthSet (1): %d\n"), pFrm->HTCaps.supportedChannelWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("mimoPowerSave (2): %d\n"), pFrm->HTCaps.mimoPowerSave);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("greenField (1): %d\n"), pFrm->HTCaps.greenField);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("shortGI20MHz (1): %d\n"), pFrm->HTCaps.shortGI20MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("shortGI40MHz (1): %d\n"), pFrm->HTCaps.shortGI40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("txSTBC (1): %d\n"), pFrm->HTCaps.txSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("rxSTBC (2): %d\n"), pFrm->HTCaps.rxSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("delayedBA (1): %d\n"), pFrm->HTCaps.delayedBA);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("maximalAMSDUsize (1): %d\n"), pFrm->HTCaps.maximalAMSDUsize);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("dsssCckMode40MHz (1): %d\n"), pFrm->HTCaps.dsssCckMode40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("psmp (1): %d\n"), pFrm->HTCaps.psmp);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("stbcControlFrame (1): %d\n"), pFrm->HTCaps.stbcControlFrame);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("lsigTXOPProtection (1): %d\n"), pFrm->HTCaps.lsigTXOPProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("maxRxAMPDUFactor (2): %d\n"), pFrm->HTCaps.maxRxAMPDUFactor);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("mpduDensity (3): %d\n"), pFrm->HTCaps.mpduDensity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved1 (3): %d\n"), pFrm->HTCaps.reserved1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->HTCaps.supportedMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("pco (1): %d\n"), pFrm->HTCaps.pco);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("transitionTime (2): %d\n"), pFrm->HTCaps.transitionTime);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved2 (5): %d\n"), pFrm->HTCaps.reserved2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("mcsFeedback (2): %d\n"), pFrm->HTCaps.mcsFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved3 (6): %d\n"), pFrm->HTCaps.reserved3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("txBF (1): %d\n"), pFrm->HTCaps.txBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("rxStaggeredSounding (1): %d\n"), pFrm->HTCaps.rxStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("txStaggeredSounding (1): %d\n"), pFrm->HTCaps.txStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("rxZLF (1): %d\n"), pFrm->HTCaps.rxZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("txZLF (1): %d\n"), pFrm->HTCaps.txZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("implicitTxBF (1): %d\n"), pFrm->HTCaps.implicitTxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("calibration (2): %d\n"), pFrm->HTCaps.calibration);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("explicitCSITxBF (1): %d\n"), pFrm->HTCaps.explicitCSITxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("explicitUncompressedSteeringMatrix (1): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrix);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("explicitBFCSIFeedback (3): %d\n"), pFrm->HTCaps.explicitBFCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("explicitUncompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("explicitCompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitCompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("csiNumBFAntennae (2): %d\n"), pFrm->HTCaps.csiNumBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("uncompressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.uncompressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("compressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.compressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved4 (7): %d\n"), pFrm->HTCaps.reserved4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("antennaSelection (1): %d\n"), pFrm->HTCaps.antennaSelection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("explicitCSIFeedbackTx (1): %d\n"), pFrm->HTCaps.explicitCSIFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("antennaIndicesFeedbackTx (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("explicitCSIFeedback (1): %d\n"), pFrm->HTCaps.explicitCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("antennaIndicesFeedback (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("rxAS (1): %d\n"), pFrm->HTCaps.rxAS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("txSoundingPPDUs (1): %d\n"), pFrm->HTCaps.txSoundingPPDUs);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved5 (1): %d\n"), pFrm->HTCaps.reserved5);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_rsvd: %d.\n"), pFrm->HTCaps.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->HTCaps.rsvd, pFrm->HTCaps.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("HTInfo:\n"));
        if (!pFrm->HTInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->HTInfo.primaryChannel, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("secondaryChannelOffset (2): %d\n"), pFrm->HTInfo.secondaryChannelOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("recommendedTxWidthSet (1): %d\n"), pFrm->HTInfo.recommendedTxWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("rifsMode (1): %d\n"), pFrm->HTInfo.rifsMode);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("controlledAccessOnly (1): %d\n"), pFrm->HTInfo.controlledAccessOnly);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("serviceIntervalGranularity (3): %d\n"), pFrm->HTInfo.serviceIntervalGranularity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("opMode (2): %d\n"), pFrm->HTInfo.opMode);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("nonGFDevicesPresent (1): %d\n"), pFrm->HTInfo.nonGFDevicesPresent);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("transmitBurstLimit (1): %d\n"), pFrm->HTInfo.transmitBurstLimit);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("obssNonHTStaPresent (1): %d\n"), pFrm->HTInfo.obssNonHTStaPresent);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved (11): %d\n"), pFrm->HTInfo.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("basicSTBCMCS (7): %d\n"), pFrm->HTInfo.basicSTBCMCS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("dualCTSProtection (1): %d\n"), pFrm->HTInfo.dualCTSProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("secondaryBeacon (1): %d\n"), pFrm->HTInfo.secondaryBeacon);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("lsigTXOPProtectionFullSupport (1): %d\n"), pFrm->HTInfo.lsigTXOPProtectionFullSupport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("pcoActive (1): %d\n"), pFrm->HTInfo.pcoActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("pcoPhase (1): %d\n"), pFrm->HTInfo.pcoPhase);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved2 (4): %d\n"), pFrm->HTInfo.reserved2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->HTInfo.basicMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_rsvd: %d.\n"), pFrm->HTInfo.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->HTInfo.rsvd, pFrm->HTInfo.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ExtChanSwitchAnn:\n"));
        if (!pFrm->ExtChanSwitchAnn.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->ExtChanSwitchAnn.secondaryChannelOffset, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("WMMInfoAp:\n"));
        if (!pFrm->WMMInfoAp.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WMMInfoAp.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("param_set_count (4): %d\n"), pFrm->WMMInfoAp.param_set_count);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved (3): %d\n"), pFrm->WMMInfoAp.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("uapsd (1): %d\n"), pFrm->WMMInfoAp.uapsd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("WMMParams:\n"));
        if (!pFrm->WMMParams.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WMMParams.version, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WMMParams.qosInfo, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WMMParams.reserved2, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_aifsn (4): %d\n"), pFrm->WMMParams.acbe_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_acm (1): %d\n"), pFrm->WMMParams.acbe_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_aci (2): %d\n"), pFrm->WMMParams.acbe_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused1 (1): %d\n"), pFrm->WMMParams.unused1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_acwmin (4): %d\n"), pFrm->WMMParams.acbe_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_acwmax (4): %d\n"), pFrm->WMMParams.acbe_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WMMParams.acbe_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_aifsn (4): %d\n"), pFrm->WMMParams.acbk_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_acm (1): %d\n"), pFrm->WMMParams.acbk_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_aci (2): %d\n"), pFrm->WMMParams.acbk_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused2 (1): %d\n"), pFrm->WMMParams.unused2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_acwmin (4): %d\n"), pFrm->WMMParams.acbk_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_acwmax (4): %d\n"), pFrm->WMMParams.acbk_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WMMParams.acbk_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_aifsn (4): %d\n"), pFrm->WMMParams.acvi_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_acm (1): %d\n"), pFrm->WMMParams.acvi_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_aci (2): %d\n"), pFrm->WMMParams.acvi_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused3 (1): %d\n"), pFrm->WMMParams.unused3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_acwmin (4): %d\n"), pFrm->WMMParams.acvi_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_acwmax (4): %d\n"), pFrm->WMMParams.acvi_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WMMParams.acvi_txoplimit, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_aifsn (4): %d\n"), pFrm->WMMParams.acvo_aifsn);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_acm (1): %d\n"), pFrm->WMMParams.acvo_acm);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_aci (2): %d\n"), pFrm->WMMParams.acvo_aci);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused4 (1): %d\n"), pFrm->WMMParams.unused4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_acwmin (4): %d\n"), pFrm->WMMParams.acvo_acwmin);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_acwmax (4): %d\n"), pFrm->WMMParams.acvo_acwmax);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WMMParams.acvo_txoplimit, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("WMMCaps:\n"));
        if (!pFrm->WMMCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WMMCaps.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved (4): %d\n"), pFrm->WMMCaps.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("qack (1): %d\n"), pFrm->WMMCaps.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("queue_request (1): %d\n"), pFrm->WMMCaps.queue_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("txop_request (1): %d\n"), pFrm->WMMCaps.txop_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("more_ack (1): %d\n"), pFrm->WMMCaps.more_ack);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("WAPI:\n"));
        if (!pFrm->WAPI.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WAPI.version, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WAPI.akm_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->WAPI.akm_suites, 4 * pFrm->WAPI.akm_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WAPI.unicast_cipher_suite_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->WAPI.unicast_cipher_suites, 4 * pFrm->WAPI.unicast_cipher_suite_count);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WAPI.multicast_cipher_suite, 4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("preauth (1): %d\n"), pFrm->WAPI.preauth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved (15): %d\n"), pFrm->WAPI.reserved);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WAPI.bkid_count, 2);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->WAPI.bkid, 16 * pFrm->WAPI.bkid_count);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("CCXRadMgmtCap:\n"));
        if (!pFrm->CCXRadMgmtCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->CCXRadMgmtCap.mgmt_state, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("mbssid_mask (3): %d\n"), pFrm->CCXRadMgmtCap.mbssid_mask);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("reserved (5): %d\n"), pFrm->CCXRadMgmtCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("CCXTrafStrmMet:\n"));
        if (!pFrm->CCXTrafStrmMet.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->CCXTrafStrmMet.tsid, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->CCXTrafStrmMet.state, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->CCXTrafStrmMet.msmt_interval, 2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("CCXTxmitPower:\n"));
        if (!pFrm->CCXTxmitPower.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->CCXTxmitPower.power_limit, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->CCXTxmitPower.reserved, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Airgo:\n"));
        if (!pFrm->Airgo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("PropSuppRates:\n"));
            if (!pFrm->Airgo.PropSuppRates.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_rates: %d.\n"), pFrm->Airgo.PropSuppRates.num_rates);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->Airgo.PropSuppRates.rates, pFrm->Airgo.PropSuppRates.num_rates);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("APName:\n"));
            if (!pFrm->Airgo.APName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_name: %d.\n"), pFrm->Airgo.APName.num_name);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->Airgo.APName.name, pFrm->Airgo.APName.num_name);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("HCF:\n"));
            if (!pFrm->Airgo.HCF.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.HCF.enabled, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("WDS:\n"));
            if (!pFrm->Airgo.WDS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_wdsData: %d.\n"), pFrm->Airgo.WDS.num_wdsData);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->Airgo.WDS.wdsData, pFrm->Airgo.WDS.num_wdsData);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("BPIndicator:\n"));
            if (!pFrm->Airgo.BPIndicator.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.BPIndicator.indicator, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.BPIndicator.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("LoadInfo:\n"));
            if (!pFrm->Airgo.LoadInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.LoadInfo.num_stas, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.LoadInfo.channel_util, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("LoadBalance:\n"));
            if (!pFrm->Airgo.LoadBalance.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.LoadBalance.bssid, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.LoadBalance.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("PropAssocType:\n"));
            if (!pFrm->Airgo.PropAssocType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropAssocType.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("LLAttr:\n"));
            if (!pFrm->Airgo.LLAttr.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.LLAttr.defer_threshold, 4);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("PropCapability:\n"));
            if (!pFrm->Airgo.PropCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropCapability.capability, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Version:\n"));
            if (!pFrm->Airgo.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.Version.chip_rev, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.Version.card_type, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_build_version: %d.\n"), pFrm->Airgo.Version.num_build_version);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->Airgo.Version.build_version, pFrm->Airgo.Version.num_build_version);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("PropEDCAParams:\n"));
            if (!pFrm->Airgo.PropEDCAParams.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.qos, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.reserved, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused1 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbe_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbe_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused2 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acbk_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbk_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused3 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvi_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvi_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("unused4 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused4);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("acvo_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvo_txoplimit, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Titan:\n"));
            if (!pFrm->Airgo.Titan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.Titan.concat_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.Titan.compression_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.Titan.cb_state, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.Titan.rev_fcs_state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("PropChannSwitchAnn:\n"));
            if (!pFrm->Airgo.PropChannSwitchAnn.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.mode, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.primary_channel, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.sub_band, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.channel_switch_count, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("PropQuietBSS:\n"));
            if (!pFrm->Airgo.PropQuietBSS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_count, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_period, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_duration, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_offset, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("TriggerStaBgScan:\n"));
            if (!pFrm->Airgo.TriggerStaBgScan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.TriggerStaBgScan.enable, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Taurus:\n"));
            if (!pFrm->Airgo.Taurus.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.Taurus.baTIDBitmap, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->Airgo.Taurus.baPolicy, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("baBufferSize (12): %d\n"), pFrm->Airgo.Taurus.baBufferSize);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("rsvd (4): %d\n"), pFrm->Airgo.Taurus.rsvd);
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("WscProbeRes:\n"));
        if (!pFrm->WscProbeRes.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Version:\n"));
            if (!pFrm->WscProbeRes.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("minor (4): %d\n"), pFrm->WscProbeRes.Version.minor);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("major (4): %d\n"), pFrm->WscProbeRes.Version.major);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("WPSState:\n"));
            if (!pFrm->WscProbeRes.WPSState.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.WPSState.state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("APSetupLocked:\n"));
            if (!pFrm->WscProbeRes.APSetupLocked.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.APSetupLocked.fLocked, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("SelectedRegistrar:\n"));
            if (!pFrm->WscProbeRes.SelectedRegistrar.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.SelectedRegistrar.selected, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("DevicePasswordID:\n"));
            if (!pFrm->WscProbeRes.DevicePasswordID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.DevicePasswordID.id, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("SelectedRegistrarConfigMethods:\n"));
            if (!pFrm->WscProbeRes.SelectedRegistrarConfigMethods.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.SelectedRegistrarConfigMethods.methods, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ResponseType:\n"));
            if (!pFrm->WscProbeRes.ResponseType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.ResponseType.resType, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("UUID_E:\n"));
            if (!pFrm->WscProbeRes.UUID_E.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.UUID_E.uuid, 16);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Manufacturer:\n"));
            if (!pFrm->WscProbeRes.Manufacturer.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_name: %d.\n"), pFrm->WscProbeRes.Manufacturer.num_name);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->WscProbeRes.Manufacturer.name, pFrm->WscProbeRes.Manufacturer.num_name);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ModelName:\n"));
            if (!pFrm->WscProbeRes.ModelName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_text: %d.\n"), pFrm->WscProbeRes.ModelName.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->WscProbeRes.ModelName.text, pFrm->WscProbeRes.ModelName.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ModelNumber:\n"));
            if (!pFrm->WscProbeRes.ModelNumber.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_text: %d.\n"), pFrm->WscProbeRes.ModelNumber.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->WscProbeRes.ModelNumber.text, pFrm->WscProbeRes.ModelNumber.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("SerialNumber:\n"));
            if (!pFrm->WscProbeRes.SerialNumber.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_text: %d.\n"), pFrm->WscProbeRes.SerialNumber.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->WscProbeRes.SerialNumber.text, pFrm->WscProbeRes.SerialNumber.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("PrimaryDeviceType:\n"));
            if (!pFrm->WscProbeRes.PrimaryDeviceType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.PrimaryDeviceType.primary_category, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.PrimaryDeviceType.oui, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.PrimaryDeviceType.sub_category, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("DeviceName:\n"));
            if (!pFrm->WscProbeRes.DeviceName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_text: %d.\n"), pFrm->WscProbeRes.DeviceName.num_text);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->WscProbeRes.DeviceName.text, pFrm->WscProbeRes.DeviceName.num_text);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ConfigMethods:\n"));
            if (!pFrm->WscProbeRes.ConfigMethods.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.ConfigMethods.methods, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("RFBands:\n"));
            if (!pFrm->WscProbeRes.RFBands.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.RFBands.bands, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("VendorExtension:\n"));
            if (!pFrm->WscProbeRes.VendorExtension.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.VendorExtension.vendorId, 3);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Version2:\n"));
                if (!pFrm->WscProbeRes.VendorExtension.Version2.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("minor (4): %d\n"), pFrm->WscProbeRes.VendorExtension.Version2.minor);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("major (4): %d\n"), pFrm->WscProbeRes.VendorExtension.Version2.major);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("AuthorizedMACs:\n"));
                if (!pFrm->WscProbeRes.VendorExtension.AuthorizedMACs.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.VendorExtension.AuthorizedMACs.mac, 6);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("RequestToEnroll:\n"));
                if (!pFrm->WscProbeRes.VendorExtension.RequestToEnroll.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->WscProbeRes.VendorExtension.RequestToEnroll.req, 1);
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("P2PProbeRes:\n"));
        if (!pFrm->P2PProbeRes.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("P2PCapability:\n"));
            if (!pFrm->P2PProbeRes.P2PCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->P2PProbeRes.P2PCapability.deviceCapability, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->P2PProbeRes.P2PCapability.groupCapability, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("ExtendedListenTiming:\n"));
            if (!pFrm->P2PProbeRes.ExtendedListenTiming.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->P2PProbeRes.ExtendedListenTiming.availibilityPeriod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->P2PProbeRes.ExtendedListenTiming.availibilityInterval, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("NoticeOfAbsence:\n"));
            if (!pFrm->P2PProbeRes.NoticeOfAbsence.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->P2PProbeRes.NoticeOfAbsence.index, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->P2PProbeRes.NoticeOfAbsence.CTSWindowOppPS, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_NoADesc: %d.\n"), pFrm->P2PProbeRes.NoticeOfAbsence.num_NoADesc);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->P2PProbeRes.NoticeOfAbsence.NoADesc, pFrm->P2PProbeRes.NoticeOfAbsence.num_NoADesc);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("P2PDeviceInfo:\n"));
            if (!pFrm->P2PProbeRes.P2PDeviceInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->P2PProbeRes.P2PDeviceInfo.P2PDeviceAddress, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->P2PProbeRes.P2PDeviceInfo.configMethod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* )&pFrm->P2PProbeRes.P2PDeviceInfo.primaryDeviceType, 8);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("DeviceName:\n"));
                if (!pFrm->P2PProbeRes.P2PDeviceInfo.DeviceName.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_text: %d.\n"), pFrm->P2PProbeRes.P2PDeviceInfo.DeviceName.num_text);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->P2PProbeRes.P2PDeviceInfo.DeviceName.text, pFrm->P2PProbeRes.P2PDeviceInfo.DeviceName.num_text);
                }
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("P2PGroupInfo:\n"));
            if (!pFrm->P2PProbeRes.P2PGroupInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), FRFL("num_P2PClientInfoDesc: %d.\n"), pFrm->P2PProbeRes.P2PGroupInfo.num_P2PClientInfoDesc);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROBERESPONSE), ( tANI_U8* ) pFrm->P2PProbeRes.P2PGroupInfo.P2PClientInfoDesc, pFrm->P2PProbeRes.P2PGroupInfo.num_P2PClientInfoDesc);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackProbeResponse. */

    static const tFFDefn FFS_ProvisionDiscoveryReq[] = {
        { "Category", offsetof(tDot11fProvisionDiscoveryReq, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fProvisionDiscoveryReq, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "P2POUI", offsetof(tDot11fProvisionDiscoveryReq, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fProvisionDiscoveryReq, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fProvisionDiscoveryReq, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_ProvisionDiscoveryReq[] = {
        {offsetof(tDot11fProvisionDiscoveryReq, P2PProvisionDiscoveryReq), offsetof(tDot11fIEP2PProvisionDiscoveryReq, present), 0, "P2PProvisionDiscoveryReq" , 0, 6, 107, SigIeP2PProvisionDiscoveryReq, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PPROVISIONDISCOVERYREQ, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackProvisionDiscoveryReq(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fProvisionDiscoveryReq *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_ProvisionDiscoveryReq, IES_ProvisionDiscoveryReq, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("Unpacked the ProvisionDiscoveryReq:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("P2PProvisionDiscoveryReq:\n"));
        if (!pFrm->P2PProvisionDiscoveryReq.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("P2PCapability:\n"));
            if (!pFrm->P2PProvisionDiscoveryReq.P2PCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->P2PProvisionDiscoveryReq.P2PCapability.deviceCapability, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->P2PProvisionDiscoveryReq.P2PCapability.groupCapability, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("P2PDeviceInfo:\n"));
            if (!pFrm->P2PProvisionDiscoveryReq.P2PDeviceInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->P2PProvisionDiscoveryReq.P2PDeviceInfo.P2PDeviceAddress, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->P2PProvisionDiscoveryReq.P2PDeviceInfo.configMethod, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->P2PProvisionDiscoveryReq.P2PDeviceInfo.primaryDeviceType, 8);
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("DeviceName:\n"));
                if (!pFrm->P2PProvisionDiscoveryReq.P2PDeviceInfo.DeviceName.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("num_text: %d.\n"), pFrm->P2PProvisionDiscoveryReq.P2PDeviceInfo.DeviceName.num_text);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* ) pFrm->P2PProvisionDiscoveryReq.P2PDeviceInfo.DeviceName.text, pFrm->P2PProvisionDiscoveryReq.P2PDeviceInfo.DeviceName.num_text);
                }
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("P2PGroupId:\n"));
            if (!pFrm->P2PProvisionDiscoveryReq.P2PGroupId.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* )&pFrm->P2PProvisionDiscoveryReq.P2PGroupId.deviceAddress, 6);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), FRFL("num_ssid: %d.\n"), pFrm->P2PProvisionDiscoveryReq.P2PGroupId.num_ssid);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYREQ), ( tANI_U8* ) pFrm->P2PProvisionDiscoveryReq.P2PGroupId.ssid, pFrm->P2PProvisionDiscoveryReq.P2PGroupId.num_ssid);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackProvisionDiscoveryReq. */

    static const tFFDefn FFS_ProvisionDiscoveryRes[] = {
        { "Category", offsetof(tDot11fProvisionDiscoveryRes, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fProvisionDiscoveryRes, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "P2POUI", offsetof(tDot11fProvisionDiscoveryRes, P2POUI), SigFfP2POUI , DOT11F_FF_P2POUI_LEN, },
        { "P2POUISubType", offsetof(tDot11fProvisionDiscoveryRes, P2POUISubType), SigFfP2POUISubType , DOT11F_FF_P2POUISUBTYPE_LEN, },
        { "DialogToken", offsetof(tDot11fProvisionDiscoveryRes, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_ProvisionDiscoveryRes[] = {
        {offsetof(tDot11fProvisionDiscoveryRes, P2PWSCProvisionDiscoveryRes), offsetof(tDot11fIEP2PWSCProvisionDiscoveryRes, present), 0, "P2PWSCProvisionDiscoveryRes" , 0, 6, 12, SigIeP2PWSCProvisionDiscoveryRes, {0, 80, 242, 4, 0}, 4, DOT11F_EID_P2PWSCPROVISIONDISCOVERYRES, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackProvisionDiscoveryRes(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fProvisionDiscoveryRes *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_ProvisionDiscoveryRes, IES_ProvisionDiscoveryRes, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("Unpacked the ProvisionDiscoveryRes:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("P2POUI:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), ( tANI_U8* )&pFrm->P2POUI.oui, 4);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("P2POUISubType:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), ( tANI_U8* )&pFrm->P2POUISubType.ouiSubtype, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("P2PWSCProvisionDiscoveryRes:\n"));
        if (!pFrm->P2PWSCProvisionDiscoveryRes.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("ConfigMethods:\n"));
            if (!pFrm->P2PWSCProvisionDiscoveryRes.ConfigMethods.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_PROVISIONDISCOVERYRES), ( tANI_U8* )&pFrm->P2PWSCProvisionDiscoveryRes.ConfigMethods.methods, 2);
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackProvisionDiscoveryRes. */

    static const tFFDefn FFS_RadioMeasurementReport[] = {
        { "Category", offsetof(tDot11fRadioMeasurementReport, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fRadioMeasurementReport, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fRadioMeasurementReport, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_RadioMeasurementReport[] = {
        {offsetof(tDot11fRadioMeasurementReport, MeasurementReport), offsetof(tDot11fIEMeasurementReport, present), offsetof(tDot11fRadioMeasurementReport, num_MeasurementReport), "MeasurementReport" , 4, 5, 31, SigIeMeasurementReport, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MEASUREMENTREPORT, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackRadioMeasurementReport(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fRadioMeasurementReport *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_RadioMeasurementReport, IES_RadioMeasurementReport, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("Unpacked the RadioMeasurementReport:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        for (i = 0; i < pFrm->num_MeasurementReport; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("MeasurementReport[%d]:\n"), i);
            if (!pFrm->MeasurementReport[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].token, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("late (1): %d\n"), pFrm->MeasurementReport[i].late);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("incapable (1): %d\n"), pFrm->MeasurementReport[i].incapable);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("refused (1): %d\n"), pFrm->MeasurementReport[i].refused);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("unused (5): %d\n"), pFrm->MeasurementReport[i].unused);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].type, 1);
                switch (pFrm->MeasurementReport[i].type)
                {
                    case 0:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Basic.channel, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Basic.meas_start_time, 8);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Basic.meas_duration, 2);
                        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("bss (1): %d\n"), pFrm->MeasurementReport[i].report.Basic.bss);
                        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("ofdm_preamble (1): %d\n"), pFrm->MeasurementReport[i].report.Basic.ofdm_preamble);
                        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("unid_signal (1): %d\n"), pFrm->MeasurementReport[i].report.Basic.unid_signal);
                        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("rader (1): %d\n"), pFrm->MeasurementReport[i].report.Basic.rader);
                        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("unmeasured (1): %d\n"), pFrm->MeasurementReport[i].report.Basic.unmeasured);
                        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("unused (3): %d\n"), pFrm->MeasurementReport[i].report.Basic.unused);
                    break;
                    case 1:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.CCA.channel, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.CCA.meas_start_time, 8);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.CCA.meas_duration, 2);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.CCA.cca_busy_fraction, 1);
                    break;
                    case 2:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.channel, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.meas_start_time, 8);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.meas_duration, 2);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.rpi0_density, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.rpi1_density, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.rpi2_density, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.rpi3_density, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.rpi4_density, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.rpi5_density, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.rpi6_density, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.RPIHistogram.rpi7_density, 1);
                    break;
                    case 5:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Beacon.regClass, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Beacon.channel, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Beacon.meas_start_time, 8);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Beacon.meas_duration, 2);
                        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("condensed_PHY (7): %d\n"), pFrm->MeasurementReport[i].report.Beacon.condensed_PHY);
                        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), FRFL("reported_frame_type (1): %d\n"), pFrm->MeasurementReport[i].report.Beacon.reported_frame_type);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Beacon.RCPI, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Beacon.RSNI, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Beacon.BSSID, 6);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Beacon.antenna_id, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREPORT), ( tANI_U8* )&pFrm->MeasurementReport[i].report.Beacon.parent_TSF, 4);
                    break;
                }
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackRadioMeasurementReport. */

    static const tFFDefn FFS_RadioMeasurementRequest[] = {
        { "Category", offsetof(tDot11fRadioMeasurementRequest, Category), SigFfCategory , DOT11F_FF_CATEGORY_LEN, },
        { "Action", offsetof(tDot11fRadioMeasurementRequest, Action), SigFfAction , DOT11F_FF_ACTION_LEN, },
        { "DialogToken", offsetof(tDot11fRadioMeasurementRequest, DialogToken), SigFfDialogToken , DOT11F_FF_DIALOGTOKEN_LEN, },
        { "NumOfRepetitions", offsetof(tDot11fRadioMeasurementRequest, NumOfRepetitions), SigFfNumOfRepetitions , DOT11F_FF_NUMOFREPETITIONS_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_RadioMeasurementRequest[] = {
        {offsetof(tDot11fRadioMeasurementRequest, MeasurementRequest), offsetof(tDot11fIEMeasurementRequest, present), offsetof(tDot11fRadioMeasurementRequest, num_MeasurementRequest), "MeasurementRequest" , 2, 16, 18, SigIeMeasurementRequest, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MEASUREMENTREQUEST, 1, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackRadioMeasurementRequest(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fRadioMeasurementRequest *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_RadioMeasurementRequest, IES_RadioMeasurementRequest, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("Unpacked the RadioMeasurementRequest:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("Category:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->Category.category, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("Action:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->Action.action, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("DialogToken:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->DialogToken.token, 1);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("NumOfRepetitions:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->NumOfRepetitions.repetitions, 2);
        for (i = 0; i < pFrm->num_MeasurementRequest; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("MeasurementRequest[%d]:\n"), i);
            if (!pFrm->MeasurementRequest[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_token, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("parallel (1): %d\n"), pFrm->MeasurementRequest[i].parallel);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("enable (1): %d\n"), pFrm->MeasurementRequest[i].enable);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("request (1): %d\n"), pFrm->MeasurementRequest[i].request);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("report (1): %d\n"), pFrm->MeasurementRequest[i].report);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("durationMandatory (1): %d\n"), pFrm->MeasurementRequest[i].durationMandatory);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), FRFL("unused (3): %d\n"), pFrm->MeasurementRequest[i].unused);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_type, 1);
                switch (pFrm->MeasurementRequest[i].measurement_type)
                {
                    case 0:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Basic.channel_no, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Basic.meas_start_time, 8);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Basic.meas_duration, 2);
                    break;
                    case 1:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.CCA.channel_no, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.CCA.meas_start_time, 8);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.CCA.meas_duration, 2);
                    break;
                    case 2:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.RPIHistogram.channel_no, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.RPIHistogram.meas_start_time, 8);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.RPIHistogram.meas_duration, 2);
                    break;
                    case 5:
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.regClass, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.channel, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.randomization, 2);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.meas_duration, 2);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.meas_mode, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_RADIOMEASUREMENTREQUEST), ( tANI_U8* )&pFrm->MeasurementRequest[i].measurement_request.Beacon.BSSID, 6);
                    break;
                }
            }
        }
    }
#   endif // DOT11F_DUMP_FRAMES
    return status;

} /* End dot11fUnpackRadioMeasurementRequest. */

    static const tFFDefn FFS_ReAssocRequest[] = {
        { "Capabilities", offsetof(tDot11fReAssocRequest, Capabilities), SigFfCapabilities , DOT11F_FF_CAPABILITIES_LEN, },
        { "ListenInterval", offsetof(tDot11fReAssocRequest, ListenInterval), SigFfListenInterval , DOT11F_FF_LISTENINTERVAL_LEN, },
        { "CurrentAPAddress", offsetof(tDot11fReAssocRequest, CurrentAPAddress), SigFfCurrentAPAddress , DOT11F_FF_CURRENTAPADDRESS_LEN, },
    { NULL, 0, 0, 0,},
    };

    static const tIEDefn IES_ReAssocRequest[] = {
        {offsetof(tDot11fReAssocRequest, SSID), offsetof(tDot11fIESSID, present), 0, "SSID" , 0, 2, 34, SigIeSSID, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SSID, 1, },
        {offsetof(tDot11fReAssocRequest, SuppRates), offsetof(tDot11fIESuppRates, present), 0, "SuppRates" , 0, 2, 14, SigIeSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPRATES, 1, },
        {offsetof(tDot11fReAssocRequest, ExtSuppRates), offsetof(tDot11fIEExtSuppRates, present), 0, "ExtSuppRates" , 0, 3, 14, SigIeExtSuppRates, {0, 0, 0, 0, 0}, 0, DOT11F_EID_EXTSUPPRATES, 0, },
        {offsetof(tDot11fReAssocRequest, PowerCaps), offsetof(tDot11fIEPowerCaps, present), 0, "PowerCaps" , 0, 4, 4, SigIePowerCaps, {0, 0, 0, 0, 0}, 0, DOT11F_EID_POWERCAPS, 0, },
        {offsetof(tDot11fReAssocRequest, SuppChannels), offsetof(tDot11fIESuppChannels, present), 0, "SuppChannels" , 0, 4, 98, SigIeSuppChannels, {0, 0, 0, 0, 0}, 0, DOT11F_EID_SUPPCHANNELS, 0, },
        {offsetof(tDot11fReAssocRequest, RSNOpaque), offsetof(tDot11fIERSNOpaque, present), 0, "RSNOpaque" , 0, 8, 255, SigIeRSNOpaque, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RSNOPAQUE, 0, },
        {offsetof(tDot11fReAssocRequest, QOSCapsStation), offsetof(tDot11fIEQOSCapsStation, present), 0, "QOSCapsStation" , 0, 3, 3, SigIeQOSCapsStation, {0, 0, 0, 0, 0}, 0, DOT11F_EID_QOSCAPSSTATION, 0, },
        {offsetof(tDot11fReAssocRequest, RRMEnabledCap), offsetof(tDot11fIERRMEnabledCap, present), 0, "RRMEnabledCap" , 0, 7, 7, SigIeRRMEnabledCap, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RRMENABLEDCAP, 0, },
        {offsetof(tDot11fReAssocRequest, MobilityDomain), offsetof(tDot11fIEMobilityDomain, present), 0, "MobilityDomain" , 0, 5, 5, SigIeMobilityDomain, {0, 0, 0, 0, 0}, 0, DOT11F_EID_MOBILITYDOMAIN, 0, },
        {offsetof(tDot11fReAssocRequest, FTInfo), offsetof(tDot11fIEFTInfo, present), 0, "FTInfo" , 0, 84, 187, SigIeFTInfo, {0, 0, 0, 0, 0}, 0, DOT11F_EID_FTINFO, 0, },
        {offsetof(tDot11fReAssocRequest, RICDataDesc), offsetof(tDot11fIERICDataDesc, present), offsetof(tDot11fReAssocRequest, num_RICDataDesc), "RICDataDesc" , 2, 2, 550, SigIeRICDataDesc, {0, 0, 0, 0, 0}, 0, DOT11F_EID_RICDATADESC, 0, },
        {offsetof(tDot11fReAssocRequest, WPAOpaque), offsetof(tDot11fIEWPAOpaque, present), 0, "WPAOpaque" , 0, 8, 255, SigIeWPAOpaque, {0, 80, 242, 1, 0}, 4, DOT11F_EID_WPAOPAQUE, 0, },
        {offsetof(tDot11fReAssocRequest, HTCaps), offsetof(tDot11fIEHTCaps, present), 0, "HTCaps" , 0, 28, 60, SigIeHTCaps, {0, 0, 0, 0, 0}, 0, DOT11F_EID_HTCAPS, 0, },
        {offsetof(tDot11fReAssocRequest, WMMCaps), offsetof(tDot11fIEWMMCaps, present), 0, "WMMCaps" , 0, 9, 9, SigIeWMMCaps, {0, 80, 242, 2, 5}, 5, DOT11F_EID_WMMCAPS, 0, },
        {offsetof(tDot11fReAssocRequest, WMMInfoStation), offsetof(tDot11fIEWMMInfoStation, present), 0, "WMMInfoStation" , 0, 9, 9, SigIeWMMInfoStation, {0, 80, 242, 2, 0}, 5, DOT11F_EID_WMMINFOSTATION, 0, },
        {offsetof(tDot11fReAssocRequest, Airgo), offsetof(tDot11fIEAirgo, present), 0, "Airgo" , 0, 5, 232, SigIeAirgo, {0, 10, 245, 0, 0}, 3, DOT11F_EID_AIRGO, 0, },
        {offsetof(tDot11fReAssocRequest, WscIEOpaque), offsetof(tDot11fIEWscIEOpaque, present), 0, "WscIEOpaque" , 0, 8, 255, SigIeWscIEOpaque, {0, 80, 242, 4, 0}, 4, DOT11F_EID_WSCIEOPAQUE, 0, },
        {offsetof(tDot11fReAssocRequest, WAPIOpaque), offsetof(tDot11fIEWAPIOpaque, present), 0, "WAPIOpaque" , 0, 8, 255, SigIeWAPIOpaque, {0, 0, 0, 0, 0}, 0, DOT11F_EID_WAPIOPAQUE, 0, },
        {offsetof(tDot11fReAssocRequest, CCXRadMgmtCap), offsetof(tDot11fIECCXRadMgmtCap, present), 0, "CCXRadMgmtCap" , 0, 8, 8, SigIeCCXRadMgmtCap, {0, 64, 150, 1, 0}, 4, DOT11F_EID_CCXRADMGMTCAP, 0, },
        {offsetof(tDot11fReAssocRequest, CCXVersion), offsetof(tDot11fIECCXVersion, present), 0, "CCXVersion" , 0, 7, 7, SigIeCCXVersion, {0, 64, 150, 3, 0}, 4, DOT11F_EID_CCXVERSION, 0, },
        {offsetof(tDot11fReAssocRequest, CCXCckmOpaque), offsetof(tDot11fIECCXCckmOpaque, present), 0, "CCXCckmOpaque" , 0, 12, 26, SigIeCCXCckmOpaque, {0, 64, 150, 0, 0}, 4, DOT11F_EID_CCXCCKMOPAQUE, 0, },
        {offsetof(tDot11fReAssocRequest, WMMTSPEC), offsetof(tDot11fIEWMMTSPEC, present), offsetof(tDot11fReAssocRequest, num_WMMTSPEC), "WMMTSPEC" , 4, 63, 63, SigIeWMMTSPEC, {0, 80, 242, 2, 2}, 5, DOT11F_EID_WMMTSPEC, 0, },
        {offsetof(tDot11fReAssocRequest, CCXTrafStrmRateSet), offsetof(tDot11fIECCXTrafStrmRateSet, present), 0, "CCXTrafStrmRateSet" , 0, 7, 15, SigIeCCXTrafStrmRateSet, {0, 64, 150, 8, 0}, 4, DOT11F_EID_CCXTRAFSTRMRATESET, 0, },
        {offsetof(tDot11fReAssocRequest, P2PIEOpaque), offsetof(tDot11fIEP2PIEOpaque, present), 0, "P2PIEOpaque" , 0, 8, 255, SigIeP2PIEOpaque, {80, 111, 154, 9, 0}, 4, DOT11F_EID_P2PIEOPAQUE, 0, },
    {0, 0, 0, NULL, 0, 0, 0, 0, {0, 0, 0, 0, 0}, 0, 0xff, 0, },    };

tANI_U32 dot11fUnpackReAssocRequest(tpAniSirGlobal pCtx, tANI_U8 *pBuf, tANI_U32 nBuf, tDot11fReAssocRequest *pFrm)
{
    tANI_U32 i = 0;
    tANI_U32 status = 0;
    status = UnpackCore(pCtx, pBuf, nBuf, FFS_ReAssocRequest, IES_ReAssocRequest, ( tANI_U8* )pFrm, sizeof(*pFrm));

    (void)i;
#   ifdef DOT11F_DUMP_FRAMES
    if (!DOT11F_FAILED(status))
    {
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Unpacked the ReAssocRequest:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), pBuf, nBuf);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("to:\n"));
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Capabilities:\n"));
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("ess (1): %d\n"), pFrm->Capabilities.ess);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("ibss (1): %d\n"), pFrm->Capabilities.ibss);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("cfPollable (1): %d\n"), pFrm->Capabilities.cfPollable);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("cfPollReq (1): %d\n"), pFrm->Capabilities.cfPollReq);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("privacy (1): %d\n"), pFrm->Capabilities.privacy);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("shortPreamble (1): %d\n"), pFrm->Capabilities.shortPreamble);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("pbcc (1): %d\n"), pFrm->Capabilities.pbcc);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("channelAgility (1): %d\n"), pFrm->Capabilities.channelAgility);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("spectrumMgt (1): %d\n"), pFrm->Capabilities.spectrumMgt);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("qos (1): %d\n"), pFrm->Capabilities.qos);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("shortSlotTime (1): %d\n"), pFrm->Capabilities.shortSlotTime);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("apsd (1): %d\n"), pFrm->Capabilities.apsd);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("rrm (1): %d\n"), pFrm->Capabilities.rrm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("dsssOfdm (1): %d\n"), pFrm->Capabilities.dsssOfdm);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("delayedBA (1): %d\n"), pFrm->Capabilities.delayedBA);
        FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("immediateBA (1): %d\n"), pFrm->Capabilities.immediateBA);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("ListenInterval:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->ListenInterval.interval, 2);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("CurrentAPAddress:\n"));
        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->CurrentAPAddress.mac, 6);
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("SSID:\n"));
        if (!pFrm->SSID.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_ssid: %d.\n"), pFrm->SSID.num_ssid);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->SSID.ssid, pFrm->SSID.num_ssid);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("SuppRates:\n"));
        if (!pFrm->SuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_rates: %d.\n"), pFrm->SuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->SuppRates.rates, pFrm->SuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("ExtSuppRates:\n"));
        if (!pFrm->ExtSuppRates.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_rates: %d.\n"), pFrm->ExtSuppRates.num_rates);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->ExtSuppRates.rates, pFrm->ExtSuppRates.num_rates);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("PowerCaps:\n"));
        if (!pFrm->PowerCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->PowerCaps.minTxPower, 1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->PowerCaps.maxTxPower, 1);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("SuppChannels:\n"));
        if (!pFrm->SuppChannels.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_bands: %d.\n"), pFrm->SuppChannels.num_bands);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->SuppChannels.bands, 2 * pFrm->SuppChannels.num_bands);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("RSNOpaque:\n"));
        if (!pFrm->RSNOpaque.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_data: %d.\n"), pFrm->RSNOpaque.num_data);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->RSNOpaque.data, pFrm->RSNOpaque.num_data);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("QOSCapsStation:\n"));
        if (!pFrm->QOSCapsStation.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("more_data_ack (1): %d\n"), pFrm->QOSCapsStation.more_data_ack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("max_sp_length (2): %d\n"), pFrm->QOSCapsStation.max_sp_length);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("qack (1): %d\n"), pFrm->QOSCapsStation.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbe_uapsd (1): %d\n"), pFrm->QOSCapsStation.acbe_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbk_uapsd (1): %d\n"), pFrm->QOSCapsStation.acbk_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvi_uapsd (1): %d\n"), pFrm->QOSCapsStation.acvi_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvo_uapsd (1): %d\n"), pFrm->QOSCapsStation.acvo_uapsd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("RRMEnabledCap:\n"));
        if (!pFrm->RRMEnabledCap.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("LinkMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LinkMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("NeighborRpt (1): %d\n"), pFrm->RRMEnabledCap.NeighborRpt);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("parallel (1): %d\n"), pFrm->RRMEnabledCap.parallel);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("repeated (1): %d\n"), pFrm->RRMEnabledCap.repeated);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("BeaconPassive (1): %d\n"), pFrm->RRMEnabledCap.BeaconPassive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("BeaconActive (1): %d\n"), pFrm->RRMEnabledCap.BeaconActive);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("BeaconTable (1): %d\n"), pFrm->RRMEnabledCap.BeaconTable);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("BeaconRepCond (1): %d\n"), pFrm->RRMEnabledCap.BeaconRepCond);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("FrameMeasurement (1): %d\n"), pFrm->RRMEnabledCap.FrameMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("ChannelLoad (1): %d\n"), pFrm->RRMEnabledCap.ChannelLoad);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("NoiseHistogram (1): %d\n"), pFrm->RRMEnabledCap.NoiseHistogram);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("statistics (1): %d\n"), pFrm->RRMEnabledCap.statistics);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("LCIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.LCIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("LCIAzimuth (1): %d\n"), pFrm->RRMEnabledCap.LCIAzimuth);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("TCMCapability (1): %d\n"), pFrm->RRMEnabledCap.TCMCapability);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("triggeredTCM (1): %d\n"), pFrm->RRMEnabledCap.triggeredTCM);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("APChanReport (1): %d\n"), pFrm->RRMEnabledCap.APChanReport);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("RRMMIBEnabled (1): %d\n"), pFrm->RRMEnabledCap.RRMMIBEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("operatingChanMax (3): %d\n"), pFrm->RRMEnabledCap.operatingChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("nonOperatinChanMax (3): %d\n"), pFrm->RRMEnabledCap.nonOperatinChanMax);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("MeasurementPilot (3): %d\n"), pFrm->RRMEnabledCap.MeasurementPilot);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("MeasurementPilotEnabled (1): %d\n"), pFrm->RRMEnabledCap.MeasurementPilotEnabled);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("NeighborTSFOffset (1): %d\n"), pFrm->RRMEnabledCap.NeighborTSFOffset);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("RCPIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RCPIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("RSNIMeasurement (1): %d\n"), pFrm->RRMEnabledCap.RSNIMeasurement);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("BssAvgAccessDelay (1): %d\n"), pFrm->RRMEnabledCap.BssAvgAccessDelay);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("BSSAvailAdmission (1): %d\n"), pFrm->RRMEnabledCap.BSSAvailAdmission);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("AntennaInformation (1): %d\n"), pFrm->RRMEnabledCap.AntennaInformation);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved (6): %d\n"), pFrm->RRMEnabledCap.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("MobilityDomain:\n"));
        if (!pFrm->MobilityDomain.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->MobilityDomain.MDID, 2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("overDSCap (1): %d\n"), pFrm->MobilityDomain.overDSCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("resourceReqCap (1): %d\n"), pFrm->MobilityDomain.resourceReqCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved (6): %d\n"), pFrm->MobilityDomain.reserved);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("FTInfo:\n"));
        if (!pFrm->FTInfo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved (8): %d\n"), pFrm->FTInfo.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("IECount (8): %d\n"), pFrm->FTInfo.IECount);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->FTInfo.MIC, 16);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->FTInfo.Anonce, 32);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->FTInfo.Snonce, 32);
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("R1KH_ID:\n"));
            if (!pFrm->FTInfo.R1KH_ID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->FTInfo.R1KH_ID.PMK_R1_ID, 6);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("GTK:\n"));
            if (!pFrm->FTInfo.GTK.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("keyId (2): %d\n"), pFrm->FTInfo.GTK.keyId);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved (14): %d\n"), pFrm->FTInfo.GTK.reserved);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->FTInfo.GTK.keyLength, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->FTInfo.GTK.RSC, 8);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_key: %d.\n"), pFrm->FTInfo.GTK.num_key);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->FTInfo.GTK.key, pFrm->FTInfo.GTK.num_key);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("R0KH_ID:\n"));
            if (!pFrm->FTInfo.R0KH_ID.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_PMK_R0_ID: %d.\n"), pFrm->FTInfo.R0KH_ID.num_PMK_R0_ID);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->FTInfo.R0KH_ID.PMK_R0_ID, pFrm->FTInfo.R0KH_ID.num_PMK_R0_ID);
            }
        }
        for (i = 0; i < pFrm->num_RICDataDesc; ++i)
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("RICDataDesc[%d]:\n"), i);
            if (!pFrm->RICDataDesc[i].present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("RICData:\n"));
                if (!pFrm->RICDataDesc[i].RICData.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].RICData.Identifier, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].RICData.resourceDescCount, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].RICData.statusCode, 2);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("RICDescriptor:\n"));
                if (!pFrm->RICDataDesc[i].RICDescriptor.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].RICDescriptor.resourceType, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_variableData: %d.\n"), pFrm->RICDataDesc[i].RICDescriptor.num_variableData);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->RICDataDesc[i].RICDescriptor.variableData, pFrm->RICDataDesc[i].RICDescriptor.num_variableData);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("TSPEC:\n"));
                if (!pFrm->RICDataDesc[i].TSPEC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("traffic_type (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.traffic_type);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].TSPEC.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].TSPEC.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("access_policy (2): %d\n"), pFrm->RICDataDesc[i].TSPEC.access_policy);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("psb (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.psb);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("user_priority (3): %d\n"), pFrm->RICDataDesc[i].TSPEC.user_priority);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->RICDataDesc[i].TSPEC.tsinfo_ack_pol);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("schedule (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.schedule);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("unused (7): %d\n"), pFrm->RICDataDesc[i].TSPEC.unused);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("size (15): %d\n"), pFrm->RICDataDesc[i].TSPEC.size);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("fixed (1): %d\n"), pFrm->RICDataDesc[i].TSPEC.fixed);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.max_msdu_size, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.min_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.max_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.inactivity_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.suspension_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.min_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.mean_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.peak_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.burst_size, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.delay_bound, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.min_phy_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.surplus_bw_allowance, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSPEC.medium_time, 2);
                }
                for (i = 0; i < pFrm->RICDataDesc[i].num_TCLAS; ++i)
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("TCLAS[%d]:\n"), i);
                    if (!pFrm->RICDataDesc[i].TCLAS[i].present)
                    {
                        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                    }
                    else
                    {
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].user_priority, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].classifier_type, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].classifier_mask, 1);
                        switch (pFrm->RICDataDesc[i].TCLAS[i].classifier_type)
                        {
                            case 0:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.EthParams.source, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.EthParams.dest, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.EthParams.type, 2);
                            break;
                            case 1:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.version, 1);
                                switch (pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.version)
                                {
                                    case 4:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.source, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.dest, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.DSCP, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.proto, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV4Params.reserved, 1);
                                    break;
                                    case 6:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.source, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.dest, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.IpParams.params.IpV6Params.flow_label, 3);
                                    break;
                                }
                            break;
                            case 2:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLAS[i].info.Params8021dq.tag_type, 2);
                            break;
                        }
                    }
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("TCLASSPROC:\n"));
                if (!pFrm->RICDataDesc[i].TCLASSPROC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TCLASSPROC.processing, 1);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("TSDelay:\n"));
                if (!pFrm->RICDataDesc[i].TSDelay.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].TSDelay.delay, 4);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Schedule:\n"));
                if (!pFrm->RICDataDesc[i].Schedule.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].Schedule.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].Schedule.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].Schedule.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved (9): %d\n"), pFrm->RICDataDesc[i].Schedule.reserved);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.service_interval, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.max_service_dur, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].Schedule.spec_interval, 2);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("WMMTSPEC:\n"));
                if (!pFrm->RICDataDesc[i].WMMTSPEC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.version, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("traffic_type (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.traffic_type);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("access_policy (2): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.access_policy);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("psb (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.psb);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("user_priority (3): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.user_priority);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("tsinfo_ack_pol (2): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.tsinfo_ack_pol);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("tsinfo_rsvd (7): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.tsinfo_rsvd);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("burst_size_defn (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.burst_size_defn);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("size (15): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.size);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("fixed (1): %d\n"), pFrm->RICDataDesc[i].WMMTSPEC.fixed);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.max_msdu_size, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.min_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.max_service_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.inactivity_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.suspension_int, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.min_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.mean_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.peak_data_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.burst_size, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.delay_bound, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.min_phy_rate, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.surplus_bw_allowance, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSPEC.medium_time, 2);
                }
                for (i = 0; i < pFrm->RICDataDesc[i].num_WMMTCLAS; ++i)
                {
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("WMMTCLAS[%d]:\n"), i);
                    if (!pFrm->RICDataDesc[i].WMMTCLAS[i].present)
                    {
                        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                    }
                    else
                    {
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].version, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].user_priority, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].classifier_type, 1);
                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].classifier_mask, 1);
                        switch (pFrm->RICDataDesc[i].WMMTCLAS[i].classifier_type)
                        {
                            case 0:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.EthParams.source, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.EthParams.dest, 6);
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.EthParams.type, 2);
                            break;
                            case 1:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.version, 1);
                                switch (pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.version)
                                {
                                    case 4:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.source, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.dest, 4);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.DSCP, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.proto, 1);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV4Params.reserved, 1);
                                    break;
                                    case 6:
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.source, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.dest, 16);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.src_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.dest_port, 2);
                                        FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.IpParams.params.IpV6Params.flow_label, 3);
                                    break;
                                }
                            break;
                            case 2:
                                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLAS[i].info.Params8021dq.tag_type, 2);
                            break;
                        }
                    }
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("WMMTCLASPROC:\n"));
                if (!pFrm->RICDataDesc[i].WMMTCLASPROC.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLASPROC.version, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTCLASPROC.processing, 1);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("WMMTSDelay:\n"));
                if (!pFrm->RICDataDesc[i].WMMTSDelay.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSDelay.version, 1);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMTSDelay.delay, 4);
                }
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("WMMSchedule:\n"));
                if (!pFrm->RICDataDesc[i].WMMSchedule.present)
                {
                    FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
                }
                else
                {
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.version, 1);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("aggregation (1): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.aggregation);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("tsid (4): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.tsid);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("direction (2): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.direction);
                    FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved (9): %d\n"), pFrm->RICDataDesc[i].WMMSchedule.reserved);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.service_start_time, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.service_interval, 4);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.max_service_dur, 2);
                    FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->RICDataDesc[i].WMMSchedule.spec_interval, 2);
                }
            }
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("WPAOpaque:\n"));
        if (!pFrm->WPAOpaque.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_data: %d.\n"), pFrm->WPAOpaque.num_data);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->WPAOpaque.data, pFrm->WPAOpaque.num_data);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("HTCaps:\n"));
        if (!pFrm->HTCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("advCodingCap (1): %d\n"), pFrm->HTCaps.advCodingCap);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("supportedChannelWidthSet (1): %d\n"), pFrm->HTCaps.supportedChannelWidthSet);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("mimoPowerSave (2): %d\n"), pFrm->HTCaps.mimoPowerSave);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("greenField (1): %d\n"), pFrm->HTCaps.greenField);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("shortGI20MHz (1): %d\n"), pFrm->HTCaps.shortGI20MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("shortGI40MHz (1): %d\n"), pFrm->HTCaps.shortGI40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("txSTBC (1): %d\n"), pFrm->HTCaps.txSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("rxSTBC (2): %d\n"), pFrm->HTCaps.rxSTBC);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("delayedBA (1): %d\n"), pFrm->HTCaps.delayedBA);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("maximalAMSDUsize (1): %d\n"), pFrm->HTCaps.maximalAMSDUsize);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("dsssCckMode40MHz (1): %d\n"), pFrm->HTCaps.dsssCckMode40MHz);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("psmp (1): %d\n"), pFrm->HTCaps.psmp);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("stbcControlFrame (1): %d\n"), pFrm->HTCaps.stbcControlFrame);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("lsigTXOPProtection (1): %d\n"), pFrm->HTCaps.lsigTXOPProtection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("maxRxAMPDUFactor (2): %d\n"), pFrm->HTCaps.maxRxAMPDUFactor);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("mpduDensity (3): %d\n"), pFrm->HTCaps.mpduDensity);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved1 (3): %d\n"), pFrm->HTCaps.reserved1);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->HTCaps.supportedMCSSet, 16);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("pco (1): %d\n"), pFrm->HTCaps.pco);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("transitionTime (2): %d\n"), pFrm->HTCaps.transitionTime);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved2 (5): %d\n"), pFrm->HTCaps.reserved2);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("mcsFeedback (2): %d\n"), pFrm->HTCaps.mcsFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved3 (6): %d\n"), pFrm->HTCaps.reserved3);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("txBF (1): %d\n"), pFrm->HTCaps.txBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("rxStaggeredSounding (1): %d\n"), pFrm->HTCaps.rxStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("txStaggeredSounding (1): %d\n"), pFrm->HTCaps.txStaggeredSounding);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("rxZLF (1): %d\n"), pFrm->HTCaps.rxZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("txZLF (1): %d\n"), pFrm->HTCaps.txZLF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("implicitTxBF (1): %d\n"), pFrm->HTCaps.implicitTxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("calibration (2): %d\n"), pFrm->HTCaps.calibration);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("explicitCSITxBF (1): %d\n"), pFrm->HTCaps.explicitCSITxBF);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("explicitUncompressedSteeringMatrix (1): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrix);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("explicitBFCSIFeedback (3): %d\n"), pFrm->HTCaps.explicitBFCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("explicitUncompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitUncompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("explicitCompressedSteeringMatrixFeedback (3): %d\n"), pFrm->HTCaps.explicitCompressedSteeringMatrixFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("csiNumBFAntennae (2): %d\n"), pFrm->HTCaps.csiNumBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("uncompressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.uncompressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("compressedSteeringMatrixBFAntennae (2): %d\n"), pFrm->HTCaps.compressedSteeringMatrixBFAntennae);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved4 (7): %d\n"), pFrm->HTCaps.reserved4);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("antennaSelection (1): %d\n"), pFrm->HTCaps.antennaSelection);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("explicitCSIFeedbackTx (1): %d\n"), pFrm->HTCaps.explicitCSIFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("antennaIndicesFeedbackTx (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedbackTx);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("explicitCSIFeedback (1): %d\n"), pFrm->HTCaps.explicitCSIFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("antennaIndicesFeedback (1): %d\n"), pFrm->HTCaps.antennaIndicesFeedback);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("rxAS (1): %d\n"), pFrm->HTCaps.rxAS);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("txSoundingPPDUs (1): %d\n"), pFrm->HTCaps.txSoundingPPDUs);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved5 (1): %d\n"), pFrm->HTCaps.reserved5);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_rsvd: %d.\n"), pFrm->HTCaps.num_rsvd);
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->HTCaps.rsvd, pFrm->HTCaps.num_rsvd);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("WMMCaps:\n"));
        if (!pFrm->WMMCaps.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->WMMCaps.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved (4): %d\n"), pFrm->WMMCaps.reserved);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("qack (1): %d\n"), pFrm->WMMCaps.qack);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("queue_request (1): %d\n"), pFrm->WMMCaps.queue_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("txop_request (1): %d\n"), pFrm->WMMCaps.txop_request);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("more_ack (1): %d\n"), pFrm->WMMCaps.more_ack);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("WMMInfoStation:\n"));
        if (!pFrm->WMMInfoStation.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->WMMInfoStation.version, 1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvo_uapsd (1): %d\n"), pFrm->WMMInfoStation.acvo_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvi_uapsd (1): %d\n"), pFrm->WMMInfoStation.acvi_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbk_uapsd (1): %d\n"), pFrm->WMMInfoStation.acbk_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbe_uapsd (1): %d\n"), pFrm->WMMInfoStation.acbe_uapsd);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved1 (1): %d\n"), pFrm->WMMInfoStation.reserved1);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("max_sp_length (2): %d\n"), pFrm->WMMInfoStation.max_sp_length);
            FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("reserved2 (1): %d\n"), pFrm->WMMInfoStation.reserved2);
        }
        FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Airgo:\n"));
        if (!pFrm->Airgo.present)
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
        }
        else
        {
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("PropSuppRates:\n"));
            if (!pFrm->Airgo.PropSuppRates.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_rates: %d.\n"), pFrm->Airgo.PropSuppRates.num_rates);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->Airgo.PropSuppRates.rates, pFrm->Airgo.PropSuppRates.num_rates);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("APName:\n"));
            if (!pFrm->Airgo.APName.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_name: %d.\n"), pFrm->Airgo.APName.num_name);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->Airgo.APName.name, pFrm->Airgo.APName.num_name);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("HCF:\n"));
            if (!pFrm->Airgo.HCF.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.HCF.enabled, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("WDS:\n"));
            if (!pFrm->Airgo.WDS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_wdsData: %d.\n"), pFrm->Airgo.WDS.num_wdsData);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->Airgo.WDS.wdsData, pFrm->Airgo.WDS.num_wdsData);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("BPIndicator:\n"));
            if (!pFrm->Airgo.BPIndicator.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.BPIndicator.indicator, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.BPIndicator.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("LoadInfo:\n"));
            if (!pFrm->Airgo.LoadInfo.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.LoadInfo.num_stas, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.LoadInfo.channel_util, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("LoadBalance:\n"));
            if (!pFrm->Airgo.LoadBalance.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.LoadBalance.bssid, 6);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.LoadBalance.channel, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("PropAssocType:\n"));
            if (!pFrm->Airgo.PropAssocType.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropAssocType.type, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("LLAttr:\n"));
            if (!pFrm->Airgo.LLAttr.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.LLAttr.defer_threshold, 4);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("PropCapability:\n"));
            if (!pFrm->Airgo.PropCapability.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropCapability.capability, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Version:\n"));
            if (!pFrm->Airgo.Version.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Version.chip_rev, 4);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Version.card_type, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("num_build_version: %d.\n"), pFrm->Airgo.Version.num_build_version);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* ) pFrm->Airgo.Version.build_version, pFrm->Airgo.Version.num_build_version);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("PropEDCAParams:\n"));
            if (!pFrm->Airgo.PropEDCAParams.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.qos, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.reserved, 1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbe_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbe_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbe_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("unused1 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused1);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbe_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbe_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbe_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbe_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbk_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbk_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbk_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("unused2 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbk_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acbk_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acbk_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acbk_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvi_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvi_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvi_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("unused3 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused3);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvi_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvi_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvi_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvi_txoplimit, 2);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvo_aifsn (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aifsn);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvo_acm (1): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_acm);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvo_aci (2): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_aci);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("unused4 (1): %d\n"), pFrm->Airgo.PropEDCAParams.unused4);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvo_min (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_min);
                FRAMES_LOG1(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("acvo_max (4): %d\n"), pFrm->Airgo.PropEDCAParams.acvo_max);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropEDCAParams.acvo_txoplimit, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Titan:\n"));
            if (!pFrm->Airgo.Titan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Titan.concat_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Titan.compression_tcid_bitmap, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Titan.cb_state, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.Titan.rev_fcs_state, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("PropChannSwitchAnn:\n"));
            if (!pFrm->Airgo.PropChannSwitchAnn.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.mode, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.primary_channel, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.sub_band, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropChannSwitchAnn.channel_switch_count, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("PropQuietBSS:\n"));
            if (!pFrm->Airgo.PropQuietBSS.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_count, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_period, 1);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_duration, 2);
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.PropQuietBSS.quiet_offset, 2);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("TriggerStaBgScan:\n"));
            if (!pFrm->Airgo.TriggerStaBgScan.present)
            {
                FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Not present.\n"));
            }
            else
            {
                FRAMES_DUMP(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), ( tANI_U8* )&pFrm->Airgo.TriggerStaBgScan.enable, 1);
            }
            FRAMES_LOG0(pCtx, FRAMES_SEV_FOR_FRAME(pCtx, DOT11F_REASSOCREQUEST), FRFL("Taurus:\n"));
            if (!pFrm->Airgo.Taurus.present)
            {
    