/*
 * This file contains the table of syscall-handling functions.
 *    Copyright (C) 1995-1996 Gary Thomas (gdt@linuxppc.org)
 *
 * Largely rewritten by Cort Dougan (cort@cs.nmt.edu)
 * and Paul Mackerras.
 *
 * Adapted for iSeries by Mike Corrigan (mikejc@us.ibm.com)
 * PPC64 updates by Dave Engebretsen (engebret@us.ibm.com) 
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <linux/config.h>
#include <asm/ppc_asm.h>

#ifdef CONFIG_PPC64
#define SYSCALL(func)		.llong	.sys_##func,.sys_##func
#define SYSCALL32(func)		.llong	.sys_##func,.sys32_##func
#define COMPAT_SYS(func)	.llong	.sys_##func,.compat_sys_##func
#define PPC_SYS(func)		.llong	.ppc_##func,.ppc_##func
#define OLDSYS(func)		.llong	.sys_ni_syscall,.sys_ni_syscall
#define SYS32ONLY(func)		.llong	.sys_ni_syscall,.sys32_##func
#define SYSX(f, f3264, f32)	.llong	.f,.f3264
#else
#define SYSCALL(func)		.long	sys_##func
#define SYSCALL32(func)		.long	sys_##func
#define COMPAT_SYS(func)	.long	sys_##func
#define PPC_SYS(func)		.long	ppc_##func
#define OLDSYS(func)		.long	sys_##func
#define SYS32ONLY(func)		.long	sys_##func
#define SYSX(f, f3264, f32)	.long	f32
#endif

#ifdef CONFIG_PPC64
#define sys_sigpending	sys_ni_syscall
#define sys_old_getrlimit sys_ni_syscall
#else
#define ppc_rtas	sys_ni_syscall
#endif

_GLOBAL(sys_call_table)
SYSCALL(restart_syscall)
SYSCALL(exit)
PPC_SYS(fork)
SYSCALL(read)
SYSCALL(write)
COMPAT_SYS(open)
SYSCALL(close)
SYSCALL32(waitpid)
SYSCALL32(creat)
SYSCALL(link)
SYSCALL(unlink)
SYSCALL32(execve)
SYSCALL(chdir)
SYSX(sys64_time,compat_sys_time,sys_time)
SYSCALL(mknod)
SYSCALL(chmod)
SYSCALL(lchown)
SYSCALL(ni_syscall)
OLDSYS(stat)
SYSX(sys_lseek,ppc32_lseek,sys_lseek)
SYSCALL(getpid)
COMPAT_SYS(mount)
SYSX(sys_ni_syscall,sys_oldumount,sys_oldumount)
SYSCALL(setuid)
SYSCALL(getuid)
COMPAT_SYS(stime)
SYSCALL32(ptrace)
SYSCALL(alarm)
OLDSYS(fstat)
SYSCALL32(pause)
COMPAT_SYS(utime)
SYSCALL(ni_syscall)
SYSCALL(ni_syscall)
SYSCALL32(access)
SYSCALL32(nice)
SYSCALL(ni_syscall)
SYSCALL(sync)
SYSCALL32(kill)
SYSCALL(rename)
SYSCALL32(mkdir)
SYSCALL(rmdir)
SYSCALL(dup)
SYSCALL(pipe)
COMPAT_SYS(times)
SYSCALL(ni_syscall)
SYSCALL(brk)
SYSCALL(setgid)
SYSCALL(getgid)
SYSCALL(signal)
SYSCALL(geteuid)
SYSCALL(getegid)
SYSCALL(acct)
SYSCALL(umount)
SYSCALL(ni_syscall)
COMPAT_SYS(ioctl)
COMPAT_SYS(fcntl)
SYSCALL(ni_syscall)
SYSCALL32(setpgid)
SYSCALL(ni_syscall)
SYS32ONLY(olduname)
SYSCALL32(umask)
SYSCALL(chroot)
SYSCALL(ustat)
SYSCALL(dup2)
SYSCALL(getppid)
SYSCALL(getpgrp)
SYSCALL(setsid)
SYS32ONLY(sigaction)
SYSCALL(sgetmask)
SYSCALL32(ssetmask)
SYSCALL(setreuid)
SYSCALL(setregid)
SYSX(sys_ni_syscall,ppc32_sigsuspend,ppc_sigsuspend)
COMPAT_SYS(sigpending)
SYSCALL32(sethostname)
COMPAT_SYS(setrlimit)
COMPAT_SYS(old_getrlimit)
COMPAT_SYS(getrusage)
SYSCALL32(gettimeofday)
SYSCALL32(settimeofday)
SYSCALL32(getgroups)
SYSCALL32(setgroups)
SYSX(sys_ni_syscall,sys_ni_syscall,ppc_select)
SYSCALL(symlink)
OLDSYS(lstat)
SYSCALL32(readlink)
SYSCALL(uselib)
SYSCALL(swapon)
SYSCALL(reboot)
SYSX(sys_ni_syscall,old32_readdir,old_readdir)
SYSCALL(mmap)
SYSCALL(munmap)
SYSCALL(truncate)
SYSCALL(ftruncate)
SYSCALL(fchmod)
SYSCALL(fchown)
SYSCALL32(getpriority)
SYSCALL32(setpriority)
SYSCALL(ni_syscall)
COMPAT_SYS(statfs)
COMPAT_SYS(fstatfs)
SYSCALL(ni_syscall)
COMPAT_SYS(socketcall)
SYSCALL32(syslog)
COMPAT_SYS(setitimer)
COMPAT_SYS(getitimer)
COMPAT_SYS(newstat)
COMPAT_SYS(newlstat)
COMPAT_SYS(newfstat)
SYSX(sys_ni_syscall,sys32_uname,sys_uname)
SYSCALL(ni_syscall)
SYSCALL(vhangup)
SYSCALL(ni_syscall)
SYSCALL(ni_syscall)
COMPAT_SYS(wait4)
SYSCALL(swapoff)
SYSCALL32(sysinfo)
SYSCALL32(ipc)
SYSCALL(fsync)
SYSX(sys_ni_syscall,ppc32_sigreturn,sys_sigreturn)
PPC_SYS(clone)
SYSCALL32(setdomainname)
SYSX(ppc64_newuname,ppc64_newuname,sys_newuname)
SYSCALL(ni_syscall)
SYSCALL32(adjtimex)
SYSCALL(mprotect)
SYSX(sys_ni_syscall,compat_sys_sigprocmask,sys_sigprocmask)
SYSCALL(ni_syscall)
SYSCALL(init_module)
SYSCALL(delete_module)
SYSCALL(ni_syscall)
SYSCALL(quotactl)
SYSCALL32(getpgid)
SYSCALL(fchdir)
SYSCALL(bdflush)
SYSCALL32(sysfs)
SYSX(ppc64_personality,ppc64_personality,sys_personality)
SYSCALL(ni_syscall)
SYSCALL(setfsuid)
SYSCALL(setfsgid)
SYSCALL(llseek)
SYSCALL32(getdents)
SYSX(sys_select,ppc32_select,ppc_select)
SYSCALL(flock)
SYSCALL(msync)
COMPAT_SYS(readv)
COMPAT_SYS(writev)
SYSCALL32(getsid)
SYSCALL(fdatasync)
SYSCALL32(sysctl)
SYSCALL(mlock)
SYSCALL(munlock)
SYSCALL(mlockall)
SYSCALL(munlockall)
SYSCALL32(sched_setparam)
SYSCALL32(sched_getparam)
SYSCALL32(sched_setscheduler)
SYSCALL32(sched_getscheduler)
SYSCALL(sched_yield)
SYSCALL32(sched_get_priority_max)
SYSCALL32(sched_get_priority_min)
SYSCALL32(sched_rr_get_interval)
COMPAT_SYS(nanosleep)
SYSCALL(mremap)
SYSCALL(setresuid)
SYSCALL(getresuid)
SYSCALL(ni_syscall)
SYSCALL(poll)
COMPAT_SYS(nfsservctl)
SYSCALL(setresgid)
SYSCALL(getresgid)
SYSCALL32(prctl)
SYSX(ppc64_rt_sigreturn,ppc32_rt_sigreturn,sys_rt_sigreturn)
SYSCALL32(rt_sigaction)
SYSCALL32(rt_sigprocmask)
SYSCALL32(rt_sigpending)
COMPAT_SYS(rt_sigtimedwait)
SYSCALL32(rt_sigqueueinfo)
SYSX(ppc64_rt_sigsuspend,ppc32_rt_sigsuspend,ppc_rt_sigsuspend)
SYSCALL32(pread64)
SYSCALL32(pwrite64)
SYSCALL(chown)
SYSCALL(getcwd)
SYSCALL(capget)
SYSCALL(capset)
SYSCALL32(sigaltstack)
SYSX(sys_sendfile64,sys32_sendfile,sys_sendfile)
SYSCALL(ni_syscall)
SYSCALL(ni_syscall)
PPC_SYS(vfork)
COMPAT_SYS(getrlimit)
SYSCALL32(readahead)
SYS32ONLY(mmap2)
SYS32ONLY(truncate64)
SYS32ONLY(ftruncate64)
SYSX(sys_ni_syscall,sys_stat64,sys_stat64)
SYSX(sys_ni_syscall,sys_lstat64,sys_lstat64)
SYSX(sys_ni_syscall,sys_fstat64,sys_fstat64)
SYSCALL32(pciconfig_read)
SYSCALL32(pciconfig_write)
SYSCALL32(pciconfig_iobase)
SYSCALL(ni_syscall)
SYSCALL(getdents64)
SYSCALL(pivot_root)
SYSX(sys_ni_syscall,compat_sys_fcntl64,sys_fcntl64)
SYSCALL(madvise)
SYSCALL(mincore)
SYSCALL(gettid)
SYSCALL(tkill)
SYSCALL(setxattr)
SYSCALL(lsetxattr)
SYSCALL(fsetxattr)
SYSCALL(getxattr)
SYSCALL(lgetxattr)
SYSCALL(fgetxattr)
SYSCALL(listxattr)
SYSCALL(llistxattr)
SYSCALL(flistxattr)
SYSCALL(removexattr)
SYSCALL(lremovexattr)
SYSCALL(fremovexattr)
COMPAT_SYS(futex)
COMPAT_SYS(sched_setaffinity)
COMPAT_SYS(sched_getaffinity)
SYSCALL(ni_syscall)
SYSCALL(ni_syscall)
SYS32ONLY(sendfile64)
COMPAT_SYS(io_setup)
SYSCALL(io_destroy)
COMPAT_SYS(io_getevents)
COMPAT_SYS(io_submit)
SYSCALL(io_cancel)
SYSCALL(set_tid_address)
SYSX(sys_fadvise64,ppc32_fadvise64,sys_fadvise64)
SYSCALL(exit_group)
SYSX(sys_lookup_dcookie,ppc32_lookup_dcookie,sys_lookup_dcookie)
SYSCALL(epoll_create)
SYSCALL(epoll_ctl)
SYSCALL(epoll_wait)
SYSCALL(remap_file_pages)
SYSX(sys_timer_create,ppc32_timer_create,sys_timer_create)
COMPAT_SYS(timer_settime)
COMPAT_SYS(timer_gettime)
SYSCALL(timer_getoverrun)
SYSCALL(timer_delete)
COMPAT_SYS(clock_settime)
COMPAT_SYS(clock_gettime)
COMPAT_SYS(clock_getres)
COMPAT_SYS(clock_nanosleep)
SYSX(ppc64_swapcontext,ppc32_swapcontext,ppc_swapcontext)
SYSCALL32(tgkill)
SYSCALL32(utimes)
COMPAT_SYS(statfs64)
COMPAT_SYS(fstatfs64)
SYSX(sys_ni_syscall, ppc32_fadvise64_64, sys_fadvise64_64)
PPC_SYS(rtas)
OLDSYS(debug_setcontext)
SYSCALL(ni_syscall)
SYSCALL(ni_syscall)
COMPAT_SYS(mbind)
COMPAT_SYS(get_mempolicy)
COMPAT_SYS(set_mempolicy)
COMPAT_SYS(mq_open)
SYSCALL(mq_unlink)
COMPAT_SYS(mq_timedsend)
COMPAT_SYS(mq_timedreceive)
COMPAT_SYS(mq_notify)
COMPAT_SYS(mq_getsetattr)
COMPAT_SYS(kexec_load)
SYSCALL32(add_key)
SYSCALL32(request_key)
COMPAT_SYS(keyctl)
COMPAT_SYS(waitid)
SYSCALL32(ioprio_set)
SYSCALL32(ioprio_get)
SYSCALL(inotify_init)
SYSCALL(inotify_add_watch)
SYSCALL(inotify_rm_watch)
