/*

  Broadcom B43 wireless driver
  IEEE 802.11n PHY and radio device data tables

  Copyright (c) 2008 Michael Buesch <mb@bu3sch.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
  Boston, MA 02110-1301, USA.

*/

#include "b43.h"
#include "radio_2055.h"
#include "phy_common.h"

struct b2055_inittab_entry {
	/* Value to write if we use the 5GHz band. */
	u16 ghz5;
	/* Value to write if we use the 2.4GHz band. */
	u16 ghz2;
	/* Flags */
	u8 flags;
#define B2055_INITTAB_ENTRY_OK	0x01
#define B2055_INITTAB_UPLOAD	0x02
};
#define UPLOAD		.flags = B2055_INITTAB_ENTRY_OK | B2055_INITTAB_UPLOAD
#define NOUPLOAD	.flags = B2055_INITTAB_ENTRY_OK

static const struct b2055_inittab_entry b2055_inittab [] = {
  [B2055_SP_PINPD]		= { .ghz5 = 0x0080, .ghz2 = 0x0080, NOUPLOAD, },
  [B2055_C1_SP_RSSI]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_SP_PDMISC]		= { .ghz5 = 0x0027, .ghz2 = 0x0027, NOUPLOAD, },
  [B2055_C2_SP_RSSI]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_SP_PDMISC]		= { .ghz5 = 0x0027, .ghz2 = 0x0027, NOUPLOAD, },
  [B2055_C1_SP_RXGC1]		= { .ghz5 = 0x007F, .ghz2 = 0x007F, UPLOAD, },
  [B2055_C1_SP_RXGC2]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, UPLOAD, },
  [B2055_C2_SP_RXGC1]		= { .ghz5 = 0x007F, .ghz2 = 0x007F, UPLOAD, },
  [B2055_C2_SP_RXGC2]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, UPLOAD, },
  [B2055_C1_SP_LPFBWSEL]	= { .ghz5 = 0x0015, .ghz2 = 0x0015, NOUPLOAD, },
  [B2055_C2_SP_LPFBWSEL]	= { .ghz5 = 0x0015, .ghz2 = 0x0015, NOUPLOAD, },
  [B2055_C1_SP_TXGC1]		= { .ghz5 = 0x004F, .ghz2 = 0x004F, UPLOAD, },
  [B2055_C1_SP_TXGC2]		= { .ghz5 = 0x0005, .ghz2 = 0x0005, UPLOAD, },
  [B2055_C2_SP_TXGC1]		= { .ghz5 = 0x004F, .ghz2 = 0x004F, UPLOAD, },
  [B2055_C2_SP_TXGC2]		= { .ghz5 = 0x0005, .ghz2 = 0x0005, UPLOAD, },
  [B2055_MASTER1]		= { .ghz5 = 0x00D0, .ghz2 = 0x00D0, NOUPLOAD, },
  [B2055_MASTER2]		= { .ghz5 = 0x0002, .ghz2 = 0x0002, NOUPLOAD, },
  [B2055_PD_LGEN]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_PD_PLLTS]		= { .ghz5 = 0x0040, .ghz2 = 0x0040, NOUPLOAD, },
  [B2055_C1_PD_LGBUF]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_PD_TX]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_PD_RXTX]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_PD_RSSIMISC]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_PD_LGBUF]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_PD_TX]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_PD_RXTX]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_PD_RSSIMISC]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_PWRDET_LGEN]		= { .ghz5 = 0x00C0, .ghz2 = 0x00C0, NOUPLOAD, },
  [B2055_C1_PWRDET_LGBUF]	= { .ghz5 = 0x00FF, .ghz2 = 0x00FF, NOUPLOAD, },
  [B2055_C1_PWRDET_RXTX]	= { .ghz5 = 0x00C0, .ghz2 = 0x00C0, NOUPLOAD, },
  [B2055_C2_PWRDET_LGBUF]	= { .ghz5 = 0x00FF, .ghz2 = 0x00FF, NOUPLOAD, },
  [B2055_C2_PWRDET_RXTX]	= { .ghz5 = 0x00C0, .ghz2 = 0x00C0, NOUPLOAD, },
  [B2055_RRCCAL_CS]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_RRCCAL_NOPTSEL]	= { .ghz5 = 0x002C, .ghz2 = 0x002C, NOUPLOAD, },
  [B2055_CAL_MISC]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_COUT]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_COUT2]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_CVARCTL]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_RVARCTL]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_LPOCTL]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_TS]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_RCCALRTS]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_CAL_RCALRTS]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_PADDRV]		= { .ghz5 = 0x00A4, .ghz2 = 0x00A4, NOUPLOAD, },
  [B2055_XOCTL1]		= { .ghz5 = 0x0038, .ghz2 = 0x0038, NOUPLOAD, },
  [B2055_XOCTL2]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_XOREGUL]		= { .ghz5 = 0x0004, .ghz2 = 0x0004, UPLOAD, },
  [B2055_XOMISC]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_PLL_LFC1]		= { .ghz5 = 0x000A, .ghz2 = 0x000A, NOUPLOAD, },
  [B2055_PLL_CALVTH]		= { .ghz5 = 0x0087, .ghz2 = 0x0087, NOUPLOAD, },
  [B2055_PLL_LFC2]		= { .ghz5 = 0x0009, .ghz2 = 0x0009, NOUPLOAD, },
  [B2055_PLL_REF]		= { .ghz5 = 0x0070, .ghz2 = 0x0070, NOUPLOAD, },
  [B2055_PLL_LFR1]		= { .ghz5 = 0x0011, .ghz2 = 0x0011, NOUPLOAD, },
  [B2055_PLL_PFDCP]		= { .ghz5 = 0x0018, .ghz2 = 0x0018, UPLOAD, },
  [B2055_PLL_IDAC_CPOPAMP]	= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_PLL_CPREG]		= { .ghz5 = 0x0004, .ghz2 = 0x0004, UPLOAD, },
  [B2055_PLL_RCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_RF_PLLMOD0]		= { .ghz5 = 0x009E, .ghz2 = 0x009E, NOUPLOAD, },
  [B2055_RF_PLLMOD1]		= { .ghz5 = 0x0009, .ghz2 = 0x0009, NOUPLOAD, },
  [B2055_RF_MMDIDAC1]		= { .ghz5 = 0x00C8, .ghz2 = 0x00C8, UPLOAD, },
  [B2055_RF_MMDIDAC0]		= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_RF_MMDSP]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL1]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL2]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL3]		= { .ghz5 = 0x0001, .ghz2 = 0x0001, NOUPLOAD, },
  [B2055_VCO_CAL4]		= { .ghz5 = 0x0002, .ghz2 = 0x0002, NOUPLOAD, },
  [B2055_VCO_CAL5]		= { .ghz5 = 0x0096, .ghz2 = 0x0096, NOUPLOAD, },
  [B2055_VCO_CAL6]		= { .ghz5 = 0x003E, .ghz2 = 0x003E, NOUPLOAD, },
  [B2055_VCO_CAL7]		= { .ghz5 = 0x003E, .ghz2 = 0x003E, NOUPLOAD, },
  [B2055_VCO_CAL8]		= { .ghz5 = 0x0013, .ghz2 = 0x0013, NOUPLOAD, },
  [B2055_VCO_CAL9]		= { .ghz5 = 0x0002, .ghz2 = 0x0002, NOUPLOAD, },
  [B2055_VCO_CAL10]		= { .ghz5 = 0x0015, .ghz2 = 0x0015, NOUPLOAD, },
  [B2055_VCO_CAL11]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, NOUPLOAD, },
  [B2055_VCO_CAL12]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL13]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL14]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL15]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_CAL16]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_VCO_KVCO]		= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_VCO_CAPTAIL]		= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_VCO_IDACVCO]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_VCO_REG]		= { .ghz5 = 0x0084, .ghz2 = 0x0084, UPLOAD, },
  [B2055_PLL_RFVTH]		= { .ghz5 = 0x00C3, .ghz2 = 0x00C3, NOUPLOAD, },
  [B2055_LGBUF_CENBUF]		= { .ghz5 = 0x008F, .ghz2 = 0x008F, NOUPLOAD, },
  [B2055_LGEN_TUNE1]		= { .ghz5 = 0x00FF, .ghz2 = 0x00FF, NOUPLOAD, },
  [B2055_LGEN_TUNE2]		= { .ghz5 = 0x00FF, .ghz2 = 0x00FF, NOUPLOAD, },
  [B2055_LGEN_IDAC1]		= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_LGEN_IDAC2]		= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_LGEN_BIASC]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_LGEN_BIASIDAC]		= { .ghz5 = 0x00CC, .ghz2 = 0x00CC, NOUPLOAD, },
  [B2055_LGEN_RCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_LGEN_DIV]		= { .ghz5 = 0x0080, .ghz2 = 0x0080, NOUPLOAD, },
  [B2055_LGEN_SPARE2]		= { .ghz5 = 0x0080, .ghz2 = 0x0080, NOUPLOAD, },
  [B2055_C1_LGBUF_ATUNE]	= { .ghz5 = 0x00F8, .ghz2 = 0x00F8, NOUPLOAD, },
  [B2055_C1_LGBUF_GTUNE]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C1_LGBUF_DIV]		= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C1_LGBUF_AIDAC]	= { .ghz5 = 0x0088, .ghz2 = 0x0008, UPLOAD, },
  [B2055_C1_LGBUF_GIDAC]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C1_LGBUF_IDACFO]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_LGBUF_SPARE]	= { .ghz5 = 0x0001, .ghz2 = 0x0001, UPLOAD, },
  [B2055_C1_RX_RFSPC1]		= { .ghz5 = 0x008A, .ghz2 = 0x008A, NOUPLOAD, },
  [B2055_C1_RX_RFR1]		= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_C1_RX_RFR2]		= { .ghz5 = 0x0083, .ghz2 = 0x0083, NOUPLOAD, },
  [B2055_C1_RX_RFRCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C1_RX_BB_BLCMP]	= { .ghz5 = 0x00A0, .ghz2 = 0x00A0, NOUPLOAD, },
  [B2055_C1_RX_BB_LPF]		= { .ghz5 = 0x000A, .ghz2 = 0x000A, NOUPLOAD, },
  [B2055_C1_RX_BB_MIDACHP]	= { .ghz5 = 0x0087, .ghz2 = 0x0087, UPLOAD, },
  [B2055_C1_RX_BB_VGA1IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C1_RX_BB_VGA2IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C1_RX_BB_VGA3IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C1_RX_BB_BUFOCTL]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C1_RX_BB_RCCALCTL]	= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C1_RX_BB_RSSICTL1]	= { .ghz5 = 0x006A, .ghz2 = 0x006A, UPLOAD, },
  [B2055_C1_RX_BB_RSSICTL2]	= { .ghz5 = 0x00AB, .ghz2 = 0x00AB, UPLOAD, },
  [B2055_C1_RX_BB_RSSICTL3]	= { .ghz5 = 0x0013, .ghz2 = 0x0013, UPLOAD, },
  [B2055_C1_RX_BB_RSSICTL4]	= { .ghz5 = 0x00C1, .ghz2 = 0x00C1, UPLOAD, },
  [B2055_C1_RX_BB_RSSICTL5]	= { .ghz5 = 0x00AA, .ghz2 = 0x00AA, UPLOAD, },
  [B2055_C1_RX_BB_REG]		= { .ghz5 = 0x0087, .ghz2 = 0x0087, UPLOAD, },
  [B2055_C1_RX_BB_SPARE1]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_RX_TXBBRCAL]	= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C1_TX_RF_SPGA]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, NOUPLOAD, },
  [B2055_C1_TX_RF_SPAD]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, NOUPLOAD, },
  [B2055_C1_TX_RF_CNTPGA1]	= { .ghz5 = 0x0015, .ghz2 = 0x0015, NOUPLOAD, },
  [B2055_C1_TX_RF_CNTPAD1]	= { .ghz5 = 0x0055, .ghz2 = 0x0055, NOUPLOAD, },
  [B2055_C1_TX_RF_PGAIDAC]	= { .ghz5 = 0x0097, .ghz2 = 0x0097, UPLOAD, },
  [B2055_C1_TX_PGAPADTN]	= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_C1_TX_PADIDAC1]	= { .ghz5 = 0x0014, .ghz2 = 0x0014, UPLOAD, },
  [B2055_C1_TX_PADIDAC2]	= { .ghz5 = 0x0033, .ghz2 = 0x0033, NOUPLOAD, },
  [B2055_C1_TX_MXBGTRIM]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C1_TX_RF_RCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C1_TX_RF_PADTSSI1]	= { .ghz5 = 0x0003, .ghz2 = 0x0003, UPLOAD, },
  [B2055_C1_TX_RF_PADTSSI2]	= { .ghz5 = 0x000A, .ghz2 = 0x000A, NOUPLOAD, },
  [B2055_C1_TX_RF_SPARE]	= { .ghz5 = 0x0003, .ghz2 = 0x0003, UPLOAD, },
  [B2055_C1_TX_RF_IQCAL1]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C1_TX_RF_IQCAL2]	= { .ghz5 = 0x00A4, .ghz2 = 0x00A4, NOUPLOAD, },
  [B2055_C1_TXBB_RCCAL]		= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C1_TXBB_LPF1]		= { .ghz5 = 0x0028, .ghz2 = 0x0028, NOUPLOAD, },
  [B2055_C1_TX_VOSCNCL]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_TX_LPF_MXGMIDAC]	= { .ghz5 = 0x004A, .ghz2 = 0x004A, NOUPLOAD, },
  [B2055_C1_TX_BB_MXGM]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_LGBUF_ATUNE]	= { .ghz5 = 0x00F8, .ghz2 = 0x00F8, NOUPLOAD, },
  [B2055_C2_LGBUF_GTUNE]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C2_LGBUF_DIV]		= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C2_LGBUF_AIDAC]	= { .ghz5 = 0x0088, .ghz2 = 0x0008, UPLOAD, },
  [B2055_C2_LGBUF_GIDAC]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C2_LGBUF_IDACFO]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_LGBUF_SPARE]	= { .ghz5 = 0x0001, .ghz2 = 0x0001, UPLOAD, },
  [B2055_C2_RX_RFSPC1]		= { .ghz5 = 0x008A, .ghz2 = 0x008A, NOUPLOAD, },
  [B2055_C2_RX_RFR1]		= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_C2_RX_RFR2]		= { .ghz5 = 0x0083, .ghz2 = 0x0083, NOUPLOAD, },
  [B2055_C2_RX_RFRCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C2_RX_BB_BLCMP]	= { .ghz5 = 0x00A0, .ghz2 = 0x00A0, NOUPLOAD, },
  [B2055_C2_RX_BB_LPF]		= { .ghz5 = 0x000A, .ghz2 = 0x000A, NOUPLOAD, },
  [B2055_C2_RX_BB_MIDACHP]	= { .ghz5 = 0x0087, .ghz2 = 0x0087, UPLOAD, },
  [B2055_C2_RX_BB_VGA1IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C2_RX_BB_VGA2IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C2_RX_BB_VGA3IDAC]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C2_RX_BB_BUFOCTL]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C2_RX_BB_RCCALCTL]	= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C2_RX_BB_RSSICTL1]	= { .ghz5 = 0x006A, .ghz2 = 0x006A, UPLOAD, },
  [B2055_C2_RX_BB_RSSICTL2]	= { .ghz5 = 0x00AB, .ghz2 = 0x00AB, UPLOAD, },
  [B2055_C2_RX_BB_RSSICTL3]	= { .ghz5 = 0x0013, .ghz2 = 0x0013, UPLOAD, },
  [B2055_C2_RX_BB_RSSICTL4]	= { .ghz5 = 0x00C1, .ghz2 = 0x00C1, UPLOAD, },
  [B2055_C2_RX_BB_RSSICTL5]	= { .ghz5 = 0x00AA, .ghz2 = 0x00AA, UPLOAD, },
  [B2055_C2_RX_BB_REG]		= { .ghz5 = 0x0087, .ghz2 = 0x0087, UPLOAD, },
  [B2055_C2_RX_BB_SPARE1]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_RX_TXBBRCAL]	= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C2_TX_RF_SPGA]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, NOUPLOAD, },
  [B2055_C2_TX_RF_SPAD]		= { .ghz5 = 0x0007, .ghz2 = 0x0007, NOUPLOAD, },
  [B2055_C2_TX_RF_CNTPGA1]	= { .ghz5 = 0x0015, .ghz2 = 0x0015, NOUPLOAD, },
  [B2055_C2_TX_RF_CNTPAD1]	= { .ghz5 = 0x0055, .ghz2 = 0x0055, NOUPLOAD, },
  [B2055_C2_TX_RF_PGAIDAC]	= { .ghz5 = 0x0097, .ghz2 = 0x0097, UPLOAD, },
  [B2055_C2_TX_PGAPADTN]	= { .ghz5 = 0x0008, .ghz2 = 0x0008, NOUPLOAD, },
  [B2055_C2_TX_PADIDAC1]	= { .ghz5 = 0x0014, .ghz2 = 0x0014, UPLOAD, },
  [B2055_C2_TX_PADIDAC2]	= { .ghz5 = 0x0033, .ghz2 = 0x0033, NOUPLOAD, },
  [B2055_C2_TX_MXBGTRIM]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [B2055_C2_TX_RF_RCAL]		= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [B2055_C2_TX_RF_PADTSSI1]	= { .ghz5 = 0x0003, .ghz2 = 0x0003, UPLOAD, },
  [B2055_C2_TX_RF_PADTSSI2]	= { .ghz5 = 0x000A, .ghz2 = 0x000A, NOUPLOAD, },
  [B2055_C2_TX_RF_SPARE]	= { .ghz5 = 0x0003, .ghz2 = 0x0003, UPLOAD, },
  [B2055_C2_TX_RF_IQCAL1]	= { .ghz5 = 0x002A, .ghz2 = 0x002A, NOUPLOAD, },
  [B2055_C2_TX_RF_IQCAL2]	= { .ghz5 = 0x00A4, .ghz2 = 0x00A4, NOUPLOAD, },
  [B2055_C2_TXBB_RCCAL]		= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C2_TXBB_LPF1]		= { .ghz5 = 0x0028, .ghz2 = 0x0028, NOUPLOAD, },
  [B2055_C2_TX_VOSCNCL]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_TX_LPF_MXGMIDAC]	= { .ghz5 = 0x004A, .ghz2 = 0x004A, NOUPLOAD, },
  [B2055_C2_TX_BB_MXGM]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_PRG_GCHP21]		= { .ghz5 = 0x0071, .ghz2 = 0x0071, NOUPLOAD, },
  [B2055_PRG_GCHP22]		= { .ghz5 = 0x0072, .ghz2 = 0x0072, NOUPLOAD, },
  [B2055_PRG_GCHP23]		= { .ghz5 = 0x0073, .ghz2 = 0x0073, NOUPLOAD, },
  [B2055_PRG_GCHP24]		= { .ghz5 = 0x0074, .ghz2 = 0x0074, NOUPLOAD, },
  [B2055_PRG_GCHP25]		= { .ghz5 = 0x0075, .ghz2 = 0x0075, NOUPLOAD, },
  [B2055_PRG_GCHP26]		= { .ghz5 = 0x0076, .ghz2 = 0x0076, NOUPLOAD, },
  [B2055_PRG_GCHP27]		= { .ghz5 = 0x0077, .ghz2 = 0x0077, NOUPLOAD, },
  [B2055_PRG_GCHP28]		= { .ghz5 = 0x0078, .ghz2 = 0x0078, NOUPLOAD, },
  [B2055_PRG_GCHP29]		= { .ghz5 = 0x0079, .ghz2 = 0x0079, NOUPLOAD, },
  [B2055_PRG_GCHP30]		= { .ghz5 = 0x007A, .ghz2 = 0x007A, NOUPLOAD, },
  [0xC7]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xC8]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xC9]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xCA]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xCB]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xCC]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_LNA_GAINBST]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xCE]			= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [0xCF]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD0]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD1]			= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C1_B0NB_RSSIVCM]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [0xD3]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD4]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD5]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C1_GENSPARE2]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD7]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xD8]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_LNA_GAINBST]	= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xDA]			= { .ghz5 = 0x0006, .ghz2 = 0x0006, NOUPLOAD, },
  [0xDB]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xDC]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xDD]			= { .ghz5 = 0x0018, .ghz2 = 0x0018, NOUPLOAD, },
  [B2055_C2_B0NB_RSSIVCM]	= { .ghz5 = 0x0088, .ghz2 = 0x0088, NOUPLOAD, },
  [0xDF]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xE0]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [0xE1]			= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
  [B2055_C2_GENSPARE2]		= { .ghz5 = 0x0000, .ghz2 = 0x0000, NOUPLOAD, },
};

#define RADIOREGS(r0, r1, r2, r3, r4, r5, r6, r7, r8, r9, r10, r11, \
		  r12, r13, r14, r15, r16, r17, r18, r19, r20, r21) \
	.radio_pll_ref		= r0,	\
	.radio_rf_pllmod0	= r1,	\
	.radio_rf_pllmod1	= r2,	\
	.radio_vco_captail	= r3,	\
	.radio_vco_cal1		= r4,	\
	.radio_vco_cal2		= r5,	\
	.radio_pll_lfc1		= r6,	\
	.radio_pll_lfr1		= r7,	\
	.radio_pll_lfc2		= r8,	\
	.radio_lgbuf_cenbuf	= r9,	\
	.radio_lgen_tune1	= r10,	\
	.radio_lgen_tune2	= r11,	\
	.radio_c1_lgbuf_atune	= r12,	\
	.radio_c1_lgbuf_gtune	= r13,	\
	.radio_c1_rx_rfr1	= r14,	\
	.radio_c1_tx_pgapadtn	= r15,	\
	.radio_c1_tx_mxbgtrim	= r16,	\
	.radio_c2_lgbuf_atune	= r17,	\
	.radio_c2_lgbuf_gtune	= r18,	\
	.radio_c2_rx_rfr1	= r19,	\
	.radio_c2_tx_pgapadtn	= r20,	\
	.radio_c2_tx_mxbgtrim	= r21

#define PHYREGS(r0, r1, r2, r3, r4, r5)	\
	.phy_regs.phy_bw1a	= r0,	\
	.phy_regs.phy_bw2	= r1,	\
	.phy_regs.phy_bw3	= r2,	\
	.phy_regs.phy_bw4	= r3,	\
	.phy_regs.phy_bw5	= r4,	\
	.phy_regs.phy_bw6	= r5

static const struct b43_nphy_channeltab_entry_rev2 b43_nphy_channeltab_rev2[] = {
  {	.channel		= 184,
	.freq			= 4920, /* MHz */
	.unk2			= 3280,
	RADIOREGS(0x71, 0x01, 0xEC, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xB407, 0xB007, 0xAC07, 0x1402, 0x1502, 0x1602),
  },
  {	.channel		= 186,
	.freq			= 4930, /* MHz */
	.unk2			= 3287,
	RADIOREGS(0x71, 0x01, 0xED, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xFF, 0xFF, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xB807, 0xB407, 0xB007, 0x1302, 0x1402, 0x1502),
  },
  {	.channel		= 188,
	.freq			= 4940, /* MHz */
	.unk2			= 3293,
	RADIOREGS(0x71, 0x01, 0xEE, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xEE, 0xEE, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xBC07, 0xB807, 0xB407, 0x1202, 0x1302, 0x1402),
  },
  {	.channel		= 190,
	.freq			= 4950, /* MHz */
	.unk2			= 3300,
	RADIOREGS(0x71, 0x01, 0xEF, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xEE, 0xEE, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xC007, 0xBC07, 0xB807, 0x1102, 0x1202, 0x1302),
  },
  {	.channel		= 192,
	.freq			= 4960, /* MHz */
	.unk2			= 3307,
	RADIOREGS(0x71, 0x01, 0xF0, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xEE, 0xEE, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xC407, 0xC007, 0xBC07, 0x0F02, 0x1102, 0x1202),
  },
  {	.channel		= 194,
	.freq			= 4970, /* MHz */
	.unk2			= 3313,
	RADIOREGS(0x71, 0x01, 0xF1, 0x0F, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xEE, 0xEE, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xC807, 0xC407, 0xC007, 0x0E02, 0x0F02, 0x1102),
  },
  {	.channel		= 196,
	.freq			= 4980, /* MHz */
	.unk2			= 3320,
	RADIOREGS(0x71, 0x01, 0xF2, 0x0E, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xDD, 0xDD, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xCC07, 0xC807, 0xC407, 0x0D02, 0x0E02, 0x0F02),
  },
  {	.channel		= 198,
	.freq			= 4990, /* MHz */
	.unk2			= 3327,
	RADIOREGS(0x71, 0x01, 0xF3, 0x0E, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xDD, 0xDD, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xD007, 0xCC07, 0xC807, 0x0C02, 0x0D02, 0x0E02),
  },
  {	.channel		= 200,
	.freq			= 5000, /* MHz */
	.unk2			= 3333,
	RADIOREGS(0x71, 0x01, 0xF4, 0x0E, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xDD, 0xDD, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xD407, 0xD007, 0xCC07, 0x0B02, 0x0C02, 0x0D02),
  },
  {	.channel		= 202,
	.freq			= 5010, /* MHz */
	.unk2			= 3340,
	RADIOREGS(0x71, 0x01, 0xF5, 0x0E, 0xFF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xDD, 0xDD, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xD807, 0xD407, 0xD007, 0x0A02, 0x0B02, 0x0C02),
  },
  {	.channel		= 204,
	.freq			= 5020, /* MHz */
	.unk2			= 3347,
	RADIOREGS(0x71, 0x01, 0xF6, 0x0E, 0xF7, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xCC, 0xCC, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xDC07, 0xD807, 0xD407, 0x0902, 0x0A02, 0x0B02),
  },
  {	.channel		= 206,
	.freq			= 5030, /* MHz */
	.unk2			= 3353,
	RADIOREGS(0x71, 0x01, 0xF7, 0x0E, 0xF7, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xCC, 0xCC, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xE007, 0xDC07, 0xD807, 0x0802, 0x0902, 0x0A02),
  },
  {	.channel		= 208,
	.freq			= 5040, /* MHz */
	.unk2			= 3360,
	RADIOREGS(0x71, 0x01, 0xF8, 0x0D, 0xEF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xCC, 0xCC, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xE407, 0xE007, 0xDC07, 0x0702, 0x0802, 0x0902),
  },
  {	.channel		= 210,
	.freq			= 5050, /* MHz */
	.unk2			= 3367,
	RADIOREGS(0x71, 0x01, 0xF9, 0x0D, 0xEF, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xCC, 0xCC, 0xFF, 0x00, 0x0F, 0x0F,
		  0x8F, 0xFF, 0x00, 0x0F, 0x0F, 0x8F),
	PHYREGS(0xE807, 0xE407, 0xE007, 0x0602, 0x0702, 0x0802),
  },
  {	.channel		= 212,
	.freq			= 5060, /* MHz */
	.unk2			= 3373,
	RADIOREGS(0x71, 0x01, 0xFA, 0x0D, 0xE6, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xBB, 0xBB, 0xFF, 0x00, 0x0E, 0x0F,
		  0x8E, 0xFF, 0x00, 0x0E, 0x0F, 0x8E),
	PHYREGS(0xEC07, 0xE807, 0xE407, 0x0502, 0x0602, 0x0702),
  },
  {	.channel		= 214,
	.freq			= 5070, /* MHz */
	.unk2			= 3380,
	RADIOREGS(0x71, 0x01, 0xFB, 0x0D, 0xE6, 0x01, 0x04, 0x0A,
		  0x00, 0x8F, 0xBB, 0xBB, 0xFF, 0x00, 0x0E, 0x0F,
		  0x8E, 0xFF, 0x00, 0x0E, 0x0F, 0x8E),
	PHYREGS(0xF007, 0xEC07, 0xE807, 0x0402, 0x0502, 0x0602),
  },
  {	.channel		= 216,
	.freq			= 5080, /* MHz */
	.unk2			= 3387,
	RADIOREGS(0x71, 0x01, 0xFC, 0x0D, 0xDE, 0x01, 0x04, 0x0A,
		  0x00, 0x8E, 0xBB, 0xBB, 0xEE, 0x00, 0x0E, 0x0F,
		  0x8D, 0xEE, 0x00, 0x0E, 0x0F, 0x8D),
	PHYREGS(0xF407, 0xF007, 0xEC07, 0x0302, 0x0402, 0x0502),
  },
  {	.channel		= 218,
	.freq			= 5090, /* MHz */
	.unk2			= 3393,
	RADIOREGS(0x71, 0x01, 0xFD, 0x0D, 0xDE, 0x01, 0x04, 0x0A,
		  0x00, 0x8E, 0xBB, 0xBB, 0xEE, 0x00, 0x0E, 0x0F,
		  0x8D, 0xEE, 0x00, 0x0E, 0x0F, 0x8D),
	PHYREGS(0xF807, 0xF407, 0xF007, 0x0202, 0x0302, 0x0402),
  },
  {	.channel		= 220,
	.freq			= 5100, /* MHz */
	.unk2			= 3400,
	RADIOREGS(0x71, 0x01, 0xFE, 0x0C, 0xD6, 0x01, 0x04, 0x0A,
		  0x00, 0x8E, 0xAA, 0xAA, 0xEE, 0x00, 0x0D, 0x0F,
		  0x8D, 0xEE, 0x00, 0x0D, 0x0F, 0x8D),
	PHYREGS(0xFC07, 0xF807, 0xF407, 0x0102, 0x0202, 0x0302),
  },
  {	.channel		= 222,
	.freq			= 5110, /* MHz */
	.unk2			= 3407,
	RADIOREGS(0x71, 0x01, 0xFF, 0x0C, 0xD6, 0x01, 0x04, 0x0A,
		  0x00, 0x8E, 0xAA, 0xAA, 0xEE, 0x00, 0x0D, 0x0F,
		  0x8D, 0xEE, 0x00, 0x0D, 0x0F, 0x8D),
	PHYREGS(0x0008, 0xFC07, 0xF807, 0x0002, 0x0102, 0x0202),
  },
  {	.channel		= 224,
	.freq			= 5120, /* MHz */
	.unk2			= 3413,
	RADIOREGS(0x71, 0x02, 0x00, 0x0C, 0xCE, 0x01, 0x04, 0x0A,
		  0x00, 0x8D, 0xAA, 0xAA, 0xDD, 0x00, 0x0D, 0x0F,
		  0x8C, 0xDD, 0x00, 0x0D, 0x0F, 0x8C),
	PHYREGS(0x0408, 0x0008, 0xFC07, 0xFF01, 0x0002, 0x0102),
  },
  {	.channel		= 226,
	.freq			= 5130, /* MHz */
	.unk2			= 3420,
	RADIOREGS(0x71, 0x02, 0x01, 0x0C, 0xCE, 0x01, 0x04, 0x0A,
		  0x00, 0x8D, 0xAA, 0xAA, 0xDD, 0x00, 0x0D, 0x0F,
		  0x8C, 0xDD, 0x00, 0x0D, 0x0F, 0x8C),
	PHYREGS(0x0808, 0x0408, 0x0008, 0xFE01, 0xFF01, 0x0002),
  },
  {	.channel		= 228,
	.freq			= 5140, /* MHz */
	.unk2			= 3427,
	RADIOREGS(0x71, 0x02, 0x02, 0x0C, 0xC6, 0x01, 0x04, 0x0A,
		  0x00, 0x8D, 0x99, 0x99, 0xDD, 0x00, 0x0C, 0x0E,
		  0x8B, 0xDD, 0x00, 0x0C, 0x0E, 0x8B),
	PHYREGS(0x0C08, 0x0808, 0x0408, 0xFD01, 0xFE01, 0xFF01),
  },
  {	.channel		= 32,
	.freq			= 5160, /* MHz */
	.unk2			= 3440,
	RADIOREGS(0x71, 0x02, 0x04, 0x0B, 0xBE, 0x01, 0x04, 0x0A,
		  0x00, 0x8C, 0x99, 0x99, 0xCC, 0x00, 0x0B, 0x0D,
		  0x8A, 0xCC, 0x00, 0x0B, 0x0D, 0x8A),
	PHYREGS(0x1408, 0x1008, 0x0C08, 0xFB01, 0xFC01, 0xFD01),
  },
  {	.channel		= 34,
	.freq			= 5170, /* MHz */
	.unk2			= 3447,
	RADIOREGS(0x71, 0x02, 0x05, 0x0B, 0xBE, 0x01, 0x04, 0x0A,
		  0x00, 0x8C, 0x99, 0x99, 0xCC, 0x00, 0x0B, 0x0D,
		  0x8A, 0xCC, 0x00, 0x0B, 0x0D, 0x8A),
	PHYREGS(0x1808, 0x1408, 0x1008, 0xFA01, 0xFB01, 0xFC01),
  },
  {	.channel		= 36,
	.freq			= 5180, /* MHz */
	.unk2			= 3453,
	RADIOREGS(0x71, 0x02, 0x06, 0x0B, 0xB6, 0x01, 0x04, 0x0A,
		  0x00, 0x8C, 0x88, 0x88, 0xCC, 0x00, 0x0B, 0x0C,
		  0x89, 0xCC, 0x00, 0x0B, 0x0C, 0x89),
	PHYREGS(0x1C08, 0x1808, 0x1408, 0xF901, 0xFA01, 0xFB01),
  },
  {	.channel		= 38,
	.freq			= 5190, /* MHz */
	.unk2			= 3460,
	RADIOREGS(0x71, 0x02, 0x07, 0x0B, 0xB6, 0x01, 0x04, 0x0A,
		  0x00, 0x8C, 0x88, 0x88, 0xCC, 0x00, 0x0B, 0x0C,
		  0x89, 0xCC, 0x00, 0x0B, 0x0C, 0x89),
	PHYREGS(0x2008, 0x1C08, 0x1808, 0xF801, 0xF901, 0xFA01),
  },
  {	.channel		= 40,
	.freq			= 5200, /* MHz */
	.unk2			= 3467,
	RADIOREGS(0x71, 0x02, 0x08, 0x0B, 0xAF, 0x01, 0x04, 0x0A,
		  0x00, 0x8B, 0x88, 0x88, 0xBB, 0x00, 0x0A, 0x0B,
		  0x89, 0xBB, 0x00, 0x0A, 0x0B, 0x89),
	PHYREGS(0x2408, 0x2008, 0x1C08, 0xF701, 0xF801, 0xF901),
  },
  {	.channel		= 42,
	.freq			= 5210, /* MHz */
	.unk2			= 3473,
	RADIOREGS(0x71, 0x02, 0x09, 0x0B, 0xAF, 0x01, 0x04, 0x0A,
		  0x00, 0x8B, 0x88, 0x88, 0xBB, 0x00, 0x0A, 0x0B,
		  0x89, 0xBB, 0x00, 0x0A, 0x0B, 0x89),
	PHYREGS(0x2808, 0x2408, 0x2008, 0xF601, 0xF701, 0xF801),
  },
  {	.channel		= 44,
	.freq			= 5220, /* MHz */
	.unk2			= 3480,
	RADIOREGS(0x71, 0x02, 0x0A, 0x0A, 0xA7, 0x01, 0x04, 0x0A,
		  0x00, 0x8B, 0x77, 0x77, 0xBB, 0x00, 0x09, 0x0A,
		  0x88, 0xBB, 0x00, 0x09, 0x0A, 0x88),
	PHYREGS(0x2C08, 0x2808, 0x2408, 0xF501, 0xF601, 0xF701),
  },
  {	.channel		= 46,
	.freq			= 5230, /* MHz */
	.unk2			= 3487,
	RADIOREGS(0x71, 0x02, 0x0B, 0x0A, 0xA7, 0x01, 0x04, 0x0A,
		  0x00, 0x8B, 0x77, 0x77, 0xBB, 0x00, 0x09, 0x0A,
		  0x88, 0xBB, 0x00, 0x09, 0x0A, 0x88),
	PHYREGS(0x3008, 0x2C08, 0x2808, 0xF401, 0xF501, 0xF601),
  },
  {	.channel		= 48,
	.freq			= 5240, /* MHz */
	.unk2			= 3493,
	RADIOREGS(0x71, 0x02, 0x0C, 0x0A, 0xA0, 0x01, 0x04, 0x0A,
		  0x00, 0x8A, 0x77, 0x77, 0xAA, 0x00, 0x09, 0x0A,
		  0x87, 0xAA, 0x00, 0x09, 0x0A, 0x87),
	PHYREGS(0x3408, 0x3008, 0x2C08, 0xF301, 0xF401, 0xF501),
  },
  {	.channel		= 50,
	.freq			= 5250, /* MHz */
	.unk2			= 3500,
	RADIOREGS(0x71, 0x02, 0x0D, 0x0A, 0xA0, 0x01, 0x04, 0x0A,
		  0x00, 0x8A, 0x77, 0x77, 0xAA, 0x00, 0x09, 0x0A,
		  0x87, 0xAA, 0x00, 0x09, 0x0A, 0x87),
	PHYREGS(0x3808, 0x3408, 0x3008, 0xF201, 0xF301, 0xF401),
  },
  {	.channel		= 52,
	.freq			= 5260, /* MHz */
	.unk2			= 3507,
	RADIOREGS(0x71, 0x02, 0x0E, 0x0A, 0x98, 0x01, 0x04, 0x0A,
		  0x00, 0x8A, 0x66, 0x66, 0xAA, 0x00, 0x08, 0x09,
		  0x87, 0xAA, 0x00, 0x08, 0x09, 0x87),
	PHYREGS(0x3C08, 0x3808, 0x3408, 0xF101, 0xF201, 0xF301),
  },
  {	.channel		= 54,
	.freq			= 5270, /* MHz */
	.unk2			= 3513,
	RADIOREGS(0x71, 0x02, 0x0F, 0x0A, 0x98, 0x01, 0x04, 0x0A,
		  0x00, 0x8A, 0x66, 0x66, 0xAA, 0x00, 0x08, 0x09,
		  0x87, 0xAA, 0x00, 0x08, 0x09, 0x87),
	PHYREGS(0x4008, 0x3C08, 0x3808, 0xF001, 0xF101, 0xF201),
  },
  {	.channel		= 56,
	.freq			= 5280, /* MHz */
	.unk2			= 3520,
	RADIOREGS(0x71, 0x02, 0x10, 0x09, 0x91, 0x01, 0x04, 0x0A,
		  0x00, 0x89, 0x66, 0x66, 0x99, 0x00, 0x08, 0x08,
		  0x86, 0x99, 0x00, 0x08, 0x08, 0x86),
	PHYREGS(0x4408, 0x4008, 0x3C08, 0xF001, 0xF001, 0xF101),
  },
  {	.channel		= 58,
	.freq			= 5290, /* MHz */
	.unk2			= 3527,
	RADIOREGS(0x71, 0x02, 0x11, 0x09, 0x91, 0x01, 0x04, 0x0A,
		  0x00, 0x89, 0x66, 0x66, 0x99, 0x00, 0x08, 0x08,
		  0x86, 0x99, 0x00, 0x08, 0x08, 0x86),
	PHYREGS(0x4808, 0x4408, 0x4008, 0xEF01, 0xF001, 0xF001),
  },
  {	.channel		= 60,
	.freq			= 5300, /* MHz */
	.unk2			= 3533,
	RADIOREGS(0x71, 0x02, 0x12, 0x09, 0x8A, 0x01, 0x04, 0x0A,
		  0x00, 0x89, 0x55, 0x55, 0x99, 0x00, 0x08, 0x07,
		  0x85, 0x99, 0x00, 0x08, 0x07, 0x85),
	PHYREGS(0x4C08, 0x4808, 0x4408, 0xEE01, 0xEF01, 0xF001),
  },
  {	.channel		= 62,
	.freq			= 5310, /* MHz */
	.unk2			= 3540,
	RADIOREGS(0x71, 0x02, 0x13, 0x09, 0x8A, 0x01, 0x04, 0x0A,
		  0x00, 0x89, 0x55, 0x55, 0x99, 0x00, 0x08, 0x07,
		  0x85, 0x99, 0x00, 0x08, 0x07, 0x85),
	PHYREGS(0x5008, 0x4C08, 0x4808, 0xED01, 0xEE01, 0xEF01),
  },
  {	.channel		= 64,
	.freq			= 5320, /* MHz */
	.unk2			= 3547,
	RADIOREGS(0x71, 0x02, 0x14, 0x09, 0x83, 0x01, 0x04, 0x0A,
		  0x00, 0x88, 0x55, 0x55, 0x88, 0x00, 0x07, 0x07,
		  0x84, 0x88, 0x00, 0x07, 0x07, 0x84),
	PHYREGS(0x5408, 0x5008, 0x4C08, 0xEC01, 0xED01, 0xEE01),
  },
  {	.channel		= 66,
	.freq			= 5330, /* MHz */
	.unk2			= 3553,
	RADIOREGS(0x71, 0x02, 0x15, 0x09, 0x83, 0x01, 0x04, 0x0A,
		  0x00, 0x88, 0x55, 0x55, 0x88, 0x00, 0x07, 0x07,
		  0x84, 0x88, 0x00, 0x07, 0x07, 0x84),
	PHYREGS(0x5808, 0x5408, 0x5008, 0xEB01, 0xEC01, 0xED01),
  },
  {	.channel		= 68,
	.freq			= 5340, /* MHz */
	.unk2			= 3560,
	RADIOREGS(0x71, 0x02, 0x16, 0x08, 0x7C, 0x01, 0x04, 0x0A,
		  0x00, 0x88, 0x44, 0x44, 0x88, 0x00, 0x07, 0x06,
		  0x84, 0x88, 0x00, 0x07, 0x06, 0x84),
	PHYREGS(0x5C08, 0x5808, 0x5408, 0xEA01, 0xEB01, 0xEC01),
  },
  {	.channel		= 70,
	.freq			= 5350, /* MHz */
	.unk2			= 3567,
	RADIOREGS(0x71, 0x02, 0x17, 0x08, 0x7C, 0x01, 0x04, 0x0A,
		  0x00, 0x88, 0x44, 0x44, 0x88, 0x00, 0x07, 0x06,
		  0x84, 0x88, 0x00, 0x07, 0x06, 0x84),
	PHYREGS(0x6008, 0x5C08, 0x5808, 0xE901, 0xEA01, 0xEB01),
  },
  {	.channel		= 72,
	.freq			= 5360, /* MHz */
	.unk2			= 3573,
	RADIOREGS(0x71, 0x02, 0x18, 0x08, 0x75, 0x01, 0x04, 0x0A,
		  0x00, 0x87, 0x44, 0x44, 0x77, 0x00, 0x06, 0x05,
		  0x83, 0x77, 0x00, 0x06, 0x05, 0x83),
	PHYREGS(0x6408, 0x6008, 0x5C08, 0xE801, 0xE901, 0xEA01),
  },
  {	.channel		= 74,
	.freq			= 5370, /* MHz */
	.unk2			= 3580,
	RADIOREGS(0x71, 0x02, 0x19, 0x08, 0x75, 0x01, 0x04, 0x0A,
		  0x00, 0x87, 0x44, 0x44, 0x77, 0x00, 0x06, 0x05,
		  0x83, 0x77, 0x00, 0x06, 0x05, 0x83),
	PHYREGS(0x6808, 0x6408, 0x6008, 0xE701, 0xE801, 0xE901),
  },
  {	.channel		= 76,
	.freq			= 5380, /* MHz */
	.unk2			= 3587,
	RADIOREGS(0x71, 0x02, 0x1A, 0x08, 0x6E, 0x01, 0x04, 0x0A,
		  0x00, 0x87, 0x33, 0x33, 0x77, 0x00, 0x06, 0x04,
		  0x82, 0x77, 0x00, 0x06, 0x04, 0x82),
	PHYREGS(0x6C08, 0x6808, 0x6408, 0xE601, 0xE701, 0xE801),
  },
  {	.channel		= 78,
	.freq			= 5390, /* MHz */
	.unk2			= 3593,
	RADIOREGS(0x71, 0x02, 0x1B, 0x08, 0x6E, 0x01, 0x04, 0x0A,
		  0x00, 0x87, 0x33, 0x33, 0x77, 0x00, 0x06, 0x04,
		  0x82, 0x77, 0x00, 0x06, 0x04, 0x82),
	PHYREGS(0x7008, 0x6C08, 0x6808, 0xE501, 0xE601, 0xE701),
  },
  {	.channel		= 80,
	.freq			= 5400, /* MHz */
	.unk2			= 3600,
	RADIOREGS(0x71, 0x02, 0x1C, 0x07, 0x67, 0x01, 0x04, 0x0A,
		  0x00, 0x86, 0x33, 0x33, 0x66, 0x00, 0x05, 0x04,
		  0x81, 0x66, 0x00, 0x05, 0x04, 0x81),
	PHYREGS(0x7408, 0x7008, 0x6C08, 0xE501, 0xE501, 0xE601),
  },
  {	.channel		= 82,
	.freq			= 5410, /* MHz */
	.unk2			= 3607,
	RADIOREGS(0x71, 0x02, 0x1D, 0x07, 0x67, 0x01, 0x04, 0x0A,
		  0x00, 0x86, 0x33, 0x33, 0x66, 0x00, 0x05, 0x04,
		  0x81, 0x66, 0x00, 0x05, 0x04, 0x81),
	PHYREGS(0x7808, 0x7408, 0x7008, 0xE401, 0xE501, 0xE501),
  },
  {	.channel		= 84,
	.freq			= 5420, /* MHz */
	.unk2			= 3613,
	RADIOREGS(0x71, 0x02, 0x1E, 0x07, 0x61, 0x01, 0x04, 0x0A,
		  0x00, 0x86, 0x22, 0x22, 0x66, 0x00, 0x05, 0x03,
		  0x80, 0x66, 0x00, 0x05, 0x03, 0x80),
	PHYREGS(0x7C08, 0x7808, 0x7408, 0xE301, 0xE401, 0xE501),
  },
  {	.channel		= 86,
	.freq			= 5430, /* MHz */
	.unk2			= 3620,
	RADIOREGS(0x71, 0x02, 0x1F, 0x07, 0x61, 0x01, 0x04, 0x0A,
		  0x00, 0x86, 0x22, 0x22, 0x66, 0x00, 0x05, 0x03,
		  0x80, 0x66, 0x00, 0x05, 0x03, 0x80),
	PHYREGS(0x8008, 0x7C08, 0x7808, 0xE201, 0xE301, 0xE401),
  },
  {	.channel		= 88,
	.freq			= 5440, /* MHz */
	.unk2			= 3627,
	RADIOREGS(0x71, 0x02, 0x20, 0x07, 0x5A, 0x01, 0x04, 0x0A,
		  0x00, 0x85, 0x22, 0x22, 0x55, 0x00, 0x04, 0x02,
		  0x80, 0x55, 0x00, 0x04, 0x02, 0x80),
	PHYREGS(0x8408, 0x8008, 0x7C08, 0xE101, 0xE201, 0xE301),
  },
  {	.channel		= 90,
	.freq			= 5450, /* MHz */
	.unk2			= 3633,
	RADIOREGS(0x71, 0x02, 0x21, 0x07, 0x5A, 0x01, 0x04, 0x0A,
		  0x00, 0x85, 0x22, 0x22, 0x55, 0x00, 0x04, 0x02,
		  0x80, 0x55, 0x00, 0x04, 0x02, 0x80),
	PHYREGS(0x8808, 0x8408, 0x8008, 0xE001, 0xE101, 0xE201),
  },
  {	.channel		= 92,
	.freq			= 5460, /* MHz */
	.unk2			= 3640,
	RADIOREGS(0x71, 0x02, 0x22, 0x06, 0x53, 0x01, 0x04, 0x0A,
		  0x00, 0x85, 0x11, 0x11, 0x55, 0x00, 0x04, 0x01,
		  0x80, 0x55, 0x00, 0x04, 0x01, 0x80),
	PHYREGS(0x8C08, 0x8808, 0x8408, 0xDF01, 0xE001, 0xE101),
  },
  {	.channel		= 94,
	.freq			= 5470, /* MHz */
	.unk2			= 3647,
	RADIOREGS(0x71, 0x02, 0x23, 0x06, 0x53, 0x01, 0x04, 0x0A,
		  0x00, 0x85, 0x11, 0x11, 0x55, 0x00, 0x04, 0x01,
		  0x80, 0x55, 0x00, 0x04, 0x01, 0x80),
	PHYREGS(0x9008, 0x8C08, 0x8808, 0xDE01, 0xDF01, 0xE001),
  },
  {	.channel		= 96,
	.freq			= 5480, /* MHz */
	.unk2			= 3653,
	RADIOREGS(0x71, 0x02, 0x24, 0x06, 0x4D, 0x01, 0x04, 0x0A,
		  0x00, 0x84, 0x11, 0x11, 0x44, 0x00, 0x03, 0x00,
		  0x80, 0x44, 0x00, 0x03, 0x00, 0x80),
	PHYREGS(0x9408, 0x9008, 0x8C08, 0xDD01, 0xDE01, 0xDF01),
  },
  {	.channel		= 98,
	.freq			= 5490, /* MHz */
	.unk2			= 3660,
	RADIOREGS(0x71, 0x02, 0x25, 0x06, 0x4D, 0x01, 0x04, 0x0A,
		  0x00, 0x84, 0x11, 0x11, 0x44, 0x00, 0x03, 0x00,
		  0x80, 0x44, 0x00, 0x03, 0x00, 0x80),
	PHYREGS(0x9808, 0x9408, 0x9008, 0xDD01, 0xDD01, 0xDE01),
  },
  {	.channel		= 100,
	.freq			= 5500, /* MHz */
	.unk2			= 3667,
	RADIOREGS(0x71, 0x02, 0x26, 0x06, 0x47, 0x01, 0x04, 0x0A,
		  0x00, 0x84, 0x00, 0x00, 0x44, 0x00, 0x03, 0x00,
		  0x80, 0x44, 0x00, 0x03, 0x00, 0x80),
	PHYREGS(0x9C08, 0x9808, 0x9408, 0xDC01, 0xDD01, 0xDD01),
  },
  {	.channel		= 102,
	.freq			= 5510, /* MHz */
	.unk2			= 3673,
	RADIOREGS(0x71, 0x02, 0x27, 0x06, 0x47, 0x01, 0x04, 0x0A,
		  0x00, 0x84, 0x00, 0x00, 0x44, 0x00, 0x03, 0x00,
		  0x80, 0x44, 0x00, 0x03, 0x00, 0x80),
	PHYREGS(0xA008, 0x9C08, 0x9808, 0xDB01, 0xDC01, 0xDD01),
  },
  {	.channel		= 104,
	.freq			= 5520, /* MHz */
	.unk2			= 3680,
	RADIOREGS(0x71, 0x02, 0x28, 0x05, 0x40, 0x01, 0x04, 0x0A,
		  0x00, 0x83, 0x00, 0x00, 0x33, 0x00, 0x02, 0x00,
		  0x80, 0x33, 0x00, 0x02, 0x00, 0x80),
	PHYREGS(0xA408, 0xA008, 0x9C08, 0xDA01, 0xDB01, 0xDC01),
  },
  {	.channel		= 106,
	.freq			= 5530, /* MHz */
	.unk2			= 3687,
	RADIOREGS(0x71, 0x02, 0x29, 0x05, 0x40, 0x01, 0x04, 0x0A,
		  0x00, 0x83, 0x00, 0x00, 0x33, 0x00, 0x02, 0x00,
		  0x80, 0x33, 0x00, 0x02, 0x00, 0x80),
	PHYREGS(0xA808, 0xA408, 0xA008, 0xD901, 0xDA01, 0xDB01),
  },
  {	.channel		= 108,
	.freq			= 5540, /* MHz */
	.unk2			= 3693,
	RADIOREGS(0x71, 0x02, 0x2A, 0x05, 0x3A, 0x01, 0x04, 0x0A,
		  0x00, 0x83, 0x00, 0x00, 0x33, 0x00, 0x02, 0x00,
		  0x80, 0x33, 0x00, 0x02, 0x00, 0x80),
	PHYREGS(0xAC08, 0xA808, 0xA408, 0xD801, 0xD901, 0xDA01),
  },
  {	.channel		= 110,
	.freq			= 5550, /* MHz */
	.unk2			= 3700,
	RADIOREGS(0x71, 0x02, 0x2B, 0x05, 0x3A, 0x01, 0x04, 0x0A,
		  0x00, 0x83, 0x00, 0x00, 0x33, 0x00, 0x02, 0x00,
		  0x80, 0x33, 0x00, 0x02, 0x00, 0x80),
	PHYREGS(0xB008, 0xAC08, 0xA808, 0xD701, 0xD801, 0xD901),
  },
  {	.channel		= 112,
	.freq			= 5560, /* MHz */
	.unk2			= 3707,
	RADIOREGS(0x71, 0x02, 0x2C, 0x05, 0x34, 0x01, 0x04, 0x0A,
		  0x00, 0x82, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00,
		  0x80, 0x22, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0xB408, 0xB008, 0xAC08, 0xD701, 0xD701, 0xD801),
  },
  {	.channel		= 114,
	.freq			= 5570, /* MHz */
	.unk2			= 3713,
	RADIOREGS(0x71, 0x02, 0x2D, 0x05, 0x34, 0x01, 0x04, 0x0A,
		  0x00, 0x82, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00,
		  0x80, 0x22, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0xB808, 0xB408, 0xB008, 0xD601, 0xD701, 0xD701),
  },
  {	.channel		= 116,
	.freq			= 5580, /* MHz */
	.unk2			= 3720,
	RADIOREGS(0x71, 0x02, 0x2E, 0x04, 0x2E, 0x01, 0x04, 0x0A,
		  0x00, 0x82, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00,
		  0x80, 0x22, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0xBC08, 0xB808, 0xB408, 0xD501, 0xD601, 0xD701),
  },
  {	.channel		= 118,
	.freq			= 5590, /* MHz */
	.unk2			= 3727,
	RADIOREGS(0x71, 0x02, 0x2F, 0x04, 0x2E, 0x01, 0x04, 0x0A,
		  0x00, 0x82, 0x00, 0x00, 0x22, 0x00, 0x01, 0x00,
		  0x80, 0x22, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0xC008, 0xBC08, 0xB808, 0xD401, 0xD501, 0xD601),
  },
  {	.channel		= 120,
	.freq			= 5600, /* MHz */
	.unk2			= 3733,
	RADIOREGS(0x71, 0x02, 0x30, 0x04, 0x28, 0x01, 0x04, 0x0A,
		  0x00, 0x81, 0x00, 0x00, 0x11, 0x00, 0x01, 0x00,
		  0x80, 0x11, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0xC408, 0xC008, 0xBC08, 0xD301, 0xD401, 0xD501),
  },
  {	.channel		= 122,
	.freq			= 5610, /* MHz */
	.unk2			= 3740,
	RADIOREGS(0x71, 0x02, 0x31, 0x04, 0x28, 0x01, 0x04, 0x0A,
		  0x00, 0x81, 0x00, 0x00, 0x11, 0x00, 0x01, 0x00,
		  0x80, 0x11, 0x00, 0x01, 0x00, 0x80),
	PHYREGS(0xC808, 0xC408, 0xC008, 0xD201, 0xD301, 0xD401),
  },
  {	.channel		= 124,
	.freq			= 5620, /* MHz */
	.unk2			= 3747,
	RADIOREGS(0x71, 0x02, 0x32, 0x04, 0x21, 0x01, 0x04, 0x0A,
		  0x00, 0x81, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
		  0x80, 0x11, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xCC08, 0xC808, 0xC408, 0xD201, 0xD201, 0xD301),
  },
  {	.channel		= 126,
	.freq			= 5630, /* MHz */
	.unk2			= 3753,
	RADIOREGS(0x71, 0x02, 0x33, 0x04, 0x21, 0x01, 0x04, 0x0A,
		  0x00, 0x81, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00,
		  0x80, 0x11, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xD008, 0xCC08, 0xC808, 0xD101, 0xD201, 0xD201),
  },
  {	.channel		= 128,
	.freq			= 5640, /* MHz */
	.unk2			= 3760,
	RADIOREGS(0x71, 0x02, 0x34, 0x03, 0x1C, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xD408, 0xD008, 0xCC08, 0xD001, 0xD101, 0xD201),
  },
  {	.channel		= 130,
	.freq			= 5650, /* MHz */
	.unk2			= 3767,
	RADIOREGS(0x71, 0x02, 0x35, 0x03, 0x1C, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xD808, 0xD408, 0xD008, 0xCF01, 0xD001, 0xD101),
  },
  {	.channel		= 132,
	.freq			= 5660, /* MHz */
	.unk2			= 3773,
	RADIOREGS(0x71, 0x02, 0x36, 0x03, 0x16, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xDC08, 0xD808, 0xD408, 0xCE01, 0xCF01, 0xD001),
  },
  {	.channel		= 134,
	.freq			= 5670, /* MHz */
	.unk2			= 3780,
	RADIOREGS(0x71, 0x02, 0x37, 0x03, 0x16, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xE008, 0xDC08, 0xD808, 0xCE01, 0xCE01, 0xCF01),
  },
  {	.channel		= 136,
	.freq			= 5680, /* MHz */
	.unk2			= 3787,
	RADIOREGS(0x71, 0x02, 0x38, 0x03, 0x10, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xE408, 0xE008, 0xDC08, 0xCD01, 0xCE01, 0xCE01),
  },
  {	.channel		= 138,
	.freq			= 5690, /* MHz */
	.unk2			= 3793,
	RADIOREGS(0x71, 0x02, 0x39, 0x03, 0x10, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xE808, 0xE408, 0xE008, 0xCC01, 0xCD01, 0xCE01),
  },
  {	.channel		= 140,
	.freq			= 5700, /* MHz */
	.unk2			= 3800,
	RADIOREGS(0x71, 0x02, 0x3A, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xEC08, 0xE808, 0xE408, 0xCB01, 0xCC01, 0xCD01),
  },
  {	.channel		= 142,
	.freq			= 5710, /* MHz */
	.unk2			= 3807,
	RADIOREGS(0x71, 0x02, 0x3B, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xF008, 0xEC08, 0xE808, 0xCA01, 0xCB01, 0xCC01),
  },
  {	.channel		= 144,
	.freq			= 5720, /* MHz */
	.unk2			= 3813,
	RADIOREGS(0x71, 0x02, 0x3C, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xF408, 0xF008, 0xEC08, 0xC901, 0xCA01, 0xCB01),
  },
  {	.channel		= 145,
	.freq			= 5725, /* MHz */
	.unk2			= 3817,
	RADIOREGS(0x72, 0x04, 0x79, 0x02, 0x03, 0x01, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xF608, 0xF208, 0xEE08, 0xC901, 0xCA01, 0xCB01),
  },
  {	.channel		= 146,
	.freq			= 5730, /* MHz */
	.unk2			= 3820,
	RADIOREGS(0x71, 0x02, 0x3D, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xF808, 0xF408, 0xF008, 0xC901, 0xC901, 0xCA01),
  },
  {	.channel		= 147,
	.freq			= 5735, /* MHz */
	.unk2			= 3823,
	RADIOREGS(0x72, 0x04, 0x7B, 0x02, 0x03, 0x01, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xFA08, 0xF608, 0xF208, 0xC801, 0xC901, 0xCA01),
  },
  {	.channel		= 148,
	.freq			= 5740, /* MHz */
	.unk2			= 3827,
	RADIOREGS(0x71, 0x02, 0x3E, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xFC08, 0xF808, 0xF408, 0xC801, 0xC901, 0xC901),
  },
  {	.channel		= 149,
	.freq			= 5745, /* MHz */
	.unk2			= 3830,
	RADIOREGS(0x72, 0x04, 0x7D, 0x02, 0xFE, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0xFE08, 0xFA08, 0xF608, 0xC801, 0xC801, 0xC901),
  },
  {	.channel		= 150,
	.freq			= 5750, /* MHz */
	.unk2			= 3833,
	RADIOREGS(0x71, 0x02, 0x3F, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0009, 0xFC08, 0xF808, 0xC701, 0xC801, 0xC901),
  },
  {	.channel		= 151,
	.freq			= 5755, /* MHz */
	.unk2			= 3837,
	RADIOREGS(0x72, 0x04, 0x7F, 0x02, 0xFE, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0209, 0xFE08, 0xFA08, 0xC701, 0xC801, 0xC801),
  },
  {	.channel		= 152,
	.freq			= 5760, /* MHz */
	.unk2			= 3840,
	RADIOREGS(0x71, 0x02, 0x40, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0409, 0x0009, 0xFC08, 0xC601, 0xC701, 0xC801),
  },
  {	.channel		= 153,
	.freq			= 5765, /* MHz */
	.unk2			= 3843,
	RADIOREGS(0x72, 0x04, 0x81, 0x02, 0xF8, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0609, 0x0209, 0xFE08, 0xC601, 0xC701, 0xC801),
  },
  {	.channel		= 154,
	.freq			= 5770, /* MHz */
	.unk2			= 3847,
	RADIOREGS(0x71, 0x02, 0x41, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0809, 0x0409, 0x0009, 0xC601, 0xC601, 0xC701),
  },
  {	.channel		= 155,
	.freq			= 5775, /* MHz */
	.unk2			= 3850,
	RADIOREGS(0x72, 0x04, 0x83, 0x02, 0xF8, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0A09, 0x0609, 0x0209, 0xC501, 0xC601, 0xC701),
  },
  {	.channel		= 156,
	.freq			= 5780, /* MHz */
	.unk2			= 3853,
	RADIOREGS(0x71, 0x02, 0x42, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0C09, 0x0809, 0x0409, 0xC501, 0xC601, 0xC601),
  },
  {	.channel		= 157,
	.freq			= 5785, /* MHz */
	.unk2			= 3857,
	RADIOREGS(0x72, 0x04, 0x85, 0x02, 0xF2, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x0E09, 0x0A09, 0x0609, 0xC401, 0xC501, 0xC601),
  },
  {	.channel		= 158,
	.freq			= 5790, /* MHz */
	.unk2			= 3860,
	RADIOREGS(0x71, 0x02, 0x43, 0x02, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x1009, 0x0C09, 0x0809, 0xC401, 0xC501, 0xC601),
  },
  {	.channel		= 159,
	.freq			= 5795, /* MHz */
	.unk2			= 3863,
	RADIOREGS(0x72, 0x04, 0x87, 0x02, 0xF2, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x1209, 0x0E09, 0x0A09, 0xC401, 0xC401, 0xC501),
  },
  {	.channel		= 160,
	.freq			= 5800, /* MHz */
	.unk2			= 3867,
	RADIOREGS(0x71, 0x02, 0x44, 0x01, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x1409, 0x1009, 0x0C09, 0xC301, 0xC401, 0xC501),
  },
  {	.channel		= 161,
	.freq			= 5805, /* MHz */
	.unk2			= 3870,
	RADIOREGS(0x72, 0x04, 0x89, 0x01, 0xED, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x1609, 0x1209, 0x0E09, 0xC301, 0xC401, 0xC401),
  },
  {	.channel		= 162,
	.freq			= 5810, /* MHz */
	.unk2			= 3873,
	RADIOREGS(0x71, 0x02, 0x45, 0x01, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x1809, 0x1409, 0x1009, 0xC201, 0xC301, 0xC401),
  },
  {	.channel		= 163,
	.freq			= 5815, /* MHz */
	.unk2			= 3877,
	RADIOREGS(0x72, 0x04, 0x8B, 0x01, 0xED, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x1A09, 0x1609, 0x1209, 0xC201, 0xC301, 0xC401),
  },
  {	.channel		= 164,
	.freq			= 5820, /* MHz */
	.unk2			= 3880,
	RADIOREGS(0x71, 0x02, 0x46, 0x01, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x1C09, 0x1809, 0x1409, 0xC201, 0xC201, 0xC301),
  },
  {	.channel		= 165,
	.freq			= 5825, /* MHz */
	.unk2			= 3883,
	RADIOREGS(0x72, 0x04, 0x8D, 0x01, 0xED, 0x00, 0x03, 0x14,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x1E09, 0x1A09, 0x1609, 0xC101, 0xC201, 0xC301),
  },
  {	.channel		= 166,
	.freq			= 5830, /* MHz */
	.unk2			= 3887,
	RADIOREGS(0x71, 0x02, 0x47, 0x01, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x2009, 0x1C09, 0x1809, 0xC101, 0xC201, 0xC201),
  },
  {	.channel		= 168,
	.freq			= 5840, /* MHz */
	.unk2			= 3893,
	RADIOREGS(0x71, 0x02, 0x48, 0x01, 0x0A, 0x01, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x2409, 0x2009, 0x1C09, 0xC001, 0xC101, 0xC201),
  },
  {	.channel		= 170,
	.freq			= 5850, /* MHz */
	.unk2			= 3900,
	RADIOREGS(0x71, 0x02, 0x49, 0x01, 0xE0, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x2809, 0x2409, 0x2009, 0xBF01, 0xC001, 0xC101),
  },
  {	.channel		= 172,
	.freq			= 5860, /* MHz */
	.unk2			= 3907,
	RADIOREGS(0x71, 0x02, 0x4A, 0x01, 0xDE, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x2C09, 0x2809, 0x2409, 0xBF01, 0xBF01, 0xC001),
  },
  {	.channel		= 174,
	.freq			= 5870, /* MHz */
	.unk2			= 3913,
	RADIOREGS(0x71, 0x02, 0x4B, 0x00, 0xDB, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x3009, 0x2C09, 0x2809, 0xBE01, 0xBF01, 0xBF01),
  },
  {	.channel		= 176,
	.freq			= 5880, /* MHz */
	.unk2			= 3920,
	RADIOREGS(0x71, 0x02, 0x4C, 0x00, 0xD8, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x3409, 0x3009, 0x2C09, 0xBD01, 0xBE01, 0xBF01),
  },
  {	.channel		= 178,
	.freq			= 5890, /* MHz */
	.unk2			= 3927,
	RADIOREGS(0x71, 0x02, 0x4D, 0x00, 0xD6, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x3809, 0x3409, 0x3009, 0xBC01, 0xBD01, 0xBE01),
  },
  {	.channel		= 180,
	.freq			= 5900, /* MHz */
	.unk2			= 3933,
	RADIOREGS(0x71, 0x02, 0x4E, 0x00, 0xD3, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x3C09, 0x3809, 0x3409, 0xBC01, 0xBC01, 0xBD01),
  },
  {	.channel		= 182,
	.freq			= 5910, /* MHz */
	.unk2			= 3940,
	RADIOREGS(0x71, 0x02, 0x4F, 0x00, 0xD6, 0x00, 0x04, 0x0A,
		  0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x80, 0x00, 0x00, 0x00, 0x00, 0x80),
	PHYREGS(0x4009, 0x3C09, 0x3809, 0xBB01, 0xBC01, 0xBC01),
  },
  {	.channel		= 1,
	.freq			= 2412, /* MHz */
	.unk2			= 3216,
	RADIOREGS(0x73, 0x09, 0x6C, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0D, 0x0C,
		  0x80, 0xFF, 0x88, 0x0D, 0x0C, 0x80),
	PHYREGS(0xC903, 0xC503, 0xC103, 0x3A04, 0x3F04, 0x4304),
  },
  {	.channel		= 2,
	.freq			= 2417, /* MHz */
	.unk2			= 3223,
	RADIOREGS(0x73, 0x09, 0x71, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0C, 0x0B,
		  0x80, 0xFF, 0x88, 0x0C, 0x0B, 0x80),
	PHYREGS(0xCB03, 0xC703, 0xC303, 0x3804, 0x3D04, 0x4104),
  },
  {	.channel		= 3,
	.freq			= 2422, /* MHz */
	.unk2			= 3229,
	RADIOREGS(0x73, 0x09, 0x76, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0C, 0x0A,
		  0x80, 0xFF, 0x88, 0x0C, 0x0A, 0x80),
	PHYREGS(0xCD03, 0xC903, 0xC503, 0x3604, 0x3A04, 0x3F04),
  },
  {	.channel		= 4,
	.freq			= 2427, /* MHz */
	.unk2			= 3236,
	RADIOREGS(0x73, 0x09, 0x7B, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0C, 0x0A,
		  0x80, 0xFF, 0x88, 0x0C, 0x0A, 0x80),
	PHYREGS(0xCF03, 0xCB03, 0xC703, 0x3404, 0x3804, 0x3D04),
  },
  {	.channel		= 5,
	.freq			= 2432, /* MHz */
	.unk2			= 3243,
	RADIOREGS(0x73, 0x09, 0x80, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0C, 0x09,
		  0x80, 0xFF, 0x88, 0x0C, 0x09, 0x80),
	PHYREGS(0xD103, 0xCD03, 0xC903, 0x3104, 0x3604, 0x3A04),
  },
  {	.channel		= 6,
	.freq			= 2437, /* MHz */
	.unk2			= 3249,
	RADIOREGS(0x73, 0x09, 0x85, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0B, 0x08,
		  0x80, 0xFF, 0x88, 0x0B, 0x08, 0x80),
	PHYREGS(0xD303, 0xCF03, 0xCB03, 0x2F04, 0x3404, 0x3804),
  },
  {	.channel		= 7,
	.freq			= 2442, /* MHz */
	.unk2			= 3256,
	RADIOREGS(0x73, 0x09, 0x8A, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0A, 0x07,
		  0x80, 0xFF, 0x88, 0x0A, 0x07, 0x80),
	PHYREGS(0xD503, 0xD103, 0xCD03, 0x2D04, 0x3104, 0x3604),
  },
  {	.channel		= 8,
	.freq			= 2447, /* MHz */
	.unk2			= 3263,
	RADIOREGS(0x73, 0x09, 0x8F, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x0A, 0x06,
		  0x80, 0xFF, 0x88, 0x0A, 0x06, 0x80),
	PHYREGS(0xD703, 0xD303, 0xCF03, 0x2B04, 0x2F04, 0x3404),
  },
  {	.channel		= 9,
	.freq			= 2452, /* MHz */
	.unk2			= 3269,
	RADIOREGS(0x73, 0x09, 0x94, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x09, 0x06,
		  0x80, 0xFF, 0x88, 0x09, 0x06, 0x80),
	PHYREGS(0xD903, 0xD503, 0xD103, 0x2904, 0x2D04, 0x3104),
  },
  {	.channel		= 10,
	.freq			= 2457, /* MHz */
	.unk2			= 3276,
	RADIOREGS(0x73, 0x09, 0x99, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x08, 0x05,
		  0x80, 0xFF, 0x88, 0x08, 0x05, 0x80),
	PHYREGS(0xDB03, 0xD703, 0xD303, 0x2704, 0x2B04, 0x2F04),
  },
  {	.channel		= 11,
	.freq			= 2462, /* MHz */
	.unk2			= 3283,
	RADIOREGS(0x73, 0x09, 0x9E, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x08, 0x04,
		  0x80, 0xFF, 0x88, 0x08, 0x04, 0x80),
	PHYREGS(0xDD03, 0xD903, 0xD503, 0x2404, 0x2904, 0x2D04),
  },
  {	.channel		= 12,
	.freq			= 2467, /* MHz */
	.unk2			= 3289,
	RADIOREGS(0x73, 0x09, 0xA3, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x08, 0x03,
		  0x80, 0xFF, 0x88, 0x08, 0x03, 0x80),
	PHYREGS(0xDF03, 0xDB03, 0xD703, 0x2204, 0x2704, 0x2B04),
  },
  {	.channel		= 13,
	.freq			= 2472, /* MHz */
	.unk2			= 3296,
	RADIOREGS(0x73, 0x09, 0xA8, 0x0F, 0x00, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x07, 0x03,
		  0x80, 0xFF, 0x88, 0x07, 0x03, 0x80),
	PHYREGS(0xE103, 0xDD03, 0xD903, 0x2004, 0x2404, 0x2904),
  },
  {	.channel		= 14,
	.freq			= 2484, /* MHz */
	.unk2			= 3312,
	RADIOREGS(0x73, 0x09, 0xB4, 0x0F, 0xFF, 0x01, 0x07, 0x15,
		  0x01, 0x8F, 0xFF, 0xFF, 0xFF, 0x88, 0x07, 0x01,
		  0x80, 0xFF, 0x88, 0x07, 0x01, 0x80),
	PHYREGS(0xE603, 0xE203, 0xDE03, 0x1B04, 0x1F04, 0x2404),
  },
};

void b2055_upload_inittab(struct b43_wldev *dev,
			  bool ghz5, bool ignore_uploadflag)
{
	const struct b2055_inittab_entry *e;
	unsigned int i, writes = 0;
	u16 value;

	for (i = 0; i < ARRAY_SIZE(b2055_inittab); i++) {
		e = &(b2055_inittab[i]);
		if (!(e->flags & B2055_INITTAB_ENTRY_OK))
			continue;
		if ((e->flags & B2055_INITTAB_UPLOAD) || ignore_uploadflag) {
			if (ghz5)
				value = e->ghz5;
			else
				value = e->ghz2;
			b43_radio_write16(dev, i, value);
			if (++writes % 4 == 0)
				b43_read32(dev, B43_MMIO_MACCTL); /* flush */
		}
	}
}

const struct b43_nphy_channeltab_entry_rev2 *
b43_nphy_get_chantabent_rev2(struct b43_wldev *dev, u8 channel)
{
	const struct b43_nphy_channeltab_entry_rev2 *e;
	unsigned int i;

	for (i = 0; i < ARRAY_SIZE(b43_nphy_channeltab_rev2); i++) {
		e = &(b43_nphy_channeltab_rev2[i]);
		if (e->channel == channel)
			return e;
	}

	return NULL;
}
