/* linux/arch/arm/plat-s5pc1xx/include/plat/regs-gpio.h
 *
 * Copyright 2009 Samsung Electronics Co.
 *      Byungho Min <bhmin@samsung.com>
 *
 * S5PC100 - GPIO register definitions
 */

#ifndef __ASM_MACH_S5PC100_REGS_GPIO_H
#define __ASM_MACH_S5PC100_REGS_GPIO_H __FILE__

#include <mach/map.h>

/* S5PC100 */
#define S5PC100_GPIO_BASE	S5PC1XX_VA_GPIO
#define S5PC100_GPA0_BASE	(S5PC100_GPIO_BASE + 0x0000)
#define S5PC100_GPA1_BASE	(S5PC100_GPIO_BASE + 0x0020)
#define S5PC100_GPB_BASE	(S5PC100_GPIO_BASE + 0x0040)
#define S5PC100_GPC_BASE	(S5PC100_GPIO_BASE + 0x0060)
#define S5PC100_GPD_BASE	(S5PC100_GPIO_BASE + 0x0080)
#define S5PC100_GPE0_BASE	(S5PC100_GPIO_BASE + 0x00A0)
#define S5PC100_GPE1_BASE	(S5PC100_GPIO_BASE + 0x00C0)
#define S5PC100_GPF0_BASE	(S5PC100_GPIO_BASE + 0x00E0)
#define S5PC100_GPF1_BASE	(S5PC100_GPIO_BASE + 0x0100)
#define S5PC100_GPF2_BASE	(S5PC100_GPIO_BASE + 0x0120)
#define S5PC100_GPF3_BASE	(S5PC100_GPIO_BASE + 0x0140)
#define S5PC100_GPG0_BASE	(S5PC100_GPIO_BASE + 0x0160)
#define S5PC100_GPG1_BASE	(S5PC100_GPIO_BASE + 0x0180)
#define S5PC100_GPG2_BASE	(S5PC100_GPIO_BASE + 0x01A0)
#define S5PC100_GPG3_BASE	(S5PC100_GPIO_BASE + 0x01C0)
#define S5PC100_GPH0_BASE	(S5PC100_GPIO_BASE + 0x0C00)
#define S5PC100_GPH1_BASE	(S5PC100_GPIO_BASE + 0x0C20)
#define S5PC100_GPH2_BASE	(S5PC100_GPIO_BASE + 0x0C40)
#define S5PC100_GPH3_BASE	(S5PC100_GPIO_BASE + 0x0C60)
#define S5PC100_GPI_BASE	(S5PC100_GPIO_BASE + 0x01E0)
#define S5PC100_GPJ0_BASE	(S5PC100_GPIO_BASE + 0x0200)
#define S5PC100_GPJ1_BASE	(S5PC100_GPIO_BASE + 0x0220)
#define S5PC100_GPJ2_BASE	(S5PC100_GPIO_BASE + 0x0240)
#define S5PC100_GPJ3_BASE	(S5PC100_GPIO_BASE + 0x0260)
#define S5PC100_GPJ4_BASE	(S5PC100_GPIO_BASE + 0x0280)
#define S5PC100_GPK0_BASE	(S5PC100_GPIO_BASE + 0x02A0)
#define S5PC100_GPK1_BASE	(S5PC100_GPIO_BASE + 0x02C0)
#define S5PC100_GPK2_BASE	(S5PC100_GPIO_BASE + 0x02E0)
#define S5PC100_GPK3_BASE	(S5PC100_GPIO_BASE + 0x0300)
#define S5PC100_GPL0_BASE	(S5PC100_GPIO_BASE + 0x0320)
#define S5PC100_GPL1_BASE	(S5PC100_GPIO_BASE + 0x0340)
#define S5PC100_GPL2_BASE	(S5PC100_GPIO_BASE + 0x0360)
#define S5PC100_GPL3_BASE	(S5PC100_GPIO_BASE + 0x0380)
#define S5PC100_GPL4_BASE	(S5PC100_GPIO_BASE + 0x03A0)
#define S5PC100_EINT_BASE	(S5PC100_GPIO_BASE + 0x0E00)

#define S5PC100_UHOST		(S5PC100_GPIO_BASE + 0x0B68)
#define S5PC100_PDNEN		(S5PC100_GPIO_BASE + 0x0F80)

/* PDNEN */
#define S5PC100_PDNEN_CFG_PDNEN	(1 << 1)
#define S5PC100_PDNEN_CFG_AUTO	(0 << 1)
#define S5PC100_PDNEN_POWERDOWN	(1 << 0)
#define S5PC100_PDNEN_NORMAL	(0 << 0)

/* Common part */
/* External interrupt base is same at both s5pc100 and s5pc110 */
#define S5PC1XX_EINT_BASE	(S5PC100_EINT_BASE)

#define S5PC100_GPx_INPUT(__gpio)	(0x0 << ((__gpio) * 4))
#define S5PC100_GPx_OUTPUT(__gpio)	(0x1 << ((__gpio) * 4))
#define S5PC100_GPx_CONMASK(__gpio)	(0xf << ((__gpio) * 4))

#endif /* __ASM_MACH_S5PC100_REGS_GPIO_H */

